import numpy
from numpy import array, nan, inf


# routines are same as v1.6.1 except for the sy/heevd routines
from v161_cuda70_k40c import *


version = '1.6.2'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v1.6.2/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ./testing_cheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
cheevd_JN = array([
	[   10,  nan,   0.0000 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0001 ],
	[   50,  nan,   0.0002 ],
	[   60,  nan,   0.0003 ],
	[   70,  nan,   0.0005 ],
	[   80,  nan,   0.0007 ],
	[   90,  nan,   0.0009 ],
	[  100,  nan,   0.0011 ],
	[  200,  nan,   0.0046 ],
	[  300,  nan,   0.0091 ],
	[  400,  nan,   0.0152 ],
	[  500,  nan,   0.0232 ],
	[  600,  nan,   0.0321 ],
	[  700,  nan,   0.0445 ],
	[  800,  nan,   0.0568 ],
	[  900,  nan,   0.0724 ],
	[ 1000,  nan,   0.0906 ],
	[ 2000,  nan,   0.4281 ],
	[ 3000,  nan,   1.2820 ],
	[ 4000,  nan,   2.3214 ],
	[ 5000,  nan,   3.7832 ],
	[ 6000,  nan,   5.6411 ],
	[ 7000,  nan,   8.1428 ],
	[ 8000,  nan,  11.0746 ],
	[ 9000,  nan,  14.8746 ],
])

# numactl --interleave=all ./testing_cheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
cheevd_JV = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0002 ],
	[   40,  nan,   0.0004 ],
	[   50,  nan,   0.0005 ],
	[   60,  nan,   0.0007 ],
	[   70,  nan,   0.0010 ],
	[   80,  nan,   0.0012 ],
	[   90,  nan,   0.0015 ],
	[  100,  nan,   0.0018 ],
	[  200,  nan,   0.0088 ],
	[  300,  nan,   0.0141 ],
	[  400,  nan,   0.0231 ],
	[  500,  nan,   0.0335 ],
	[  600,  nan,   0.0433 ],
	[  700,  nan,   0.0581 ],
	[  800,  nan,   0.0745 ],
	[  900,  nan,   0.1033 ],
	[ 1000,  nan,   0.1187 ],
	[ 2000,  nan,   0.5184 ],
	[ 3000,  nan,   1.4990 ],
	[ 4000,  nan,   2.7271 ],
	[ 5000,  nan,   4.3927 ],
	[ 6000,  nan,   6.6419 ],
	[ 7000,  nan,   9.5703 ],
	[ 8000,  nan,  13.1326 ],
	[ 9000,  nan,  17.1391 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
cheevd_gpu_JN = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0002 ],
	[   50,  nan,   0.0002 ],
	[   60,  nan,   0.0003 ],
	[   70,  nan,   0.0006 ],
	[   80,  nan,   0.0007 ],
	[   90,  nan,   0.0010 ],
	[  100,  nan,   0.0014 ],
	[  200,  nan,   0.0110 ],
	[  300,  nan,   0.0205 ],
	[  400,  nan,   0.0358 ],
	[  500,  nan,   0.0501 ],
	[  600,  nan,   0.0692 ],
	[  700,  nan,   0.0891 ],
	[  800,  nan,   0.1138 ],
	[  900,  nan,   0.1403 ],
	[ 1000,  nan,   0.1674 ],
	[ 2000,  nan,   0.5743 ],
	[ 3000,  nan,   1.2913 ],
	[ 4000,  nan,   2.3674 ],
	[ 5000,  nan,   3.8625 ],
	[ 6000,  nan,   5.6197 ],
	[ 7000,  nan,   8.0877 ],
	[ 8000,  nan,  11.0239 ],
	[ 9000,  nan,  14.7748 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
cheevd_gpu_JV = array([
	[   10,  nan,   0.0002 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0003 ],
	[   40,  nan,   0.0004 ],
	[   50,  nan,   0.0005 ],
	[   60,  nan,   0.0007 ],
	[   70,  nan,   0.0010 ],
	[   80,  nan,   0.0013 ],
	[   90,  nan,   0.0016 ],
	[  100,  nan,   0.0020 ],
	[  200,  nan,   0.0148 ],
	[  300,  nan,   0.0254 ],
	[  400,  nan,   0.0426 ],
	[  500,  nan,   0.0588 ],
	[  600,  nan,   0.0785 ],
	[  700,  nan,   0.0998 ],
	[  800,  nan,   0.1296 ],
	[  900,  nan,   0.1571 ],
	[ 1000,  nan,   0.1865 ],
	[ 2000,  nan,   0.6367 ],
	[ 3000,  nan,   1.4485 ],
	[ 4000,  nan,   2.5915 ],
	[ 5000,  nan,   4.2487 ],
	[ 6000,  nan,   6.4947 ],
	[ 7000,  nan,   9.3415 ],
	[ 8000,  nan,  12.9641 ],
	[ 9000,  nan,  17.4105 ],
])

# ------------------------------------------------------------
# file: v1.6.2/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ./testing_dsyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
dsyevd_JN = array([
	[   10,  nan,   0.0000 ],
	[   20,  nan,   0.0000 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0001 ],
	[   50,  nan,   0.0002 ],
	[   60,  nan,   0.0003 ],
	[   70,  nan,   0.0004 ],
	[   80,  nan,   0.0005 ],
	[   90,  nan,   0.0007 ],
	[  100,  nan,   0.0009 ],
	[  200,  nan,   0.0046 ],
	[  300,  nan,   0.0093 ],
	[  400,  nan,   0.0157 ],
	[  500,  nan,   0.0239 ],
	[  600,  nan,   0.0331 ],
	[  700,  nan,   0.0444 ],
	[  800,  nan,   0.0578 ],
	[  900,  nan,   0.0732 ],
	[ 1000,  nan,   0.0910 ],
	[ 2000,  nan,   0.3946 ],
	[ 3000,  nan,   1.3086 ],
	[ 4000,  nan,   2.3535 ],
	[ 5000,  nan,   3.8218 ],
	[ 6000,  nan,   5.7008 ],
	[ 7000,  nan,   8.1357 ],
	[ 8000,  nan,  11.0823 ],
	[ 9000,  nan,  14.8139 ],
])

# numactl --interleave=all ./testing_dsyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
dsyevd_JV = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0003 ],
	[   40,  nan,   0.0005 ],
	[   50,  nan,   0.0007 ],
	[   60,  nan,   0.0008 ],
	[   70,  nan,   0.0010 ],
	[   80,  nan,   0.0013 ],
	[   90,  nan,   0.0017 ],
	[  100,  nan,   0.0022 ],
	[  200,  nan,   0.0109 ],
	[  300,  nan,   0.0176 ],
	[  400,  nan,   0.0276 ],
	[  500,  nan,   0.0415 ],
	[  600,  nan,   0.0485 ],
	[  700,  nan,   0.0632 ],
	[  800,  nan,   0.0807 ],
	[  900,  nan,   0.1036 ],
	[ 1000,  nan,   0.1245 ],
	[ 2000,  nan,   0.4801 ],
	[ 3000,  nan,   1.3453 ],
	[ 4000,  nan,   2.3808 ],
	[ 5000,  nan,   4.0590 ],
	[ 6000,  nan,   5.9509 ],
	[ 7000,  nan,   8.5131 ],
	[ 8000,  nan,  11.6961 ],
	[ 9000,  nan,  15.5623 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
dsyevd_gpu_JN = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0002 ],
	[   50,  nan,   0.0002 ],
	[   60,  nan,   0.0004 ],
	[   70,  nan,   0.0004 ],
	[   80,  nan,   0.0006 ],
	[   90,  nan,   0.0008 ],
	[  100,  nan,   0.0011 ],
	[  200,  nan,   0.0113 ],
	[  300,  nan,   0.0209 ],
	[  400,  nan,   0.0355 ],
	[  500,  nan,   0.0500 ],
	[  600,  nan,   0.0696 ],
	[  700,  nan,   0.0891 ],
	[  800,  nan,   0.1209 ],
	[  900,  nan,   0.1484 ],
	[ 1000,  nan,   0.1760 ],
	[ 2000,  nan,   0.6013 ],
	[ 3000,  nan,   1.3152 ],
	[ 4000,  nan,   2.3344 ],
	[ 5000,  nan,   3.7911 ],
	[ 6000,  nan,   5.6472 ],
	[ 7000,  nan,   8.2819 ],
	[ 8000,  nan,  10.9944 ],
	[ 9000,  nan,  14.6560 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
dsyevd_gpu_JV = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0004 ],
	[   40,  nan,   0.0005 ],
	[   50,  nan,   0.0006 ],
	[   60,  nan,   0.0009 ],
	[   70,  nan,   0.0011 ],
	[   80,  nan,   0.0014 ],
	[   90,  nan,   0.0019 ],
	[  100,  nan,   0.0022 ],
	[  200,  nan,   0.0175 ],
	[  300,  nan,   0.0291 ],
	[  400,  nan,   0.0479 ],
	[  500,  nan,   0.0656 ],
	[  600,  nan,   0.0826 ],
	[  700,  nan,   0.1048 ],
	[  800,  nan,   0.1317 ],
	[  900,  nan,   0.1548 ],
	[ 1000,  nan,   0.1819 ],
	[ 2000,  nan,   0.6203 ],
	[ 3000,  nan,   1.3923 ],
	[ 4000,  nan,   2.5416 ],
	[ 5000,  nan,   4.2772 ],
	[ 6000,  nan,   6.3248 ],
	[ 7000,  nan,   9.2650 ],
	[ 8000,  nan,  12.2612 ],
	[ 9000,  nan,  16.3899 ],
])

# ------------------------------------------------------------
# file: v1.6.2/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ./testing_ssyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JN = array([
	[    10,  nan,   0.0000 ],
	[    20,  nan,   0.0000 ],
	[    30,  nan,   0.0001 ],
	[    40,  nan,   0.0001 ],
	[    50,  nan,   0.0001 ],
	[    60,  nan,   0.0002 ],
	[    70,  nan,   0.0003 ],
	[    80,  nan,   0.0003 ],
	[    90,  nan,   0.0004 ],
	[   100,  nan,   0.0005 ],
	[   200,  nan,   0.0032 ],
	[   300,  nan,   0.0063 ],
	[   400,  nan,   0.0107 ],
	[   500,  nan,   0.0168 ],
	[   600,  nan,   0.0215 ],
	[   700,  nan,   0.0279 ],
	[   800,  nan,   0.0357 ],
	[   900,  nan,   0.0447 ],
	[  1000,  nan,   0.0546 ],
	[  2000,  nan,   0.2282 ],
	[  3000,  nan,   0.8892 ],
	[  4000,  nan,   1.5411 ],
	[  5000,  nan,   2.4856 ],
	[  6000,  nan,   4.0524 ],
	[  7000,  nan,   5.3686 ],
	[  8000,  nan,   7.1975 ],
	[  9000,  nan,   9.4643 ],
	[ 10000,  nan,  12.1726 ],
	[ 12000,  nan,  19.3079 ],
	[ 14000,  nan,  28.1323 ],
	[ 16000,  nan,  40.6615 ],
	[ 18000,  nan,  55.4339 ],
	[ 20000,  nan,  71.7824 ],
])

# numactl --interleave=all ./testing_ssyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JV = array([
	[   10,  nan,  0.0001 ],
	[   20,  nan,  0.0001 ],
	[   30,  nan,  0.0002 ],
	[   40,  nan,  0.0003 ],
	[   50,  nan,  0.0004 ],
	[   60,  nan,  0.0005 ],
	[   70,  nan,  0.0006 ],
	[   80,  nan,  0.0007 ],
	[   90,  nan,  0.0009 ],
	[  100,  nan,  0.0010 ],
	[  200,  nan,  0.0070 ],
	[  300,  nan,  0.0106 ],
	[  400,  nan,  0.0168 ],
	[  500,  nan,  0.0248 ],
	[  600,  nan,  0.0285 ],
	[  700,  nan,  0.0367 ],
	[  800,  nan,  0.0455 ],
	[  900,  nan,  0.0576 ],
	[ 1000,  nan,  0.0673 ],
	[ 2000,  nan,  0.2710 ],
	[ 3000,  nan,  0.9194 ],
])

# numactl --interleave=all ./testing_ssyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
ssyevd_JN = array([
	[   10,  nan,  0.0000 ],
	[   20,  nan,  0.0000 ],
	[   30,  nan,  0.0001 ],
	[   40,  nan,  0.0001 ],
	[   50,  nan,  0.0002 ],
	[   60,  nan,  0.0002 ],
	[   70,  nan,  0.0003 ],
	[   80,  nan,  0.0004 ],
	[   90,  nan,  0.0005 ],
	[  100,  nan,  0.0006 ],
	[  200,  nan,  0.0036 ],
	[  300,  nan,  0.0069 ],
	[  400,  nan,  0.0113 ],
	[  500,  nan,  0.0174 ],
	[  600,  nan,  0.0231 ],
	[  700,  nan,  0.0309 ],
	[  800,  nan,  0.0396 ],
	[  900,  nan,  0.0533 ],
	[ 1000,  nan,  0.0606 ],
	[ 2000,  nan,  0.2523 ],
	[ 3000,  nan,  0.9090 ],
	[ 4000,  nan,  1.5965 ],
	[ 5000,  nan,  2.5789 ],
	[ 6000,  nan,  3.7544 ],
	[ 7000,  nan,  5.3782 ],
	[ 8000,  nan,  7.2381 ],
	[ 9000,  nan,  9.5919 ],
])

# numactl --interleave=all ./testing_ssyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
ssyevd_JV = array([
	[   10,  nan,  0.0001 ],
	[   20,  nan,  0.0001 ],
	[   30,  nan,  0.0002 ],
	[   40,  nan,  0.0003 ],
	[   50,  nan,  0.0003 ],
	[   60,  nan,  0.0005 ],
	[   70,  nan,  0.0006 ],
	[   80,  nan,  0.0007 ],
	[   90,  nan,  0.0009 ],
	[  100,  nan,  0.0011 ],
	[  200,  nan,  0.0072 ],
	[  300,  nan,  0.0111 ],
	[  400,  nan,  0.0171 ],
	[  500,  nan,  0.0391 ],
	[  600,  nan,  0.0294 ],
	[  700,  nan,  0.0378 ],
	[  800,  nan,  0.0472 ],
	[  900,  nan,  0.0591 ],
	[ 1000,  nan,  0.0679 ],
	[ 2000,  nan,  0.2484 ],
	[ 3000,  nan,  0.9114 ],
	[ 4000,  nan,  1.5739 ],
	[ 5000,  nan,  2.5379 ],
	[ 6000,  nan,  3.8574 ],
	[ 7000,  nan,  5.5671 ],
	[ 8000,  nan,  7.3919 ],
	[ 9000,  nan,  9.7177 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
ssyevd_gpu_JN = array([
	[   10,  nan,  0.0001 ],
	[   20,  nan,  0.0001 ],
	[   30,  nan,  0.0001 ],
	[   40,  nan,  0.0001 ],
	[   50,  nan,  0.0002 ],
	[   60,  nan,  0.0002 ],
	[   70,  nan,  0.0003 ],
	[   80,  nan,  0.0004 ],
	[   90,  nan,  0.0005 ],
	[  100,  nan,  0.0006 ],
	[  200,  nan,  0.0090 ],
	[  300,  nan,  0.0164 ],
	[  400,  nan,  0.0281 ],
	[  500,  nan,  0.0389 ],
	[  600,  nan,  0.0532 ],
	[  700,  nan,  0.0670 ],
	[  800,  nan,  0.0850 ],
	[  900,  nan,  0.1069 ],
	[ 1000,  nan,  0.1240 ],
	[ 2000,  nan,  0.4499 ],
	[ 3000,  nan,  0.9240 ],
	[ 4000,  nan,  1.6000 ],
	[ 5000,  nan,  2.5353 ],
	[ 6000,  nan,  3.7759 ],
	[ 7000,  nan,  5.3275 ],
	[ 8000,  nan,  7.5790 ],
	[ 9000,  nan,  9.4562 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
ssyevd_gpu_JV = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0002 ],
	[   40,  nan,   0.0003 ],
	[   50,  nan,   0.0004 ],
	[   60,  nan,   0.0005 ],
	[   70,  nan,   0.0007 ],
	[   80,  nan,   0.0008 ],
	[   90,  nan,   0.0010 ],
	[  100,  nan,   0.0011 ],
	[  200,  nan,   0.0124 ],
	[  300,  nan,   0.0205 ],
	[  400,  nan,   0.0348 ],
	[  500,  nan,   0.0471 ],
	[  600,  nan,   0.0606 ],
	[  700,  nan,   0.0753 ],
	[  800,  nan,   0.0948 ],
	[  900,  nan,   0.1190 ],
	[ 1000,  nan,   0.1374 ],
	[ 2000,  nan,   0.4669 ],
	[ 3000,  nan,   0.9294 ],
	[ 4000,  nan,   1.5760 ],
	[ 5000,  nan,   2.5580 ],
	[ 6000,  nan,   3.9266 ],
	[ 7000,  nan,   5.5895 ],
	[ 8000,  nan,   7.6636 ],
	[ 9000,  nan,  10.2211 ],
])

# ------------------------------------------------------------
# file: v1.6.2/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ./testing_zheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
zheevd_JN = array([
	[   10,  nan,   0.0000 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0002 ],
	[   50,  nan,   0.0003 ],
	[   60,  nan,   0.0004 ],
	[   70,  nan,   0.0007 ],
	[   80,  nan,   0.0009 ],
	[   90,  nan,   0.0012 ],
	[  100,  nan,   0.0016 ],
	[  200,  nan,   0.0068 ],
	[  300,  nan,   0.0140 ],
	[  400,  nan,   0.0242 ],
	[  500,  nan,   0.0382 ],
	[  600,  nan,   0.0544 ],
	[  700,  nan,   0.0755 ],
	[  800,  nan,   0.0993 ],
	[  900,  nan,   0.1279 ],
	[ 1000,  nan,   0.1640 ],
	[ 2000,  nan,   0.8174 ],
	[ 3000,  nan,   2.0327 ],
	[ 4000,  nan,   3.9137 ],
	[ 5000,  nan,   6.6486 ],
	[ 6000,  nan,  10.3163 ],
	[ 7000,  nan,  15.2289 ],
	[ 8000,  nan,  21.0563 ],
	[ 9000,  nan,  28.6325 ],
])

# numactl --interleave=all ./testing_zheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
zheevd_JV = array([
	[   10,  nan,   0.0002 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0003 ],
	[   40,  nan,   0.0005 ],
	[   50,  nan,   0.0007 ],
	[   60,  nan,   0.0009 ],
	[   70,  nan,   0.0013 ],
	[   80,  nan,   0.0017 ],
	[   90,  nan,   0.0022 ],
	[  100,  nan,   0.0026 ],
	[  200,  nan,   0.0121 ],
	[  300,  nan,   0.0199 ],
	[  400,  nan,   0.0317 ],
	[  500,  nan,   0.0485 ],
	[  600,  nan,   0.0701 ],
	[  700,  nan,   0.0835 ],
	[  800,  nan,   0.1082 ],
	[  900,  nan,   0.1410 ],
	[ 1000,  nan,   0.1723 ],
	[ 2000,  nan,   0.7492 ],
	[ 3000,  nan,   2.3133 ],
	[ 4000,  nan,   4.4831 ],
	[ 5000,  nan,   7.6648 ],
	[ 6000,  nan,  12.0563 ],
	[ 7000,  nan,  17.8659 ],
	[ 8000,  nan,  25.2895 ],
	[ 9000,  nan,  34.6548 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
zheevd_gpu_JN = array([
	[   10,  nan,   0.0001 ],
	[   20,  nan,   0.0001 ],
	[   30,  nan,   0.0001 ],
	[   40,  nan,   0.0002 ],
	[   50,  nan,   0.0003 ],
	[   60,  nan,   0.0005 ],
	[   70,  nan,   0.0008 ],
	[   80,  nan,   0.0010 ],
	[   90,  nan,   0.0014 ],
	[  100,  nan,   0.0017 ],
	[  200,  nan,   0.0148 ],
	[  300,  nan,   0.0275 ],
	[  400,  nan,   0.0469 ],
	[  500,  nan,   0.0671 ],
	[  600,  nan,   0.0942 ],
	[  700,  nan,   0.1215 ],
	[  800,  nan,   0.1555 ],
	[  900,  nan,   0.1922 ],
	[ 1000,  nan,   0.2297 ],
	[ 2000,  nan,   0.8257 ],
	[ 3000,  nan,   2.0287 ],
	[ 4000,  nan,   3.8918 ],
	[ 5000,  nan,   6.5700 ],
	[ 6000,  nan,  10.2343 ],
	[ 7000,  nan,  14.9908 ],
	[ 8000,  nan,  21.1643 ],
	[ 9000,  nan,  28.6322 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000
zheevd_gpu_JV = array([
	[   10,  nan,   0.0002 ],
	[   20,  nan,   0.0002 ],
	[   30,  nan,   0.0004 ],
	[   40,  nan,   0.0006 ],
	[   50,  nan,   0.0007 ],
	[   60,  nan,   0.0011 ],
	[   70,  nan,   0.0015 ],
	[   80,  nan,   0.0020 ],
	[   90,  nan,   0.0024 ],
	[  100,  nan,   0.0032 ],
	[  200,  nan,   0.0197 ],
	[  300,  nan,   0.0341 ],
	[  400,  nan,   0.0836 ],
	[  500,  nan,   0.0814 ],
	[  600,  nan,   0.1094 ],
	[  700,  nan,   0.1404 ],
	[  800,  nan,   0.1815 ],
	[  900,  nan,   0.2227 ],
	[ 1000,  nan,   0.2641 ],
	[ 2000,  nan,   0.9898 ],
	[ 3000,  nan,   2.4228 ],
	[ 4000,  nan,   4.6590 ],
	[ 5000,  nan,   7.9803 ],
	[ 6000,  nan,  12.0939 ],
	[ 7000,  nan,  18.0258 ],
	[ 8000,  nan,  25.5465 ],
	[ 9000,  nan,  35.5198 ],
])

