/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.Benchmark;
import com.google.caliper.model.Measurement;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

abstract class AllocationWorker
implements Worker {
    private int allocationCount;
    private long allocationSize;
    private boolean recordAllocations = false;

    protected AllocationWorker() {
        AllocationRecorder.addSampler((Sampler)new Sampler(){

            public void sampleAllocation(int arrayCount, String desc, Object newObj, long size) {
                if (AllocationWorker.this.recordAllocations) {
                    AllocationWorker.this.allocationCount++;
                    AllocationWorker.this.allocationSize += size;
                }
            }
        });
    }

    @Override
    public synchronized Collection<Measurement> measure(Benchmark benchmark, String methodName, Map<String, String> options, WorkerEventLog log) throws Exception {
        log.notifyWarmupPhaseStarting();
        this.measureAllocations(benchmark, methodName, 1);
        log.notifyMeasurementPhaseStarting();
        log.notifyMeasurementStarting();
        Measurement baseline = this.measureAllocations(benchmark, methodName, 1);
        log.notifyMeasurementEnding(baseline.value / baseline.weight);
        log.notifyMeasurementStarting();
        Measurement twoReps = this.measureAllocations(benchmark, methodName, 2);
        log.notifyMeasurementEnding(twoReps.value / twoReps.weight);
        Measurement diff = this.diffMeasurements(baseline, twoReps);
        return ImmutableSet.of((Object)diff);
    }

    private Measurement diffMeasurements(Measurement initial, Measurement second) {
        Measurement diff = new Measurement();
        diff.value = second.value - initial.value;
        diff.weight = second.weight - initial.weight;
        Preconditions.checkArgument((diff.weight > 0.0 ? 1 : 0) != 0);
        diff.unit = second.unit;
        diff.description = second.description;
        return diff;
    }

    private synchronized Measurement measureAllocations(Benchmark benchmark, String methodName, int reps) throws Exception {
        Method method = benchmark.getClass().getDeclaredMethod("time" + methodName, Integer.TYPE);
        this.clearAccumulatedStats();
        Object[] args = new Object[]{reps};
        this.recordAllocations = true;
        method.invoke((Object)benchmark, args);
        this.recordAllocations = false;
        return this.extractMeasurement(this.getAccumulatedStats(), reps);
    }

    private synchronized void clearAccumulatedStats() {
        this.recordAllocations = false;
        this.allocationCount = 0;
        this.allocationSize = 0L;
    }

    private synchronized AllocationStats getAccumulatedStats() {
        return new AllocationStats(this.allocationCount, this.allocationSize);
    }

    abstract Measurement extractMeasurement(AllocationStats var1, int var2);

    static class AllocationStats {
        final int allocationCount;
        final long allocationSize;

        AllocationStats(int allocationCount, long allocationSize) {
            this.allocationCount = allocationCount;
            this.allocationSize = allocationSize;
        }
    }
}

