
functor MLLrValsFun (structure Token: TOKEN
                              structure Ast: AST) = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Heavily modified from SML/NJ sources by sweeks@sweeks.com *)

(* ml.grm
 *
 * Copyright 1989,1992 by AT&T Bell Laboratories
 *)

type int = Int.t

fun reg (left, right) = Region.make {left = left, right = right}
fun error (reg, msg) = Control.error (reg, Layout.str msg, Layout.empty)

open Ast
structure Field = Record.Field
structure Srecord = SortedRecord

structure Type =
   struct
      open Type

      val tuple = Record o Srecord.tuple

      val unit = tuple (Vector.new0 ())

      fun arrow (t1, t2) = Con (Longtycon.arrow, Vector.new2 (t1, t2))
   end

structure DatBind =
   struct
      open DatBind

      fun make (dbs, withtypes, left, right) =
         makeRegion' (T {datatypes = dbs, withtypes = withtypes},
                      left, right)
   end

structure Pat =
   struct
      open Pat

      fun tuple ps =
         if 1 = Vector.length ps
            then node (Vector.sub (ps, 0))
         else Tuple ps

      val unit = tuple (Vector.new0 ())

      val bogus = unit

      fun makeAs (p1: t, p2: t): node =
         let
            fun err () =
               error (Pat.region p1, "must have variable to left in as pattern")
            fun fixopVar (p : t) =
               case node p of
                  FlatApp ps =>
                     if 1 = Vector.length ps
                        then (case node (Vector.sub (ps, 0)) of
                                 Var {fixop,name} =>
                                    (case Longvid.split name of
                                        ([], vid) =>
                                           SOME (fixop, Vid.toVar vid)
                                      | _ =>
                                           let
                                              val () = err ()
                                           in
                                              SOME (Fixop.None, Var.bogus)
                                           end)
                               | _ => NONE)
                     else NONE
                | _ => NONE
         in
            case fixopVar p1 of
               SOME (fixop, var) =>
                  Layered {fixop = fixop, var = var,
                           constraint = NONE,
                           pat = p2}
             | NONE =>
                  case node p1 of
                     Pat.Constraint (p, t) =>
                        (case fixopVar p of
                            SOME (fixop, var) =>
                               Layered {fixop = fixop, var = var,
                                        constraint = SOME t,
                                        pat = p2}
                          | _ => (err (); bogus))
                   | _ => (err (); bogus)
         end
   end

structure Exp =
   struct
      open Exp

      fun tuple es =
         if 1 = Vector.length es
            then node (Vector.sub (es, 0))
         else Record (Record.tuple es)

      val unit = tuple (Vector.new0 ())
   end

structure Dec =
   struct
      open Dec

      fun sequence (d1: t, d2: t): t =
         makeRegion (case (node d1, node d2) of
                        (SeqDec d1, SeqDec d2) => SeqDec (Vector.concat [d1, d2])
                      | (SeqDec d1, _) =>
                           SeqDec (Vector.concat [d1, Vector.new1 d2])
                      | (_, SeqDec d2) =>
                           SeqDec (Vector.concat [Vector.new1 d1, d2])
                      | _ => SeqDec (Vector.new2 (d1, d2)),
                     Region.append (region d1, region d2))
   end

structure Spec =
   struct
      open Spec

      (* Some of this mess is so that a sharing equation captures as
       * many specs as possible in its scope.
       *)
      fun seq (s: t, s': t): t =
         let
            fun reg s'' = makeRegion (s'', Region.append (region s, region s'))
         in
            case (node s, node s') of
               (Empty, _) => s'
             | (_, Empty) => s
             | (_, Seq (s1, s2)) => reg (Seq (seq (s, s1), s2))
             | (_, Sharing {spec, equations}) =>
                  reg (Sharing {spec = seq (s, spec), equations = equations})
             | _ => reg (Seq (s, s'))
         end

(*      val seq = Trace.trace2 ("Spec.seq", layout, layout, layout) seq *)
   end

fun consTopdec (d, dss) =
   case dss of
      [] => [[d]]
    | ds :: dss => (d :: ds) :: dss

type rule = Pat.t * Exp.t
type clause = {pats : Pat.t vector,
               resultType : Type.t option,
               body : Exp.t}
type clauses = clause vector
type eb = Con.t * EbRhs.t
type db = {tyvars: Tyvar.t vector,
           tycon: Tycon.t,
           cons: (Con.t * Type.t option) vector}

type strdesc = Strid.t * Sigexp.t

type wherespec = {tyvars: Tyvar.t vector,
                  longtycon: Longtycon.t,
                  ty: Type.t}

type typdesc =  {tyvars: Tyvar.t vector,
                 tycon: Tycon.t}

type valdesc = Var.t * Type.t

type exndesc = Con.t * Type.t option

type strbind = {name: Strid.t,
                def: Strexp.t,
                constraint: SigConst.t}

type sigbind = Sigid.t * Sigexp.t

type funbind = {name : Fctid.t,
                arg : FctArg.t,
                result : SigConst.t,
                body : Strexp.t}

type vb = {pat: Pat.t,
           exp: Exp.t}

type rvb = {pat: Pat.t,
            match: Match.t}

fun ensureNonqualified (ss: Symbol.t list, r: Region.t): Symbol.t * Region.t =
   case ss of
      [s] => (s, r)
    | _ => (error (r, "expected nonqualified id")
            ; (Symbol.bogus, r))

fun cons1 (x, (l, r, y)) = (x :: l, r, y)

fun augment (id, sigexp, (wherespecs, right, binds)) =
   (id, Sigexp.wheree (sigexp, Vector.fromList wherespecs,
                       Region.extendRight (Sigexp.region sigexp, right)))
   :: binds

fun 'a augment1 ((strexp: Strexp.t,
                  makesigconst: Sigexp.t -> SigConst.t,
                  sigexp: Sigexp.t),
                 (wherespecs: wherespec list,
                  right: SourcePos.t,
                  z: 'a)): Strexp.t * 'a =
   (Strexp.makeRegion
    (Strexp.Constrained
     (strexp, makesigconst (Sigexp.wheree
                            (sigexp, Vector.fromList wherespecs,
                             Region.extendRight (Sigexp.region sigexp, right)))),
     Region.extendRight (Strexp.region strexp, right)),
    z)

type 'a whereAnd = wherespec list * SourcePos.t * 'a list

  
end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\006\000\113\000\007\000\060\000\013\000\058\000\
\\039\000\112\000\040\000\111\000\043\000\110\000\047\000\109\000\
\\053\000\108\000\066\000\107\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\006\000\113\000\007\000\060\000\013\000\058\000\
\\039\000\112\000\040\000\111\000\043\000\110\000\047\000\109\000\
\\066\000\107\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\015\000\057\000\
\\024\000\055\000\029\000\053\000\033\000\050\000\034\000\049\000\
\\039\000\046\000\040\000\045\000\041\000\044\000\043\000\042\000\
\\047\000\040\000\050\000\037\000\052\000\151\000\065\000\031\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\076\000\023\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\015\000\057\000\
\\024\000\055\000\029\000\053\000\033\000\050\000\034\000\049\000\
\\039\000\046\000\040\000\045\000\041\000\044\000\043\000\042\000\
\\047\000\040\000\050\000\037\000\054\000\138\000\065\000\031\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\076\000\023\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\015\000\057\000\
\\024\000\055\000\029\000\053\000\033\000\050\000\034\000\049\000\
\\039\000\046\000\040\000\045\000\041\000\044\000\043\000\042\000\
\\047\000\040\000\050\000\037\000\065\000\031\000\069\000\030\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\076\000\023\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\039\000\112\000\
\\040\000\111\000\043\000\175\000\047\000\109\000\053\000\108\000\
\\066\000\107\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\039\000\112\000\
\\040\000\111\000\043\000\175\000\047\000\109\000\053\000\228\000\
\\066\000\107\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\039\000\112\000\
\\040\000\111\000\043\000\175\000\047\000\109\000\066\000\107\000\000\000\
\\001\000\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\076\000\000\000\
\\001\000\002\000\064\000\003\000\063\000\013\000\076\000\000\000\
\\001\000\002\000\064\000\003\000\063\000\013\000\076\000\020\000\241\000\000\000\
\\001\000\002\000\064\000\003\000\063\000\013\000\076\000\020\000\241\000\
\\051\000\240\000\000\000\
\\001\000\002\000\064\000\003\000\063\000\013\000\076\000\051\000\157\000\000\000\
\\001\000\002\000\064\000\003\000\063\000\013\000\076\000\051\000\042\001\000\000\
\\001\000\003\000\122\003\008\000\121\003\009\000\121\003\010\000\121\003\
\\011\000\121\003\012\000\121\003\013\000\122\003\014\000\121\003\
\\016\000\121\003\017\000\121\003\018\000\121\003\019\000\121\003\
\\021\000\121\003\022\000\121\003\023\000\121\003\024\000\121\003\
\\025\000\121\003\026\000\121\003\027\000\121\003\028\000\121\003\
\\030\000\121\003\031\000\121\003\032\000\121\003\035\000\121\003\
\\036\000\121\003\037\000\121\003\038\000\121\003\042\000\121\003\
\\044\000\121\003\045\000\121\003\046\000\121\003\048\000\121\003\
\\049\000\121\003\051\000\121\003\052\000\121\003\054\000\121\003\
\\055\000\121\003\056\000\121\003\058\000\121\003\060\000\121\003\
\\061\000\121\003\062\000\121\003\063\000\121\003\064\000\121\003\
\\067\000\121\003\068\000\121\003\000\000\
\\001\000\003\000\063\000\000\000\
\\001\000\003\000\063\000\006\000\113\000\039\000\206\000\043\000\205\000\000\000\
\\001\000\003\000\063\000\013\000\058\000\000\000\
\\001\000\003\000\063\000\013\000\058\000\024\000\055\000\000\000\
\\001\000\003\000\063\000\013\000\058\000\041\000\163\001\059\000\162\001\000\000\
\\001\000\003\000\063\000\013\000\058\000\047\000\117\001\000\000\
\\001\000\003\000\063\000\013\000\058\000\062\000\191\001\000\000\
\\001\000\003\000\063\000\013\000\076\000\000\000\
\\001\000\003\000\063\000\013\000\076\000\019\000\210\001\047\000\181\000\000\000\
\\001\000\003\000\063\000\013\000\076\000\024\000\075\000\000\000\
\\001\000\003\000\063\000\013\000\076\000\047\000\181\000\000\000\
\\001\000\003\000\063\000\013\000\076\000\057\000\077\001\000\000\
\\001\000\003\000\063\000\013\000\076\000\062\000\243\001\000\000\
\\001\000\003\000\063\000\013\000\035\001\000\000\
\\001\000\005\000\084\000\000\000\
\\001\000\005\000\084\000\013\000\086\000\000\000\
\\001\000\005\000\084\000\013\000\088\000\000\000\
\\001\000\006\000\113\000\000\000\
\\001\000\008\000\123\002\009\000\231\001\016\000\126\002\017\000\126\002\
\\019\000\123\002\022\000\123\002\023\000\123\002\026\000\123\002\
\\030\000\123\002\031\000\123\002\035\000\123\002\037\000\123\002\
\\038\000\123\002\042\000\123\002\044\000\123\002\048\000\123\002\
\\049\000\123\002\054\000\123\002\055\000\123\002\058\000\123\002\
\\060\000\123\002\062\000\123\002\063\000\123\002\064\000\235\001\000\000\
\\001\000\008\000\123\002\009\000\053\002\016\000\141\002\017\000\141\002\
\\019\000\123\002\022\000\123\002\023\000\123\002\026\000\123\002\
\\030\000\123\002\031\000\123\002\035\000\123\002\037\000\123\002\
\\038\000\123\002\042\000\123\002\044\000\123\002\048\000\123\002\
\\049\000\123\002\054\000\123\002\055\000\123\002\058\000\123\002\
\\060\000\123\002\062\000\123\002\063\000\123\002\064\000\235\001\000\000\
\\001\000\008\000\123\002\009\000\053\002\016\000\144\002\017\000\144\002\
\\019\000\123\002\022\000\123\002\023\000\123\002\026\000\123\002\
\\030\000\123\002\031\000\123\002\035\000\123\002\037\000\123\002\
\\038\000\123\002\042\000\123\002\044\000\123\002\048\000\123\002\
\\049\000\123\002\054\000\123\002\055\000\123\002\058\000\123\002\
\\060\000\123\002\062\000\123\002\063\000\123\002\064\000\235\001\000\000\
\\001\000\008\000\131\002\009\000\131\002\016\000\128\002\017\000\128\002\
\\019\000\131\002\022\000\131\002\023\000\131\002\026\000\131\002\
\\030\000\131\002\031\000\131\002\035\000\131\002\037\000\131\002\
\\038\000\131\002\042\000\131\002\044\000\131\002\048\000\131\002\
\\049\000\131\002\054\000\131\002\055\000\131\002\058\000\131\002\
\\060\000\131\002\062\000\131\002\063\000\131\002\000\000\
\\001\000\008\000\202\002\009\000\077\002\016\000\126\002\017\000\126\002\
\\019\000\202\002\023\000\202\002\026\000\202\002\030\000\202\002\
\\031\000\202\002\037\000\202\002\038\000\202\002\042\000\202\002\
\\044\000\202\002\048\000\202\002\049\000\202\002\055\000\202\002\
\\058\000\202\002\060\000\202\002\062\000\202\002\063\000\202\002\
\\064\000\080\002\000\000\
\\001\000\008\000\202\002\009\000\092\002\016\000\141\002\017\000\141\002\
\\019\000\202\002\023\000\202\002\026\000\202\002\030\000\202\002\
\\031\000\202\002\037\000\202\002\038\000\202\002\042\000\202\002\
\\044\000\202\002\048\000\202\002\049\000\202\002\055\000\202\002\
\\058\000\202\002\060\000\202\002\062\000\202\002\063\000\202\002\
\\064\000\080\002\000\000\
\\001\000\008\000\202\002\009\000\092\002\016\000\144\002\017\000\144\002\
\\019\000\202\002\023\000\202\002\026\000\202\002\030\000\202\002\
\\031\000\202\002\037\000\202\002\038\000\202\002\042\000\202\002\
\\044\000\202\002\048\000\202\002\049\000\202\002\055\000\202\002\
\\058\000\202\002\060\000\202\002\062\000\202\002\063\000\202\002\
\\064\000\080\002\000\000\
\\001\000\010\000\081\000\016\000\080\000\018\000\255\000\032\000\079\000\
\\045\000\078\000\055\000\254\000\000\000\
\\001\000\010\000\081\000\016\000\080\000\021\000\176\001\032\000\079\000\
\\045\000\078\000\000\000\
\\001\000\010\000\081\000\016\000\080\000\022\000\174\001\032\000\079\000\
\\045\000\078\000\055\000\254\000\000\000\
\\001\000\010\000\081\000\016\000\080\000\027\000\220\000\032\000\079\000\
\\045\000\078\000\000\000\
\\001\000\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\
\\046\000\031\001\000\000\
\\001\000\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\
\\055\000\077\000\000\000\
\\001\000\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\
\\061\000\012\001\000\000\
\\001\000\011\000\036\001\012\000\247\001\000\000\
\\001\000\011\000\036\001\018\000\131\001\054\000\130\001\000\000\
\\001\000\011\000\036\001\024\000\143\001\000\000\
\\001\000\011\000\036\001\055\000\135\001\000\000\
\\001\000\011\000\036\001\055\000\137\001\000\000\
\\001\000\011\000\036\001\055\000\141\001\000\000\
\\001\000\011\000\036\001\055\000\142\001\000\000\
\\001\000\011\000\036\001\055\000\144\001\000\000\
\\001\000\011\000\036\001\055\000\217\001\000\000\
\\001\000\011\000\036\001\055\000\218\001\000\000\
\\001\000\011\000\036\001\055\000\219\001\000\000\
\\001\000\011\000\036\001\055\000\220\001\000\000\
\\001\000\012\000\157\003\016\000\157\003\018\000\157\003\024\000\164\003\
\\051\000\157\003\000\000\
\\001\000\012\000\224\000\016\000\223\000\024\000\222\000\000\000\
\\001\000\012\000\224\000\016\000\223\000\024\000\059\001\000\000\
\\001\000\012\000\224\000\016\000\223\000\028\000\020\001\000\000\
\\001\000\016\000\208\000\000\000\
\\001\000\016\000\211\000\000\000\
\\001\000\016\000\216\000\000\000\
\\001\000\016\000\217\000\000\000\
\\001\000\016\000\218\000\000\000\
\\001\000\016\000\219\000\000\000\
\\001\000\016\000\044\001\000\000\
\\001\000\016\000\048\001\000\000\
\\001\000\016\000\049\001\000\000\
\\001\000\016\000\050\001\000\000\
\\001\000\016\000\080\001\000\000\
\\001\000\016\000\134\001\000\000\
\\001\000\016\000\177\001\000\000\
\\001\000\016\000\237\001\017\000\236\001\000\000\
\\001\000\016\000\237\001\017\000\236\001\022\000\070\002\000\000\
\\001\000\016\000\237\001\017\000\236\001\054\000\054\002\000\000\
\\001\000\016\000\252\001\000\000\
\\001\000\016\000\000\002\000\000\
\\001\000\022\000\172\001\000\000\
\\001\000\022\000\173\001\000\000\
\\001\000\022\000\211\001\000\000\
\\001\000\022\000\244\001\000\000\
\\001\000\022\000\248\001\000\000\
\\001\000\022\000\025\002\000\000\
\\001\000\023\000\000\000\000\000\
\\001\000\024\000\247\000\000\000\
\\001\000\024\000\009\001\000\000\
\\001\000\024\000\070\001\000\000\
\\001\000\024\000\071\001\000\000\
\\001\000\024\000\072\001\000\000\
\\001\000\024\000\110\001\000\000\
\\001\000\024\000\119\001\000\000\
\\001\000\024\000\123\001\000\000\
\\001\000\024\000\001\002\000\000\
\\001\000\024\000\037\002\000\000\
\\001\000\024\000\044\002\000\000\
\\001\000\024\000\073\002\000\000\
\\001\000\029\000\147\001\000\000\
\\001\000\035\000\000\001\000\000\
\\001\000\035\000\003\001\000\000\
\\001\000\035\000\088\001\000\000\
\\001\000\035\000\026\002\000\000\
\\001\000\043\000\013\001\000\000\
\\001\000\051\000\010\001\000\000\
\\001\000\051\000\068\001\000\000\
\\001\000\051\000\132\001\000\000\
\\001\000\052\000\007\001\000\000\
\\001\000\052\000\066\001\000\000\
\\001\000\054\000\252\000\000\000\
\\001\000\054\000\253\000\000\000\
\\001\000\054\000\061\001\000\000\
\\001\000\054\000\063\001\000\000\
\\001\000\054\000\129\001\000\000\
\\001\000\054\000\179\001\000\000\
\\001\000\054\000\055\002\000\000\
\\001\000\055\000\013\002\000\000\
\\001\000\062\000\243\001\000\000\
\\001\000\067\000\033\001\000\000\
\\098\002\000\000\
\\099\002\000\000\
\\100\002\000\000\
\\101\002\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\008\000\059\000\013\000\058\000\
\\015\000\057\000\019\000\056\000\024\000\055\000\026\000\054\000\
\\029\000\053\000\030\000\052\000\031\000\051\000\033\000\050\000\
\\034\000\049\000\037\000\048\000\038\000\047\000\039\000\046\000\
\\040\000\045\000\041\000\044\000\042\000\043\000\043\000\042\000\
\\044\000\041\000\047\000\040\000\048\000\039\000\049\000\038\000\
\\050\000\037\000\055\000\036\000\058\000\035\000\060\000\034\000\
\\062\000\033\000\063\000\032\000\065\000\031\000\069\000\030\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\076\000\023\000\000\000\
\\101\002\008\000\059\000\019\000\056\000\026\000\054\000\030\000\052\000\
\\031\000\051\000\037\000\048\000\038\000\047\000\042\000\043\000\
\\044\000\041\000\048\000\039\000\049\000\038\000\055\000\036\000\
\\058\000\035\000\060\000\034\000\062\000\033\000\063\000\032\000\000\000\
\\102\002\000\000\
\\103\002\000\000\
\\104\002\000\000\
\\105\002\000\000\
\\106\002\000\000\
\\107\002\000\000\
\\108\002\000\000\
\\109\002\003\000\063\000\008\000\059\000\013\000\058\000\019\000\056\000\
\\026\000\054\000\030\000\052\000\037\000\048\000\038\000\047\000\
\\041\000\163\001\042\000\043\000\044\000\041\000\048\000\039\000\
\\049\000\038\000\055\000\142\000\059\000\162\001\060\000\034\000\
\\062\000\033\000\063\000\032\000\000\000\
\\109\002\008\000\059\000\019\000\056\000\026\000\054\000\030\000\052\000\
\\037\000\048\000\038\000\047\000\042\000\043\000\044\000\041\000\
\\048\000\039\000\049\000\038\000\055\000\142\000\060\000\034\000\
\\062\000\033\000\063\000\032\000\000\000\
\\110\002\000\000\
\\111\002\000\000\
\\112\002\000\000\
\\113\002\000\000\
\\114\002\000\000\
\\115\002\000\000\
\\116\002\000\000\
\\117\002\000\000\
\\118\002\000\000\
\\119\002\000\000\
\\120\002\000\000\
\\121\002\000\000\
\\122\002\000\000\
\\123\002\009\000\231\001\000\000\
\\124\002\000\000\
\\125\002\000\000\
\\126\002\064\000\166\001\000\000\
\\127\002\000\000\
\\128\002\000\000\
\\129\002\000\000\
\\130\002\000\000\
\\132\002\043\000\239\001\000\000\
\\133\002\000\000\
\\134\002\000\000\
\\135\002\000\000\
\\136\002\000\000\
\\137\002\000\000\
\\138\002\064\000\166\001\000\000\
\\139\002\000\000\
\\140\002\000\000\
\\141\002\009\000\029\002\064\000\166\001\000\000\
\\142\002\000\000\
\\143\002\000\000\
\\144\002\009\000\029\002\064\000\166\001\000\000\
\\145\002\000\000\
\\146\002\000\000\
\\147\002\000\000\
\\148\002\000\000\
\\149\002\000\000\
\\149\002\003\000\063\000\013\000\076\000\000\000\
\\150\002\000\000\
\\151\002\009\000\170\001\064\000\169\001\000\000\
\\151\002\009\000\033\002\064\000\169\001\000\000\
\\152\002\000\000\
\\153\002\000\000\
\\154\002\000\000\
\\155\002\000\000\
\\156\002\011\000\036\001\000\000\
\\157\002\016\000\246\000\017\000\245\000\000\000\
\\158\002\000\000\
\\159\002\000\000\
\\160\002\003\000\063\000\013\000\076\000\019\000\107\001\025\000\106\001\
\\026\000\105\001\036\000\104\001\055\000\103\001\056\000\102\001\
\\060\000\101\001\062\000\100\001\063\000\099\001\000\000\
\\160\002\019\000\107\001\025\000\106\001\026\000\105\001\036\000\104\001\
\\055\000\103\001\056\000\102\001\060\000\101\001\062\000\100\001\
\\063\000\099\001\000\000\
\\161\002\000\000\
\\162\002\000\000\
\\163\002\000\000\
\\164\002\000\000\
\\165\002\000\000\
\\166\002\000\000\
\\167\002\000\000\
\\168\002\000\000\
\\169\002\000\000\
\\170\002\000\000\
\\171\002\000\000\
\\172\002\000\000\
\\173\002\000\000\
\\174\002\000\000\
\\175\002\000\000\
\\176\002\024\000\001\002\000\000\
\\177\002\000\000\
\\178\002\024\000\044\002\000\000\
\\179\002\000\000\
\\180\002\000\000\
\\181\002\009\000\066\002\064\000\065\002\000\000\
\\181\002\009\000\089\002\064\000\065\002\000\000\
\\182\002\000\000\
\\183\002\000\000\
\\184\002\000\000\
\\185\002\000\000\
\\186\002\009\000\255\001\000\000\
\\187\002\000\000\
\\188\002\000\000\
\\188\002\024\000\071\001\000\000\
\\189\002\009\000\253\001\000\000\
\\190\002\000\000\
\\191\002\011\000\036\001\000\000\
\\192\002\009\000\006\002\000\000\
\\193\002\000\000\
\\194\002\000\000\
\\195\002\046\000\008\002\000\000\
\\196\002\011\000\036\001\000\000\
\\197\002\000\000\
\\198\002\000\000\
\\199\002\000\000\
\\200\002\000\000\
\\201\002\000\000\
\\202\002\009\000\077\002\000\000\
\\203\002\000\000\
\\204\002\000\000\
\\205\002\000\000\
\\206\002\000\000\
\\207\002\000\000\
\\208\002\008\000\059\000\019\000\056\000\026\000\054\000\030\000\052\000\
\\037\000\048\000\038\000\047\000\042\000\148\000\044\000\041\000\
\\048\000\039\000\049\000\038\000\055\000\147\000\062\000\033\000\
\\063\000\032\000\000\000\
\\209\002\000\000\
\\210\002\000\000\
\\211\002\000\000\
\\212\002\000\000\
\\213\002\000\000\
\\214\002\000\000\
\\215\002\000\000\
\\216\002\000\000\
\\217\002\000\000\
\\218\002\000\000\
\\219\002\000\000\
\\220\002\000\000\
\\221\002\000\000\
\\222\002\000\000\
\\223\002\000\000\
\\224\002\000\000\
\\225\002\000\000\
\\226\002\000\000\
\\227\002\000\000\
\\228\002\009\000\146\001\010\000\081\000\016\000\080\000\032\000\079\000\
\\045\000\078\000\000\000\
\\229\002\000\000\
\\230\002\000\000\
\\231\002\000\000\
\\232\002\009\000\015\002\000\000\
\\233\002\000\000\
\\234\002\016\000\018\001\000\000\
\\235\002\011\000\036\001\000\000\
\\236\002\009\000\015\001\000\000\
\\237\002\000\000\
\\238\002\000\000\
\\239\002\014\000\016\001\000\000\
\\240\002\000\000\
\\241\002\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\242\002\000\000\
\\243\002\000\000\
\\244\002\009\000\229\001\011\000\036\001\000\000\
\\245\002\000\000\
\\246\002\000\000\
\\247\002\006\000\113\000\043\000\118\000\000\000\
\\248\002\000\000\
\\249\002\000\000\
\\250\002\018\000\062\001\000\000\
\\251\002\000\000\
\\252\002\014\000\011\002\000\000\
\\253\002\000\000\
\\254\002\046\000\010\002\000\000\
\\255\002\011\000\036\001\000\000\
\\000\003\000\000\
\\001\003\000\000\
\\002\003\009\000\025\001\000\000\
\\003\003\000\000\
\\004\003\000\000\
\\005\003\000\000\
\\006\003\024\000\024\001\046\000\023\001\000\000\
\\007\003\011\000\036\001\000\000\
\\008\003\000\000\
\\009\003\000\000\
\\010\003\002\000\129\000\000\000\
\\011\003\000\000\
\\012\003\002\000\129\000\000\000\
\\013\003\000\000\
\\014\003\000\000\
\\015\003\002\000\129\000\000\000\
\\016\003\000\000\
\\017\003\000\000\
\\018\003\000\000\
\\019\003\000\000\
\\020\003\000\000\
\\021\003\000\000\
\\022\003\000\000\
\\023\003\000\000\
\\024\003\000\000\
\\025\003\000\000\
\\026\003\000\000\
\\027\003\000\000\
\\028\003\000\000\
\\029\003\000\000\
\\030\003\009\000\030\001\000\000\
\\031\003\000\000\
\\032\003\000\000\
\\033\003\068\000\029\001\000\000\
\\034\003\000\000\
\\035\003\009\000\060\002\000\000\
\\036\003\000\000\
\\037\003\000\000\
\\038\003\014\000\019\001\000\000\
\\039\003\000\000\
\\040\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\041\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\042\003\000\000\
\\043\003\018\000\011\001\000\000\
\\044\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\
\\055\000\254\000\000\000\
\\045\003\000\000\
\\046\003\000\000\
\\046\003\054\000\251\000\000\000\
\\047\003\000\000\
\\048\003\010\000\081\000\016\000\080\000\000\000\
\\049\003\016\000\080\000\000\000\
\\050\003\011\000\036\001\000\000\
\\051\003\000\000\
\\052\003\000\000\
\\053\003\000\000\
\\054\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\055\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\056\003\010\000\081\000\016\000\080\000\032\000\079\000\045\000\078\000\000\000\
\\057\003\000\000\
\\058\003\000\000\
\\059\003\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\024\000\055\000\
\\033\000\050\000\039\000\046\000\040\000\045\000\041\000\044\000\
\\043\000\042\000\047\000\040\000\069\000\030\000\070\000\029\000\
\\071\000\028\000\072\000\027\000\073\000\026\000\074\000\025\000\
\\075\000\024\000\076\000\023\000\000\000\
\\060\003\000\000\
\\061\003\000\000\
\\062\003\000\000\
\\063\003\000\000\
\\064\003\000\000\
\\065\003\000\000\
\\066\003\000\000\
\\067\003\000\000\
\\068\003\000\000\
\\069\003\000\000\
\\070\003\000\000\
\\071\003\000\000\
\\072\003\000\000\
\\073\003\000\000\
\\074\003\000\000\
\\075\003\000\000\
\\076\003\000\000\
\\077\003\000\000\
\\078\003\000\000\
\\079\003\000\000\
\\080\003\000\000\
\\081\003\000\000\
\\082\003\000\000\
\\083\003\000\000\
\\084\003\003\000\063\000\013\000\076\000\000\000\
\\085\003\000\000\
\\086\003\003\000\063\000\013\000\076\000\000\000\
\\087\003\000\000\
\\088\003\000\000\
\\089\003\010\000\081\000\016\000\080\000\018\000\255\000\032\000\079\000\
\\045\000\078\000\000\000\
\\090\003\010\000\081\000\016\000\080\000\018\000\008\001\032\000\079\000\
\\045\000\078\000\000\000\
\\091\003\000\000\
\\092\003\000\000\
\\093\003\012\000\224\000\016\000\223\000\000\000\
\\094\003\011\000\036\001\000\000\
\\095\003\000\000\
\\096\003\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\039\000\112\000\
\\040\000\111\000\043\000\175\000\047\000\109\000\066\000\107\000\000\000\
\\097\003\000\000\
\\098\003\000\000\
\\099\003\000\000\
\\100\003\000\000\
\\101\003\000\000\
\\102\003\000\000\
\\103\003\000\000\
\\104\003\000\000\
\\105\003\000\000\
\\106\003\000\000\
\\107\003\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\006\000\113\000\007\000\060\000\013\000\058\000\
\\039\000\112\000\040\000\111\000\043\000\175\000\047\000\109\000\
\\066\000\107\000\000\000\
\\107\003\001\000\065\000\002\000\064\000\003\000\063\000\004\000\062\000\
\\005\000\061\000\007\000\060\000\013\000\058\000\039\000\112\000\
\\040\000\111\000\043\000\175\000\047\000\109\000\066\000\107\000\000\000\
\\108\003\000\000\
\\109\003\012\000\224\000\016\000\223\000\018\000\065\001\000\000\
\\110\003\000\000\
\\111\003\000\000\
\\112\003\018\000\069\001\000\000\
\\113\003\000\000\
\\114\003\012\000\224\000\016\000\223\000\000\000\
\\115\003\000\000\
\\116\003\012\000\151\001\000\000\
\\117\003\012\000\224\000\016\000\223\000\000\000\
\\118\003\000\000\
\\119\003\000\000\
\\120\003\011\000\036\001\000\000\
\\122\003\000\000\
\\123\003\000\000\
\\124\003\000\000\
\\125\003\000\000\
\\126\003\000\000\
\\127\003\000\000\
\\128\003\000\000\
\\129\003\000\000\
\\130\003\011\000\036\001\000\000\
\\131\003\000\000\
\\132\003\018\000\133\001\000\000\
\\133\003\000\000\
\\134\003\003\000\063\000\013\000\035\001\000\000\
\\135\003\011\000\036\001\018\000\131\001\000\000\
\\136\003\000\000\
\\137\003\000\000\
\\138\003\000\000\
\\139\003\000\000\
\\140\003\000\000\
\\141\003\000\000\
\\142\003\000\000\
\\143\003\000\000\
\\144\003\000\000\
\\145\003\000\000\
\\146\003\000\000\
\\147\003\000\000\
\\148\003\000\000\
\\149\003\000\000\
\\150\003\000\000\
\\151\003\000\000\
\\152\003\000\000\
\\153\003\000\000\
\\154\003\000\000\
\\155\003\000\000\
\\156\003\000\000\
\\158\003\003\000\063\000\013\000\076\000\024\000\075\000\000\000\
\\159\003\000\000\
\\160\003\000\000\
\\161\003\000\000\
\\162\003\000\000\
\\163\003\000\000\
\\164\003\000\000\
\\165\003\000\000\
\\166\003\000\000\
\\167\003\000\000\
\\168\003\003\000\063\000\013\000\076\000\000\000\
\\169\003\000\000\
\\170\003\000\000\
\\171\003\000\000\
\\172\003\000\000\
\\173\003\000\000\
\\174\003\000\000\
\\175\003\000\000\
\\176\003\000\000\
\\177\003\003\000\063\000\013\000\058\000\000\000\
\\178\003\000\000\
\"
val actionRowNumbers =
"\124\000\171\001\123\000\128\000\
\\125\000\137\000\129\000\089\001\
\\181\001\202\001\184\001\170\001\
\\024\000\121\000\075\001\045\000\
\\140\000\169\001\092\001\081\001\
\\089\001\029\000\030\000\031\000\
\\029\000\029\000\029\000\029\000\
\\029\000\004\000\000\000\020\001\
\\022\000\022\000\124\000\004\000\
\\044\001\017\000\024\000\043\001\
\\003\000\134\000\237\000\002\000\
\\012\000\041\001\039\001\004\000\
\\009\000\022\000\001\000\007\000\
\\025\000\185\001\020\001\004\000\
\\182\001\020\001\047\001\173\001\
\\172\001\183\001\046\001\174\001\
\\126\000\088\001\090\001\252\000\
\\187\001\176\001\177\001\186\001\
\\179\001\180\001\178\001\124\000\
\\004\000\007\000\016\000\004\000\
\\087\001\063\000\175\001\116\001\
\\064\000\114\001\114\001\114\001\
\\065\000\066\000\067\000\068\000\
\\043\000\243\000\254\000\005\000\
\\021\001\122\001\060\000\129\001\
\\203\001\131\001\125\001\128\001\
\\126\001\132\001\006\000\024\000\
\\137\001\138\001\011\000\192\001\
\\019\001\015\000\015\001\247\000\
\\032\000\183\000\138\000\195\001\
\\088\000\130\000\196\001\127\000\
\\086\001\024\000\045\001\048\001\
\\251\000\206\001\205\001\091\001\
\\076\001\111\000\112\000\040\000\
\\096\001\132\000\101\000\134\000\
\\134\000\102\000\241\000\240\000\
\\237\000\237\000\237\000\109\000\
\\120\001\101\001\194\001\193\001\
\\089\000\106\000\072\001\095\001\
\\042\001\040\001\046\000\093\001\
\\199\001\131\000\105\000\007\000\
\\245\000\009\001\011\001\012\001\
\\007\001\066\001\067\001\062\000\
\\082\001\138\001\035\001\190\001\
\\250\000\031\001\029\001\022\000\
\\015\000\051\001\058\001\062\001\
\\059\001\049\001\248\000\052\001\
\\044\000\015\000\120\000\188\001\
\\122\000\078\001\077\001\153\001\
\\149\001\014\000\028\000\080\001\
\\150\001\159\001\200\001\016\000\
\\013\000\079\001\016\000\069\000\
\\116\001\016\000\114\001\070\000\
\\071\000\072\000\016\000\016\000\
\\016\000\016\000\004\000\244\000\
\\004\000\016\000\007\000\127\001\
\\000\001\061\000\006\000\130\001\
\\113\000\023\001\114\000\140\001\
\\110\000\007\001\107\000\143\001\
\\059\000\090\000\135\001\144\001\
\\091\000\191\001\092\000\026\000\
\\026\000\026\000\073\000\189\001\
\\207\001\097\001\098\001\099\001\
\\004\000\004\000\134\000\136\000\
\\135\000\004\000\238\000\239\000\
\\103\000\100\001\004\000\004\000\
\\094\001\009\000\004\000\186\000\
\\246\000\007\000\007\000\093\000\
\\016\000\007\000\004\000\034\001\
\\033\001\016\000\020\000\025\000\
\\030\001\094\000\056\001\020\001\
\\020\001\007\000\095\000\237\000\
\\158\001\016\000\016\000\115\000\
\\048\000\108\000\162\001\074\000\
\\155\001\050\000\016\000\117\001\
\\051\000\115\001\016\000\016\000\
\\016\000\052\000\053\000\049\000\
\\054\000\084\001\001\001\124\001\
\\123\001\100\000\003\001\022\001\
\\032\000\133\001\139\001\007\000\
\\134\001\147\001\136\001\010\000\
\\007\000\016\000\019\000\173\000\
\\172\000\162\000\185\000\187\000\
\\184\000\176\000\016\000\074\001\
\\073\001\118\001\119\001\081\000\
\\082\000\042\000\237\000\121\001\
\\070\001\071\001\041\000\075\000\
\\236\000\190\000\187\000\200\000\
\\116\000\024\000\020\001\022\000\
\\021\000\187\000\026\000\022\000\
\\020\001\020\001\010\001\013\001\
\\004\000\008\001\068\001\069\001\
\\036\001\204\001\037\001\017\000\
\\032\001\023\000\063\001\060\001\
\\083\001\025\000\083\000\152\001\
\\164\001\163\001\151\001\015\000\
\\157\001\016\000\154\001\009\000\
\\016\000\111\001\055\000\113\001\
\\056\000\057\000\058\000\104\001\
\\107\001\008\000\105\001\255\000\
\\005\000\007\000\024\001\140\001\
\\146\001\007\000\142\001\145\001\
\\017\001\150\000\036\000\148\000\
\\033\000\076\000\141\000\156\000\
\\134\000\134\000\164\000\163\000\
\\119\000\084\000\171\000\119\000\
\\022\000\047\000\139\000\103\001\
\\102\001\085\000\004\000\026\000\
\\189\000\183\000\079\000\191\000\
\\218\000\015\000\192\000\214\000\
\\193\000\080\000\197\000\202\000\
\\096\000\015\000\188\000\174\000\
\\198\000\196\000\221\000\224\000\
\\015\000\194\000\053\001\057\001\
\\050\001\195\000\054\001\014\001\
\\038\001\027\001\061\001\025\001\
\\015\000\249\000\156\001\166\001\
\\165\001\161\001\160\001\112\001\
\\109\001\110\001\108\001\168\001\
\\118\000\167\001\002\001\005\001\
\\141\001\148\001\016\001\020\001\
\\143\000\022\000\152\000\144\000\
\\142\000\119\000\026\000\026\000\
\\158\000\133\000\086\000\104\000\
\\165\000\020\001\175\000\177\000\
\\178\000\018\000\242\000\085\001\
\\235\000\097\000\016\000\024\000\
\\217\000\020\001\026\000\017\000\
\\201\000\098\000\199\000\197\001\
\\022\000\223\000\016\000\216\000\
\\016\000\025\000\055\001\106\001\
\\004\001\006\000\018\001\149\000\
\\034\000\155\000\154\000\153\000\
\\151\000\078\000\117\000\157\000\
\\019\000\166\000\167\000\119\000\
\\015\000\179\000\180\000\027\000\
\\253\000\064\001\201\001\019\000\
\\220\000\219\000\215\000\208\000\
\\204\000\203\000\015\000\198\001\
\\222\000\225\000\028\001\026\001\
\\006\001\145\000\146\000\027\000\
\\160\000\161\000\077\000\168\000\
\\099\000\177\000\018\000\231\000\
\\037\000\226\000\207\000\119\000\
\\022\000\206\000\205\000\035\000\
\\159\000\170\000\169\000\016\000\
\\181\000\065\001\228\000\022\000\
\\229\000\227\000\119\000\209\000\
\\210\000\147\000\182\000\232\000\
\\038\000\211\000\212\000\027\000\
\\230\000\233\000\027\000\209\000\
\\039\000\213\000\234\000\087\000"
val gotoT =
"\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\033\000\016\000\045\000\015\000\049\000\014\000\050\000\013\000\
\\054\000\012\000\064\000\011\000\066\000\010\000\067\000\009\000\
\\068\000\008\000\076\000\007\000\089\000\095\002\117\000\006\000\
\\118\000\005\000\134\000\004\000\135\000\003\000\136\000\002\000\
\\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\033\000\016\000\054\000\012\000\117\000\006\000\118\000\005\000\
\\134\000\004\000\135\000\003\000\136\000\064\000\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\066\000\008\000\065\000\016\000\018\000\
\\017\000\017\000\064\000\011\000\066\000\010\000\067\000\009\000\
\\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\072\000\062\000\071\000\063\000\070\000\068\000\069\000\
\\161\000\068\000\163\000\067\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\066\000\008\000\080\000\016\000\018\000\
\\017\000\017\000\064\000\011\000\066\000\010\000\067\000\009\000\
\\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\130\000\081\000\000\000\
\\130\000\083\000\000\000\
\\130\000\085\000\000\000\
\\130\000\087\000\000\000\
\\130\000\088\000\000\000\
\\130\000\089\000\000\000\
\\130\000\090\000\000\000\
\\130\000\091\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\092\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\098\000\086\000\097\000\151\000\096\000\
\\154\000\095\000\155\000\094\000\157\000\093\000\168\000\001\000\000\000\
\\146\000\115\000\147\000\114\000\151\000\096\000\153\000\113\000\
\\154\000\112\000\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\112\000\118\000\
\\129\000\117\000\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\099\000\121\000\
\\107\000\120\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\033\000\016\000\045\000\015\000\049\000\014\000\050\000\123\000\
\\054\000\012\000\064\000\011\000\066\000\010\000\067\000\009\000\
\\068\000\008\000\076\000\007\000\117\000\006\000\118\000\005\000\
\\134\000\004\000\135\000\003\000\136\000\002\000\168\000\001\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\124\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\036\000\126\000\088\000\125\000\000\000\
\\066\000\130\000\068\000\008\000\069\000\129\000\071\000\128\000\000\000\
\\061\000\072\000\062\000\071\000\063\000\070\000\068\000\069\000\
\\161\000\131\000\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\135\000\046\000\134\000\048\000\133\000\049\000\132\000\
\\064\000\011\000\066\000\010\000\067\000\009\000\068\000\008\000\
\\076\000\007\000\168\000\001\000\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\138\000\120\000\137\000\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\141\000\
\\054\000\012\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\148\000\047\000\147\000\049\000\014\000\064\000\011\000\
\\066\000\010\000\067\000\009\000\068\000\008\000\076\000\007\000\
\\168\000\001\000\000\000\
\\041\000\154\000\042\000\153\000\053\000\152\000\061\000\151\000\
\\063\000\070\000\064\000\150\000\068\000\069\000\000\000\
\\036\000\156\000\000\000\
\\036\000\157\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\158\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\053\000\159\000\061\000\151\000\063\000\070\000\064\000\150\000\
\\068\000\069\000\000\000\
\\052\000\162\000\055\000\161\000\061\000\160\000\063\000\070\000\
\\068\000\069\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\168\000\011\000\167\000\
\\012\000\166\000\013\000\165\000\016\000\101\000\017\000\017\000\
\\060\000\164\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\151\000\096\000\154\000\163\000\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\078\000\172\000\082\000\171\000\086\000\097\000\
\\091\000\170\000\092\000\169\000\168\000\001\000\000\000\
\\015\000\178\000\037\000\177\000\040\000\176\000\061\000\175\000\
\\063\000\070\000\068\000\069\000\080\000\174\000\000\000\
\\000\000\
\\022\000\187\000\024\000\186\000\026\000\185\000\028\000\184\000\
\\029\000\183\000\030\000\182\000\090\000\181\000\151\000\096\000\
\\153\000\180\000\154\000\112\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\188\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\022\000\190\000\028\000\184\000\029\000\183\000\030\000\182\000\
\\151\000\096\000\153\000\189\000\154\000\112\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\072\000\062\000\071\000\063\000\070\000\068\000\069\000\
\\161\000\068\000\163\000\191\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\033\000\016\000\045\000\015\000\049\000\014\000\050\000\192\000\
\\054\000\012\000\064\000\011\000\066\000\010\000\067\000\009\000\
\\068\000\008\000\076\000\007\000\117\000\006\000\118\000\005\000\
\\134\000\004\000\135\000\003\000\136\000\002\000\168\000\001\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\193\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\078\000\194\000\082\000\171\000\086\000\097\000\
\\091\000\170\000\092\000\169\000\168\000\001\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\199\000\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\205\000\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\208\000\063\000\070\000\068\000\069\000\131\000\207\000\000\000\
\\000\000\
\\010\000\211\000\061\000\210\000\063\000\070\000\068\000\069\000\000\000\
\\010\000\212\000\061\000\210\000\063\000\070\000\068\000\069\000\000\000\
\\010\000\213\000\061\000\210\000\063\000\070\000\068\000\069\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\098\000\086\000\097\000\155\000\094\000\
\\157\000\219\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\223\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\168\000\001\000\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\225\000\086\000\097\000\093\000\224\000\
\\168\000\001\000\000\000\
\\061\000\072\000\062\000\071\000\063\000\070\000\068\000\069\000\
\\161\000\227\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\231\000\086\000\097\000\087\000\230\000\
\\151\000\229\000\152\000\228\000\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\231\000\086\000\097\000\087\000\232\000\
\\168\000\001\000\000\000\
\\053\000\237\000\061\000\236\000\063\000\070\000\064\000\150\000\
\\068\000\069\000\084\000\235\000\085\000\234\000\162\000\233\000\000\000\
\\000\000\
\\000\000\
\\063\000\241\000\068\000\069\000\144\000\240\000\000\000\
\\000\000\
\\000\000\
\\151\000\229\000\152\000\228\000\000\000\
\\102\000\242\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\072\000\062\000\247\000\063\000\070\000\068\000\069\000\
\\160\000\246\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\066\000\130\000\068\000\008\000\069\000\129\000\071\000\248\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\255\000\120\000\137\000\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\000\001\120\000\137\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\002\001\
\\054\000\012\000\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\003\001\
\\054\000\012\000\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\004\001\
\\054\000\012\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\168\000\011\000\167\000\
\\012\000\166\000\013\000\165\000\016\000\101\000\017\000\017\000\
\\060\000\012\001\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\019\000\015\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\231\000\086\000\097\000\087\000\230\000\
\\168\000\001\000\000\000\
\\038\000\020\001\039\000\019\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\024\001\061\000\175\000\063\000\070\000\068\000\069\000\000\000\
\\063\000\241\000\068\000\069\000\144\000\025\001\000\000\
\\000\000\
\\000\000\
\\167\000\026\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\063\000\241\000\068\000\069\000\144\000\030\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\032\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\036\001\
\\139\000\198\000\140\000\197\000\141\000\035\001\145\000\196\000\
\\151\000\195\000\000\000\
\\053\000\039\001\061\000\151\000\063\000\070\000\064\000\150\000\
\\068\000\069\000\132\000\038\001\133\000\037\001\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\041\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\061\000\208\000\063\000\070\000\068\000\069\000\131\000\043\001\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\044\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\010\000\045\001\061\000\210\000\063\000\070\000\068\000\069\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\049\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\050\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\051\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\052\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\053\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\054\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\055\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\056\001\086\000\097\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\225\000\086\000\097\000\093\000\058\001\
\\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\062\001\000\000\
\\000\000\
\\019\000\065\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\103\000\074\001\
\\104\000\073\001\105\000\072\001\107\000\071\001\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\103\000\076\001\
\\104\000\073\001\105\000\072\001\107\000\071\001\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\104\000\077\001\
\\105\000\072\001\107\000\071\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\080\001\048\000\079\001\049\000\014\000\064\000\011\000\
\\066\000\010\000\067\000\009\000\068\000\008\000\076\000\007\000\
\\168\000\001\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\082\001\046\000\081\001\049\000\014\000\064\000\011\000\
\\066\000\010\000\067\000\009\000\068\000\008\000\076\000\007\000\
\\168\000\001\000\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\083\001\120\000\137\000\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\085\001\048\000\084\001\049\000\014\000\064\000\011\000\
\\066\000\010\000\067\000\009\000\068\000\008\000\076\000\007\000\
\\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\148\000\047\000\087\001\049\000\014\000\064\000\011\000\
\\066\000\010\000\067\000\009\000\068\000\008\000\076\000\007\000\
\\168\000\001\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\088\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\041\000\154\000\042\000\089\001\053\000\152\000\061\000\151\000\
\\063\000\070\000\064\000\150\000\068\000\069\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\090\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\051\000\096\001\061\000\119\000\063\000\070\000\068\000\069\000\
\\098\000\095\001\109\000\094\001\110\000\093\001\111\000\092\001\
\\129\000\091\001\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\168\000\011\000\167\000\
\\012\000\166\000\013\000\165\000\016\000\101\000\017\000\017\000\
\\060\000\106\001\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\168\000\011\000\167\000\
\\012\000\107\001\016\000\101\000\017\000\017\000\064\000\011\000\
\\066\000\100\000\068\000\008\000\077\000\099\000\168\000\001\000\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\109\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\171\000\086\000\097\000\091\000\170\000\
\\092\000\110\001\168\000\001\000\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\111\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\112\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\065\000\114\001\066\000\113\001\068\000\008\000\000\000\
\\015\000\178\000\037\000\177\000\040\000\116\001\061\000\175\000\
\\063\000\070\000\068\000\069\000\080\000\174\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\146\000\118\001\147\000\114\000\151\000\096\000\153\000\113\000\
\\154\000\112\000\000\000\
\\028\000\184\000\030\000\119\001\151\000\096\000\153\000\189\000\
\\154\000\112\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\078\000\120\001\082\000\171\000\086\000\097\000\
\\091\000\170\000\092\000\169\000\168\000\001\000\000\000\
\\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\122\001\
\\054\000\012\000\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\125\001\139\000\124\001\
\\140\000\123\001\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\126\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\134\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\136\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\137\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\138\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\156\000\143\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\151\000\229\000\152\000\146\001\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\147\001\086\000\097\000\168\000\001\000\000\000\
\\000\000\
\\079\000\148\001\000\000\
\\000\000\
\\053\000\237\000\061\000\236\000\063\000\070\000\064\000\150\000\
\\068\000\069\000\084\000\235\000\085\000\150\001\162\000\233\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\151\001\086\000\097\000\168\000\001\000\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\152\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\066\000\159\001\068\000\008\000\113\000\158\001\124\000\157\001\
\\125\000\156\001\126\000\155\001\127\000\154\001\128\000\153\001\000\000\
\\000\000\
\\000\000\
\\165\000\163\001\166\000\162\001\000\000\
\\000\000\
\\098\000\095\001\109\000\094\001\110\000\093\001\111\000\165\001\000\000\
\\000\000\
\\100\000\166\001\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\169\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\031\000\144\000\032\000\143\000\033\000\142\000\034\000\173\001\
\\054\000\012\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\098\000\095\001\109\000\094\001\110\000\093\001\111\000\176\001\000\000\
\\000\000\
\\000\000\
\\061\000\072\000\062\000\247\000\063\000\070\000\068\000\069\000\
\\158\000\180\001\159\000\179\001\160\000\178\001\000\000\
\\146\000\184\001\147\000\114\000\149\000\183\001\150\000\182\001\
\\151\000\096\000\153\000\181\001\154\000\112\000\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\121\000\186\001\
\\129\000\185\001\000\000\
\\066\000\130\000\068\000\008\000\069\000\188\001\070\000\187\001\000\000\
\\098\000\095\001\109\000\094\001\110\000\093\001\111\000\190\001\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\103\000\192\001\
\\104\000\073\001\105\000\072\001\107\000\191\001\000\000\
\\015\000\195\001\043\000\194\001\044\000\193\001\061\000\175\000\
\\063\000\070\000\068\000\069\000\000\000\
\\149\000\183\001\150\000\197\001\151\000\096\000\153\000\196\001\
\\154\000\112\000\000\000\
\\023\000\202\001\025\000\201\001\027\000\200\001\028\000\184\000\
\\029\000\199\001\030\000\182\000\090\000\198\001\151\000\096\000\
\\153\000\180\000\154\000\112\000\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\203\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\065\000\204\001\066\000\113\001\068\000\008\000\000\000\
\\000\000\
\\015\000\178\000\018\000\207\001\020\000\206\001\061\000\175\000\
\\063\000\070\000\068\000\069\000\080\000\205\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\178\000\018\000\207\001\020\000\206\001\061\000\175\000\
\\063\000\070\000\068\000\069\000\080\000\205\001\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\032\001\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\210\001\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\212\001\
\\139\000\198\000\140\000\197\000\141\000\211\001\145\000\196\000\
\\151\000\195\000\000\000\
\\000\000\
\\053\000\039\001\061\000\151\000\063\000\070\000\064\000\150\000\
\\068\000\069\000\132\000\038\001\133\000\213\001\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\214\001\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\221\001\017\000\017\000\021\000\220\001\061\000\219\001\
\\063\000\070\000\064\000\011\000\068\000\069\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\098\000\086\000\097\000\155\000\222\001\
\\168\000\001\000\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\078\000\223\001\082\000\171\000\086\000\097\000\
\\091\000\170\000\092\000\169\000\168\000\001\000\000\000\
\\000\000\
\\014\000\224\001\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\225\001\086\000\097\000\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\148\000\226\001\000\000\
\\000\000\
\\000\000\
\\116\000\228\001\000\000\
\\114\000\232\001\116\000\231\001\165\000\230\001\166\000\162\001\000\000\
\\000\000\
\\000\000\
\\009\000\236\001\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\238\001\120\000\137\000\000\000\
\\033\000\016\000\054\000\012\000\117\000\139\000\118\000\005\000\
\\119\000\239\001\120\000\137\000\000\000\
\\000\000\
\\000\000\
\\164\000\240\001\000\000\
\\000\000\
\\000\000\
\\164\000\243\001\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\099\000\244\001\
\\107\000\120\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\020\000\007\000\019\000\016\000\018\000\017\000\017\000\
\\045\000\247\001\049\000\014\000\064\000\011\000\066\000\010\000\
\\067\000\009\000\068\000\008\000\076\000\007\000\168\000\001\000\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\103\000\248\001\
\\104\000\073\001\105\000\072\001\107\000\071\001\000\000\
\\000\000\
\\102\000\249\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\063\000\241\000\068\000\069\000\144\000\252\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\001\002\073\000\000\002\000\000\
\\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\107\000\003\002\
\\108\000\002\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\143\000\005\002\000\000\
\\063\000\241\000\068\000\069\000\144\000\007\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\010\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\012\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\147\000\014\002\151\000\096\000\153\000\113\000\154\000\112\000\000\000\
\\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\112\000\015\002\
\\129\000\117\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\164\000\016\002\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\104\000\017\002\
\\105\000\072\001\107\000\071\001\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\104\000\018\002\
\\105\000\072\001\107\000\071\001\000\000\
\\000\000\
\\033\000\016\000\054\000\012\000\066\000\159\001\068\000\008\000\
\\117\000\139\000\118\000\005\000\119\000\022\002\120\000\137\000\
\\124\000\021\002\125\000\020\002\127\000\019\002\128\000\153\001\000\000\
\\000\000\
\\000\000\
\\002\000\026\002\166\000\025\002\000\000\
\\151\000\096\000\153\000\028\002\154\000\112\000\000\000\
\\000\000\
\\100\000\030\002\101\000\029\002\000\000\
\\000\000\
\\066\000\010\000\067\000\034\002\068\000\008\000\074\000\033\002\
\\075\000\032\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\036\002\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\061\000\072\000\062\000\247\000\063\000\070\000\068\000\069\000\
\\158\000\180\001\159\000\037\002\160\000\178\001\000\000\
\\000\000\
\\149\000\183\001\150\000\038\002\151\000\096\000\153\000\196\001\
\\154\000\112\000\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\104\000\039\002\
\\105\000\072\001\107\000\071\001\000\000\
\\066\000\130\000\068\000\008\000\069\000\041\002\070\000\040\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\107\000\003\002\
\\108\000\043\002\000\000\
\\015\000\195\001\043\000\194\001\044\000\044\002\061\000\175\000\
\\063\000\070\000\068\000\069\000\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\045\002\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\046\002\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\015\000\178\000\018\000\207\001\020\000\047\002\061\000\175\000\
\\063\000\070\000\068\000\069\000\080\000\205\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\104\000\005\000\103\000\006\000\102\000\016\000\101\000\
\\017\000\017\000\064\000\011\000\066\000\100\000\068\000\008\000\
\\077\000\099\000\082\000\225\000\086\000\097\000\093\000\048\002\
\\168\000\001\000\000\000\
\\000\000\
\\000\000\
\\002\000\026\002\114\000\050\002\115\000\049\002\116\000\231\001\
\\166\000\025\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\165\000\230\001\166\000\162\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\066\000\159\001\068\000\008\000\124\000\054\002\125\000\020\002\
\\127\000\019\002\128\000\153\001\000\000\
\\000\000\
\\000\000\
\\164\000\055\002\000\000\
\\068\000\202\000\072\000\056\002\000\000\
\\000\000\
\\000\000\
\\061\000\122\000\063\000\070\000\068\000\069\000\099\000\244\001\
\\107\000\120\000\164\000\057\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\056\000\061\002\066\000\159\001\068\000\008\000\124\000\157\001\
\\125\000\060\002\126\000\059\002\127\000\154\001\128\000\153\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\122\000\062\002\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\066\002\073\000\065\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\112\000\015\002\
\\129\000\117\000\164\000\067\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\070\002\166\000\069\002\000\000\
\\000\000\
\\100\000\030\002\101\000\072\002\000\000\
\\066\000\010\000\067\000\034\002\068\000\008\000\074\000\033\002\
\\075\000\073\002\000\000\
\\059\000\074\002\000\000\
\\057\000\077\002\059\000\076\002\165\000\230\001\166\000\162\001\000\000\
\\000\000\
\\000\000\
\\164\000\079\002\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\121\000\080\002\
\\129\000\185\001\000\000\
\\000\000\
\\000\000\
\\002\000\070\002\114\000\050\002\115\000\081\002\116\000\231\001\
\\166\000\069\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\202\000\072\000\201\000\137\000\200\000\138\000\082\002\
\\139\000\198\000\140\000\197\000\145\000\196\000\151\000\195\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\052\000\162\000\055\000\083\002\061\000\160\000\063\000\070\000\
\\068\000\069\000\000\000\
\\000\000\
\\000\000\
\\164\000\084\002\000\000\
\\122\000\086\002\123\000\085\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\026\002\057\000\089\002\058\000\088\002\059\000\076\002\
\\166\000\025\002\000\000\
\\000\000\
\\000\000\
\\061\000\119\000\063\000\070\000\068\000\069\000\121\000\080\002\
\\129\000\185\001\164\000\091\002\000\000\
\\000\000\
\\000\000\
\\052\000\162\000\055\000\083\002\061\000\160\000\063\000\070\000\
\\068\000\069\000\164\000\092\002\000\000\
\\122\000\086\002\123\000\093\002\000\000\
\\002\000\070\002\057\000\089\002\058\000\094\002\059\000\076\002\
\\166\000\069\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 608
val numrules = 337
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = SourcePos.t
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit
 | WORD of unit ->  ({ digits:string,radix:StringCvt.radix } )
 | TYVAR of unit ->  (string) | STRING of unit ->  (IntInf.t vector)
 | REAL of unit ->  (string) | LONGID of unit ->  (string)
 | INT of unit ->  ({ digits:string,negate:bool,radix:StringCvt.radix } )
 | CHAR of unit ->  (IntInf.t) | word of unit ->  (IntInf.t)
 | withtypes of unit ->  (TypBind.t)
 | wherespecs' of unit ->  (wherespec list)
 | wherespecs of unit ->  (wherespec vector)
 | wherespec of unit ->  (wherespec) | vids of unit ->  (Vid.t list)
 | vidNoEqual of unit ->  (Vid.t) | vid of unit ->  (Vid.t)
 | var of unit ->  (Var.t) | valdescs of unit ->  (valdesc list)
 | valdesc of unit ->  (valdesc)
 | valbindTop of unit ->  (vb vector*rvb vector)
 | valbindRest of unit ->  (vb list*rvb list)
 | valbind of unit ->  (vb list*rvb list)
 | tyvarseq of unit ->  (Tyvar.t vector)
 | tyvars of unit ->  (Tyvar.t vector)
 | tyvar_pc of unit ->  (Tyvar.t list) | tyvar of unit ->  (Tyvar.t)
 | typdescs of unit ->  (typdesc list) | typdesc of unit ->  (typdesc)
 | typBind'' of unit ->  ({ def:Type.t,tycon:Tycon.t,tyvars:Tyvar.t vector }  list)
 | typBind' of unit ->  ({ def:Type.t,tycon:Tycon.t,tyvars:Tyvar.t vector }  list)
 | typBind of unit ->  (TypBind.t) | tynode of unit ->  (Type.node)
 | tycon of unit ->  (Tycon.t) | tyOpt of unit ->  (Type.t option)
 | ty1 of unit ->  (Type.t) | ty0_pc of unit ->  (Type.t list)
 | ty'node of unit ->  (Type.node) | ty' of unit ->  (Type.t)
 | ty of unit ->  (Type.t) | tuple_ty of unit ->  (Type.t list)
 | topdecs of unit ->  (Topdec.t list list)
 | topdecnode of unit ->  (Topdec.node)
 | topdec of unit ->  (Topdec.t)
 | tlabels of unit ->  ( ( Field.t * Type.t )  list)
 | tlabel of unit ->  ( ( Field.t * Type.t ) )
 | symattributes of unit ->  (PrimKind.SymbolAttribute.t list)
 | string of unit ->  (string) | strid of unit ->  (Strid.t)
 | strexpnode of unit ->  (Strexp.node)
 | strexp2node of unit ->  (Strexp.node)
 | strexp2 of unit ->  (Strexp.t)
 | strexp1 of unit ->  (Strexp.t* ( Sigexp.t -> SigConst.t ) *Sigexp.t)
 | strexp of unit ->  (Strexp.t)
 | strdescs'' of unit ->  (strdesc whereAnd)
 | strdescs' of unit ->  (strdesc whereAnd)
 | strdescs of unit ->  (strdesc list)
 | strdecsnode of unit ->  (Strdec.node)
 | strdecs of unit ->  (Strdec.t)
 | strdecnode of unit ->  (Strdec.node)
 | strdec of unit ->  (Strdec.t)
 | strbinds'2 of unit ->  (strbind list)
 | strbinds'1' of unit ->  (strbind whereAnd)
 | strbinds'1 of unit ->  (strbind whereAnd)
 | strbinds' of unit ->  (Strexp.t*strbind list)
 | strbinds of unit ->  (strbind list) | specs of unit ->  (Spec.t)
 | specnode of unit ->  (Spec.node) | spec of unit ->  (Spec.t)
 | sigids of unit ->  (Sigid.t list) | sigid of unit ->  (Sigid.t)
 | sigexpnode of unit ->  (Sigexp.node)
 | sigexp'node of unit ->  (Sigexp.node)
 | sigexp' of unit ->  (Sigexp.t) | sigexp of unit ->  (Sigexp.t)
 | sigconst of unit ->  (SigConst.t)
 | sigbinds'' of unit ->  (sigbind whereAnd)
 | sigbinds' of unit ->  (sigbind whereAnd)
 | sigbinds of unit ->  (sigbind list)
 | sharespec of unit ->  (Equation.node)
 | sdecsPlus of unit ->  (Dec.t) | sdecs of unit ->  (Dec.t)
 | sdec of unit ->  (Dec.t) | rvalbindRest of unit ->  (rvb list)
 | rvalbind of unit ->  (rvb list) | rules of unit ->  (rule list)
 | rule of unit ->  (rule) | repl of unit ->  (DatatypeRhs.node)
 | program of unit ->  (Program.t) | priority of unit ->  (Priority.t)
 | pats of unit ->  (Pat.t list) | patnode of unit ->  (Pat.node)
 | patitems of unit ->  ( ( (Field.t * Pat.Item.t) list * bool ) )
 | patitem of unit ->  ( ( Field.t * Pat.Item.t ) )
 | pat_2c of unit ->  (Pat.t list) | pat of unit ->  (Pat.t)
 | ot_list of unit ->  (Exp.t list) | opcon of unit ->  (Con.t)
 | opaspat of unit ->  (Pat.t option) | match of unit ->  (Match.t)
 | longvidNoEqual of unit ->  (Longvid.t)
 | longvid of unit ->  (Longvid.t)
 | longvarands of unit ->  (Longvar.t list)
 | longvar of unit ->  (Longvar.t)
 | longtyconeqns of unit ->  (Longtycon.t list)
 | longtycon of unit ->  (Longtycon.t)
 | longstrids of unit ->  (Longstrid.t list)
 | longstrideqns of unit ->  (Longstrid.t list)
 | longstrid of unit ->  (Longstrid.t)
 | longidNoAsterisk of unit ->  (Symbol.t list*Region.t)
 | longidEqual of unit ->  (Symbol.t list*Region.t)
 | longid of unit ->  (Symbol.t list*Region.t)
 | longcon of unit ->  (Longcon.t) | int of unit ->  (IntInf.t)
 | idNoAsterisk of unit ->  (Symbol.t*Region.t)
 | idEqual of unit ->  (Symbol.t*Region.t)
 | id of unit ->  (Symbol.t*Region.t)
 | funs of unit ->  (clauses list)
 | funbinds'2 of unit ->  (funbind list)
 | funbinds'1' of unit ->  (funbind whereAnd)
 | funbinds'1 of unit ->  (funbind whereAnd)
 | funbinds' of unit ->  (Strexp.t*funbind list)
 | funbinds of unit ->  (funbind list) | fixity of unit ->  (Fixity.t)
 | field of unit ->  (Field.t) | fctid of unit ->  (Fctid.t)
 | fctarg of unit ->  (FctArg.node)
 | expsAndTopdecs of unit ->  (Topdec.t list list)
 | expnode of unit ->  (Exp.node) | exp_ps of unit ->  (Exp.t list)
 | exp_list of unit ->  (Exp.t list) | exp_2c of unit ->  (Exp.t list)
 | exp of unit ->  (Exp.t) | exndescs of unit ->  (exndesc list)
 | exndesc of unit ->  (exndesc)
 | elabels of unit ->  ( ( Field.t * Exp.t )  list)
 | elabel of unit ->  ( ( Field.t * Exp.t ) )
 | ebs of unit ->  (eb list) | ebrhsnode of unit ->  (EbRhs.node)
 | ebrhs of unit ->  (EbRhs.t) | eb of unit ->  (eb)
 | digit of unit ->  (int) | decsnode of unit ->  (Dec.node)
 | decs of unit ->  (Dec.t) | decnolocal of unit ->  (Dec.node)
 | decnode of unit ->  (Dec.node) | dec of unit ->  (Dec.t)
 | dbs' of unit ->  (db list) | dbs of unit ->  (db vector)
 | db of unit ->  (db)
 | datatypeRhsnodeNoWithtype of unit ->  (DatatypeRhs.node)
 | datatypeRhsnode of unit ->  (DatatypeRhs.node)
 | datatypeRhsNoWithtype of unit ->  (DatatypeRhs.t)
 | datatypeRhs of unit ->  (DatatypeRhs.t)
 | datBindNoWithtype of unit ->  (DatBind.t)
 | datBind of unit ->  (DatBind.t) | constOrBool of unit ->  (Const.t)
 | constrs of unit ->  ( ( Con.t * Type.t option )  list)
 | constraint of unit ->  (Type.t option)
 | constr of unit ->  (Con.t*Type.t option)
 | const' of unit ->  (Const.node) | const of unit ->  (Const.t)
 | con of unit ->  (Con.t) | commapats of unit ->  (Pat.t list)
 | clausesTop of unit ->  (clauses)
 | clauses of unit ->  (clause list) | clause of unit ->  (clause)
 | ieattributes of unit ->  (PrimKind.ImportExportAttribute.t list)
 | arg_fct of unit ->  (Strexp.t) | app_exp1 of unit ->  (Exp.t list)
 | app_exp of unit ->  (Exp.t list) | apats of unit ->  (Pat.t list)
 | apatnode of unit ->  (Pat.node) | apat' of unit ->  (Pat.t)
 | apat of unit ->  (Pat.t) | andspecs of unit ->  (wherespec list)
 | aexp of unit ->  (Exp.node)
end
type svalue = MlyValue.svalue
type result = Program.t
end
structure EC=
struct
open LrTable
infix 5 $$
fun x $$ y = y::x
val is_keyword =
fn (T 7) => true | (T 8) => true | (T 11) => true | (T 14) => true | 
(T 18) => true | (T 19) => true | (T 20) => true | (T 21) => true | 
(T 24) => true | (T 25) => true | (T 26) => true | (T 27) => true | 
(T 28) => true | (T 29) => true | (T 30) => true | (T 31) => true | 
(T 33) => true | (T 34) => true | (T 35) => true | (T 36) => true | 
(T 37) => true | (T 40) => true | (T 41) => true | (T 43) => true | 
(T 45) => true | (T 46) => true | (T 47) => true | (T 48) => true | 
(T 49) => true | (T 52) => true | (T 55) => true | (T 56) => true | 
(T 57) => true | (T 58) => true | (T 59) => true | (T 60) => true | 
(T 61) => true | (T 62) => true | (T 64) => true | (T 63) => true | 
(T 66) => true | (T 67) => true | (T 44) => true | (T 9) => true | _ => false
val preferred_change : (term list * term list) list = 
(nil
,nil
 $$ (T 62))::
(nil
,nil
 $$ (T 60))::
(nil
,nil
 $$ (T 20))::
(nil
,nil
 $$ (T 42))::
(nil
,nil
 $$ (T 54))::
(nil
 $$ (T 27),nil
 $$ (T 23))::
(nil
 $$ (T 23),nil
 $$ (T 27))::
(nil
 $$ (T 8),nil
 $$ (T 9))::
(nil
 $$ (T 15),nil
 $$ (T 45))::
(nil
 $$ (T 54),nil
 $$ (T 17))::
(nil
 $$ (T 17),nil
 $$ (T 54))::
(nil
,nil
 $$ (T 21) $$ (T 2) $$ (T 34))::
(nil
,nil
 $$ (T 2) $$ (T 20))::
nil
val noShift = 
fn (T 22) => true | _ => false
val showTerminal =
fn (T 0) => "CHAR"
  | (T 1) => "INT"
  | (T 2) => "LONGID"
  | (T 3) => "REAL"
  | (T 4) => "STRING"
  | (T 5) => "TYVAR"
  | (T 6) => "WORD"
  | (T 7) => "ABSTYPE"
  | (T 8) => "AND"
  | (T 9) => "ANDALSO"
  | (T 10) => "ARROW"
  | (T 11) => "AS"
  | (T 12) => "ASTERISK"
  | (T 13) => "BAR"
  | (T 14) => "CASE"
  | (T 15) => "COLON"
  | (T 16) => "COLONGT"
  | (T 17) => "COMMA"
  | (T 18) => "DATATYPE"
  | (T 19) => "DOTDOTDOT"
  | (T 20) => "ELSE"
  | (T 21) => "END"
  | (T 22) => "EOF"
  | (T 23) => "EQUALOP"
  | (T 24) => "EQTYPE"
  | (T 25) => "EXCEPTION"
  | (T 26) => "DO"
  | (T 27) => "DARROW"
  | (T 28) => "FN"
  | (T 29) => "FUN"
  | (T 30) => "FUNCTOR"
  | (T 31) => "HANDLE"
  | (T 32) => "HASH"
  | (T 33) => "IF"
  | (T 34) => "IN"
  | (T 35) => "INCLUDE"
  | (T 36) => "INFIX"
  | (T 37) => "INFIXR"
  | (T 38) => "LBRACE"
  | (T 39) => "LBRACKET"
  | (T 40) => "LET"
  | (T 41) => "LOCAL"
  | (T 42) => "LPAREN"
  | (T 43) => "NONFIX"
  | (T 44) => "ORELSE"
  | (T 45) => "OF"
  | (T 46) => "OP"
  | (T 47) => "OPEN"
  | (T 48) => "OVERLOAD"
  | (T 49) => "RAISE"
  | (T 50) => "RBRACE"
  | (T 51) => "RBRACKET"
  | (T 52) => "REC"
  | (T 53) => "RPAREN"
  | (T 54) => "SEMICOLON"
  | (T 55) => "SHARING"
  | (T 56) => "SIG"
  | (T 57) => "SIGNATURE"
  | (T 58) => "STRUCT"
  | (T 59) => "STRUCTURE"
  | (T 60) => "THEN"
  | (T 61) => "TYPE"
  | (T 62) => "VAL"
  | (T 63) => "WHERE"
  | (T 64) => "WHILE"
  | (T 65) => "WILD"
  | (T 66) => "WITH"
  | (T 67) => "WITHTYPE"
  | (T 68) => "BUILD_CONST"
  | (T 69) => "COMMAND_LINE_CONST"
  | (T 70) => "CONST"
  | (T 71) => "ADDRESS"
  | (T 72) => "EXPORT"
  | (T 73) => "IMPORT"
  | (T 74) => "SYMBOL"
  | (T 75) => "PRIM"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 0) => MlyValue.CHAR(fn () => (IntInf.fromInt (Char.ord #"a"))) | 
(T 1) => MlyValue.INT(fn () => (
{digits = "0", negate = false, radix = StringCvt.DEC})) | 
(T 2) => MlyValue.LONGID(fn () => ("bogus")) | 
(T 3) => MlyValue.REAL(fn () => ("13.0")) | 
(T 4) => MlyValue.STRING(fn () => (Vector.fromList [])) | 
(T 5) => MlyValue.TYVAR(fn () => ("'a")) | 
(T 6) => MlyValue.WORD(fn () => ({digits = "0", radix = StringCvt.DEC}
)) | 
_ => MlyValue.VOID
end
val terms : term list = nil
 $$ (T 75) $$ (T 74) $$ (T 73) $$ (T 72) $$ (T 71) $$ (T 70) $$ (T 69)
 $$ (T 68) $$ (T 67) $$ (T 66) $$ (T 65) $$ (T 64) $$ (T 63) $$ (T 62)
 $$ (T 61) $$ (T 60) $$ (T 59) $$ (T 58) $$ (T 57) $$ (T 56) $$ (T 55)
 $$ (T 54) $$ (T 53) $$ (T 52) $$ (T 51) $$ (T 50) $$ (T 49) $$ (T 48)
 $$ (T 47) $$ (T 46) $$ (T 45) $$ (T 44) $$ (T 43) $$ (T 42) $$ (T 41)
 $$ (T 40) $$ (T 39) $$ (T 38) $$ (T 37) $$ (T 36) $$ (T 35) $$ (T 34)
 $$ (T 33) $$ (T 32) $$ (T 31) $$ (T 30) $$ (T 29) $$ (T 28) $$ (T 27)
 $$ (T 26) $$ (T 25) $$ (T 24) $$ (T 23) $$ (T 22) $$ (T 21) $$ (T 20)
 $$ (T 19) $$ (T 18) $$ (T 17) $$ (T 16) $$ (T 15) $$ (T 14) $$ (T 13)
 $$ (T 12) $$ (T 11) $$ (T 10) $$ (T 9) $$ (T 8) $$ (T 7)end
structure Actions =
struct 
type int = Int.int
exception mlyAction of int
local open Header in
val actions = 
fn (i392:int,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of  ( 0, ( ( _, ( MlyValue.expsAndTopdecs expsAndTopdecs1, 
expsAndTopdecs1left, expsAndTopdecs1right)) :: rest671)) => let val  
result = MlyValue.program (fn _ => let val  (expsAndTopdecs as 
expsAndTopdecs1) = expsAndTopdecs1 ()
 in (Program.T expsAndTopdecs)
end)
 in ( LrTable.NT 88, ( result, expsAndTopdecs1left, 
expsAndTopdecs1right), rest671)
end
|  ( 1, ( ( _, ( MlyValue.expsAndTopdecs expsAndTopdecs1, _, 
expsAndTopdecs1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _))
 :: rest671)) => let val  result = MlyValue.expsAndTopdecs (fn _ =>
 let val  (exp as exp1) = exp1 ()
 val  (expsAndTopdecs as expsAndTopdecs1) = expsAndTopdecs1 ()
 in ([Topdec.fromExp exp] :: expsAndTopdecs)
end)
 in ( LrTable.NT 49, ( result, exp1left, expsAndTopdecs1right), 
rest671)
end
|  ( 2, ( ( _, ( MlyValue.topdecs topdecs1, topdecs1left, 
topdecs1right)) :: rest671)) => let val  result = 
MlyValue.expsAndTopdecs (fn _ => let val  (topdecs as topdecs1) = 
topdecs1 ()
 in (topdecs)
end)
 in ( LrTable.NT 49, ( result, topdecs1left, topdecs1right), rest671)

end
|  ( 3, ( rest671)) => let val  result = MlyValue.topdecs (fn _ => ([]
))
 in ( LrTable.NT 135, ( result, defaultPos, defaultPos), rest671)
end
|  ( 4, ( ( _, ( MlyValue.topdecs topdecs1, _, topdecs1right)) :: ( _,
 ( MlyValue.topdec topdec1, topdec1left, _)) :: rest671)) => let val  
result = MlyValue.topdecs (fn _ => let val  (topdec as topdec1) = 
topdec1 ()
 val  (topdecs as topdecs1) = topdecs1 ()
 in (consTopdec (topdec, topdecs))
end)
 in ( LrTable.NT 135, ( result, topdec1left, topdecs1right), rest671)

end
|  ( 5, ( ( _, ( MlyValue.expsAndTopdecs expsAndTopdecs1, _, 
expsAndTopdecs1right)) :: ( _, ( _, SEMICOLON1left, _)) :: rest671))
 => let val  result = MlyValue.topdecs (fn _ => let val  (
expsAndTopdecs as expsAndTopdecs1) = expsAndTopdecs1 ()
 in ([] :: expsAndTopdecs)
end)
 in ( LrTable.NT 135, ( result, SEMICOLON1left, expsAndTopdecs1right),
 rest671)
end
|  ( 6, ( ( _, ( MlyValue.topdecnode topdecnode1, (topdecnodeleft as 
topdecnode1left), (topdecnoderight as topdecnode1right))) :: rest671))
 => let val  result = MlyValue.topdec (fn _ => let val  (topdecnode
 as topdecnode1) = topdecnode1 ()
 in (
Topdec.makeRegion' (topdecnode,
                                         topdecnodeleft,
                                         topdecnoderight)
)
end)
 in ( LrTable.NT 133, ( result, topdecnode1left, topdecnode1right), 
rest671)
end
|  ( 7, ( ( _, ( MlyValue.strdec strdec1, strdec1left, strdec1right))
 :: rest671)) => let val  result = MlyValue.topdecnode (fn _ => let
 val  (strdec as strdec1) = strdec1 ()
 in (Topdec.Strdec strdec)
end)
 in ( LrTable.NT 134, ( result, strdec1left, strdec1right), rest671)

end
|  ( 8, ( ( _, ( MlyValue.sigbinds sigbinds1, _, sigbinds1right)) :: (
 _, ( _, SIGNATURE1left, _)) :: rest671)) => let val  result = 
MlyValue.topdecnode (fn _ => let val  (sigbinds as sigbinds1) = 
sigbinds1 ()
 in (
let
         val sigbinds = Vector.fromList sigbinds
         val d = Topdec.Signature sigbinds
      in
         d
      end
)
end)
 in ( LrTable.NT 134, ( result, SIGNATURE1left, sigbinds1right), 
rest671)
end
|  ( 9, ( ( _, ( MlyValue.funbinds funbinds1, _, funbinds1right)) :: (
 _, ( _, FUNCTOR1left, _)) :: rest671)) => let val  result = 
MlyValue.topdecnode (fn _ => let val  (funbinds as funbinds1) = 
funbinds1 ()
 in (Topdec.Functor (Vector.fromList funbinds))
end)
 in ( LrTable.NT 134, ( result, FUNCTOR1left, funbinds1right), rest671
)
end
|  ( 10, ( ( _, ( MlyValue.strdecsnode strdecsnode1, (strdecsnodeleft
 as strdecsnode1left), (strdecsnoderight as strdecsnode1right))) :: 
rest671)) => let val  result = MlyValue.strdecs (fn _ => let val  (
strdecsnode as strdecsnode1) = strdecsnode1 ()
 in (
Strdec.makeRegion'
                       (strdecsnode, strdecsnodeleft, strdecsnoderight)
)
end)
 in ( LrTable.NT 118, ( result, strdecsnode1left, strdecsnode1right), 
rest671)
end
|  ( 11, ( rest671)) => let val  result = MlyValue.strdecsnode (fn _
 => (Strdec.Seq []))
 in ( LrTable.NT 119, ( result, defaultPos, defaultPos), rest671)
end
|  ( 12, ( ( _, ( MlyValue.strdecs strdecs1, _, strdecs1right)) :: ( _
, ( _, SEMICOLON1left, _)) :: rest671)) => let val  result = 
MlyValue.strdecsnode (fn _ => let val  (strdecs as strdecs1) = 
strdecs1 ()
 in (Strdec.Seq [strdecs])
end)
 in ( LrTable.NT 119, ( result, SEMICOLON1left, strdecs1right), 
rest671)
end
|  ( 13, ( ( _, ( MlyValue.strdecs strdecs1, _, strdecs1right)) :: ( _
, ( MlyValue.strdec strdec1, strdec1left, _)) :: rest671)) => let val 
 result = MlyValue.strdecsnode (fn _ => let val  (strdec as strdec1) =
 strdec1 ()
 val  (strdecs as strdecs1) = strdecs1 ()
 in (Strdec.Seq [strdec, strdecs])
end)
 in ( LrTable.NT 119, ( result, strdec1left, strdecs1right), rest671)

end
|  ( 14, ( ( _, ( MlyValue.strdecnode strdecnode1, (strdecnodeleft as 
strdecnode1left), (strdecnoderight as strdecnode1right))) :: rest671))
 => let val  result = MlyValue.strdec (fn _ => let val  (strdecnode
 as strdecnode1) = strdecnode1 ()
 in (
Strdec.makeRegion' (strdecnode,
                                         strdecnodeleft, strdecnoderight)
)
end)
 in ( LrTable.NT 116, ( result, strdecnode1left, strdecnode1right), 
rest671)
end
|  ( 15, ( ( _, ( MlyValue.strbinds strbinds1, _, strbinds1right)) :: 
( _, ( _, STRUCTURE1left, _)) :: rest671)) => let val  result = 
MlyValue.strdecnode (fn _ => let val  (strbinds as strbinds1) = 
strbinds1 ()
 in (
let
         val strbinds = Vector.fromList strbinds
         val d = Strdec.Structure strbinds



      in
         d
      end
)
end)
 in ( LrTable.NT 117, ( result, STRUCTURE1left, strbinds1right), 
rest671)
end
|  ( 16, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strdecs 
strdecs2, _, _)) :: _ :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: (
 _, ( _, LOCAL1left, _)) :: rest671)) => let val  result = 
MlyValue.strdecnode (fn _ => let val  strdecs1 = strdecs1 ()
 val  strdecs2 = strdecs2 ()
 in (Strdec.Local (strdecs1, strdecs2))
end)
 in ( LrTable.NT 117, ( result, LOCAL1left, END1right), rest671)
end
|  ( 17, ( ( _, ( MlyValue.decnolocal decnolocal1, (decnolocalleft as 
decnolocal1left), (decnolocalright as decnolocal1right))) :: rest671))
 => let val  result = MlyValue.strdecnode (fn _ => let val  (
decnolocal as decnolocal1) = decnolocal1 ()
 in (
Strdec.Core (Dec.makeRegion' (decnolocal,
                                    decnolocalleft, decnolocalright))
)
end)
 in ( LrTable.NT 117, ( result, decnolocal1left, decnolocal1right), 
rest671)
end
|  ( 18, ( ( _, ( MlyValue.strbinds' strbinds'1, _, strbinds'1right))
 :: _ :: ( _, ( MlyValue.sigconst sigconst1, _, _)) :: ( _, ( 
MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val  result
 = MlyValue.strbinds (fn _ => let val  (strid as strid1) = strid1 ()
 val  (sigconst as sigconst1) = sigconst1 ()
 val  (strbinds' as strbinds'1) = strbinds'1 ()
 in (
let val (def,strbinds) = strbinds'
            in {name = strid, def = def, constraint = sigconst}
               :: strbinds
            end
)
end)
 in ( LrTable.NT 111, ( result, strid1left, strbinds'1right), rest671)

end
|  ( 19, ( ( _, ( MlyValue.strbinds'1 strbinds'11, _, strbinds'11right
)) :: ( _, ( MlyValue.strexp1 strexp11, strexp11left, _)) :: rest671))
 => let val  result = MlyValue.strbinds' (fn _ => let val  (strexp1
 as strexp11) = strexp11 ()
 val  (strbinds'1 as strbinds'11) = strbinds'11 ()
 in (augment1 (strexp1, strbinds'1))
end)
 in ( LrTable.NT 112, ( result, strexp11left, strbinds'11right), 
rest671)
end
|  ( 20, ( ( _, ( MlyValue.strbinds'2 strbinds'21, _, strbinds'21right
)) :: ( _, ( MlyValue.strexp2 strexp21, strexp21left, _)) :: rest671))
 => let val  result = MlyValue.strbinds' (fn _ => let val  (strexp2
 as strexp21) = strexp21 ()
 val  (strbinds'2 as strbinds'21) = strbinds'21 ()
 in ((strexp2,strbinds'2))
end)
 in ( LrTable.NT 112, ( result, strexp21left, strbinds'21right), 
rest671)
end
|  ( 21, ( ( _, ( MlyValue.strbinds'2 strbinds'21, (strbinds'2left as 
strbinds'21left), strbinds'21right)) :: rest671)) => let val  result =
 MlyValue.strbinds'1 (fn _ => let val  (strbinds'2 as strbinds'21) = 
strbinds'21 ()
 in (([], strbinds'2left, strbinds'2))
end)
 in ( LrTable.NT 113, ( result, strbinds'21left, strbinds'21right), 
rest671)
end
|  ( 22, ( ( _, ( MlyValue.strbinds'1' strbinds'1'1, _, 
strbinds'1'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, WHERE1left, _)) :: rest671)) => let val  result = 
MlyValue.strbinds'1 (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (strbinds'1' as strbinds'1'1) = strbinds'1'1 ()
 in (cons1 (wherespec,strbinds'1'))
end)
 in ( LrTable.NT 113, ( result, WHERE1left, strbinds'1'1right), 
rest671)
end
|  ( 23, ( ( _, ( MlyValue.strbinds'1 strbinds'11, strbinds'11left, 
strbinds'11right)) :: rest671)) => let val  result = 
MlyValue.strbinds'1' (fn _ => let val  (strbinds'1 as strbinds'11) = 
strbinds'11 ()
 in (strbinds'1)
end)
 in ( LrTable.NT 114, ( result, strbinds'11left, strbinds'11right), 
rest671)
end
|  ( 24, ( ( _, ( MlyValue.strbinds'1' strbinds'1'1, _, 
strbinds'1'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.strbinds'1' (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (strbinds'1' as strbinds'1'1) = strbinds'1'1 ()
 in (cons1 (wherespec,strbinds'1'))
end)
 in ( LrTable.NT 114, ( result, AND1left, strbinds'1'1right), rest671)

end
|  ( 25, ( rest671)) => let val  result = MlyValue.strbinds'2 (fn _ =>
 ([]))
 in ( LrTable.NT 115, ( result, defaultPos, defaultPos), rest671)
end
|  ( 26, ( ( _, ( MlyValue.strbinds strbinds1, _, strbinds1right)) :: 
( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.strbinds'2 (fn _ => let val  (strbinds as strbinds1) = 
strbinds1 ()
 in (strbinds)
end)
 in ( LrTable.NT 115, ( result, AND1left, strbinds1right), rest671)

end
|  ( 27, ( ( _, ( MlyValue.strexpnode strexpnode1, (strexpnodeleft as 
strexpnode1left), (strexpnoderight as strexpnode1right))) :: rest671))
 => let val  result = MlyValue.strexp (fn _ => let val  (strexpnode
 as strexpnode1) = strexpnode1 ()
 in (
Strexp.makeRegion' (strexpnode,
                                        strexpnodeleft, strexpnoderight)
)
end)
 in ( LrTable.NT 123, ( result, strexpnode1left, strexpnode1right), 
rest671)
end
|  ( 28, ( ( _, ( MlyValue.strexp1 strexp11, strexp11left, 
strexp11right)) :: rest671)) => let val  result = MlyValue.strexpnode
 (fn _ => let val  (strexp1 as strexp11) = strexp11 ()
 in (
let
        val (strexp, sigconst, sigexp) = strexp1
     in
        Strexp.Constrained (strexp, sigconst sigexp)
     end
)
end)
 in ( LrTable.NT 127, ( result, strexp11left, strexp11right), rest671)

end
|  ( 29, ( ( _, ( MlyValue.wherespecs wherespecs1, _, (wherespecsright
 as wherespecs1right))) :: ( _, ( MlyValue.strexp1 strexp11, 
strexp11left, _)) :: rest671)) => let val  result = 
MlyValue.strexpnode (fn _ => let val  (strexp1 as strexp11) = strexp11
 ()
 val  (wherespecs as wherespecs1) = wherespecs1 ()
 in (
let
        val (strexp,sigconst,sigexp) = strexp1
     in
        Strexp.Constrained
        (strexp,
         sigconst (Sigexp.wheree
                   (sigexp, wherespecs,
                    Region.extendRight (Sigexp.region sigexp,
                                        wherespecsright))))
     end
)
end)
 in ( LrTable.NT 127, ( result, strexp11left, wherespecs1right), 
rest671)
end
|  ( 30, ( ( _, ( MlyValue.strexp2node strexp2node1, strexp2node1left,
 strexp2node1right)) :: rest671)) => let val  result = 
MlyValue.strexpnode (fn _ => let val  (strexp2node as strexp2node1) = 
strexp2node1 ()
 in (strexp2node)
end)
 in ( LrTable.NT 127, ( result, strexp2node1left, strexp2node1right), 
rest671)
end
|  ( 31, ( ( _, ( MlyValue.sigexp' sigexp'1, _, sigexp'1right)) :: _
 :: ( _, ( MlyValue.strexp strexp1, strexp1left, _)) :: rest671)) =>
 let val  result = MlyValue.strexp1 (fn _ => let val  (strexp as 
strexp1) = strexp1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 in ((strexp,SigConst.Transparent,sigexp'))
end)
 in ( LrTable.NT 124, ( result, strexp1left, sigexp'1right), rest671)

end
|  ( 32, ( ( _, ( MlyValue.sigexp' sigexp'1, _, sigexp'1right)) :: _
 :: ( _, ( MlyValue.strexp strexp1, strexp1left, _)) :: rest671)) =>
 let val  result = MlyValue.strexp1 (fn _ => let val  (strexp as 
strexp1) = strexp1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 in ((strexp,SigConst.Opaque,sigexp'))
end)
 in ( LrTable.NT 124, ( result, strexp1left, sigexp'1right), rest671)

end
|  ( 33, ( ( _, ( MlyValue.strexp2node strexp2node1, (strexp2nodeleft
 as strexp2node1left), (strexp2noderight as strexp2node1right))) :: 
rest671)) => let val  result = MlyValue.strexp2 (fn _ => let val  (
strexp2node as strexp2node1) = strexp2node1 ()
 in (
Strexp.makeRegion'
                       (strexp2node, strexp2nodeleft, strexp2noderight)
)
end)
 in ( LrTable.NT 125, ( result, strexp2node1left, strexp2node1right), 
rest671)
end
|  ( 34, ( ( _, ( MlyValue.longid longid1, longid1left, longid1right))
 :: rest671)) => let val  result = MlyValue.strexp2node (fn _ => let
 val  (longid as longid1) = longid1 ()
 in (Strexp.Var (Longstrid.fromSymbols longid))
end)
 in ( LrTable.NT 126, ( result, longid1left, longid1right), rest671)

end
|  ( 35, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strdecs 
strdecs1, _, _)) :: ( _, ( _, STRUCT1left, _)) :: rest671)) => let
 val  result = MlyValue.strexp2node (fn _ => let val  (strdecs as 
strdecs1) = strdecs1 ()
 in (Strexp.Struct strdecs)
end)
 in ( LrTable.NT 126, ( result, STRUCT1left, END1right), rest671)
end
|  ( 36, ( ( _, ( MlyValue.arg_fct arg_fct1, _, arg_fct1right)) :: ( _
, ( MlyValue.longid longid1, longid1left, _)) :: rest671)) => let val 
 result = MlyValue.strexp2node (fn _ => let val  (longid as longid1) =
 longid1 ()
 val  (arg_fct as arg_fct1) = arg_fct1 ()
 in (
Strexp.App (Fctid.fromSymbol (ensureNonqualified longid), arg_fct))

end)
 in ( LrTable.NT 126, ( result, longid1left, arg_fct1right), rest671)

end
|  ( 37, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strexp strexp1,
 _, _)) :: _ :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: ( _, ( _, 
LET1left, _)) :: rest671)) => let val  result = MlyValue.strexp2node
 (fn _ => let val  (strdecs as strdecs1) = strdecs1 ()
 val  (strexp as strexp1) = strexp1 ()
 in (Strexp.Let (strdecs,strexp))
end)
 in ( LrTable.NT 126, ( result, LET1left, END1right), rest671)
end
|  ( 38, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.strexp 
strexp1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val 
 result = MlyValue.arg_fct (fn _ => let val  (strexp as strexp1) = 
strexp1 ()
 in (strexp)
end)
 in ( LrTable.NT 8, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 39, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.strdecs 
strdecs1, strdecsleft, strdecsright)) :: ( _, ( _, LPAREN1left, _)) ::
 rest671)) => let val  result = MlyValue.arg_fct (fn _ => let val  (
strdecs as strdecs1) = strdecs1 ()
 in (
Strexp.makeRegion'
                                  (Strexp.Struct strdecs,
                                   strdecsleft, strdecsright)
)
end)
 in ( LrTable.NT 8, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 40, ( ( _, ( MlyValue.sigexp' sigexp'1, sigexp'1left, 
sigexp'1right)) :: rest671)) => let val  result = MlyValue.sigexp (fn
 _ => let val  (sigexp' as sigexp'1) = sigexp'1 ()
 in (sigexp')
end)
 in ( LrTable.NT 102, ( result, sigexp'1left, sigexp'1right), rest671)

end
|  ( 41, ( ( _, ( MlyValue.wherespecs wherespecs1, _, (wherespecsright
 as wherespecs1right))) :: ( _, ( MlyValue.sigexp' sigexp'1, (
sigexp'left as sigexp'1left), _)) :: rest671)) => let val  result = 
MlyValue.sigexp (fn _ => let val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (wherespecs as wherespecs1) = wherespecs1 ()
 in (
Sigexp.wheree (sigexp', wherespecs, reg (sigexp'left, wherespecsright))
)
end)
 in ( LrTable.NT 102, ( result, sigexp'1left, wherespecs1right), 
rest671)
end
|  ( 42, ( ( _, ( MlyValue.wherespecs' wherespecs'1, wherespecs'1left,
 wherespecs'1right)) :: rest671)) => let val  result = 
MlyValue.wherespecs (fn _ => let val  (wherespecs' as wherespecs'1) = 
wherespecs'1 ()
 in (Vector.fromList wherespecs')
end)
 in ( LrTable.NT 164, ( result, wherespecs'1left, wherespecs'1right), 
rest671)
end
|  ( 43, ( ( _, ( MlyValue.wherespec wherespec1, _, wherespec1right))
 :: ( _, ( _, WHERE1left, _)) :: rest671)) => let val  result = 
MlyValue.wherespecs' (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 in ([wherespec])
end)
 in ( LrTable.NT 165, ( result, WHERE1left, wherespec1right), rest671)

end
|  ( 44, ( ( _, ( MlyValue.wherespecs' wherespecs'1, _, 
wherespecs'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, WHERE1left, _)) :: rest671)) => let val  result = 
MlyValue.wherespecs' (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (wherespecs' as wherespecs'1) = wherespecs'1 ()
 in (wherespec :: wherespecs')
end)
 in ( LrTable.NT 165, ( result, WHERE1left, wherespecs'1right), 
rest671)
end
|  ( 45, ( ( _, ( MlyValue.andspecs andspecs1, _, andspecs1right)) :: 
( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, WHERE1left,
 _)) :: rest671)) => let val  result = MlyValue.wherespecs' (fn _ =>
 let val  (wherespec as wherespec1) = wherespec1 ()
 val  (andspecs as andspecs1) = andspecs1 ()
 in (wherespec :: andspecs)
end)
 in ( LrTable.NT 165, ( result, WHERE1left, andspecs1right), rest671)

end
|  ( 46, ( ( _, ( MlyValue.wherespec wherespec1, _, wherespec1right))
 :: ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.andspecs (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 in ([wherespec])
end)
 in ( LrTable.NT 1, ( result, AND1left, wherespec1right), rest671)
end
|  ( 47, ( ( _, ( MlyValue.andspecs andspecs1, _, andspecs1right)) :: 
( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, AND1left, _)
) :: rest671)) => let val  result = MlyValue.andspecs (fn _ => let
 val  (wherespec as wherespec1) = wherespec1 ()
 val  (andspecs as andspecs1) = andspecs1 ()
 in (wherespec :: andspecs)
end)
 in ( LrTable.NT 1, ( result, AND1left, andspecs1right), rest671)
end
|  ( 48, ( ( _, ( MlyValue.wherespecs' wherespecs'1, _, 
wherespecs'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.andspecs (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (wherespecs' as wherespecs'1) = wherespecs'1 ()
 in (wherespec :: wherespecs')
end)
 in ( LrTable.NT 1, ( result, AND1left, wherespecs'1right), rest671)

end
|  ( 49, ( ( _, ( MlyValue.sigbinds' sigbinds'1, _, sigbinds'1right))
 :: ( _, ( MlyValue.sigexp' sigexp'1, _, _)) :: _ :: ( _, ( 
MlyValue.sigid sigid1, sigid1left, _)) :: rest671)) => let val  result
 = MlyValue.sigbinds (fn _ => let val  (sigid as sigid1) = sigid1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (sigbinds' as sigbinds'1) = sigbinds'1 ()
 in (augment (sigid, sigexp', sigbinds'))
end)
 in ( LrTable.NT 98, ( result, sigid1left, sigbinds'1right), rest671)

end
|  ( 50, ( ( _, ( MlyValue.sigexp'node sigexp'node1, (sigexp'nodeleft
 as sigexp'node1left), (sigexp'noderight as sigexp'node1right))) :: 
rest671)) => let val  result = MlyValue.sigexp' (fn _ => let val  (
sigexp'node as sigexp'node1) = sigexp'node1 ()
 in (
Sigexp.makeRegion' (sigexp'node,
                                          sigexp'nodeleft,
                                          sigexp'noderight)
)
end)
 in ( LrTable.NT 103, ( result, sigexp'node1left, sigexp'node1right), 
rest671)
end
|  ( 51, ( ( _, ( MlyValue.sigid sigid1, sigid1left, sigid1right)) :: 
rest671)) => let val  result = MlyValue.sigexp'node (fn _ => let val 
 (sigid as sigid1) = sigid1 ()
 in (Sigexp.Var sigid)
end)
 in ( LrTable.NT 104, ( result, sigid1left, sigid1right), rest671)
end
|  ( 52, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.specs specs1, _
, _)) :: ( _, ( _, SIG1left, _)) :: rest671)) => let val  result = 
MlyValue.sigexp'node (fn _ => let val  (specs as specs1) = specs1 ()
 in (Sigexp.Spec specs)
end)
 in ( LrTable.NT 104, ( result, SIG1left, END1right), rest671)
end
|  ( 53, ( rest671)) => let val  result = MlyValue.sigbinds' (fn _ =>
 (([], defaultPos, [])))
 in ( LrTable.NT 99, ( result, defaultPos, defaultPos), rest671)
end
|  ( 54, ( ( _, ( MlyValue.sigbinds sigbinds1, _, sigbinds1right)) :: 
( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.sigbinds' (fn _ => let val  (sigbinds as sigbinds1) = 
sigbinds1 ()
 in (([], defaultPos, sigbinds))
end)
 in ( LrTable.NT 99, ( result, AND1left, sigbinds1right), rest671)
end
|  ( 55, ( ( _, ( MlyValue.sigbinds'' sigbinds''1, _, sigbinds''1right
)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, 
WHERE1left, _)) :: rest671)) => let val  result = MlyValue.sigbinds'
 (fn _ => let val  (wherespec as wherespec1) = wherespec1 ()
 val  (sigbinds'' as sigbinds''1) = sigbinds''1 ()
 in (cons1 (wherespec,sigbinds''))
end)
 in ( LrTable.NT 99, ( result, WHERE1left, sigbinds''1right), rest671)

end
|  ( 56, ( ( _, ( MlyValue.sigbinds' sigbinds'1, sigbinds'1left, 
sigbinds'1right)) :: rest671)) => let val  result = 
MlyValue.sigbinds'' (fn _ => let val  (sigbinds' as sigbinds'1) = 
sigbinds'1 ()
 in (sigbinds')
end)
 in ( LrTable.NT 100, ( result, sigbinds'1left, sigbinds'1right), 
rest671)
end
|  ( 57, ( ( _, ( MlyValue.sigbinds'' sigbinds''1, _, sigbinds''1right
)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, 
AND1left, _)) :: rest671)) => let val  result = MlyValue.sigbinds''
 (fn _ => let val  (wherespec as wherespec1) = wherespec1 ()
 val  (sigbinds'' as sigbinds''1) = sigbinds''1 ()
 in (cons1 (wherespec,sigbinds''))
end)
 in ( LrTable.NT 100, ( result, AND1left, sigbinds''1right), rest671)

end
|  ( 58, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.longtycon longtycon1, _, _)) :: ( _, ( MlyValue.tyvars 
tyvars1, _, _)) :: ( _, ( _, TYPE1left, _)) :: rest671)) => let val  
result = MlyValue.wherespec (fn _ => let val  (tyvars as tyvars1) = 
tyvars1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 val  (ty as ty1) = ty1 ()
 in (
{tyvars = tyvars,
                                                 longtycon = longtycon,
                                                 ty = ty}
)
end)
 in ( LrTable.NT 163, ( result, TYPE1left, ty1right), rest671)
end
|  ( 59, ( rest671)) => let val  result = MlyValue.sigconst (fn _ => (
SigConst.None))
 in ( LrTable.NT 101, ( result, defaultPos, defaultPos), rest671)
end
|  ( 60, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, (
 _, COLON1left, _)) :: rest671)) => let val  result = 
MlyValue.sigconst (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in (SigConst.Transparent sigexp)
end)
 in ( LrTable.NT 101, ( result, COLON1left, sigexp1right), rest671)

end
|  ( 61, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, (
 _, COLONGT1left, _)) :: rest671)) => let val  result = 
MlyValue.sigconst (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in (SigConst.Opaque sigexp)
end)
 in ( LrTable.NT 101, ( result, COLONGT1left, sigexp1right), rest671)

end
|  ( 62, ( rest671)) => let val  result = MlyValue.specs (fn _ => (
Spec.makeRegion (Spec.Empty, Region.bogus)))
 in ( LrTable.NT 110, ( result, defaultPos, defaultPos), rest671)
end
|  ( 63, ( ( _, ( MlyValue.specs specs1, _, specs1right)) :: ( _, ( _,
 SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.specs
 (fn _ => let val  (specs as specs1) = specs1 ()
 in (specs)
end)
 in ( LrTable.NT 110, ( result, SEMICOLON1left, specs1right), rest671)

end
|  ( 64, ( ( _, ( MlyValue.specs specs1, _, specs1right)) :: ( _, ( 
MlyValue.spec spec1, spec1left, _)) :: rest671)) => let val  result = 
MlyValue.specs (fn _ => let val  (spec as spec1) = spec1 ()
 val  (specs as specs1) = specs1 ()
 in (Spec.seq (spec, specs))
end)
 in ( LrTable.NT 110, ( result, spec1left, specs1right), rest671)
end
|  ( 65, ( ( _, ( MlyValue.specnode specnode1, (specnodeleft as 
specnode1left), (specnoderight as specnode1right))) :: rest671)) =>
 let val  result = MlyValue.spec (fn _ => let val  (specnode as 
specnode1) = specnode1 ()
 in (Spec.makeRegion' (specnode, specnodeleft, specnoderight))
end)
 in ( LrTable.NT 108, ( result, specnode1left, specnode1right), 
rest671)
end
|  ( 66, ( ( _, ( MlyValue.valdescs valdescs1, _, valdescs1right)) :: 
( _, ( _, VAL1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (valdescs as valdescs1) = 
valdescs1 ()
 in (Spec.Val (Vector.fromList valdescs))
end)
 in ( LrTable.NT 109, ( result, VAL1left, valdescs1right), rest671)

end
|  ( 67, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) :: 
( _, ( _, TYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (typdescs as typdescs1) = 
typdescs1 ()
 in (Spec.Type (Vector.fromList typdescs))
end)
 in ( LrTable.NT 109, ( result, TYPE1left, typdescs1right), rest671)

end
|  ( 68, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: ( _
, ( _, TYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (typBind as typBind1) = typBind1
 ()
 in (Spec.TypeDefs typBind)
end)
 in ( LrTable.NT 109, ( result, TYPE1left, typBind1right), rest671)

end
|  ( 69, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) :: 
( _, ( _, EQTYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (typdescs as typdescs1) = 
typdescs1 ()
 in (Spec.Eqtype (Vector.fromList typdescs))
end)
 in ( LrTable.NT 109, ( result, EQTYPE1left, typdescs1right), rest671)

end
|  ( 70, ( ( _, ( MlyValue.datatypeRhsNoWithtype 
datatypeRhsNoWithtype1, _, datatypeRhsNoWithtype1right)) :: ( _, ( _, 
DATATYPE1left, _)) :: rest671)) => let val  result = MlyValue.specnode
 (fn _ => let val  (datatypeRhsNoWithtype as datatypeRhsNoWithtype1) =
 datatypeRhsNoWithtype1 ()
 in (Spec.Datatype datatypeRhsNoWithtype)
end)
 in ( LrTable.NT 109, ( result, DATATYPE1left, 
datatypeRhsNoWithtype1right), rest671)
end
|  ( 71, ( ( _, ( MlyValue.exndescs exndescs1, _, exndescs1right)) :: 
( _, ( _, EXCEPTION1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (exndescs as exndescs1) = 
exndescs1 ()
 in (Spec.Exception (Vector.fromList exndescs))
end)
 in ( LrTable.NT 109, ( result, EXCEPTION1left, exndescs1right), 
rest671)
end
|  ( 72, ( ( _, ( MlyValue.strdescs strdescs1, _, strdescs1right)) :: 
( _, ( _, STRUCTURE1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (strdescs as strdescs1) = 
strdescs1 ()
 in (Spec.Structure (Vector.fromList strdescs))
end)
 in ( LrTable.NT 109, ( result, STRUCTURE1left, strdescs1right), 
rest671)
end
|  ( 73, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, (
 _, INCLUDE1left, _)) :: rest671)) => let val  result = 
MlyValue.specnode (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in (Spec.IncludeSigexp sigexp)
end)
 in ( LrTable.NT 109, ( result, INCLUDE1left, sigexp1right), rest671)

end
|  ( 74, ( ( _, ( MlyValue.sigids sigids1, _, sigids1right)) :: ( _, (
 MlyValue.sigid sigid1, _, _)) :: ( _, ( _, INCLUDE1left, _)) :: 
rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (
sigid as sigid1) = sigid1 ()
 val  (sigids as sigids1) = sigids1 ()
 in (Spec.IncludeSigids (Vector.fromList (sigid :: sigids)) )
end)
 in ( LrTable.NT 109, ( result, INCLUDE1left, sigids1right), rest671)

end
|  ( 75, ( ( _, ( MlyValue.sharespec sharespec1, (sharespecleft as 
sharespec1left), (sharespecright as sharespec1right))) :: rest671)) =>
 let val  result = MlyValue.specnode (fn _ => let val  (sharespec as 
sharespec1) = sharespec1 ()
 in (
Spec.Sharing {spec = Spec.makeRegion' (Spec.Empty,
                                                   sharespecleft,
                                                   sharespecright),
                          equations = (Vector.new1
                                       (Equation.makeRegion' (sharespec,
                                                              sharespecleft,
                                                              sharespecright)))}
)
end)
 in ( LrTable.NT 109, ( result, sharespec1left, sharespec1right), 
rest671)
end
|  ( 76, ( ( _, ( MlyValue.longtyconeqns longtyconeqns1, _, 
longtyconeqns1right)) :: _ :: ( _, ( _, SHARING1left, _)) :: rest671))
 => let val  result = MlyValue.sharespec (fn _ => let val  (
longtyconeqns as longtyconeqns1) = longtyconeqns1 ()
 in (Equation.Type longtyconeqns)
end)
 in ( LrTable.NT 97, ( result, SHARING1left, longtyconeqns1right), 
rest671)
end
|  ( 77, ( ( _, ( MlyValue.longstrideqns longstrideqns1, _, 
longstrideqns1right)) :: ( _, ( _, SHARING1left, _)) :: rest671)) =>
 let val  result = MlyValue.sharespec (fn _ => let val  (longstrideqns
 as longstrideqns1) = longstrideqns1 ()
 in (Equation.Structure longstrideqns)
end)
 in ( LrTable.NT 97, ( result, SHARING1left, longstrideqns1right), 
rest671)
end
|  ( 78, ( ( _, ( MlyValue.longstrid longstrid2, _, longstrid2right))
 :: _ :: ( _, ( MlyValue.longstrid longstrid1, longstrid1left, _)) :: 
rest671)) => let val  result = MlyValue.longstrideqns (fn _ => let
 val  longstrid1 = longstrid1 ()
 val  longstrid2 = longstrid2 ()
 in ([longstrid1,longstrid2])
end)
 in ( LrTable.NT 69, ( result, longstrid1left, longstrid2right), 
rest671)
end
|  ( 79, ( ( _, ( MlyValue.longstrideqns longstrideqns1, _, 
longstrideqns1right)) :: _ :: ( _, ( MlyValue.longstrid longstrid1, 
longstrid1left, _)) :: rest671)) => let val  result = 
MlyValue.longstrideqns (fn _ => let val  (longstrid as longstrid1) = 
longstrid1 ()
 val  (longstrideqns as longstrideqns1) = longstrideqns1 ()
 in (longstrid :: longstrideqns)
end)
 in ( LrTable.NT 69, ( result, longstrid1left, longstrideqns1right), 
rest671)
end
|  ( 80, ( ( _, ( MlyValue.longtycon longtycon2, _, longtycon2right))
 :: _ :: ( _, ( MlyValue.longtycon longtycon1, longtycon1left, _)) :: 
rest671)) => let val  result = MlyValue.longtyconeqns (fn _ => let
 val  longtycon1 = longtycon1 ()
 val  longtycon2 = longtycon2 ()
 in ([longtycon1,longtycon2])
end)
 in ( LrTable.NT 72, ( result, longtycon1left, longtycon2right), 
rest671)
end
|  ( 81, ( ( _, ( MlyValue.longtyconeqns longtyconeqns1, _, 
longtyconeqns1right)) :: _ :: ( _, ( MlyValue.longtycon longtycon1, 
longtycon1left, _)) :: rest671)) => let val  result = 
MlyValue.longtyconeqns (fn _ => let val  (longtycon as longtycon1) = 
longtycon1 ()
 val  (longtyconeqns as longtyconeqns1) = longtyconeqns1 ()
 in (longtycon :: longtyconeqns)
end)
 in ( LrTable.NT 72, ( result, longtycon1left, longtyconeqns1right), 
rest671)
end
|  ( 82, ( ( _, ( MlyValue.strdescs' strdescs'1, _, strdescs'1right))
 :: ( _, ( MlyValue.sigexp' sigexp'1, _, _)) :: _ :: ( _, ( 
MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val  result
 = MlyValue.strdescs (fn _ => let val  (strid as strid1) = strid1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (strdescs' as strdescs'1) = strdescs'1 ()
 in (augment (strid, sigexp', strdescs'))
end)
 in ( LrTable.NT 120, ( result, strid1left, strdescs'1right), rest671)

end
|  ( 83, ( rest671)) => let val  result = MlyValue.strdescs' (fn _ =>
 (([], defaultPos, [])))
 in ( LrTable.NT 121, ( result, defaultPos, defaultPos), rest671)
end
|  ( 84, ( ( _, ( MlyValue.strdescs strdescs1, _, strdescs1right)) :: 
( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.strdescs' (fn _ => let val  (strdescs as strdescs1) = 
strdescs1 ()
 in (([], defaultPos, strdescs))
end)
 in ( LrTable.NT 121, ( result, AND1left, strdescs1right), rest671)

end
|  ( 85, ( ( _, ( MlyValue.strdescs'' strdescs''1, _, strdescs''1right
)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, 
WHERE1left, _)) :: rest671)) => let val  result = MlyValue.strdescs'
 (fn _ => let val  (wherespec as wherespec1) = wherespec1 ()
 val  (strdescs'' as strdescs''1) = strdescs''1 ()
 in (cons1 (wherespec, strdescs''))
end)
 in ( LrTable.NT 121, ( result, WHERE1left, strdescs''1right), rest671
)
end
|  ( 86, ( ( _, ( MlyValue.strdescs' strdescs'1, strdescs'1left, 
strdescs'1right)) :: rest671)) => let val  result = 
MlyValue.strdescs'' (fn _ => let val  (strdescs' as strdescs'1) = 
strdescs'1 ()
 in (strdescs')
end)
 in ( LrTable.NT 122, ( result, strdescs'1left, strdescs'1right), 
rest671)
end
|  ( 87, ( ( _, ( MlyValue.strdescs'' strdescs''1, _, strdescs''1right
)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) :: ( _, ( _, 
AND1left, _)) :: rest671)) => let val  result = MlyValue.strdescs''
 (fn _ => let val  (wherespec as wherespec1) = wherespec1 ()
 val  (strdescs'' as strdescs''1) = strdescs''1 ()
 in (cons1 (wherespec, strdescs''))
end)
 in ( LrTable.NT 122, ( result, AND1left, strdescs''1right), rest671)

end
|  ( 88, ( ( _, ( MlyValue.typdesc typdesc1, typdesc1left, 
typdesc1right)) :: rest671)) => let val  result = MlyValue.typdescs
 (fn _ => let val  (typdesc as typdesc1) = typdesc1 ()
 in ([typdesc])
end)
 in ( LrTable.NT 149, ( result, typdesc1left, typdesc1right), rest671)

end
|  ( 89, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) ::
 _ :: ( _, ( MlyValue.typdesc typdesc1, typdesc1left, _)) :: rest671))
 => let val  result = MlyValue.typdescs (fn _ => let val  (typdesc as 
typdesc1) = typdesc1 ()
 val  (typdescs as typdescs1) = typdescs1 ()
 in (typdesc :: typdescs)
end)
 in ( LrTable.NT 149, ( result, typdesc1left, typdescs1right), rest671
)
end
|  ( 90, ( ( _, ( MlyValue.tycon tycon1, _, tycon1right)) :: ( _, ( 
MlyValue.tyvars tyvars1, tyvars1left, _)) :: rest671)) => let val  
result = MlyValue.typdesc (fn _ => let val  (tyvars as tyvars1) = 
tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 in ({tyvars = tyvars,
                         tycon = tycon})
end)
 in ( LrTable.NT 148, ( result, tyvars1left, tycon1right), rest671)

end
|  ( 91, ( ( _, ( MlyValue.valdesc valdesc1, valdesc1left, 
valdesc1right)) :: rest671)) => let val  result = MlyValue.valdescs
 (fn _ => let val  (valdesc as valdesc1) = valdesc1 ()
 in ([valdesc])
end)
 in ( LrTable.NT 158, ( result, valdesc1left, valdesc1right), rest671)

end
|  ( 92, ( ( _, ( MlyValue.valdescs valdescs1, _, valdescs1right)) ::
 _ :: ( _, ( MlyValue.valdesc valdesc1, valdesc1left, _)) :: rest671))
 => let val  result = MlyValue.valdescs (fn _ => let val  (valdesc as 
valdesc1) = valdesc1 ()
 val  (valdescs as valdescs1) = valdescs1 ()
 in (valdesc :: valdescs)
end)
 in ( LrTable.NT 158, ( result, valdesc1left, valdescs1right), rest671
)
end
|  ( 93, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.var var1, var1left, _)) :: rest671)) => let val  result = 
MlyValue.valdesc (fn _ => let val  (var as var1) = var1 ()
 val  (ty as ty1) = ty1 ()
 in (
Con.ensureSpecify (Vid.toCon (Vid.fromVar var))
                         ; (var, ty)
)
end)
 in ( LrTable.NT 157, ( result, var1left, ty1right), rest671)
end
|  ( 94, ( ( _, ( MlyValue.exndesc exndesc1, exndesc1left, 
exndesc1right)) :: rest671)) => let val  result = MlyValue.exndescs
 (fn _ => let val  (exndesc as exndesc1) = exndesc1 ()
 in ([exndesc])
end)
 in ( LrTable.NT 43, ( result, exndesc1left, exndesc1right), rest671)

end
|  ( 95, ( ( _, ( MlyValue.exndescs exndescs1, _, exndescs1right)) ::
 _ :: ( _, ( MlyValue.exndesc exndesc1, exndesc1left, _)) :: rest671))
 => let val  result = MlyValue.exndescs (fn _ => let val  (exndesc as 
exndesc1) = exndesc1 ()
 val  (exndescs as exndescs1) = exndescs1 ()
 in (exndesc :: exndescs)
end)
 in ( LrTable.NT 43, ( result, exndesc1left, exndescs1right), rest671)

end
|  ( 96, ( ( _, ( MlyValue.tyOpt tyOpt1, _, tyOpt1right)) :: ( _, ( 
MlyValue.con con1, con1left, _)) :: rest671)) => let val  result = 
MlyValue.exndesc (fn _ => let val  (con as con1) = con1 ()
 val  (tyOpt as tyOpt1) = tyOpt1 ()
 in (Con.ensureSpecify con; (con, tyOpt))
end)
 in ( LrTable.NT 42, ( result, con1left, tyOpt1right), rest671)
end
|  ( 97, ( rest671)) => let val  result = MlyValue.tyOpt (fn _ => (
NONE))
 in ( LrTable.NT 142, ( result, defaultPos, defaultPos), rest671)
end
|  ( 98, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, OF1left,
 _)) :: rest671)) => let val  result = MlyValue.tyOpt (fn _ => let
 val  (ty as ty1) = ty1 ()
 in (SOME ty)
end)
 in ( LrTable.NT 142, ( result, OF1left, ty1right), rest671)
end
|  ( 99, ( ( _, ( MlyValue.funbinds' funbinds'1, _, funbinds'1right))
 :: _ :: ( _, ( MlyValue.sigconst sigconst1, _, _)) :: _ :: ( _, ( 
MlyValue.fctarg fctarg1, fctargleft, fctargright)) :: _ :: ( _, ( 
MlyValue.fctid fctid1, fctid1left, _)) :: rest671)) => let val  result
 = MlyValue.funbinds (fn _ => let val  (fctid as fctid1) = fctid1 ()
 val  (fctarg as fctarg1) = fctarg1 ()
 val  (sigconst as sigconst1) = sigconst1 ()
 val  (funbinds' as funbinds'1) = funbinds'1 ()
 in (
let val (strexp,funbinds) = funbinds'
            in {name = fctid,
                arg = FctArg.makeRegion' (fctarg, fctargleft, fctargright),
                result = sigconst,
                body = strexp}
               :: funbinds
            end
)
end)
 in ( LrTable.NT 54, ( result, fctid1left, funbinds'1right), rest671)

end
|  ( 100, ( ( _, ( MlyValue.funbinds'1 funbinds'11, _, 
funbinds'11right)) :: ( _, ( MlyValue.strexp1 strexp11, strexp11left,
 _)) :: rest671)) => let val  result = MlyValue.funbinds' (fn _ => let
 val  (strexp1 as strexp11) = strexp11 ()
 val  (funbinds'1 as funbinds'11) = funbinds'11 ()
 in (augment1 (strexp1, funbinds'1))
end)
 in ( LrTable.NT 55, ( result, strexp11left, funbinds'11right), 
rest671)
end
|  ( 101, ( ( _, ( MlyValue.funbinds'2 funbinds'21, _, 
funbinds'21right)) :: ( _, ( MlyValue.strexp2 strexp21, strexp21left,
 _)) :: rest671)) => let val  result = MlyValue.funbinds' (fn _ => let
 val  (strexp2 as strexp21) = strexp21 ()
 val  (funbinds'2 as funbinds'21) = funbinds'21 ()
 in ((strexp2, funbinds'2))
end)
 in ( LrTable.NT 55, ( result, strexp21left, funbinds'21right), 
rest671)
end
|  ( 102, ( ( _, ( MlyValue.funbinds'2 funbinds'21, (funbinds'2left
 as funbinds'21left), funbinds'21right)) :: rest671)) => let val  
result = MlyValue.funbinds'1 (fn _ => let val  (funbinds'2 as 
funbinds'21) = funbinds'21 ()
 in ([], funbinds'2left, funbinds'2)
end)
 in ( LrTable.NT 56, ( result, funbinds'21left, funbinds'21right), 
rest671)
end
|  ( 103, ( ( _, ( MlyValue.funbinds'1' funbinds'1'1, _, 
funbinds'1'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, WHERE1left, _)) :: rest671)) => let val  result = 
MlyValue.funbinds'1 (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (funbinds'1' as funbinds'1'1) = funbinds'1'1 ()
 in (cons1 (wherespec,funbinds'1'))
end)
 in ( LrTable.NT 56, ( result, WHERE1left, funbinds'1'1right), rest671
)
end
|  ( 104, ( rest671)) => let val  result = MlyValue.funbinds'2 (fn _
 => ([]))
 in ( LrTable.NT 58, ( result, defaultPos, defaultPos), rest671)
end
|  ( 105, ( ( _, ( MlyValue.funbinds funbinds1, _, funbinds1right)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.funbinds'2 (fn _ => let val  (funbinds as funbinds1) = 
funbinds1 ()
 in (funbinds)
end)
 in ( LrTable.NT 58, ( result, AND1left, funbinds1right), rest671)
end
|  ( 106, ( ( _, ( MlyValue.funbinds'1 funbinds'11, funbinds'11left, 
funbinds'11right)) :: rest671)) => let val  result = 
MlyValue.funbinds'1' (fn _ => let val  (funbinds'1 as funbinds'11) = 
funbinds'11 ()
 in (funbinds'1)
end)
 in ( LrTable.NT 57, ( result, funbinds'11left, funbinds'11right), 
rest671)
end
|  ( 107, ( ( _, ( MlyValue.funbinds'1' funbinds'1'1, _, 
funbinds'1'1right)) :: ( _, ( MlyValue.wherespec wherespec1, _, _)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.funbinds'1' (fn _ => let val  (wherespec as wherespec1) = 
wherespec1 ()
 val  (funbinds'1' as funbinds'1'1) = funbinds'1'1 ()
 in (cons1 (wherespec,funbinds'1'))
end)
 in ( LrTable.NT 57, ( result, AND1left, funbinds'1'1right), rest671)

end
|  ( 108, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: _ :: 
( _, ( MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val 
 result = MlyValue.fctarg (fn _ => let val  (strid as strid1) = strid1
 ()
 val  (sigexp as sigexp1) = sigexp1 ()
 in (FctArg.Structure (strid, sigexp))
end)
 in ( LrTable.NT 50, ( result, strid1left, sigexp1right), rest671)
end
|  ( 109, ( ( _, ( MlyValue.specs specs1, specs1left, specs1right)) ::
 rest671)) => let val  result = MlyValue.fctarg (fn _ => let val  (
specs as specs1) = specs1 ()
 in (FctArg.Spec specs)
end)
 in ( LrTable.NT 50, ( result, specs1left, specs1right), rest671)
end
|  ( 110, ( rest671)) => let val  result = MlyValue.decs (fn _ => (
Dec.makeRegion' (Dec.SeqDec (Vector.new0 ()),
                                          defaultPos, defaultPos)
))
 in ( LrTable.NT 33, ( result, defaultPos, defaultPos), rest671)
end
|  ( 111, ( ( _, ( MlyValue.decs decs1, _, decs1right)) :: ( _, ( 
MlyValue.dec dec1, dec1left, _)) :: rest671)) => let val  result = 
MlyValue.decs (fn _ => let val  (dec as dec1) = dec1 ()
 val  (decs as decs1) = decs1 ()
 in (Dec.sequence (dec,decs))
end)
 in ( LrTable.NT 33, ( result, dec1left, decs1right), rest671)
end
|  ( 112, ( ( _, ( MlyValue.decs decs1, _, decs1right)) :: ( _, ( _, 
SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.decs
 (fn _ => let val  (decs as decs1) = decs1 ()
 in (decs)
end)
 in ( LrTable.NT 33, ( result, SEMICOLON1left, decs1right), rest671)

end
|  ( 113, ( ( _, ( MlyValue.decnode decnode1, (decnodeleft as 
decnode1left), (decnoderight as decnode1right))) :: rest671)) => let
 val  result = MlyValue.dec (fn _ => let val  (decnode as decnode1) = 
decnode1 ()
 in (Dec.makeRegion' (decnode, decnodeleft, decnoderight))
end)
 in ( LrTable.NT 30, ( result, decnode1left, decnode1right), rest671)

end
|  ( 114, ( ( _, ( MlyValue.decnolocal decnolocal1, decnolocal1left, 
decnolocal1right)) :: rest671)) => let val  result = MlyValue.decnode
 (fn _ => let val  (decnolocal as decnolocal1) = decnolocal1 ()
 in (decnolocal)
end)
 in ( LrTable.NT 31, ( result, decnolocal1left, decnolocal1right), 
rest671)
end
|  ( 115, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.decs decs2, _,
 _)) :: _ :: ( _, ( MlyValue.decs decs1, _, _)) :: ( _, ( _, 
LOCAL1left, _)) :: rest671)) => let val  result = MlyValue.decnode (fn
 _ => let val  decs1 = decs1 ()
 val  decs2 = decs2 ()
 in (Dec.Local (decs1,decs2))
end)
 in ( LrTable.NT 31, ( result, LOCAL1left, END1right), rest671)
end
|  ( 116, ( ( _, ( MlyValue.valbindTop valbindTop1, _, 
valbindTop1right)) :: ( _, ( _, VAL1left, _)) :: rest671)) => let val 
 result = MlyValue.decnolocal (fn _ => let val  (valbindTop as 
valbindTop1) = valbindTop1 ()
 in (
Dec.Val {tyvars = Vector.new0 (),
                                            vbs = #1 valbindTop,
                                            rvbs = #2 valbindTop}
)
end)
 in ( LrTable.NT 32, ( result, VAL1left, valbindTop1right), rest671)

end
|  ( 117, ( ( _, ( MlyValue.valbindTop valbindTop1, _, 
valbindTop1right)) :: ( _, ( MlyValue.tyvarseq tyvarseq1, _, _)) :: (
 _, ( _, VAL1left, _)) :: rest671)) => let val  result = 
MlyValue.decnolocal (fn _ => let val  (tyvarseq as tyvarseq1) = 
tyvarseq1 ()
 val  (valbindTop as valbindTop1) = valbindTop1 ()
 in (
Dec.Val {tyvars = tyvarseq,
                                             vbs = #1 valbindTop,
                                             rvbs = #2 valbindTop}
)
end)
 in ( LrTable.NT 32, ( result, VAL1left, valbindTop1right), rest671)

end
|  ( 118, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: ( _, ( _, 
FUN1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal
 (fn _ => let val  (funs as funs1) = funs1 ()
 in (Dec.Fun (Vector.new0 (), Vector.fromList funs))
end)
 in ( LrTable.NT 32, ( result, FUN1left, funs1right), rest671)
end
|  ( 119, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: ( _, ( 
MlyValue.tyvarseq tyvarseq1, _, _)) :: ( _, ( _, FUN1left, _)) :: 
rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (
tyvarseq as tyvarseq1) = tyvarseq1 ()
 val  (funs as funs1) = funs1 ()
 in (Dec.Fun (tyvarseq, Vector.fromList funs))
end)
 in ( LrTable.NT 32, ( result, FUN1left, funs1right), rest671)
end
|  ( 120, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: (
 _, ( _, TYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.decnolocal (fn _ => let val  (typBind as typBind1) = typBind1
 ()
 in (Dec.Type typBind)
end)
 in ( LrTable.NT 32, ( result, TYPE1left, typBind1right), rest671)
end
|  ( 121, ( ( _, ( MlyValue.datatypeRhs datatypeRhs1, _, 
datatypeRhs1right)) :: ( _, ( _, DATATYPE1left, _)) :: rest671)) =>
 let val  result = MlyValue.decnolocal (fn _ => let val  (datatypeRhs
 as datatypeRhs1) = datatypeRhs1 ()
 in (Dec.Datatype datatypeRhs)
end)
 in ( LrTable.NT 32, ( result, DATATYPE1left, datatypeRhs1right), 
rest671)
end
|  ( 122, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.decs decs1, _,
 _)) :: _ :: ( _, ( MlyValue.datBind datBind1, _, _)) :: ( _, ( _, 
ABSTYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.decnolocal (fn _ => let val  (datBind as datBind1) = datBind1
 ()
 val  (decs as decs1) = decs1 ()
 in (
Dec.Abstype {datBind = datBind,
                                                        body = decs}
)
end)
 in ( LrTable.NT 32, ( result, ABSTYPE1left, END1right), rest671)
end
|  ( 123, ( ( _, ( MlyValue.ebs ebs1, _, ebs1right)) :: ( _, ( _, 
EXCEPTION1left, _)) :: rest671)) => let val  result = 
MlyValue.decnolocal (fn _ => let val  (ebs as ebs1) = ebs1 ()
 in (Dec.Exception (Vector.fromList ebs))
end)
 in ( LrTable.NT 32, ( result, EXCEPTION1left, ebs1right), rest671)

end
|  ( 124, ( ( _, ( MlyValue.longstrids longstrids1, _, 
longstrids1right)) :: ( _, ( _, OPEN1left, _)) :: rest671)) => let
 val  result = MlyValue.decnolocal (fn _ => let val  (longstrids as 
longstrids1) = longstrids1 ()
 in (Dec.Open (Vector.fromList longstrids))
end)
 in ( LrTable.NT 32, ( result, OPEN1left, longstrids1right), rest671)

end
|  ( 125, ( ( _, ( MlyValue.vids vids1, _, vids1right)) :: ( _, ( 
MlyValue.fixity fixity1, fixity1left, _)) :: rest671)) => let val  
result = MlyValue.decnolocal (fn _ => let val  (fixity as fixity1) = 
fixity1 ()
 val  (vids as vids1) = vids1 ()
 in (
Dec.Fix {fixity = fixity,
                                          ops = Vector.fromList vids}
)
end)
 in ( LrTable.NT 32, ( result, fixity1left, vids1right), rest671)
end
|  ( 126, ( ( _, ( MlyValue.longvarands longvarands1, _, 
longvarands1right)) :: _ :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _
, ( MlyValue.var var1, _, _)) :: ( _, ( MlyValue.priority priority1, _
, _)) :: ( _, ( _, OVERLOAD1left, _)) :: rest671)) => let val  result
 = MlyValue.decnolocal (fn _ => let val  (priority as priority1) = 
priority1 ()
 val  (var as var1) = var1 ()
 val  (ty as ty1) = ty1 ()
 val  (longvarands as longvarands1) = longvarands1 ()
 in (
Dec.Overload (priority, 
                                               var,
                                               Vector.new0 (),
                                               ty,
                                               Vector.fromList longvarands)
)
end)
 in ( LrTable.NT 32, ( result, OVERLOAD1left, longvarands1right), 
rest671)
end
|  ( 127, ( ( _, ( MlyValue.valbind valbind1, valbind1left, 
valbind1right)) :: rest671)) => let val  result = MlyValue.valbindTop
 (fn _ => let val  (valbind as valbind1) = valbind1 ()
 in (
let
                         val (vbs, rvbs) = valbind
                      in
                         (Vector.fromList vbs,
                          Vector.fromList rvbs)
                      end
)
end)
 in ( LrTable.NT 156, ( result, valbind1left, valbind1right), rest671)

end
|  ( 128, ( ( _, ( MlyValue.valbindRest valbindRest1, _, 
valbindRest1right)) :: ( _, ( MlyValue.exp exp1, _, _)) :: _ :: ( _, (
 MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = 
MlyValue.valbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (exp as exp1) = exp1 ()
 val  (valbindRest as valbindRest1) = valbindRest1 ()
 in (
let
              val (vbs, rvbs) = valbindRest
           in
              ({pat = pat, exp = exp} :: vbs,
               rvbs)
           end
)
end)
 in ( LrTable.NT 154, ( result, pat1left, valbindRest1right), rest671)

end
|  ( 129, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) ::
 ( _, ( _, REC1left, _)) :: rest671)) => let val  result = 
MlyValue.valbind (fn _ => let val  (rvalbind as rvalbind1) = rvalbind1
 ()
 in (([], rvalbind))
end)
 in ( LrTable.NT 154, ( result, REC1left, rvalbind1right), rest671)

end
|  ( 130, ( rest671)) => let val  result = MlyValue.valbindRest (fn _
 => (([], [])))
 in ( LrTable.NT 155, ( result, defaultPos, defaultPos), rest671)
end
|  ( 131, ( ( _, ( MlyValue.valbind valbind1, _, valbind1right)) :: (
 _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.valbindRest (fn _ => let val  (valbind as valbind1) = 
valbind1 ()
 in (valbind)
end)
 in ( LrTable.NT 155, ( result, AND1left, valbind1right), rest671)
end
|  ( 132, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) ::
 ( _, ( _, REC1left, _)) :: rest671)) => let val  result = 
MlyValue.rvalbind (fn _ => let val  (rvalbind as rvalbind1) = 
rvalbind1 ()
 in (rvalbind)
end)
 in ( LrTable.NT 92, ( result, REC1left, rvalbind1right), rest671)
end
|  ( 133, ( ( _, ( MlyValue.rvalbindRest rvalbindRest1, _, 
rvalbindRest1right)) :: ( _, ( MlyValue.match match1, _, _)) :: _ :: _
 :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  
result = MlyValue.rvalbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (match as match1) = match1 ()
 val  (rvalbindRest as rvalbindRest1) = rvalbindRest1 ()
 in ({pat = pat, match = match} :: rvalbindRest)
end)
 in ( LrTable.NT 92, ( result, pat1left, rvalbindRest1right), rest671)

end
|  ( 134, ( rest671)) => let val  result = MlyValue.rvalbindRest (fn _
 => ([]))
 in ( LrTable.NT 93, ( result, defaultPos, defaultPos), rest671)
end
|  ( 135, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.rvalbindRest (fn _ => let val  (rvalbind as rvalbind1) = 
rvalbind1 ()
 in (rvalbind)
end)
 in ( LrTable.NT 93, ( result, AND1left, rvalbind1right), rest671)
end
|  ( 136, ( rest671)) => let val  result = MlyValue.constraint (fn _
 => (NONE))
 in ( LrTable.NT 18, ( result, defaultPos, defaultPos), rest671)
end
|  ( 137, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, 
COLON1left, _)) :: rest671)) => let val  result = MlyValue.constraint
 (fn _ => let val  (ty as ty1) = ty1 ()
 in (SOME ty)
end)
 in ( LrTable.NT 18, ( result, COLON1left, ty1right), rest671)
end
|  ( 138, ( ( _, ( MlyValue.clausesTop clausesTop1, clausesTop1left, 
clausesTop1right)) :: rest671)) => let val  result = MlyValue.funs (fn
 _ => let val  (clausesTop as clausesTop1) = clausesTop1 ()
 in ([clausesTop])
end)
 in ( LrTable.NT 59, ( result, clausesTop1left, clausesTop1right), 
rest671)
end
|  ( 139, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: _ :: ( _, (
 MlyValue.clausesTop clausesTop1, clausesTop1left, _)) :: rest671)) =>
 let val  result = MlyValue.funs (fn _ => let val  (clausesTop as 
clausesTop1) = clausesTop1 ()
 val  (funs as funs1) = funs1 ()
 in (clausesTop :: funs)
end)
 in ( LrTable.NT 59, ( result, clausesTop1left, funs1right), rest671)

end
|  ( 140, ( ( _, ( MlyValue.clauses clauses1, clauses1left, 
clauses1right)) :: rest671)) => let val  result = MlyValue.clausesTop
 (fn _ => let val  (clauses as clauses1) = clauses1 ()
 in (Vector.fromList clauses)
end)
 in ( LrTable.NT 12, ( result, clauses1left, clauses1right), rest671)

end
|  ( 141, ( ( _, ( MlyValue.clause clause1, clause1left, clause1right)
) :: rest671)) => let val  result = MlyValue.clauses (fn _ => let val 
 (clause as clause1) = clause1 ()
 in ([clause])
end)
 in ( LrTable.NT 11, ( result, clause1left, clause1right), rest671)

end
|  ( 142, ( ( _, ( MlyValue.clauses clauses1, _, clauses1right)) :: _
 :: ( _, ( MlyValue.clause clause1, clause1left, _)) :: rest671)) =>
 let val  result = MlyValue.clauses (fn _ => let val  (clause as 
clause1) = clause1 ()
 val  (clauses as clauses1) = clauses1 ()
 in (clause :: clauses)
end)
 in ( LrTable.NT 11, ( result, clause1left, clauses1right), rest671)

end
|  ( 143, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( 
MlyValue.constraint constraint1, _, _)) :: ( _, ( MlyValue.apats 
apats1, apats1left, _)) :: rest671)) => let val  result = 
MlyValue.clause (fn _ => let val  (apats as apats1) = apats1 ()
 val  (constraint as constraint1) = constraint1 ()
 val  (exp as exp1) = exp1 ()
 in (
{pats = Vector.fromList apats,
                                          resultType = constraint,
                                          body = exp}
)
end)
 in ( LrTable.NT 10, ( result, apats1left, exp1right), rest671)
end
|  ( 144, ( ( _, ( MlyValue.typBind' typBind'1, (typBind'left as 
typBind'1left), (typBind'right as typBind'1right))) :: rest671)) =>
 let val  result = MlyValue.typBind (fn _ => let val  (typBind' as 
typBind'1) = typBind'1 ()
 in (
let
              val typBind = Vector.fromList typBind'
              val b =
                 TypBind.makeRegion'
                 (TypBind.T typBind, typBind'left, typBind'right)
           in
              b
           end
)
end)
 in ( LrTable.NT 145, ( result, typBind'1left, typBind'1right), 
rest671)
end
|  ( 145, ( ( _, ( MlyValue.typBind'' typBind''1, _, typBind''1right))
 :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.tycon 
tycon1, _, _)) :: ( _, ( MlyValue.tyvars tyvars1, tyvars1left, _)) :: 
rest671)) => let val  result = MlyValue.typBind' (fn _ => let val  (
tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  (ty as ty1) = ty1 ()
 val  (typBind'' as typBind''1) = typBind''1 ()
 in ({def = ty, tycon = tycon, tyvars = tyvars} :: typBind'')
end)
 in ( LrTable.NT 146, ( result, tyvars1left, typBind''1right), rest671
)
end
|  ( 146, ( rest671)) => let val  result = MlyValue.typBind'' (fn _ =>
 ([]))
 in ( LrTable.NT 147, ( result, defaultPos, defaultPos), rest671)
end
|  ( 147, ( ( _, ( MlyValue.typBind' typBind'1, _, typBind'1right)) ::
 ( _, ( _, AND1left, _)) :: rest671)) => let val  result = 
MlyValue.typBind'' (fn _ => let val  (typBind' as typBind'1) = 
typBind'1 ()
 in (typBind')
end)
 in ( LrTable.NT 147, ( result, AND1left, typBind'1right), rest671)

end
|  ( 148, ( ( _, ( MlyValue.tyvarseq tyvarseq1, tyvarseq1left, 
tyvarseq1right)) :: rest671)) => let val  result = MlyValue.tyvars (fn
 _ => let val  (tyvarseq as tyvarseq1) = tyvarseq1 ()
 in (tyvarseq)
end)
 in ( LrTable.NT 152, ( result, tyvarseq1left, tyvarseq1right), 
rest671)
end
|  ( 149, ( rest671)) => let val  result = MlyValue.tyvars (fn _ => (
Vector.new0 ()))
 in ( LrTable.NT 152, ( result, defaultPos, defaultPos), rest671)
end
|  ( 150, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) ::
 rest671)) => let val  result = MlyValue.tyvarseq (fn _ => let val  (
tyvar as tyvar1) = tyvar1 ()
 in (Vector.new1 tyvar)
end)
 in ( LrTable.NT 153, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 151, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.tyvar_pc 
tyvar_pc1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let
 val  result = MlyValue.tyvarseq (fn _ => let val  (tyvar_pc as 
tyvar_pc1) = tyvar_pc1 ()
 in (
let
              val v = Vector.fromList tyvar_pc
              val () =
                 reportDuplicates
                 (v, {equals = Tyvar.sameName,
                      layout = Tyvar.layout,
                      name = "type variable",
                      region = Tyvar.region,
                      term = fn () => Layout.tuple (Vector.toListMap
                                                    (v, Tyvar.layout))})
           in
              v
           end
)
end)
 in ( LrTable.NT 153, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 152, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) ::
 rest671)) => let val  result = MlyValue.tyvar_pc (fn _ => let val  (
tyvar as tyvar1) = tyvar1 ()
 in ([tyvar])
end)
 in ( LrTable.NT 151, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 153, ( ( _, ( MlyValue.tyvar_pc tyvar_pc1, _, tyvar_pc1right)) ::
 _ :: ( _, ( MlyValue.tyvar tyvar1, tyvar1left, _)) :: rest671)) =>
 let val  result = MlyValue.tyvar_pc (fn _ => let val  (tyvar as 
tyvar1) = tyvar1 ()
 val  (tyvar_pc as tyvar_pc1) = tyvar_pc1 ()
 in (tyvar :: tyvar_pc)
end)
 in ( LrTable.NT 151, ( result, tyvar1left, tyvar_pc1right), rest671)

end
|  ( 154, ( ( _, ( MlyValue.constr constr1, constr1left, constr1right)
) :: rest671)) => let val  result = MlyValue.constrs (fn _ => let val 
 (constr as constr1) = constr1 ()
 in ([constr])
end)
 in ( LrTable.NT 19, ( result, constr1left, constr1right), rest671)

end
|  ( 155, ( ( _, ( MlyValue.constrs constrs1, _, constrs1right)) :: _
 :: ( _, ( MlyValue.constr constr1, constr1left, _)) :: rest671)) =>
 let val  result = MlyValue.constrs (fn _ => let val  (constr as 
constr1) = constr1 ()
 val  (constrs as constrs1) = constrs1 ()
 in (constr :: constrs)
end)
 in ( LrTable.NT 19, ( result, constr1left, constrs1right), rest671)

end
|  ( 156, ( ( _, ( MlyValue.opcon opcon1, opcon1left, opcon1right)) ::
 rest671)) => let val  result = MlyValue.constr (fn _ => let val  (
opcon as opcon1) = opcon1 ()
 in (opcon, NONE)
end)
 in ( LrTable.NT 17, ( result, opcon1left, opcon1right), rest671)
end
|  ( 157, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.opcon opcon1, opcon1left, _)) :: rest671)) => let val  result
 = MlyValue.constr (fn _ => let val  (opcon as opcon1) = opcon1 ()
 val  (ty as ty1) = ty1 ()
 in (opcon, SOME ty)
end)
 in ( LrTable.NT 17, ( result, opcon1left, ty1right), rest671)
end
|  ( 158, ( ( _, ( MlyValue.con con1, con1left, con1right)) :: rest671
)) => let val  result = MlyValue.opcon (fn _ => let val  (con as con1)
 = con1 ()
 in (con)
end)
 in ( LrTable.NT 79, ( result, con1left, con1right), rest671)
end
|  ( 159, ( ( _, ( MlyValue.con con1, _, con1right)) :: ( _, ( _, 
OP1left, _)) :: rest671)) => let val  result = MlyValue.opcon (fn _ =>
 let val  (con as con1) = con1 ()
 in (con)
end)
 in ( LrTable.NT 79, ( result, OP1left, con1right), rest671)
end
|  ( 160, ( ( _, ( MlyValue.eb eb1, eb1left, eb1right)) :: rest671))
 => let val  result = MlyValue.ebs (fn _ => let val  (eb as eb1) = eb1
 ()
 in ([eb])
end)
 in ( LrTable.NT 39, ( result, eb1left, eb1right), rest671)
end
|  ( 161, ( ( _, ( MlyValue.ebs ebs1, _, ebs1right)) :: _ :: ( _, ( 
MlyValue.eb eb1, eb1left, _)) :: rest671)) => let val  result = 
MlyValue.ebs (fn _ => let val  (eb as eb1) = eb1 ()
 val  (ebs as ebs1) = ebs1 ()
 in (eb::ebs)
end)
 in ( LrTable.NT 39, ( result, eb1left, ebs1right), rest671)
end
|  ( 162, ( ( _, ( MlyValue.ebrhs ebrhs1, _, ebrhs1right)) :: ( _, ( 
MlyValue.opcon opcon1, opcon1left, _)) :: rest671)) => let val  result
 = MlyValue.eb (fn _ => let val  (opcon as opcon1) = opcon1 ()
 val  (ebrhs as ebrhs1) = ebrhs1 ()
 in (Con.ensureRedefine opcon; (opcon, ebrhs))
end)
 in ( LrTable.NT 36, ( result, opcon1left, ebrhs1right), rest671)
end
|  ( 163, ( ( _, ( MlyValue.ebrhsnode ebrhsnode1, (ebrhsnodeleft as 
ebrhsnode1left), (ebrhsnoderight as ebrhsnode1right))) :: rest671)) =>
 let val  result = MlyValue.ebrhs (fn _ => let val  (ebrhsnode as 
ebrhsnode1) = ebrhsnode1 ()
 in (
EbRhs.makeRegion' (ebrhsnode,
                                     ebrhsnodeleft, ebrhsnoderight)
)
end)
 in ( LrTable.NT 37, ( result, ebrhsnode1left, ebrhsnode1right), 
rest671)
end
|  ( 164, ( rest671)) => let val  result = MlyValue.ebrhsnode (fn _ =>
 (EbRhs.Gen NONE))
 in ( LrTable.NT 38, ( result, defaultPos, defaultPos), rest671)
end
|  ( 165, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, OF1left
, _)) :: rest671)) => let val  result = MlyValue.ebrhsnode (fn _ =>
 let val  (ty as ty1) = ty1 ()
 in (EbRhs.Gen (SOME ty))
end)
 in ( LrTable.NT 38, ( result, OF1left, ty1right), rest671)
end
|  ( 166, ( ( _, ( MlyValue.longcon longcon1, _, longcon1right)) :: (
 _, ( _, EQUALOP1left, _)) :: rest671)) => let val  result = 
MlyValue.ebrhsnode (fn _ => let val  (longcon as longcon1) = longcon1
 ()
 in (EbRhs.Def longcon)
end)
 in ( LrTable.NT 38, ( result, EQUALOP1left, longcon1right), rest671)

end
|  ( 167, ( ( _, ( MlyValue.longcon longcon1, _, longcon1right)) :: _
 :: ( _, ( _, EQUALOP1left, _)) :: rest671)) => let val  result = 
MlyValue.ebrhsnode (fn _ => let val  (longcon as longcon1) = longcon1
 ()
 in (EbRhs.Def longcon)
end)
 in ( LrTable.NT 38, ( result, EQUALOP1left, longcon1right), rest671)

end
|  ( 168, ( ( _, ( _, INFIX1left, INFIX1right)) :: rest671)) => let
 val  result = MlyValue.fixity (fn _ => (Fixity.Infix NONE))
 in ( LrTable.NT 53, ( result, INFIX1left, INFIX1right), rest671)
end
|  ( 169, ( ( _, ( MlyValue.digit digit1, _, digit1right)) :: ( _, ( _
, INFIX1left, _)) :: rest671)) => let val  result = MlyValue.fixity
 (fn _ => let val  (digit as digit1) = digit1 ()
 in (Fixity.Infix (SOME digit))
end)
 in ( LrTable.NT 53, ( result, INFIX1left, digit1right), rest671)
end
|  ( 170, ( ( _, ( _, INFIXR1left, INFIXR1right)) :: rest671)) => let
 val  result = MlyValue.fixity (fn _ => (Fixity.Infixr NONE))
 in ( LrTable.NT 53, ( result, INFIXR1left, INFIXR1right), rest671)

end
|  ( 171, ( ( _, ( MlyValue.digit digit1, _, digit1right)) :: ( _, ( _
, INFIXR1left, _)) :: rest671)) => let val  result = MlyValue.fixity
 (fn _ => let val  (digit as digit1) = digit1 ()
 in (Fixity.Infixr (SOME digit))
end)
 in ( LrTable.NT 53, ( result, INFIXR1left, digit1right), rest671)
end
|  ( 172, ( ( _, ( _, NONFIX1left, NONFIX1right)) :: rest671)) => let
 val  result = MlyValue.fixity (fn _ => (Fixity.Nonfix))
 in ( LrTable.NT 53, ( result, NONFIX1left, NONFIX1right), rest671)

end
|  ( 173, ( rest671)) => let val  result = MlyValue.priority (fn _ =>
 (Priority.T NONE))
 in ( LrTable.NT 87, ( result, defaultPos, defaultPos), rest671)
end
|  ( 174, ( ( _, ( MlyValue.digit digit1, digit1left, digit1right)) ::
 rest671)) => let val  result = MlyValue.priority (fn _ => let val  (
digit as digit1) = digit1 ()
 in (Priority.T (SOME digit))
end)
 in ( LrTable.NT 87, ( result, digit1left, digit1right), rest671)
end
|  ( 175, ( ( _, ( MlyValue.INT INT1, INT1left, INT1right)) :: rest671
)) => let val  result = MlyValue.int (fn _ => let val  (INT as INT1) =
 INT1 ()
 in (
let
       val {digits, negate, radix} = INT
    in
       case StringCvt.scanString (fn r => IntInf.scan (radix, r)) digits of
          NONE => Error.bug "parser saw invalid int"
        | SOME i => if negate then ~ i else i
    end
)
end)
 in ( LrTable.NT 63, ( result, INT1left, INT1right), rest671)
end
|  ( 176, ( ( _, ( MlyValue.WORD WORD1, WORD1left, WORD1right)) :: 
rest671)) => let val  result = MlyValue.word (fn _ => let val  (WORD
 as WORD1) = WORD1 ()
 in (
let
       val {digits, radix} = WORD
    in
       case StringCvt.scanString (fn r => IntInf.scan (radix, r)) digits of
          NONE => Error.bug "parser saw invalid word"
        | SOME i => i
    end
)
end)
 in ( LrTable.NT 167, ( result, WORD1left, WORD1right), rest671)
end
|  ( 177, ( ( _, ( MlyValue.INT INT1, (INTleft as INT1left), (INTright
 as INT1right))) :: rest671)) => let val  result = MlyValue.digit (fn
 _ => let val  (INT as INT1) = INT1 ()
 in (
let
       val {digits, negate, radix} = INT
    in
       if 1 = String.size digits andalso not negate andalso radix = StringCvt.DEC
          then valOf (Int.fromString digits)
       else let
               open Layout
               val _ = 
                  Control.error (reg (INTleft, INTright),
                                 str "invalid digit in infix declaration",
                                 empty)
            in
               0
            end
    end
)
end)
 in ( LrTable.NT 35, ( result, INT1left, INT1right), rest671)
end
|  ( 178, ( ( _, ( MlyValue.datatypeRhsnode datatypeRhsnode1, (
datatypeRhsnodeleft as datatypeRhsnode1left), (datatypeRhsnoderight
 as datatypeRhsnode1right))) :: rest671)) => let val  result = 
MlyValue.datatypeRhs (fn _ => let val  (datatypeRhsnode as 
datatypeRhsnode1) = datatypeRhsnode1 ()
 in (
DatatypeRhs.makeRegion' (datatypeRhsnode,
                               datatypeRhsnodeleft, datatypeRhsnoderight)
)
end)
 in ( LrTable.NT 23, ( result, datatypeRhsnode1left, 
datatypeRhsnode1right), rest671)
end
|  ( 179, ( ( _, ( MlyValue.datatypeRhsnodeNoWithtype 
datatypeRhsnodeNoWithtype1, (datatypeRhsnodeNoWithtypeleft as 
datatypeRhsnodeNoWithtype1left), (datatypeRhsnodeNoWithtyperight as 
datatypeRhsnodeNoWithtype1right))) :: rest671)) => let val  result = 
MlyValue.datatypeRhsNoWithtype (fn _ => let val  (
datatypeRhsnodeNoWithtype as datatypeRhsnodeNoWithtype1) = 
datatypeRhsnodeNoWithtype1 ()
 in (
DatatypeRhs.makeRegion' (datatypeRhsnodeNoWithtype,
                               datatypeRhsnodeNoWithtypeleft,
                               datatypeRhsnodeNoWithtyperight)
)
end)
 in ( LrTable.NT 24, ( result, datatypeRhsnodeNoWithtype1left, 
datatypeRhsnodeNoWithtype1right), rest671)
end
|  ( 180, ( ( _, ( MlyValue.repl repl1, repl1left, repl1right)) :: 
rest671)) => let val  result = MlyValue.datatypeRhsnode (fn _ => let
 val  (repl as repl1) = repl1 ()
 in (repl)
end)
 in ( LrTable.NT 25, ( result, repl1left, repl1right), rest671)
end
|  ( 181, ( ( _, ( MlyValue.datBind datBind1, datBind1left, 
datBind1right)) :: rest671)) => let val  result = 
MlyValue.datatypeRhsnode (fn _ => let val  (datBind as datBind1) = 
datBind1 ()
 in (DatatypeRhs.DatBind datBind)
end)
 in ( LrTable.NT 25, ( result, datBind1left, datBind1right), rest671)

end
|  ( 182, ( ( _, ( MlyValue.repl repl1, repl1left, repl1right)) :: 
rest671)) => let val  result = MlyValue.datatypeRhsnodeNoWithtype (fn
 _ => let val  (repl as repl1) = repl1 ()
 in (repl)
end)
 in ( LrTable.NT 26, ( result, repl1left, repl1right), rest671)
end
|  ( 183, ( ( _, ( MlyValue.datBindNoWithtype datBindNoWithtype1, 
datBindNoWithtype1left, datBindNoWithtype1right)) :: rest671)) => let
 val  result = MlyValue.datatypeRhsnodeNoWithtype (fn _ => let val  (
datBindNoWithtype as datBindNoWithtype1) = datBindNoWithtype1 ()
 in (DatatypeRhs.DatBind datBindNoWithtype)
end)
 in ( LrTable.NT 26, ( result, datBindNoWithtype1left, 
datBindNoWithtype1right), rest671)
end
|  ( 184, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right))
 :: _ :: _ :: ( _, ( MlyValue.tycon tycon1, _, _)) :: ( _, ( 
MlyValue.tyvars tyvars1, (tyvarsleft as tyvars1left), tyvarsright)) ::
 rest671)) => let val  result = MlyValue.repl (fn _ => let val  (
tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in (
if Vector.isEmpty tyvars
           then ()
        else error (reg (tyvarsleft, tyvarsright),
                    "nonempty tyvars in datatype repl")
        ; DatatypeRhs.Repl {lhs = tycon, rhs = longtycon}
)
end)
 in ( LrTable.NT 89, ( result, tyvars1left, longtycon1right), rest671)

end
|  ( 185, ( ( _, ( MlyValue.withtypes withtypes1, _, (withtypesright
 as withtypes1right))) :: ( _, ( MlyValue.dbs dbs1, (dbsleft as 
dbs1left), _)) :: rest671)) => let val  result = MlyValue.datBind (fn
 _ => let val  (dbs as dbs1) = dbs1 ()
 val  (withtypes as withtypes1) = withtypes1 ()
 in (DatBind.make (dbs, withtypes, dbsleft, withtypesright))
end)
 in ( LrTable.NT 21, ( result, dbs1left, withtypes1right), rest671)

end
|  ( 186, ( ( _, ( MlyValue.dbs dbs1, (dbsleft as dbs1left), (dbsright
 as dbs1right))) :: rest671)) => let val  result = 
MlyValue.datBindNoWithtype (fn _ => let val  (dbs as dbs1) = dbs1 ()
 in (DatBind.make (dbs, TypBind.empty, dbsleft, dbsright))
end)
 in ( LrTable.NT 22, ( result, dbs1left, dbs1right), rest671)
end
|  ( 187, ( ( _, ( MlyValue.dbs' dbs'1, dbs'1left, dbs'1right)) :: 
rest671)) => let val  result = MlyValue.dbs (fn _ => let val  (dbs'
 as dbs'1) = dbs'1 ()
 in (Vector.fromList dbs')
end)
 in ( LrTable.NT 28, ( result, dbs'1left, dbs'1right), rest671)
end
|  ( 188, ( ( _, ( MlyValue.db db1, db1left, db1right)) :: rest671))
 => let val  result = MlyValue.dbs' (fn _ => let val  (db as db1) = 
db1 ()
 in ([db])
end)
 in ( LrTable.NT 29, ( result, db1left, db1right), rest671)
end
|  ( 189, ( ( _, ( MlyValue.dbs' dbs'1, _, dbs'1right)) :: _ :: ( _, (
 MlyValue.db db1, db1left, _)) :: rest671)) => let val  result = 
MlyValue.dbs' (fn _ => let val  (db as db1) = db1 ()
 val  (dbs' as dbs'1) = dbs'1 ()
 in (db :: dbs')
end)
 in ( LrTable.NT 29, ( result, db1left, dbs'1right), rest671)
end
|  ( 190, ( ( _, ( MlyValue.constrs constrs1, _, constrs1right)) :: _
 :: ( _, ( MlyValue.tycon tycon1, _, _)) :: ( _, ( MlyValue.tyvars 
tyvars1, tyvars1left, _)) :: rest671)) => let val  result = 
MlyValue.db (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  (constrs as constrs1) = constrs1 ()
 in (
{cons = Vector.fromList constrs,
       tycon = tycon,
       tyvars = tyvars}
)
end)
 in ( LrTable.NT 27, ( result, tyvars1left, constrs1right), rest671)

end
|  ( 191, ( rest671)) => let val  result = MlyValue.withtypes (fn _ =>
 (TypBind.empty))
 in ( LrTable.NT 166, ( result, defaultPos, defaultPos), rest671)
end
|  ( 192, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: (
 _, ( _, WITHTYPE1left, _)) :: rest671)) => let val  result = 
MlyValue.withtypes (fn _ => let val  (typBind as typBind1) = typBind1
 ()
 in (typBind)
end)
 in ( LrTable.NT 166, ( result, WITHTYPE1left, typBind1right), rest671
)
end
|  ( 193, ( ( _, ( MlyValue.longvar longvar1, longvar1left, 
longvar1right)) :: rest671)) => let val  result = MlyValue.longvarands
 (fn _ => let val  (longvar as longvar1) = longvar1 ()
 in ([longvar])
end)
 in ( LrTable.NT 74, ( result, longvar1left, longvar1right), rest671)

end
|  ( 194, ( ( _, ( MlyValue.longvarands longvarands1, _, 
longvarands1right)) :: _ :: ( _, ( MlyValue.longvar longvar1, 
longvar1left, _)) :: rest671)) => let val  result = 
MlyValue.longvarands (fn _ => let val  (longvar as longvar1) = 
longvar1 ()
 val  (longvarands as longvarands1) = longvarands1 ()
 in (longvar :: longvarands)
end)
 in ( LrTable.NT 74, ( result, longvar1left, longvarands1right), 
rest671)
end
|  ( 195, ( ( _, ( MlyValue.rules rules1, (rulesleft as rules1left), (
rulesright as rules1right))) :: rest671)) => let val  result = 
MlyValue.match (fn _ => let val  (rules as rules1) = rules1 ()
 in (
Match.makeRegion' (Match.T (Vector.fromList rules),
                                            rulesleft, rulesright)
)
end)
 in ( LrTable.NT 77, ( result, rules1left, rules1right), rest671)
end
|  ( 196, ( ( _, ( MlyValue.rule rule1, rule1left, rule1right)) :: 
rest671)) => let val  result = MlyValue.rules (fn _ => let val  (rule
 as rule1) = rule1 ()
 in ([rule])
end)
 in ( LrTable.NT 91, ( result, rule1left, rule1right), rest671)
end
|  ( 197, ( ( _, ( MlyValue.rules rules1, _, rules1right)) :: _ :: ( _
, ( MlyValue.rule rule1, rule1left, _)) :: rest671)) => let val  
result = MlyValue.rules (fn _ => let val  (rule as rule1) = rule1 ()
 val  (rules as rules1) = rules1 ()
 in (rule :: rules)
end)
 in ( LrTable.NT 91, ( result, rule1left, rules1right), rest671)
end
|  ( 198, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( 
MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = 
MlyValue.rule (fn _ => let val  (pat as pat1) = pat1 ()
 val  (exp as exp1) = exp1 ()
 in ((pat,exp))
end)
 in ( LrTable.NT 90, ( result, pat1left, exp1right), rest671)
end
|  ( 199, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( 
MlyValue.field field1, field1left, _)) :: rest671)) => let val  result
 = MlyValue.elabel (fn _ => let val  (field as field1) = field1 ()
 val  (exp as exp1) = exp1 ()
 in (field,exp)
end)
 in ( LrTable.NT 40, ( result, field1left, exp1right), rest671)
end
|  ( 200, ( ( _, ( MlyValue.elabels elabels1, _, elabels1right)) :: _
 :: ( _, ( MlyValue.elabel elabel1, elabel1left, _)) :: rest671)) =>
 let val  result = MlyValue.elabels (fn _ => let val  (elabel as 
elabel1) = elabel1 ()
 val  (elabels as elabels1) = elabels1 ()
 in (elabel :: elabels)
end)
 in ( LrTable.NT 41, ( result, elabel1left, elabels1right), rest671)

end
|  ( 201, ( ( _, ( MlyValue.elabel elabel1, elabel1left, elabel1right)
) :: rest671)) => let val  result = MlyValue.elabels (fn _ => let val 
 (elabel as elabel1) = elabel1 ()
 in ([elabel])
end)
 in ( LrTable.NT 41, ( result, elabel1left, elabel1right), rest671)

end
|  ( 202, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( 
MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = 
MlyValue.exp_ps (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ([exp1, exp2])
end)
 in ( LrTable.NT 47, ( result, exp1left, exp2right), rest671)
end
|  ( 203, ( ( _, ( MlyValue.exp_ps exp_ps1, _, exp_ps1right)) :: _ :: 
( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  
result = MlyValue.exp_ps (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_ps as exp_ps1) = exp_ps1 ()
 in (exp :: exp_ps)
end)
 in ( LrTable.NT 47, ( result, exp1left, exp_ps1right), rest671)
end
|  ( 204, ( ( _, ( MlyValue.expnode expnode1, (expnodeleft as 
expnode1left), (expnoderight as expnode1right))) :: rest671)) => let
 val  result = MlyValue.exp (fn _ => let val  (expnode as expnode1) = 
expnode1 ()
 in (Exp.makeRegion' (expnode, expnodeleft, expnoderight))
end)
 in ( LrTable.NT 44, ( result, expnode1left, expnode1right), rest671)

end
|  ( 205, ( ( _, ( MlyValue.match match1, _, match1right)) :: _ :: ( _
, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result =
 MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 val  (match as match1) = match1 ()
 in (Exp.Handle (exp, match))
end)
 in ( LrTable.NT 48, ( result, exp1left, match1right), rest671)
end
|  ( 206, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( 
MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = 
MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in (Exp.Orelse (exp1, exp2))
end)
 in ( LrTable.NT 48, ( result, exp1left, exp2right), rest671)
end
|  ( 207, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( 
MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = 
MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in (Exp.Andalso (exp1, exp2))
end)
 in ( LrTable.NT 48, ( result, exp1left, exp2right), rest671)
end
|  ( 208, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = 
MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 val  (ty as ty1) = ty1 ()
 in (Exp.Constraint (exp, ty))
end)
 in ( LrTable.NT 48, ( result, exp1left, ty1right), rest671)
end
|  ( 209, ( ( _, ( MlyValue.app_exp app_exp1, app_exp1left, 
app_exp1right)) :: rest671)) => let val  result = MlyValue.expnode (fn
 _ => let val  (app_exp as app_exp1) = app_exp1 ()
 in (Exp.FlatApp (Vector.fromList app_exp))
end)
 in ( LrTable.NT 48, ( result, app_exp1left, app_exp1right), rest671)

end
|  ( 210, ( ( _, ( MlyValue.match match1, _, match1right)) :: ( _, ( _
, FN1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn
 _ => let val  (match as match1) = match1 ()
 in (Exp.Fn match)
end)
 in ( LrTable.NT 48, ( result, FN1left, match1right), rest671)
end
|  ( 211, ( ( _, ( MlyValue.match match1, _, match1right)) :: _ :: ( _
, ( MlyValue.exp exp1, _, _)) :: ( _, ( _, CASE1left, _)) :: rest671))
 => let val  result = MlyValue.expnode (fn _ => let val  (exp as exp1)
 = exp1 ()
 val  (match as match1) = match1 ()
 in (Exp.Case (exp, match))
end)
 in ( LrTable.NT 48, ( result, CASE1left, match1right), rest671)
end
|  ( 212, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( 
MlyValue.exp exp1, _, _)) :: ( _, ( _, WHILE1left, _)) :: rest671)) =>
 let val  result = MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in (Exp.While {test = exp1, expr = exp2})
end)
 in ( LrTable.NT 48, ( result, WHILE1left, exp2right), rest671)
end
|  ( 213, ( ( _, ( MlyValue.exp exp3, _, exp3right)) :: _ :: ( _, ( 
MlyValue.exp exp2, _, _)) :: _ :: ( _, ( MlyValue.exp exp1, _, _)) :: 
( _, ( _, IF1left, _)) :: rest671)) => let val  result = 
MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 val  exp3 = exp3 ()
 in (Exp.If (exp1, exp2, exp3))
end)
 in ( LrTable.NT 48, ( result, IF1left, exp3right), rest671)
end
|  ( 214, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: ( _, ( _, 
RAISE1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn
 _ => let val  (exp as exp1) = exp1 ()
 in (Exp.Raise exp)
end)
 in ( LrTable.NT 48, ( result, RAISE1left, exp1right), rest671)
end
|  ( 215, ( ( _, ( MlyValue.app_exp1 app_exp11, _, app_exp11right)) ::
 ( _, ( MlyValue.aexp aexp1, (aexpleft as aexp1left), aexpright)) :: 
rest671)) => let val  result = MlyValue.app_exp (fn _ => let val  (
aexp as aexp1) = aexp1 ()
 val  (app_exp1 as app_exp11) = app_exp11 ()
 in (
Exp.makeRegion' (aexp, aexpleft, aexpright)
                             :: app_exp1
)
end)
 in ( LrTable.NT 6, ( result, aexp1left, app_exp11right), rest671)
end
|  ( 216, ( ( _, ( MlyValue.app_exp1 app_exp11, _, app_exp11right)) ::
 ( _, ( MlyValue.longvid longvid1, (longvidleft as longvid1left), 
longvidright)) :: rest671)) => let val  result = MlyValue.app_exp (fn
 _ => let val  (longvid as longvid1) = longvid1 ()
 val  (app_exp1 as app_exp11) = app_exp11 ()
 in (
Exp.makeRegion' (Exp.Var {name = longvid,
                                                       fixop = Fixop.None},
                                             longvidleft, longvidright)
                             :: app_exp1
)
end)
 in ( LrTable.NT 6, ( result, longvid1left, app_exp11right), rest671)

end
|  ( 217, ( rest671)) => let val  result = MlyValue.app_exp1 (fn _ =>
 ([]))
 in ( LrTable.NT 7, ( result, defaultPos, defaultPos), rest671)
end
|  ( 218, ( ( _, ( MlyValue.app_exp app_exp1, app_exp1left, 
app_exp1right)) :: rest671)) => let val  result = MlyValue.app_exp1
 (fn _ => let val  (app_exp as app_exp1) = app_exp1 ()
 in (app_exp)
end)
 in ( LrTable.NT 7, ( result, app_exp1left, app_exp1right), rest671)

end
|  ( 219, ( ( _, ( MlyValue.vid vid1, _, vid1right)) :: ( _, ( _, 
OP1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ =>
 let val  (vid as vid1) = vid1 ()
 in (
Exp.Var {name = Longvid.short vid,
                                         fixop = Fixop.Op}
)
end)
 in ( LrTable.NT 0, ( result, OP1left, vid1right), rest671)
end
|  ( 220, ( ( _, ( MlyValue.const const1, const1left, const1right)) ::
 rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (const
 as const1) = const1 ()
 in (Exp.Const const)
end)
 in ( LrTable.NT 0, ( result, const1left, const1right), rest671)
end
|  ( 221, ( ( _, ( MlyValue.field field1, _, field1right)) :: ( _, ( _
, HASH1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _
 => let val  (field as field1) = field1 ()
 in (Exp.Selector field)
end)
 in ( LrTable.NT 0, ( result, HASH1left, field1right), rest671)
end
|  ( 222, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.elabels 
elabels1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let
 val  result = MlyValue.aexp (fn _ => let val  (elabels as elabels1) =
 elabels1 ()
 in (Exp.Record (Record.fromVector (Vector.fromList elabels)))
end)
 in ( LrTable.NT 0, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 223, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _))
 :: rest671)) => let val  result = MlyValue.aexp (fn _ => (Exp.unit))
 in ( LrTable.NT 0, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 224, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( _, LPAREN1left, _))
 :: rest671)) => let val  result = MlyValue.aexp (fn _ => (Exp.unit))
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 225, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.expnode 
expnode1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let
 val  result = MlyValue.aexp (fn _ => let val  (expnode as expnode1) =
 expnode1 ()
 in (expnode)
end)
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 226, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.exp_ps 
exp_ps1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val 
 result = MlyValue.aexp (fn _ => let val  (exp_ps as exp_ps1) = 
exp_ps1 ()
 in (Exp.Seq (Vector.fromList exp_ps))
end)
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 227, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.exp_2c 
exp_2c1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val 
 result = MlyValue.aexp (fn _ => let val  (exp_2c as exp_2c1) = 
exp_2c1 ()
 in (Exp.tuple (Vector.fromList exp_2c))
end)
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 228, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.exp_list 
exp_list1, _, _)) :: ( _, ( _, LBRACKET1left, _)) :: rest671)) => let
 val  result = MlyValue.aexp (fn _ => let val  (exp_list as exp_list1)
 = exp_list1 ()
 in (Exp.List (Vector.fromList exp_list))
end)
 in ( LrTable.NT 0, ( result, LBRACKET1left, RBRACKET1right), rest671)

end
|  ( 229, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( _, LBRACKET1left,
 _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => (
Exp.List (Vector.new0 ())))
 in ( LrTable.NT 0, ( result, LBRACKET1left, RBRACKET1right), rest671)

end
|  ( 230, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.exp exp1, _, _
)) :: _ :: ( _, ( MlyValue.decs decs1, _, _)) :: ( _, ( _, LET1left, _
)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (
decs as decs1) = decs1 ()
 val  (exp as exp1) = exp1 ()
 in (Exp.Let (decs, exp))
end)
 in ( LrTable.NT 0, ( result, LET1left, END1right), rest671)
end
|  ( 231, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.exp_ps exp_ps1
, exp_psleft, exp_psright)) :: _ :: ( _, ( MlyValue.decs decs1, _, _))
 :: ( _, ( _, LET1left, _)) :: rest671)) => let val  result = 
MlyValue.aexp (fn _ => let val  (decs as decs1) = decs1 ()
 val  (exp_ps as exp_ps1) = exp_ps1 ()
 in (
Exp.Let (decs, Exp.makeRegion' (Exp.Seq (Vector.fromList exp_ps),
                                             exp_psleft,
                                             exp_psright))
)
end)
 in ( LrTable.NT 0, ( result, LET1left, END1right), rest671)
end
|  ( 232, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, 
ADDRESS1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn
 _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.Address {name = string,
                                       ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, ADDRESS1left, SEMICOLON1right), rest671)

end
|  ( 233, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, 
BUILD_CONST1left, _)) :: rest671)) => let val  result = MlyValue.aexp
 (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in (Exp.Prim (PrimKind.BuildConst {name = string, ty = ty}))
end)
 in ( LrTable.NT 0, ( result, BUILD_CONST1left, SEMICOLON1right), 
rest671)
end
|  ( 234, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( 
MlyValue.constOrBool constOrBool1, _, _)) :: _ :: ( _, ( MlyValue.ty 
ty1, _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _
, COMMAND_LINE_CONST1left, _)) :: rest671)) => let val  result = 
MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 val  (constOrBool as constOrBool1) = constOrBool1 ()
 in (
Exp.Prim (PrimKind.CommandLineConst {name = string,
                                                ty = ty,
                                                value = constOrBool})
)
end)
 in ( LrTable.NT 0, ( result, COMMAND_LINE_CONST1left, SEMICOLON1right
), rest671)
end
|  ( 235, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, 
CONST1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _
 => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in (Exp.Prim (PrimKind.Const {name = string, ty = ty}))
end)
 in ( LrTable.NT 0, ( result, CONST1left, SEMICOLON1right), rest671)

end
|  ( 236, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) :: 
( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, EXPORT1left, _))
 :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (
string as string1) = string1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.Export {attributes = ieattributes,
                                      name = string,
                                      ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, EXPORT1left, SEMICOLON1right), rest671)

end
|  ( 237, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) :: 
( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, IMPORT1left, _))
 :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (
string as string1) = string1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.Import {attributes = ieattributes,
                                      name = string,
                                      ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, IMPORT1left, SEMICOLON1right), rest671)

end
|  ( 238, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) ::
 _ :: ( _, ( _, IMPORT1left, _)) :: rest671)) => let val  result = 
MlyValue.aexp (fn _ => let val  (ieattributes as ieattributes1) = 
ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.IImport {attributes = ieattributes,
                                       ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, IMPORT1left, SEMICOLON1right), rest671)

end
|  ( 239, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, 
PRIM1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _
 => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.Prim {name = string,
                                    ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, PRIM1left, SEMICOLON1right), rest671)

end
|  ( 240, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: ( _, ( MlyValue.symattributes symattributes1, _, _))
 :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, SYMBOL1left, _
)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (
string as string1) = string1 ()
 val  (symattributes as symattributes1) = symattributes1 ()
 val  (ty as ty1) = ty1 ()
 in (
Exp.Prim (PrimKind.Symbol {attributes = symattributes,
                                      name = string,
                                      ty = ty})
)
end)
 in ( LrTable.NT 0, ( result, SYMBOL1left, SEMICOLON1right), rest671)

end
|  ( 241, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1,
 _, _)) :: _ :: _ :: ( _, ( _, SYMBOL1left, _)) :: rest671)) => let
 val  result = MlyValue.aexp (fn _ => let val  (ty as ty1) = ty1 ()
 in (Exp.Prim (PrimKind.ISymbol {ty = ty}))
end)
 in ( LrTable.NT 0, ( result, SYMBOL1left, SEMICOLON1right), rest671)

end
|  ( 242, ( rest671)) => let val  result = MlyValue.ieattributes (fn _
 => ([]))
 in ( LrTable.NT 9, ( result, defaultPos, defaultPos), rest671)
end
|  ( 243, ( ( _, ( MlyValue.ieattributes ieattributes1, _, 
ieattributes1right)) :: ( _, ( MlyValue.id id1, (idleft as id1left), 
idright)) :: rest671)) => let val  result = MlyValue.ieattributes (fn
 _ => let val  (id as id1) = id1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 in (
let
         val id = Symbol.toString (#1 id)
      in
         case id of
            "cdecl" => PrimKind.ImportExportAttribute.Cdecl :: ieattributes
          | "stdcall" => PrimKind.ImportExportAttribute.Stdcall :: ieattributes
          | _ => (error (reg (idleft, idright), concat ["invalid attribute", id])
                  ; ieattributes)
      end
)
end)
 in ( LrTable.NT 9, ( result, id1left, ieattributes1right), rest671)

end
|  ( 244, ( rest671)) => let val  result = MlyValue.symattributes (fn
 _ => ([]))
 in ( LrTable.NT 130, ( result, defaultPos, defaultPos), rest671)
end
|  ( 245, ( ( _, ( MlyValue.symattributes symattributes1, _, 
symattributes1right)) :: ( _, ( MlyValue.id id1, (idleft as id1left), 
idright)) :: rest671)) => let val  result = MlyValue.symattributes (fn
 _ => let val  (id as id1) = id1 ()
 val  (symattributes as symattributes1) = symattributes1 ()
 in (
let
         val id = Symbol.toString (#1 id)
      in
         case id of
            "alloc" => PrimKind.SymbolAttribute.Alloc :: symattributes
          | _ => (error (reg (idleft, idright), concat ["invalid attribute", id])
                  ; symattributes)
      end
)
end)
 in ( LrTable.NT 130, ( result, id1left, symattributes1right), rest671
)
end
|  ( 246, ( ( _, ( MlyValue.exp_2c exp_2c1, _, exp_2c1right)) :: _ :: 
( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  
result = MlyValue.exp_2c (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_2c as exp_2c1) = exp_2c1 ()
 in (exp :: exp_2c)
end)
 in ( LrTable.NT 45, ( result, exp1left, exp_2c1right), rest671)
end
|  ( 247, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( 
MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = 
MlyValue.exp_2c (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ([exp1, exp2])
end)
 in ( LrTable.NT 45, ( result, exp1left, exp2right), rest671)
end
|  ( 248, ( ( _, ( MlyValue.exp exp1, exp1left, exp1right)) :: rest671
)) => let val  result = MlyValue.exp_list (fn _ => let val  (exp as 
exp1) = exp1 ()
 in ([exp])
end)
 in ( LrTable.NT 46, ( result, exp1left, exp1right), rest671)
end
|  ( 249, ( ( _, ( MlyValue.exp_list exp_list1, _, exp_list1right)) ::
 _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val 
 result = MlyValue.exp_list (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_list as exp_list1) = exp_list1 ()
 in (exp :: exp_list)
end)
 in ( LrTable.NT 46, ( result, exp1left, exp_list1right), rest671)
end
|  ( 250, ( ( _, ( MlyValue.patnode patnode1, (patnodeleft as 
patnode1left), (patnoderight as patnode1right))) :: rest671)) => let
 val  result = MlyValue.pat (fn _ => let val  (patnode as patnode1) = 
patnode1 ()
 in (Pat.makeRegion' (patnode, patnodeleft, patnoderight))
end)
 in ( LrTable.NT 81, ( result, patnode1left, patnode1right), rest671)

end
|  ( 251, ( ( _, ( MlyValue.pat pat2, _, pat2right)) :: _ :: ( _, ( 
MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = 
MlyValue.patnode (fn _ => let val  pat1 = pat1 ()
 val  pat2 = pat2 ()
 in (Pat.makeAs (pat1, pat2))
end)
 in ( LrTable.NT 85, ( result, pat1left, pat2right), rest671)
end
|  ( 252, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = 
MlyValue.patnode (fn _ => let val  (pat as pat1) = pat1 ()
 val  (ty as ty1) = ty1 ()
 in (Pat.Constraint (pat, ty))
end)
 in ( LrTable.NT 85, ( result, pat1left, ty1right), rest671)
end
|  ( 253, ( ( _, ( MlyValue.apats apats1, apats1left, apats1right)) ::
 rest671)) => let val  result = MlyValue.patnode (fn _ => let val  (
apats as apats1) = apats1 ()
 in (Pat.FlatApp (Vector.fromList apats))
end)
 in ( LrTable.NT 85, ( result, apats1left, apats1right), rest671)
end
|  ( 254, ( ( _, ( MlyValue.apat apat1, apat1left, apat1right)) :: 
rest671)) => let val  result = MlyValue.apats (fn _ => let val  (apat
 as apat1) = apat1 ()
 in ([apat])
end)
 in ( LrTable.NT 5, ( result, apat1left, apat1right), rest671)
end
|  ( 255, ( ( _, ( MlyValue.apats apats1, _, apats1right)) :: ( _, ( 
MlyValue.apat apat1, apat1left, _)) :: rest671)) => let val  result = 
MlyValue.apats (fn _ => let val  (apat as apat1) = apat1 ()
 val  (apats as apats1) = apats1 ()
 in (apat :: apats)
end)
 in ( LrTable.NT 5, ( result, apat1left, apats1right), rest671)
end
|  ( 256, ( ( _, ( MlyValue.apatnode apatnode1, (apatnodeleft as 
apatnode1left), (apatnoderight as apatnode1right))) :: rest671)) =>
 let val  result = MlyValue.apat (fn _ => let val  (apatnode as 
apatnode1) = apatnode1 ()
 in (Pat.makeRegion' (apatnode, apatnodeleft, apatnoderight))
end)
 in ( LrTable.NT 2, ( result, apatnode1left, apatnode1right), rest671)

end
|  ( 257, ( ( _, ( MlyValue.longvidNoEqual longvidNoEqual1, 
longvidNoEqual1left, longvidNoEqual1right)) :: rest671)) => let val  
result = MlyValue.apatnode (fn _ => let val  (longvidNoEqual as 
longvidNoEqual1) = longvidNoEqual1 ()
 in (
Pat.Var {name = longvidNoEqual,
                                           fixop = Fixop.None}
)
end)
 in ( LrTable.NT 4, ( result, longvidNoEqual1left, 
longvidNoEqual1right), rest671)
end
|  ( 258, ( ( _, ( MlyValue.vid vid1, _, vid1right)) :: ( _, ( _, 
OP1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _
 => let val  (vid as vid1) = vid1 ()
 in (
Pat.Var {name = Longvid.short vid,
                                           fixop = Fixop.Op}
)
end)
 in ( LrTable.NT 4, ( result, OP1left, vid1right), rest671)
end
|  ( 259, ( ( _, ( MlyValue.const const1, const1left, const1right)) ::
 rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (
const as const1) = const1 ()
 in (
let
              val _ =
                 case Const.node const of
                    Const.Real r =>
                       let
                          open Layout
                       in
                          Control.error
                          (Const.region const,
                           seq [str "real constants are not allowed in patterns: ",
                                Const.layout const],
                           empty)
                       end
                    | _ => ()
           in
              Pat.Const const
           end
)
end)
 in ( LrTable.NT 4, ( result, const1left, const1right), rest671)
end
|  ( 260, ( ( _, ( _, WILD1left, WILD1right)) :: rest671)) => let val 
 result = MlyValue.apatnode (fn _ => (Pat.Wild))
 in ( LrTable.NT 4, ( result, WILD1left, WILD1right), rest671)
end
|  ( 261, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.pats pats1,
 _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result
 = MlyValue.apatnode (fn _ => let val  (pats as pats1) = pats1 ()
 in (Pat.tuple (Vector.fromList pats))
end)
 in ( LrTable.NT 4, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 262, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.pats 
pats1, _, _)) :: ( _, ( _, LBRACKET1left, _)) :: rest671)) => let val 
 result = MlyValue.apatnode (fn _ => let val  (pats as pats1) = pats1
 ()
 in (Pat.List (Vector.fromList pats))
end)
 in ( LrTable.NT 4, ( result, LBRACKET1left, RBRACKET1right), rest671)

end
|  ( 263, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _))
 :: rest671)) => let val  result = MlyValue.apatnode (fn _ => (
Pat.unit))
 in ( LrTable.NT 4, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 264, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.patitems 
patitems1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let
 val  result = MlyValue.apatnode (fn _ => let val  (patitems as 
patitems1) = patitems1 ()
 in (
let
              val (items, flexible) = patitems
           in
              Pat.Record {flexible = flexible,
                          items = Vector.fromList items}
           end
)
end)
 in ( LrTable.NT 4, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 265, ( rest671)) => let val  result = MlyValue.pats (fn _ => ([])
)
 in ( LrTable.NT 86, ( result, defaultPos, defaultPos), rest671)
end
|  ( 266, ( ( _, ( MlyValue.commapats commapats1, _, commapats1right))
 :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  
result = MlyValue.pats (fn _ => let val  (pat as pat1) = pat1 ()
 val  (commapats as commapats1) = commapats1 ()
 in (pat :: commapats)
end)
 in ( LrTable.NT 86, ( result, pat1left, commapats1right), rest671)

end
|  ( 267, ( rest671)) => let val  result = MlyValue.commapats (fn _ =>
 ([]))
 in ( LrTable.NT 13, ( result, defaultPos, defaultPos), rest671)
end
|  ( 268, ( ( _, ( MlyValue.commapats commapats1, _, commapats1right))
 :: ( _, ( MlyValue.pat pat1, _, _)) :: ( _, ( _, COMMA1left, _)) :: 
rest671)) => let val  result = MlyValue.commapats (fn _ => let val  (
pat as pat1) = pat1 ()
 val  (commapats as commapats1) = commapats1 ()
 in (pat :: commapats)
end)
 in ( LrTable.NT 13, ( result, COMMA1left, commapats1right), rest671)

end
|  ( 269, ( ( _, ( MlyValue.patitems patitems1, _, patitems1right)) ::
 _ :: ( _, ( MlyValue.patitem patitem1, patitem1left, _)) :: rest671))
 => let val  result = MlyValue.patitems (fn _ => let val  (patitem as 
patitem1) = patitem1 ()
 val  (patitems as patitems1) = patitems1 ()
 in (
let val (items, f) = patitems
                                    in (patitem :: items, f)
                                    end
)
end)
 in ( LrTable.NT 84, ( result, patitem1left, patitems1right), rest671)

end
|  ( 270, ( ( _, ( MlyValue.patitem patitem1, patitem1left, 
patitem1right)) :: rest671)) => let val  result = MlyValue.patitems
 (fn _ => let val  (patitem as patitem1) = patitem1 ()
 in ([patitem], false)
end)
 in ( LrTable.NT 84, ( result, patitem1left, patitem1right), rest671)

end
|  ( 271, ( ( _, ( _, DOTDOTDOT1left, DOTDOTDOT1right)) :: rest671))
 => let val  result = MlyValue.patitems (fn _ => ([], true))
 in ( LrTable.NT 84, ( result, DOTDOTDOT1left, DOTDOTDOT1right), 
rest671)
end
|  ( 272, ( ( _, ( MlyValue.pat pat1, _, pat1right)) :: _ :: ( _, ( 
MlyValue.field field1, field1left, _)) :: rest671)) => let val  result
 = MlyValue.patitem (fn _ => let val  (field as field1) = field1 ()
 val  (pat as pat1) = pat1 ()
 in ((field, Pat.Item.Field pat))
end)
 in ( LrTable.NT 83, ( result, field1left, pat1right), rest671)
end
|  ( 273, ( ( _, ( MlyValue.opaspat opaspat1, _, opaspat1right)) :: (
 _, ( MlyValue.constraint constraint1, _, _)) :: ( _, ( 
MlyValue.vidNoEqual vidNoEqual1, vidNoEqual1left, _)) :: rest671)) =>
 let val  result = MlyValue.patitem (fn _ => let val  (vidNoEqual as 
vidNoEqual1) = vidNoEqual1 ()
 val  (constraint as constraint1) = constraint1 ()
 val  (opaspat as opaspat1) = opaspat1 ()
 in (
Field.Symbol (Vid.toSymbol vidNoEqual),
      Pat.Item.Vid (vidNoEqual, constraint, opaspat)
)
end)
 in ( LrTable.NT 83, ( result, vidNoEqual1left, opaspat1right), 
rest671)
end
|  ( 274, ( rest671)) => let val  result = MlyValue.opaspat (fn _ => (
NONE))
 in ( LrTable.NT 78, ( result, defaultPos, defaultPos), rest671)
end
|  ( 275, ( ( _, ( MlyValue.pat pat1, _, pat1right)) :: ( _, ( _, 
AS1left, _)) :: rest671)) => let val  result = MlyValue.opaspat (fn _
 => let val  (pat as pat1) = pat1 ()
 in (SOME pat)
end)
 in ( LrTable.NT 78, ( result, AS1left, pat1right), rest671)
end
|  ( 276, ( ( _, ( MlyValue.tynode tynode1, (tynodeleft as tynode1left
), (tynoderight as tynode1right))) :: rest671)) => let val  result = 
MlyValue.ty (fn _ => let val  (tynode as tynode1) = tynode1 ()
 in (Type.makeRegion' (tynode, tynodeleft, tynoderight))
end)
 in ( LrTable.NT 137, ( result, tynode1left, tynode1right), rest671)

end
|  ( 277, ( ( _, ( MlyValue.tuple_ty tuple_ty1, tuple_ty1left, 
tuple_ty1right)) :: rest671)) => let val  result = MlyValue.tynode (fn
 _ => let val  (tuple_ty as tuple_ty1) = tuple_ty1 ()
 in (Type.tuple (Vector.fromList tuple_ty))
end)
 in ( LrTable.NT 144, ( result, tuple_ty1left, tuple_ty1right), 
rest671)
end
|  ( 278, ( ( _, ( MlyValue.ty ty2, _, ty2right)) :: _ :: ( _, ( 
MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result = 
MlyValue.tynode (fn _ => let val  ty1 = ty1 ()
 val  ty2 = ty2 ()
 in (Type.arrow (ty1, ty2))
end)
 in ( LrTable.NT 144, ( result, ty1left, ty2right), rest671)
end
|  ( 279, ( ( _, ( MlyValue.ty'node ty'node1, ty'node1left, 
ty'node1right)) :: rest671)) => let val  result = MlyValue.tynode (fn
 _ => let val  (ty'node as ty'node1) = ty'node1 ()
 in (ty'node)
end)
 in ( LrTable.NT 144, ( result, ty'node1left, ty'node1right), rest671)

end
|  ( 280, ( ( _, ( MlyValue.ty'node ty'node1, (ty'nodeleft as 
ty'node1left), (ty'noderight as ty'node1right))) :: rest671)) => let
 val  result = MlyValue.ty' (fn _ => let val  (ty'node as ty'node1) = 
ty'node1 ()
 in (Type.makeRegion' (ty'node, ty'nodeleft, ty'noderight))
end)
 in ( LrTable.NT 138, ( result, ty'node1left, ty'node1right), rest671)

end
|  ( 281, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) ::
 rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (
tyvar as tyvar1) = tyvar1 ()
 in (Type.Var tyvar)
end)
 in ( LrTable.NT 139, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 282, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.tlabels 
tlabels1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let
 val  result = MlyValue.ty'node (fn _ => let val  (tlabels as tlabels1
) = tlabels1 ()
 in (Type.Record (Srecord.fromVector (Vector.fromList tlabels)))
end)
 in ( LrTable.NT 139, ( result, LBRACE1left, RBRACE1right), rest671)

end
|  ( 283, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _))
 :: rest671)) => let val  result = MlyValue.ty'node (fn _ => (
Type.unit))
 in ( LrTable.NT 139, ( result, LBRACE1left, RBRACE1right), rest671)

end
|  ( 284, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right))
 :: _ :: ( _, ( MlyValue.ty0_pc ty0_pc1, _, _)) :: ( _, ( _, 
LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.ty'node
 (fn _ => let val  (ty0_pc as ty0_pc1) = ty0_pc1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in (
Type.Con (longtycon,
                                                     Vector.fromList ty0_pc)
)
end)
 in ( LrTable.NT 139, ( result, LPAREN1left, longtycon1right), rest671
)
end
|  ( 285, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.ty ty1, _,
 _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = 
MlyValue.ty'node (fn _ => let val  (ty as ty1) = ty1 ()
 in (Type.node ty)
end)
 in ( LrTable.NT 139, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 286, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right))
 :: ( _, ( MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val  
result = MlyValue.ty'node (fn _ => let val  (ty' as ty'1) = ty'1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in (
Type.Con (longtycon,
                                                     Vector.new1 ty')
)
end)
 in ( LrTable.NT 139, ( result, ty'1left, longtycon1right), rest671)

end
|  ( 287, ( ( _, ( MlyValue.longtycon longtycon1, longtycon1left, 
longtycon1right)) :: rest671)) => let val  result = MlyValue.ty'node
 (fn _ => let val  (longtycon as longtycon1) = longtycon1 ()
 in (
Type.Con (longtycon,
                                                     Vector.new0 ())
)
end)
 in ( LrTable.NT 139, ( result, longtycon1left, longtycon1right), 
rest671)
end
|  ( 288, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( 
MlyValue.field field1, field1left, _)) :: rest671)) => let val  result
 = MlyValue.tlabel (fn _ => let val  (field as field1) = field1 ()
 val  (ty as ty1) = ty1 ()
 in (field, ty)
end)
 in ( LrTable.NT 131, ( result, field1left, ty1right), rest671)
end
|  ( 289, ( ( _, ( MlyValue.tlabels tlabels1, _, tlabels1right)) :: _
 :: ( _, ( MlyValue.tlabel tlabel1, tlabel1left, _)) :: rest671)) =>
 let val  result = MlyValue.tlabels (fn _ => let val  (tlabel as 
tlabel1) = tlabel1 ()
 val  (tlabels as tlabels1) = tlabels1 ()
 in (tlabel :: tlabels)
end)
 in ( LrTable.NT 132, ( result, tlabel1left, tlabels1right), rest671)

end
|  ( 290, ( ( _, ( MlyValue.tlabel tlabel1, tlabel1left, tlabel1right)
) :: rest671)) => let val  result = MlyValue.tlabels (fn _ => let val 
 (tlabel as tlabel1) = tlabel1 ()
 in ([tlabel])
end)
 in ( LrTable.NT 132, ( result, tlabel1left, tlabel1right), rest671)

end
|  ( 291, ( ( _, ( MlyValue.tuple_ty tuple_ty1, _, tuple_ty1right)) ::
 _ :: ( _, ( MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val 
 result = MlyValue.tuple_ty (fn _ => let val  (ty' as ty'1) = ty'1 ()
 val  (tuple_ty as tuple_ty1) = tuple_ty1 ()
 in (ty' :: tuple_ty)
end)
 in ( LrTable.NT 136, ( result, ty'1left, tuple_ty1right), rest671)

end
|  ( 292, ( ( _, ( MlyValue.ty' ty'2, _, ty'2right)) :: _ :: ( _, ( 
MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val  result = 
MlyValue.tuple_ty (fn _ => let val  ty'1 = ty'1 ()
 val  ty'2 = ty'2 ()
 in ([ty'1, ty'2])
end)
 in ( LrTable.NT 136, ( result, ty'1left, ty'2right), rest671)
end
|  ( 293, ( ( _, ( MlyValue.ty ty2, _, ty2right)) :: _ :: ( _, ( 
MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result = 
MlyValue.ty0_pc (fn _ => let val  ty1 = ty1 ()
 val  ty2 = ty2 ()
 in ([ty1, ty2])
end)
 in ( LrTable.NT 140, ( result, ty1left, ty2right), rest671)
end
|  ( 294, ( ( _, ( MlyValue.ty0_pc ty0_pc1, _, ty0_pc1right)) :: _ :: 
( _, ( MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result =
 MlyValue.ty0_pc (fn _ => let val  (ty as ty1) = ty1 ()
 val  (ty0_pc as ty0_pc1) = ty0_pc1 ()
 in (ty :: ty0_pc)
end)
 in ( LrTable.NT 140, ( result, ty1left, ty0_pc1right), rest671)
end
|  ( 295, ( ( _, ( MlyValue.const const1, const1left, const1right)) ::
 rest671)) => let val  result = MlyValue.constOrBool (fn _ => let val 
 (const as const1) = const1 ()
 in (const)
end)
 in ( LrTable.NT 20, ( result, const1left, const1right), rest671)
end
|  ( 296, ( ( _, ( MlyValue.id id1, (idleft as id1left), (idright as 
id1right))) :: rest671)) => let val  result = MlyValue.constOrBool (fn
 _ => let val  (id as id1) = id1 ()
 in (
let
            fun ok b = Const.makeRegion (Const.Bool b, reg (idleft, idright))
         in            
            case Symbol.toString (#1 id) of
               "false" => ok false
             | "true" => ok true
             | s => (error (#2 id, concat ["unknown boolean constant: ", s])
                     ; ok false)
         end
)
end)
 in ( LrTable.NT 20, ( result, id1left, id1right), rest671)
end
|  ( 297, ( ( _, ( MlyValue.const' const'1, (const'left as const'1left
), (const'right as const'1right))) :: rest671)) => let val  result = 
MlyValue.const (fn _ => let val  (const' as const'1) = const'1 ()
 in (
Const.makeRegion
                                 (const', reg (const'left, const'right))
)
end)
 in ( LrTable.NT 15, ( result, const'1left, const'1right), rest671)

end
|  ( 298, ( ( _, ( MlyValue.int int1, int1left, int1right)) :: rest671
)) => let val  result = MlyValue.const' (fn _ => let val  (int as int1
) = int1 ()
 in (Const.Int int)
end)
 in ( LrTable.NT 16, ( result, int1left, int1right), rest671)
end
|  ( 299, ( ( _, ( MlyValue.word word1, word1left, word1right)) :: 
rest671)) => let val  result = MlyValue.const' (fn _ => let val  (word
 as word1) = word1 ()
 in (Const.Word word)
end)
 in ( LrTable.NT 16, ( result, word1left, word1right), rest671)
end
|  ( 300, ( ( _, ( MlyValue.REAL REAL1, REAL1left, REAL1right)) :: 
rest671)) => let val  result = MlyValue.const' (fn _ => let val  (REAL
 as REAL1) = REAL1 ()
 in (Const.Real REAL)
end)
 in ( LrTable.NT 16, ( result, REAL1left, REAL1right), rest671)
end
|  ( 301, ( ( _, ( MlyValue.STRING STRING1, STRING1left, STRING1right)
) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val 
 (STRING as STRING1) = STRING1 ()
 in (Const.String STRING)
end)
 in ( LrTable.NT 16, ( result, STRING1left, STRING1right), rest671)

end
|  ( 302, ( ( _, ( MlyValue.CHAR CHAR1, CHAR1left, CHAR1right)) :: 
rest671)) => let val  result = MlyValue.const' (fn _ => let val  (CHAR
 as CHAR1) = CHAR1 ()
 in (Const.Char CHAR)
end)
 in ( LrTable.NT 16, ( result, CHAR1left, CHAR1right), rest671)
end
|  ( 303, ( ( _, ( MlyValue.STRING STRING1, STRING1left, STRING1right)
) :: rest671)) => let val  result = MlyValue.string (fn _ => let val 
 (STRING as STRING1) = STRING1 ()
 in (
CharVector.tabulate
                  (Vector.length STRING, fn i =>
                   Char.fromInt (Int.fromIntInf (Vector.sub (STRING, i))))
)
end)
 in ( LrTable.NT 129, ( result, STRING1left, STRING1right), rest671)

end
|  ( 304, ( ( _, ( MlyValue.longidNoAsterisk longidNoAsterisk1, 
longidNoAsterisk1left, longidNoAsterisk1right)) :: rest671)) => let
 val  result = MlyValue.idNoAsterisk (fn _ => let val  (
longidNoAsterisk as longidNoAsterisk1) = longidNoAsterisk1 ()
 in (ensureNonqualified longidNoAsterisk)
end)
 in ( LrTable.NT 62, ( result, longidNoAsterisk1left, 
longidNoAsterisk1right), rest671)
end
|  ( 305, ( ( _, ( MlyValue.idNoAsterisk idNoAsterisk1, 
idNoAsterisk1left, idNoAsterisk1right)) :: rest671)) => let val  
result = MlyValue.id (fn _ => let val  (idNoAsterisk as idNoAsterisk1)
 = idNoAsterisk1 ()
 in (idNoAsterisk)
end)
 in ( LrTable.NT 60, ( result, idNoAsterisk1left, idNoAsterisk1right),
 rest671)
end
|  ( 306, ( ( _, ( _, (ASTERISKleft as ASTERISK1left), (ASTERISKright
 as ASTERISK1right))) :: rest671)) => let val  result = MlyValue.id
 (fn _ => ((Symbol.asterisk, reg (ASTERISKleft, ASTERISKright))))
 in ( LrTable.NT 60, ( result, ASTERISK1left, ASTERISK1right), rest671
)
end
|  ( 307, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.idEqual (fn _ => let val  (id as id1) =
 id1 ()
 in (id)
end)
 in ( LrTable.NT 61, ( result, id1left, id1right), rest671)
end
|  ( 308, ( ( _, ( _, (EQUALOPleft as EQUALOP1left), (EQUALOPright as 
EQUALOP1right))) :: rest671)) => let val  result = MlyValue.idEqual
 (fn _ => ((Symbol.equal, reg (EQUALOPleft, EQUALOPright))))
 in ( LrTable.NT 61, ( result, EQUALOP1left, EQUALOP1right), rest671)

end
|  ( 309, ( ( _, ( MlyValue.longidNoAsterisk longidNoAsterisk1, 
longidNoAsterisk1left, longidNoAsterisk1right)) :: rest671)) => let
 val  result = MlyValue.longid (fn _ => let val  (longidNoAsterisk as 
longidNoAsterisk1) = longidNoAsterisk1 ()
 in (longidNoAsterisk)
end)
 in ( LrTable.NT 65, ( result, longidNoAsterisk1left, 
longidNoAsterisk1right), rest671)
end
|  ( 310, ( ( _, ( _, (ASTERISKleft as ASTERISK1left), (ASTERISKright
 as ASTERISK1right))) :: rest671)) => let val  result = 
MlyValue.longid (fn _ => (
([Symbol.asterisk], reg (ASTERISKleft, ASTERISKright))))
 in ( LrTable.NT 65, ( result, ASTERISK1left, ASTERISK1right), rest671
)
end
|  ( 311, ( ( _, ( MlyValue.LONGID LONGID1, (LONGIDleft as LONGID1left
), (LONGIDright as LONGID1right))) :: rest671)) => let val  result = 
MlyValue.longidNoAsterisk (fn _ => let val  (LONGID as LONGID1) = 
LONGID1 ()
 in (
let
         val syms = List.map (String.split (LONGID, #"."), Symbol.fromString)
      in
         (syms, reg (LONGIDleft, LONGIDright))
      end
)
end)
 in ( LrTable.NT 67, ( result, LONGID1left, LONGID1right), rest671)

end
|  ( 312, ( ( _, ( MlyValue.longid longid1, longid1left, longid1right)
) :: rest671)) => let val  result = MlyValue.longidEqual (fn _ => let
 val  (longid as longid1) = longid1 ()
 in (longid)
end)
 in ( LrTable.NT 66, ( result, longid1left, longid1right), rest671)

end
|  ( 313, ( ( _, ( _, (EQUALOPleft as EQUALOP1left), (EQUALOPright as 
EQUALOP1right))) :: rest671)) => let val  result = 
MlyValue.longidEqual (fn _ => (
([Symbol.equal], reg (EQUALOPleft, EQUALOPright))))
 in ( LrTable.NT 66, ( result, EQUALOP1left, EQUALOP1right), rest671)

end
|  ( 314, ( ( _, ( MlyValue.idEqual idEqual1, idEqual1left, 
idEqual1right)) :: rest671)) => let val  result = MlyValue.vid (fn _
 => let val  (idEqual as idEqual1) = idEqual1 ()
 in (Vid.fromSymbol idEqual)
end)
 in ( LrTable.NT 160, ( result, idEqual1left, idEqual1right), rest671)

end
|  ( 315, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.vidNoEqual (fn _ => let val  (id as id1
) = id1 ()
 in (Vid.fromSymbol id)
end)
 in ( LrTable.NT 161, ( result, id1left, id1right), rest671)
end
|  ( 316, ( ( _, ( MlyValue.vid vid1, vid1left, vid1right)) :: rest671
)) => let val  result = MlyValue.vids (fn _ => let val  (vid as vid1)
 = vid1 ()
 in ([vid])
end)
 in ( LrTable.NT 162, ( result, vid1left, vid1right), rest671)
end
|  ( 317, ( ( _, ( MlyValue.vids vids1, _, vids1right)) :: ( _, ( 
MlyValue.vid vid1, vid1left, _)) :: rest671)) => let val  result = 
MlyValue.vids (fn _ => let val  (vid as vid1) = vid1 ()
 val  (vids as vids1) = vids1 ()
 in (vid::vids)
end)
 in ( LrTable.NT 162, ( result, vid1left, vids1right), rest671)
end
|  ( 318, ( ( _, ( MlyValue.idEqual idEqual1, idEqual1left, 
idEqual1right)) :: rest671)) => let val  result = MlyValue.var (fn _
 => let val  (idEqual as idEqual1) = idEqual1 ()
 in (Var.fromSymbol idEqual)
end)
 in ( LrTable.NT 159, ( result, idEqual1left, idEqual1right), rest671)

end
|  ( 319, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.con (fn _ => let val  (id as id1) = id1
 ()
 in (Con.fromSymbol id)
end)
 in ( LrTable.NT 14, ( result, id1left, id1right), rest671)
end
|  ( 320, ( ( _, ( MlyValue.idNoAsterisk idNoAsterisk1, 
idNoAsterisk1left, idNoAsterisk1right)) :: rest671)) => let val  
result = MlyValue.tycon (fn _ => let val  (idNoAsterisk as 
idNoAsterisk1) = idNoAsterisk1 ()
 in (Tycon.fromSymbol idNoAsterisk)
end)
 in ( LrTable.NT 143, ( result, idNoAsterisk1left, idNoAsterisk1right)
, rest671)
end
|  ( 321, ( ( _, ( MlyValue.TYVAR TYVAR1, (TYVARleft as TYVAR1left), (
TYVARright as TYVAR1right))) :: rest671)) => let val  result = 
MlyValue.tyvar (fn _ => let val  (TYVAR as TYVAR1) = TYVAR1 ()
 in (
Tyvar.newString (TYVAR, {left = TYVARleft,
                                                         right = TYVARright})
)
end)
 in ( LrTable.NT 150, ( result, TYVAR1left, TYVAR1right), rest671)
end
|  ( 322, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.field (fn _ => let val  (id as id1) = 
id1 ()
 in (Field.Symbol (#1 id))
end)
 in ( LrTable.NT 52, ( result, id1left, id1right), rest671)
end
|  ( 323, ( ( _, ( MlyValue.int int1, (intleft as int1left), (intright
 as int1right))) :: rest671)) => let val  result = MlyValue.field (fn
 _ => let val  (int as int1) = int1 ()
 in (
let
                                   val int =
                                      IntInf.toInt int
                                      handle Exn.Overflow =>
                                         (error (reg (intleft, intright),
                                                 "field too huge")
                                          ; 0)
                                in
                                   Field.Int
                                   (if int <= 0
                                       then (error (reg (intleft, intright),
                                                    "nonpositive field")
                                             ; ~1)
                                    else
                                       int - 1)
                                end
)
end)
 in ( LrTable.NT 52, ( result, int1left, int1right), rest671)
end
|  ( 324, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.strid (fn _ => let val  (id as id1) = 
id1 ()
 in (Strid.fromSymbol id)
end)
 in ( LrTable.NT 128, ( result, id1left, id1right), rest671)
end
|  ( 325, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.sigid (fn _ => let val  (id as id1) = 
id1 ()
 in (Sigid.fromSymbol id)
end)
 in ( LrTable.NT 106, ( result, id1left, id1right), rest671)
end
|  ( 326, ( ( _, ( MlyValue.sigid sigid1, sigid1left, sigid1right)) ::
 rest671)) => let val  result = MlyValue.sigids (fn _ => let val  (
sigid as sigid1) = sigid1 ()
 in ([sigid])
end)
 in ( LrTable.NT 107, ( result, sigid1left, sigid1right), rest671)
end
|  ( 327, ( ( _, ( MlyValue.sigids sigids1, _, sigids1right)) :: ( _, 
( MlyValue.sigid sigid1, sigid1left, _)) :: rest671)) => let val  
result = MlyValue.sigids (fn _ => let val  (sigid as sigid1) = sigid1
 ()
 val  (sigids as sigids1) = sigids1 ()
 in (sigid :: sigids)
end)
 in ( LrTable.NT 107, ( result, sigid1left, sigids1right), rest671)

end
|  ( 328, ( ( _, ( MlyValue.id id1, id1left, id1right)) :: rest671))
 => let val  result = MlyValue.fctid (fn _ => let val  (id as id1) = 
id1 ()
 in (Fctid.fromSymbol id)
end)
 in ( LrTable.NT 51, ( result, id1left, id1right), rest671)
end
|  ( 329, ( ( _, ( MlyValue.longidNoAsterisk longidNoAsterisk1, 
longidNoAsterisk1left, longidNoAsterisk1right)) :: rest671)) => let
 val  result = MlyValue.longtycon (fn _ => let val  (longidNoAsterisk
 as longidNoAsterisk1) = longidNoAsterisk1 ()
 in (Longtycon.fromSymbols longidNoAsterisk)
end)
 in ( LrTable.NT 71, ( result, longidNoAsterisk1left, 
longidNoAsterisk1right), rest671)
end
|  ( 330, ( ( _, ( MlyValue.longidEqual longidEqual1, longidEqual1left
, longidEqual1right)) :: rest671)) => let val  result = 
MlyValue.longvar (fn _ => let val  (longidEqual as longidEqual1) = 
longidEqual1 ()
 in (Longvar.fromSymbols longidEqual)
end)
 in ( LrTable.NT 73, ( result, longidEqual1left, longidEqual1right), 
rest671)
end
|  ( 331, ( ( _, ( MlyValue.longidEqual longidEqual1, longidEqual1left
, longidEqual1right)) :: rest671)) => let val  result = 
MlyValue.longvid (fn _ => let val  (longidEqual as longidEqual1) = 
longidEqual1 ()
 in (Longvid.fromSymbols longidEqual)
end)
 in ( LrTable.NT 75, ( result, longidEqual1left, longidEqual1right), 
rest671)
end
|  ( 332, ( ( _, ( MlyValue.longid longid1, longid1left, longid1right)
) :: rest671)) => let val  result = MlyValue.longvidNoEqual (fn _ =>
 let val  (longid as longid1) = longid1 ()
 in (Longvid.fromSymbols longid)
end)
 in ( LrTable.NT 76, ( result, longid1left, longid1right), rest671)

end
|  ( 333, ( ( _, ( MlyValue.longid longid1, longid1left, longid1right)
) :: rest671)) => let val  result = MlyValue.longcon (fn _ => let val 
 (longid as longid1) = longid1 ()
 in (Longcon.fromSymbols longid)
end)
 in ( LrTable.NT 64, ( result, longid1left, longid1right), rest671)

end
|  ( 334, ( ( _, ( MlyValue.longid longid1, longid1left, longid1right)
) :: rest671)) => let val  result = MlyValue.longstrid (fn _ => let
 val  (longid as longid1) = longid1 ()
 in (Longstrid.fromSymbols longid)
end)
 in ( LrTable.NT 68, ( result, longid1left, longid1right), rest671)

end
|  ( 335, ( ( _, ( MlyValue.longstrid longstrid1, longstrid1left, 
longstrid1right)) :: rest671)) => let val  result = 
MlyValue.longstrids (fn _ => let val  (longstrid as longstrid1) = 
longstrid1 ()
 in ([longstrid])
end)
 in ( LrTable.NT 70, ( result, longstrid1left, longstrid1right), 
rest671)
end
|  ( 336, ( ( _, ( MlyValue.longstrids longstrids1, _, 
longstrids1right)) :: ( _, ( MlyValue.longstrid longstrid1, 
longstrid1left, _)) :: rest671)) => let val  result = 
MlyValue.longstrids (fn _ => let val  (longstrid as longstrid1) = 
longstrid1 ()
 val  (longstrids as longstrids1) = longstrids1 ()
 in (longstrid :: longstrids)
end)
 in ( LrTable.NT 70, ( result, longstrid1left, longstrids1right), 
rest671)
end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.program x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun CHAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.CHAR (fn () => i),p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.INT (fn () => i),p1,p2))
fun LONGID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.LONGID (fn () => i),p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.REAL (fn () => i),p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.STRING (fn () => i),p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.TYVAR (fn () => i),p1,p2))
fun WORD (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.WORD (fn () => i),p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun COLONGT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUALOP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun OVERLOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun WHERE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun WILD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun BUILD_CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMAND_LINE_CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69
,(ParserData.MlyValue.VOID,p1,p2))
fun CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.VOID,p1,p2))
fun ADDRESS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.VOID,p1,p2))
fun EXPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(
ParserData.MlyValue.VOID,p1,p2))
fun SYMBOL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(
ParserData.MlyValue.VOID,p1,p2))
fun PRIM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(
ParserData.MlyValue.VOID,p1,p2))
end
end
