/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.cobertura.ant.AntUtil;
import net.sourceforge.cobertura.ant.CommonMatchingTask;
import net.sourceforge.cobertura.ant.Regex;
import net.sourceforge.cobertura.check.CheckCoverageMain;
import org.apache.tools.ant.BuildException;

public class CheckTask
extends CommonMatchingTask {
    private String dataFile = null;
    final Set<Regex> regexes = new HashSet<Regex>();
    private String branchRate = null;
    private String lineRate = null;
    private String packageBranchRate = null;
    private String packageLineRate = null;
    private String totalBranchRate = null;
    private String totalLineRate = null;
    private String failureProperty = null;
    private boolean haltOnFailure = true;

    public CheckTask() {
        super(CheckCoverageMain.class.getCanonicalName());
    }

    public void execute() throws BuildException {
        if (this.dataFile != null) {
            this.getJava().createArg().setValue("--datafile");
            this.getJava().createArg().setValue(this.dataFile);
        }
        if (this.branchRate != null) {
            this.getJava().createArg().setValue("--branch");
            this.getJava().createArg().setValue(this.branchRate);
        }
        if (this.lineRate != null) {
            this.getJava().createArg().setValue("--line");
            this.getJava().createArg().setValue(this.lineRate);
        }
        if (this.packageBranchRate != null) {
            this.getJava().createArg().setValue("--packagebranch");
            this.getJava().createArg().setValue(this.packageBranchRate);
        }
        if (this.packageLineRate != null) {
            this.getJava().createArg().setValue("--packageline");
            this.getJava().createArg().setValue(this.packageLineRate);
        }
        if (this.totalBranchRate != null) {
            this.getJava().createArg().setValue("--totalbranch");
            this.getJava().createArg().setValue(this.totalBranchRate);
        }
        if (this.totalLineRate != null) {
            this.getJava().createArg().setValue("--totalline");
            this.getJava().createArg().setValue(this.totalLineRate);
        }
        Iterator<Regex> iter = this.regexes.iterator();
        while (iter.hasNext()) {
            this.getJava().createArg().setValue("--regex");
            this.getJava().createArg().setValue(iter.next().toString());
        }
        AntUtil.transferCoberturaDataFileProperty(this.getJava());
        int returnCode = this.getJava().executeJava();
        if (returnCode == 0) {
            System.out.println("All checks passed.");
        } else {
            if (this.haltOnFailure) {
                throw new BuildException("Coverage check failed. See messages above.");
            }
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            } else {
                System.err.println("Coverage check failed. See messages above.");
            }
        }
    }

    public Regex createRegex() {
        Regex regex = new Regex();
        this.regexes.add(regex);
        return regex;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public void setBranchRate(String branchRate) {
        this.branchRate = branchRate;
    }

    public void setLineRate(String lineRate) {
        this.lineRate = lineRate;
    }

    public void setPackageBranchRate(String packageBranchRate) {
        this.packageBranchRate = packageBranchRate;
    }

    public void setPackageLineRate(String packageLineRate) {
        this.packageLineRate = packageLineRate;
    }

    public void setTotalBranchRate(String totalBranchRate) {
        this.totalBranchRate = totalBranchRate;
    }

    public void setTotalLineRate(String totalLineRate) {
        this.totalLineRate = totalLineRate;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }
}

