#include "memoryaccess.ih"

    // by getid.cc

// static
size_t MemoryAccess::getSegmentSize(int id)
{
    struct shmid_ds buf;

    if (shmctl(id, IPC_STAT, &buf) == -1)
        throw Exception{} << "Can't determine segment size of segment " <<
                            id << ": " << errnodescr;

    return buf.shm_segsz;
}
