/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef ATOMDECORATION_H
#define ATOMDECORATION_H
#include "PMComponentAPI.h"


class Atom;
class AtomDC;
class Vector;

#include "Decoration.h"

#include <GeometricObject.h>

/**
 *   This class allows you to display a geometric object (arrow, sphere, ...)
 *   positionned on an atom. For example an arrow can represent a vector
 *   associated to the atom (e.g. a force, its velocity...)
 *

 */
class PHYSICALMODEL_COMPONENT_API AtomDecoration : public Decoration {
public:

    /// this constructor set the current atom to follow
    AtomDecoration(AtomDC *, camitk::GeometricObject::Geometry);
    ~AtomDecoration();

    /** update the 3D representation
     *  - if the geometry is an arrow : update position of the geometric object using the atom's position
     *  and the three parameters as the new direction
     *  - if the geometry is a sphere: use the parameters as the new position (do not take into account the
     *  position of the atom.
     */
    void update(const double, const double, const double);

    /** update the 3D representation
     *  - if the geometry is an arrow : update position of the geometric object using the atom's position
     *  and and the new vector given in parameter as the new direction
     *  - if the geometry is a sphere: use the parameters as the new position (do not take into account the
     *  position of the atom.
     */
    void update(const double[3]);

    /// update the position of the geometric object (using the atom's position)
    void update();

    /// show the geometric object in 3D or not depending on the paramater
    void show(const bool);

    /// change the color of the geometric object
    void setColor(const double, const double, const double);

    /// change the size of the geometric object
    void setSize(const double);

    /// change the position of the geometric object (even if different from the atom's position)
    void setPosition(const double, const double, const double);

    /// set the direction of the of the object without updating the position
    void setDirection(const double, const double, const double);

    /// set the direction of the object, without updating the position
    void setDirection(const double[3]);

    // get the geometric type
    camitk::GeometricObject::Geometry getType() const;

private:
    camitk::GeometricObject *myObject;
    Atom *myAtom;

};

inline camitk::GeometricObject::Geometry AtomDecoration::getType() const {
    return myObject->getType();
}

#endif
