/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef QT_BINDINGS_H
#define QT_BINDINGS_H

#include <QString>
#include <QVariant>
#include <QColor>
#include <QStringList>

#pragma push_macro("slots")
#undef slots
#include <pybind11/pybind11.h>
#include <pybind11/embed.h>
#include <pybind11/numpy.h>
#include <pybind11/stl.h>
#pragma pop_macro("slots")

// Many Qt bindings greatly inspired by
// https://github.com/ModOrganizer2/modorganizer-plugin_python/tree/master/src/pybind11-qt
namespace pybind11::detail {

template <>
struct type_caster<QString> {
public:
    PYBIND11_TYPE_CASTER(QString, const_name("str"));
    bool load(handle src, bool);
    static handle cast(const QString& src, return_value_policy, handle);
};

template <>
struct type_caster<QVariant> {
public:
    PYBIND11_TYPE_CASTER(QVariant, const_name("typing.Any"));
    bool load(handle src, bool);
    static handle cast(QVariant src, return_value_policy, handle);
};

template <> struct type_caster<QList<QVariant>> {
public:
    PYBIND11_TYPE_CASTER(QList<QVariant>, const_name("list[typing.Any]"));
    bool load(handle src, bool);
    static handle cast(const QList<QVariant>& src, return_value_policy, handle);
};

#if QT_VERSION < QT_VERSION_CHECK(6, 0, 0)
// Qt 5: QVector and QList are different, from version 6 they are the same class
template <> struct type_caster<QVector<QVariant>> {
public:
    PYBIND11_TYPE_CASTER(QVector<QVariant>, const_name("list[typing.Any]"));
    bool load(handle src, bool);
    static handle cast(const QVector<QVariant>& src, return_value_policy, handle);
};
#endif

template <> struct type_caster<QColor> {
public:
    PYBIND11_TYPE_CASTER(QColor, const_name("Union[tuple[float, ...], list[float]]"));
    bool load(handle src, bool);
    static handle cast(const QColor& src, return_value_policy, handle);
};

template<> struct type_caster<QStringList> {
public:
    PYBIND11_TYPE_CASTER(QStringList, const_name("list[str]"));
    bool load(handle src, bool);
    static handle cast(const QStringList& src, return_value_policy, handle);
};

} // namespace pybind11::detail

#endif // QT_BINDINGS_H