.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: cannalib.man,v 1.1.1.1 2002/10/19 08:27:48 aida_s Exp $ NEC;
.if t .pn 575
.TH CANNALIB 3
.SH "NAME"
CannaLib intro \(em Kana-to-Kanji Conversion Library Intro
.SH "DESCRIPTION"
.PP
Canna provides the following three libraries:
.IP "-" 3
High-level libraries
.RS
.PP
From application programs, high-level libraries are available without
considering Kana-to-Kanji Conversion.  Processes such as selecting
candidates (including candidate list display) are executed by the
Kana-to-Kanji Conversion system.  Only fixed character strings are
passed to the application.  If the Kana-to-Kanji Conversion front end
is being used for TTY input, the read (cooked mode) system call in
terminal input is regarded as a high-level library.  In this case,
scanf, which uses it, is also regarded as a higo-level library.
The Japanese version of Athena Widget (Text Wideget) in the X
Window System is a more typical library that is regarded as a
high-level library.
.RE
.IP "-" 3
User interface libraries
.RS
.PP
Responding to one-character or one-key input, user interface libraries
return various kinds of information.  They include the unfixed
character string, fixed character string, marked segment position,
status dispaly character string, and candidate list character string.
The libraries at this level do not provide the detailed functions
involving dictionary maintenance or learning control.  There is a
little remaining room of divising the display fields although rough
lines for Japanese input user interface are restricted.  It is
recommended that application interfaces at this level be used for an
application that desires to obtain keys in raw mode in the TTY.  Also,
it is recommended that they be used for an application that desires to
input and display graphics and characters in a single window.
.RE
.IP "-" 3
Dictionary access libraries
.RS
.PP
Dictionary access libraries are used to control dictionary access or
candidate selection directly.  Kana-to-Kanji Conversion libraries at
this level provide various function interfaces.  They include starting
the use of Kana-to-Kanji Conversion system, converting the reading
into Kanji, changing the splitting of sentence-segment, fetching Next
or Previous Candidate, controlling dictionary learning, and
maintaining dictionaries.  Dictionary access libraries are used to
construct a user interface or high-level library.  It is recommended
that they not be used by ordinary users.
.RE
.PP
Canna provides three header files and three libraries.  Their outlines
are listed below:
.IP "-" 3
Header files
.RS
.IP "X11/kanji.h" 18
Used to input or output Japanese data with X.
.IP "canna/jrkanji.h" 18
Used to input or output TTY-level Japanese data.
.IP "canna/RK.h" 18
Used to use a dictionary access library.
.RE
.IP "-" 3
Libraries
.RS
.IP "libXnw" 18
Japanese version of Athena Widget Xaw.  The application program does
not need to consider Kana-to-Kanji Conversion.
.IP "libXn" 18
Used to process Japanese data with X.  When using XLookupKanjiString
or XDrawKanjiString, you must link this library.
.IP "libcanna" 18
Kernel for Japanese data input
.RE
.PP
Library link and header file include must be done as follows,
depending on the function you use:
.IP "-" 3
Athena Widget
.RS
.IP "Header file" 16
canna/kanji.h
.IP "Library" 16
libXnw, libXn, libcanna
.RE
.IP "-" 3
XDrawKanjiString
.RS
.IP "Header file" 16
canna/kanji.h
.IP "Library" 16
libXn
.RE
.IP "-" 3
XLookupKanjiString, XKanjiControl
.RS
.IP "Header file" 16
canna/kanji.h
.IP "Library" 16
libXn, libcanna
.RE
.IP "-" 3
jrKanjiString, jrKanjiControl
.RS
.IP "Header file" 16
canna/jrkanji.h
.IP "Library" 16
libcanna
.RE
.IP "-" 3
Dictionary access library
.RS
.IP "Header file" 16
canna/RK.h
.IP "Library" 16
libcanna
.RE
.SH "Conversion context"
.PP
Canna enables you to perform two or more Kana-to-Kanji Conversion
processes simultaneously.  Conversion contextsare used to control
management of the respective Kana-to-Kanji Conversion processes.  The
internal data needed for Kana-to-Kanji Conversion is secured in each
context.
.PP
The application identifies each conversion context by the context
number.  It is an integer equal to or larger than 0, and used as the
first parameter of any Kana-to-Kanji Conversion function.
.PP
Immediately after dictionary access library RkInitialize(3)
initializes Kana-to-Kanji Conversion, there is only the standard
context, which has the context number 0.  It can be used by any
application that uses only one context.
.SH "Outline of Successive Segment Conversion:"
.PP
Successive Segment Conversion analyzes the specified Hiragana string,
and splits it into a few elements called sentence segments, or
Bunsetsu.  An example of analysis is shown below:
.sp
.ft CW
.nf
  ``KANAWOKANJINIHENKANSURU''
  KANAWO        KANAWO(1)     KANAWO(2)
  KANJINI       KANJINI(1)    KANJINI(2)    KANJINI(3)    KANJINI(4)
  HENKANSURU    HENKANSURU(1) HENKANSURU(2) HENKANSURU(3)
.fi
.ft
.sp
.PP
Each function provided by the dictionary access library's Successive
Segment Conversion may either modify the result of this analysis or
obtain the analysis information.  It assumes a two-dimensional
candidate address.
.PP
Segment numbers 0, 1, ..., N-1 are assigned leftward to the N segments
that have been analyzed.  The currently marked candidate is called the
current candidate.
.PP
For example, ``KANAWO'' may be specified as a
candidate having Segment Number 0 and Candidate Number 0.  The library
instead assumes current segment and candidate in the context to
simplify the parameters.
.SH "SEE ALSO"
.PP
uilib(3) \- User Interface Library
.PP
diclib(3) \- Dictionary Access Library
