// Proc_ViewCtrlV3.cpp: implementation of the Proc_ViewCtrlV3 Parsing
//   Processor class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"


#ifndef _WIN32
    #include <fstream>
#elif _MSC_VER > 1300
    #include <fstream>
#else
    #include <fstream.h>
#endif


#include "Proc_ViewCtrlV3.h"

#include "ParseValue.h"

using namespace std;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Proc_ViewCtrlV3::Proc_ViewCtrlV3()
{
   PcktID = "ViewCtrl";
}

Proc_ViewCtrlV3::~Proc_ViewCtrlV3()
{
}


void Proc_ViewCtrlV3::ProcPckt(ParseValue *pPV)
{

   if(Omsg == NULL)
      return;


   pPV = pPV->nxt();  // skip the cmd name

   printf("View Control:\n");

   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetViewID(pPV->GetUShort(),true);
         printf("\tView ID = %d\n",pPV->GetUShort());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetGroupID(pPV->GetUChar(),true);
         printf("\tGroup ID = %d\n",pPV->GetUChar());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }


      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetXOffEn(pPV->GetBool(),true);
         printf("\tX Offset Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetYOffEn(pPV->GetBool(),true);
         printf("\tY Offset Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetZOffEn(pPV->GetBool(),true);
         printf("\tZ Offset Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetRollEn(pPV->GetBool(),true);
         printf("\tRoll Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetPitchEn(pPV->GetBool(),true);
         printf("\tPitch Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetYawEn(pPV->GetBool(),true);
         printf("\tYaw Enable = %d\n",pPV->GetBool());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetEntityID(pPV->GetUShort(),true);
         printf("\tEntity ID = %d\n",pPV->GetUShort());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetXOff(pPV->Getfloat(),true);
         printf("\tX Offset = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetYOff(pPV->Getfloat(),true);
         printf("\tY Offset = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetZOff(pPV->Getfloat(),true);
         printf("\tZ Offset = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetRoll(pPV->Getfloat(),true);
         printf("\tRoll = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetPitch(pPV->Getfloat(),true);
         printf("\tPitch = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }
   if(pPV != NULL)
   {
      try
      {
         Om_ViewCtrl.SetYaw(pPV->Getfloat(),true);
         printf("\tYaw = %f\n",pPV->Getfloat());
      }
      catch(CigiValueOutOfRangeException ORX)
      {
         if(ORX.HasMessage())
            printf("%s\n",ORX.what());
      }

      pPV = pPV->nxt();
   }

   if(pPV != NULL)
      DefHex = pPV->GetStr();



   *Omsg << Om_ViewCtrl;

}


