/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny <tnowotny@ucsd.edu>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-03-31
 *
 */


#ifndef LIBCN_MX_ATTR_H
#define LIBCN_MX_ATTR_H

#include <vector>

#include "config.h"

using namespace std;

namespace CNRun {

class C_MultiplexingAttributes {
    protected:
	friend class CModel;
	virtual void update_queue() = 0;
	vector<double> _kq;
    public:
	double  q() const	{ return _kq.size(); }
	void reset()
		{
			_kq.clear();
		}
};



class C_DotAttributes {
    public:
	virtual double& spikes_fired_in_last_dt() = 0;
};

}

#endif

// EOF
