/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file LegendVisitorAttributes.h
    \brief Definition of LegendVisitor Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:25 2013
*/
   

#ifndef LegendVisitorAttributes_H
#define LegendVisitorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "LegendMethod.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class LegendVisitorAttributes 
{
public:
//  --  constructor
    LegendVisitorAttributes();
    
//  --  destructor
    virtual ~LegendVisitorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LegendVisitorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	bool title_;
	string title_text_;
	string title_orientation_;
	bool units_;
	string units_text_;
	bool use_min_;
	string use_min_text_;
	bool use_max_;
	string use_max_text_;
	auto_ptr<LegendMethod> method_;
	string format_;
	string box_;
	string font_;
	string font_style_;
	string font_dimension_;
	string text_quality_;
	double orientation_;
	stringarray lines_;
	int columns_;
	string direction_;
	string entry_orientation_;
	string composition_;
	string text_;
	string text1_;
	string text2_;
	string text3_;
	string text4_;
	string text5_;
	string text6_;
	string text7_;
	string text8_;
	string text9_;
	string text10_;
	double box_x_;
	double box_y_;
	double box_width_;
	double box_height_;
	bool blanking_;
	bool border_;
	LineStyle border_line_style_;
	auto_ptr<Colour> border_colour_;
	int border_thickness_;
	bool wrep_;
	double text_width_;
	bool entry_border_;
	auto_ptr<Colour> entry_border_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const LegendVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
