/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQContentsModel_H
#define MvQContentsModel_H

#include <QAbstractItemModel>
#include <QStyledItemDelegate>

#include "MvIconDataBase.h"
#include "Visitor.h"

class MvIcon;
class Page;
class Presentable;
class SuperPage;

using namespace std;

class MvQContentsNode
{
public:
    enum Type
    {
        NoType,
        DisplayTitleType,
        PageTitleType,
        DataTitleType,
        IconType
    };

    MvQContentsNode(Presentable&, MvQContentsNode*, Type);
    MvQContentsNode(MvIcon&, MvQContentsNode*, Type);
    MvQContentsNode(QString, MvQContentsNode*, Type);
    MvQContentsNode* addChild(Presentable&, Type);
    MvQContentsNode* addChild(MvIcon&, Type);
    MvQContentsNode* addChild(QString, Type);
    QString name() { return name_; }
    QPixmap pixmap() { return pixmap_; }
    MvQContentsNode* parent() { return parent_; }
    QList<MvQContentsNode*> children() { return children_; }
    Type type() { return type_; }

protected:
    QList<MvQContentsNode*> children_;
    MvQContentsNode* parent_;
    QString name_;
    QPixmap pixmap_;
    Type type_;
};

class MvQContentsTree : public Visitor
{
public:
    MvQContentsTree();
    void Visit(SuperPage& sp);
    void Visit(Page& page);
    void Visit(SubPage&){};

    MvQContentsNode* root() { return root_; }

protected:
    MvIconList iconList(Presentable& treeNode);
    MvQContentsNode* root_;
};

class MvQContentsDelegate : public QStyledItemDelegate
{
public:
    MvQContentsDelegate(QWidget* parent = 0);
    void paint(QPainter* painter, const QStyleOptionViewItem& option,
               const QModelIndex& index) const;
    QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;
};


/*class MvQContentsList : public Visitor
{
public:
	MvQContentsList();
	void Visit(SuperPage &sp);
	void Visit(Page &page);
	void Visit(SubPage&) {};

	//MvQContentsNode *root() {return root_;}

protected:
    	MvIconList iconList(Presentable &treeNode);
	QList<MvQContentsNode*> *items_;	
};*/


class MvQContentsModel : public QAbstractItemModel
{
public:
    MvQContentsModel();

    int columnCount(const QModelIndex& parent = QModelIndex()) const;
    int rowCount(const QModelIndex& parent = QModelIndex()) const;

    QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;

    void dataIsAboutToChange();
    void setRootNode(MvQContentsNode*);
    QModelIndex indexFromNode(MvQContentsNode*) const;
    MvQContentsNode* nodeFromIndex(const QModelIndex& index) const;

protected:
    MvQContentsNode* root_;
};


#endif
