"use strict";

var helpers = require("../../helpers/helpers");

exports["Atlantic/Bermuda"] = {

	"guess:by:offset" : helpers.makeTestGuess("Atlantic/Bermuda", { offset: true, expect: "America/Halifax" }),

	"guess:by:abbr" : helpers.makeTestGuess("Atlantic/Bermuda", { abbr: true, expect: "America/Halifax" }),

	"1917" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1917-04-06T04:19:17+00:00", "23:59:59", "BMT", 15558 / 60],
		["1917-04-06T04:19:18+00:00", "01:00:00", "BST", 11958 / 60],
		["1917-10-01T03:19:17+00:00", "23:59:59", "BST", 11958 / 60],
		["1917-10-01T03:19:18+00:00", "23:00:00", "BMT", 15558 / 60]
	]),

	"1918" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1918-04-14T04:19:17+00:00", "23:59:59", "BMT", 15558 / 60],
		["1918-04-14T04:19:18+00:00", "01:00:00", "BST", 11958 / 60],
		["1918-09-16T03:19:17+00:00", "23:59:59", "BST", 11958 / 60],
		["1918-09-16T03:19:18+00:00", "23:00:00", "BMT", 15558 / 60]
	]),

	"1930" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1930-01-01T06:19:17+00:00", "01:59:59", "BMT", 15558 / 60],
		["1930-01-01T06:19:18+00:00", "02:19:18", "AST", 240]
	]),

	"1942" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1942-01-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["1942-01-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1942-10-18T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1942-10-18T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1943" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1943-03-21T05:59:59+00:00", "01:59:59", "AST", 240],
		["1943-03-21T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1943-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1943-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1944" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1944-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["1944-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1944-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1944-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1945" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1945-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["1945-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1945-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1945-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1947" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1947-05-18T05:59:59+00:00", "01:59:59", "AST", 240],
		["1947-05-18T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1947-09-14T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1947-09-14T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1948" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1948-05-23T05:59:59+00:00", "01:59:59", "AST", 240],
		["1948-05-23T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1948-09-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1948-09-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1949" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1949-05-22T05:59:59+00:00", "01:59:59", "AST", 240],
		["1949-05-22T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1949-09-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1949-09-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1950" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1950-05-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1950-05-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1950-09-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1950-09-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1951" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1951-05-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1951-05-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1951-09-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1951-09-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1952" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1952-05-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1952-05-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1952-09-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1952-09-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1956" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1956-05-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1956-05-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1956-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1956-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1974" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1974-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1974-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1974-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1974-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1975" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1975-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1975-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1975-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1975-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1976" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1976-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1976-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1976-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1976-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1977" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1977-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1977-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1977-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1977-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1978" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1978-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1978-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1978-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1978-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1979" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1979-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1979-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1979-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1979-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1980-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1980-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1980-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1980-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1981" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1981-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1981-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1981-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1981-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1982" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1982-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1982-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1982-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1982-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1983" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1983-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1983-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1983-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1983-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1984" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1984-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1984-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1984-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1984-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1985" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1985-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1985-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1985-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1985-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1986" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1986-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1986-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1986-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1986-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1987" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1987-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1987-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1987-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1987-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1988" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1988-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1988-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1988-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1988-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1989" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1989-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1989-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1989-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1989-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1990" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1990-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["1990-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1990-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1990-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1991" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1991-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1991-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1991-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1991-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1992" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1992-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1992-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1992-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1992-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1993" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1993-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1993-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1993-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1993-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1994" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1994-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1994-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1994-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1994-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1995" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1995-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1995-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1995-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1995-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1996" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1996-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1996-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1996-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1996-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1997" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1997-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["1997-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1997-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1997-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1998" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1998-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1998-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1998-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1998-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1999" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1999-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1999-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1999-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1999-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2000" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2000-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2000-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2000-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2000-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2001" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2001-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["2001-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2001-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2001-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2002" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2002-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["2002-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2002-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2002-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2003" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2003-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["2003-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2003-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2003-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2004" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2004-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["2004-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2004-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2004-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2005" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2005-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["2005-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2005-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2005-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2006" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2006-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2006-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2006-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2006-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2007" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2007-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2007-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2007-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2007-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2008" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2008-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2008-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2008-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2008-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2009" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2009-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2009-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2009-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2009-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2010" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2010-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2010-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2010-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2010-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2011" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2011-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2011-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2011-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2011-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2012" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2012-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2012-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2012-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2012-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2013" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2013-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2013-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2013-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2013-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2014" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2014-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2014-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2014-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2014-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2015" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2015-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2015-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2015-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2015-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2016" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2016-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2016-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2016-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2016-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2017" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2017-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2017-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2017-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2017-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2018" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2018-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2018-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2018-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2018-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2019" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2019-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2019-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2019-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2019-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2020" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2020-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2020-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2020-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2020-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2021" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2021-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2021-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2021-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2021-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2022" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2022-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2022-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2022-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2022-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2023" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2023-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2023-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2023-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2023-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2024" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2024-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2024-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2024-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2024-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2025" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2025-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2025-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2025-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2025-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2026" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2026-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2026-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2026-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2026-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2027" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2027-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2027-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2027-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2027-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2028" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2028-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2028-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2028-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2028-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2029" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2029-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2029-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2029-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2029-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2030" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2030-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2030-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2030-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2030-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2031" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2031-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2031-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2031-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2031-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2032" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2032-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2032-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2032-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2032-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2033" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2033-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2033-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2033-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2033-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2034" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2034-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2034-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2034-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2034-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2035" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2035-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2035-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2035-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2035-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2036" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2036-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2036-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2036-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2036-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2037" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2037-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2037-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2037-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2037-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	])
};