#include <gtk/gtk.h>

#include <caml/alloc.h>

#include "wrappers.h"
#include "ml_glib.h"
#include "ml_gobject.h"
#include "ml_gtk.h"


CAMLprim value
_ml_g_get_home_dir (value unit)
{
  G_CONST_RETURN gchar *dir = g_get_home_dir ();
  return copy_string (dir ? dir : "");
}

CAMLprim value
_ml_gtk_invisible_new (value unit)
{
  return Val_GtkWidget_sink (gtk_invisible_new ());
}


#define GtkTreeView_val(val) check_cast(GTK_TREE_VIEW,val)
#define GtkTreePath_val(val) ((GtkTreePath*)Pointer_val(val))
CAMLprim value
_ml_gtk_tree_view_expand_to_path (value view, value path)
{
  gtk_tree_view_expand_to_path (GtkTreeView_val (view),
				GtkTreePath_val (path));
  return Val_unit;
}
