/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import java.util.Arrays;

abstract class AbstractByteCollection
implements ByteCollection {
    AbstractByteCollection() {
    }

    public int removeAll(ByteLookupContainer c) {
        final ByteLookupContainer c2 = c;
        return this.removeAll(new BytePredicate(){

            public boolean apply(byte k) {
                return c2.contains(k);
            }
        });
    }

    public int retainAll(ByteLookupContainer c) {
        final ByteLookupContainer c2 = c;
        return this.removeAll(new BytePredicate(){

            public boolean apply(byte k) {
                return !c2.contains(k);
            }
        });
    }

    public int retainAll(final BytePredicate predicate) {
        return this.removeAll(new BytePredicate(){

            public boolean apply(byte value) {
                return !predicate.apply(value);
            }
        });
    }

    public byte[] toArray() {
        int size = this.size();
        byte[] array = new byte[size];
        int i = 0;
        for (ByteCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

