/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "ClipCases.h"

// note -- this was converted automatically from the quad cases
// using the clipeditor

// This file is meant to be read and created by a program other than a
// compiler.  If you must modify it by hand, at least be nice to the 
// parser and don't add anything else to this file or rearrange it.

int numClipCasesVox = 256;

int numClipShapesVox[256] = {
  1,  10,  10,  3,  10,  3,  18,  15, // cases 0 - 7
  10,  18,  3,  15,  3,  15,  15,  2, // cases 8 - 15
  10,  3,  18,  15,  18,  15,  11,  10, // cases 16 - 23
  8,  18,  18,  17,  18,  17,  16,  15, // cases 24 - 31
  10,  18,  3,  15,  8,  18,  18,  17, // cases 32 - 39
  18,  11,  15,  10,  18,  16,  17,  15, // cases 40 - 47
  3,  15,  15,  2,  18,  17,  16,  15, // cases 48 - 55
  18,  16,  17,  15,  4,  13,  13,  3, // cases 56 - 63
  10,  18,  8,  18,  3,  15,  18,  17, // cases 64 - 71
  18,  11,  18,  16,  15,  10,  17,  15, // cases 72 - 79
  3,  15,  18,  17,  15,  2,  16,  15, // cases 80 - 87
  18,  16,  4,  13,  17,  15,  13,  3, // cases 88 - 95
  18,  11,  18,  16,  18,  16,  4,  13, // cases 96 - 103
  11,  9,  16,  8,  16,  8,  13,  7, // cases 104 - 111
  15,  10,  17,  15,  17,  15,  13,  3, // cases 112 - 119
  16,  8,  13,  7,  13,  7,  8,  10, // cases 120 - 127
  10,  8,  18,  18,  18,  18,  11,  16, // cases 128 - 135
  3,  18,  15,  17,  15,  17,  10,  15, // cases 136 - 143
  18,  18,  11,  16,  11,  16,  9,  8, // cases 144 - 151
  18,  4,  16,  13,  16,  13,  8,  7, // cases 152 - 159
  3,  18,  15,  17,  18,  4,  16,  13, // cases 160 - 167
  15,  16,  2,  15,  17,  13,  15,  3, // cases 168 - 175
  15,  17,  10,  15,  16,  13,  8,  7, // cases 176 - 183
  17,  13,  15,  3,  13,  8,  7,  10, // cases 184 - 191
  3,  18,  18,  4,  15,  17,  16,  13, // cases 192 - 199
  15,  16,  17,  13,  2,  15,  15,  3, // cases 200 - 207
  15,  17,  16,  13,  10,  15,  8,  7, // cases 208 - 215
  17,  13,  13,  8,  15,  3,  7,  10, // cases 216 - 223
  15,  16,  17,  13,  17,  13,  13,  8, // cases 224 - 231
  10,  8,  15,  7,  15,  7,  3,  10, // cases 232 - 239
  2,  15,  15,  3,  15,  3,  7,  10, // cases 240 - 247
  15,  7,  3,  10,  3,  10,  10,  1  // cases 248 - 255
};

int startClipShapesVox[256] = {
  0, 10, 80, 150, 176, 246, 272, 387, // cases 0 - 7
  488, 558, 673, 699, 800, 826, 927, 1028, // cases 8 - 15
  1048, 1118, 1144, 1259, 1360, 1475, 1576, 1652, // cases 16 - 23
  1720, 1772, 1891, 2010, 2124, 2243, 2357, 2465, // cases 24 - 31
  2566, 2636, 2751, 2777, 2878, 2930, 3049, 3168, // cases 32 - 39
  3282, 3397, 3473, 3574, 3642, 3761, 3869, 3983, // cases 40 - 47
  4084, 4110, 4211, 4312, 4332, 4451, 4565, 4673, // cases 48 - 55
  4774, 4893, 5001, 5115, 5216, 5252, 5343, 5434, // cases 56 - 63
  5460, 5530, 5645, 5697, 5816, 5842, 5943, 6062, // cases 64 - 71
  6176, 6291, 6367, 6486, 6594, 6695, 6763, 6877, // cases 72 - 79
  6978, 7004, 7105, 7224, 7338, 7439, 7459, 7567, // cases 80 - 87
  7668, 7787, 7895, 7931, 8022, 8136, 8237, 8328, // cases 88 - 95
  8354, 8469, 8545, 8664, 8772, 8891, 8999, 9035, // cases 96 - 103
  9126, 9202, 9264, 9372, 9426, 9534, 9588, 9679, // cases 104 - 111
  9726, 9827, 9895, 10009, 10110, 10224, 10325, 10416, // cases 112 - 119
  10442, 10550, 10604, 10695, 10742, 10833, 10880, 10932, // cases 120 - 127
  11002, 11072, 11124, 11239, 11358, 11473, 11592, 11668, // cases 128 - 135
  11776, 11802, 11921, 12022, 12136, 12237, 12351, 12419, // cases 136 - 143
  12520, 12635, 12754, 12830, 12938, 13014, 13122, 13184, // cases 144 - 151
  13238, 13357, 13393, 13501, 13592, 13700, 13791, 13845, // cases 152 - 159
  13892, 13918, 14037, 14138, 14252, 14371, 14407, 14515, // cases 160 - 167
  14606, 14707, 14815, 14835, 14936, 15050, 15141, 15242, // cases 168 - 175
  15268, 15369, 15483, 15551, 15652, 15760, 15851, 15905, // cases 176 - 183
  15952, 16066, 16157, 16258, 16284, 16375, 16427, 16474, // cases 184 - 191
  16544, 16570, 16689, 16808, 16844, 16945, 17059, 17167, // cases 192 - 199
  17258, 17359, 17467, 17581, 17672, 17692, 17793, 17894, // cases 200 - 207
  17920, 18021, 18135, 18243, 18334, 18402, 18503, 18557, // cases 208 - 215
  18604, 18718, 18809, 18900, 18952, 19053, 19079, 19126, // cases 216 - 223
  19196, 19297, 19405, 19519, 19610, 19724, 19815, 19906, // cases 224 - 231
  19958, 20026, 20080, 20181, 20228, 20329, 20376, 20402, // cases 232 - 239
  20472, 20492, 20593, 20694, 20720, 20821, 20847, 20894, // cases 240 - 247
  20964, 21065, 21112, 21138, 21208, 21234, 21304, 21374  // cases 248 - 255
};

unsigned char clipShapesVox[] = {
 // Case #0: Unique case #1
  ST_HEX, COLOR0, P0, P1, P3, P2, P4, P5, P7, P6, 
 // Case #1: Unique case #2
  ST_PNT, 0, COLOR0, 7, P1, P3, P2, P4, P5, P7, P6, 
  ST_WDG, COLOR0, P1, P2, P4, EA, ED, EI, 
  ST_TET, COLOR0, P1, P2, P4, N0, 
  ST_TET, COLOR0, P1, P3, P2, N0, 
  ST_PYR, COLOR0, P7, P6, P2, P3, N0, 
  ST_PYR, COLOR0, P5, P7, P3, P1, N0, 
  ST_PYR, COLOR0, P4, P6, P7, P5, N0, 
  ST_TET, COLOR0, P2, P6, P4, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P0, EA, ED, EI, 
 // Case #2: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P5, P4, P0, P3, P7, P6, P2, 
  ST_WDG, COLOR0, EJ, EA, EB, P5, P0, P3, 
  ST_TET, COLOR0, P5, P3, P0, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P6, P4, P0, P2, N0, 
  ST_PYR, COLOR0, P7, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P3, P7, P6, P2, N0, 
  ST_TET, COLOR0, P0, P3, P2, N0, 
  ST_TET, COLOR0, P3, P5, P7, N0, 
  ST_TET, COLOR1, P1, EA, EJ, EB, 
 // Case #3: Unique case #3
  ST_HEX, COLOR0, EB, P3, P2, ED, EJ, P5, P4, EI, 
  ST_WDG, COLOR0, P3, P7, P5, P2, P6, P4, 
  ST_WDG, COLOR1, P1, EB, EJ, P0, ED, EI, 
 // Case #4: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P3, P1, P0, P6, P7, P5, P4, 
  ST_WDG, COLOR0, EC, ED, EK, P3, P0, P6, 
  ST_TET, COLOR0, P3, P6, P0, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_PYR, COLOR0, P5, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P7, P3, P1, P5, N0, 
  ST_PYR, COLOR0, P6, P7, P5, P4, N0, 
  ST_TET, COLOR0, P0, P6, P4, N0, 
  ST_TET, COLOR0, P6, P3, P7, N0, 
  ST_TET, COLOR1, P2, ED, EC, EK, 
 // Case #5: (cloned #3)
  ST_HEX, COLOR0, EK, P6, P4, EI, EC, P3, P1, EA, 
  ST_WDG, COLOR0, P6, P7, P3, P4, P5, P1, 
  ST_WDG, COLOR1, P2, EK, EC, P0, EI, EA, 
 // Case #6: Unique case #4
  ST_PNT, 0, NOCOLOR, 2, EK, EJ, 
  ST_PYR, COLOR0, P6, P7, P5, P4, N0, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_TET, COLOR0, P6, P3, P7, N0, 
  ST_TET, COLOR0, P0, P6, P4, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_PYR, COLOR0, P3, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_PYR, COLOR0, P6, EK, EC, P3, N0, 
  ST_PYR, COLOR0, P6, P0, ED, EK, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P2, ED, EA, P1, N0, 
  ST_PYR, COLOR1, EC, P2, P1, EB, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EC, P2, N0, EK, 
  ST_TET, COLOR1, ED, P2, EK, N0, 
 // Case #7: Unique case #5
  ST_PNT, 0, NOCOLOR, 5, EJ, EI, EB, EC, EK, 
  ST_PYR, COLOR0, P5, P4, P6, P7, N0, 
  ST_TET, COLOR0, P6, N0, P3, P7, 
  ST_PYR, COLOR0, P4, EI, EK, P6, N0, 
  ST_PYR, COLOR0, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR0, P3, P5, P7, N0, 
  ST_PYR, COLOR0, P3, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_PYR, COLOR0, EK, EC, P3, P6, N0, 
  ST_PYR, COLOR1, EI, P0, P2, EK, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_PYR, COLOR1, EB, EC, P2, P1, N0, 
  ST_TET, COLOR1, P2, EC, EK, N0, 
 // Case #8: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P7, P5, P1, P2, P6, P4, P0, 
  ST_WDG, COLOR0, EL, EB, EC, P7, P1, P2, 
  ST_TET, COLOR0, P7, P2, P1, N0, 
  ST_TET, COLOR0, P7, P1, P5, N0, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P6, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P2, P6, P4, P0, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_TET, COLOR0, P2, P7, P6, N0, 
  ST_TET, COLOR1, P3, EB, EL, EC, 
 // Case #9: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EI, EL, 
  ST_PYR, COLOR0, P4, P6, P7, P5, N0, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P2, P6, P4, N0, 
  ST_TET, COLOR0, P7, P6, P2, N0, 
  ST_PYR, COLOR0, P7, P2, EC, EL, N0, 
  ST_PYR, COLOR0, P1, P7, EL, EB, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P2, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_PYR, COLOR1, P0, P3, EC, ED, N0, 
  ST_PYR, COLOR1, EA, EB, P3, P0, N0, 
  ST_TET, COLOR1, EB, EL, P3, N0, 
  ST_TET, COLOR1, P3, EL, EC, N0, 
  ST_TET, COLOR1, EA, N0, P0, EI, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
 // Case #10: (cloned #3)
  ST_HEX, COLOR0, EC, P2, P0, EA, EL, P7, P5, EJ, 
  ST_WDG, COLOR0, P2, P6, P7, P0, P4, P5, 
  ST_WDG, COLOR1, P3, EC, EL, P1, EA, EJ, 
 // Case #11: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EC, ED, EI, 
  ST_PYR, COLOR0, P7, P5, P4, P6, N0, 
  ST_TET, COLOR0, P4, N0, P2, P6, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_PYR, COLOR0, EL, EJ, P5, P7, N0, 
  ST_TET, COLOR0, P2, P7, P6, N0, 
  ST_PYR, COLOR0, P2, EC, EL, P7, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_PYR, COLOR0, EI, ED, P2, P4, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_TET, COLOR1, EC, P3, EL, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P3, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
 // Case #12: (cloned #3)
  ST_HEX, COLOR0, EL, P7, P6, EK, EB, P1, P0, ED, 
  ST_WDG, COLOR0, P0, P4, P6, P1, P5, P7, 
  ST_WDG, COLOR1, P2, ED, EK, P3, EB, EL, 
 // Case #13: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EB, EA, EI, 
  ST_PYR, COLOR0, P7, P5, P4, P6, N0, 
  ST_TET, COLOR0, P4, P1, N0, P5, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_PYR, COLOR0, EL, P7, P6, EK, N0, 
  ST_TET, COLOR0, P1, P5, P7, N0, 
  ST_PYR, COLOR0, P1, P7, EL, EB, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, EI, P4, P1, EA, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_TET, COLOR1, EB, EL, P3, N0, 
  ST_TET, COLOR1, P3, P2, P0, N0, 
  ST_PYR, COLOR1, EB, P3, P0, EA, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
 // Case #14: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, ED, EA, EJ, 
  ST_PYR, COLOR0, P6, P7, P5, P4, N0, 
  ST_TET, COLOR0, P5, N0, P0, P4, 
  ST_PYR, COLOR0, P7, EL, EJ, P5, N0, 
  ST_PYR, COLOR0, EK, EL, P7, P6, N0, 
  ST_TET, COLOR0, P0, P6, P4, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P6, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, N0, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_PYR, COLOR1, EK, P2, P3, EL, N0, 
  ST_TET, COLOR1, ED, P2, EK, N0, 
  ST_TET, COLOR1, P2, P1, P3, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P2, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
 // Case #15: Unique case #6
  ST_HEX, COLOR0, EI, EJ, EL, EK, P4, P5, P7, P6, 
  ST_HEX, COLOR1, P0, P1, P3, P2, EI, EJ, EL, EK, 
 // Case #16: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P5, P1, P0, P6, P7, P3, P2, 
  ST_WDG, COLOR0, P5, P0, P6, EE, EI, EH, 
  ST_TET, COLOR0, P5, P0, P6, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P3, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P7, P3, P1, P5, N0, 
  ST_PYR, COLOR0, P6, P2, P3, P7, N0, 
  ST_TET, COLOR0, P0, P2, P6, N0, 
  ST_TET, COLOR0, P6, P7, P5, N0, 
  ST_TET, COLOR1, P4, EE, EI, EH, 
 // Case #17: (cloned #3)
  ST_HEX, COLOR0, EE, P5, P1, EA, EH, P6, P2, ED, 
  ST_WDG, COLOR0, P2, P3, P1, P6, P7, P5, 
  ST_WDG, COLOR1, P0, ED, EA, P4, EH, EE, 
 // Case #18: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EH, EB, 
  ST_PYR, COLOR0, P6, P2, P3, P7, N0, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_TET, COLOR0, P6, P7, P5, N0, 
  ST_TET, COLOR0, P0, P2, P6, N0, 
  ST_TET, COLOR0, P3, P2, P0, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EB, N0, 
  ST_PYR, COLOR0, P5, P3, EB, EJ, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EH, N0, 
  ST_PYR, COLOR0, P6, EH, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_TET, COLOR1, EE, N0, P4, EH, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
 // Case #19: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EB, ED, EJ, EE, EH, 
  ST_PYR, COLOR0, P3, P7, P6, P2, N0, 
  ST_TET, COLOR0, P6, P5, N0, P7, 
  ST_PYR, COLOR0, P2, P6, EH, ED, N0, 
  ST_PYR, COLOR0, EB, P3, P2, ED, N0, 
  ST_TET, COLOR0, P5, P7, P3, N0, 
  ST_PYR, COLOR0, P5, P3, EB, EJ, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_PYR, COLOR0, EH, P6, P5, EE, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
 // Case #20: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EC, EE, 
  ST_PYR, COLOR0, P3, P1, P5, P7, N0, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_TET, COLOR0, P3, P7, P6, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EH, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_PYR, COLOR0, P3, P6, EK, EC, N0, 
  ST_PYR, COLOR0, P3, EC, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P2, P4, EI, ED, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P2, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EK, N0, P2, EC, 
  ST_TET, COLOR1, ED, EC, P2, N0, 
 // Case #21: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EE, EA, EH, EK, EC, 
  ST_PYR, COLOR0, P5, P7, P3, P1, N0, 
  ST_TET, COLOR0, P3, P6, N0, P7, 
  ST_PYR, COLOR0, P1, P3, EC, EA, N0, 
  ST_PYR, COLOR0, EE, P5, P1, EA, N0, 
  ST_TET, COLOR0, P6, P7, P5, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EH, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_PYR, COLOR0, EC, P3, P6, EK, N0, 
  ST_PYR, COLOR1, EA, EC, P2, P0, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_TET, COLOR1, P4, P0, P2, N0, 
  ST_PYR, COLOR1, EH, P4, P2, EK, N0, 
  ST_TET, COLOR1, P2, EC, EK, N0, 
 // Case #22: Unique case #7
  ST_TET, COLOR0, P0, EA, ED, EI, 
  ST_TET, COLOR0, P5, P6, P7, P3, 
  ST_PYR, COLOR0, EC, P3, P6, EK, EH, 
  ST_PYR, COLOR0, EB, EJ, P5, P3, EE, 
  ST_PYR, COLOR0, P6, P5, EE, EH, P3, 
  ST_PYR, COLOR0, EH, EE, EB, EC, P3, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_PYR, COLOR1, P2, EK, EH, P4, EC, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR1, EC, P2, P1, EB, P4, 
  ST_PYR, COLOR1, EC, EB, EE, EH, P4, 
 // Case #23: Unique case #8
  ST_TET, COLOR0, P5, P6, P7, P3, 
  ST_PYR, COLOR0, EC, P3, P6, EK, EH, 
  ST_PYR, COLOR0, EB, EJ, P5, P3, EE, 
  ST_PYR, COLOR0, P6, P5, EE, EH, P3, 
  ST_PYR, COLOR0, EH, EE, EB, EC, P3, 
  ST_TET, COLOR1, P0, P1, P2, P4, 
  ST_PYR, COLOR1, EH, P4, P2, EK, EC, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR1, P2, P1, EB, EC, P4, 
  ST_PYR, COLOR1, EH, EC, EB, EE, P4, 
 // Case #24: Unique case #9
  ST_WDG, COLOR0, EB, EC, EL, P1, P2, P7, 
  ST_WDG, COLOR0, P0, P6, P5, EI, EH, EE, 
  ST_TET, COLOR0, P2, P1, P7, P6, 
  ST_TET, COLOR0, P5, P6, P7, P1, 
  ST_TET, COLOR0, P0, P5, P1, P6, 
  ST_TET, COLOR0, P2, P6, P0, P1, 
  ST_TET, COLOR1, P4, EE, EI, EH, 
  ST_TET, COLOR1, P3, EC, EB, EL, 
 // Case #25: Unique case #10
  ST_PNT, 0, NOCOLOR, 4, EE, EH, EL, EL, 
  ST_PYR, COLOR0, P7, P2, EC, EL, N0, 
  ST_TET, COLOR0, EC, P2, ED, N0, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_TET, COLOR0, P7, P6, P2, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_PYR, COLOR0, P1, P7, EL, EB, N0, 
  ST_TET, COLOR0, P5, P6, P7, N0, 
  ST_PYR, COLOR0, P5, EE, EH, P6, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_PYR, COLOR1, P3, EC, ED, P0, N0, 
  ST_PYR, COLOR1, EA, EB, P3, P0, N0, 
  ST_TET, COLOR1, P3, EL, EC, N0, 
  ST_TET, COLOR1, EB, EL, P3, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_PYR, COLOR1, P0, P4, EE, EA, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
 // Case #26: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EL, EC, EH, EH, 
  ST_PYR, COLOR0, P6, EH, EI, P0, N0, 
  ST_TET, COLOR0, EI, EA, P0, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_TET, COLOR0, P6, P0, P2, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_PYR, COLOR0, P5, EE, EH, P6, N0, 
  ST_TET, COLOR0, P7, P6, P2, N0, 
  ST_PYR, COLOR0, P7, P2, EC, EL, N0, 
  ST_PYR, COLOR0, P7, EL, EJ, P5, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR1, P4, EI, EH, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
  ST_PYR, COLOR1, EA, P1, P3, EC, N0, 
  ST_PYR, COLOR1, P1, EJ, EL, P3, N0, 
  ST_TET, COLOR1, EL, EC, P3, N0, 
 // Case #27: Unique case #11
  ST_PNT, 0, NOCOLOR, 6, ED, EC, EL, EJ, EE, EH, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_PYR, COLOR0, P7, EL, EJ, P5, N0, 
  ST_TET, COLOR0, P2, P7, P6, N0, 
  ST_PYR, COLOR0, P2, EC, EL, P7, N0, 
  ST_TET, COLOR0, ED, EC, P2, N0, 
  ST_PYR, COLOR0, P2, P6, EH, ED, N0, 
  ST_PYR, COLOR0, EH, P6, P5, EE, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, ED, P0, P3, EC, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_TET, COLOR1, P4, P1, P0, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P3, P1, N0, 
  ST_TET, COLOR1, EL, EC, P3, N0, 
 // Case #28: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EL, EB, EE, EE, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_TET, COLOR0, EI, P0, ED, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EH, N0, 
  ST_TET, COLOR0, P7, P1, P5, N0, 
  ST_PYR, COLOR0, P7, EL, EB, P1, N0, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_PYR, COLOR1, P4, EI, ED, P2, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P2, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_PYR, COLOR1, ED, EB, P3, P2, N0, 
  ST_PYR, COLOR1, P2, P3, EL, EK, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
 // Case #29: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EA, EB, EL, EK, EH, EE, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_TET, COLOR0, P1, P5, P7, N0, 
  ST_PYR, COLOR0, P1, P7, EL, EB, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_PYR, COLOR0, EE, EH, P6, P5, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR1, P0, P3, P2, N0, 
  ST_PYR, COLOR1, EA, EB, P3, P0, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_TET, COLOR1, P4, P0, P2, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P4, P2, EK, EH, N0, 
  ST_PYR, COLOR1, EK, P2, P3, EL, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
 // Case #30: Unique case #12
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EK, EH, EE, 
  ST_TET, COLOR0, P0, EA, ED, EI, 
  ST_PYR, COLOR0, P5, P7, EL, EJ, N0, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR0, P7, P5, P6, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EH, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_TET, COLOR1, P1, P2, P4, N0, 
  ST_PYR, COLOR1, P2, EK, EH, P4, N0, 
  ST_TET, COLOR1, P3, P2, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P3, P1, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
 // Case #31: Unique case #13
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EK, EE, EH, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_PYR, COLOR0, P5, P7, EL, EJ, N0, 
  ST_TET, COLOR0, EE, P5, EJ, N0, 
  ST_PYR, COLOR0, EH, P6, P5, EE, N0, 
  ST_TET, COLOR0, P6, P7, P5, N0, 
  ST_PYR, COLOR1, P0, P1, P3, P2, N0, 
  ST_TET, COLOR1, P2, P4, P0, N0, 
  ST_TET, COLOR1, P4, P1, P0, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P3, P1, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P2, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
 // Case #32: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P7, P3, P1, P4, P6, P2, P0, 
  ST_WDG, COLOR0, P7, P1, P4, EF, EJ, EE, 
  ST_TET, COLOR0, P7, P1, P4, N0, 
  ST_TET, COLOR0, P7, P3, P1, N0, 
  ST_PYR, COLOR0, P2, P0, P1, P3, N0, 
  ST_PYR, COLOR0, P6, P2, P3, P7, N0, 
  ST_PYR, COLOR0, P4, P0, P2, P6, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_TET, COLOR0, P4, P6, P7, N0, 
  ST_TET, COLOR1, P5, EF, EJ, EE, 
 // Case #33: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, ED, EF, 
  ST_PYR, COLOR0, P2, P3, P7, P6, N0, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_TET, COLOR0, P2, P1, P3, N0, 
  ST_TET, COLOR0, P4, P2, P6, N0, 
  ST_TET, COLOR0, P7, P4, P6, N0, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, P2, ED, EA, P1, N0, 
  ST_PYR, COLOR0, P2, P4, EI, ED, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_TET, COLOR1, EA, P0, N0, ED, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #34: (cloned #3)
  ST_HEX, COLOR0, EF, P7, P3, EB, EE, P4, P0, EA, 
  ST_WDG, COLOR0, P0, P2, P3, P4, P6, P7, 
  ST_WDG, COLOR1, P1, EA, EB, P5, EE, EF, 
 // Case #35: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EE, EI, ED, 
  ST_PYR, COLOR0, P7, P6, P2, P3, N0, 
  ST_TET, COLOR0, P2, P4, N0, P6, 
  ST_PYR, COLOR0, P3, P2, ED, EB, N0, 
  ST_PYR, COLOR0, EF, P7, P3, EB, N0, 
  ST_TET, COLOR0, P4, P6, P7, N0, 
  ST_PYR, COLOR0, P4, P7, EF, EE, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR0, ED, P2, P4, EI, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_TET, COLOR1, EE, EF, P5, N0, 
  ST_TET, COLOR1, P5, P1, P0, N0, 
  ST_PYR, COLOR1, EE, P5, P0, EI, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
 // Case #36: (cloned #24)
  ST_WDG, COLOR0, P1, P4, P7, EJ, EE, EF, 
  ST_WDG, COLOR0, ED, EK, EC, P0, P6, P3, 
  ST_TET, COLOR0, P4, P7, P1, P6, 
  ST_TET, COLOR0, P3, P7, P6, P1, 
  ST_TET, COLOR0, P0, P1, P3, P6, 
  ST_TET, COLOR0, P4, P0, P6, P1, 
  ST_TET, COLOR1, P2, ED, EC, EK, 
  ST_TET, COLOR1, P5, EJ, EE, EF, 
 // Case #37: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EC, EK, EF, EF, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_TET, COLOR0, EE, EI, P4, N0, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_TET, COLOR0, P7, P4, P6, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR0, P3, P7, P6, N0, 
  ST_PYR, COLOR0, P3, P6, EK, EC, N0, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_PYR, COLOR1, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
  ST_PYR, COLOR1, EI, P0, P2, EK, N0, 
  ST_PYR, COLOR1, P0, EA, EC, P2, N0, 
  ST_TET, COLOR1, EC, EK, P2, N0, 
 // Case #38: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EF, EE, EK, EK, 
  ST_PYR, COLOR0, P6, P0, ED, EK, N0, 
  ST_TET, COLOR0, ED, P0, EA, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P6, P4, P0, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_TET, COLOR0, P7, P6, P3, N0, 
  ST_PYR, COLOR0, P3, P6, EK, EC, N0, 
  ST_TET, COLOR0, P7, P4, P6, N0, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_PYR, COLOR0, P7, P3, EB, EF, N0, 
  ST_PYR, COLOR1, P2, ED, EA, P1, N0, 
  ST_PYR, COLOR1, EB, EC, P2, P1, N0, 
  ST_TET, COLOR1, P2, EK, ED, N0, 
  ST_TET, COLOR1, EC, EK, P2, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, P1, P5, EF, EB, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #39: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EI, EE, EF, EB, EC, EK, 
  ST_TET, COLOR0, P7, P6, P3, N0, 
  ST_PYR, COLOR0, P7, P3, EB, EF, N0, 
  ST_TET, COLOR0, P4, P6, P7, N0, 
  ST_PYR, COLOR0, P4, P7, EF, EE, N0, 
  ST_TET, COLOR0, EI, P4, EE, N0, 
  ST_PYR, COLOR0, P4, EI, EK, P6, N0, 
  ST_PYR, COLOR0, EK, EC, P3, P6, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_PYR, COLOR1, EI, P0, P2, EK, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_TET, COLOR1, P2, EC, EK, N0, 
  ST_PYR, COLOR1, P2, P1, EB, EC, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #40: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EC, EE, 
  ST_PYR, COLOR0, P2, P6, P4, P0, N0, 
  ST_TET, COLOR0, P6, P7, P4, N0, 
  ST_TET, COLOR0, P2, P7, P6, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_PYR, COLOR0, P2, EC, EL, P7, N0, 
  ST_PYR, COLOR0, P2, P1, EB, EC, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P3, EB, EJ, P5, N0, 
  ST_PYR, COLOR1, EL, P3, P5, EF, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EL, P3, N0, EC, 
  ST_TET, COLOR1, EB, P3, EC, N0, 
 // Case #41: (cloned #22)
  ST_TET, COLOR0, P1, EA, EJ, EB, 
  ST_TET, COLOR0, P7, P6, P2, P4, 
  ST_PYR, COLOR0, EI, ED, P2, P4, EC, 
  ST_PYR, COLOR0, EE, P4, P7, EF, EL, 
  ST_PYR, COLOR0, P2, EC, EL, P7, P4, 
  ST_PYR, COLOR0, EC, EI, EE, EL, P4, 
  ST_WDG, COLOR1, P0, P5, P3, EA, EJ, EB, 
  ST_PYR, COLOR1, P0, P3, EC, ED, EI, 
  ST_PYR, COLOR1, EL, P3, P5, EF, EE, 
  ST_PYR, COLOR1, EI, EE, P5, P0, P3, 
  ST_PYR, COLOR1, EI, EC, EL, EE, P3, 
 // Case #42: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EE, EA, EF, EL, EC, 
  ST_PYR, COLOR0, P4, P0, P2, P6, N0, 
  ST_TET, COLOR0, P2, N0, P7, P6, 
  ST_PYR, COLOR0, P0, EA, EC, P2, N0, 
  ST_PYR, COLOR0, EE, EA, P0, P4, N0, 
  ST_TET, COLOR0, P7, P4, P6, N0, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_PYR, COLOR0, EC, EL, P7, P2, N0, 
  ST_PYR, COLOR1, EA, P1, P3, EC, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_TET, COLOR1, P5, P3, P1, N0, 
  ST_PYR, COLOR1, EF, EL, P3, P5, N0, 
  ST_TET, COLOR1, P3, EL, EC, N0, 
 // Case #43: (cloned #23)
  ST_TET, COLOR0, P7, P6, P2, P4, 
  ST_PYR, COLOR0, EI, ED, P2, P4, EC, 
  ST_PYR, COLOR0, EE, P4, P7, EF, EL, 
  ST_PYR, COLOR0, P2, EC, EL, P7, P4, 
  ST_PYR, COLOR0, EC, EI, EE, EL, P4, 
  ST_TET, COLOR1, P1, P0, P5, P3, 
  ST_PYR, COLOR1, EC, ED, P0, P3, EI, 
  ST_PYR, COLOR1, EL, P3, P5, EF, EE, 
  ST_PYR, COLOR1, P0, EI, EE, P5, P3, 
  ST_PYR, COLOR1, EC, EL, EE, EI, P3, 
 // Case #44: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EK, ED, EE, EE, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR0, EJ, EB, P1, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_TET, COLOR0, P6, P7, P4, N0, 
  ST_PYR, COLOR0, P7, EF, EE, P4, N0, 
  ST_TET, COLOR0, P6, P4, P0, N0, 
  ST_PYR, COLOR0, P6, P0, ED, EK, N0, 
  ST_PYR, COLOR0, P6, EK, EL, P7, N0, 
  ST_PYR, COLOR1, P5, P3, EB, EJ, N0, 
  ST_PYR, COLOR1, EL, P3, P5, EF, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_PYR, COLOR1, P3, EL, EK, P2, N0, 
  ST_TET, COLOR1, EK, ED, P2, N0, 
 // Case #45: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EI, EE, EF, 
  ST_TET, COLOR0, P1, EB, EA, EJ, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR0, P6, P7, P4, N0, 
  ST_PYR, COLOR0, P4, P7, EF, EE, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_WDG, COLOR1, EA, EB, EJ, P0, P3, P5, 
  ST_TET, COLOR1, P3, P0, P5, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_TET, COLOR1, P2, P0, P3, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P3, N0, 
  ST_TET, COLOR1, EE, EF, P5, N0, 
 // Case #46: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EA, ED, EK, EL, EF, EE, 
  ST_TET, COLOR0, P6, P7, P4, N0, 
  ST_PYR, COLOR0, P6, EK, EL, P7, N0, 
  ST_TET, COLOR0, P0, P6, P4, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P6, N0, 
  ST_TET, COLOR0, EA, ED, P0, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_PYR, COLOR0, EE, P4, P7, EF, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_TET, COLOR1, P1, P3, P2, N0, 
  ST_PYR, COLOR1, EA, P1, P2, ED, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_TET, COLOR1, P5, P3, P1, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P3, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_TET, COLOR1, EK, ED, P2, N0, 
 // Case #47: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EI, EF, EE, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR0, P7, P6, EK, EL, N0, 
  ST_TET, COLOR0, EF, P7, EL, N0, 
  ST_PYR, COLOR0, EE, P4, P7, EF, N0, 
  ST_TET, COLOR0, P4, P6, P7, N0, 
  ST_PYR, COLOR1, P1, P3, P2, P0, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_TET, COLOR1, P5, P3, P1, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P3, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #48: (cloned #3)
  ST_HEX, COLOR0, EJ, P1, P0, EI, EF, P7, P6, EH, 
  ST_WDG, COLOR0, P1, P3, P7, P0, P2, P6, 
  ST_WDG, COLOR1, P5, EJ, EF, P4, EI, EH, 
 // Case #49: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, EJ, EA, ED, 
  ST_PYR, COLOR0, P7, P6, P2, P3, N0, 
  ST_TET, COLOR0, P2, N0, P1, P3, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_PYR, COLOR0, EF, EH, P6, P7, N0, 
  ST_TET, COLOR0, P1, P7, P3, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, ED, EA, P1, P2, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
  ST_TET, COLOR1, P5, P0, P4, N0, 
  ST_PYR, COLOR1, EJ, EA, P0, P5, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
 // Case #50: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, EI, EA, EB, 
  ST_PYR, COLOR0, P6, P2, P3, P7, N0, 
  ST_TET, COLOR0, P3, P0, N0, P2, 
  ST_PYR, COLOR0, P7, P3, EB, EF, N0, 
  ST_PYR, COLOR0, EH, P6, P7, EF, N0, 
  ST_TET, COLOR0, P0, P2, P6, N0, 
  ST_PYR, COLOR0, P0, P6, EH, EI, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, EB, P3, P0, EA, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
 // Case #51: (cloned #15)
  ST_HEX, COLOR0, P2, P3, P7, P6, ED, EB, EF, EH, 
  ST_HEX, COLOR1, ED, EB, EF, EH, P0, P1, P5, P4, 
 // Case #52: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EF, EJ, EC, EC, 
  ST_PYR, COLOR0, P3, EC, ED, P0, N0, 
  ST_TET, COLOR0, ED, EI, P0, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR0, P7, P6, P3, N0, 
  ST_PYR, COLOR0, P6, EK, EC, P3, N0, 
  ST_TET, COLOR0, P7, P3, P1, N0, 
  ST_PYR, COLOR0, P7, P1, EJ, EF, N0, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_PYR, COLOR1, P2, P4, EI, ED, N0, 
  ST_PYR, COLOR1, EH, P4, P2, EK, N0, 
  ST_TET, COLOR1, P2, ED, EC, N0, 
  ST_TET, COLOR1, EK, P2, EC, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, P4, EH, EF, P5, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #53: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EA, EJ, EF, EH, EK, EC, 
  ST_TET, COLOR0, P7, P6, P3, N0, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_TET, COLOR0, P1, P7, P3, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, P1, P3, EC, EA, N0, 
  ST_PYR, COLOR0, EC, P3, P6, EK, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_PYR, COLOR1, EA, EC, P2, P0, N0, 
  ST_TET, COLOR1, P2, P4, P0, N0, 
  ST_TET, COLOR1, P2, EC, EK, N0, 
  ST_PYR, COLOR1, P2, EK, EH, P4, N0, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #54: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EH, EK, EC, 
  ST_TET, COLOR0, P0, EI, EA, ED, 
  ST_PYR, COLOR0, P3, EB, EF, P7, N0, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_TET, COLOR0, P7, P6, P3, N0, 
  ST_PYR, COLOR0, P6, EK, EC, P3, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_WDG, COLOR1, P4, P1, P2, EI, EA, ED, 
  ST_TET, COLOR1, P1, P2, P4, N0, 
  ST_PYR, COLOR1, P4, P2, EK, EH, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, P2, P1, EB, EC, N0, 
  ST_TET, COLOR1, EK, P2, EC, N0, 
 // Case #55: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, EH, EC, EK, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_TET, COLOR0, P6, EH, EK, N0, 
  ST_PYR, COLOR0, P3, EB, EF, P7, N0, 
  ST_TET, COLOR0, EC, EB, P3, N0, 
  ST_PYR, COLOR0, EK, EC, P3, P6, N0, 
  ST_TET, COLOR0, P6, P3, P7, N0, 
  ST_PYR, COLOR1, P0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P4, P0, P2, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_PYR, COLOR1, P2, P1, EB, EC, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P2, EK, N0, 
  ST_TET, COLOR1, EC, EK, P2, N0, 
 // Case #56: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EH, EI, EC, EC, 
  ST_PYR, COLOR0, P2, P1, EB, EC, N0, 
  ST_TET, COLOR0, EB, P1, EJ, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_TET, COLOR0, P6, P2, P7, N0, 
  ST_PYR, COLOR0, P7, P2, EC, EL, N0, 
  ST_TET, COLOR0, P6, P0, P2, N0, 
  ST_PYR, COLOR0, P6, EH, EI, P0, N0, 
  ST_PYR, COLOR0, P6, P7, EF, EH, N0, 
  ST_PYR, COLOR1, P3, EB, EJ, P5, N0, 
  ST_PYR, COLOR1, EF, EL, P3, P5, N0, 
  ST_TET, COLOR1, P3, EC, EB, N0, 
  ST_TET, COLOR1, EL, EC, P3, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, P5, P4, EH, EF, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #57: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, ED, EC, EL, 
  ST_TET, COLOR0, P1, EA, EJ, EB, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_TET, COLOR0, P6, P2, P7, N0, 
  ST_PYR, COLOR0, P2, EC, EL, P7, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_WDG, COLOR1, P0, P5, P3, EA, EJ, EB, 
  ST_TET, COLOR1, P5, P3, P0, N0, 
  ST_PYR, COLOR1, P0, P3, EC, ED, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, P3, P5, EF, EL, N0, 
  ST_TET, COLOR1, EC, P3, EL, N0, 
 // Case #58: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EA, EI, EH, EF, EL, EC, 
  ST_TET, COLOR0, P6, P2, P7, N0, 
  ST_PYR, COLOR0, P6, P7, EF, EH, N0, 
  ST_TET, COLOR0, P0, P2, P6, N0, 
  ST_PYR, COLOR0, P0, P6, EH, EI, N0, 
  ST_TET, COLOR0, EA, P0, EI, N0, 
  ST_PYR, COLOR0, P0, EA, EC, P2, N0, 
  ST_PYR, COLOR0, EC, EL, P7, P2, N0, 
  ST_TET, COLOR0, P7, EL, EF, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_PYR, COLOR1, EA, P1, P3, EC, N0, 
  ST_TET, COLOR1, P3, P1, P5, N0, 
  ST_TET, COLOR1, P3, EL, EC, N0, 
  ST_PYR, COLOR1, P3, P5, EF, EL, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #59: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, ED, EL, EC, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_PYR, COLOR0, P7, EF, EH, P6, N0, 
  ST_TET, COLOR0, EL, EF, P7, N0, 
  ST_PYR, COLOR0, EC, EL, P7, P2, N0, 
  ST_TET, COLOR0, P2, P7, P6, N0, 
  ST_PYR, COLOR1, P1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_TET, COLOR1, P3, P1, P5, N0, 
  ST_PYR, COLOR1, P3, P5, EF, EL, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P3, EC, N0, 
  ST_TET, COLOR1, EL, EC, P3, N0, 
 // Case #60: Unique case #14
  ST_WDG, COLOR0, P1, EB, EJ, P0, ED, EI, 
  ST_WDG, COLOR0, P7, EF, EL, P6, EH, EK, 
  ST_HEX, COLOR1, P2, P4, P5, P3, EK, EH, EF, EL, 
  ST_HEX, COLOR1, ED, EI, EJ, EB, P2, P4, P5, P3, 
 // Case #61: Unique case #15
  ST_PNT, 0, COLOR1, 6, P0, P3, P2, P4, EF, EH, 
  ST_WDG, COLOR0, EH, P6, EK, EF, P7, EL, 
  ST_TET, COLOR0, EA, P1, EB, EJ, 
  ST_WDG, COLOR1, P0, P5, P3, EA, EJ, EB, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_TET, COLOR1, P4, P0, P2, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P2, N0, 
  ST_PYR, COLOR1, EL, EK, P2, P3, N0, 
  ST_TET, COLOR1, P2, P0, P3, N0, 
  ST_PYR, COLOR1, EF, EH, EK, EL, N0, 
  ST_TET, COLOR1, P3, P0, P5, N0, 
  ST_PYR, COLOR1, EF, EL, P3, P5, N0, 
 // Case #62: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P2, P3, P5, EH, EF, 
  ST_WDG, COLOR0, EH, P6, EK, EF, P7, EL, 
  ST_TET, COLOR0, EA, ED, P0, EI, 
  ST_WDG, COLOR1, EA, EI, ED, P1, P4, P2, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_TET, COLOR1, P5, P3, P1, N0, 
  ST_PYR, COLOR1, EL, P3, P5, EF, N0, 
  ST_PYR, COLOR1, EK, P2, P3, EL, N0, 
  ST_TET, COLOR1, P3, P2, P1, N0, 
  ST_PYR, COLOR1, EH, EK, EL, EF, N0, 
  ST_TET, COLOR1, P2, P4, P1, N0, 
  ST_PYR, COLOR1, EH, P4, P2, EK, N0, 
 // Case #63: Unique case #16
  ST_WDG, COLOR0, P6, EK, EH, P7, EL, EF, 
  ST_HEX, COLOR1, P2, P4, P5, P3, EK, EH, EF, EL, 
  ST_WDG, COLOR1, P1, P3, P5, P0, P2, P4, 
 // Case #64: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P7, P5, P4, P2, P3, P1, P0, 
  ST_WDG, COLOR0, P7, P4, P2, EG, EH, EK, 
  ST_TET, COLOR0, P7, P4, P2, N0, 
  ST_TET, COLOR0, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P1, P0, P4, P5, N0, 
  ST_PYR, COLOR0, P3, P1, P5, P7, N0, 
  ST_PYR, COLOR0, P2, P0, P1, P3, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_TET, COLOR0, P2, P3, P7, N0, 
  ST_TET, COLOR1, P6, EG, EH, EK, 
 // Case #65: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EA, EG, 
  ST_PYR, COLOR0, P1, P5, P7, P3, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_TET, COLOR0, P2, P1, P3, N0, 
  ST_TET, COLOR0, P7, P2, P3, N0, 
  ST_PYR, COLOR0, P7, EG, EK, P2, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR0, P1, P2, ED, EA, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P6, N0, 
  ST_PYR, COLOR1, EI, P0, P6, EH, N0, 
  ST_TET, COLOR1, EH, P6, EG, N0, 
  ST_TET, COLOR1, P6, EK, EG, N0, 
  ST_TET, COLOR1, EI, P0, N0, EA, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
 // Case #66: (cloned #24)
  ST_WDG, COLOR0, P4, P2, P7, EH, EK, EG, 
  ST_WDG, COLOR0, EA, EB, EJ, P0, P3, P5, 
  ST_TET, COLOR0, P2, P7, P4, P3, 
  ST_TET, COLOR0, P5, P7, P3, P4, 
  ST_TET, COLOR0, P0, P4, P5, P3, 
  ST_TET, COLOR0, P2, P0, P3, P4, 
  ST_TET, COLOR1, P1, EA, EJ, EB, 
  ST_TET, COLOR1, P6, EH, EK, EG, 
 // Case #67: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EJ, EB, EG, EG, 
  ST_PYR, COLOR0, P7, EG, EK, P2, N0, 
  ST_TET, COLOR0, EK, ED, P2, N0, 
  ST_PYR, COLOR0, P3, P2, ED, EB, N0, 
  ST_TET, COLOR0, P7, P2, P3, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_TET, COLOR0, P5, P7, P3, N0, 
  ST_PYR, COLOR0, P5, P3, EB, EJ, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_PYR, COLOR1, P6, P0, ED, EK, N0, 
  ST_PYR, COLOR1, EI, P0, P6, EH, N0, 
  ST_TET, COLOR1, P6, EK, EG, N0, 
  ST_TET, COLOR1, EH, P6, EG, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
 // Case #68: (cloned #3)
  ST_HEX, COLOR0, EH, P4, P0, ED, EG, P7, P3, EC, 
  ST_WDG, COLOR0, P4, P5, P7, P0, P1, P3, 
  ST_WDG, COLOR1, P6, EH, EG, P2, ED, EC, 
 // Case #69: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EH, EI, EA, 
  ST_PYR, COLOR0, P7, P3, P1, P5, N0, 
  ST_TET, COLOR0, P1, N0, P4, P5, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_PYR, COLOR0, EG, EC, P3, P7, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, EA, EI, P4, P1, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_TET, COLOR1, EH, P6, EG, N0, 
  ST_TET, COLOR1, P6, P0, P2, N0, 
  ST_PYR, COLOR1, EH, EI, P0, P6, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
 // Case #70: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EG, EH, EJ, EJ, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_TET, COLOR0, EA, ED, P0, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_PYR, COLOR0, P3, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P7, P4, EH, EG, N0, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_PYR, COLOR1, P1, P2, ED, EA, N0, 
  ST_PYR, COLOR1, EC, P2, P1, EB, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_PYR, COLOR1, ED, P2, P6, EH, N0, 
  ST_PYR, COLOR1, P2, EC, EG, P6, N0, 
  ST_TET, COLOR1, EG, EH, P6, N0, 
 // Case #71: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EI, EH, EG, EC, EB, EJ, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_TET, COLOR0, EI, EH, P4, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_PYR, COLOR0, EJ, P5, P3, EB, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_TET, COLOR1, P0, P2, P6, N0, 
  ST_PYR, COLOR1, EI, P0, P6, EH, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_TET, COLOR1, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P1, EB, EC, P2, N0, 
  ST_PYR, COLOR1, EC, EG, P6, P2, N0, 
  ST_TET, COLOR1, EG, EH, P6, N0, 
 // Case #72: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EH, EB, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_TET, COLOR0, P2, P4, P0, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P2, N0, 
  ST_PYR, COLOR0, P7, EL, EB, P1, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_PYR, COLOR0, P4, P2, EK, EH, N0, 
  ST_TET, COLOR0, P2, EC, EK, N0, 
  ST_PYR, COLOR1, P6, EK, EC, P3, N0, 
  ST_PYR, COLOR1, EG, P6, P3, EL, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
  ST_TET, COLOR1, P3, EC, EB, N0, 
  ST_TET, COLOR1, EG, P6, N0, EH, 
  ST_TET, COLOR1, EK, P6, EH, N0, 
 // Case #73: (cloned #22)
  ST_TET, COLOR0, P2, ED, EC, EK, 
  ST_TET, COLOR0, P7, P5, P4, P1, 
  ST_PYR, COLOR0, EA, EI, P4, P1, EH, 
  ST_PYR, COLOR0, EB, P1, P7, EL, EG, 
  ST_PYR, COLOR0, P4, EH, EG, P7, P1, 
  ST_PYR, COLOR0, EH, EA, EB, EG, P1, 
  ST_WDG, COLOR1, P0, P3, P6, ED, EC, EK, 
  ST_PYR, COLOR1, P0, P6, EH, EI, EA, 
  ST_PYR, COLOR1, EG, P6, P3, EL, EB, 
  ST_PYR, COLOR1, EA, EB, P3, P0, P6, 
  ST_PYR, COLOR1, EA, EH, EG, EB, P6, 
 // Case #74: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EJ, EA, EH, EH, 
  ST_PYR, COLOR0, P4, P2, EK, EH, N0, 
  ST_TET, COLOR0, EK, P2, EC, N0, 
  ST_PYR, COLOR0, P0, EA, EC, P2, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P7, P4, EH, EG, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_PYR, COLOR0, P5, P7, EL, EJ, N0, 
  ST_PYR, COLOR1, P6, EK, EC, P3, N0, 
  ST_PYR, COLOR1, EL, EG, P6, P3, N0, 
  ST_TET, COLOR1, P6, EH, EK, N0, 
  ST_TET, COLOR1, EG, EH, P6, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, P3, P1, EJ, EL, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #75: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EI, EH, EG, 
  ST_TET, COLOR0, P2, ED, EC, EK, 
  ST_PYR, COLOR0, P7, EL, EJ, P5, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P7, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_WDG, COLOR1, P0, P3, P6, ED, EC, EK, 
  ST_TET, COLOR1, P3, P6, P0, N0, 
  ST_PYR, COLOR1, P0, P6, EH, EI, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_PYR, COLOR1, P6, P3, EL, EG, N0, 
  ST_TET, COLOR1, EH, P6, EG, N0, 
 // Case #76: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EB, ED, EL, EG, EH, 
  ST_PYR, COLOR0, P1, P0, P4, P5, N0, 
  ST_TET, COLOR0, P4, N0, P7, P5, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_PYR, COLOR0, EB, ED, P0, P1, N0, 
  ST_TET, COLOR0, P7, P1, P5, N0, 
  ST_PYR, COLOR0, P7, EL, EB, P1, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_PYR, COLOR0, EH, EG, P7, P4, N0, 
  ST_PYR, COLOR1, ED, P2, P6, EH, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
  ST_TET, COLOR1, P3, P6, P2, N0, 
  ST_PYR, COLOR1, EL, EG, P6, P3, N0, 
  ST_TET, COLOR1, P6, EG, EH, N0, 
 // Case #77: (cloned #23)
  ST_TET, COLOR0, P7, P5, P4, P1, 
  ST_PYR, COLOR0, EA, EI, P4, P1, EH, 
  ST_PYR, COLOR0, EB, P1, P7, EL, EG, 
  ST_PYR, COLOR0, P4, EH, EG, P7, P1, 
  ST_PYR, COLOR0, EH, EA, EB, EG, P1, 
  ST_TET, COLOR1, P2, P0, P3, P6, 
  ST_PYR, COLOR1, EH, EI, P0, P6, EA, 
  ST_PYR, COLOR1, EG, P6, P3, EL, EB, 
  ST_PYR, COLOR1, P0, EA, EB, P3, P6, 
  ST_PYR, COLOR1, EH, EG, EB, EA, P6, 
 // Case #78: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, ED, EA, EJ, EL, EG, EH, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P5, P7, EL, EJ, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, ED, P0, EA, N0, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_PYR, COLOR0, EH, EG, P7, P4, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_TET, COLOR1, P2, P1, P3, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P2, N0, 
  ST_PYR, COLOR1, ED, P2, P6, EH, N0, 
  ST_TET, COLOR1, P6, P2, P3, N0, 
  ST_TET, COLOR1, P6, EG, EH, N0, 
  ST_PYR, COLOR1, P6, P3, EL, EG, N0, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #79: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EI, EG, EH, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P7, EL, EJ, P5, N0, 
  ST_TET, COLOR0, EG, EL, P7, N0, 
  ST_PYR, COLOR0, EH, EG, P7, P4, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_PYR, COLOR1, P2, P0, P1, P3, N0, 
  ST_TET, COLOR1, P0, P2, P6, N0, 
  ST_TET, COLOR1, P6, P2, P3, N0, 
  ST_PYR, COLOR1, P6, P3, EL, EG, N0, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_PYR, COLOR1, EI, P0, P6, EH, N0, 
  ST_TET, COLOR1, EG, EH, P6, N0, 
 // Case #80: (cloned #3)
  ST_HEX, COLOR0, EG, P7, P5, EE, EK, P2, P0, EI, 
  ST_WDG, COLOR0, P0, P1, P5, P2, P3, P7, 
  ST_WDG, COLOR1, P4, EI, EE, P6, EK, EG, 
 // Case #81: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EK, ED, EA, 
  ST_PYR, COLOR0, P7, P3, P1, P5, N0, 
  ST_TET, COLOR0, P1, P2, N0, P3, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_PYR, COLOR0, EG, P7, P5, EE, N0, 
  ST_TET, COLOR0, P2, P3, P7, N0, 
  ST_PYR, COLOR0, P2, P7, EG, EK, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_PYR, COLOR0, EA, P1, P2, ED, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_TET, COLOR1, EK, EG, P6, N0, 
  ST_TET, COLOR1, P6, P4, P0, N0, 
  ST_PYR, COLOR1, EK, P6, P0, ED, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
 // Case #82: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EG, EK, EB, EB, 
  ST_PYR, COLOR0, P3, P0, EA, EB, N0, 
  ST_TET, COLOR0, EA, P0, EI, N0, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_TET, COLOR0, P3, P2, P0, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_PYR, COLOR0, P5, P3, EB, EJ, N0, 
  ST_TET, COLOR0, P7, P2, P3, N0, 
  ST_PYR, COLOR0, P7, EG, EK, P2, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EG, N0, 
  ST_PYR, COLOR1, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_PYR, COLOR1, EI, EK, P6, P4, N0, 
  ST_PYR, COLOR1, P4, P6, EG, EE, N0, 
  ST_TET, COLOR1, EG, P6, EK, N0, 
 // Case #83: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, ED, EK, EG, EE, EJ, EB, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EG, N0, 
  ST_TET, COLOR0, P2, P3, P7, N0, 
  ST_PYR, COLOR0, P2, P7, EG, EK, N0, 
  ST_TET, COLOR0, ED, P2, EK, N0, 
  ST_PYR, COLOR0, P2, ED, EB, P3, N0, 
  ST_PYR, COLOR0, EB, EJ, P5, P3, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR1, P0, P6, P4, N0, 
  ST_PYR, COLOR1, ED, EK, P6, P0, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_TET, COLOR1, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EG, N0, 
  ST_TET, COLOR1, EG, P6, EK, N0, 
 // Case #84: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, ED, EI, EE, 
  ST_PYR, COLOR0, P3, P1, P5, P7, N0, 
  ST_TET, COLOR0, P5, P0, N0, P1, 
  ST_PYR, COLOR0, P7, P5, EE, EG, N0, 
  ST_PYR, COLOR0, EC, P3, P7, EG, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_PYR, COLOR0, P0, P3, EC, ED, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, EE, P5, P0, EI, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_PYR, COLOR1, EC, EG, P6, P2, N0, 
  ST_TET, COLOR1, ED, EC, P2, N0, 
  ST_TET, COLOR1, P2, P6, P4, N0, 
  ST_PYR, COLOR1, ED, P2, P4, EI, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
 // Case #85: (cloned #15)
  ST_HEX, COLOR0, P1, P5, P7, P3, EA, EE, EG, EC, 
  ST_HEX, COLOR1, EA, EE, EG, EC, P0, P4, P6, P2, 
 // Case #86: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EC, EB, EJ, 
  ST_TET, COLOR0, P0, ED, EI, EA, 
  ST_PYR, COLOR0, P5, EE, EG, P7, N0, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_TET, COLOR0, P7, P3, P5, N0, 
  ST_PYR, COLOR0, P3, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_WDG, COLOR1, P2, P4, P1, ED, EI, EA, 
  ST_TET, COLOR1, P4, P1, P2, N0, 
  ST_PYR, COLOR1, P2, P1, EB, EC, N0, 
  ST_TET, COLOR1, P6, P4, P2, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EG, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
 // Case #87: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EC, EJ, EB, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_TET, COLOR0, P3, EC, EB, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P7, N0, 
  ST_TET, COLOR0, EJ, EE, P5, N0, 
  ST_PYR, COLOR0, EB, EJ, P5, P3, N0, 
  ST_TET, COLOR0, P3, P5, P7, N0, 
  ST_PYR, COLOR1, P0, P2, P6, P4, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EG, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_PYR, COLOR1, EC, P2, P1, EB, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
 // Case #88: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EE, EI, EB, EB, 
  ST_PYR, COLOR0, P1, EB, EC, P2, N0, 
  ST_TET, COLOR0, EC, EK, P2, N0, 
  ST_PYR, COLOR0, P0, P2, EK, EI, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_PYR, COLOR0, P7, EL, EB, P1, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P7, N0, 
  ST_PYR, COLOR1, P3, P6, EK, EC, N0, 
  ST_PYR, COLOR1, EG, P6, P3, EL, N0, 
  ST_TET, COLOR1, P3, EC, EB, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, P6, EG, EE, P4, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #89: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EA, EB, EL, 
  ST_TET, COLOR0, P2, EK, ED, EC, 
  ST_PYR, COLOR0, P7, P5, EE, EG, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_PYR, COLOR0, P1, P7, EL, EB, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P6, P3, 
  ST_TET, COLOR1, P6, P0, P3, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P3, N0, 
  ST_TET, COLOR1, P4, P0, P6, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_PYR, COLOR1, P3, EL, EG, P6, N0, 
  ST_TET, COLOR1, EB, EL, P3, N0, 
 // Case #90: (cloned #60)
  ST_WDG, COLOR0, P2, EK, EC, P0, EI, EA, 
  ST_WDG, COLOR0, P7, EL, EG, P5, EJ, EE, 
  ST_HEX, COLOR1, P4, P1, P3, P6, EE, EJ, EL, EG, 
  ST_HEX, COLOR1, EI, EA, EC, EK, P4, P1, P3, P6, 
 // Case #91: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P0, P6, P4, P1, EL, EJ, 
  ST_WDG, COLOR0, EJ, P5, EE, EL, P7, EG, 
  ST_TET, COLOR0, ED, P2, EK, EC, 
  ST_WDG, COLOR1, P0, P3, P6, ED, EC, EK, 
  ST_PYR, COLOR1, EJ, EL, P3, P1, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_TET, COLOR1, P4, P0, P6, N0, 
  ST_PYR, COLOR1, EL, EJ, EE, EG, N0, 
  ST_TET, COLOR1, P6, P0, P3, N0, 
  ST_PYR, COLOR1, EL, EG, P6, P3, N0, 
 // Case #92: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, ED, EI, EE, EG, EL, EB, 
  ST_TET, COLOR0, P5, P7, P1, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P7, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, ED, EI, P0, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_PYR, COLOR0, EB, P1, P7, EL, N0, 
  ST_TET, COLOR0, P7, EG, EL, N0, 
  ST_TET, COLOR1, P2, P6, P4, N0, 
  ST_PYR, COLOR1, ED, P2, P4, EI, N0, 
  ST_PYR, COLOR1, ED, EB, P3, P2, N0, 
  ST_TET, COLOR1, P3, P6, P2, N0, 
  ST_TET, COLOR1, P3, EB, EL, N0, 
  ST_PYR, COLOR1, P3, EL, EG, P6, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #93: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EA, EL, EB, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EG, N0, 
  ST_TET, COLOR0, EL, P7, EG, N0, 
  ST_PYR, COLOR0, EB, P1, P7, EL, N0, 
  ST_TET, COLOR0, P1, P5, P7, N0, 
  ST_PYR, COLOR1, P2, P6, P4, P0, N0, 
  ST_TET, COLOR1, P0, P3, P2, N0, 
  ST_TET, COLOR1, P3, P6, P2, N0, 
  ST_PYR, COLOR1, P3, EL, EG, P6, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P6, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_PYR, COLOR1, EA, EB, P3, P0, N0, 
  ST_TET, COLOR1, EL, P3, EB, N0, 
 // Case #94: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P4, P6, P3, EJ, EL, 
  ST_WDG, COLOR0, EJ, P5, EE, EL, P7, EG, 
  ST_TET, COLOR0, ED, EI, P0, EA, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_PYR, COLOR1, EL, P3, P1, EJ, N0, 
  ST_TET, COLOR1, P3, P2, P1, N0, 
  ST_TET, COLOR1, P3, P6, P2, N0, 
  ST_PYR, COLOR1, EG, P6, P3, EL, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EG, N0, 
  ST_TET, COLOR1, P6, P4, P2, N0, 
  ST_PYR, COLOR1, EJ, EE, EG, EL, N0, 
  ST_TET, COLOR1, P4, P1, P2, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
 // Case #95: (cloned #63)
  ST_WDG, COLOR0, P5, EE, EJ, P7, EG, EL, 
  ST_HEX, COLOR1, P4, P1, P3, P6, EE, EJ, EL, EG, 
  ST_WDG, COLOR1, P2, P6, P3, P0, P4, P1, 
 // Case #96: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EK, EJ, 
  ST_PYR, COLOR0, P2, P0, P1, P3, N0, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_TET, COLOR0, P2, P3, P7, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR0, P7, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_PYR, COLOR0, P2, P7, EG, EK, N0, 
  ST_PYR, COLOR0, P2, EK, EH, P4, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P6, P5, EE, EH, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P6, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EG, N0, P6, EK, 
  ST_TET, COLOR1, EH, EK, P6, N0, 
 // Case #97: (cloned #22)
  ST_TET, COLOR0, P4, EE, EI, EH, 
  ST_TET, COLOR0, P7, P2, P3, P1, 
  ST_PYR, COLOR0, EA, P1, P2, ED, EK, 
  ST_PYR, COLOR0, EJ, EF, P7, P1, EG, 
  ST_PYR, COLOR0, P2, P7, EG, EK, P1, 
  ST_PYR, COLOR0, EK, EG, EJ, EA, P1, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P6, 
  ST_PYR, COLOR1, P0, ED, EK, P6, EA, 
  ST_PYR, COLOR1, EG, EF, P5, P6, EJ, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, P6, 
  ST_PYR, COLOR1, EA, EJ, EG, EK, P6, 
 // Case #98: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EB, EA, EK, EK, 
  ST_PYR, COLOR0, P2, EK, EH, P4, N0, 
  ST_TET, COLOR0, EH, EE, P4, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P2, P4, P0, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_TET, COLOR0, P3, P7, P2, N0, 
  ST_PYR, COLOR0, P7, EG, EK, P2, N0, 
  ST_TET, COLOR0, P3, P2, P0, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EB, N0, 
  ST_PYR, COLOR0, P3, EB, EF, P7, N0, 
  ST_PYR, COLOR1, P6, P5, EE, EH, N0, 
  ST_PYR, COLOR1, EF, P5, P6, EG, N0, 
  ST_TET, COLOR1, P6, EH, EK, N0, 
  ST_TET, COLOR1, EG, P6, EK, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, P5, EF, EB, P1, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #99: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, ED, EK, EG, 
  ST_TET, COLOR0, P4, EE, EI, EH, 
  ST_PYR, COLOR0, P7, P3, EB, EF, N0, 
  ST_PYR, COLOR0, P3, P2, ED, EB, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_TET, COLOR0, P3, P7, P2, N0, 
  ST_PYR, COLOR0, P2, P7, EG, EK, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P6, 
  ST_TET, COLOR1, P5, P0, P6, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P6, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, P6, EG, EF, P5, N0, 
  ST_TET, COLOR1, EK, EG, P6, N0, 
 // Case #100: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EC, ED, EJ, EJ, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_PYR, COLOR0, P7, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_PYR, COLOR0, P3, EC, ED, P0, N0, 
  ST_PYR, COLOR0, P3, P7, EG, EC, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P6, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P6, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, P6, P2, EC, EG, N0, 
  ST_TET, COLOR1, EC, P2, ED, N0, 
 // Case #101: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EA, EJ, EF, 
  ST_TET, COLOR0, P4, EI, EH, EE, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_WDG, COLOR1, P0, P6, P5, EI, EH, EE, 
  ST_TET, COLOR1, P6, P5, P0, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR1, P2, P6, P0, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_PYR, COLOR1, P5, P6, EG, EF, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
 // Case #102: (cloned #60)
  ST_WDG, COLOR0, P0, ED, EA, P4, EH, EE, 
  ST_WDG, COLOR0, P3, EB, EC, P7, EF, EG, 
  ST_HEX, COLOR1, EC, EB, EF, EG, P2, P1, P5, P6, 
  ST_HEX, COLOR1, P2, P1, P5, P6, ED, EA, EE, EH, 
 // Case #103: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P0, P6, P2, P1, EF, EB, 
  ST_WDG, COLOR0, EF, P7, EG, EB, P3, EC, 
  ST_TET, COLOR0, EI, EH, P4, EE, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P6, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_PYR, COLOR1, EC, P2, P1, EB, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_TET, COLOR1, P2, P6, P0, N0, 
  ST_PYR, COLOR1, EF, EG, EC, EB, N0, 
  ST_TET, COLOR1, P6, P5, P0, N0, 
  ST_PYR, COLOR1, EF, P5, P6, EG, N0, 
 // Case #104: (cloned #22)
  ST_TET, COLOR0, P7, EF, EG, EL, 
  ST_TET, COLOR0, P2, P0, P1, P4, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR0, EH, P4, P2, EK, EC, 
  ST_PYR, COLOR0, P1, EB, EC, P2, P4, 
  ST_PYR, COLOR0, EB, EE, EH, EC, P4, 
  ST_WDG, COLOR1, P5, P6, P3, EF, EG, EL, 
  ST_PYR, COLOR1, P5, P3, EB, EJ, EE, 
  ST_PYR, COLOR1, EC, P3, P6, EK, EH, 
  ST_PYR, COLOR1, EE, EH, P6, P5, P3, 
  ST_PYR, COLOR1, EE, EB, EC, EH, P3, 
 // Case #105: Unique case #17
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_TET, COLOR0, EK, EC, ED, P2, 
  ST_TET, COLOR0, EG, EF, EL, P7, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, P3, P0, P5, EB, EA, EJ, 
  ST_TET, COLOR1, P3, P0, P5, P6, 
  ST_WDG, COLOR1, EG, EF, EL, P6, P5, P3, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P6, P3, 
  ST_WDG, COLOR1, EE, EH, EI, P5, P6, P0, 
 // Case #106: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EE, EH, EK, 
  ST_TET, COLOR0, P7, EL, EF, EG, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_TET, COLOR0, P0, P2, P4, N0, 
  ST_PYR, COLOR0, P4, P2, EK, EH, N0, 
  ST_TET, COLOR0, P2, EC, EK, N0, 
  ST_WDG, COLOR1, EF, EL, EG, P5, P3, P6, 
  ST_TET, COLOR1, P3, P5, P6, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P6, N0, 
  ST_TET, COLOR1, P1, P5, P3, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, P6, EK, EC, P3, N0, 
  ST_TET, COLOR1, EH, EK, P6, N0, 
 // Case #107: Unique case #18
  ST_TET, COLOR0, EL, EG, EF, P7, 
  ST_TET, COLOR0, EC, P2, ED, EK, 
  ST_TET, COLOR0, EE, EI, P4, EH, 
  ST_WDG, COLOR1, EH, EI, EE, P6, P0, P5, 
  ST_WDG, COLOR1, P3, P6, P0, EC, EK, ED, 
  ST_WDG, COLOR1, EL, EG, EF, P3, P6, P5, 
  ST_TET, COLOR1, P6, P5, P0, P3, 
  ST_TET, COLOR1, P3, P1, P5, P0, 
 // Case #108: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EB, EJ, EE, 
  ST_TET, COLOR0, P7, EG, EL, EF, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_TET, COLOR0, P0, P4, P1, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_WDG, COLOR1, EL, EG, EF, P3, P6, P5, 
  ST_TET, COLOR1, P6, P3, P5, N0, 
  ST_PYR, COLOR1, P3, EB, EJ, P5, N0, 
  ST_TET, COLOR1, P2, P3, P6, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, ED, EB, P3, P2, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P6, N0, 
  ST_TET, COLOR1, EJ, EE, P5, N0, 
 // Case #109: (cloned #107)
  ST_TET, COLOR0, EG, EF, EL, P7, 
  ST_TET, COLOR0, EH, P4, EI, EE, 
  ST_TET, COLOR0, EB, EA, P1, EJ, 
  ST_WDG, COLOR1, EJ, EA, EB, P5, P0, P3, 
  ST_WDG, COLOR1, P6, P5, P0, EH, EE, EI, 
  ST_WDG, COLOR1, EG, EF, EL, P6, P5, P3, 
  ST_TET, COLOR1, P5, P3, P0, P6, 
  ST_TET, COLOR1, P6, P2, P3, P0, 
 // Case #110: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P5, P1, P2, EH, ED, 
  ST_WDG, COLOR0, EH, P4, EE, ED, P0, EA, 
  ST_TET, COLOR0, EL, EF, P7, EG, 
  ST_WDG, COLOR1, EL, EG, EF, P3, P6, P5, 
  ST_PYR, COLOR1, ED, P2, P6, EH, N0, 
  ST_TET, COLOR1, P2, P3, P6, N0, 
  ST_TET, COLOR1, P2, P1, P3, N0, 
  ST_PYR, COLOR1, EA, P1, P2, ED, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, P1, P5, P3, N0, 
  ST_PYR, COLOR1, EH, EE, EA, ED, N0, 
  ST_TET, COLOR1, P5, P6, P3, N0, 
  ST_PYR, COLOR1, EH, P6, P5, EE, N0, 
 // Case #111: Unique case #19
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_TET, COLOR0, EF, EL, EG, P7, 
  ST_WDG, COLOR1, EG, EF, EL, P6, P5, P3, 
  ST_WDG, COLOR1, P6, P5, P0, EH, EE, EI, 
  ST_PYR, COLOR1, P2, P0, P1, P3, P6, 
  ST_TET, COLOR1, P5, P1, P0, P6, 
  ST_TET, COLOR1, P5, P3, P1, P6, 
 // Case #112: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EJ, EI, EF, EG, EK, 
  ST_PYR, COLOR0, P1, P3, P2, P0, N0, 
  ST_TET, COLOR0, P2, P7, N0, P3, 
  ST_PYR, COLOR0, P0, P2, EK, EI, N0, 
  ST_PYR, COLOR0, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR0, P7, P3, P1, N0, 
  ST_PYR, COLOR0, P7, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_PYR, COLOR0, EK, P2, P7, EG, N0, 
  ST_PYR, COLOR1, EI, EK, P6, P4, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_PYR, COLOR1, EF, P5, P6, EG, N0, 
  ST_TET, COLOR1, P6, EK, EG, N0, 
 // Case #113: (cloned #23)
  ST_TET, COLOR0, P7, P2, P3, P1, 
  ST_PYR, COLOR0, EA, P1, P2, ED, EK, 
  ST_PYR, COLOR0, EJ, EF, P7, P1, EG, 
  ST_PYR, COLOR0, P2, P7, EG, EK, P1, 
  ST_PYR, COLOR0, EK, EG, EJ, EA, P1, 
  ST_TET, COLOR1, P4, P5, P0, P6, 
  ST_PYR, COLOR1, EK, P6, P0, ED, EA, 
  ST_PYR, COLOR1, EG, EF, P5, P6, EJ, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, P6, 
  ST_PYR, COLOR1, EK, EA, EJ, EG, P6, 
 // Case #114: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EI, EA, EB, EF, EG, EK, 
  ST_TET, COLOR0, P3, P7, P2, N0, 
  ST_PYR, COLOR0, P3, EB, EF, P7, N0, 
  ST_TET, COLOR0, P0, P3, P2, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P3, N0, 
  ST_TET, COLOR0, EI, EA, P0, N0, 
  ST_PYR, COLOR0, P0, P2, EK, EI, N0, 
  ST_PYR, COLOR0, EK, P2, P7, EG, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_PYR, COLOR1, EI, EK, P6, P4, N0, 
  ST_TET, COLOR1, P6, P5, P4, N0, 
  ST_TET, COLOR1, P6, EK, EG, N0, 
  ST_PYR, COLOR1, P6, EG, EF, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #115: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, ED, EG, EK, 
  ST_PYR, COLOR0, P3, P2, ED, EB, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_PYR, COLOR0, P7, P3, EB, EF, N0, 
  ST_TET, COLOR0, EG, P7, EF, N0, 
  ST_PYR, COLOR0, EK, P2, P7, EG, N0, 
  ST_TET, COLOR0, P2, P3, P7, N0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, N0, 
  ST_TET, COLOR1, P0, P6, P4, N0, 
  ST_TET, COLOR1, P6, P5, P4, N0, 
  ST_PYR, COLOR1, P6, EG, EF, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, ED, EK, P6, P0, N0, 
  ST_TET, COLOR1, EG, P6, EK, N0, 
 // Case #116: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EI, ED, EC, EG, EF, EJ, 
  ST_TET, COLOR0, P3, P1, P7, N0, 
  ST_PYR, COLOR0, P3, P7, EG, EC, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_PYR, COLOR0, P0, P3, EC, ED, N0, 
  ST_TET, COLOR0, EI, P0, ED, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_PYR, COLOR0, EJ, EF, P7, P1, N0, 
  ST_TET, COLOR0, P7, EF, EG, N0, 
  ST_TET, COLOR1, P4, P2, P6, N0, 
  ST_PYR, COLOR1, EI, ED, P2, P4, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_TET, COLOR1, P5, EF, EJ, N0, 
  ST_PYR, COLOR1, P5, P6, EG, EF, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_TET, COLOR1, EC, P2, ED, N0, 
 // Case #117: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EA, EF, EJ, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, P7, EG, EC, P3, N0, 
  ST_TET, COLOR0, EF, EG, P7, N0, 
  ST_PYR, COLOR0, EJ, EF, P7, P1, N0, 
  ST_TET, COLOR0, P1, P7, P3, N0, 
  ST_PYR, COLOR1, P4, P0, P2, P6, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_PYR, COLOR1, P5, P6, EG, EF, N0, 
  ST_PYR, COLOR1, EG, P6, P2, EC, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #118: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P2, P6, P5, EB, EF, 
  ST_WDG, COLOR0, EF, P7, EG, EB, P3, EC, 
  ST_TET, COLOR0, EI, P0, ED, EA, 
  ST_WDG, COLOR1, P4, P1, P2, EI, EA, ED, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P6, N0, 
  ST_PYR, COLOR1, EC, EG, P6, P2, N0, 
  ST_TET, COLOR1, P6, P4, P2, N0, 
  ST_PYR, COLOR1, EB, EF, EG, EC, N0, 
  ST_TET, COLOR1, P2, P4, P1, N0, 
  ST_PYR, COLOR1, EB, EC, P2, P1, N0, 
 // Case #119: (cloned #63)
  ST_WDG, COLOR0, P7, EG, EF, P3, EC, EB, 
  ST_HEX, COLOR1, EC, EB, EF, EG, P2, P1, P5, P6, 
  ST_WDG, COLOR1, P0, P2, P1, P4, P6, P5, 
 // Case #120: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EJ, EB, EC, 
  ST_TET, COLOR0, P7, EF, EG, EL, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P2, N0, 
  ST_TET, COLOR0, P2, EC, EK, N0, 
  ST_WDG, COLOR1, P5, P6, P3, EF, EG, EL, 
  ST_TET, COLOR1, P6, P3, P5, N0, 
  ST_PYR, COLOR1, P5, P3, EB, EJ, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, P3, P6, EK, EC, N0, 
  ST_TET, COLOR1, EB, P3, EC, N0, 
 // Case #121: (cloned #107)
  ST_TET, COLOR0, EG, EF, EL, P7, 
  ST_TET, COLOR0, EK, ED, P2, EC, 
  ST_TET, COLOR0, EJ, P1, EA, EB, 
  ST_WDG, COLOR1, P3, P0, P5, EB, EA, EJ, 
  ST_WDG, COLOR1, EK, EC, ED, P6, P3, P0, 
  ST_WDG, COLOR1, P6, P3, P5, EG, EL, EF, 
  ST_TET, COLOR1, P3, P0, P5, P6, 
  ST_TET, COLOR1, P6, P5, P4, P0, 
 // Case #122: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P3, P1, P4, EK, EI, 
  ST_WDG, COLOR0, EI, P0, EA, EK, P2, EC, 
  ST_TET, COLOR0, EF, P7, EL, EG, 
  ST_WDG, COLOR1, P5, P6, P3, EF, EG, EL, 
  ST_PYR, COLOR1, EI, EK, P6, P4, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_TET, COLOR1, P1, P5, P3, N0, 
  ST_PYR, COLOR1, EK, EI, EA, EC, N0, 
  ST_TET, COLOR1, P3, P5, P6, N0, 
  ST_PYR, COLOR1, EK, EC, P3, P6, N0, 
 // Case #123: (cloned #111)
  ST_TET, COLOR0, EC, ED, EK, P2, 
  ST_TET, COLOR0, EL, EG, EF, P7, 
  ST_WDG, COLOR1, P6, P3, P5, EG, EL, EF, 
  ST_WDG, COLOR1, EK, EC, ED, P6, P3, P0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, P6, 
  ST_TET, COLOR1, P3, P0, P1, P6, 
  ST_TET, COLOR1, P3, P1, P5, P6, 
 // Case #124: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P5, P4, P2, EB, ED, 
  ST_WDG, COLOR0, ED, P0, EI, EB, P1, EJ, 
  ST_TET, COLOR0, EG, P7, EF, EL, 
  ST_WDG, COLOR1, P6, P3, P5, EG, EL, EF, 
  ST_PYR, COLOR1, ED, EB, P3, P2, N0, 
  ST_TET, COLOR1, P2, P3, P6, N0, 
  ST_TET, COLOR1, P2, P6, P4, N0, 
  ST_PYR, COLOR1, EI, ED, P2, P4, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_PYR, COLOR1, EB, ED, EI, EJ, N0, 
  ST_TET, COLOR1, P5, P6, P3, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P3, N0, 
 // Case #125: (cloned #111)
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_TET, COLOR0, EF, EL, EG, P7, 
  ST_WDG, COLOR1, P3, P5, P6, EL, EF, EG, 
  ST_WDG, COLOR1, EB, EJ, EA, P3, P5, P0, 
  ST_PYR, COLOR1, P2, P6, P4, P0, P3, 
  ST_TET, COLOR1, P5, P0, P4, P3, 
  ST_TET, COLOR1, P5, P4, P6, P3, 
 // Case #126: Unique case #20
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EL, EG, EF, P7, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_WDG, COLOR1, EL, EG, EF, P3, P6, P5, 
  ST_TET, COLOR1, P5, P4, P6, P3, 
  ST_TET, COLOR1, P3, P2, P1, P4, 
  ST_TET, COLOR1, P2, P3, P6, P4, 
  ST_TET, COLOR1, P3, P1, P5, P4, 
 // Case #127: Unique case #21
  ST_PNT, 0, COLOR1, 7, P1, P0, P2, P3, P5, P4, P6, 
  ST_TET, COLOR0, EF, EL, EG, P7, 
  ST_WDG, COLOR1, P5, P6, P3, EF, EG, EL, 
  ST_TET, COLOR1, P5, P6, P3, N0, 
  ST_PYR, COLOR1, P4, P0, P2, P6, N0, 
  ST_TET, COLOR1, P6, P2, P3, N0, 
  ST_PYR, COLOR1, P1, P3, P2, P0, N0, 
  ST_TET, COLOR1, P1, P5, P3, N0, 
  ST_PYR, COLOR1, P1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
 // Case #128: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P6, P4, P5, P3, P2, P0, P1, 
  ST_WDG, COLOR0, EG, EF, EL, P6, P5, P3, 
  ST_TET, COLOR0, P6, P3, P5, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_PYR, COLOR0, P2, P6, P4, P0, N0, 
  ST_PYR, COLOR0, P3, P2, P0, P1, N0, 
  ST_TET, COLOR0, P5, P3, P1, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_TET, COLOR1, P7, EF, EG, EL, 
 // Case #129: (cloned #24)
  ST_WDG, COLOR0, P5, P6, P3, EF, EG, EL, 
  ST_WDG, COLOR0, EI, ED, EA, P4, P2, P1, 
  ST_TET, COLOR0, P6, P3, P5, P2, 
  ST_TET, COLOR0, P1, P3, P2, P5, 
  ST_TET, COLOR0, P4, P5, P1, P2, 
  ST_TET, COLOR0, P6, P4, P2, P5, 
  ST_TET, COLOR1, P0, EI, EA, ED, 
  ST_TET, COLOR1, P7, EF, EG, EL, 
 // Case #130: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EA, EG, 
  ST_PYR, COLOR0, P0, P2, P6, P4, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_TET, COLOR0, P3, P2, P0, N0, 
  ST_TET, COLOR0, P6, P2, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EL, EG, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P3, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_PYR, COLOR1, P1, P7, EL, EB, N0, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, N0, 
  ST_TET, COLOR1, EF, EG, P7, N0, 
  ST_TET, COLOR1, P7, EG, EL, N0, 
  ST_TET, COLOR1, EJ, N0, P1, EA, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #131: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EI, ED, EG, EG, 
  ST_PYR, COLOR0, P6, P3, EL, EG, N0, 
  ST_TET, COLOR0, EL, P3, EB, N0, 
  ST_PYR, COLOR0, P2, ED, EB, P3, N0, 
  ST_TET, COLOR0, P6, P2, P3, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, P4, P2, P6, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P2, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_PYR, COLOR1, P7, EL, EB, P1, N0, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, N0, 
  ST_TET, COLOR1, P7, EG, EL, N0, 
  ST_TET, COLOR1, EF, EG, P7, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #132: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, ED, EF, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P1, P5, P3, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_TET, COLOR0, P6, P4, P0, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_PYR, COLOR0, P3, P5, EF, EL, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_PYR, COLOR0, P0, P3, EC, ED, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P6, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_PYR, COLOR1, P2, P7, EG, EK, N0, 
  ST_PYR, COLOR1, EC, EL, P7, P2, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
  ST_TET, COLOR1, P7, EF, EG, N0, 
  ST_TET, COLOR1, EC, N0, P2, ED, 
  ST_TET, COLOR1, EK, ED, P2, N0, 
 // Case #133: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EA, EI, EF, EF, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, EG, P6, EK, N0, 
  ST_PYR, COLOR0, P4, EI, EK, P6, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_TET, COLOR0, P1, P5, P3, N0, 
  ST_PYR, COLOR0, P3, P5, EF, EL, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR0, P1, P3, EC, EA, N0, 
  ST_PYR, COLOR1, P7, EG, EK, P2, N0, 
  ST_PYR, COLOR1, EC, EL, P7, P2, N0, 
  ST_TET, COLOR1, P7, EF, EG, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, P2, P0, EA, EC, N0, 
  ST_TET, COLOR1, EA, P0, EI, N0, 
 // Case #134: (cloned #22)
  ST_TET, COLOR0, P3, EB, EL, EC, 
  ST_TET, COLOR0, P6, P4, P0, P5, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, ED, 
  ST_PYR, COLOR0, EF, P5, P6, EG, EK, 
  ST_PYR, COLOR0, P0, ED, EK, P6, P5, 
  ST_PYR, COLOR0, ED, EJ, EF, EK, P5, 
  ST_WDG, COLOR1, P1, P7, P2, EB, EL, EC, 
  ST_PYR, COLOR1, P1, P2, ED, EA, EJ, 
  ST_PYR, COLOR1, EK, P2, P7, EG, EF, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, P2, 
  ST_PYR, COLOR1, EJ, ED, EK, EF, P2, 
 // Case #135: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EJ, EF, EG, 
  ST_TET, COLOR0, P3, EC, EB, EL, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P2, P7, 
  ST_TET, COLOR1, P2, P1, P7, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_PYR, COLOR1, P7, EG, EK, P2, N0, 
  ST_TET, COLOR1, EF, EG, P7, N0, 
 // Case #136: (cloned #3)
  ST_HEX, COLOR0, EG, P6, P2, EC, EF, P5, P1, EB, 
  ST_WDG, COLOR0, P1, P0, P2, P5, P4, P6, 
  ST_WDG, COLOR1, P3, EB, EC, P7, EF, EG, 
 // Case #137: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EG, EF, EI, EI, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_TET, COLOR0, P6, P4, P2, N0, 
  ST_PYR, COLOR0, P2, P4, EI, ED, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P6, EG, EF, P5, N0, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P3, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P3, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
  ST_PYR, COLOR1, EB, EF, P7, P3, N0, 
  ST_PYR, COLOR1, P3, P7, EG, EC, N0, 
  ST_TET, COLOR1, EG, P7, EF, N0, 
 // Case #138: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EF, EJ, EA, 
  ST_PYR, COLOR0, P6, P4, P0, P2, N0, 
  ST_TET, COLOR0, P0, P5, N0, P4, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_PYR, COLOR0, EG, P6, P2, EC, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, EA, P0, P5, EJ, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_TET, COLOR1, EF, EG, P7, N0, 
  ST_TET, COLOR1, P7, P3, P1, N0, 
  ST_PYR, COLOR1, EF, P7, P1, EJ, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
 // Case #139: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EJ, EF, EG, EC, ED, EI, 
  ST_TET, COLOR0, P6, P4, P2, N0, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P5, P6, EG, EF, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_PYR, COLOR0, EI, ED, P2, P4, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_TET, COLOR1, P1, P7, P3, N0, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P0, P3, EC, ED, N0, 
  ST_PYR, COLOR1, EC, P3, P7, EG, N0, 
  ST_TET, COLOR1, EG, P7, EF, N0, 
 // Case #140: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EG, EK, ED, 
  ST_PYR, COLOR0, P5, P1, P0, P4, N0, 
  ST_TET, COLOR0, P0, N0, P6, P4, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_PYR, COLOR0, EF, EB, P1, P5, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P6, EG, EF, P5, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_PYR, COLOR0, ED, EK, P6, P0, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_TET, COLOR1, EG, P7, EF, N0, 
  ST_TET, COLOR1, P7, P2, P3, N0, 
  ST_PYR, COLOR1, EG, EK, P2, P7, N0, 
  ST_TET, COLOR1, P2, EK, ED, N0, 
 // Case #141: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EK, EG, EF, EB, EA, EI, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P6, EG, EF, P5, N0, 
  ST_TET, COLOR0, EK, EG, P6, N0, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_PYR, COLOR0, EI, P4, P1, EA, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR1, P2, P3, P7, N0, 
  ST_PYR, COLOR1, EK, P2, P7, EG, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_TET, COLOR1, P0, P3, P2, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P3, N0, 
  ST_PYR, COLOR1, EB, EF, P7, P3, N0, 
  ST_TET, COLOR1, EF, EG, P7, N0, 
 // Case #142: (cloned #23)
  ST_TET, COLOR0, P6, P4, P0, P5, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, ED, 
  ST_PYR, COLOR0, EF, P5, P6, EG, EK, 
  ST_PYR, COLOR0, P0, ED, EK, P6, P5, 
  ST_PYR, COLOR0, ED, EJ, EF, EK, P5, 
  ST_TET, COLOR1, P3, P1, P7, P2, 
  ST_PYR, COLOR1, ED, EA, P1, P2, EJ, 
  ST_PYR, COLOR1, EK, P2, P7, EG, EF, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, P2, 
  ST_PYR, COLOR1, ED, EK, EF, EJ, P2, 
 // Case #143: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EK, EI, EJ, EG, EF, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, P6, P4, EI, EK, N0, 
  ST_TET, COLOR0, EG, P6, EK, N0, 
  ST_PYR, COLOR0, EF, P5, P6, EG, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR1, P3, P2, P0, P1, N0, 
  ST_TET, COLOR1, P1, P7, P3, N0, 
  ST_TET, COLOR1, P7, P2, P3, N0, 
  ST_PYR, COLOR1, P7, EG, EK, P2, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, N0, 
  ST_TET, COLOR1, EG, P7, EF, N0, 
 // Case #144: (cloned #6)
  ST_PNT, 0, NOCOLOR, 2, EI, EL, 
  ST_PYR, COLOR0, P0, P1, P3, P2, N0, 
  ST_TET, COLOR0, P1, P5, P3, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_TET, COLOR0, P6, P0, P2, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_PYR, COLOR0, P3, EL, EG, P6, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P3, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR0, P0, P6, EH, EI, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P7, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EF, N0, 
  ST_TET, COLOR1, EF, P7, EL, N0, 
  ST_TET, COLOR1, P7, EG, EL, N0, 
  ST_TET, COLOR1, EE, P4, N0, EI, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #145: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EA, ED, EL, EL, 
  ST_PYR, COLOR0, P3, EL, EG, P6, N0, 
  ST_TET, COLOR0, EG, EH, P6, N0, 
  ST_PYR, COLOR0, P2, P6, EH, ED, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR0, P1, P5, P3, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P3, N0, 
  ST_TET, COLOR0, P1, P3, P2, N0, 
  ST_PYR, COLOR0, P1, P2, ED, EA, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_PYR, COLOR1, P7, P4, EH, EG, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EF, N0, 
  ST_TET, COLOR1, P7, EG, EL, N0, 
  ST_TET, COLOR1, EF, P7, EL, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, P4, EE, EA, P0, N0, 
  ST_TET, COLOR1, EA, ED, P0, N0, 
 // Case #146: (cloned #22)
  ST_TET, COLOR0, P5, EF, EJ, EE, 
  ST_TET, COLOR0, P6, P0, P2, P3, 
  ST_PYR, COLOR0, EB, P3, P0, EA, EI, 
  ST_PYR, COLOR0, EL, EG, P6, P3, EH, 
  ST_PYR, COLOR0, P0, P6, EH, EI, P3, 
  ST_PYR, COLOR0, EI, EH, EL, EB, P3, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P7, P4, 
  ST_PYR, COLOR1, P1, EA, EI, P4, EB, 
  ST_PYR, COLOR1, EH, EG, P7, P4, EL, 
  ST_PYR, COLOR1, EB, P1, P7, EL, P4, 
  ST_PYR, COLOR1, EB, EL, EH, EI, P4, 
 // Case #147: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EB, EL, EG, 
  ST_TET, COLOR0, P5, EJ, EE, EF, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_PYR, COLOR0, P2, ED, EB, P3, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_TET, COLOR0, P2, P3, P6, N0, 
  ST_PYR, COLOR0, P3, EL, EG, P6, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_WDG, COLOR1, P1, P4, P7, EJ, EE, EF, 
  ST_TET, COLOR1, P4, P7, P1, N0, 
  ST_PYR, COLOR1, P1, P7, EL, EB, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, P7, P4, EH, EG, N0, 
  ST_TET, COLOR1, EL, P7, EG, N0, 
 // Case #148: (cloned #22)
  ST_TET, COLOR0, P6, EG, EH, EK, 
  ST_TET, COLOR0, P3, P0, P1, P5, 
  ST_PYR, COLOR0, EE, P5, P0, EI, ED, 
  ST_PYR, COLOR0, EF, EL, P3, P5, EC, 
  ST_PYR, COLOR0, P0, P3, EC, ED, P5, 
  ST_PYR, COLOR0, ED, EC, EF, EE, P5, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P7, P2, 
  ST_PYR, COLOR1, P4, EI, ED, P2, EE, 
  ST_PYR, COLOR1, EC, EL, P7, P2, EF, 
  ST_PYR, COLOR1, EE, P4, P7, EF, P2, 
  ST_PYR, COLOR1, EE, EF, EC, ED, P2, 
 // Case #149: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EE, EF, EL, 
  ST_TET, COLOR0, P6, EH, EK, EG, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR0, P1, P5, P3, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P3, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_WDG, COLOR1, P4, P2, P7, EH, EK, EG, 
  ST_TET, COLOR1, P2, P7, P4, N0, 
  ST_PYR, COLOR1, P4, P7, EF, EE, N0, 
  ST_TET, COLOR1, P0, P2, P4, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_PYR, COLOR1, P7, P2, EC, EL, N0, 
  ST_TET, COLOR1, EF, P7, EL, N0, 
 // Case #150: (cloned #105)
  ST_TET, COLOR0, EH, EG, EK, P6, 
  ST_TET, COLOR0, EI, ED, EA, P0, 
  ST_TET, COLOR0, EE, EJ, EF, P5, 
  ST_TET, COLOR0, EB, EC, EL, P3, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P2, P7, 
  ST_TET, COLOR1, P1, P7, P2, P4, 
  ST_WDG, COLOR1, P4, P7, P1, EE, EF, EJ, 
  ST_WDG, COLOR1, P2, P4, P1, ED, EI, EA, 
  ST_WDG, COLOR1, P7, P4, P2, EG, EH, EK, 
 // Case #151: (cloned #107)
  ST_TET, COLOR0, EK, EH, EG, P6, 
  ST_TET, COLOR0, EC, EB, P3, EL, 
  ST_TET, COLOR0, EE, P5, EJ, EF, 
  ST_WDG, COLOR1, P7, P1, P4, EF, EJ, EE, 
  ST_WDG, COLOR1, EC, EL, EB, P2, P7, P1, 
  ST_WDG, COLOR1, P2, P7, P4, EK, EG, EH, 
  ST_TET, COLOR1, P7, P1, P4, P2, 
  ST_TET, COLOR1, P2, P4, P0, P1, 
 // Case #152: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EC, EB, EI, EI, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_TET, COLOR0, P2, P6, P0, N0, 
  ST_PYR, COLOR0, P6, EH, EI, P0, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P2, P1, EB, EC, N0, 
  ST_PYR, COLOR0, P2, EC, EG, P6, N0, 
  ST_PYR, COLOR1, P4, P7, EF, EE, N0, 
  ST_PYR, COLOR1, EG, P7, P4, EH, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_PYR, COLOR1, P7, EG, EC, P3, N0, 
  ST_TET, COLOR1, EC, EB, P3, N0, 
 // Case #153: (cloned #60)
  ST_WDG, COLOR0, P6, EH, EG, P2, ED, EC, 
  ST_WDG, COLOR0, P5, EF, EE, P1, EB, EA, 
  ST_HEX, COLOR1, P0, P3, P7, P4, EA, EB, EF, EE, 
  ST_HEX, COLOR1, ED, EC, EG, EH, P0, P3, P7, P4, 
 // Case #154: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EA, EI, EH, 
  ST_TET, COLOR0, P5, EF, EJ, EE, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_TET, COLOR0, P2, P6, P0, N0, 
  ST_PYR, COLOR0, P0, P6, EH, EI, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P7, P4, 
  ST_TET, COLOR1, P7, P1, P4, N0, 
  ST_PYR, COLOR1, P1, EA, EI, P4, N0, 
  ST_TET, COLOR1, P3, P1, P7, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P7, N0, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
 // Case #155: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P4, P0, P3, EG, EC, 
  ST_WDG, COLOR0, EG, P6, EH, EC, P2, ED, 
  ST_TET, COLOR0, EJ, EE, P5, EF, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P7, P4, 
  ST_PYR, COLOR1, EC, P3, P7, EG, N0, 
  ST_TET, COLOR1, P3, P1, P7, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_PYR, COLOR1, ED, P0, P3, EC, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EG, EH, ED, EC, N0, 
  ST_TET, COLOR1, P4, P7, P1, N0, 
  ST_PYR, COLOR1, EG, P7, P4, EH, N0, 
 // Case #156: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, ED, EI, EE, 
  ST_TET, COLOR0, P6, EK, EG, EH, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_TET, COLOR0, P1, P0, P5, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_WDG, COLOR1, P2, P7, P4, EK, EG, EH, 
  ST_TET, COLOR1, P7, P4, P2, N0, 
  ST_PYR, COLOR1, P2, P4, EI, ED, N0, 
  ST_TET, COLOR1, P3, P7, P2, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_PYR, COLOR1, P4, P7, EF, EE, N0, 
  ST_TET, COLOR1, EI, P4, EE, N0, 
 // Case #157: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P4, P0, P3, EF, EB, 
  ST_WDG, COLOR0, EB, P1, EA, EF, P5, EE, 
  ST_TET, COLOR0, EK, P6, EH, EG, 
  ST_WDG, COLOR1, P2, P7, P4, EK, EG, EH, 
  ST_PYR, COLOR1, EB, EF, P7, P3, N0, 
  ST_TET, COLOR1, P3, P7, P2, N0, 
  ST_TET, COLOR1, P3, P2, P0, N0, 
  ST_PYR, COLOR1, EA, EB, P3, P0, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, P0, P2, P4, N0, 
  ST_PYR, COLOR1, EF, EB, EA, EE, N0, 
  ST_TET, COLOR1, P4, P2, P7, N0, 
  ST_PYR, COLOR1, EF, EE, P4, P7, N0, 
 // Case #158: (cloned #107)
  ST_TET, COLOR0, EJ, EF, EE, P5, 
  ST_TET, COLOR0, EA, ED, P0, EI, 
  ST_TET, COLOR0, EG, P6, EK, EH, 
  ST_WDG, COLOR1, P4, P2, P7, EH, EK, EG, 
  ST_WDG, COLOR1, EA, EI, ED, P1, P4, P2, 
  ST_WDG, COLOR1, P1, P4, P7, EJ, EE, EF, 
  ST_TET, COLOR1, P4, P2, P7, P1, 
  ST_TET, COLOR1, P1, P7, P3, P2, 
 // Case #159: (cloned #111)
  ST_TET, COLOR0, EG, EK, EH, P6, 
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_WDG, COLOR1, P4, P7, P1, EE, EF, EJ, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P7, P2, 
  ST_PYR, COLOR1, P0, P1, P3, P2, P4, 
  ST_TET, COLOR1, P7, P2, P3, P4, 
  ST_TET, COLOR1, P7, P3, P1, P4, 
 // Case #160: (cloned #3)
  ST_HEX, COLOR0, EL, P3, P1, EJ, EG, P6, P4, EE, 
  ST_WDG, COLOR0, P3, P2, P6, P1, P0, P4, 
  ST_WDG, COLOR1, P7, EL, EG, P5, EJ, EE, 
 // Case #161: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EG, EL, ED, ED, 
  ST_PYR, COLOR0, P2, ED, EA, P1, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, P3, P1, EJ, EL, N0, 
  ST_TET, COLOR0, P2, P1, P3, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR0, P6, P4, P2, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P2, N0, 
  ST_TET, COLOR0, P6, P2, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EL, EG, N0, 
  ST_PYR, COLOR0, P6, EG, EE, P4, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EE, P5, P0, EI, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
  ST_PYR, COLOR1, EJ, P5, P7, EL, N0, 
  ST_PYR, COLOR1, P5, EE, EG, P7, N0, 
  ST_TET, COLOR1, EG, EL, P7, N0, 
 // Case #162: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EL, EB, EA, 
  ST_PYR, COLOR0, P6, P4, P0, P2, N0, 
  ST_TET, COLOR0, P0, N0, P3, P2, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_PYR, COLOR0, EG, EE, P4, P6, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_PYR, COLOR0, P3, EL, EG, P6, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_PYR, COLOR0, EA, EB, P3, P0, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_TET, COLOR1, EL, P7, EG, N0, 
  ST_TET, COLOR1, P7, P1, P5, N0, 
  ST_PYR, COLOR1, EL, EB, P1, P7, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
 // Case #163: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EB, EL, EG, EE, EI, ED, 
  ST_TET, COLOR0, P6, P4, P2, N0, 
  ST_PYR, COLOR0, P6, EG, EE, P4, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_PYR, COLOR0, P3, EL, EG, P6, N0, 
  ST_TET, COLOR0, EB, EL, P3, N0, 
  ST_PYR, COLOR0, P3, P2, ED, EB, N0, 
  ST_PYR, COLOR0, ED, P2, P4, EI, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR1, P1, P5, P7, N0, 
  ST_PYR, COLOR1, EB, P1, P7, EL, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P7, P5, N0, 
  ST_TET, COLOR1, EG, EL, P7, N0, 
 // Case #164: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EE, EJ, ED, ED, 
  ST_PYR, COLOR0, P0, P3, EC, ED, N0, 
  ST_TET, COLOR0, EC, P3, EL, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P3, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_TET, COLOR0, P4, P0, P6, N0, 
  ST_PYR, COLOR0, P6, P0, ED, EK, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR0, P4, P6, EG, EE, N0, 
  ST_PYR, COLOR1, P2, EC, EL, P7, N0, 
  ST_PYR, COLOR1, EG, EK, P2, P7, N0, 
  ST_TET, COLOR1, P2, ED, EC, N0, 
  ST_TET, COLOR1, EK, ED, P2, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_PYR, COLOR1, P7, P5, EE, EG, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #165: (cloned #60)
  ST_WDG, COLOR0, P4, EI, EE, P6, EK, EG, 
  ST_WDG, COLOR0, P1, EJ, EA, P3, EL, EC, 
  ST_HEX, COLOR1, EA, EJ, EL, EC, P0, P5, P7, P2, 
  ST_HEX, COLOR1, P0, P5, P7, P2, EI, EE, EG, EK, 
 // Case #166: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EA, ED, EK, 
  ST_TET, COLOR0, P3, EB, EL, EC, 
  ST_PYR, COLOR0, P6, EG, EE, P4, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_TET, COLOR0, P4, P0, P6, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P6, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_WDG, COLOR1, P1, P7, P2, EB, EL, EC, 
  ST_TET, COLOR1, P7, P2, P1, N0, 
  ST_PYR, COLOR1, P1, P2, ED, EA, N0, 
  ST_TET, COLOR1, P5, P7, P1, N0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, P2, P7, EG, EK, N0, 
  ST_TET, COLOR1, ED, P2, EK, N0, 
 // Case #167: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P2, P0, P5, EG, EE, 
  ST_WDG, COLOR0, EE, P4, EI, EG, P6, EK, 
  ST_TET, COLOR0, EB, P3, EC, EL, 
  ST_WDG, COLOR1, P1, P7, P2, EB, EL, EC, 
  ST_PYR, COLOR1, EE, EG, P7, P5, N0, 
  ST_TET, COLOR1, P5, P7, P1, N0, 
  ST_TET, COLOR1, P5, P1, P0, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P2, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_PYR, COLOR1, EG, EE, EI, EK, N0, 
  ST_TET, COLOR1, P2, P1, P7, N0, 
  ST_PYR, COLOR1, EG, EK, P2, P7, N0, 
 // Case #168: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EB, EJ, EE, 
  ST_PYR, COLOR0, P2, P6, P4, P0, N0, 
  ST_TET, COLOR0, P4, N0, P1, P0, 
  ST_PYR, COLOR0, P6, EG, EE, P4, N0, 
  ST_PYR, COLOR0, EC, EG, P6, P2, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P2, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, N0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_PYR, COLOR1, EC, P3, P7, EG, N0, 
  ST_TET, COLOR1, EB, P3, EC, N0, 
  ST_TET, COLOR1, P3, P5, P7, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P3, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
 // Case #169: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EC, ED, EI, 
  ST_TET, COLOR0, P1, EJ, EB, EA, 
  ST_PYR, COLOR0, P4, P6, EG, EE, N0, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_TET, COLOR0, P6, P4, P2, N0, 
  ST_PYR, COLOR0, P2, P4, EI, ED, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_WDG, COLOR1, EB, EJ, EA, P3, P5, P0, 
  ST_TET, COLOR1, P5, P3, P0, N0, 
  ST_PYR, COLOR1, P3, EC, ED, P0, N0, 
  ST_TET, COLOR1, P7, P3, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P7, P5, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
 // Case #170: (cloned #15)
  ST_HEX, COLOR0, EA, EE, EG, EC, P0, P4, P6, P2, 
  ST_HEX, COLOR1, P1, P5, P7, P3, EA, EE, EG, EC, 
 // Case #171: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EC, EI, ED, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_TET, COLOR0, P2, ED, EC, N0, 
  ST_PYR, COLOR0, P4, P6, EG, EE, N0, 
  ST_TET, COLOR0, EI, P4, EE, N0, 
  ST_PYR, COLOR0, ED, P2, P4, EI, N0, 
  ST_TET, COLOR0, P2, P6, P4, N0, 
  ST_PYR, COLOR1, P1, P5, P7, P3, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P7, P5, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P3, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #172: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EB, EJ, EE, EG, EK, ED, 
  ST_TET, COLOR0, P4, P0, P6, N0, 
  ST_PYR, COLOR0, P4, P6, EG, EE, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, EB, P1, EJ, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_PYR, COLOR0, ED, EK, P6, P0, N0, 
  ST_TET, COLOR0, P6, EK, EG, N0, 
  ST_TET, COLOR1, P3, P5, P7, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P3, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_TET, COLOR1, P2, P3, P7, N0, 
  ST_TET, COLOR1, P2, EK, ED, N0, 
  ST_PYR, COLOR1, P2, P7, EG, EK, N0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #173: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P0, P2, P7, EE, EG, 
  ST_WDG, COLOR0, EE, P4, EI, EG, P6, EK, 
  ST_TET, COLOR0, EB, EA, P1, EJ, 
  ST_WDG, COLOR1, EB, EJ, EA, P3, P5, P0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_TET, COLOR1, P7, P3, P5, N0, 
  ST_TET, COLOR1, P7, P2, P3, N0, 
  ST_PYR, COLOR1, EK, P2, P7, EG, N0, 
  ST_PYR, COLOR1, EI, P0, P2, EK, N0, 
  ST_TET, COLOR1, P2, P0, P3, N0, 
  ST_PYR, COLOR1, EE, EI, EK, EG, N0, 
  ST_TET, COLOR1, P0, P5, P3, N0, 
  ST_PYR, COLOR1, EE, P5, P0, EI, N0, 
 // Case #174: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EA, EK, ED, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, P6, EG, EE, P4, N0, 
  ST_TET, COLOR0, EK, EG, P6, N0, 
  ST_PYR, COLOR0, ED, EK, P6, P0, N0, 
  ST_TET, COLOR0, P0, P6, P4, N0, 
  ST_PYR, COLOR1, P3, P1, P5, P7, N0, 
  ST_TET, COLOR1, P1, P3, P2, N0, 
  ST_TET, COLOR1, P2, P3, P7, N0, 
  ST_PYR, COLOR1, P2, P7, EG, EK, N0, 
  ST_PYR, COLOR1, EG, P7, P5, EE, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, EA, P1, P2, ED, N0, 
  ST_TET, COLOR1, EK, ED, P2, N0, 
 // Case #175: (cloned #63)
  ST_WDG, COLOR0, P4, EI, EE, P6, EK, EG, 
  ST_HEX, COLOR1, P0, P5, P7, P2, EI, EE, EG, EK, 
  ST_WDG, COLOR1, P3, P2, P7, P1, P0, P5, 
 // Case #176: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EG, EH, EI, 
  ST_PYR, COLOR0, P3, P2, P0, P1, N0, 
  ST_TET, COLOR0, P0, P6, N0, P2, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_PYR, COLOR0, EL, P3, P1, EJ, N0, 
  ST_TET, COLOR0, P6, P2, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EL, EG, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_PYR, COLOR0, EI, P0, P6, EH, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_TET, COLOR1, EG, EL, P7, N0, 
  ST_TET, COLOR1, P7, P5, P4, N0, 
  ST_PYR, COLOR1, EG, P7, P4, EH, N0, 
  ST_TET, COLOR1, P4, EI, EH, N0, 
 // Case #177: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EH, EG, EL, EJ, EA, ED, 
  ST_TET, COLOR0, P3, P2, P1, N0, 
  ST_PYR, COLOR0, P3, P1, EJ, EL, N0, 
  ST_TET, COLOR0, P6, P2, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EL, EG, N0, 
  ST_TET, COLOR0, EH, P6, EG, N0, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_PYR, COLOR0, ED, EA, P1, P2, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_PYR, COLOR1, EH, EG, P7, P4, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EJ, P5, P7, EL, N0, 
  ST_TET, COLOR1, EL, P7, EG, N0, 
 // Case #178: (cloned #23)
  ST_TET, COLOR0, P6, P0, P2, P3, 
  ST_PYR, COLOR0, EB, P3, P0, EA, EI, 
  ST_PYR, COLOR0, EL, EG, P6, P3, EH, 
  ST_PYR, COLOR0, P0, P6, EH, EI, P3, 
  ST_PYR, COLOR0, EI, EH, EL, EB, P3, 
  ST_TET, COLOR1, P5, P7, P1, P4, 
  ST_PYR, COLOR1, EI, P4, P1, EA, EB, 
  ST_PYR, COLOR1, EH, EG, P7, P4, EL, 
  ST_PYR, COLOR1, P1, P7, EL, EB, P4, 
  ST_PYR, COLOR1, EI, EB, EL, EH, P4, 
 // Case #179: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EH, ED, EB, EG, EL, 
  ST_PYR, COLOR0, P2, ED, EB, P3, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_PYR, COLOR0, P6, EH, ED, P2, N0, 
  ST_TET, COLOR0, EG, EH, P6, N0, 
  ST_PYR, COLOR0, EL, EG, P6, P3, N0, 
  ST_TET, COLOR0, P3, P6, P2, N0, 
  ST_PYR, COLOR1, P5, P1, P0, P4, N0, 
  ST_TET, COLOR1, P1, P5, P7, N0, 
  ST_TET, COLOR1, P7, P5, P4, N0, 
  ST_PYR, COLOR1, P7, P4, EH, EG, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, EB, P1, P7, EL, N0, 
  ST_TET, COLOR1, EG, EL, P7, N0, 
 // Case #180: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EI, ED, EC, 
  ST_TET, COLOR0, P6, EG, EH, EK, 
  ST_PYR, COLOR0, P3, P1, EJ, EL, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR0, P0, P3, EC, ED, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P7, P2, 
  ST_TET, COLOR1, P7, P4, P2, N0, 
  ST_PYR, COLOR1, P4, EI, ED, P2, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, P2, EC, EL, P7, N0, 
  ST_TET, COLOR1, ED, EC, P2, N0, 
 // Case #181: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P2, P0, P5, EL, EJ, 
  ST_WDG, COLOR0, EL, P3, EC, EJ, P1, EA, 
  ST_TET, COLOR0, EH, EK, P6, EG, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P7, P2, 
  ST_PYR, COLOR1, EJ, P5, P7, EL, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_TET, COLOR1, P5, P0, P4, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_TET, COLOR1, P0, P2, P4, N0, 
  ST_PYR, COLOR1, EL, EC, EA, EJ, N0, 
  ST_TET, COLOR1, P2, P7, P4, N0, 
  ST_PYR, COLOR1, EL, P7, P2, EC, N0, 
 // Case #182: (cloned #107)
  ST_TET, COLOR0, EB, EC, EL, P3, 
  ST_TET, COLOR0, EA, P0, EI, ED, 
  ST_TET, COLOR0, EG, EH, P6, EK, 
  ST_WDG, COLOR1, EK, EH, EG, P2, P4, P7, 
  ST_WDG, COLOR1, P1, P2, P4, EA, ED, EI, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P2, P7, 
  ST_TET, COLOR1, P2, P7, P4, P1, 
  ST_TET, COLOR1, P1, P5, P7, P4, 
 // Case #183: (cloned #111)
  ST_TET, COLOR0, EG, EK, EH, P6, 
  ST_TET, COLOR0, EL, EB, EC, P3, 
  ST_WDG, COLOR1, EC, EL, EB, P2, P7, P1, 
  ST_WDG, COLOR1, P2, P7, P4, EK, EG, EH, 
  ST_PYR, COLOR1, P0, P4, P5, P1, P2, 
  ST_TET, COLOR1, P7, P5, P4, P2, 
  ST_TET, COLOR1, P7, P1, P5, P2, 
 // Case #184: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EJ, EB, EC, EG, EH, EI, 
  ST_TET, COLOR0, P2, P6, P0, N0, 
  ST_PYR, COLOR0, P2, EC, EG, P6, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P2, N0, 
  ST_TET, COLOR0, EJ, EB, P1, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_PYR, COLOR0, EI, P0, P6, EH, N0, 
  ST_TET, COLOR0, P6, EG, EH, N0, 
  ST_TET, COLOR1, P5, P7, P3, N0, 
  ST_PYR, COLOR1, EJ, P5, P3, EB, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_TET, COLOR1, P4, EI, EH, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P7, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_TET, COLOR1, EC, EB, P3, N0, 
 // Case #185: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P0, P4, P7, EC, EG, 
  ST_WDG, COLOR0, EG, P6, EH, EC, P2, ED, 
  ST_TET, COLOR0, EJ, P1, EA, EB, 
  ST_WDG, COLOR1, P5, P3, P0, EJ, EB, EA, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_TET, COLOR1, P7, P3, P5, N0, 
  ST_TET, COLOR1, P7, P5, P4, N0, 
  ST_PYR, COLOR1, EH, EG, P7, P4, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_PYR, COLOR1, EC, EG, EH, ED, N0, 
  ST_TET, COLOR1, P0, P5, P3, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P3, N0, 
 // Case #186: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EA, EH, EI, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, P6, P2, EC, EG, N0, 
  ST_TET, COLOR0, EH, P6, EG, N0, 
  ST_PYR, COLOR0, EI, P0, P6, EH, N0, 
  ST_TET, COLOR0, P0, P2, P6, N0, 
  ST_PYR, COLOR1, P5, P7, P3, P1, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P7, N0, 
  ST_PYR, COLOR1, EG, EC, P3, P7, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #187: (cloned #63)
  ST_WDG, COLOR0, P6, EH, EG, P2, ED, EC, 
  ST_HEX, COLOR1, ED, EC, EG, EH, P0, P3, P7, P4, 
  ST_WDG, COLOR1, P1, P0, P3, P5, P4, P7, 
 // Case #188: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P4, P5, P3, ED, EB, 
  ST_WDG, COLOR0, ED, P0, EI, EB, P1, EJ, 
  ST_TET, COLOR0, EG, EH, P6, EK, 
  ST_WDG, COLOR1, EG, EK, EH, P7, P2, P4, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_TET, COLOR1, P3, P7, P2, N0, 
  ST_TET, COLOR1, P3, P5, P7, N0, 
  ST_PYR, COLOR1, EJ, P5, P3, EB, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, ED, EI, EJ, EB, N0, 
  ST_TET, COLOR1, P4, P2, P7, N0, 
  ST_PYR, COLOR1, ED, P2, P4, EI, N0, 
 // Case #189: (cloned #126)
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_TET, COLOR0, EH, EG, EK, P6, 
  ST_WDG, COLOR1, P0, P5, P3, EA, EJ, EB, 
  ST_WDG, COLOR1, P4, P2, P7, EH, EK, EG, 
  ST_TET, COLOR1, P7, P2, P3, P4, 
  ST_TET, COLOR1, P4, P5, P0, P3, 
  ST_TET, COLOR1, P0, P2, P4, P3, 
  ST_TET, COLOR1, P4, P7, P5, P3, 
 // Case #190: (cloned #111)
  ST_TET, COLOR0, EI, ED, EA, P0, 
  ST_TET, COLOR0, EH, EG, EK, P6, 
  ST_WDG, COLOR1, EK, EH, EG, P2, P4, P7, 
  ST_WDG, COLOR1, P2, P4, P1, ED, EI, EA, 
  ST_PYR, COLOR1, P3, P1, P5, P7, P2, 
  ST_TET, COLOR1, P4, P5, P1, P2, 
  ST_TET, COLOR1, P4, P7, P5, P2, 
 // Case #191: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P5, P1, P0, P4, P7, P3, P2, 
  ST_TET, COLOR0, EG, EK, EH, P6, 
  ST_WDG, COLOR1, EG, EK, EH, P7, P2, P4, 
  ST_TET, COLOR1, P7, P4, P2, N0, 
  ST_PYR, COLOR1, P3, P2, P0, P1, N0, 
  ST_TET, COLOR1, P2, P4, P0, N0, 
  ST_PYR, COLOR1, P5, P1, P0, P4, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, P5, P7, P3, P1, N0, 
  ST_TET, COLOR1, P7, P2, P3, N0, 
 // Case #192: (cloned #3)
  ST_HEX, COLOR0, EF, P5, P4, EH, EL, P3, P2, EK, 
  ST_WDG, COLOR0, P5, P1, P3, P4, P0, P2, 
  ST_WDG, COLOR1, P7, EF, EL, P6, EH, EK, 
 // Case #193: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EL, EF, EA, EA, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_TET, COLOR0, EI, EH, P4, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_TET, COLOR0, P3, P2, P1, N0, 
  ST_PYR, COLOR0, P2, ED, EA, P1, N0, 
  ST_TET, COLOR0, P3, P1, P5, N0, 
  ST_PYR, COLOR0, P3, P5, EF, EL, N0, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_PYR, COLOR1, P0, P6, EH, EI, N0, 
  ST_PYR, COLOR1, EK, P6, P0, ED, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
  ST_PYR, COLOR1, EH, P6, P7, EF, N0, 
  ST_PYR, COLOR1, P6, EK, EL, P7, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
 // Case #194: (cloned #25)
  ST_PNT, 0, NOCOLOR, 4, EK, EH, EA, EA, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, P4, EH, EF, P5, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_TET, COLOR0, P2, P0, P3, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EB, N0, 
  ST_TET, COLOR0, P2, P4, P0, N0, 
  ST_PYR, COLOR0, P2, EK, EH, P4, N0, 
  ST_PYR, COLOR0, P2, P3, EL, EK, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, N0, 
  ST_PYR, COLOR1, EL, EB, P1, P7, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_PYR, COLOR1, P7, P6, EK, EL, N0, 
  ST_TET, COLOR1, EK, P6, EH, N0, 
 // Case #195: (cloned #60)
  ST_WDG, COLOR0, P2, ED, EK, P3, EB, EL, 
  ST_WDG, COLOR0, P4, EH, EI, P5, EF, EJ, 
  ST_HEX, COLOR1, EI, EH, EF, EJ, P0, P6, P7, P1, 
  ST_HEX, COLOR1, P0, P6, P7, P1, ED, EK, EL, EB, 
 // Case #196: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, EL, EC, ED, 
  ST_PYR, COLOR0, P5, P1, P0, P4, N0, 
  ST_TET, COLOR0, P0, P3, N0, P1, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_PYR, COLOR0, EF, P5, P4, EH, N0, 
  ST_TET, COLOR0, P3, P1, P5, N0, 
  ST_PYR, COLOR0, P3, P5, EF, EL, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_PYR, COLOR0, ED, P0, P3, EC, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
  ST_TET, COLOR1, P7, P6, P2, N0, 
  ST_PYR, COLOR1, EL, P7, P2, EC, N0, 
  ST_TET, COLOR1, P2, ED, EC, N0, 
 // Case #197: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EC, EL, EF, EH, EI, EA, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P3, P1, P5, N0, 
  ST_PYR, COLOR0, P3, P5, EF, EL, N0, 
  ST_TET, COLOR0, EC, P3, EL, N0, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_PYR, COLOR0, EA, EI, P4, P1, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR1, P2, P7, P6, N0, 
  ST_PYR, COLOR1, EC, EL, P7, P2, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_TET, COLOR1, P0, P2, P6, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P0, P6, EH, EI, N0, 
  ST_PYR, COLOR1, EH, P6, P7, EF, N0, 
  ST_TET, COLOR1, EF, P7, EL, N0, 
 // Case #198: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, ED, EA, EJ, 
  ST_TET, COLOR0, P3, EL, EC, EB, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_TET, COLOR0, P4, P5, P0, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_WDG, COLOR1, EC, EL, EB, P2, P7, P1, 
  ST_TET, COLOR1, P7, P2, P1, N0, 
  ST_PYR, COLOR1, P2, ED, EA, P1, N0, 
  ST_TET, COLOR1, P6, P2, P7, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, N0, 
  ST_TET, COLOR1, EA, EJ, P1, N0, 
 // Case #199: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P1, P0, P6, EF, EH, 
  ST_WDG, COLOR0, EF, P5, EJ, EH, P4, EI, 
  ST_TET, COLOR0, EC, EB, P3, EL, 
  ST_WDG, COLOR1, EC, EL, EB, P2, P7, P1, 
  ST_PYR, COLOR1, EH, P6, P7, EF, N0, 
  ST_TET, COLOR1, P6, P2, P7, N0, 
  ST_TET, COLOR1, P6, P0, P2, N0, 
  ST_PYR, COLOR1, EI, P0, P6, EH, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_PYR, COLOR1, EF, EJ, EI, EH, N0, 
  ST_TET, COLOR1, P1, P7, P2, N0, 
  ST_PYR, COLOR1, EF, P7, P1, EJ, N0, 
 // Case #200: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, EK, EC, EB, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_TET, COLOR0, P1, N0, P2, P0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_PYR, COLOR0, EH, EF, P5, P4, N0, 
  ST_TET, COLOR0, P2, P4, P0, N0, 
  ST_PYR, COLOR0, P2, EK, EH, P4, N0, 
  ST_TET, COLOR0, P2, EC, EK, N0, 
  ST_PYR, COLOR0, EB, EC, P2, P1, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_PYR, COLOR1, EH, P6, P7, EF, N0, 
  ST_TET, COLOR1, EK, P6, EH, N0, 
  ST_TET, COLOR1, P6, P3, P7, N0, 
  ST_PYR, COLOR1, EK, EC, P3, P6, N0, 
  ST_TET, COLOR1, P3, EC, EB, N0, 
 // Case #201: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EH, EI, EA, 
  ST_TET, COLOR0, P2, EC, EK, ED, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_WDG, COLOR1, EK, EC, ED, P6, P3, P0, 
  ST_TET, COLOR1, P3, P6, P0, N0, 
  ST_PYR, COLOR1, P6, EH, EI, P0, N0, 
  ST_TET, COLOR1, P7, P6, P3, N0, 
  ST_PYR, COLOR1, EB, EF, P7, P3, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P3, N0, 
  ST_TET, COLOR1, EI, EA, P0, N0, 
 // Case #202: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EC, EK, EH, EF, EJ, EA, 
  ST_TET, COLOR0, P4, P5, P0, N0, 
  ST_PYR, COLOR0, P4, EH, EF, P5, N0, 
  ST_TET, COLOR0, P2, P4, P0, N0, 
  ST_PYR, COLOR0, P2, EK, EH, P4, N0, 
  ST_TET, COLOR0, EC, EK, P2, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_PYR, COLOR0, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR1, P3, P7, P6, N0, 
  ST_PYR, COLOR1, EC, P3, P6, EK, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_TET, COLOR1, P1, P7, P3, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_TET, COLOR1, EH, EK, P6, N0, 
 // Case #203: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P0, P1, P7, EH, EF, 
  ST_WDG, COLOR0, EF, P5, EJ, EH, P4, EI, 
  ST_TET, COLOR0, EC, P2, ED, EK, 
  ST_WDG, COLOR1, P3, P6, P0, EC, EK, ED, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_TET, COLOR1, P7, P6, P3, N0, 
  ST_TET, COLOR1, P7, P3, P1, N0, 
  ST_PYR, COLOR1, EJ, EF, P7, P1, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_PYR, COLOR1, EH, EF, EJ, EI, N0, 
  ST_TET, COLOR1, P0, P3, P6, N0, 
  ST_PYR, COLOR1, EH, EI, P0, P6, N0, 
 // Case #204: (cloned #15)
  ST_HEX, COLOR0, ED, EB, EF, EH, P0, P1, P5, P4, 
  ST_HEX, COLOR1, P2, P3, P7, P6, ED, EB, EF, EH, 
 // Case #205: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, EH, EA, EI, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, EI, P4, P1, EA, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_PYR, COLOR1, P2, P3, P7, P6, N0, 
  ST_TET, COLOR1, P6, P0, P2, N0, 
  ST_TET, COLOR1, P0, P3, P2, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P3, N0, 
  ST_PYR, COLOR1, EB, EF, P7, P3, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_PYR, COLOR1, EH, EI, P0, P6, N0, 
  ST_TET, COLOR1, EA, P0, EI, N0, 
 // Case #206: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, ED, EJ, EA, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_PYR, COLOR1, P3, P7, P6, P2, N0, 
  ST_TET, COLOR1, P2, P1, P3, N0, 
  ST_TET, COLOR1, P1, P7, P3, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P7, N0, 
  ST_PYR, COLOR1, EF, EH, P6, P7, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P2, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #207: (cloned #63)
  ST_WDG, COLOR0, P5, EJ, EF, P4, EI, EH, 
  ST_HEX, COLOR1, EI, EH, EF, EJ, P0, P6, P7, P1, 
  ST_WDG, COLOR1, P2, P0, P6, P3, P1, P7, 
 // Case #208: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EF, EE, EI, 
  ST_PYR, COLOR0, P3, P2, P0, P1, N0, 
  ST_TET, COLOR0, P0, N0, P5, P1, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_PYR, COLOR0, EL, EK, P2, P3, N0, 
  ST_TET, COLOR0, P5, P3, P1, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P3, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, EI, EE, P5, P0, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_TET, COLOR1, EF, P7, EL, N0, 
  ST_TET, COLOR1, P7, P4, P6, N0, 
  ST_PYR, COLOR1, EF, EE, P4, P7, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
 // Case #209: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EE, EF, EL, EK, ED, EA, 
  ST_TET, COLOR0, P3, P2, P1, N0, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_TET, COLOR0, P5, P3, P1, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P3, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_PYR, COLOR0, EA, P1, P2, ED, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_TET, COLOR1, P4, P6, P7, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EF, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, P0, P6, P4, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P6, N0, 
  ST_PYR, COLOR1, EK, EL, P7, P6, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
 // Case #210: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EI, EA, EB, 
  ST_TET, COLOR0, P5, EE, EF, EJ, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_TET, COLOR0, P2, P0, P3, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P3, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_WDG, COLOR1, P4, P7, P1, EE, EF, EJ, 
  ST_TET, COLOR1, P7, P1, P4, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_TET, COLOR1, P6, P7, P4, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, P1, P7, EL, EB, N0, 
  ST_TET, COLOR1, EA, P1, EB, N0, 
 // Case #211: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P1, P0, P6, EL, EK, 
  ST_WDG, COLOR0, EK, P2, ED, EL, P3, EB, 
  ST_TET, COLOR0, EE, P5, EJ, EF, 
  ST_WDG, COLOR1, P4, P7, P1, EE, EF, EJ, 
  ST_PYR, COLOR1, EK, EL, P7, P6, N0, 
  ST_TET, COLOR1, P6, P7, P4, N0, 
  ST_TET, COLOR1, P6, P4, P0, N0, 
  ST_PYR, COLOR1, ED, EK, P6, P0, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EL, EK, ED, EB, N0, 
  ST_TET, COLOR1, P1, P4, P7, N0, 
  ST_PYR, COLOR1, EL, EB, P1, P7, N0, 
 // Case #212: (cloned #23)
  ST_TET, COLOR0, P3, P0, P1, P5, 
  ST_PYR, COLOR0, EE, P5, P0, EI, ED, 
  ST_PYR, COLOR0, EF, EL, P3, P5, EC, 
  ST_PYR, COLOR0, P0, P3, EC, ED, P5, 
  ST_PYR, COLOR0, ED, EC, EF, EE, P5, 
  ST_TET, COLOR1, P6, P7, P4, P2, 
  ST_PYR, COLOR1, ED, P2, P4, EI, EE, 
  ST_PYR, COLOR1, EC, EL, P7, P2, EF, 
  ST_PYR, COLOR1, P4, P7, EF, EE, P2, 
  ST_PYR, COLOR1, ED, EE, EF, EC, P2, 
 // Case #213: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EC, EA, EE, EL, EF, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, P3, EC, EA, P1, N0, 
  ST_TET, COLOR0, EL, EC, P3, N0, 
  ST_PYR, COLOR0, EF, EL, P3, P5, N0, 
  ST_TET, COLOR0, P5, P3, P1, N0, 
  ST_PYR, COLOR1, P6, P4, P0, P2, N0, 
  ST_TET, COLOR1, P4, P6, P7, N0, 
  ST_TET, COLOR1, P7, P6, P2, N0, 
  ST_PYR, COLOR1, P7, P2, EC, EL, N0, 
  ST_PYR, COLOR1, EC, P2, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EF, N0, 
  ST_TET, COLOR1, EL, EF, P7, N0, 
 // Case #214: (cloned #107)
  ST_TET, COLOR0, EE, EJ, EF, P5, 
  ST_TET, COLOR0, EI, P0, ED, EA, 
  ST_TET, COLOR0, EL, EC, P3, EB, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P2, P7, 
  ST_WDG, COLOR1, P4, P1, P2, EI, EA, ED, 
  ST_WDG, COLOR1, EE, EJ, EF, P4, P1, P7, 
  ST_TET, COLOR1, P1, P7, P2, P4, 
  ST_TET, COLOR1, P4, P6, P7, P2, 
 // Case #215: (cloned #111)
  ST_TET, COLOR0, EL, EB, EC, P3, 
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P7, P4, 
  ST_WDG, COLOR1, P1, P7, P2, EB, EL, EC, 
  ST_PYR, COLOR1, P0, P2, P6, P4, P1, 
  ST_TET, COLOR1, P7, P6, P2, P1, 
  ST_TET, COLOR1, P7, P4, P6, P1, 
 // Case #216: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EK, EC, EB, EF, EE, EI, 
  ST_TET, COLOR0, P1, P0, P5, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P2, P1, EB, EC, N0, 
  ST_TET, COLOR0, EK, P2, EC, N0, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_PYR, COLOR0, EI, EE, P5, P0, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR1, P6, P3, P7, N0, 
  ST_PYR, COLOR1, EK, EC, P3, P6, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_TET, COLOR1, P4, P6, P7, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_PYR, COLOR1, P4, P7, EF, EE, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_TET, COLOR1, EB, P3, EC, N0, 
 // Case #217: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P0, P4, P7, EB, EF, 
  ST_WDG, COLOR0, EB, P1, EA, EF, P5, EE, 
  ST_TET, COLOR0, EK, ED, P2, EC, 
  ST_WDG, COLOR1, EK, EC, ED, P6, P3, P0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_TET, COLOR1, P7, P6, P3, N0, 
  ST_TET, COLOR1, P7, P4, P6, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EF, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_TET, COLOR1, P4, P0, P6, N0, 
  ST_PYR, COLOR1, EB, EA, EE, EF, N0, 
  ST_TET, COLOR1, P0, P3, P6, N0, 
  ST_PYR, COLOR1, EB, P3, P0, EA, N0, 
 // Case #218: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P1, P3, P6, EI, EK, 
  ST_WDG, COLOR0, EI, P0, EA, EK, P2, EC, 
  ST_TET, COLOR0, EF, EJ, P5, EE, 
  ST_WDG, COLOR1, EF, EE, EJ, P7, P4, P1, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_TET, COLOR1, P6, P7, P4, N0, 
  ST_TET, COLOR1, P6, P3, P7, N0, 
  ST_PYR, COLOR1, EC, P3, P6, EK, N0, 
  ST_PYR, COLOR1, EA, P1, P3, EC, N0, 
  ST_TET, COLOR1, P3, P1, P7, N0, 
  ST_PYR, COLOR1, EI, EA, EC, EK, N0, 
  ST_TET, COLOR1, P1, P4, P7, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
 // Case #219: (cloned #126)
  ST_TET, COLOR0, EC, ED, EK, P2, 
  ST_TET, COLOR0, EJ, EF, EE, P5, 
  ST_WDG, COLOR1, P0, P3, P6, ED, EC, EK, 
  ST_WDG, COLOR1, P1, P4, P7, EJ, EE, EF, 
  ST_TET, COLOR1, P7, P4, P6, P1, 
  ST_TET, COLOR1, P1, P3, P0, P6, 
  ST_TET, COLOR1, P0, P4, P1, P6, 
  ST_TET, COLOR1, P1, P7, P3, P6, 
 // Case #220: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, ED, EE, EI, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, EI, EE, P5, P0, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_PYR, COLOR1, P6, P2, P3, P7, N0, 
  ST_TET, COLOR1, P2, P6, P4, N0, 
  ST_TET, COLOR1, P4, P6, P7, N0, 
  ST_PYR, COLOR1, P4, P7, EF, EE, N0, 
  ST_PYR, COLOR1, EF, P7, P3, EB, N0, 
  ST_PYR, COLOR1, EB, P3, P2, ED, N0, 
  ST_PYR, COLOR1, ED, P2, P4, EI, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #221: (cloned #63)
  ST_WDG, COLOR0, P1, EA, EB, P5, EE, EF, 
  ST_HEX, COLOR1, P0, P3, P7, P4, EA, EB, EF, EE, 
  ST_WDG, COLOR1, P6, P4, P7, P2, P0, P3, 
 // Case #222: (cloned #111)
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EJ, EF, EE, P5, 
  ST_WDG, COLOR1, EE, EJ, EF, P4, P1, P7, 
  ST_WDG, COLOR1, P4, P1, P2, EI, EA, ED, 
  ST_PYR, COLOR1, P6, P2, P3, P7, P4, 
  ST_TET, COLOR1, P1, P3, P2, P4, 
  ST_TET, COLOR1, P1, P7, P3, P4, 
 // Case #223: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P3, P2, P0, P1, P7, P6, P4, 
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_WDG, COLOR1, EF, EE, EJ, P7, P4, P1, 
  ST_TET, COLOR1, P7, P1, P4, N0, 
  ST_PYR, COLOR1, P6, P4, P0, P2, N0, 
  ST_TET, COLOR1, P4, P1, P0, N0, 
  ST_PYR, COLOR1, P3, P2, P0, P1, N0, 
  ST_TET, COLOR1, P3, P1, P7, N0, 
  ST_PYR, COLOR1, P3, P7, P6, P2, N0, 
  ST_TET, COLOR1, P7, P4, P6, N0, 
 // Case #224: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EH, EE, EJ, 
  ST_PYR, COLOR0, P2, P0, P1, P3, N0, 
  ST_TET, COLOR0, P1, P4, N0, P0, 
  ST_PYR, COLOR0, P3, P1, EJ, EL, N0, 
  ST_PYR, COLOR0, EK, P2, P3, EL, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_PYR, COLOR0, P4, P2, EK, EH, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR0, EJ, P1, P4, EE, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_PYR, COLOR1, EK, EL, P7, P6, N0, 
  ST_TET, COLOR1, EH, EK, P6, N0, 
  ST_TET, COLOR1, P6, P7, P5, N0, 
  ST_PYR, COLOR1, EH, P6, P5, EE, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
 // Case #225: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EK, ED, EA, 
  ST_TET, COLOR0, P4, EH, EE, EI, 
  ST_PYR, COLOR0, P1, EJ, EL, P3, N0, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_TET, COLOR0, P3, P2, P1, N0, 
  ST_PYR, COLOR0, P2, ED, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_WDG, COLOR1, P6, P5, P0, EH, EE, EI, 
  ST_TET, COLOR1, P5, P0, P6, N0, 
  ST_PYR, COLOR1, P6, P0, ED, EK, N0, 
  ST_TET, COLOR1, P7, P5, P6, N0, 
  ST_PYR, COLOR1, EJ, P5, P7, EL, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
 // Case #226: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EE, EH, EK, EL, EB, EA, 
  ST_TET, COLOR0, P2, P0, P3, N0, 
  ST_PYR, COLOR0, P2, P3, EL, EK, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_PYR, COLOR0, P4, P2, EK, EH, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_PYR, COLOR0, EA, EB, P3, P0, N0, 
  ST_TET, COLOR0, P3, EB, EL, N0, 
  ST_TET, COLOR1, P5, P6, P7, N0, 
  ST_PYR, COLOR1, EE, EH, P6, P5, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, P1, P5, P7, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_PYR, COLOR1, P1, P7, EL, EB, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_TET, COLOR1, EK, P6, EH, N0, 
 // Case #227: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P0, P1, P7, EK, EL, 
  ST_WDG, COLOR0, EK, P2, ED, EL, P3, EB, 
  ST_TET, COLOR0, EE, EI, P4, EH, 
  ST_WDG, COLOR1, EE, EH, EI, P5, P6, P0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_TET, COLOR1, P7, P5, P6, N0, 
  ST_TET, COLOR1, P7, P1, P5, N0, 
  ST_PYR, COLOR1, EB, P1, P7, EL, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_PYR, COLOR1, EK, ED, EB, EL, N0, 
  ST_TET, COLOR1, P0, P6, P5, N0, 
  ST_PYR, COLOR1, EK, P6, P0, ED, N0, 
 // Case #228: (cloned #27)
  ST_PNT, 0, NOCOLOR, 6, EH, EE, EJ, EL, EC, ED, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P3, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR0, EH, EE, P4, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_PYR, COLOR0, ED, P0, P3, EC, N0, 
  ST_TET, COLOR0, P3, EL, EC, N0, 
  ST_TET, COLOR1, P6, P7, P5, N0, 
  ST_PYR, COLOR1, EH, P6, P5, EE, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_TET, COLOR1, P2, P7, P6, N0, 
  ST_TET, COLOR1, P2, ED, EC, N0, 
  ST_PYR, COLOR1, P2, EC, EL, P7, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_TET, COLOR1, EJ, EE, P5, N0, 
 // Case #229: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P0, P2, P7, EJ, EL, 
  ST_WDG, COLOR0, EL, P3, EC, EJ, P1, EA, 
  ST_TET, COLOR0, EH, P4, EI, EE, 
  ST_WDG, COLOR1, P6, P5, P0, EH, EE, EI, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_TET, COLOR1, P7, P5, P6, N0, 
  ST_TET, COLOR1, P7, P6, P2, N0, 
  ST_PYR, COLOR1, EC, EL, P7, P2, N0, 
  ST_PYR, COLOR1, EA, EC, P2, P0, N0, 
  ST_TET, COLOR1, P2, P6, P0, N0, 
  ST_PYR, COLOR1, EJ, EL, EC, EA, N0, 
  ST_TET, COLOR1, P0, P6, P5, N0, 
  ST_PYR, COLOR1, EJ, EA, P0, P5, N0, 
 // Case #230: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P1, P5, P6, ED, EH, 
  ST_WDG, COLOR0, EH, P4, EE, ED, P0, EA, 
  ST_TET, COLOR0, EL, P3, EB, EC, 
  ST_WDG, COLOR1, P7, P2, P1, EL, EC, EB, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_TET, COLOR1, P6, P2, P7, N0, 
  ST_TET, COLOR1, P6, P7, P5, N0, 
  ST_PYR, COLOR1, EE, EH, P6, P5, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_TET, COLOR1, P5, P7, P1, N0, 
  ST_PYR, COLOR1, ED, EH, EE, EA, N0, 
  ST_TET, COLOR1, P1, P7, P2, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P2, N0, 
 // Case #231: (cloned #126)
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_TET, COLOR0, EB, EC, EL, P3, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P6, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P2, P7, 
  ST_TET, COLOR1, P7, P6, P2, P1, 
  ST_TET, COLOR1, P1, P0, P5, P6, 
  ST_TET, COLOR1, P0, P1, P2, P6, 
  ST_TET, COLOR1, P1, P5, P7, P6, 
 // Case #232: (cloned #23)
  ST_TET, COLOR0, P2, P0, P1, P4, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR0, EH, P4, P2, EK, EC, 
  ST_PYR, COLOR0, P1, EB, EC, P2, P4, 
  ST_PYR, COLOR0, EB, EE, EH, EC, P4, 
  ST_TET, COLOR1, P7, P5, P6, P3, 
  ST_PYR, COLOR1, EB, EJ, P5, P3, EE, 
  ST_PYR, COLOR1, EC, P3, P6, EK, EH, 
  ST_PYR, COLOR1, P5, EE, EH, P6, P3, 
  ST_PYR, COLOR1, EB, EC, EH, EE, P3, 
 // Case #233: (cloned #107)
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_TET, COLOR0, EE, P4, EH, EI, 
  ST_TET, COLOR0, EC, EK, P2, ED, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P6, P3, 
  ST_WDG, COLOR1, P5, P0, P6, EE, EI, EH, 
  ST_WDG, COLOR1, EJ, EA, EB, P5, P0, P3, 
  ST_TET, COLOR1, P0, P3, P6, P5, 
  ST_TET, COLOR1, P5, P7, P3, P6, 
 // Case #234: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EC, EA, EE, EK, EH, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EC, N0, 
  ST_TET, COLOR0, EK, P2, EC, N0, 
  ST_PYR, COLOR0, EH, P4, P2, EK, N0, 
  ST_TET, COLOR0, P4, P0, P2, N0, 
  ST_PYR, COLOR1, P7, P3, P1, P5, N0, 
  ST_TET, COLOR1, P5, P6, P7, N0, 
  ST_TET, COLOR1, P6, P3, P7, N0, 
  ST_PYR, COLOR1, P6, EK, EC, P3, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P3, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, EE, EH, P6, P5, N0, 
  ST_TET, COLOR1, EK, P6, EH, N0, 
 // Case #235: (cloned #111)
  ST_TET, COLOR0, EK, EC, ED, P2, 
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_WDG, COLOR1, P0, P6, P5, EI, EH, EE, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P6, P3, 
  ST_PYR, COLOR1, P1, P5, P7, P3, P0, 
  ST_TET, COLOR1, P6, P3, P7, P0, 
  ST_TET, COLOR1, P6, P7, P5, P0, 
 // Case #236: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EH, ED, EB, EE, EJ, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR1, P7, P6, P2, P3, N0, 
  ST_TET, COLOR1, P3, P5, P7, N0, 
  ST_TET, COLOR1, P5, P6, P7, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P6, N0, 
  ST_PYR, COLOR1, EH, ED, P2, P6, N0, 
  ST_PYR, COLOR1, ED, EB, P3, P2, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P3, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #237: (cloned #111)
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_WDG, COLOR1, P0, P5, P3, EA, EJ, EB, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P6, 
  ST_PYR, COLOR1, P2, P3, P7, P6, P0, 
  ST_TET, COLOR1, P5, P6, P7, P0, 
  ST_TET, COLOR1, P5, P7, P3, P0, 
 // Case #238: (cloned #63)
  ST_WDG, COLOR0, P4, EE, EH, P0, EA, ED, 
  ST_HEX, COLOR1, EA, ED, EH, EE, P1, P2, P6, P5, 
  ST_WDG, COLOR1, P3, P1, P2, P7, P5, P6, 
 // Case #239: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P7, P3, P1, P5, P6, P2, P0, 
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_WDG, COLOR1, EH, EI, EE, P6, P0, P5, 
  ST_TET, COLOR1, P6, P5, P0, N0, 
  ST_PYR, COLOR1, P2, P0, P1, P3, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, P7, P3, P1, P5, N0, 
  ST_TET, COLOR1, P7, P5, P6, N0, 
  ST_PYR, COLOR1, P7, P6, P2, P3, N0, 
  ST_TET, COLOR1, P6, P0, P2, N0, 
 // Case #240: (cloned #15)
  ST_HEX, COLOR0, P0, P1, P3, P2, EI, EJ, EL, EK, 
  ST_HEX, COLOR1, EI, EJ, EL, EK, P4, P5, P7, P6, 
 // Case #241: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EK, EA, ED, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_TET, COLOR0, P2, EK, ED, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P3, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, ED, EA, P1, P2, N0, 
  ST_TET, COLOR0, P2, P1, P3, N0, 
  ST_PYR, COLOR1, P4, P6, P7, P5, N0, 
  ST_TET, COLOR1, P6, P4, P0, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EJ, P5, P7, EL, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_PYR, COLOR1, EK, P6, P0, ED, N0, 
  ST_TET, COLOR1, EA, ED, P0, N0, 
 // Case #242: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EI, EB, EA, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, P3, EL, EK, P2, N0, 
  ST_TET, COLOR0, EB, EL, P3, N0, 
  ST_PYR, COLOR0, EA, EB, P3, P0, N0, 
  ST_TET, COLOR0, P0, P3, P2, N0, 
  ST_PYR, COLOR1, P5, P4, P6, P7, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_TET, COLOR1, P1, P5, P7, N0, 
  ST_PYR, COLOR1, P1, P7, EL, EB, N0, 
  ST_PYR, COLOR1, EL, P7, P6, EK, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #243: (cloned #63)
  ST_WDG, COLOR0, P2, ED, EK, P3, EB, EL, 
  ST_HEX, COLOR1, P0, P6, P7, P1, ED, EK, EL, EB, 
  ST_WDG, COLOR1, P5, P1, P7, P4, P0, P6, 
 // Case #244: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EI, EC, ED, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, P3, P1, EJ, EL, N0, 
  ST_TET, COLOR0, EC, P3, EL, N0, 
  ST_PYR, COLOR0, ED, P0, P3, EC, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_PYR, COLOR1, P6, P7, P5, P4, N0, 
  ST_TET, COLOR1, P4, P2, P6, N0, 
  ST_TET, COLOR1, P2, P7, P6, N0, 
  ST_PYR, COLOR1, P2, EC, EL, P7, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P7, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, EI, ED, P2, P4, N0, 
  ST_TET, COLOR1, EC, P2, ED, N0, 
 // Case #245: (cloned #63)
  ST_WDG, COLOR0, P3, EC, EL, P1, EA, EJ, 
  ST_HEX, COLOR1, EA, EJ, EL, EC, P0, P5, P7, P2, 
  ST_WDG, COLOR1, P4, P0, P5, P6, P2, P7, 
 // Case #246: (cloned #111)
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EB, EC, EL, P3, 
  ST_WDG, COLOR1, P2, P1, P7, EC, EB, EL, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_PYR, COLOR1, P6, P7, P5, P4, P2, 
  ST_TET, COLOR1, P1, P4, P5, P2, 
  ST_TET, COLOR1, P1, P5, P7, P2, 
 // Case #247: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P5, P4, P0, P1, P7, P6, P2, 
  ST_TET, COLOR0, EL, EB, EC, P3, 
  ST_WDG, COLOR1, P7, P2, P1, EL, EC, EB, 
  ST_TET, COLOR1, P7, P2, P1, N0, 
  ST_PYR, COLOR1, P6, P4, P0, P2, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_PYR, COLOR1, P5, P1, P0, P4, N0, 
  ST_TET, COLOR1, P5, P7, P1, N0, 
  ST_PYR, COLOR1, P5, P4, P6, P7, N0, 
  ST_TET, COLOR1, P7, P6, P2, N0, 
 // Case #248: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EK, EI, EJ, EC, EB, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, P2, EK, EI, P0, N0, 
  ST_TET, COLOR0, EC, EK, P2, N0, 
  ST_PYR, COLOR0, EB, EC, P2, P1, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR1, P7, P5, P4, P6, N0, 
  ST_TET, COLOR1, P5, P7, P3, N0, 
  ST_TET, COLOR1, P3, P7, P6, N0, 
  ST_PYR, COLOR1, P3, P6, EK, EC, N0, 
  ST_PYR, COLOR1, EK, P6, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, EJ, P5, P3, EB, N0, 
  ST_TET, COLOR1, EC, EB, P3, N0, 
 // Case #249: (cloned #111)
  ST_TET, COLOR0, EC, ED, EK, P2, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, EA, EB, EJ, P0, P3, P5, 
  ST_WDG, COLOR1, P0, P3, P6, ED, EC, EK, 
  ST_PYR, COLOR1, P4, P6, P7, P5, P0, 
  ST_TET, COLOR1, P3, P7, P6, P0, 
  ST_TET, COLOR1, P3, P5, P7, P0, 
 // Case #250: (cloned #63)
  ST_WDG, COLOR0, P0, EA, EI, P2, EC, EK, 
  ST_HEX, COLOR1, P1, P4, P6, P3, EA, EI, EK, EC, 
  ST_WDG, COLOR1, P7, P3, P6, P5, P1, P4, 
 // Case #251: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P7, P5, P1, P3, P6, P4, P0, 
  ST_TET, COLOR0, EK, EC, ED, P2, 
  ST_WDG, COLOR1, P6, P0, P3, EK, ED, EC, 
  ST_TET, COLOR1, P6, P0, P3, N0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, P7, P3, P1, P5, N0, 
  ST_TET, COLOR1, P7, P6, P3, N0, 
  ST_PYR, COLOR1, P7, P5, P4, P6, N0, 
  ST_TET, COLOR1, P6, P4, P0, N0, 
 // Case #252: (cloned #63)
  ST_WDG, COLOR0, P0, EI, ED, P1, EJ, EB, 
  ST_HEX, COLOR1, P4, P2, P3, P5, EI, ED, EB, EJ, 
  ST_WDG, COLOR1, P7, P5, P3, P6, P4, P2, 
 // Case #253: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P7, P6, P4, P5, P3, P2, P0, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, P3, P0, P5, EB, EA, EJ, 
  ST_TET, COLOR1, P3, P0, P5, N0, 
  ST_PYR, COLOR1, P2, P6, P4, P0, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, P7, P5, P4, P6, N0, 
  ST_TET, COLOR1, P7, P3, P5, N0, 
  ST_PYR, COLOR1, P7, P6, P2, P3, N0, 
  ST_TET, COLOR1, P3, P2, P0, N0, 
 // Case #254: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P6, P7, P5, P4, P2, P3, P1, 
  ST_TET, COLOR0, ED, EA, EI, P0, 
  ST_WDG, COLOR1, ED, EA, EI, P2, P1, P4, 
  ST_TET, COLOR1, P2, P4, P1, N0, 
  ST_PYR, COLOR1, P3, P1, P5, P7, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_PYR, COLOR1, P6, P7, P5, P4, N0, 
  ST_TET, COLOR1, P6, P4, P2, N0, 
  ST_PYR, COLOR1, P6, P2, P3, P7, N0, 
  ST_TET, COLOR1, P2, P1, P3, N0, 
 // Case #255: Unique case #22
  ST_HEX, COLOR1, P0, P1, P3, P2, P4, P5, P7, P6, 
 // Dummy
  0
};

