#!/usr/bin/perl
#
# Written by Sebastien Tricaud (C) 2008
#
# Changelog:
# 2008/12/23 - Initial version
#

# argus -r file.pcap -w - | ra -n > file.netflow
#
# 09-07-07 13:32:46.447979           udp                   192.168.0.1.138         ->              192.168.167.39.138        1        0         258          0           INT
# 09-07-07 13:33:31.830770           tcp                   192.168.0.1.1032        ->              10.42.166.119.80         13       14        1087         16090       FIN
#

print "header {\n";
print "    title = \"Argus netflow graph\";\n";
print "}\n";

print "axes {\n";
print "    timeline time [label=\"Timeline\"];\n";
print "    ipv4     sip [label=\"Source IP\"];\n";
print "    ipv4     dip [label=\"Dest IP\"];\n";
print "    integer  sport [label=\"Source Port\"];\n";
print "    integer  dport [label=\"Dest Port\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {


	$line =~ s/\\/\\\\/g;
	$line =~ s/\"|&|<|>/\\"/g;


	if ($line =~ m/\d+-\d+-\d+ (\d+:\d+:\d+).\d+.*(udp|tcp).*(\d+.\d+.\d+.\d+)\.(\d+).*(\d+.\d+.\d+.\d+)\.(\d+).*/) {

		$time=$1;
		$proto=$2;
		$sip=$3;
		$sport=$4;
		$dip=$5;
		$dport=$6;

		if ($proto =~ m/tcp/) {
			print "    time=\"$time\",sip=\"$sip\",dip=\"$dip\",sport=\"$sport\",dport=\"$dport\" [color=\"yellow\"];\n";
		} else {
			print "    time=\"$time\",sip=\"$sip\",dip=\"$dip\",sport=\"$sport\",dport=\"$dport\" [color=\"blue\"];\n";
		}
	}
}

print "}\n";

