#  Copyright (c) 1997-2018
#  Ewgenij Gawrilow, Michael Joswig (Technische Universitaet Berlin, Germany)
#  http://www.polymake.org
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version: http://www.gnu.org/licenses/gpl.txt.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#-------------------------------------------------------------------------------

use application "polytope";

# volume of a union of polytopes (in the same space); by inclusion-exclusion
sub vol_union(@) {
  my $n = scalar(@_);
  die "usage: vol_union(poly1,poly2,...)\n" unless $n>0;
  my $total = 0;
  my $sign = 1;
  for (my $k=1; $k<=$n; ++$k) {
    my @idx = all_subsets_of_k($k,0..($n-1));
    my $v = 0;
    foreach my $subset (@idx) {
      $v += intersection(@_[@$subset])->VOLUME; 
    }
    $total += $sign * $v;
    $sign = -$sign;
  }
  return $total;
}

# Local Variables:
# mode: perl
# c-basic-offset:3
# End:
