/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class MedianOfWidestDimension
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1383443320160540663L;

    public String globalInfo() {
        return "The class that splits a KDTree node based on the median value of a dimension in which the node's points have the widest spread.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jerome H. Friedman and Jon Luis Bentley and Raphael Ari Finkel");
        result.setValue(TechnicalInformation.Field.YEAR, "1977");
        result.setValue(TechnicalInformation.Field.TITLE, "An Algorithm for Finding Best Matches in Logarithmic Expected Time");
        result.setValue(TechnicalInformation.Field.JOURNAL, "ACM Transactions on Mathematics Software");
        result.setValue(TechnicalInformation.Field.PAGES, "209-226");
        result.setValue(TechnicalInformation.Field.MONTH, "September");
        result.setValue(TechnicalInformation.Field.VOLUME, "3");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        return result;
    }

    public void splitNode(KDTreeNode node, int numNodesCreated, double[][] nodeRanges, double[][] universe) throws Exception {
        this.correctlyInitialized();
        int splitDim = this.widestDim(nodeRanges, universe);
        int medianIdxIdx = node.m_Start + (node.m_End - node.m_Start) / 2;
        int medianIdx = this.select(splitDim, this.m_InstList, node.m_Start, node.m_End, (node.m_End - node.m_Start) / 2 + 1);
        node.m_SplitDim = splitDim;
        node.m_SplitValue = this.m_Instances.instance(this.m_InstList[medianIdx]).value(splitDim);
        node.m_Left = new KDTreeNode(numNodesCreated + 1, node.m_Start, medianIdxIdx, this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, medianIdxIdx));
        node.m_Right = new KDTreeNode(numNodesCreated + 2, medianIdxIdx + 1, node.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, medianIdxIdx + 1, node.m_End));
    }

    protected int partition(int attIdx, int[] index, int l, int r) {
        double pivot = this.m_Instances.instance(index[(l + r) / 2]).value(attIdx);
        while (l < r) {
            while (this.m_Instances.instance(index[l]).value(attIdx) < pivot && l < r) {
                ++l;
            }
            while (this.m_Instances.instance(index[r]).value(attIdx) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && this.m_Instances.instance(index[r]).value(attIdx) > pivot) {
            --r;
        }
        return r;
    }

    public int select(int attIdx, int[] indices, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIdx, indices, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIdx, indices, left, middle, k);
        }
        return this.select(attIdx, indices, middle + 1, right, k - (middle - left + 1));
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

