/*
 * @BEGIN LICENSE
 *
 * Psi4: an open-source quantum chemistry software package
 *
 * Copyright (c) 2007-2019 The Psi4 Developers.
 *
 * The copyrights for code used from other parties are included in
 * the corresponding files.
 *
 * This file is part of Psi4.
 *
 * Psi4 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * Psi4 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with Psi4; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * @END LICENSE
 */

/*
** PHYSCONST.H : Includes physical constants
** D. Sherrill, April 1993
** Edward F. Valeev, March 1998
*/

/* revised 5/7/93 to agree w/ 1986 CODATA
 * recommended values J. Phys. Chem. Ref. Data 17, 1795 (1988)
 * all values revised
 *
 * revised 4/28/02 to agree with NIST online database
 * updated au2amu, hartree2J, hartree2wavenumbers
 *
 * revised 10/28/02 by TDC to include vacuum permittivity (_e0)
 * Avogadro's number (_na).
 *
 * Added electron rest mass from NIST database 6/27/03.
 * -TDC
 *
 * revised Jan 2012 by ACS from NIST CODATA 2010.
 *
 * revisec Aug 2018 by LAB to be autogenerated from NIST CODATA 2014.
 *
 */

#ifndef _qcelemental_physconst_h_
#define _qcelemental_physconst_h_

/* This file is autogenerated from the QCElemental python module */

/* clang-format off */
#define pc_pi 3.14159265358979323846264338327950288
#define pc_twopi 6.283185307179586476925286767
#define pc__220_lattice_spacing_of_silicon 1.920155714E-10                        /*- {220} lattice spacing of silicon [m] uncertainty=0.000 0032 e-12 -*/
#define pc_alpha_particle_electron_mass_ratio 7294.29954136                       /*- alpha particle-electron mass ratio [] uncertainty=0.000 000 24 -*/
#define pc_alpha_particle_mass 6.644657230E-27                                    /*- alpha particle mass [kg] uncertainty=0.000 000 082 e-27 -*/
#define pc_alpha_particle_mass_energy_equivalent 5.971920097E-10                  /*- alpha particle mass energy equivalent [J] uncertainty=0.000 000 073 e-10 -*/
#define pc_alpha_particle_mass_energy_equivalent_in_MeV 3727.379378               /*- alpha particle mass energy equivalent in MeV [MeV] uncertainty=0.000 023 -*/
#define pc_alpha_particle_mass_in_u 4.001506179127                                /*- alpha particle mass in u [u] uncertainty=0.000 000 000 063 -*/
#define pc_alpha_particle_molar_mass 0.004001506179127                            /*- alpha particle molar mass [kg mol^{-1}] uncertainty=0.000 000 000 063 e-3 -*/
#define pc_alpha_particle_proton_mass_ratio 3.97259968907                         /*- alpha particle-proton mass ratio [] uncertainty=0.000 000 000 36 -*/
#define pc_Angstrom_star 1.00001495E-10                                           /*- Angstrom star [m] uncertainty=0.000 000 90 e-10 -*/
#define pc_atomic_mass_constant 1.660539040E-27                                   /*- atomic mass constant [kg] uncertainty=0.000 000 020 e-27 -*/
#define pc_atomic_mass_constant_energy_equivalent 1.492418062E-10                 /*- atomic mass constant energy equivalent [J] uncertainty=0.000 000 018 e-10 -*/
#define pc_atomic_mass_constant_energy_equivalent_in_MeV 931.4940954              /*- atomic mass constant energy equivalent in MeV [MeV] uncertainty=0.000 0057 -*/
#define pc_atomic_mass_unit_electron_volt_relationship 931494095.4                /*- atomic mass unit-electron volt relationship [eV] uncertainty=0.000 0057 e6 -*/
#define pc_atomic_mass_unit_hartree_relationship 34231776.902                     /*- atomic mass unit-hartree relationship [E_h] uncertainty=0.000 000 0016 e7 -*/
#define pc_atomic_mass_unit_hertz_relationship 2.2523427206E+23                   /*- atomic mass unit-hertz relationship [Hz] uncertainty=0.000 000 0010 e23 -*/
#define pc_atomic_mass_unit_inverse_meter_relationship 7.5130066166E+14           /*- atomic mass unit-inverse meter relationship [m^{-1}] uncertainty=0.000 000 0034 e14 -*/
#define pc_atomic_mass_unit_joule_relationship 1.492418062E-10                    /*- atomic mass unit-joule relationship [J] uncertainty=0.000 000 018 e-10 -*/
#define pc_atomic_mass_unit_kelvin_relationship 1.08095438E+13                    /*- atomic mass unit-kelvin relationship [K] uncertainty=0.000 000 62 e13 -*/
#define pc_atomic_mass_unit_kilogram_relationship 1.660539040E-27                 /*- atomic mass unit-kilogram relationship [kg] uncertainty=0.000 000 020 e-27 -*/
#define pc_atomic_unit_of_1st_hyperpolarizability 3.206361329E-53                 /*- atomic unit of 1st hyperpolarizability [C^3 m^3 J^{-2}] uncertainty=0.000 000 020 e-53 -*/
#define pc_atomic_unit_of_2nd_hyperpolarizability 6.235380085E-65                 /*- atomic unit of 2nd hyperpolarizability [C^4 m^4 J^{-3}] uncertainty=0.000 000 077 e-65 -*/
#define pc_atomic_unit_of_action 1.054571800E-34                                  /*- atomic unit of action [J s] uncertainty=0.000 000 013 e-34 -*/
#define pc_atomic_unit_of_charge 1.6021766208E-19                                 /*- atomic unit of charge [C] uncertainty=0.000 000 0098 e-19 -*/
#define pc_atomic_unit_of_charge_density 1.0812023770E+12                         /*- atomic unit of charge density [C m^{-3}] uncertainty=0.000 000 0067 e12 -*/
#define pc_atomic_unit_of_current 0.006623618183                                  /*- atomic unit of current [A] uncertainty=0.000 000 041 e-3 -*/
#define pc_atomic_unit_of_electric_dipole_mom 8.478353552E-30                     /*- atomic unit of electric dipole mom. [C m] uncertainty=0.000 000 052 e-30 -*/
#define pc_atomic_unit_of_electric_field 5.142206707E+11                          /*- atomic unit of electric field [V m^{-1}] uncertainty=0.000 000 032 e11 -*/
#define pc_atomic_unit_of_electric_field_gradient 9.717362356E+21                 /*- atomic unit of electric field gradient [V m^{-2}] uncertainty=0.000 000 060 e21 -*/
#define pc_atomic_unit_of_electric_polarizability 1.6487772731E-41                /*- atomic unit of electric polarizability [C^2 m^2 J^{-1}] uncertainty=0.000 000 0011 e-41 -*/
#define pc_atomic_unit_of_electric_potential 27.21138602                          /*- atomic unit of electric potential [V] uncertainty=0.000 000 17 -*/
#define pc_atomic_unit_of_electric_quadrupole_mom 4.486551484E-40                 /*- atomic unit of electric quadrupole mom. [C m^2] uncertainty=0.000 000 028 e-40 -*/
#define pc_atomic_unit_of_energy 4.359744650E-18                                  /*- atomic unit of energy [J] uncertainty=0.000 000 054 e-18 -*/
#define pc_atomic_unit_of_force 8.23872336E-8                                     /*- atomic unit of force [N] uncertainty=0.000 000 10 e-8 -*/
#define pc_atomic_unit_of_length 5.2917721067E-11                                 /*- atomic unit of length [m] uncertainty=0.000 000 000 12 e-10 -*/
#define pc_atomic_unit_of_mag_dipole_mom 1.854801999E-23                          /*- atomic unit of mag. dipole mom. [J T^{-1}] uncertainty=0.000 000 011 e-23 -*/
#define pc_atomic_unit_of_mag_flux_density 235051.7550                            /*- atomic unit of mag. flux density [T] uncertainty=0.000 000 014 e5 -*/
#define pc_atomic_unit_of_magnetizability 7.8910365886E-29                        /*- atomic unit of magnetizability [J T^{-2}] uncertainty=0.000 000 0090 e-29 -*/
#define pc_atomic_unit_of_mass 9.10938356E-31                                     /*- atomic unit of mass [kg] uncertainty=0.000 000 11 e-31 -*/
#define pc_atomic_unit_of_momum 1.992851882E-24                                   /*- atomic unit of mom.um [kg m s^{-1}] uncertainty=0.000 000 024 e-24 -*/
#define pc_atomic_unit_of_permittivity 1.112650056E-10                            /*- atomic unit of permittivity [F m^{-1}] uncertainty=(exact) -*/
#define pc_atomic_unit_of_time 2.418884326509E-17                                 /*- atomic unit of time [s] uncertainty=0.000 000 000 014 e-17 -*/
#define pc_atomic_unit_of_velocity 2187691.26277                                  /*- atomic unit of velocity [m s^{-1}] uncertainty=0.000 000 000 50 e6 -*/
#define pc_Avogadro_constant 6.022140857E+23                                      /*- Avogadro constant [mol^{-1}] uncertainty=0.000 000 074 e23 -*/
#define pc_Bohr_magneton 9.274009994E-24                                          /*- Bohr magneton [J T^{-1}] uncertainty=0.000 0057 e-26 -*/
#define pc_Bohr_magneton_in_eVpT 0.000057883818012                                /*- Bohr magneton in eV/T [eV T^{-1}] uncertainty=0.000 000 0026 e-5 -*/
#define pc_Bohr_magneton_in_HzpT 13996245042                                      /*- Bohr magneton in Hz/T [Hz T^{-1}] uncertainty=0.000 000 086 e9 -*/
#define pc_Bohr_magneton_in_inverse_meters_per_tesla 46.68644814                  /*- Bohr magneton in inverse meters per tesla [m^{-1} T^{-1}] uncertainty=0.000 000 29 -*/
#define pc_Bohr_magneton_in_KpT 0.67171405                                        /*- Bohr magneton in K/T [K T^{-1}] uncertainty=0.000 000 39 -*/
#define pc_Bohr_radius 5.2917721067E-11                                           /*- Bohr radius [m] uncertainty=0.000 000 000 12 e-10 -*/
#define pc_Boltzmann_constant 1.38064852E-23                                      /*- Boltzmann constant [J K^{-1}] uncertainty=0.000 000 79 e-23 -*/
#define pc_Boltzmann_constant_in_eVpK 0.000086173303                              /*- Boltzmann constant in eV/K [eV K^{-1}] uncertainty=0.000 0050 e-5 -*/
#define pc_Boltzmann_constant_in_HzpK 2.0836612E+10                               /*- Boltzmann constant in Hz/K [Hz K^{-1}] uncertainty=0.000 0012 e10 -*/
#define pc_Boltzmann_constant_in_inverse_meters_per_kelvin 69.503457              /*- Boltzmann constant in inverse meters per kelvin [m^{-1} K^{-1}] uncertainty=0.000 040 -*/
#define pc_characteristic_impedance_of_vacuum 376.730313461                       /*- characteristic impedance of vacuum [ohm] uncertainty=(exact) -*/
#define pc_classical_electron_radius 2.8179403227E-15                             /*- classical electron radius [m] uncertainty=0.000 000 0019 e-15 -*/
#define pc_Compton_wavelength 2.4263102367E-12                                    /*- Compton wavelength [m] uncertainty=0.000 000 0011 e-12 -*/
#define pc_Compton_wavelength_over_2_pi 3.8615926764E-13                          /*- Compton wavelength over 2 pi [m] uncertainty=0.000 000 18 e-15 -*/
#define pc_conductance_quantum 0.000077480917310                                  /*- conductance quantum [S] uncertainty=0.000 000 0018 e-5 -*/
#define pc_conventional_value_of_Josephson_constant 4.835979E+14                  /*- conventional value of Josephson constant [Hz V^{-1}] uncertainty=(exact) -*/
#define pc_conventional_value_of_von_Klitzing_constant 25812.807                  /*- conventional value of von Klitzing constant [ohm] uncertainty=(exact) -*/
#define pc_Cu_x_unit 1.00207697E-13                                               /*- Cu x unit [m] uncertainty=0.000 000 28 e-13 -*/
#define pc_deuteron_electron_mag_mom_ratio -0.0004664345535                       /*- deuteron-electron mag. mom. ratio [] uncertainty=0.000 000 026 e-4 -*/
#define pc_deuteron_electron_mass_ratio 3670.48296785                             /*- deuteron-electron mass ratio [] uncertainty=0.000 000 13 -*/
#define pc_deuteron_g_factor 0.8574382311                                         /*- deuteron g factor [] uncertainty=0.000 000 0048 -*/
#define pc_deuteron_mag_mom 4.330735040E-27                                       /*- deuteron mag. mom. [J T^{-1}] uncertainty=0.000 000 0036 e-26 -*/
#define pc_deuteron_mag_mom_to_Bohr_magneton_ratio 0.0004669754554                /*- deuteron mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 0026 e-3 -*/
#define pc_deuteron_mag_mom_to_nuclear_magneton_ratio 0.8574382311                /*- deuteron mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 0048 -*/
#define pc_deuteron_mass 3.343583719E-27                                          /*- deuteron mass [kg] uncertainty=0.000 000 041 e-27 -*/
#define pc_deuteron_mass_energy_equivalent 3.005063183E-10                        /*- deuteron mass energy equivalent [J] uncertainty=0.000 000 037 e-10 -*/
#define pc_deuteron_mass_energy_equivalent_in_MeV 1875.612928                     /*- deuteron mass energy equivalent in MeV [MeV] uncertainty=0.000 012 -*/
#define pc_deuteron_mass_in_u 2.013553212745                                      /*- deuteron mass in u [u] uncertainty=0.000 000 000 040 -*/
#define pc_deuteron_molar_mass 0.002013553212745                                  /*- deuteron molar mass [kg mol^{-1}] uncertainty=0.000 000 000 040 e-3 -*/
#define pc_deuteron_neutron_mag_mom_ratio -0.44820652                             /*- deuteron-neutron mag. mom. ratio [] uncertainty=0.000 000 11 -*/
#define pc_deuteron_proton_mag_mom_ratio 0.3070122077                             /*- deuteron-proton mag. mom. ratio [] uncertainty=0.000 000 0015 -*/
#define pc_deuteron_proton_mass_ratio 1.99900750087                               /*- deuteron-proton mass ratio [] uncertainty=0.000 000 000 19 -*/
#define pc_deuteron_rms_charge_radius 2.1413E-15                                  /*- deuteron rms charge radius [m] uncertainty=0.0025 e-15 -*/
#define pc_electric_constant 8.854187817E-12                                      /*- electric constant [F m^{-1}] uncertainty=(exact) -*/
#define pc_electron_charge_to_mass_quotient -1.758820024E+11                      /*- electron charge to mass quotient [C kg^{-1}] uncertainty=0.000 000 011 e11 -*/
#define pc_electron_deuteron_mag_mom_ratio -2143.923499                           /*- electron-deuteron mag. mom. ratio [] uncertainty=0.000 012 -*/
#define pc_electron_deuteron_mass_ratio 0.0002724437107484                        /*- electron-deuteron mass ratio [] uncertainty=0.000 000 000 096 e-4 -*/
#define pc_electron_g_factor -2.00231930436182                                    /*- electron g factor [] uncertainty=0.000 000 000 000 52 -*/
#define pc_electron_gyromag_ratio 1.760859644E+11                                 /*- electron gyromag. ratio [s^{-1} T^{-1}] uncertainty=0.000 000 011 e11 -*/
#define pc_electron_gyromag_ratio_over_2_pi 28024.95164                           /*- electron gyromag. ratio over 2 pi [MHz T^{-1}] uncertainty=0.000 17 -*/
#define pc_electron_helion_mass_ratio 0.0001819543074854                          /*- electron-helion mass ratio [] uncertainty=0.000 000 000 088 e-4 -*/
#define pc_electron_mag_mom -9.284764620E-24                                      /*- electron mag. mom. [J T^{-1}] uncertainty=0.000 0057 e-26 -*/
#define pc_electron_mag_mom_anomaly 0.00115965218091                              /*- electron mag. mom. anomaly [] uncertainty=0.000 000 000 26 e-3 -*/
#define pc_electron_mag_mom_to_Bohr_magneton_ratio -1.00115965218091              /*- electron mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 000 000 26 -*/
#define pc_electron_mag_mom_to_nuclear_magneton_ratio -1838.28197234              /*- electron mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 17 -*/
#define pc_electron_mass 9.10938356E-31                                           /*- electron mass [kg] uncertainty=0.000 000 11 e-31 -*/
#define pc_electron_mass_energy_equivalent 8.18710565E-14                         /*- electron mass energy equivalent [J] uncertainty=0.000 000 10 e-14 -*/
#define pc_electron_mass_energy_equivalent_in_MeV 0.5109989461                    /*- electron mass energy equivalent in MeV [MeV] uncertainty=0.000 000 0031 -*/
#define pc_electron_mass_in_u 0.000548579909070                                   /*- electron mass in u [u] uncertainty=0.000 000 000 16 e-4 -*/
#define pc_electron_molar_mass 5.48579909070E-7                                   /*- electron molar mass [kg mol^{-1}] uncertainty=0.000 000 000 16 e-7 -*/
#define pc_electron_muon_mag_mom_ratio 206.7669880                                /*- electron-muon mag. mom. ratio [] uncertainty=0.000 0046 -*/
#define pc_electron_muon_mass_ratio 0.00483633170                                 /*- electron-muon mass ratio [] uncertainty=0.000 000 11 e-3 -*/
#define pc_electron_neutron_mag_mom_ratio 960.92050                               /*- electron-neutron mag. mom. ratio [] uncertainty=0.000 23 -*/
#define pc_electron_neutron_mass_ratio 0.00054386734428                           /*- electron-neutron mass ratio [] uncertainty=0.000 000 0027 e-4 -*/
#define pc_electron_proton_mag_mom_ratio -658.2106866                             /*- electron-proton mag. mom. ratio [] uncertainty=0.000 0020 -*/
#define pc_electron_proton_mass_ratio 0.000544617021352                           /*- electron-proton mass ratio [] uncertainty=0.000 000 000 52 e-4 -*/
#define pc_electron_tau_mass_ratio 0.000287592                                    /*- electron-tau mass ratio [] uncertainty=0.000 26 e-4 -*/
#define pc_electron_to_alpha_particle_mass_ratio 0.0001370933554798               /*- electron to alpha particle mass ratio [] uncertainty=0.000 000 000 045 e-4 -*/
#define pc_electron_to_shielded_helion_mag_mom_ratio 864.058257                   /*- electron to shielded helion mag. mom. ratio [] uncertainty=0.000 010 -*/
#define pc_electron_to_shielded_proton_mag_mom_ratio -658.2275971                 /*- electron to shielded proton mag. mom. ratio [] uncertainty=0.000 0072 -*/
#define pc_electron_triton_mass_ratio 0.0001819200062203                          /*- electron-triton mass ratio [] uncertainty=0.000 000 000 084 e-4 -*/
#define pc_electron_volt 1.6021766208E-19                                         /*- electron volt [J] uncertainty=0.000 000 0098 e-19 -*/
#define pc_electron_volt_atomic_mass_unit_relationship 1.0735441105E-9            /*- electron volt-atomic mass unit relationship [u] uncertainty=0.000 000 0066 e-9 -*/
#define pc_electron_volt_hartree_relationship 0.03674932248                       /*- electron volt-hartree relationship [E_h] uncertainty=0.000 000 023 e-2 -*/
#define pc_electron_volt_hertz_relationship 2.417989262E+14                       /*- electron volt-hertz relationship [Hz] uncertainty=0.000 000 015 e14 -*/
#define pc_electron_volt_inverse_meter_relationship 806554.4005                   /*- electron volt-inverse meter relationship [m^{-1}] uncertainty=0.000 000 050 e5 -*/
#define pc_electron_volt_joule_relationship 1.6021766208E-19                      /*- electron volt-joule relationship [J] uncertainty=0.000 000 0098 e-19 -*/
#define pc_electron_volt_kelvin_relationship 11604.5221                           /*- electron volt-kelvin relationship [K] uncertainty=0.000 000 67 e4 -*/
#define pc_electron_volt_kilogram_relationship 1.782661907E-36                    /*- electron volt-kilogram relationship [kg] uncertainty=0.000 000 011 e-36 -*/
#define pc_elementary_charge 1.6021766208E-19                                     /*- elementary charge [C] uncertainty=0.000 000 0098 e-19 -*/
#define pc_elementary_charge_over_h 2.417989262E+14                               /*- elementary charge over h [A J^{-1}] uncertainty=0.000 000 015 e14 -*/
#define pc_Faraday_constant 96485.33289                                           /*- Faraday constant [C mol^{-1}] uncertainty=0.000 59 -*/
#define pc_Faraday_constant_for_conventional_electric_current 96485.3251          /*- Faraday constant for conventional electric current [C_{90} mol^{-1}] uncertainty=0.0012 -*/
#define pc_Fermi_coupling_constant 0.000011663787                                 /*- Fermi coupling constant [GeV^{-2}] uncertainty=0.000 0006 e-5 -*/
#define pc_fine_structure_constant 0.0072973525664                                /*- fine-structure constant [] uncertainty=0.000 000 0017 e-3 -*/
#define pc_first_radiation_constant 3.741771790E-16                               /*- first radiation constant [W m^2] uncertainty=0.000 000 046 e-16 -*/
#define pc_first_radiation_constant_for_spectral_radiance 1.191042953E-16         /*- first radiation constant for spectral radiance [W m^2 sr^{-1}] uncertainty=0.000 000 015 e-16 -*/
#define pc_hartree_atomic_mass_unit_relationship 2.9212623197E-8                  /*- hartree-atomic mass unit relationship [u] uncertainty=0.000 000 0013 e-8 -*/
#define pc_hartree_electron_volt_relationship 27.21138602                         /*- hartree-electron volt relationship [eV] uncertainty=0.000 000 17 -*/
#define pc_Hartree_energy 4.359744650E-18                                         /*- Hartree energy [J] uncertainty=0.000 000 054 e-18 -*/
#define pc_Hartree_energy_in_eV 27.21138602                                       /*- Hartree energy in eV [eV] uncertainty=0.000 000 17 -*/
#define pc_hartree_hertz_relationship 6.579683920711E+15                          /*- hartree-hertz relationship [Hz] uncertainty=0.000 000 000 039 e15 -*/
#define pc_hartree_inverse_meter_relationship 21947463.13702                      /*- hartree-inverse meter relationship [m^{-1}] uncertainty=0.000 000 000 013 e7 -*/
#define pc_hartree_joule_relationship 4.359744650E-18                             /*- hartree-joule relationship [J] uncertainty=0.000 000 054 e-18 -*/
#define pc_hartree_kelvin_relationship 315775.13                                  /*- hartree-kelvin relationship [K] uncertainty=0.000 0018 e5 -*/
#define pc_hartree_kilogram_relationship 4.850870129E-35                          /*- hartree-kilogram relationship [kg] uncertainty=0.000 000 060 e-35 -*/
#define pc_helion_electron_mass_ratio 5495.88527922                               /*- helion-electron mass ratio [] uncertainty=0.000 000 27 -*/
#define pc_helion_g_factor -4.255250616                                           /*- helion g factor [] uncertainty=0.000 000 050 -*/
#define pc_helion_mag_mom -1.074617522E-26                                        /*- helion mag. mom. [J T^{-1}] uncertainty=0.000 000 014 e-26 -*/
#define pc_helion_mag_mom_to_Bohr_magneton_ratio -0.001158740958                  /*- helion mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 014 e-3 -*/
#define pc_helion_mag_mom_to_nuclear_magneton_ratio -2.127625308                  /*- helion mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 025 -*/
#define pc_helion_mass 5.006412700E-27                                            /*- helion mass [kg] uncertainty=0.000 000 062 e-27 -*/
#define pc_helion_mass_energy_equivalent 4.499539341E-10                          /*- helion mass energy equivalent [J] uncertainty=0.000 000 055 e-10 -*/
#define pc_helion_mass_energy_equivalent_in_MeV 2808.391586                       /*- helion mass energy equivalent in MeV [MeV] uncertainty=0.000 017 -*/
#define pc_helion_mass_in_u 3.01493224673                                         /*- helion mass in u [u] uncertainty=0.000 000 000 12 -*/
#define pc_helion_molar_mass 0.00301493224673                                     /*- helion molar mass [kg mol^{-1}] uncertainty=0.000 000 000 12 e-3 -*/
#define pc_helion_proton_mass_ratio 2.99315267046                                 /*- helion-proton mass ratio [] uncertainty=0.000 000 000 29 -*/
#define pc_hertz_atomic_mass_unit_relationship 4.4398216616E-24                   /*- hertz-atomic mass unit relationship [u] uncertainty=0.000 000 0020 e-24 -*/
#define pc_hertz_electron_volt_relationship 4.135667662E-15                       /*- hertz-electron volt relationship [eV] uncertainty=0.000 000 025 e-15 -*/
#define pc_hertz_hartree_relationship 1.5198298460088E-16                         /*- hertz-hartree relationship [E_h] uncertainty=0.000 000 000 0090 e-16 -*/
#define pc_hertz_inverse_meter_relationship 3.335640951E-9                        /*- hertz-inverse meter relationship [m^{-1}] uncertainty=(exact) -*/
#define pc_hertz_joule_relationship 6.626070040E-34                               /*- hertz-joule relationship [J] uncertainty=0.000 000 081 e-34 -*/
#define pc_hertz_kelvin_relationship 4.7992447E-11                                /*- hertz-kelvin relationship [K] uncertainty=0.000 0028 e-11 -*/
#define pc_hertz_kilogram_relationship 7.372497201E-51                            /*- hertz-kilogram relationship [kg] uncertainty=0.000 000 091 e-51 -*/
#define pc_inverse_fine_structure_constant 137.035999139                          /*- inverse fine-structure constant [] uncertainty=0.000 000 031 -*/
#define pc_inverse_meter_atomic_mass_unit_relationship 1.33102504900E-15          /*- inverse meter-atomic mass unit relationship [u] uncertainty=0.000 000 000 61 e-15 -*/
#define pc_inverse_meter_electron_volt_relationship 0.0000012398419739            /*- inverse meter-electron volt relationship [eV] uncertainty=0.000 000 0076 e-6 -*/
#define pc_inverse_meter_hartree_relationship 4.556335252767E-8                   /*- inverse meter-hartree relationship [E_h] uncertainty=0.000 000 000 027 e-8 -*/
#define pc_inverse_meter_hertz_relationship 299792458                             /*- inverse meter-hertz relationship [Hz] uncertainty=(exact) -*/
#define pc_inverse_meter_joule_relationship 1.986445824E-25                       /*- inverse meter-joule relationship [J] uncertainty=0.000 000 024 e-25 -*/
#define pc_inverse_meter_kelvin_relationship 0.0143877736                         /*- inverse meter-kelvin relationship [K] uncertainty=0.000 000 83 e-2 -*/
#define pc_inverse_meter_kilogram_relationship 2.210219057E-42                    /*- inverse meter-kilogram relationship [kg] uncertainty=0.000 000 027 e-42 -*/
#define pc_inverse_of_conductance_quantum 12906.4037278                           /*- inverse of conductance quantum [ohm] uncertainty=0.000 0029 -*/
#define pc_Josephson_constant 4.835978525E+14                                     /*- Josephson constant [Hz V^{-1}] uncertainty=0.0030 e9 -*/
#define pc_joule_atomic_mass_unit_relationship 6700535363                         /*- joule-atomic mass unit relationship [u] uncertainty=0.000 000 082 e9 -*/
#define pc_joule_electron_volt_relationship 6.241509126E+18                       /*- joule-electron volt relationship [eV] uncertainty=0.000 000 038 e18 -*/
#define pc_joule_hartree_relationship 2.293712317E+17                             /*- joule-hartree relationship [E_h] uncertainty=0.000 000 028 e17 -*/
#define pc_joule_hertz_relationship 1.509190205E+33                               /*- joule-hertz relationship [Hz] uncertainty=0.000 000 019 e33 -*/
#define pc_joule_inverse_meter_relationship 5.034116651E+24                       /*- joule-inverse meter relationship [m^{-1}] uncertainty=0.000 000 062 e24 -*/
#define pc_joule_kelvin_relationship 7.2429731E+22                                /*- joule-kelvin relationship [K] uncertainty=0.000 0042 e22 -*/
#define pc_joule_kilogram_relationship 1.112650056E-17                            /*- joule-kilogram relationship [kg] uncertainty=(exact) -*/
#define pc_kelvin_atomic_mass_unit_relationship 9.2510842E-14                     /*- kelvin-atomic mass unit relationship [u] uncertainty=0.000 0053 e-14 -*/
#define pc_kelvin_electron_volt_relationship 0.000086173303                       /*- kelvin-electron volt relationship [eV] uncertainty=0.000 0050 e-5 -*/
#define pc_kelvin_hartree_relationship 0.0000031668105                            /*- kelvin-hartree relationship [E_h] uncertainty=0.000 0018 e-6 -*/
#define pc_kelvin_hertz_relationship 2.0836612E+10                                /*- kelvin-hertz relationship [Hz] uncertainty=0.000 0012 e10 -*/
#define pc_kelvin_inverse_meter_relationship 69.503457                            /*- kelvin-inverse meter relationship [m^{-1}] uncertainty=0.000 040 -*/
#define pc_kelvin_joule_relationship 1.38064852E-23                               /*- kelvin-joule relationship [J] uncertainty=0.000 000 79 e-23 -*/
#define pc_kelvin_kilogram_relationship 1.53617865E-40                            /*- kelvin-kilogram relationship [kg] uncertainty=0.000 000 88 e-40 -*/
#define pc_kilogram_atomic_mass_unit_relationship 6.022140857E+26                 /*- kilogram-atomic mass unit relationship [u] uncertainty=0.000 000 074 e26 -*/
#define pc_kilogram_electron_volt_relationship 5.609588650E+35                    /*- kilogram-electron volt relationship [eV] uncertainty=0.000 000 034 e35 -*/
#define pc_kilogram_hartree_relationship 2.061485823E+34                          /*- kilogram-hartree relationship [E_h] uncertainty=0.000 000 025 e34 -*/
#define pc_kilogram_hertz_relationship 1.356392512E+50                            /*- kilogram-hertz relationship [Hz] uncertainty=0.000 000 017 e50 -*/
#define pc_kilogram_inverse_meter_relationship 4.524438411E+41                    /*- kilogram-inverse meter relationship [m^{-1}] uncertainty=0.000 000 056 e41 -*/
#define pc_kilogram_joule_relationship 8.987551787E+16                            /*- kilogram-joule relationship [J] uncertainty=(exact) -*/
#define pc_kilogram_kelvin_relationship 6.5096595E+39                             /*- kilogram-kelvin relationship [K] uncertainty=0.000 0037 e39 -*/
#define pc_lattice_parameter_of_silicon 5.431020504E-10                           /*- lattice parameter of silicon [m] uncertainty=0.000 0089 e-12 -*/
#define pc_Loschmidt_constant_27315_K_100_kPa 2.6516467E+25                       /*- Loschmidt constant (273.15 K, 100 kPa) [m^{-3}] uncertainty=0.000 0015 e25 -*/
#define pc_Loschmidt_constant_27315_K_101325_kPa 2.6867811E+25                    /*- Loschmidt constant (273.15 K, 101.325 kPa) [m^{-3}] uncertainty=0.000 0015 e25 -*/
#define pc_mag_constant 0.0000012566370614                                        /*- mag. constant [N A^{-2}] uncertainty=(exact) -*/
#define pc_mag_flux_quantum 2.067833831E-15                                       /*- mag. flux quantum [Wb] uncertainty=0.000 000 013 e-15 -*/
#define pc_molar_gas_constant 8.3144598                                           /*- molar gas constant [J mol^{-1} K^{-1}] uncertainty=0.000 0048 -*/
#define pc_molar_mass_constant 0.001                                              /*- molar mass constant [kg mol^{-1}] uncertainty=(exact) -*/
#define pc_molar_mass_of_carbon_12 0.012                                          /*- molar mass of carbon-12 [kg mol^{-1}] uncertainty=(exact) -*/
#define pc_molar_Planck_constant 3.9903127110E-10                                 /*- molar Planck constant [J s mol^{-1}] uncertainty=0.000 000 0018 e-10 -*/
#define pc_molar_Planck_constant_times_c 0.119626565582                           /*- molar Planck constant times c [J m mol^{-1}] uncertainty=0.000 000 000 054 -*/
#define pc_molar_volume_of_ideal_gas_27315_K_100_kPa 0.022710947                  /*- molar volume of ideal gas (273.15 K, 100 kPa) [m^3 mol^{-1}] uncertainty=0.000 013 e-3 -*/
#define pc_molar_volume_of_ideal_gas_27315_K_101325_kPa 0.022413962               /*- molar volume of ideal gas (273.15 K, 101.325 kPa) [m^3 mol^{-1}] uncertainty=0.000 013 e-3 -*/
#define pc_molar_volume_of_silicon 0.00001205883214                               /*- molar volume of silicon [m^3 mol^{-1}] uncertainty=0.000 000 61 e-6 -*/
#define pc_Mo_x_unit 1.00209952E-13                                               /*- Mo x unit [m] uncertainty=0.000 000 53 e-13 -*/
#define pc_muon_Compton_wavelength 1.173444111E-14                                /*- muon Compton wavelength [m] uncertainty=0.000 000 26 e-15 -*/
#define pc_muon_Compton_wavelength_over_2_pi 1.867594308E-15                      /*- muon Compton wavelength over 2 pi [m] uncertainty=0.000 000 042 e-15 -*/
#define pc_muon_electron_mass_ratio 206.7682826                                   /*- muon-electron mass ratio [] uncertainty=0.000 0046 -*/
#define pc_muon_g_factor -2.0023318418                                            /*- muon g factor [] uncertainty=0.000 000 0013 -*/
#define pc_muon_mag_mom -4.49044826E-26                                           /*- muon mag. mom. [J T^{-1}] uncertainty=0.000 000 10 e-26 -*/
#define pc_muon_mag_mom_anomaly 0.00116592089                                     /*- muon mag. mom. anomaly [] uncertainty=0.000 000 63 e-3 -*/
#define pc_muon_mag_mom_to_Bohr_magneton_ratio -0.00484197048                     /*- muon mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 11 e-3 -*/
#define pc_muon_mag_mom_to_nuclear_magneton_ratio -8.89059705                     /*- muon mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 20 -*/
#define pc_muon_mass 1.883531594E-28                                              /*- muon mass [kg] uncertainty=0.000 000 048 e-28 -*/
#define pc_muon_mass_energy_equivalent 1.692833774E-11                            /*- muon mass energy equivalent [J] uncertainty=0.000 000 043 e-11 -*/
#define pc_muon_mass_energy_equivalent_in_MeV 105.6583745                         /*- muon mass energy equivalent in MeV [MeV] uncertainty=0.000 0024 -*/
#define pc_muon_mass_in_u 0.1134289257                                            /*- muon mass in u [u] uncertainty=0.000 000 0025 -*/
#define pc_muon_molar_mass 0.0001134289257                                        /*- muon molar mass [kg mol^{-1}] uncertainty=0.000 000 0025 e-3 -*/
#define pc_muon_neutron_mass_ratio 0.1124545167                                   /*- muon-neutron mass ratio [] uncertainty=0.000 000 0025 -*/
#define pc_muon_proton_mag_mom_ratio -3.183345142                                 /*- muon-proton mag. mom. ratio [] uncertainty=0.000 000 071 -*/
#define pc_muon_proton_mass_ratio 0.1126095262                                    /*- muon-proton mass ratio [] uncertainty=0.000 000 0025 -*/
#define pc_muon_tau_mass_ratio 0.0594649                                          /*- muon-tau mass ratio [] uncertainty=0.000 54 e-2 -*/
#define pc_natural_unit_of_action 1.054571800E-34                                 /*- natural unit of action [J s] uncertainty=0.000 000 013 e-34 -*/
#define pc_natural_unit_of_action_in_eV_s 6.582119514E-16                         /*- natural unit of action in eV s [eV s] uncertainty=0.000 000 040 e-16 -*/
#define pc_natural_unit_of_energy 8.18710565E-14                                  /*- natural unit of energy [J] uncertainty=0.000 000 10 e-14 -*/
#define pc_natural_unit_of_energy_in_MeV 0.5109989461                             /*- natural unit of energy in MeV [MeV] uncertainty=0.000 000 0031 -*/
#define pc_natural_unit_of_length 3.8615926764E-13                                /*- natural unit of length [m] uncertainty=0.000 000 18 e-15 -*/
#define pc_natural_unit_of_mass 9.10938356E-31                                    /*- natural unit of mass [kg] uncertainty=0.000 000 11 e-31 -*/
#define pc_natural_unit_of_momum 2.730924488E-22                                  /*- natural unit of mom.um [kg m s^{-1}] uncertainty=0.000 000 034 e-22 -*/
#define pc_natural_unit_of_momum_in_MeVpc 0.5109989461                            /*- natural unit of mom.um in MeV/c [MeV/c] uncertainty=0.000 000 0031 -*/
#define pc_natural_unit_of_time 1.28808866712E-21                                 /*- natural unit of time [s] uncertainty=0.000 000 000 58 e-21 -*/
#define pc_natural_unit_of_velocity 299792458                                     /*- natural unit of velocity [m s^{-1}] uncertainty=(exact) -*/
#define pc_neutron_Compton_wavelength 1.31959090481E-15                           /*- neutron Compton wavelength [m] uncertainty=0.000 000 000 88 e-15 -*/
#define pc_neutron_Compton_wavelength_over_2_pi 2.1001941536E-16                  /*- neutron Compton wavelength over 2 pi [m] uncertainty=0.000 000 000 14 e-15 -*/
#define pc_neutron_electron_mag_mom_ratio 0.00104066882                           /*- neutron-electron mag. mom. ratio [] uncertainty=0.000 000 25 e-3 -*/
#define pc_neutron_electron_mass_ratio 1838.68366158                              /*- neutron-electron mass ratio [] uncertainty=0.000 000 90 -*/
#define pc_neutron_g_factor -3.82608545                                           /*- neutron g factor [] uncertainty=0.000 000 90 -*/
#define pc_neutron_gyromag_ratio 183247172                                        /*- neutron gyromag. ratio [s^{-1} T^{-1}] uncertainty=0.000 000 43 e8 -*/
#define pc_neutron_gyromag_ratio_over_2_pi 29.1646933                             /*- neutron gyromag. ratio over 2 pi [MHz T^{-1}] uncertainty=0.000 0069 -*/
#define pc_neutron_mag_mom -9.6623650E-27                                         /*- neutron mag. mom. [J T^{-1}] uncertainty=0.000 000 23 e-26 -*/
#define pc_neutron_mag_mom_to_Bohr_magneton_ratio -0.00104187563                  /*- neutron mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 25 e-3 -*/
#define pc_neutron_mag_mom_to_nuclear_magneton_ratio -1.91304273                  /*- neutron mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 45 -*/
#define pc_neutron_mass 1.674927471E-27                                           /*- neutron mass [kg] uncertainty=0.000 000 021 e-27 -*/
#define pc_neutron_mass_energy_equivalent 1.505349739E-10                         /*- neutron mass energy equivalent [J] uncertainty=0.000 000 019 e-10 -*/
#define pc_neutron_mass_energy_equivalent_in_MeV 939.5654133                      /*- neutron mass energy equivalent in MeV [MeV] uncertainty=0.000 0058 -*/
#define pc_neutron_mass_in_u 1.00866491588                                        /*- neutron mass in u [u] uncertainty=0.000 000 000 49 -*/
#define pc_neutron_molar_mass 0.00100866491588                                    /*- neutron molar mass [kg mol^{-1}] uncertainty=0.000 000 000 49 e-3 -*/
#define pc_neutron_muon_mass_ratio 8.89248408                                     /*- neutron-muon mass ratio [] uncertainty=0.000 000 20 -*/
#define pc_neutron_proton_mag_mom_ratio -0.68497934                               /*- neutron-proton mag. mom. ratio [] uncertainty=0.000 000 16 -*/
#define pc_neutron_proton_mass_difference 2.30557377E-30                          /*- neutron-proton mass difference [] uncertainty=0.000 000 85 e-30 -*/
#define pc_neutron_proton_mass_difference_energy_equivalent 2.07214637E-13        /*- neutron-proton mass difference energy equivalent [] uncertainty=0.000 000 76 e-13 -*/
#define pc_neutron_proton_mass_difference_energy_equivalent_in_MeV 1.29333205     /*- neutron-proton mass difference energy equivalent in MeV [] uncertainty=0.000 000 48 -*/
#define pc_neutron_proton_mass_difference_in_u 0.00138844900                      /*- neutron-proton mass difference in u [] uncertainty=0.000 000 000 51 -*/
#define pc_neutron_proton_mass_ratio 1.00137841898                                /*- neutron-proton mass ratio [] uncertainty=0.000 000 000 51 -*/
#define pc_neutron_tau_mass_ratio 0.528790                                        /*- neutron-tau mass ratio [] uncertainty=0.000 048 -*/
#define pc_neutron_to_shielded_proton_mag_mom_ratio -0.68499694                   /*- neutron to shielded proton mag. mom. ratio [] uncertainty=0.000 000 16 -*/
#define pc_Newtonian_constant_of_gravitation 6.67408E-11                          /*- Newtonian constant of gravitation [m^3 kg^{-1} s^{-2}] uncertainty=0.000 31 e-11 -*/
#define pc_Newtonian_constant_of_gravitation_over_h_bar_c 6.70861E-39             /*- Newtonian constant of gravitation over h-bar c [(GeV/c^2)^-2] uncertainty=0.000 31 e-39 -*/
#define pc_nuclear_magneton 5.050783699E-27                                       /*- nuclear magneton [J T^{-1}] uncertainty=0.000 000 031 e-27 -*/
#define pc_nuclear_magneton_in_eVpT 3.1524512550E-8                               /*- nuclear magneton in eV/T [eV T^{-1}] uncertainty=0.000 000 0015 e-8 -*/
#define pc_nuclear_magneton_in_inverse_meters_per_tesla 0.02542623432             /*- nuclear magneton in inverse meters per tesla [m^{-1} T^{-1}] uncertainty=0.000 000 016 e-2 -*/
#define pc_nuclear_magneton_in_KpT 0.00036582690                                  /*- nuclear magneton in K/T [K T^{-1}] uncertainty=0.000 0021 e-4 -*/
#define pc_nuclear_magneton_in_MHzpT 7.622593285                                  /*- nuclear magneton in MHz/T [MHz T^{-1}] uncertainty=0.000 000 047 -*/
#define pc_Planck_constant 6.626070040E-34                                        /*- Planck constant [J s] uncertainty=0.000 000 081 e-34 -*/
#define pc_Planck_constant_in_eV_s 4.135667662E-15                                /*- Planck constant in eV s [eV s] uncertainty=0.000 000 025 e-15 -*/
#define pc_Planck_constant_over_2_pi 1.054571800E-34                              /*- Planck constant over 2 pi [J s] uncertainty=0.000 000 013 e-34 -*/
#define pc_Planck_constant_over_2_pi_in_eV_s 6.582119514E-16                      /*- Planck constant over 2 pi in eV s [eV s] uncertainty=0.000 000 040 e-16 -*/
#define pc_Planck_constant_over_2_pi_times_c_in_MeV_fm 197.3269788                /*- Planck constant over 2 pi times c in MeV fm [MeV fm] uncertainty=0.000 0012 -*/
#define pc_Planck_length 1.616229E-35                                             /*- Planck length [m] uncertainty=0.000 038 e-35 -*/
#define pc_Planck_mass 2.176470E-8                                                /*- Planck mass [kg] uncertainty=0.000 051 e-8 -*/
#define pc_Planck_mass_energy_equivalent_in_GeV 1.220910E+19                      /*- Planck mass energy equivalent in GeV [GeV] uncertainty=0.000 029 e19 -*/
#define pc_Planck_temperature 1.416808E+32                                        /*- Planck temperature [K] uncertainty=0.000 033 e32 -*/
#define pc_Planck_time 5.39116E-44                                                /*- Planck time [s] uncertainty=0.000 13 e-44 -*/
#define pc_proton_charge_to_mass_quotient 95788332.26                             /*- proton charge to mass quotient [C kg^{-1}] uncertainty=0.000 000 059 e7 -*/
#define pc_proton_Compton_wavelength 1.32140985396E-15                            /*- proton Compton wavelength [m] uncertainty=0.000 000 000 61 e-15 -*/
#define pc_proton_Compton_wavelength_over_2_pi 2.10308910109E-16                  /*- proton Compton wavelength over 2 pi [m] uncertainty=0.000 000 000 097 e-15 -*/
#define pc_proton_electron_mass_ratio 1836.15267389                               /*- proton-electron mass ratio [] uncertainty=0.000 000 17 -*/
#define pc_proton_g_factor 5.585694702                                            /*- proton g factor [] uncertainty=0.000 000 017 -*/
#define pc_proton_gyromag_ratio 267522190.0                                       /*- proton gyromag. ratio [s^{-1} T^{-1}] uncertainty=0.000 000 018 e8 -*/
#define pc_proton_gyromag_ratio_over_2_pi 42.57747892                             /*- proton gyromag. ratio over 2 pi [MHz T^{-1}] uncertainty=0.000 000 29 -*/
#define pc_proton_mag_mom 1.4106067873E-26                                        /*- proton mag. mom. [J T^{-1}] uncertainty=0.000 000 0097 e-26 -*/
#define pc_proton_mag_mom_to_Bohr_magneton_ratio 0.0015210322053                  /*- proton mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 0046 e-3 -*/
#define pc_proton_mag_mom_to_nuclear_magneton_ratio 2.7928473508                  /*- proton mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 0085 -*/
#define pc_proton_mag_shielding_correction 0.000025691                            /*- proton mag. shielding correction [] uncertainty=0.011 e-6 -*/
#define pc_proton_mass 1.672621898E-27                                            /*- proton mass [kg] uncertainty=0.000 000 021 e-27 -*/
#define pc_proton_mass_energy_equivalent 1.503277593E-10                          /*- proton mass energy equivalent [J] uncertainty=0.000 000 018 e-10 -*/
#define pc_proton_mass_energy_equivalent_in_MeV 938.2720813                       /*- proton mass energy equivalent in MeV [MeV] uncertainty=0.000 0058 -*/
#define pc_proton_mass_in_u 1.007276466879                                        /*- proton mass in u [u] uncertainty=0.000 000 000 091 -*/
#define pc_proton_molar_mass 0.001007276466879                                    /*- proton molar mass [kg mol^{-1}] uncertainty=0.000 000 000 091 e-3 -*/
#define pc_proton_muon_mass_ratio 8.88024338                                      /*- proton-muon mass ratio [] uncertainty=0.000 000 20 -*/
#define pc_proton_neutron_mag_mom_ratio -1.45989805                               /*- proton-neutron mag. mom. ratio [] uncertainty=0.000 000 34 -*/
#define pc_proton_neutron_mass_ratio 0.99862347844                                /*- proton-neutron mass ratio [] uncertainty=0.000 000 000 51 -*/
#define pc_proton_rms_charge_radius 8.751E-16                                     /*- proton rms charge radius [m] uncertainty=0.0061 e-15 -*/
#define pc_proton_tau_mass_ratio 0.528063                                         /*- proton-tau mass ratio [] uncertainty=0.000 048 -*/
#define pc_quantum_of_circulation 0.00036369475486                                /*- quantum of circulation [m^2 s^{-1}] uncertainty=0.000 000 0017 e-4 -*/
#define pc_quantum_of_circulation_times_2 0.00072738950972                        /*- quantum of circulation times 2 [m^2 s^{-1}] uncertainty=0.000 000 0033 e-4 -*/
#define pc_Rydberg_constant 10973731.568508                                       /*- Rydberg constant [m^{-1}] uncertainty=0.000 065 -*/
#define pc_Rydberg_constant_times_c_in_Hz 3.289841960355E+15                      /*- Rydberg constant times c in Hz [Hz] uncertainty=0.000 000 000 019 e15 -*/
#define pc_Rydberg_constant_times_hc_in_eV 13.605693009                           /*- Rydberg constant times hc in eV [eV] uncertainty=0.000 000 084 -*/
#define pc_Rydberg_constant_times_hc_in_J 2.179872325E-18                         /*- Rydberg constant times hc in J [J] uncertainty=0.000 000 027 e-18 -*/
#define pc_Sackur_Tetrode_constant_1_K_100_kPa -1.1517084                         /*- Sackur-Tetrode constant (1 K, 100 kPa) [] uncertainty=0.000 0014 -*/
#define pc_Sackur_Tetrode_constant_1_K_101325_kPa -1.1648714                      /*- Sackur-Tetrode constant (1 K, 101.325 kPa) [] uncertainty=0.000 0014 -*/
#define pc_second_radiation_constant 0.0143877736                                 /*- second radiation constant [m K] uncertainty=0.000 000 83 e-2 -*/
#define pc_shielded_helion_gyromag_ratio 203789458.5                              /*- shielded helion gyromag. ratio [s^{-1} T^{-1}] uncertainty=0.000 000 027 e8 -*/
#define pc_shielded_helion_gyromag_ratio_over_2_pi 32.43409966                    /*- shielded helion gyromag. ratio over 2 pi [MHz T^{-1}] uncertainty=0.000 000 43 -*/
#define pc_shielded_helion_mag_mom -1.074553080E-26                               /*- shielded helion mag. mom. [J T^{-1}] uncertainty=0.000 000 014 e-26 -*/
#define pc_shielded_helion_mag_mom_to_Bohr_magneton_ratio -0.001158671471         /*- shielded helion mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 014 e-3 -*/
#define pc_shielded_helion_mag_mom_to_nuclear_magneton_ratio -2.127497720         /*- shielded helion mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 025 -*/
#define pc_shielded_helion_to_proton_mag_mom_ratio -0.7617665603                  /*- shielded helion to proton mag. mom. ratio [] uncertainty=0.000 000 0092 -*/
#define pc_shielded_helion_to_shielded_proton_mag_mom_ratio -0.7617861313         /*- shielded helion to shielded proton mag. mom. ratio [] uncertainty=0.000 000 0033 -*/
#define pc_shielded_proton_gyromag_ratio 267515317.1                              /*- shielded proton gyromag. ratio [s^{-1} T^{-1}] uncertainty=0.000 000 033 e8 -*/
#define pc_shielded_proton_gyromag_ratio_over_2_pi 42.57638507                    /*- shielded proton gyromag. ratio over 2 pi [MHz T^{-1}] uncertainty=0.000 000 53 -*/
#define pc_shielded_proton_mag_mom 1.410570547E-26                                /*- shielded proton mag. mom. [J T^{-1}] uncertainty=0.000 000 018 e-26 -*/
#define pc_shielded_proton_mag_mom_to_Bohr_magneton_ratio 0.001520993128          /*- shielded proton mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 017 e-3 -*/
#define pc_shielded_proton_mag_mom_to_nuclear_magneton_ratio 2.792775600          /*- shielded proton mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 030 -*/
#define pc_speed_of_light_in_vacuum 299792458                                     /*- speed of light in vacuum [m s^{-1}] uncertainty=(exact) -*/
#define pc_standard_acceleration_of_gravity 9.80665                               /*- standard acceleration of gravity [m s^{-2}] uncertainty=(exact) -*/
#define pc_standard_atmosphere 101325                                             /*- standard atmosphere [Pa] uncertainty=(exact) -*/
#define pc_standard_state_pressure 100000                                         /*- standard-state pressure [Pa] uncertainty=(exact) -*/
#define pc_Stefan_Boltzmann_constant 5.670367E-8                                  /*- Stefan-Boltzmann constant [W m^{-2} K^{-4}] uncertainty=0.000 013 e-8 -*/
#define pc_tau_Compton_wavelength 6.97787E-16                                     /*- tau Compton wavelength [m] uncertainty=0.000 063 e-15 -*/
#define pc_tau_Compton_wavelength_over_2_pi 1.11056E-16                           /*- tau Compton wavelength over 2 pi [m] uncertainty=0.000 010 e-15 -*/
#define pc_tau_electron_mass_ratio 3477.15                                        /*- tau-electron mass ratio [] uncertainty=0.31 -*/
#define pc_tau_mass 3.16747E-27                                                   /*- tau mass [kg] uncertainty=0.000 29 e-27 -*/
#define pc_tau_mass_energy_equivalent 2.84678E-10                                 /*- tau mass energy equivalent [J] uncertainty=0.000 26 e-10 -*/
#define pc_tau_mass_energy_equivalent_in_MeV 1776.82                              /*- tau mass energy equivalent in MeV [MeV] uncertainty=0.16 -*/
#define pc_tau_mass_in_u 1.90749                                                  /*- tau mass in u [u] uncertainty=0.000 17 -*/
#define pc_tau_molar_mass 0.00190749                                              /*- tau molar mass [kg mol^{-1}] uncertainty=0.000 17 e-3 -*/
#define pc_tau_muon_mass_ratio 16.8167                                            /*- tau-muon mass ratio [] uncertainty=0.0015 -*/
#define pc_tau_neutron_mass_ratio 1.89111                                         /*- tau-neutron mass ratio [] uncertainty=0.000 17 -*/
#define pc_tau_proton_mass_ratio 1.89372                                          /*- tau-proton mass ratio [] uncertainty=0.000 17 -*/
#define pc_Thomson_cross_section 6.6524587158E-29                                 /*- Thomson cross section [m^2] uncertainty=0.000 000 000 91 e-28 -*/
#define pc_triton_electron_mass_ratio 5496.92153588                               /*- triton-electron mass ratio [] uncertainty=0.000 000 26 -*/
#define pc_triton_g_factor 5.957924920                                            /*- triton g factor [] uncertainty=0.000 000 028 -*/
#define pc_triton_mag_mom 1.504609503E-26                                         /*- triton mag. mom. [J T^{-1}] uncertainty=0.000 000 012 e-26 -*/
#define pc_triton_mag_mom_to_Bohr_magneton_ratio 0.0016223936616                  /*- triton mag. mom. to Bohr magneton ratio [] uncertainty=0.000 000 0076 e-3 -*/
#define pc_triton_mag_mom_to_nuclear_magneton_ratio 2.978962460                   /*- triton mag. mom. to nuclear magneton ratio [] uncertainty=0.000 000 014 -*/
#define pc_triton_mass 5.007356665E-27                                            /*- triton mass [kg] uncertainty=0.000 000 062 e-27 -*/
#define pc_triton_mass_energy_equivalent 4.500387735E-10                          /*- triton mass energy equivalent [J] uncertainty=0.000 000 055 e-10 -*/
#define pc_triton_mass_energy_equivalent_in_MeV 2808.921112                       /*- triton mass energy equivalent in MeV [MeV] uncertainty=0.000 017 -*/
#define pc_triton_mass_in_u 3.01550071632                                         /*- triton mass in u [u] uncertainty=0.000 000 000 11 -*/
#define pc_triton_molar_mass 0.00301550071632                                     /*- triton molar mass [kg mol^{-1}] uncertainty=0.000 000 000 11 e-3 -*/
#define pc_triton_proton_mass_ratio 2.99371703348                                 /*- triton-proton mass ratio [] uncertainty=0.000 000 000 22 -*/
#define pc_unified_atomic_mass_unit 1.660539040E-27                               /*- unified atomic mass unit [kg] uncertainty=0.000 000 020 e-27 -*/
#define pc_von_Klitzing_constant 25812.8074555                                    /*- von Klitzing constant [ohm] uncertainty=0.000 0059 -*/
#define pc_weak_mixing_angle 0.2223                                               /*- weak mixing angle [] uncertainty=0.0021 -*/
#define pc_Wien_frequency_displacement_law_constant 5.8789238E+10                 /*- Wien frequency displacement law constant [Hz K^{-1}] uncertainty=0.000 0034 e10 -*/
#define pc_Wien_wavelength_displacement_law_constant 0.0028977729                 /*- Wien wavelength displacement law constant [m K] uncertainty=0.000 0017 e-3 -*/
#define pc_calorie_joule_relationship 4.184                                       /*- calorie-joule relationship [J] uncertainty=(exact) -*/
#define pc_h 6.626070040E-34                                                      /*- h [J] The Planck constant (Js) -*/
#define pc_c 299792458                                                            /*- c [Hz] Speed of light (ms$^{-1}$) -*/
#define pc_kb 1.38064852E-23                                                      /*- kb [J] The Boltzmann constant (JK$^{-1}$) -*/
#define pc_R 8.3144598                                                            /*- R [J mol^-1 K^-1] Universal gas constant (JK$^{-1}$mol$^{-1}$) -*/
#define pc_bohr2angstroms 0.52917721067                                           /*- bohr2angstroms [AA] Bohr to Angstroms conversion factor -*/
#define pc_bohr2m 5.2917721067E-11                                                /*- bohr2m [m] Bohr to meters conversion factor -*/
#define pc_bohr2cm 5.291772106700E-9                                              /*- bohr2cm [cm] Bohr to centimeters conversion factor -*/
#define pc_amu2g 1.660539040000E-24                                               /*- amu2g [g] Atomic mass units to grams conversion factor -*/
#define pc_amu2kg 1.660539040E-27                                                 /*- amu2kg [kg] Atomic mass units to kg conversion factor -*/
#define pc_au2amu 0.000548579909070                                               /*- au2amu [u] Atomic units (m$@@e$) to atomic mass units conversion factor -*/
#define pc_hartree2J 4.359744650E-18                                              /*- hartree2J [J] Hartree to joule conversion factor -*/
#define pc_hartree2aJ 4.359744650                                                 /*- hartree2aJ [aJ] Hartree to attojoule (10$^{-18}$J) conversion factor -*/
#define pc_cal2J 4.184                                                            /*- cal2J [J] Calorie to joule conversion factor -*/
#define pc_dipmom_au2si 8.478353552E-30                                           /*- dipmom_au2si [C m] Atomic units to SI units (Cm) conversion factor for dipoles -*/
#define pc_dipmom_au2debye 2.541746451895025916414946904                          /*- dipmom_au2debye [???] Atomic units to Debye conversion factor for dipoles -*/
#define pc_dipmom_debye2si 3.335640951E-30                                        /*- dipmom_debye2si [???] Debye to SI units (Cm) conversion factor for dipoles -*/
#define pc_c_au 137.035999139                                                     /*- c_au [] Speed of light in atomic units -*/
#define pc_hartree2ev 27.21138602                                                 /*- hartree2ev [eV] Hartree to eV conversion factor -*/
#define pc_hartree2wavenumbers 219474.6313702                                     /*- hartree2wavenumbers [cm^-1] Hartree to cm$^{-1}$ conversion factor -*/
#define pc_hartree2kcalmol 627.5094737775374055927342256                          /*- hartree2kcalmol [kcal mol^-1] Hartree to kcal mol$^{-1}$ conversion factor -*/
#define pc_hartree2kJmol 2625.4996382852165050                                    /*- hartree2kJmol [kJ mol^-1] Hartree to kilojoule mol$^{-1}$ conversion factor -*/
#define pc_hartree2MHz 6579683920.711                                             /*- hartree2MHz [MHz] Hartree to MHz conversion factor -*/
#define pc_kcalmol2wavenumbers 349.7550882318031839256652313                      /*- kcalmol2wavenumbers [kcal cm mol^-1] kcal mol$^{-1}$ to cm$^{-1}$ conversion factor -*/
#define pc_e0 8.854187817E-12                                                     /*- e0 [F m^-1] Vacuum permittivity (Fm$^{-1}$) -*/
#define pc_na 6.022140857E+23                                                     /*- na [mol^-1] Avogadro's number -*/
#define pc_me 9.10938356E-31                                                      /*- me [kg] Electron rest mass (in kg) -*/
/* clang-format on */

/* For Cray X1 compilers */
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#endif /* header guard */
