# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Event(Model):
    """A container group or container instance event.

    :param count: The count of the event.
    :type count: int
    :param first_timestamp: The date-time of the earliest logged event.
    :type first_timestamp: datetime
    :param last_timestamp: The date-time of the latest logged event.
    :type last_timestamp: datetime
    :param name: The event name.
    :type name: str
    :param message: The event message.
    :type message: str
    :param type: The event type.
    :type type: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'first_timestamp': {'key': 'firstTimestamp', 'type': 'iso-8601'},
        'last_timestamp': {'key': 'lastTimestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Event, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.first_timestamp = kwargs.get('first_timestamp', None)
        self.last_timestamp = kwargs.get('last_timestamp', None)
        self.name = kwargs.get('name', None)
        self.message = kwargs.get('message', None)
        self.type = kwargs.get('type', None)
