// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- TEST WITH GRAPHIC -->
// Comment above added because clipboard linked to Java clipboard
// 
// <-- Non-regression test for bug 1590 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=1590
//
// <-- Short Description -->
//    clipboard function crashes scilab when called from a script


if getos() == 'Windows' then
	if ( ~or(sciargs()==['-nw']) & ~or(sciargs()==['-nwni']) ) then
		a="put in clipboard";
		clipboard('copy',a);
		a1=clipboard('paste');
		if a<>a1 then pause,end
		
		b=123.4;
		clipboard('copy',b);
		b1=clipboard('paste');
		if string(b)<>b1 then pause,end
		
		c=["put","in","clipboard"];
		clipboard('copy',c);
		c1=clipboard('paste');
		if "put in clipboard "<>c1  then pause,end
	end
	
	scf(2);
	plot();
	clipboard(2,'EMF');
	if ( ~or(sciargs()==['-nw']) & ~or(sciargs()==['-nwni']) ) then
		clipboard('do','empty');
	end
	
	scf(3);
	plot3d();
	clipboard(3,'DIB');
	if ( ~or(sciargs()==['-nw']) & ~or(sciargs()==['-nwni']) ) then
		clipboard('do','empty');
	end
	
	if ( ~or(sciargs()==['-nw']) & ~or(sciargs()==['-nwni']) ) then
		d=rand(3,5);
		clipboard('copy',d);
		d1=clipboard('paste');
		da=strcat(string(d)'+' ');
		db=strsubst(d1',char(10),'');
		if da<>db then pause,end
	end
end
