/***************************************************************************
 *   copyright           : (C) 2005 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCMXX_PIN_H
#define SCMXX_PIN_H

/* typical request strings:
 * "SIM PIN", "SIM PUK" (SIM PIN and PUK)
 * "SIM PIN2", "SIM PUK2" (SIM PIN 2 and PUK 2)
 * "PH-SIM PIN", "PH-SIM PUK" (theft protection PIN and PUK)
 *
 * There are device specific codes (SIM LOCK) but you
 * usually do not need them:
 * "PH-FSIM PIN", "PH-FSIM PUK" (Phone locked to very first inserted SIM)
 * "PH-NET PIN", "PH-NET PUK" (Network Personalization is actually a PUK)
 * "PH-NETSUB PIN", "PH-NETSUB PUK" (Network Subset Personalization is actually a PUK)
 * "PH-SP PIN", "PH-SP PUK" (Network Personalization is actually a PUK)
 * "PH-CORP PIN", "PH-CORP PUK" (Network Personalization is actually a PUK)
 * 
 * Other request are ignored:
 *
 * Return value (malloc'ed values):
 * "<PIN>" on a pin request (if pin is defined in file)
 * "<PUK>,<PIN>" on a puk request (if puk AND pin is defined in file)
 * "" if the pin file does not exist or the valid request cannot be processed
 * NULL on an invalid request
 */
char* pinfile_get (char* request);

#endif
