-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Wf_Declare_Annotation
  (Node         : in     STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   Task_Or_Proc : in     Dictionary.Symbol;
   First_Seen   : in     Boolean;
   The_Heap     : in out Heap.HeapRecord)
is
   Next_Node : STree.SyntaxNode;
begin
   -- Grammar permits the declare annotation on procedures and task types only so no need
   -- to check the context further.
   if Dictionary.IsProcedure (Task_Or_Proc) and then not First_Seen then
      -- This procedure already has a declare annotation
      ErrorHandler.Semantic_Error
        (Err_Num   => 929,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => Dictionary.GetSimpleName (Task_Or_Proc));
   elsif not CommandLineData.Ravenscar_Selected then
      -- Declare annotation ignored in Ada83 mode
      ErrorHandler.Semantic_Warning
        (Err_Num  => 4,
         Position => Node_Position (Node => Node),
         Id_Str   => LexTokenManager.Null_String);
   else
      Next_Node := Child_Node (Current_Node => Node);
      -- ASSUME Next_Node = property_list
      SystemErrors.RT_Assert
        (C       => Syntax_Node_Type (Node => Next_Node) = SP_Symbols.property_list,
         Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect Next_Node = property_list in Wf_Declare_Annotation");
      Wf_Property_List
        (Node          => Next_Node,
         Type_Node_Pos => LexTokenManager.Null_Token_Position,
         Scope         => Scope,
         The_Owner     => Task_Or_Proc,
         The_Heap      => The_Heap);
   end if;
end Wf_Declare_Annotation;
