/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.CheckContext;
import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import adql.db.DBTableAlias;
import adql.db.DefaultDBTable;
import adql.db.FunctionDef;
import adql.db.SearchColumnList;
import adql.db.SearchTableApi;
import adql.db.SearchTableList;
import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedIdentifiersException;
import adql.db.exception.UnresolvedTableException;
import adql.db.region.CoordSys;
import adql.db.region.Region;
import adql.db.region.STCS;
import adql.parser.QueryChecker;
import adql.parser.grammar.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.SetOperation;
import adql.query.WithItem;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.search.SearchColumnHandler;
import adql.search.SimpleReplaceHandler;
import adql.search.SimpleSearchHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DBChecker
implements QueryChecker {
    protected SearchTableApi lstTables;
    protected FunctionDef[] allowedUdfs = null;
    @Deprecated
    protected String[] allowedGeo = null;
    @Deprecated
    protected String[] allowedCoordSys = null;
    @Deprecated
    protected String coordSysRegExp = null;

    public DBChecker() {
        this(null, null);
    }

    public DBChecker(Collection<? extends DBTable> tables) {
        this(tables, null);
    }

    public DBChecker(Collection<? extends DBTable> tables, Collection<? extends FunctionDef> allowedUdfs) {
        this.setTables(tables);
        if (allowedUdfs != null) {
            FunctionDef[] tmp = new FunctionDef[allowedUdfs.size()];
            int cnt = 0;
            for (FunctionDef functionDef : allowedUdfs) {
                if (functionDef == null) continue;
                tmp[cnt++] = functionDef;
            }
            this.allowedUdfs = new FunctionDef[cnt];
            System.arraycopy(tmp, 0, this.allowedUdfs, 0, cnt);
            tmp = null;
            Arrays.sort(this.allowedUdfs);
        }
    }

    public final void setTables(Collection<? extends DBTable> tables) {
        this.lstTables = tables == null ? new SearchTableList() : (tables instanceof SearchTableApi ? (SearchTableApi)((Object)tables) : new SearchTableList(tables));
    }

    @Override
    public final void check(ADQLSet query) throws ParseException {
        this.check(query, null);
    }

    protected void check(ADQLSet query, Stack<CheckContext> contextList) throws UnresolvedIdentifiersException {
        UnresolvedIdentifiersException errors = new UnresolvedIdentifiersException();
        if (contextList == null) {
            contextList = new Stack();
        }
        if (contextList.isEmpty()) {
            contextList.push(new CheckContext(null, null));
        } else {
            contextList.push(contextList.peek().getCopy());
        }
        CheckContext context = contextList.peek();
        ADQLTable[] declaredCTEs = new ADQLTable[query.getWith().size()];
        int i = 0;
        for (WithItem withItem : query.getWith()) {
            try {
                this.check(withItem.getQuery(), contextList);
            }
            catch (UnresolvedIdentifiersException uie) {
                for (ParseException pe : uie) {
                    errors.addException(pe);
                }
            }
            withItem.setDBLink(DBChecker.generateDBTable(withItem));
            ADQLTable adqlTable = new ADQLTable(null, withItem.getLabel());
            adqlTable.setCaseSensitive(IdentifierField.TABLE, withItem.isLabelCaseSensitive());
            adqlTable.setDBLink(withItem.getDBLink());
            declaredCTEs[i++] = adqlTable;
            context.cteTables.add(adqlTable.getDBLink());
        }
        if (query instanceof ADQLQuery) {
            this.check((ADQLQuery)query, contextList, errors);
        } else if (query instanceof SetOperation) {
            this.check((SetOperation)query, contextList, errors);
        }
        if (errors.getNbErrors() > 0) {
            throw errors;
        }
        contextList.pop();
    }

    protected void check(SetOperation setOp, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        Iterator<ParseException> itPe;
        try {
            this.check(setOp.getLeftSet(), contextList);
        }
        catch (UnresolvedIdentifiersException uie) {
            itPe = uie.getErrors();
            while (itPe.hasNext()) {
                errors.addException(itPe.next());
            }
        }
        try {
            this.check(setOp.getRightSet(), contextList);
        }
        catch (UnresolvedIdentifiersException uie) {
            itPe = uie.getErrors();
            while (itPe.hasNext()) {
                errors.addException(itPe.next());
            }
        }
        DBColumn[] leftColumns = setOp.getLeftSet().getResultingColumns();
        DBColumn[] rightColumns = setOp.getRightSet().getResultingColumns();
        if (leftColumns.length != rightColumns.length) {
            errors.addException(new ParseException("Columns number mismatch! This sub-query must return the same of number of columns as the left sub-query (i.e. " + leftColumns.length + " instead of " + rightColumns.length + ").", setOp.getRightSet().getPosition()));
        }
        if (leftColumns.length == rightColumns.length) {
            for (int i = 0; i < leftColumns.length; ++i) {
                if (leftColumns[i].getDatatype() == null || rightColumns[i].getDatatype() == null || leftColumns[i].getDatatype().isCompatible(rightColumns[i].getDatatype())) continue;
                errors.addException(new ParseException("Columns datatype mismatch! The " + (i + 1) + "-th SELECT-ed column (named '" + rightColumns[i].getADQLName() + "') was expected to be a " + leftColumns[i].getDatatype() + " instead of a " + rightColumns[i].getDatatype() + "!", setOp.getRightSet().getPosition()));
            }
        }
    }

    protected void check(ADQLQuery query, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        this.checkDBItems(query, contextList, errors);
        if (this.allowedUdfs != null) {
            this.checkUDFs(query, errors);
        }
        this.checkTypes(query, errors);
        this.checkSubQueries(query, contextList, errors);
    }

    protected SearchColumnList checkDBItems(ADQLQuery query, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        SearchColumnList availableColumns;
        this.resolveTables(query, contextList, errors);
        try {
            availableColumns = query.getFrom().getDBColumns();
        }
        catch (ParseException pe) {
            errors.addException(pe);
            availableColumns = new SearchColumnList();
        }
        contextList.peek().availableColumns.addAll(availableColumns);
        this.resolveColumns(query, contextList, errors);
        return availableColumns;
    }

    protected void resolveTables(ADQLQuery query, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        CheckContext context = contextList.peek();
        SimpleSearchHandler sHandler = new SearchTableHandler();
        sHandler.search(query.getFrom());
        for (ADQLObject result : sHandler) {
            try {
                ADQLTable table = (ADQLTable)result;
                DBTable dbTable = null;
                if (table.isSubQuery()) {
                    this.check(table.getSubQuery(), contextList);
                    dbTable = DBChecker.generateDBTable(table.getSubQuery(), table.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + table.getAlias() + "\"" : table.getAlias());
                } else {
                    if (dbTable == null) {
                        dbTable = this.resolveTable(table, contextList);
                    }
                    if (dbTable != null && table.hasAlias()) {
                        dbTable = new DBTableAlias(dbTable, table.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + table.getAlias() + "\"" : table.getAlias().toLowerCase());
                    }
                }
                table.setDBLink(dbTable);
                if (!table.isSubQuery() && !table.hasAlias() || context.cteTables.add(dbTable)) continue;
                errors.addException(new ParseException("Table name already used: \"" + dbTable.getADQLName() + "\". Please, choose a different alias for this table."));
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
        sHandler = new SearchWildCardHandler();
        sHandler.search(query.getSelect());
        for (ADQLObject result : sHandler) {
            try {
                SelectAllColumns wildcard = (SelectAllColumns)result;
                ADQLTable table = wildcard.getAdqlTable();
                DBTable dbTable = null;
                dbTable = this.resolveTable(table, contextList);
                wildcard.getAdqlTable().setDBLink(dbTable);
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
    }

    protected DBTable resolveTable(ADQLTable table, Stack<CheckContext> contextList) throws ParseException {
        List<DBTable> tables = this.lstTables.search(table);
        tables.addAll(contextList.peek().cteTables.search(table));
        if (tables.size() == 1) {
            return tables.get(0);
        }
        if (tables.size() > 1) {
            throw new UnresolvedTableException(table, (tables.get(0).getADQLSchemaName() == null ? "" : tables.get(0).getADQLSchemaName() + ".") + tables.get(0).getADQLName(), (tables.get(1).getADQLSchemaName() == null ? "" : tables.get(1).getADQLSchemaName() + ".") + tables.get(1).getADQLName());
        }
        throw new UnresolvedTableException(table);
    }

    @Deprecated
    protected final void resolveColumns(ADQLQuery query, Stack<CheckContext> contextList, Map<DBTable, ADQLTable> mapTables, UnresolvedIdentifiersException errors) {
        this.resolveColumns(query, contextList, errors);
    }

    protected void resolveColumns(ADQLQuery query, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        SimpleSearchHandler sHandler = new SearchColumnOutsideGroupByHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            try {
                this.resolveColumn((ADQLColumn)result, contextList);
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
        ClauseSelect select = query.getSelect();
        this.checkGroupBy(query.getGroupBy(), select, contextList, errors);
        this.checkOrderBy(query.getOrderBy(), select, contextList, errors);
        sHandler = new SearchColReferenceHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            try {
                ColumnReference colRef = (ColumnReference)result;
                DBColumn dbColumn = this.checkColumnReference(colRef, select, contextList);
                colRef.setDBLink(dbColumn);
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
    }

    protected DBColumn resolveColumn(ADQLColumn column, Stack<CheckContext> contextList) throws ParseException {
        List<DBColumn> foundColumns = contextList.peek().availableColumns.search(column);
        if (foundColumns.size() == 1) {
            column.setDBLink(foundColumns.get(0));
            return foundColumns.get(0);
        }
        if (foundColumns.size() > 1) {
            if (column.getTableName() == null) {
                throw new UnresolvedColumnException(column, foundColumns.get(0).getTable() == null ? "<NULL>" : foundColumns.get(0).getTable().getADQLName() + "." + foundColumns.get(0).getADQLName(), foundColumns.get(1).getTable() == null ? "<NULL>" : foundColumns.get(1).getTable().getADQLName() + "." + foundColumns.get(1).getADQLName());
            }
            throw new UnresolvedTableException(column, foundColumns.get(0).getTable() == null ? "<NULL>" : foundColumns.get(0).getTable().getADQLName(), foundColumns.get(1).getTable() == null ? "<NULL>" : foundColumns.get(1).getTable().getADQLName());
        }
        if (contextList.size() > 1) {
            Stack<CheckContext> subStack = new Stack<CheckContext>();
            subStack.addAll(contextList.subList(0, contextList.size() - 1));
            return this.resolveColumn(column, subStack);
        }
        throw new UnresolvedColumnException(column);
    }

    protected void checkGroupBy(ClauseADQL<ADQLOperand> groupBy, ClauseSelect select, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        for (ADQLOperand obj : groupBy) {
            try {
                if (obj instanceof ADQLColumn) {
                    ADQLColumn adqlColumn = (ADQLColumn)obj;
                    if (adqlColumn.getTableName() == null) {
                        this.resolveColumnNameReference(adqlColumn, select, contextList);
                        continue;
                    }
                    this.resolveColumn(adqlColumn, contextList);
                    continue;
                }
                SearchColumnHandler sHandler = new SearchColumnHandler();
                sHandler.search(obj);
                for (ADQLObject result : sHandler) {
                    try {
                        this.resolveColumn((ADQLColumn)result, contextList);
                    }
                    catch (ParseException pe) {
                        errors.addException(pe);
                    }
                }
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
    }

    protected void checkOrderBy(ClauseADQL<ADQLOrder> orderBy, ClauseSelect select, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        for (ADQLObject aDQLObject : orderBy) {
            try {
                ADQLOrder order = (ADQLOrder)aDQLObject;
                if (order.getExpression() == null) continue;
                ADQLOperand expr = order.getExpression();
                if (expr instanceof ADQLColumn) {
                    ADQLColumn adqlColumn = (ADQLColumn)expr;
                    if (adqlColumn.getTableName() == null) {
                        this.resolveColumnNameReference(adqlColumn, select, contextList);
                        continue;
                    }
                    this.resolveColumn(adqlColumn, contextList);
                    continue;
                }
                SearchColumnHandler sHandler = new SearchColumnHandler();
                sHandler.search(expr);
                for (ADQLObject result : sHandler) {
                    try {
                        this.resolveColumn((ADQLColumn)result, contextList);
                    }
                    catch (ParseException pe) {
                        errors.addException(pe);
                    }
                }
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
    }

    protected DBColumn resolveColumnNameReference(ADQLColumn col, ClauseSelect select, Stack<CheckContext> contextList) throws ParseException {
        if (col.getTableName() == null) {
            List<SelectItem> founds = select.searchByAlias(col.getColumnName(), col.isCaseSensitive(IdentifierField.COLUMN));
            if (founds.size() == 1) {
                return null;
            }
            if (founds.size() > 1) {
                throw new UnresolvedColumnException(col, founds.get(0).getAlias(), founds.get(1).getAlias());
            }
        }
        return this.resolveColumn(col, contextList);
    }

    protected DBColumn checkColumnReference(ColumnReference colRef, ClauseSelect select, Stack<CheckContext> contextList) throws ParseException {
        int index = colRef.getColumnIndex();
        if (index > 0 && index <= select.size()) {
            SelectItem item = (SelectItem)select.get(index - 1);
            if (item.getOperand() instanceof ADQLColumn) {
                return ((ADQLColumn)item.getOperand()).getDBLink();
            }
            return null;
        }
        throw new ParseException("Column index out of bounds: " + index + " (must be between 1 and " + select.size() + ") !", colRef.getPosition());
    }

    public static DBTable generateDBTable(ADQLSet subQuery, String tableName) throws ParseException {
        DBColumn[] columns;
        DefaultDBTable dbTable = new DefaultDBTable(DefaultDBTable.isDelimited(tableName) ? tableName : tableName.toLowerCase());
        for (DBColumn dbCol : columns = subQuery.getResultingColumns()) {
            dbTable.addColumn(dbCol.copy(dbCol.getDBName(), DBIdentifier.denormalize(dbCol.getADQLName(), dbCol.isCaseSensitive()), dbTable));
        }
        return dbTable;
    }

    public static DBTable generateDBTable(WithItem withItem) {
        DBColumn[] columns;
        DefaultDBTable dbTable = new DefaultDBTable(withItem.isLabelCaseSensitive() ? withItem.getLabel() : withItem.getLabel().toLowerCase());
        dbTable.setCaseSensitive(withItem.isLabelCaseSensitive());
        for (DBColumn dbCol : columns = withItem.getResultingColumns()) {
            dbTable.addColumn(dbCol.copy(dbCol.getDBName(), DBIdentifier.denormalize(dbCol.getADQLName(), dbCol.isCaseSensitive()), dbTable));
        }
        return dbTable;
    }

    protected void checkUDFs(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchUDFHandler sHandler = new SearchUDFHandler();
        sHandler.search(query);
        if (this.allowedUdfs.length == 0) {
            for (ADQLObject result : sHandler) {
                errors.addException(new UnresolvedFunctionException((UserDefinedFunction)result));
            }
        } else {
            int match;
            UserDefinedFunction udf;
            ArrayList<UserDefinedFunction> toResolveLater = new ArrayList<UserDefinedFunction>();
            BinarySearch<FunctionDef, UserDefinedFunction> binSearch = new BinarySearch<FunctionDef, UserDefinedFunction>(){

                @Override
                protected int compare(UserDefinedFunction searchItem, FunctionDef arrayItem) {
                    return arrayItem.compareTo(searchItem) * -1;
                }
            };
            for (ADQLObject result : sHandler) {
                udf = (UserDefinedFunction)result;
                if (!this.isAllParamTypesResolved(udf)) {
                    toResolveLater.add(udf);
                    continue;
                }
                match = binSearch.search(udf, this.allowedUdfs);
                if (match < 0) {
                    errors.addException(new UnresolvedFunctionException(udf));
                    continue;
                }
                udf.setDefinition(this.allowedUdfs[match]);
            }
            for (int i = toResolveLater.size() - 1; i >= 0; --i) {
                udf = (UserDefinedFunction)toResolveLater.get(i);
                match = binSearch.search(udf, this.allowedUdfs);
                if (match < 0) {
                    errors.addException(new UnresolvedFunctionException(udf));
                    continue;
                }
                udf.setDefinition(this.allowedUdfs[match]);
            }
            new ReplaceDefaultUDFHandler(errors).searchAndReplace(query);
        }
    }

    protected final boolean isAllParamTypesResolved(ADQLFunction fct) {
        for (ADQLOperand op : fct.getParameters()) {
            if (op.isGeometry() != op.isNumeric() || op.isNumeric() != op.isString()) continue;
            return false;
        }
        return true;
    }

    protected void checkTypes(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchUnknownTypeHandler sHandler = new SearchUnknownTypeHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            UnknownType unknown = (UnknownType)result;
            switch (unknown.getExpectedType()) {
                case 'G': 
                case 'g': {
                    if (unknown.isGeometry()) break;
                    errors.addException(new ParseException("Type mismatch! A geometry was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                    break;
                }
                case 'N': 
                case 'n': {
                    if (unknown.isNumeric()) break;
                    errors.addException(new ParseException("Type mismatch! A numeric value was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                    break;
                }
                case 'S': 
                case 's': {
                    if (unknown.isString()) break;
                    errors.addException(new ParseException("Type mismatch! A string value was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                }
            }
        }
    }

    protected void checkSubQueries(ADQLQuery query, Stack<CheckContext> contextList, UnresolvedIdentifiersException errors) {
        SearchSubQueryHandler sHandler = new SearchSubQueryHandler();
        sHandler.search(query);
        if (sHandler.getNbMatch() > 0) {
            for (ADQLObject result : sHandler) {
                try {
                    this.check((ADQLQuery)result, contextList);
                }
                catch (UnresolvedIdentifiersException uie) {
                    Iterator<ParseException> itPe = uie.getErrors();
                    while (itPe.hasNext()) {
                        errors.addException(itPe.next());
                    }
                }
            }
        }
    }

    @Deprecated
    public DBChecker(Collection<? extends DBTable> tables, Collection<String> allowedGeoFcts, Collection<String> allowedCoordSys) throws ParseException {
        this(tables, null, allowedGeoFcts, allowedCoordSys);
    }

    @Deprecated
    public DBChecker(Collection<? extends DBTable> tables, Collection<? extends FunctionDef> allowedUdfs, Collection<String> allowedGeoFcts, Collection<String> allowedCoordSys) throws ParseException {
        this(tables, allowedUdfs);
        this.allowedGeo = DBChecker.specialSort(allowedGeoFcts);
        this.allowedCoordSys = DBChecker.specialSort(allowedCoordSys);
        this.coordSysRegExp = CoordSys.buildCoordSysRegExp(this.allowedCoordSys);
    }

    @Deprecated
    protected static final String[] specialSort(Collection<String> items) {
        if (items == null) {
            return null;
        }
        String[] tmp = new String[items.size()];
        int cnt = 0;
        for (String item : items) {
            if (item == null || item.trim().length() <= 0) continue;
            tmp[cnt++] = item;
        }
        Object[] copy = new String[cnt];
        System.arraycopy(tmp, 0, copy, 0, cnt);
        Arrays.sort(copy);
        return copy;
    }

    @Deprecated
    protected void checkGeometries(ADQLQuery query, UnresolvedIdentifiersException errors) {
        BinarySearch<String, String> binSearch = new BinarySearch<String, String>(){

            @Override
            protected int compare(String searchItem, String arrayItem) {
                return searchItem.compareToIgnoreCase(arrayItem);
            }
        };
        if (this.allowedCoordSys != null) {
            this.resolveCoordinateSystems(query, errors);
        }
        if (this.allowedGeo == null || this.allowedGeo.length > 0 && binSearch.search("REGION", this.allowedGeo) >= 0) {
            this.resolveSTCSExpressions(query, binSearch, errors);
        }
    }

    @Deprecated
    protected final void resolveGeometryFunctions(ADQLQuery query, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        SearchGeometryHandler sHandler = new SearchGeometryHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            String fctName = result.getName();
            this.checkGeometryFunction(fctName, (ADQLFunction)result, binSearch, errors);
        }
    }

    @Deprecated
    protected final void checkGeometryFunction(String fctName, ADQLFunction fct, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        int match = -1;
        if (this.allowedGeo.length != 0) {
            match = binSearch.search(fctName, (String[])this.allowedGeo);
        }
        if (match < 0) {
            errors.addException(new UnresolvedFunctionException("The geometrical function \"" + fctName + "\" is not available in this implementation!", fct));
        }
    }

    @Deprecated
    protected void resolveCoordinateSystems(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchCoordSysHandler sHandler = new SearchCoordSysHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            this.checkCoordinateSystem((StringConstant)result, errors);
        }
    }

    @Deprecated
    protected void checkCoordinateSystem(StringConstant adqlCoordSys, UnresolvedIdentifiersException errors) {
        String coordSysStr = adqlCoordSys.getValue();
        try {
            this.checkCoordinateSystem(STCS.parseCoordSys(coordSysStr), adqlCoordSys, errors);
        }
        catch (ParseException pe) {
            errors.addException(new ParseException(pe.getMessage(), adqlCoordSys.getPosition()));
        }
    }

    @Deprecated
    protected void checkCoordinateSystem(CoordSys coordSys, ADQLOperand operand, UnresolvedIdentifiersException errors) {
        if (this.coordSysRegExp != null && coordSys != null && !coordSys.toFullSTCS().matches(this.coordSysRegExp)) {
            StringBuffer buf = new StringBuffer();
            if (this.allowedCoordSys != null) {
                for (String cs : this.allowedCoordSys) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(cs);
                }
            }
            if (buf.length() == 0) {
                buf.append("No coordinate system is allowed!");
            } else {
                buf.insert(0, "Allowed coordinate systems are: ");
            }
            errors.addException(new ParseException("Coordinate system \"" + (operand instanceof StringConstant ? ((StringConstant)operand).getValue() : coordSys.toString()) + "\" (= \"" + coordSys.toFullSTCS() + "\") not allowed in this implementation. " + buf.toString(), operand.getPosition()));
        }
    }

    @Deprecated
    protected void resolveSTCSExpressions(ADQLQuery query, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        SearchRegionHandler sHandler = new SearchRegionHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            try {
                String stcs = ((StringConstant)((RegionFunction)result).getParameter(0)).getValue();
                Region region = STCS.parseRegion(stcs);
                this.checkRegion(region, (RegionFunction)result, binSearch, errors);
            }
            catch (ParseException pe) {
                errors.addException(new ParseException(pe.getMessage(), result.getPosition()));
            }
        }
    }

    @Deprecated
    protected void checkRegion(Region r, RegionFunction fct, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        if (r == null) {
            return;
        }
        if (r.coordSys != null) {
            this.checkCoordinateSystem(r.coordSys, fct, errors);
        }
        if (this.allowedGeo != null) {
            if (this.allowedGeo.length == 0) {
                errors.addException(new UnresolvedFunctionException("The region type \"" + (Object)((Object)r.type) + "\" is not available in this implementation!", fct));
            } else {
                this.checkGeometryFunction(r.type == Region.RegionType.POSITION ? "POINT" : r.type.toString(), fct, binSearch, errors);
            }
        }
        if (r.regions != null) {
            for (Region innerR : r.regions) {
                this.checkRegion(innerR, fct, binSearch, errors);
            }
        }
    }

    @Deprecated
    private static class SearchRegionHandler
    extends SimpleSearchHandler {
        private SearchRegionHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            if (obj instanceof RegionFunction) {
                return ((RegionFunction)obj).getParameter(0) instanceof StringConstant;
            }
            return false;
        }
    }

    @Deprecated
    private static class SearchCoordSysHandler
    extends SimpleSearchHandler {
        private SearchCoordSysHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            if (obj instanceof PointFunction || obj instanceof BoxFunction || obj instanceof CircleFunction || obj instanceof PolygonFunction) {
                return ((GeometryFunction)obj).getCoordinateSystem() instanceof StringConstant;
            }
            return false;
        }

        @Override
        protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
            this.results.add(((GeometryFunction)matchObj).getCoordinateSystem());
        }
    }

    @Deprecated
    private static class SearchGeometryHandler
    extends SimpleSearchHandler {
        private SearchGeometryHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            return obj instanceof GeometryFunction;
        }
    }

    protected static abstract class BinarySearch<T, S> {
        private int s;
        private int e;
        private int m;
        private int comp;

        protected BinarySearch() {
        }

        public int search(S searchItem, T[] array) {
            this.s = 0;
            this.e = array.length - 1;
            while (this.s < this.e) {
                this.m = this.s + (this.e - this.s) / 2;
                this.comp = this.compare(searchItem, array[this.m]);
                if (this.comp > 0) {
                    this.s = this.m + 1;
                    continue;
                }
                this.e = this.m;
            }
            if (this.s != this.e || this.compare(searchItem, array[this.s]) != 0) {
                return -1;
            }
            return this.s;
        }

        protected abstract int compare(S var1, T var2);
    }

    private static class SearchUnknownTypeHandler
    extends SimpleSearchHandler {
        private SearchUnknownTypeHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            if (obj instanceof UnknownType) {
                char expected = ((UnknownType)obj).getExpectedType();
                return expected == 'G' || expected == 'g' || expected == 'S' || expected == 's' || expected == 'N' || expected == 'n';
            }
            return false;
        }
    }

    private static class ReplaceDefaultUDFHandler
    extends SimpleReplaceHandler {
        private final UnresolvedIdentifiersException errors;

        public ReplaceDefaultUDFHandler(UnresolvedIdentifiersException errorsContainer) {
            this.errors = errorsContainer;
        }

        @Override
        protected boolean match(ADQLObject obj) {
            return obj instanceof UserDefinedFunction && ((UserDefinedFunction)obj).getDefinition() != null && ((UserDefinedFunction)obj).getDefinition().getUDFClass() != null;
        }

        @Override
        protected ADQLObject getReplacer(ADQLObject objToReplace) throws UnsupportedOperationException {
            UserDefinedFunction udf = (UserDefinedFunction)objToReplace;
            try {
                return udf.getDefinition().createUDF(udf.getParameters());
            }
            catch (Exception ex) {
                this.errors.addException(new UnresolvedFunctionException("Impossible to represent the function \"" + udf.getName() + "\": the following error occured while creating this representation: \"" + (ex instanceof InvocationTargetException ? "[" + ex.getCause().getClass().getSimpleName() + "] " + ex.getCause().getMessage() : ex.getMessage()) + "\"", udf));
                return objToReplace;
            }
        }
    }

    private static class SearchUDFHandler
    extends SimpleSearchHandler {
        private SearchUDFHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            return obj instanceof UserDefinedFunction;
        }
    }

    private static class SearchSubQueryHandler
    extends SimpleSearchHandler {
        private SearchSubQueryHandler() {
        }

        @Override
        protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
            if (it != null) {
                super.addMatch(matchObj, it);
            }
        }

        @Override
        protected boolean goInto(ADQLObject obj) {
            return super.goInto(obj) && !(obj instanceof FromContent) && (!(obj instanceof ClauseADQL) || !"WITH".equals(obj.getName()));
        }

        @Override
        protected boolean match(ADQLObject obj) {
            return obj instanceof ADQLQuery;
        }
    }

    private static class SearchColReferenceHandler
    extends SimpleSearchHandler {
        private SearchColReferenceHandler() {
        }

        @Override
        public boolean match(ADQLObject obj) {
            return obj instanceof ColumnReference;
        }
    }

    private static class SearchWildCardHandler
    extends SimpleSearchHandler {
        private SearchWildCardHandler() {
        }

        @Override
        public boolean match(ADQLObject obj) {
            return obj instanceof SelectAllColumns && ((SelectAllColumns)obj).getAdqlTable() != null;
        }
    }

    private static class SearchTableHandler
    extends SimpleSearchHandler {
        private SearchTableHandler() {
        }

        @Override
        public boolean match(ADQLObject obj) {
            return obj instanceof ADQLTable;
        }
    }

    private static class SearchColumnOutsideGroupByHandler
    extends SearchColumnHandler {
        private SearchColumnOutsideGroupByHandler() {
        }

        @Override
        protected boolean goInto(ADQLObject obj) {
            if (obj instanceof ClauseADQL && ((ClauseADQL)obj).getName() != null) {
                ClauseADQL clause = (ClauseADQL)obj;
                return !clause.getName().equalsIgnoreCase("GROUP BY") && !clause.getName().equalsIgnoreCase("ORDER BY");
            }
            return super.goInto(obj);
        }
    }
}

