# -*- perl -*-

#
#   Copyright (C) Dr. Heinz-Josef Claes (2013-2022)
#                 hjclaes@web.de
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.

#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


use strict;

# archiveTypes
# specialTypeArchiver
# cpio and tar must be handelt differently
$main::fileTypeArchiver{'cpio'}{'prog'} = 'cpio';
# ls filename | cpio -o --quiet > backupDir/filename
$main::fileTypeArchiver{'cpio'}{'createOpts'} = ['-o', '--quiet'];
# cpio -i --quiet < ../x.cpio
$main::fileTypeArchiver{'cpio'}{'extractOpts'} = ['-i', '--quiet'];
$main::fileTypeArchiver{'tar'}{'prog'} = 'tar';
# tar cf - filename > backupDir/filename
$main::fileTypeArchiver{'tar'}{'createOpts'} = ['cf'];
# tar xpf backupDir/filename
$main::fileTypeArchiver{'tar'}{'extractOpts'} = ['xpf'];

# name of "finished flag file" within the backups (since version > 3.4.3)
#$main::finishedFlag = ".md5CheckSums.Finished";
$main::finishedFlag = ".storeBackupLinks/backup.Finished";


##################################################
# special file layout starting with version 3.6
# backups are converted automatically when accessed
# conversion = create .storeBackup + generate hard links to original files
#
# .md5CheckSums.info                -> .storeBackup/info
# .storeBackupLinks/backup.Finished -> .storeBackup/backup.Finished
# .storeBackupLinks/linkFile.bz2    -> .storeBackup/linkFile.bz2
# .storeBackupLinks/linkFrom0       -> .storeBackup/linkFrom0
# .storeBackupLinks/linkFrom1       -> .storeBackup/linkFrom1
# ...
# .storeBackup.notSaved.bz2         -> .storeBackup/files.notSaved.bz2
# .storeBackup.log.bz2 (or something else) -> .storeBackup/log.bz2
######### -> option logInBackupDirFileName is cancelled
# 
# .storeBackupLinks/linkTo          -> .storeBackup/linkTo
# .md5CheckSums.bz2                 -> .storeBackup/checkSums.MD5.bz2
# .md5CheckSums                     -> .storeBackup/checkSums.MD5
# other checksums:
# sha-1    -> .storeBackup/checkSums.SHA-1[.bz2]
# sha-256  -> .storeBackup/checkSums.SHA-256[.bz2]
# sha-224  -> .storeBackup/checkSums.SHA-224[.bz2]
# sha-384  -> .storeBackup/checkSums.SHA-384[.bz2]
# sha-512  -> .storeBackup/checkSums.SHA-512[.bz2]

## -> important: change function storeBackupLib.pl:checkIfBackupWasFinished
##               and change $main::finishedFlag to new value

use English;

sub uid_gid  # returns uid + guids in numerical order
{
    my (@gid) = sort { $a <=> $b } split(/\s+/, $GID);

    return ($UID, @gid);
}

1
