#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import socket
from winswitch.util.simple_logger import Logger

class	ReservePort:
	"""
	"""
	def	__init__(self, host, port):
		Logger(self)
		self.host = host
		self.port = port
		self.pid = 0
		self.returncode = None
		self.socket = None
		self.start()

	def start(self):
		self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
		self.socket.bind((self.host, self.port))
		self.sdebug("host=%s, port=%s, socket=%s" % (self.host, self.port, self.socket))
	
	def stop(self, callback=None):
		self.sdebug("socket=%s" % self.socket, callback)
		if self.socket:
			self.socket.close()
