#
# Wireshark tests
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
'''Follow QUIC/HTTP2 Stream tests'''

import subprocess
import pytest


class TestFollowMultistream:
    def test_follow_http2_multistream(self, cmd_tshark, capture_file, test_env, features):
        '''Checks whether Follow HTTP2 correctly handles multiple streams on the same packet.'''
        # If we don't have nghttp2, we output the compressed headers.
        # We could test against the expected output in that case, but
        # just skip for now.
        if not features.have_nghttp2:
            pytest.skip('Requires nghttp2.')
        # Test 1:
        # 1. While following stream 25 we should ignore stream 21 at frame 65
        stdout = subprocess.check_output((cmd_tshark,
                                '-r', capture_file('http2_follow_multistream.pcapng'),
                                '-qz', 'follow,http2,raw,0,25',
                                ), encoding='utf-8', universal_newlines=True, env=test_env)

        assert """\
===================================================================
Follow: http2,raw
Filter: tcp.stream eq 0 and http2.streamid eq 25
Node 0: 10.9.0.2:59246
Node 1: 104.16.40.2:443
3a6d6574686f643a204745540a3a706174683a202f6d656469612f6a732f66697265666f785f666972737472756e2d62756e646c652e3464633733383035353861622e6a730a3a617574686f726974793a207777772e6d6f7a696c6c612e6f72670a3a736368656d653a2068747470730a757365722d6167656e743a204d6f7a696c6c612f352e3020285831313b204c696e7578207838365f36343b2072763a35322e3029204765636b6f2f32303130303130312046697265666f782f35322e300a6163636570743a202a2f2a0a6163636570742d6c616e67756167653a20656e2d55532c656e3b713d302e350a6163636570742d656e636f64696e673a20677a69702c206465666c6174652c2062720a726566657265723a2068747470733a2f2f7777772e6d6f7a696c6c612e6f72672f656e2d55532f66697265666f782f35322e302e312f666972737472756e2f0a0a
00000408000000001900be0000
	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
===================================================================
""" in stdout


    def test_follow_quic_multistream(self, cmd_tshark, capture_file, test_env):
        '''Checks whether Follow QUIC correctly handles multiple streams on the same packet.'''

        # Test 2:
        # 1. While following stream 40 we should ignore stream 36 at frame 426, and stream 11 at frame 623
        stdout = subprocess.check_output((cmd_tshark,
                                '-r', capture_file('quic_follow_multistream.pcapng'),
                                '-qz', 'follow,quic,raw,0,40',
                                ), encoding='utf-8', universal_newlines=True, env=test_env)

        assert """\
===================================================================
Follow: quic,raw
Filter: quic.connection.number eq 0 and quic.stream.stream_id eq 40
Node 0: 10.0.2.15:57172
Node 1: 172.217.5.110:443
01143000d1aed782e4a7dd81a3a280a0df9f9e9d9c9b
	010f3700d982fd819380adf89eeab0aeac00424203500200e4d7dcfefe2fa7a5df3632669896a543445e8a68d10ebc13d704f6af5e7460740ba4e67985c9c8c6b3b9b6b65ce9af3404e6213f749da27b3c523060867c215f30e43343a1a055e4924757cba0cd8fb3b9219712521b197ba3b55d06907660c4a29fee6cb94abce7d1800346c603f68021dad3fdfb7bbada302be0f3e9456a7134b3f0f9c82deb126fa10875b570f96976ea311b77d2e620d2a3cd652555db30dc8da347a1f2be10bc129a180d576cb394a9cfef499a0a037f3a34c6e3047507f07fff215080120182587a6277871ae3e16e2c44ecebdbe77ce1ca6f447a35d2c89749a5054e09679b28fa46bbc58dd10b404ac36436c3e2305f72ff18b847b85e181c0f0ba058c05780a2a12f8ccac69fdf819e4e60b2765852c6304c44064b9ae30b170c8181fde020cee9cb83994176942023abd0c35b0ca571ca0f77a63764b5a170a24f76a4734ef16f858af2950a69b4da1902b8968722e9a328c2f9176d3e71159c82d564e776b8ee6fb648ae94b537ec0efd0898e679d60d230e5f7748a399af565014ddcc22b74b794474155c26c7d02ec9a4180edb2ccd322cd3081a21ed51c0e8e157adb448af052c34dd636a80cb426540cdf0444fcab899105702754b35a95257f9574ab8459a2d20366ed939d280266974f236815603dbc57c250b35dcc0e5a6fa35da21198550625e157282755cfedd0b3f1e1de923dd3f83b1548aeb7411f1e41ae97ca47bb77b467a2462cc8cc8cc1ae95b3edd1c46faee87c1f7e365b7b8782dcbe1a5a7130fa25b94765b32be7029ed5bfeafc40c
	000103
	
===================================================================
""" in stdout
