/* Tag.c generated by valac 0.40.4, the Vala compiler
 * generated from Tag.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>
#include <glib/gi18n-lib.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;
typedef struct _ContainerSourceCollectionPrivate ContainerSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
typedef struct _TagSourceCollectionPrivate TagSourceCollectionPrivate;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;

#define TYPE_TAG_ID (tag_id_get_type ())
typedef struct _TagID TagID;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DataObjectPrivate DataObjectPrivate;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_PROXYABLE (proxyable_get_type ())
#define PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROXYABLE, Proxyable))
#define IS_PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROXYABLE))
#define PROXYABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROXYABLE, ProxyableIface))

typedef struct _Proxyable Proxyable;
typedef struct _ProxyableIface ProxyableIface;

#define TYPE_SOURCE_PROXY (source_proxy_get_type ())
#define SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_PROXY, SourceProxy))
#define SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_PROXY, SourceProxyClass))
#define IS_SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_PROXY))
#define IS_SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_PROXY))
#define SOURCE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_PROXY, SourceProxyClass))

typedef struct _SourceProxy SourceProxy;
typedef struct _SourceProxyClass SourceProxyClass;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;
typedef struct _TagPrivate TagPrivate;

#define TYPE_TAG_ROW (tag_row_get_type ())
#define TAG_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_ROW, TagRow))
#define TAG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_ROW, TagRowClass))
#define IS_TAG_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_ROW))
#define IS_TAG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_ROW))
#define TAG_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_ROW, TagRowClass))

typedef struct _TagRow TagRow;
typedef struct _TagRowClass TagRowClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
enum  {
	TAG_0_PROPERTY,
	TAG_NUM_PROPERTIES
};
static GParamSpec* tag_properties[TAG_NUM_PROPERTIES];

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
#define _tag_row_unref0(var) ((var == NULL) ? NULL : (var = (tag_row_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _TagRowPrivate TagRowPrivate;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_TAG_TABLE (tag_table_get_type ())
#define TAG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_TABLE, TagTable))
#define TAG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_TABLE, TagTableClass))
#define IS_TAG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_TABLE))
#define IS_TAG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_TABLE))
#define TAG_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_TABLE, TagTableClass))

typedef struct _TagTable TagTable;
typedef struct _TagTableClass TagTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TAG_TYPE_TAG_SNAPSHOT (tag_tag_snapshot_get_type ())
#define TAG_TAG_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshot))
#define TAG_TAG_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshotClass))
#define TAG_IS_TAG_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TAG_TYPE_TAG_SNAPSHOT))
#define TAG_IS_TAG_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TAG_TYPE_TAG_SNAPSHOT))
#define TAG_TAG_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshotClass))

typedef struct _TagTagSnapshot TagTagSnapshot;
typedef struct _TagTagSnapshotClass TagTagSnapshotClass;

#define TAG_TYPE_TAG_PROXY (tag_tag_proxy_get_type ())
#define TAG_TAG_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TAG_TYPE_TAG_PROXY, TagTagProxy))
#define TAG_TAG_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TAG_TYPE_TAG_PROXY, TagTagProxyClass))
#define TAG_IS_TAG_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TAG_TYPE_TAG_PROXY))
#define TAG_IS_TAG_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TAG_TYPE_TAG_PROXY))
#define TAG_TAG_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TAG_TYPE_TAG_PROXY, TagTagProxyClass))

typedef struct _TagTagProxy TagTagProxy;
typedef struct _TagTagProxyClass TagTagProxyClass;
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
typedef struct _SourceSnapshotPrivate SourceSnapshotPrivate;
typedef struct _TagTagSnapshotPrivate TagTagSnapshotPrivate;
typedef struct _SourceProxyPrivate SourceProxyPrivate;
typedef struct _TagTagProxyPrivate TagTagProxyPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

struct _ContainerSourceCollection {
	DatabaseSourceCollection parent_instance;
	ContainerSourceCollectionPrivate * priv;
};

struct _ContainerSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	void (*notify_container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*notify_container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*notify_container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*notify_backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
	GeeCollection* (*get_containers_holding_source) (ContainerSourceCollection* self, DataSource* source);
	ContainerSource* (*convert_backlink_to_container) (ContainerSourceCollection* self, SourceBacklink* backlink);
	void (*container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
};

struct _TagSourceCollection {
	ContainerSourceCollection parent_instance;
	TagSourceCollectionPrivate * priv;
};

struct _TagSourceCollectionClass {
	ContainerSourceCollectionClass parent_class;
};

struct _TagSourceCollectionPrivate {
	GeeHashMap* name_map;
	GeeHashMap* source_map;
	GeeHashMap* sorted_source_map;
};

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
struct _TagID {
	gint64 id;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ProxyableIface {
	GTypeInterface parent_iface;
	SourceProxy* (*get_proxy) (Proxyable* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _Tag {
	DataSource parent_instance;
	TagPrivate * priv;
};

struct _TagClass {
	DataSourceClass parent_class;
};

struct _TagPrivate {
	TagRow* row;
	ViewCollection* media_views;
	gchar* name_collation_key;
	gboolean unlinking;
	gboolean relinking;
	gchar* indexable_keywords;
};

struct _TagRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagRowPrivate * priv;
	TagID tag_id;
	gchar* name;
	GeeSet* source_id_list;
	time_t time_created;
};

struct _TagRowClass {
	GTypeClass parent_class;
	void (*finalize) (TagRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

typedef DataView* (*CreateView) (DataSource* source, void* user_data);
typedef gboolean (*CreateViewPredicate) (DataSource* source, void* user_data);
struct _SourceSnapshot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceSnapshotPrivate * priv;
};

struct _SourceSnapshotClass {
	GTypeClass parent_class;
	void (*finalize) (SourceSnapshot *self);
	void (*notify_broken) (SourceSnapshot* self);
	void (*broken) (SourceSnapshot* self);
};

struct _TagTagSnapshot {
	SourceSnapshot parent_instance;
	TagTagSnapshotPrivate * priv;
};

struct _TagTagSnapshotClass {
	SourceSnapshotClass parent_class;
};

struct _TagTagSnapshotPrivate {
	TagRow* row;
	GeeHashSet* sources;
};

struct _SourceProxy {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceProxyPrivate * priv;
};

struct _SourceProxyClass {
	GTypeClass parent_class;
	void (*finalize) (SourceProxy *self);
	DataSource* (*reconstitute) (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
	void (*notify_reconstituted) (SourceProxy* self, DataSource* source);
	void (*notify_dehydrated) (SourceProxy* self);
	void (*notify_broken) (SourceProxy* self);
	void (*reconstituted) (SourceProxy* self, DataSource* source);
	void (*dehydrated) (SourceProxy* self);
	void (*broken) (SourceProxy* self);
};

struct _TagTagProxy {
	SourceProxy parent_instance;
	TagTagProxyPrivate * priv;
};

struct _TagTagProxyClass {
	SourceProxyClass parent_class;
};


static gpointer tag_source_collection_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
extern VideoSourceCollection* video_global;
static gpointer tag_parent_class = NULL;
extern TagSourceCollection* tag_global;
TagSourceCollection* tag_global = NULL;
static gpointer tag_tag_snapshot_parent_class = NULL;
static gpointer tag_tag_proxy_parent_class = NULL;
static ContainerSourceIface * tag_container_source_parent_iface = NULL;
static ProxyableIface * tag_proxyable_parent_iface = NULL;
static IndexableIface * tag_indexable_parent_iface = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GType tag_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
#define TAG_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionPrivate))
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
static void tag_source_collection_on_photo_source_reimported (TagSourceCollection* self,
                                                       LibraryPhoto* photo,
                                                       PhotoMetadata* metadata);
static void _tag_source_collection_on_photo_source_reimported_library_photo_source_collection_source_reimported (LibraryPhotoSourceCollection* _sender,
                                                                                                          LibraryPhoto* photo,
                                                                                                          PhotoMetadata* metadata,
                                                                                                          gpointer self);
guint tag_hash_name_string (const gchar* a);
static guint _tag_hash_name_string_gee_hash_data_func (gconstpointer v,
                                                gpointer self);
gboolean tag_equal_name_strings (const gchar* a,
                                 const gchar* b);
static gboolean _tag_equal_name_strings_gee_equal_data_func (gconstpointer a,
                                                      gconstpointer b,
                                                      gpointer self);
TagSourceCollection* tag_source_collection_new (void);
TagSourceCollection* tag_source_collection_construct (GType object_type);
#define TAG_TYPENAME "tag"
static gint64 tag_source_collection_get_tag_key (DataSource* source);
static gint64 _tag_source_collection_get_tag_key_get_source_database_key (DataSource* source,
                                                                   gpointer self);
ContainerSourceCollection* container_source_collection_construct (GType object_type,
                                                                  const gchar* backlink_name,
                                                                  const gchar* name,
                                                                  GetSourceDatabaseKey source_key_func,
                                                                  void* source_key_func_target);
void container_source_collection_attach_collection (ContainerSourceCollection* self,
                                                    SourceCollection* collection);
GType video_source_collection_get_type (void) G_GNUC_CONST;
static gboolean tag_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                          DataSource* source);
gint64 data_source_get_instance_id (DataSource* self);
static GeeCollection* tag_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                                         DataSource* source);
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
static ContainerSource* tag_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                                           SourceBacklink* backlink);
GType tag_id_get_type (void) G_GNUC_CONST;
TagID* tag_id_dup (const TagID* self);
void tag_id_free (TagID* self);
gint64 source_backlink_get_instance_id (SourceBacklink* self);
void tag_id_init (TagID *self,
                  gint64 id);
Tag* tag_source_collection_fetch (TagSourceCollection* self,
                                  TagID* tag_id);
GeeCollection* container_source_collection_get_holding_tank (ContainerSourceCollection* self);
void tag_get_tag_id (Tag* self,
                     TagID* result);
gchar* tag_get_path (Tag* self);
#define TAG_PATH_SEPARATOR_STRING "/"
GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
gchar* hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path);
void tag_promote (Tag* self);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
gboolean tag_source_collection_exists (TagSourceCollection* self,
                                       const gchar* name,
                                       gboolean treat_htags_as_root);
Tag* tag_source_collection_fetch_by_name (TagSourceCollection* self,
                                          const gchar* name,
                                          gboolean treat_htags_as_root);
GeeCollection* tag_source_collection_get_all_names (TagSourceCollection* self);
GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                                             MediaSource* photo);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
Tag* tag_source_collection_restore_tag_from_holding_tank (TagSourceCollection* self,
                                                          const gchar* name);
gchar* data_object_get_name (DataObject* self);
gboolean container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self,
                                                               ContainerSource* source);
static void tag_source_collection_real_notify_items_added (DataCollection* base,
                                                    GeeIterable* added);
void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
static void tag_source_collection_real_notify_items_removed (DataCollection* base,
                                                      GeeIterable* removed);
Tag* tag_get_hierarchical_parent (Tag* self);
GeeList* tag_get_hierarchical_children (Tag* self);
void tag_flatten (Tag* self);
void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
static void tag_source_collection_real_notify_items_altered (DataCollection* base,
                                                      GeeMap* map);
gboolean data_source_equals (DataSource* self,
                             DataSource* source);
void data_collection_notify_items_altered (DataCollection* self,
                                           GeeMap* items);
static void tag_source_collection_real_notify_container_contents_added (ContainerSourceCollection* base,
                                                                 ContainerSource* container,
                                                                 GeeCollection* added,
                                                                 gboolean relinking);
gint tag_compare_names (Tag* a,
                        Tag* b);
static gint _tag_compare_names_gcompare_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self);
void container_source_collection_notify_container_contents_added (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked);
static void tag_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* base,
                                                                   ContainerSource* container,
                                                                   GeeCollection* removed,
                                                                   gboolean unlinking);
void container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
static void tag_source_collection_finalize (DataCollection * obj);
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
gpointer source_proxy_ref (gpointer instance);
void source_proxy_unref (gpointer instance);
GParamSpec* param_spec_source_proxy (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_source_proxy (GValue* value,
                             gpointer v_object);
void value_take_source_proxy (GValue* value,
                              gpointer v_object);
gpointer value_get_source_proxy (const GValue* value);
GType source_proxy_get_type (void) G_GNUC_CONST;
GType proxyable_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
gpointer tag_row_ref (gpointer instance);
void tag_row_unref (gpointer instance);
GParamSpec* param_spec_tag_row (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_tag_row (GValue* value,
                        gpointer v_object);
void value_take_tag_row (GValue* value,
                         gpointer v_object);
gpointer value_get_tag_row (const GValue* value);
GType tag_row_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
#define TAG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAG, TagPrivate))
GType data_view_get_type (void) G_GNUC_CONST;
static void tag_on_media_views_contents_altered (Tag* self,
                                          GeeIterable* added,
                                          GeeIterable* removed);
static void _tag_on_media_views_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            GeeIterable* removed,
                                                                            gpointer self);
static void tag_on_sources_destroyed (Tag* self,
                               GeeCollection* sources);
static void _tag_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                  GeeCollection* destroyed,
                                                                  gpointer self);
#define TAG_TAG_LIST_SEPARATOR_STRING ", "
static Tag* tag_new (TagRow* row,
              gint64 object_id);
static Tag* tag_construct (GType object_type,
                    TagRow* row,
                    gint64 object_id);
DataSource* data_source_construct (GType object_type,
                                   gint64 object_id);
gchar* tag_prep_tag_name (const gchar* name);
GType thumbnail_view_get_type (void) G_GNUC_CONST;
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
void value_set_media_collection_registry (GValue* value,
                                          gpointer v_object);
void value_take_media_collection_registry (GValue* value,
                                           gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
MediaCollectionRegistry* media_collection_registry_get_instance (void);
MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self,
                                                    const gchar* source_id);
ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
ThumbnailView* thumbnail_view_construct (GType object_type,
                                         ThumbnailSource* source);
ViewCollection* view_collection_new (const gchar* name);
ViewCollection* view_collection_construct (GType object_type,
                                           const gchar* name);
GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         void* monitor_target);
void container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* added,
                                                                    gboolean relinked,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
static void tag_update_indexable_keywords (Tag* self);
void tag_init (ProgressMonitor monitor,
               void* monitor_target);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType tag_table_get_type (void) G_GNUC_CONST;
TagTable* tag_table_get_instance (void);
GQuark database_error_quark (void);
GeeList* tag_table_get_all_rows (TagTable* self,
                                 GError** error);
void app_window_database_error (GError* err);
void tag_table_remove (TagTable* self,
                       TagID* tag_id,
                       GError** error);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
gboolean container_source_has_links (ContainerSource* self);
void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
GeeCollection* tag_get_sources (Tag* self);
gchar* tag_get_user_visible_name (Tag* self);
void tag_attach_many (Tag* self,
                      GeeCollection* sources);
GeeMultiMap* tag_detach_many (Tag* self,
                              GeeCollection* sources);
gboolean data_source_destroy_orphan (DataSource* self,
                                     gboolean delete_backing);
gint tag_get_sources_count (Tag* self);
void container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self,
                                                         GeeCollection* unlinked);
void tag_terminate (void);
gint string_precollated_compare (const gchar* astr,
                                 const gchar* akey,
                                 const gchar* bstr,
                                 const gchar* bkey);
gchar* tag_get_name_collation_key (Tag* self);
gint tag_compare_user_visible_names (Tag* a,
                                     Tag* b);
guint string_collated_hash (void* ptr);
gboolean string_collated_equals (void* a,
                                 void* b);
Tag* tag_for_path (const gchar* name);
TagRow* tag_table_add (TagTable* self,
                       const gchar* name,
                       GError** error);
gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
GeeCollection* tag_get_terminal_tags (GeeCollection* tags);
GeeList* tag_make_user_visible_tag_list (GeeCollection* tags);
static gint _tag_compare_user_visible_names_gcompare_data_func (gconstpointer a,
                                                         gconstpointer b,
                                                         gpointer self);
gchar* tag_make_tag_markup_string (GeeList* tags,
                                   gint highlight_index);
gchar* guarded_markup_escape_text (const gchar* plain);
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gchar** tag_prep_tag_names (gchar** names,
                            int names_length1,
                            int* result_length1);
static void _vala_array_add127 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void tag_set_raw_flat_name (Tag* self,
                            const gchar* name);
void tag_table_rename (TagTable* self,
                       TagID* tag_id,
                       const gchar* new_name,
                       GError** error);
void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
static void tag_set_raw_path (Tag* self,
                       const gchar* path,
                       gboolean suppress_notify);
static gchar* tag_real_get_typename (DataSource* base);
static gint64 tag_real_get_instance_id (DataSource* base);
static gchar* tag_real_get_name (DataObject* base);
gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
gchar* tag_get_searchable_name (Tag* self);
gchar* string_remove_diacritics (const gchar* istring);
gint tag_get_attachment_count (Tag* self,
                               MediaSource* source);
gboolean tag_contains (Tag* self,
                       MediaSource* source);
static gchar* tag_get_next_untitled_tag_name (const gchar* _prefix);
Tag* tag_create_new_child (Tag* self);
Tag* tag_create_new_root (void);
static gchar* tag_real_to_string (DataObject* base);
gint data_collection_get_count (DataCollection* self);
static gboolean tag_real_equals (DataSource* base,
                          DataSource* source);
static SourceSnapshot* tag_real_save_snapshot (DataSource* base);
static TagTagSnapshot* tag_tag_snapshot_new (Tag* tag);
static TagTagSnapshot* tag_tag_snapshot_construct (GType object_type,
                                            Tag* tag);
static GType tag_tag_snapshot_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SourceProxy* tag_real_get_proxy (Proxyable* base);
static TagTagProxy* tag_tag_proxy_new (Tag* tag);
static TagTagProxy* tag_tag_proxy_construct (GType object_type,
                                      Tag* tag);
static GType tag_tag_proxy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
Tag* tag_reconstitute (gint64 object_id,
                       TagRow* row);
void tag_table_create_from_row (TagTable* self,
                                TagRow* row,
                                TagID* result,
                                GError** error);
gchar* data_object_to_string (DataObject* self);
static gboolean tag_real_has_links (ContainerSource* base);
gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
SourceBacklink* container_source_get_backlink (ContainerSource* self);
static SourceBacklink* tag_real_get_backlink (ContainerSource* base);
SourceBacklink* source_backlink_new_from_source (DataSource* source);
SourceBacklink* source_backlink_construct_from_source (GType object_type,
                                                       DataSource* source);
static void tag_real_break_link (ContainerSource* base,
                          DataSource* source);
GeeList* tag_detach (Tag* self,
                     MediaSource* source);
static void tag_real_break_link_many (ContainerSource* base,
                               GeeCollection* sources);
static void tag_real_establish_link (ContainerSource* base,
                              DataSource* source);
void tag_attach (Tag* self,
                 MediaSource* source);
static void tag_real_establish_link_many (ContainerSource* base,
                                   GeeCollection* sources);
gchar* indexable_prepare_indexable_string (const gchar* str);
static const gchar* tag_real_get_indexable_keywords (Indexable* base);
gboolean view_collection_has_view_for_source (ViewCollection* self,
                                              DataSource* source);
DataView* view_collection_get_view_for_source (ViewCollection* self,
                                               DataSource* source);
void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
Marker* data_collection_mark (DataCollection* self,
                              DataObject* object);
Marker* data_collection_start_marking (DataCollection* self);
void marker_mark (Marker* self,
                  DataObject* object);
gboolean tag_rename (Tag* self,
                     const gchar* name);
GeeCollection* view_collection_get_sources (ViewCollection* self);
void tag_mirror_sources (Tag* self,
                         ViewCollection* view,
                         CreateView mirroring_ctor,
                         void* mirroring_ctor_target);
void view_collection_mirror (ViewCollection* self,
                             ViewCollection* to_mirror,
                             CreateView mirroring_ctor,
                             void* mirroring_ctor_target,
                             CreateViewPredicate should_mirror,
                             void* should_mirror_target);
DataSource* data_view_get_source (DataView* self);
gchar* data_source_get_source_id (DataSource* self);
void tag_table_set_tagged_sources (TagTable* self,
                                   TagID* tag_id,
                                   GeeCollection* source_ids,
                                   GError** error);
static void tag_real_destroy (DataSource* base);
void data_collection_clear (DataCollection* self);
void data_source_destroy (DataSource* self);
#define TAG_TAG_SNAPSHOT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshotPrivate))
static void tag_tag_snapshot_on_source_destroyed (TagTagSnapshot* self,
                                           DataSource* source);
static void _tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                             DataSource* source,
                                                                             gpointer self);
SourceSnapshot* source_snapshot_construct (GType object_type);
static TagRow* tag_tag_snapshot_get_row (TagTagSnapshot* self);
static void tag_tag_snapshot_real_notify_broken (SourceSnapshot* base);
TagRow* tag_row_new (void);
TagRow* tag_row_construct (GType object_type);
void source_snapshot_notify_broken (SourceSnapshot* self);
static void tag_tag_snapshot_finalize (SourceSnapshot * obj);
SourceProxy* source_proxy_construct (GType object_type,
                                     DataSource* source);
static DataSource* tag_tag_proxy_real_reconstitute (SourceProxy* base,
                                             gint64 object_id,
                                             SourceSnapshot* snapshot);
static void tag_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static void
_tag_source_collection_on_photo_source_reimported_library_photo_source_collection_source_reimported (LibraryPhotoSourceCollection* _sender,
                                                                                                     LibraryPhoto* photo,
                                                                                                     PhotoMetadata* metadata,
                                                                                                     gpointer self)
{
#line 26 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_source_collection_on_photo_source_reimported ((TagSourceCollection*) self, photo, metadata);
#line 1229 "Tag.c"
}


static guint
_tag_hash_name_string_gee_hash_data_func (gconstpointer v,
                                          gpointer self)
{
	guint result;
	result = tag_hash_name_string ((const gchar*) v);
#line 8 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1241 "Tag.c"
}


static gboolean
_tag_equal_name_strings_gee_equal_data_func (gconstpointer a,
                                             gconstpointer b,
                                             gpointer self)
{
	gboolean result;
	result = tag_equal_name_strings ((const gchar*) a, (const gchar*) b);
#line 8 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1254 "Tag.c"
}


static gint64
_tag_source_collection_get_tag_key_get_source_database_key (DataSource* source,
                                                            gpointer self)
{
	gint64 result;
	result = tag_source_collection_get_tag_key (source);
#line 16 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1266 "Tag.c"
}


TagSourceCollection*
tag_source_collection_construct (GType object_type)
{
	TagSourceCollection* self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	VideoSourceCollection* _tmp1_;
	LibraryPhotoSourceCollection* _tmp2_;
#line 16 "/home/jens/Source/shotwell/src/Tag.vala"
	self = (TagSourceCollection*) container_source_collection_construct (object_type, TAG_TYPENAME, "TagSourceCollection", _tag_source_collection_get_tag_key_get_source_database_key, NULL);
#line 18 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = library_photo_global;
#line 18 "/home/jens/Source/shotwell/src/Tag.vala"
	container_source_collection_attach_collection (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection));
#line 19 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = video_global;
#line 19 "/home/jens/Source/shotwell/src/Tag.vala"
	container_source_collection_attach_collection (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_COLLECTION, SourceCollection));
#line 22 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = library_photo_global;
#line 22 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect (_tmp2_, "source-reimported", (GCallback) _tag_source_collection_on_photo_source_reimported_library_photo_source_collection_source_reimported, self);
#line 15 "/home/jens/Source/shotwell/src/Tag.vala"
	return self;
#line 1293 "Tag.c"
}


TagSourceCollection*
tag_source_collection_new (void)
{
#line 15 "/home/jens/Source/shotwell/src/Tag.vala"
	return tag_source_collection_construct (TYPE_TAG_SOURCE_COLLECTION);
#line 1302 "Tag.c"
}


static gboolean
tag_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                 DataSource* source)
{
	TagSourceCollection * self;
	gboolean result = FALSE;
#line 29 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 29 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 30 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (source, TYPE_TAG);
#line 30 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1320 "Tag.c"
}


static gint64
tag_source_collection_get_tag_key (DataSource* source)
{
	gint64 result = 0LL;
#line 33 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 34 "/home/jens/Source/shotwell/src/Tag.vala"
	result = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag), TYPE_DATA_SOURCE, DataSource));
#line 34 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1334 "Tag.c"
}


static GeeCollection*
tag_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                          DataSource* source)
{
	TagSourceCollection * self;
	GeeCollection* result = NULL;
	GeeList* _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 37 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 38 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_source_collection_fetch_for_source (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
#line 38 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 38 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1355 "Tag.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 48 "/home/jens/Source/shotwell/src/Tag.vala"
	return self ? g_object_ref (self) : NULL;
#line 1364 "Tag.c"
}


static ContainerSource*
tag_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                          SourceBacklink* backlink)
{
	TagSourceCollection * self;
	ContainerSource* result = NULL;
	TagID tag_id = {0};
	gint64 _tmp0_;
	gint64 _tmp1_;
	Tag* _result_ = NULL;
	Tag* tag = NULL;
	TagID _tmp2_;
	Tag* _tmp3_;
	Tag* _tmp4_;
	Tag* _tmp23_;
#line 41 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 41 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), NULL);
#line 42 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = source_backlink_get_instance_id (backlink);
#line 42 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_id_init (&tag_id, _tmp1_);
#line 43 "/home/jens/Source/shotwell/src/Tag.vala"
	_result_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_id;
#line 46 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = tag_source_collection_fetch (self, &_tmp2_);
#line 46 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp3_;
#line 47 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = tag;
#line 47 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp4_ != NULL) {
#line 1405 "Tag.c"
		Tag* _tmp5_;
		Tag* _tmp6_;
#line 48 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = tag;
#line 48 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 48 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_result_);
#line 48 "/home/jens/Source/shotwell/src/Tag.vala"
		_result_ = _tmp6_;
#line 1416 "Tag.c"
	} else {
		{
			GeeIterator* _container_it = NULL;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = container_source_collection_get_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection));
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _tmp7_;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = _tmp9_;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp8_);
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_container_it = _tmp10_;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 1438 "Tag.c"
				GeeIterator* _tmp11_;
				ContainerSource* container = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				ContainerSource* _tmp14_;
				Tag* _tmp15_;
				Tag* _tmp16_;
				TagID _tmp17_ = {0};
				gint64 _tmp18_;
				TagID _tmp19_;
				gint64 _tmp20_;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = _container_it;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp11_)) {
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 1456 "Tag.c"
				}
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = _container_it;
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = gee_iterator_get (_tmp12_);
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				container = (ContainerSource*) _tmp13_;
#line 52 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = container;
#line 52 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_TAG, Tag));
#line 52 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tag);
#line 52 "/home/jens/Source/shotwell/src/Tag.vala"
				tag = _tmp15_;
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = tag;
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				tag_get_tag_id (_tmp16_, &_tmp17_);
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = _tmp17_.id;
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = tag_id;
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = _tmp19_.id;
#line 53 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp18_ == _tmp20_) {
#line 1484 "Tag.c"
					Tag* _tmp21_;
					Tag* _tmp22_;
#line 54 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp21_ = tag;
#line 54 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp22_ = _g_object_ref0 (_tmp21_);
#line 54 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_result_);
#line 54 "/home/jens/Source/shotwell/src/Tag.vala"
					_result_ = _tmp22_;
#line 55 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (container);
#line 55 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 1499 "Tag.c"
				}
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (container);
#line 1503 "Tag.c"
			}
#line 51 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_container_it);
#line 1507 "Tag.c"
		}
	}
#line 63 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp23_ = _result_;
#line 63 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp23_ != NULL) {
#line 1514 "Tag.c"
		gboolean _tmp24_ = FALSE;
		Tag* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gboolean _tmp28_;
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp25_ = _result_;
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp26_ = tag_get_path (_tmp25_);
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp27_ = _tmp26_;
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp28_ = g_str_has_prefix (_tmp27_, TAG_PATH_SEPARATOR_STRING);
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (_tmp27_);
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		if (_tmp28_) {
#line 1532 "Tag.c"
			Tag* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GeeList* _tmp32_;
			GeeList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp29_ = _result_;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp30_ = tag_get_path (_tmp29_);
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp31_ = _tmp30_;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp32_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp31_);
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp33_ = _tmp32_;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp34_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection));
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp35_ = _tmp34_;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = _tmp35_ > 0;
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp33_);
#line 65 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp31_);
#line 1560 "Tag.c"
		} else {
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = FALSE;
#line 1564 "Tag.c"
		}
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
		if (_tmp24_) {
#line 1568 "Tag.c"
			gchar* top_level_with_prefix_path = NULL;
			Tag* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			GeeList* _tmp39_;
			GeeList* _tmp40_;
			gpointer _tmp41_;
			gchar* _tmp42_;
			gchar* top_level_no_prefix_path = NULL;
			const gchar* _tmp43_;
			gchar* _tmp44_;
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp36_ = _result_;
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp37_ = tag_get_path (_tmp36_);
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp38_ = _tmp37_;
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp39_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp38_);
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp40_ = _tmp39_;
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp41_ = gee_list_get (_tmp40_, 0);
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp42_ = (gchar*) _tmp41_;
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp40_);
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp38_);
#line 66 "/home/jens/Source/shotwell/src/Tag.vala"
			top_level_with_prefix_path = _tmp42_;
#line 68 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp43_ = top_level_with_prefix_path;
#line 68 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp44_ = hierarchical_tag_utilities_hierarchical_to_flat (_tmp43_);
#line 68 "/home/jens/Source/shotwell/src/Tag.vala"
			top_level_no_prefix_path = _tmp44_;
#line 1606 "Tag.c"
			{
				GeeIterator* _container_it = NULL;
				GeeCollection* _tmp45_;
				GeeCollection* _tmp46_;
				GeeIterator* _tmp47_;
				GeeIterator* _tmp48_;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp45_ = container_source_collection_get_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection));
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp46_ = _tmp45_;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp47_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ITERABLE, GeeIterable));
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp48_ = _tmp47_;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp46_);
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_container_it = _tmp48_;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				while (TRUE) {
#line 1627 "Tag.c"
					GeeIterator* _tmp49_;
					ContainerSource* container = NULL;
					GeeIterator* _tmp50_;
					gpointer _tmp51_;
					Tag* parent_candidate = NULL;
					ContainerSource* _tmp52_;
					Tag* _tmp53_;
					Tag* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					const gchar* _tmp57_;
					gboolean _tmp58_;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp49_ = _container_it;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					if (!gee_iterator_next (_tmp49_)) {
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
						break;
#line 1646 "Tag.c"
					}
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp50_ = _container_it;
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp51_ = gee_iterator_get (_tmp50_);
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					container = (ContainerSource*) _tmp51_;
#line 72 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp52_ = container;
#line 72 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_TAG, Tag));
#line 72 "/home/jens/Source/shotwell/src/Tag.vala"
					parent_candidate = _tmp53_;
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp54_ = parent_candidate;
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp55_ = tag_get_path (_tmp54_);
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp56_ = _tmp55_;
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp57_ = top_level_no_prefix_path;
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp58_ = g_strcmp0 (_tmp56_, _tmp57_) == 0;
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (_tmp56_);
#line 73 "/home/jens/Source/shotwell/src/Tag.vala"
					if (_tmp58_) {
#line 1674 "Tag.c"
						Tag* _tmp59_;
#line 74 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp59_ = parent_candidate;
#line 74 "/home/jens/Source/shotwell/src/Tag.vala"
						tag_promote (_tmp59_);
#line 1680 "Tag.c"
					}
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (parent_candidate);
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (container);
#line 1686 "Tag.c"
				}
#line 71 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_container_it);
#line 1690 "Tag.c"
			}
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (top_level_no_prefix_path);
#line 64 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (top_level_with_prefix_path);
#line 1696 "Tag.c"
		}
	}
#line 79 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, TYPE_CONTAINER_SOURCE, ContainerSource);
#line 79 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (tag);
#line 79 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1705 "Tag.c"
}


Tag*
tag_source_collection_fetch (TagSourceCollection* self,
                             TagID* tag_id)
{
	Tag* result = NULL;
	TagID _tmp0_;
	gint64 _tmp1_;
	DataSource* _tmp2_;
#line 82 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 82 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (tag_id != NULL, NULL);
#line 83 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = *tag_id;
#line 83 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_.id;
#line 83 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp1_);
#line 83 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TAG, Tag);
#line 83 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1731 "Tag.c"
}


gboolean
tag_source_collection_exists (TagSourceCollection* self,
                              const gchar* name,
                              gboolean treat_htags_as_root)
{
	gboolean result = FALSE;
	Tag* _tmp0_;
	Tag* _tmp1_;
	gboolean _tmp2_;
#line 86 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), FALSE);
#line 86 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_source_collection_fetch_by_name (self, name, treat_htags_as_root);
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = _tmp1_ != NULL;
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp1_);
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp2_;
#line 87 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1760 "Tag.c"
}


GeeCollection*
tag_source_collection_get_all_names (TagSourceCollection* self)
{
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 90 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 91 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->name_map;
#line 91 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 91 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = _tmp1_;
#line 91 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 91 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1783 "Tag.c"
}


GeeList*
tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                        MediaSource* source)
{
	GeeList* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 98 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
#line 99 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->source_map;
#line 99 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), source);
#line 99 "/home/jens/Source/shotwell/src/Tag.vala"
	result = (GeeList*) _tmp1_;
#line 99 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1806 "Tag.c"
}


GeeSortedSet*
tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                               MediaSource* photo)
{
	GeeSortedSet* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 106 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 106 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (photo), NULL);
#line 107 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->sorted_source_map;
#line 107 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 107 "/home/jens/Source/shotwell/src/Tag.vala"
	result = (GeeSortedSet*) _tmp1_;
#line 107 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1829 "Tag.c"
}


Tag*
tag_source_collection_fetch_by_name (TagSourceCollection* self,
                                     const gchar* name,
                                     gboolean treat_htags_as_root)
{
	Tag* result = NULL;
	GeeHashMap* _tmp17_;
	gpointer _tmp18_;
#line 112 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 112 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 113 "/home/jens/Source/shotwell/src/Tag.vala"
	if (treat_htags_as_root) {
#line 114 "/home/jens/Source/shotwell/src/Tag.vala"
		if (g_str_has_prefix (name, TAG_PATH_SEPARATOR_STRING)) {
#line 1849 "Tag.c"
			GeeList* _tmp0_;
			GeeList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gboolean _tmp4_;
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp0_ = hierarchical_tag_utilities_enumerate_path_components (name);
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp1_ = _tmp0_;
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = _tmp2_;
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _tmp3_ == 1;
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp1_);
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp4_) {
#line 1869 "Tag.c"
				Tag* tag = NULL;
				GeeHashMap* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gpointer _tmp8_;
				Tag* _tmp9_;
				Tag* _tmp10_;
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = self->priv->name_map;
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp6_ = hierarchical_tag_utilities_hierarchical_to_flat (name);
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp7_ = _tmp6_;
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp9_ = (Tag*) _tmp8_;
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp7_);
#line 116 "/home/jens/Source/shotwell/src/Tag.vala"
				tag = _tmp9_;
#line 117 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp10_ = tag;
#line 117 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp10_ != NULL) {
#line 118 "/home/jens/Source/shotwell/src/Tag.vala"
					result = tag;
#line 118 "/home/jens/Source/shotwell/src/Tag.vala"
					return result;
#line 1899 "Tag.c"
				}
#line 115 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tag);
#line 1903 "Tag.c"
			}
		} else {
			Tag* tag = NULL;
			GeeHashMap* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gpointer _tmp14_;
			Tag* _tmp15_;
			Tag* _tmp16_;
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = self->priv->name_map;
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = hierarchical_tag_utilities_flat_to_hierarchical (name);
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = _tmp12_;
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = (Tag*) _tmp14_;
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp13_);
#line 121 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = _tmp15_;
#line 122 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = tag;
#line 122 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp16_ != NULL) {
#line 123 "/home/jens/Source/shotwell/src/Tag.vala"
				result = tag;
#line 123 "/home/jens/Source/shotwell/src/Tag.vala"
				return result;
#line 1935 "Tag.c"
			}
#line 114 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 1939 "Tag.c"
		}
	}
#line 127 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp17_ = self->priv->name_map;
#line 127 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp18_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 127 "/home/jens/Source/shotwell/src/Tag.vala"
	result = (Tag*) _tmp18_;
#line 127 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 1950 "Tag.c"
}


Tag*
tag_source_collection_restore_tag_from_holding_tank (TagSourceCollection* self,
                                                     const gchar* name)
{
	Tag* result = NULL;
	Tag* found = NULL;
	Tag* _tmp15_;
#line 130 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_SOURCE_COLLECTION (self), NULL);
#line 130 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 131 "/home/jens/Source/shotwell/src/Tag.vala"
	found = NULL;
#line 1967 "Tag.c"
	{
		GeeIterator* _container_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = container_source_collection_get_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection));
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp1_);
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_container_it = _tmp3_;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 1988 "Tag.c"
			GeeIterator* _tmp4_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Tag* tag = NULL;
			ContainerSource* _tmp7_;
			Tag* _tmp8_;
			Tag* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _container_it;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2006 "Tag.c"
			}
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _container_it;
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			container = (ContainerSource*) _tmp6_;
#line 133 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = container;
#line 133 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TAG, Tag));
#line 133 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = _tmp8_;
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = tag;
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = _tmp10_;
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = g_strcmp0 (_tmp11_, name) == 0;
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp11_);
#line 134 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp12_) {
#line 2032 "Tag.c"
				Tag* _tmp13_;
				Tag* _tmp14_;
#line 135 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = tag;
#line 135 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = _g_object_ref0 (_tmp13_);
#line 135 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (found);
#line 135 "/home/jens/Source/shotwell/src/Tag.vala"
				found = _tmp14_;
#line 137 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tag);
#line 137 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (container);
#line 137 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2049 "Tag.c"
			}
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (container);
#line 2055 "Tag.c"
		}
#line 132 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_container_it);
#line 2059 "Tag.c"
	}
#line 141 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp15_ = found;
#line 141 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp15_ != NULL) {
#line 2065 "Tag.c"
		gboolean relinked = FALSE;
		Tag* _tmp16_;
		gboolean _tmp17_;
#line 142 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp16_ = found;
#line 142 "/home/jens/Source/shotwell/src/Tag.vala"
		relinked = container_source_collection_relink_from_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_CONTAINER_SOURCE, ContainerSource));
#line 143 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp17_ = relinked;
#line 143 "/home/jens/Source/shotwell/src/Tag.vala"
		_vala_assert (_tmp17_, "relinked");
#line 2077 "Tag.c"
	}
#line 146 "/home/jens/Source/shotwell/src/Tag.vala"
	result = found;
#line 146 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 2083 "Tag.c"
}


static void
tag_source_collection_real_notify_items_added (DataCollection* base,
                                               GeeIterable* added)
{
	TagSourceCollection * self;
#line 149 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 149 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 2096 "Tag.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = gee_iterable_iterator (added);
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
		_object_it = _tmp0_;
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 2106 "Tag.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Tag* tag = NULL;
			DataObject* _tmp4_;
			Tag* _tmp5_;
			GeeHashMap* _tmp6_;
			Tag* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GeeHashMap* _tmp10_;
			Tag* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			Tag* _tmp14_;
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp1_ = _object_it;
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2129 "Tag.c"
			}
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp2_ = _object_it;
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			object = (DataObject*) _tmp3_;
#line 151 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = object;
#line 151 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TAG, Tag));
#line 151 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = _tmp5_;
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = self->priv->name_map;
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = tag;
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _tmp8_;
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_), "!name_map.has_key(tag.get_name())");
#line 153 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp9_);
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = self->priv->name_map;
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = tag;
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = _tmp12_;
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = tag;
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
#line 154 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp13_);
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (object);
#line 2173 "Tag.c"
		}
#line 150 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_object_it);
#line 2177 "Tag.c"
	}
#line 157 "/home/jens/Source/shotwell/src/Tag.vala"
	DATA_COLLECTION_CLASS (tag_source_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added);
#line 2181 "Tag.c"
}


static void
tag_source_collection_real_notify_items_removed (DataCollection* base,
                                                 GeeIterable* removed)
{
	TagSourceCollection * self;
#line 160 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 160 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 2194 "Tag.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = gee_iterable_iterator (removed);
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
		_object_it = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 2204 "Tag.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Tag* tag = NULL;
			DataObject* _tmp4_;
			Tag* _tmp5_;
			gboolean unset = FALSE;
			GeeHashMap* _tmp6_;
			Tag* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			Tag* parent = NULL;
			Tag* _tmp13_;
			Tag* _tmp14_;
			gboolean _tmp15_ = FALSE;
			Tag* _tmp16_;
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp1_ = _object_it;
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2231 "Tag.c"
			}
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp2_ = _object_it;
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			object = (DataObject*) _tmp3_;
#line 162 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = object;
#line 162 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TAG, Tag));
#line 162 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = _tmp5_;
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = self->priv->name_map;
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = tag;
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _tmp8_;
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, NULL);
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = _tmp10_;
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp9_);
#line 164 "/home/jens/Source/shotwell/src/Tag.vala"
			unset = _tmp11_;
#line 165 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = unset;
#line 165 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp12_, "unset");
#line 169 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = tag;
#line 169 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = tag_get_hierarchical_parent (_tmp13_);
#line 169 "/home/jens/Source/shotwell/src/Tag.vala"
			parent = _tmp14_;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = parent;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp16_ != NULL) {
#line 2275 "Tag.c"
				Tag* _tmp17_;
				Tag* _tmp18_;
				Tag* _tmp19_;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = parent;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = tag_get_hierarchical_parent (_tmp17_);
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = _tmp18_;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = _tmp19_ == NULL;
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp19_);
#line 2289 "Tag.c"
			} else {
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = FALSE;
#line 2293 "Tag.c"
			}
#line 170 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp15_) {
#line 2297 "Tag.c"
				Tag* _tmp20_;
				GeeList* _tmp21_;
				GeeList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gboolean _tmp25_;
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = parent;
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = tag_get_hierarchical_children (_tmp20_);
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = _tmp21_;
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp24_ = _tmp23_;
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = _tmp24_ == 0;
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp22_);
#line 171 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp25_) {
#line 2320 "Tag.c"
					Tag* _tmp26_;
#line 172 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp26_ = parent;
#line 172 "/home/jens/Source/shotwell/src/Tag.vala"
					tag_flatten (_tmp26_);
#line 2326 "Tag.c"
				}
			}
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (parent);
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (object);
#line 2335 "Tag.c"
		}
#line 161 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_object_it);
#line 2339 "Tag.c"
	}
#line 176 "/home/jens/Source/shotwell/src/Tag.vala"
	DATA_COLLECTION_CLASS (tag_source_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), removed);
#line 2343 "Tag.c"
}


static void
tag_source_collection_real_notify_items_altered (DataCollection* base,
                                                 GeeMap* map)
{
	TagSourceCollection * self;
#line 179 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 179 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 2356 "Tag.c"
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = gee_map_get_keys (map);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = _tmp0_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = _tmp1_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = _tmp3_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp2_);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_object_it = _tmp4_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 2380 "Tag.c"
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Tag* tag = NULL;
			DataObject* _tmp8_;
			Tag* _tmp9_;
			gchar* old_name = NULL;
			GeeMapIterator* iter = NULL;
			GeeHashMap* _tmp10_;
			GeeMapIterator* _tmp11_;
			const gchar* _tmp20_;
			Tag* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _object_it;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2404 "Tag.c"
			}
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _object_it;
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			object = (DataObject*) _tmp7_;
#line 181 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = object;
#line 181 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TAG, Tag));
#line 181 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = _tmp9_;
#line 183 "/home/jens/Source/shotwell/src/Tag.vala"
			old_name = NULL;
#line 186 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = self->priv->name_map;
#line 186 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = gee_abstract_map_map_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 186 "/home/jens/Source/shotwell/src/Tag.vala"
			iter = _tmp11_;
#line 187 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 2428 "Tag.c"
				GeeMapIterator* _tmp12_;
				GeeMapIterator* _tmp13_;
				gpointer _tmp14_;
				Tag* _tmp15_;
				Tag* _tmp16_;
				gboolean _tmp17_;
				GeeMapIterator* _tmp18_;
				gpointer _tmp19_;
#line 187 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = iter;
#line 187 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_map_iterator_next (_tmp12_)) {
#line 187 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 2443 "Tag.c"
				}
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = iter;
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = gee_map_iterator_get_value (_tmp13_);
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = (Tag*) _tmp14_;
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = tag;
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = !data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_SOURCE, DataSource));
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp15_);
#line 188 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp17_) {
#line 189 "/home/jens/Source/shotwell/src/Tag.vala"
					continue;
#line 2461 "Tag.c"
				}
#line 191 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = iter;
#line 191 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = gee_map_iterator_get_key (_tmp18_);
#line 191 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (old_name);
#line 191 "/home/jens/Source/shotwell/src/Tag.vala"
				old_name = (gchar*) _tmp19_;
#line 193 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2473 "Tag.c"
			}
#line 196 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = old_name;
#line 196 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp20_ != NULL, "old_name != null");
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = tag;
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp22_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp23_ = _tmp22_;
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = old_name;
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp25_ = g_strcmp0 (_tmp23_, _tmp24_) != 0;
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp23_);
#line 198 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp25_) {
#line 2493 "Tag.c"
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				GeeHashMap* _tmp28_;
				Tag* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				Tag* _tmp32_;
#line 199 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp26_ = self->priv->name_map;
#line 199 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp27_ = old_name;
#line 199 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, NULL);
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp28_ = self->priv->name_map;
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp29_ = tag;
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp30_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_OBJECT, DataObject));
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp31_ = _tmp30_;
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp32_ = tag;
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp31_, _tmp32_);
#line 200 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp31_);
#line 2521 "Tag.c"
			}
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (iter);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (old_name);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (object);
#line 2531 "Tag.c"
		}
#line 180 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_object_it);
#line 2535 "Tag.c"
	}
#line 204 "/home/jens/Source/shotwell/src/Tag.vala"
	DATA_COLLECTION_CLASS (tag_source_collection_parent_class)->notify_items_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), map);
#line 2539 "Tag.c"
}


static gint
_tag_compare_names_gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self)
{
	gint result;
	result = tag_compare_names ((Tag*) a, (Tag*) b);
#line 224 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 2552 "Tag.c"
}


static void
tag_source_collection_real_notify_container_contents_added (ContainerSourceCollection* base,
                                                            ContainerSource* container,
                                                            GeeCollection* added,
                                                            gboolean relinking)
{
	TagSourceCollection * self;
	Tag* tag = NULL;
	Tag* _tmp0_;
	GeeCollection* sources = NULL;
	GeeCollection* _tmp1_;
#line 207 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 207 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 207 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (added));
#line 209 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_TAG, Tag));
#line 209 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp0_;
#line 210 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection));
#line 210 "/home/jens/Source/shotwell/src/Tag.vala"
	sources = _tmp1_;
#line 2581 "Tag.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = sources;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
		_source_it = _tmp3_;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 2594 "Tag.c"
			GeeIterator* _tmp4_;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* tags = NULL;
			GeeHashMap* _tmp7_;
			MediaSource* _tmp8_;
			gpointer _tmp9_;
			GeeList* _tmp10_;
			gboolean is_added = FALSE;
			GeeList* _tmp15_;
			Tag* _tmp16_;
			gboolean _tmp17_;
			GeeSortedSet* sorted_tags = NULL;
			GeeHashMap* _tmp18_;
			MediaSource* _tmp19_;
			gpointer _tmp20_;
			GeeSortedSet* _tmp21_;
			GeeSortedSet* _tmp26_;
			Tag* _tmp27_;
			gboolean _tmp28_;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _source_it;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2622 "Tag.c"
			}
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _source_it;
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			source = (MediaSource*) _tmp6_;
#line 213 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = self->priv->source_map;
#line 213 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = source;
#line 213 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
#line 213 "/home/jens/Source/shotwell/src/Tag.vala"
			tags = (GeeList*) _tmp9_;
#line 214 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = tags;
#line 214 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp10_ == NULL) {
#line 2642 "Tag.c"
				GeeArrayList* _tmp11_;
				GeeHashMap* _tmp12_;
				MediaSource* _tmp13_;
				GeeList* _tmp14_;
#line 215 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 215 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tags);
#line 215 "/home/jens/Source/shotwell/src/Tag.vala"
				tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_LIST, GeeList);
#line 216 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = self->priv->source_map;
#line 216 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = source;
#line 216 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = tags;
#line 216 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
#line 2661 "Tag.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = tags;
#line 219 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = tag;
#line 219 "/home/jens/Source/shotwell/src/Tag.vala"
			is_added = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
#line 220 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = is_added;
#line 220 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp17_, "is_added");
#line 222 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp18_ = self->priv->sorted_source_map;
#line 222 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = source;
#line 222 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp19_);
#line 222 "/home/jens/Source/shotwell/src/Tag.vala"
			sorted_tags = (GeeSortedSet*) _tmp20_;
#line 223 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = sorted_tags;
#line 223 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp21_ == NULL) {
#line 2685 "Tag.c"
				GeeTreeSet* _tmp22_;
				GeeHashMap* _tmp23_;
				MediaSource* _tmp24_;
				GeeSortedSet* _tmp25_;
#line 224 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = gee_tree_set_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tag_compare_names_gcompare_data_func, NULL, NULL);
#line 224 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (sorted_tags);
#line 224 "/home/jens/Source/shotwell/src/Tag.vala"
				sorted_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_SORTED_SET, GeeSortedSet);
#line 225 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = self->priv->sorted_source_map;
#line 225 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp24_ = source;
#line 225 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = sorted_tags;
#line 225 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_, _tmp25_);
#line 2704 "Tag.c"
			}
#line 228 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp26_ = sorted_tags;
#line 228 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp27_ = tag;
#line 228 "/home/jens/Source/shotwell/src/Tag.vala"
			is_added = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 229 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp28_ = is_added;
#line 229 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp28_, "is_added");
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (sorted_tags);
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tags);
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (source);
#line 2722 "Tag.c"
		}
#line 212 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_source_it);
#line 2726 "Tag.c"
	}
#line 232 "/home/jens/Source/shotwell/src/Tag.vala"
	CONTAINER_SOURCE_COLLECTION_CLASS (tag_source_collection_parent_class)->notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), container, added, relinking);
#line 207 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (sources);
#line 207 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (tag);
#line 2734 "Tag.c"
}


static void
tag_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* base,
                                                              ContainerSource* container,
                                                              GeeCollection* removed,
                                                              gboolean unlinking)
{
	TagSourceCollection * self;
	Tag* tag = NULL;
	Tag* _tmp0_;
	GeeCollection* sources = NULL;
	GeeCollection* _tmp1_;
#line 235 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 235 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 235 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (removed));
#line 237 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_TAG, Tag));
#line 237 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp0_;
#line 238 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
#line 238 "/home/jens/Source/shotwell/src/Tag.vala"
	sources = _tmp1_;
#line 2763 "Tag.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = sources;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
		_source_it = _tmp3_;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 2776 "Tag.c"
			GeeIterator* _tmp4_;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* tags = NULL;
			GeeHashMap* _tmp7_;
			MediaSource* _tmp8_;
			gpointer _tmp9_;
			GeeList* _tmp10_;
			gboolean is_removed = FALSE;
			GeeList* _tmp11_;
			Tag* _tmp12_;
			gboolean _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeSortedSet* sorted_tags = NULL;
			GeeHashMap* _tmp19_;
			MediaSource* _tmp20_;
			gpointer _tmp21_;
			GeeSortedSet* _tmp22_;
			GeeSortedSet* _tmp23_;
			Tag* _tmp24_;
			gboolean _tmp25_;
			GeeSortedSet* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _source_it;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 2810 "Tag.c"
			}
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _source_it;
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			source = (MediaSource*) _tmp6_;
#line 241 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = self->priv->source_map;
#line 241 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = source;
#line 241 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
#line 241 "/home/jens/Source/shotwell/src/Tag.vala"
			tags = (GeeList*) _tmp9_;
#line 242 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = tags;
#line 242 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp10_ != NULL, "tags != null");
#line 244 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = tags;
#line 244 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = tag;
#line 244 "/home/jens/Source/shotwell/src/Tag.vala"
			is_removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
#line 245 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = is_removed;
#line 245 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp13_, "is_removed");
#line 247 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = tags;
#line 247 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
#line 247 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = _tmp15_;
#line 247 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp16_ == 0) {
#line 2848 "Tag.c"
				GeeHashMap* _tmp17_;
				MediaSource* _tmp18_;
#line 248 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = self->priv->source_map;
#line 248 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = source;
#line 248 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_, NULL);
#line 2857 "Tag.c"
			}
#line 250 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = self->priv->sorted_source_map;
#line 250 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = source;
#line 250 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_);
#line 250 "/home/jens/Source/shotwell/src/Tag.vala"
			sorted_tags = (GeeSortedSet*) _tmp21_;
#line 251 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp22_ = sorted_tags;
#line 251 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp22_ != NULL, "sorted_tags != null");
#line 253 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp23_ = sorted_tags;
#line 253 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = tag;
#line 253 "/home/jens/Source/shotwell/src/Tag.vala"
			is_removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_);
#line 254 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp25_ = is_removed;
#line 254 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp25_, "is_removed");
#line 256 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp26_ = sorted_tags;
#line 256 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp27_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
#line 256 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp28_ = _tmp27_;
#line 256 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp28_ == 0) {
#line 2889 "Tag.c"
				GeeHashMap* _tmp29_;
				MediaSource* _tmp30_;
#line 257 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp29_ = self->priv->sorted_source_map;
#line 257 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp30_ = source;
#line 257 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp30_, NULL);
#line 2898 "Tag.c"
			}
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (sorted_tags);
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tags);
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (source);
#line 2906 "Tag.c"
		}
#line 240 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_source_it);
#line 2910 "Tag.c"
	}
#line 260 "/home/jens/Source/shotwell/src/Tag.vala"
	CONTAINER_SOURCE_COLLECTION_CLASS (tag_source_collection_parent_class)->notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), container, removed, unlinking);
#line 235 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (sources);
#line 235 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (tag);
#line 2918 "Tag.c"
}


static void
tag_source_collection_on_photo_source_reimported (TagSourceCollection* self,
                                                  LibraryPhoto* photo,
                                                  PhotoMetadata* metadata)
{
#line 263 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG_SOURCE_COLLECTION (self));
#line 263 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 263 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 2933 "Tag.c"
}


static void
tag_source_collection_class_init (TagSourceCollectionClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataCollectionClass *) klass)->finalize = tag_source_collection_finalize;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	g_type_class_add_private (klass, sizeof (TagSourceCollectionPrivate));
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection *, DataSource*)) tag_source_collection_real_holds_type_of_source;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection *, DataSource*)) tag_source_collection_real_get_containers_holding_source;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection *, SourceBacklink*)) tag_source_collection_real_convert_backlink_to_container;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection *, GeeIterable*)) tag_source_collection_real_notify_items_added;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection *, GeeIterable*)) tag_source_collection_real_notify_items_removed;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection *, GeeMap*)) tag_source_collection_real_notify_items_altered;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_added = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*, gboolean)) tag_source_collection_real_notify_container_contents_added;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_removed = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*, gboolean)) tag_source_collection_real_notify_container_contents_removed;
#line 2962 "Tag.c"
}


static void
tag_source_collection_instance_init (TagSourceCollection * self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv = TAG_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tag_hash_name_string_gee_hash_data_func, NULL, NULL, _tag_equal_name_strings_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 8 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->name_map = _tmp0_;
#line 10 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 10 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->source_map = _tmp1_;
#line 12 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_SORTED_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 12 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->sorted_source_map = _tmp2_;
#line 2986 "Tag.c"
}


static void
tag_source_collection_finalize (DataCollection * obj)
{
	TagSourceCollection * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection);
#line 26 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = library_photo_global;
#line 26 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("source-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
#line 26 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tag_source_collection_on_photo_source_reimported_library_photo_source_collection_source_reimported, self);
#line 8 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (self->priv->name_map);
#line 10 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (self->priv->source_map);
#line 12 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (self->priv->sorted_source_map);
#line 7 "/home/jens/Source/shotwell/src/Tag.vala"
	DATA_COLLECTION_CLASS (tag_source_collection_parent_class)->finalize (obj);
#line 3012 "Tag.c"
}


GType
tag_source_collection_get_type (void)
{
	static volatile gsize tag_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&tag_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TagSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagSourceCollection), 0, (GInstanceInitFunc) tag_source_collection_instance_init, NULL };
		GType tag_source_collection_type_id;
		tag_source_collection_type_id = g_type_register_static (TYPE_CONTAINER_SOURCE_COLLECTION, "TagSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&tag_source_collection_type_id__volatile, tag_source_collection_type_id);
	}
	return tag_source_collection_type_id__volatile;
}


static void
_tag_on_media_views_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       GeeIterable* removed,
                                                                       gpointer self)
{
#line 382 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_on_media_views_contents_altered ((Tag*) self, added, removed);
#line 3038 "Tag.c"
}


static void
_tag_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                             GeeCollection* destroyed,
                                                             gpointer self)
{
#line 383 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_on_sources_destroyed ((Tag*) self, destroyed);
#line 3049 "Tag.c"
}


static gpointer
_tag_row_ref0 (gpointer self)
{
#line 335 "/home/jens/Source/shotwell/src/Tag.vala"
	return self ? tag_row_ref (self) : NULL;
#line 3058 "Tag.c"
}


static Tag*
tag_construct (GType object_type,
               TagRow* row,
               gint64 object_id)
{
	Tag * self = NULL;
	TagRow* _tmp0_;
	TagRow* _tmp1_;
	TagRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* source_list = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* thumbnail_views = NULL;
	GeeArrayList* _tmp6_;
	TagRow* _tmp7_;
	GeeSet* _tmp8_;
	TagID _tmp29_;
	gint64 _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	ViewCollection* _tmp35_;
	ViewCollection* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* _tmp39_;
	GeeArrayList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	ViewCollection* _tmp47_;
	LibraryPhotoSourceCollection* _tmp48_;
	VideoSourceCollection* _tmp49_;
#line 332 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_ROW (row), NULL);
#line 333 "/home/jens/Source/shotwell/src/Tag.vala"
	self = (Tag*) data_source_construct (object_type, object_id);
#line 335 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _tag_row_ref0 (row);
#line 335 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (self->priv->row);
#line 335 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->row = _tmp0_;
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = self->priv->row;
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = self->priv->row;
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_->name;
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = tag_prep_tag_name (_tmp3_);
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_->name);
#line 338 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_->name = _tmp4_;
#line 341 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 341 "/home/jens/Source/shotwell/src/Tag.vala"
	source_list = _tmp5_;
#line 342 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 342 "/home/jens/Source/shotwell/src/Tag.vala"
	thumbnail_views = _tmp6_;
#line 343 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = self->priv->row;
#line 343 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = _tmp7_->source_id_list;
#line 343 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp8_ != NULL) {
#line 3132 "Tag.c"
		{
			GeeIterator* _source_id_it = NULL;
			TagRow* _tmp9_;
			GeeSet* _tmp10_;
			GeeIterator* _tmp11_;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = self->priv->row;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = _tmp9_->source_id_list;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			_source_id_it = _tmp11_;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 3148 "Tag.c"
				GeeIterator* _tmp12_;
				gchar* source_id = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				MediaSource* current_source = NULL;
				MediaCollectionRegistry* _tmp15_;
				MediaCollectionRegistry* _tmp16_;
				const gchar* _tmp17_;
				MediaSource* _tmp18_;
				MediaSource* _tmp19_;
				MediaSource* _tmp20_;
				GeeArrayList* _tmp21_;
				MediaSource* _tmp22_;
				GeeArrayList* _tmp23_;
				MediaSource* _tmp24_;
				ThumbnailView* _tmp25_;
				ThumbnailView* _tmp26_;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = _source_id_it;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp12_)) {
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 3172 "Tag.c"
				}
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = _source_id_it;
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = gee_iterator_get (_tmp13_);
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				source_id = (gchar*) _tmp14_;
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = media_collection_registry_get_instance ();
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = _tmp15_;
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = source_id;
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = media_collection_registry_fetch_media (_tmp16_, _tmp17_);
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MEDIA_SOURCE, MediaSource);
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				_media_collection_registry_unref0 (_tmp16_);
#line 345 "/home/jens/Source/shotwell/src/Tag.vala"
				current_source = _tmp19_;
#line 347 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = current_source;
#line 347 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp20_ == NULL) {
#line 348 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (current_source);
#line 348 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (source_id);
#line 348 "/home/jens/Source/shotwell/src/Tag.vala"
					continue;
#line 3204 "Tag.c"
				}
#line 350 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = source_list;
#line 350 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = current_source;
#line 350 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp22_);
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = thumbnail_views;
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp24_ = current_source;
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp26_ = _tmp25_;
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
#line 351 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp26_);
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (current_source);
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (source_id);
#line 3228 "Tag.c"
			}
#line 344 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_source_id_it);
#line 3232 "Tag.c"
		}
	} else {
		TagRow* _tmp27_;
		GeeHashSet* _tmp28_;
#line 355 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp27_ = self->priv->row;
#line 355 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp28_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 355 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp27_->source_id_list);
#line 355 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp27_->source_id_list = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_SET, GeeSet);
#line 3245 "Tag.c"
	}
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp29_ = row->tag_id;
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp30_ = _tmp29_.id;
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp31_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp30_);
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp32_ = _tmp31_;
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp33_ = g_strdup_printf ("ViewCollection for tag %s", _tmp32_);
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp34_ = _tmp33_;
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp35_ = view_collection_new (_tmp34_);
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_data_collection_unref0 (self->priv->media_views);
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->media_views = _tmp35_;
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp34_);
#line 359 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp32_);
#line 360 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp36_ = self->priv->media_views;
#line 360 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp37_ = thumbnail_views;
#line 360 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp38_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 360 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp39_ = _tmp38_;
#line 360 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp39_);
#line 364 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp40_ = source_list;
#line 364 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp41_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 364 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp42_ = _tmp41_;
#line 364 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp42_ > 0) {
#line 3287 "Tag.c"
		TagSourceCollection* _tmp43_;
		GeeArrayList* _tmp44_;
		TagSourceCollection* _tmp45_;
		GeeArrayList* _tmp46_;
#line 365 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp43_ = tag_global;
#line 365 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp44_ = source_list;
#line 365 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
#line 366 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp45_ = tag_global;
#line 366 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp46_ = source_list;
#line 366 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_COLLECTION, GeeCollection), FALSE, NULL, FALSE);
#line 3304 "Tag.c"
	}
#line 371 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp47_ = self->priv->media_views;
#line 371 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _tag_on_media_views_contents_altered_data_collection_contents_altered, self, 0);
#line 375 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp48_ = library_photo_global;
#line 375 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_SOURCE_COLLECTION, SourceCollection), "items-destroyed", (GCallback) _tag_on_sources_destroyed_source_collection_items_destroyed, self, 0);
#line 376 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp49_ = video_global;
#line 376 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_SOURCE_COLLECTION, SourceCollection), "items-destroyed", (GCallback) _tag_on_sources_destroyed_source_collection_items_destroyed, self, 0);
#line 378 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_update_indexable_keywords (self);
#line 332 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (thumbnail_views);
#line 332 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (source_list);
#line 332 "/home/jens/Source/shotwell/src/Tag.vala"
	return self;
#line 3326 "Tag.c"
}


static Tag*
tag_new (TagRow* row,
         gint64 object_id)
{
#line 332 "/home/jens/Source/shotwell/src/Tag.vala"
	return tag_construct (TYPE_TAG, row, object_id);
#line 3336 "Tag.c"
}


void
tag_init (ProgressMonitor monitor,
          void* monitor_target)
{
	TagSourceCollection* _tmp0_;
	GeeList* rows = NULL;
	GeeTreeMap* ancestry_dictionary = NULL;
	GeeTreeMap* _tmp8_;
	GeeArrayList* unlinked = NULL;
	GeeArrayList* _tmp9_;
	gint count = 0;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeSet* victim_set = NULL;
	GeeHashSet* _tmp51_;
	GeeSet* _tmp103_;
	TagSourceCollection* _tmp158_;
	GeeTreeMap* _tmp159_;
	GeeCollection* _tmp160_;
	GeeCollection* _tmp161_;
	GeeCollection* _tmp162_;
	GeeCollection* _tmp163_;
	GeeCollection* _tmp164_;
	TagSourceCollection* _tmp165_;
	GeeArrayList* _tmp166_;
	GError * _inner_error_ = NULL;
#line 388 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_source_collection_new ();
#line 388 "/home/jens/Source/shotwell/src/Tag.vala"
	_data_collection_unref0 (tag_global);
#line 388 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_global = _tmp0_;
#line 391 "/home/jens/Source/shotwell/src/Tag.vala"
	rows = NULL;
#line 3375 "Tag.c"
	{
		GeeList* _tmp1_ = NULL;
		TagTable* _tmp2_;
		TagTable* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = tag_table_get_instance ();
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = tag_table_get_all_rows (_tmp3_, &_inner_error_);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = _tmp4_;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp3_);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = _tmp5_;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 3399 "Tag.c"
				goto __catch480_database_error;
			}
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (rows);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
			return;
#line 3410 "Tag.c"
		}
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = NULL;
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (rows);
#line 393 "/home/jens/Source/shotwell/src/Tag.vala"
		rows = _tmp6_;
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp1_);
#line 3422 "Tag.c"
	}
	goto __finally480;
	__catch480_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 395 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = err;
#line 395 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp7_);
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 3439 "Tag.c"
	}
	__finally480:
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (rows);
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 392 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 3452 "Tag.c"
	}
#line 404 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 404 "/home/jens/Source/shotwell/src/Tag.vala"
	ancestry_dictionary = _tmp8_;
#line 406 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 406 "/home/jens/Source/shotwell/src/Tag.vala"
	unlinked = _tmp9_;
#line 407 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp10_ = rows;
#line 407 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
#line 407 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = _tmp11_;
#line 407 "/home/jens/Source/shotwell/src/Tag.vala"
	count = _tmp12_;
#line 3470 "Tag.c"
	{
		gint ctr = 0;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
		ctr = 0;
#line 3475 "Tag.c"
		{
			gboolean _tmp13_ = FALSE;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = TRUE;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 3482 "Tag.c"
				gint _tmp15_;
				gint _tmp16_;
				TagRow* row = NULL;
				GeeList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				gchar* name = NULL;
				TagRow* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				TagRow* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				Tag* tag = NULL;
				TagRow* _tmp37_;
				Tag* _tmp38_;
				GeeTreeMap* _tmp41_;
				Tag* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				Tag* _tmp45_;
				Tag* _tmp46_;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!_tmp13_) {
#line 3508 "Tag.c"
					gint _tmp14_;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp14_ = ctr;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
					ctr = _tmp14_ + 1;
#line 3514 "Tag.c"
				}
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = FALSE;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = ctr;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = count;
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 3526 "Tag.c"
				}
#line 409 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = rows;
#line 409 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = ctr;
#line 409 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 409 "/home/jens/Source/shotwell/src/Tag.vala"
				row = (TagRow*) _tmp19_;
#line 412 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = row;
#line 412 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = _tmp20_->name;
#line 412 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = tag_prep_tag_name (_tmp21_);
#line 412 "/home/jens/Source/shotwell/src/Tag.vala"
				name = _tmp22_;
#line 413 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = name;
#line 413 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp23_ == NULL) {
#line 3548 "Tag.c"
					TagRow* _tmp24_;
					const gchar* _tmp25_;
#line 416 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp24_ = row;
#line 416 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp25_ = _tmp24_->name;
#line 416 "/home/jens/Source/shotwell/src/Tag.vala"
					g_warning ("Tag.vala:416: Invalid tag name \"%s\": removing from database", _tmp25_);
#line 3557 "Tag.c"
					{
						TagTable* _tmp26_;
						TagTable* _tmp27_;
						TagRow* _tmp28_;
						TagID _tmp29_;
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp26_ = tag_table_get_instance ();
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp27_ = _tmp26_;
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp28_ = row;
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp29_ = _tmp28_->tag_id;
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						tag_table_remove (_tmp27_, &_tmp29_, &_inner_error_);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						_database_table_unref0 (_tmp27_);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							if (_inner_error_->domain == DATABASE_ERROR) {
#line 3579 "Tag.c"
								goto __catch481_database_error;
							}
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							_g_free0 (name);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							_tag_row_unref0 (row);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							_g_object_unref0 (unlinked);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							_g_object_unref0 (ancestry_dictionary);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							_g_object_unref0 (rows);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							g_clear_error (&_inner_error_);
#line 418 "/home/jens/Source/shotwell/src/Tag.vala"
							return;
#line 3598 "Tag.c"
						}
					}
					goto __finally481;
					__catch481_database_error:
					{
						GError* err = NULL;
						TagRow* _tmp30_;
						const gchar* _tmp31_;
						GError* _tmp32_;
						const gchar* _tmp33_;
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						err = _inner_error_;
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_inner_error_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp30_ = row;
#line 420 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp31_ = _tmp30_->name;
#line 420 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp32_ = err;
#line 420 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp33_ = _tmp32_->message;
#line 420 "/home/jens/Source/shotwell/src/Tag.vala"
						g_warning ("Tag.vala:420: Unable to delete tag \"%s\": %s", _tmp31_, _tmp33_);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_error_free0 (err);
#line 3625 "Tag.c"
					}
					__finally481:
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_free0 (name);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_tag_row_unref0 (row);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (unlinked);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (ancestry_dictionary);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (rows);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						g_clear_error (&_inner_error_);
#line 417 "/home/jens/Source/shotwell/src/Tag.vala"
						return;
#line 3646 "Tag.c"
					}
#line 423 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (name);
#line 423 "/home/jens/Source/shotwell/src/Tag.vala"
					_tag_row_unref0 (row);
#line 423 "/home/jens/Source/shotwell/src/Tag.vala"
					continue;
#line 3654 "Tag.c"
				}
#line 426 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp34_ = row;
#line 426 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp35_ = name;
#line 426 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp36_ = g_strdup (_tmp35_);
#line 426 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp34_->name);
#line 426 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp34_->name = _tmp36_;
#line 428 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp37_ = row;
#line 428 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp38_ = tag_new (_tmp37_, DATA_OBJECT_INVALID_OBJECT_ID);
#line 428 "/home/jens/Source/shotwell/src/Tag.vala"
				tag = _tmp38_;
#line 429 "/home/jens/Source/shotwell/src/Tag.vala"
				if (monitor != NULL) {
#line 3674 "Tag.c"
					gint _tmp39_;
					gint _tmp40_;
#line 430 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp39_ = ctr;
#line 430 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp40_ = count;
#line 430 "/home/jens/Source/shotwell/src/Tag.vala"
					monitor ((guint64) _tmp39_, (guint64) _tmp40_, TRUE, monitor_target);
#line 3683 "Tag.c"
				}
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp41_ = ancestry_dictionary;
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp42_ = tag;
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp43_ = tag_get_path (_tmp42_);
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp44_ = _tmp43_;
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp45_ = tag;
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp44_, _tmp45_);
#line 432 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp44_);
#line 434 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp46_ = tag;
#line 434 "/home/jens/Source/shotwell/src/Tag.vala"
				if (container_source_has_links (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_CONTAINER_SOURCE, ContainerSource))) {
#line 3703 "Tag.c"
					Tag* _tmp47_;
					TagSourceCollection* _tmp48_;
					GeeArrayList* _tmp49_;
					Tag* _tmp50_;
#line 435 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp47_ = tag;
#line 435 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp48_ = tag_global;
#line 435 "/home/jens/Source/shotwell/src/Tag.vala"
					data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_SOURCE_COLLECTION, SourceCollection), NULL);
#line 436 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp49_ = unlinked;
#line 436 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp50_ = tag;
#line 436 "/home/jens/Source/shotwell/src/Tag.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp50_);
#line 3720 "Tag.c"
				}
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tag);
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (name);
#line 408 "/home/jens/Source/shotwell/src/Tag.vala"
				_tag_row_unref0 (row);
#line 3728 "Tag.c"
			}
		}
	}
#line 440 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp51_ = gee_hash_set_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 440 "/home/jens/Source/shotwell/src/Tag.vala"
	victim_set = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_SET, GeeSet);
#line 3736 "Tag.c"
	{
		GeeIterator* _fq_tag_path_it = NULL;
		GeeTreeMap* _tmp52_;
		GeeSet* _tmp53_;
		GeeSet* _tmp54_;
		GeeSet* _tmp55_;
		GeeIterator* _tmp56_;
		GeeIterator* _tmp57_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp52_ = ancestry_dictionary;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp53_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp54_ = _tmp53_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp55_ = _tmp54_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp56_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ITERABLE, GeeIterable));
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp57_ = _tmp56_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp55_);
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_fq_tag_path_it = _tmp57_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 3763 "Tag.c"
			GeeIterator* _tmp58_;
			gchar* fq_tag_path = NULL;
			GeeIterator* _tmp59_;
			gpointer _tmp60_;
			const gchar* _tmp61_;
			GeeList* _tmp62_;
			GeeList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gboolean _tmp66_;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp58_ = _fq_tag_path_it;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp58_)) {
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 3780 "Tag.c"
			}
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp59_ = _fq_tag_path_it;
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp60_ = gee_iterator_get (_tmp59_);
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			fq_tag_path = (gchar*) _tmp60_;
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp61_ = fq_tag_path;
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp62_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp61_);
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp63_ = _tmp62_;
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp64_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COLLECTION, GeeCollection));
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp65_ = _tmp64_;
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp66_ = _tmp65_ < 1;
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp63_);
#line 446 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp66_) {
#line 3804 "Tag.c"
				gboolean _tmp67_ = FALSE;
				const gchar* _tmp68_;
#line 447 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp68_ = fq_tag_path;
#line 447 "/home/jens/Source/shotwell/src/Tag.vala"
				if (g_str_has_prefix (_tmp68_, TAG_PATH_SEPARATOR_STRING)) {
#line 3811 "Tag.c"
					GeeTreeMap* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp69_ = ancestry_dictionary;
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp70_ = fq_tag_path;
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp71_ = hierarchical_tag_utilities_hierarchical_to_flat (_tmp70_);
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp72_ = _tmp71_;
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp67_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp72_);
#line 448 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (_tmp72_);
#line 3828 "Tag.c"
				} else {
#line 447 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp67_ = FALSE;
#line 3832 "Tag.c"
				}
#line 447 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp67_) {
#line 3836 "Tag.c"
					GeeSet* _tmp73_;
					GeeTreeMap* _tmp74_;
					const gchar* _tmp75_;
					gpointer _tmp76_;
					Tag* _tmp77_;
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp73_ = victim_set;
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp74_ = ancestry_dictionary;
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp75_ = fq_tag_path;
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp76_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp75_);
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp77_ = (Tag*) _tmp76_;
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEE_TYPE_COLLECTION, GeeCollection), _tmp77_);
#line 449 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_tmp77_);
#line 3856 "Tag.c"
				}
			}
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (fq_tag_path);
#line 3861 "Tag.c"
		}
#line 445 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_fq_tag_path_it);
#line 3865 "Tag.c"
	}
	{
		GeeIterator* _tag_it = NULL;
		GeeSet* _tmp78_;
		GeeIterator* _tmp79_;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp78_ = victim_set;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp79_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, GEE_TYPE_ITERABLE, GeeIterable));
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_it = _tmp79_;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 3879 "Tag.c"
			GeeIterator* _tmp80_;
			Tag* tag = NULL;
			GeeIterator* _tmp81_;
			gpointer _tmp82_;
			GeeCollection* source_collection = NULL;
			Tag* _tmp83_;
			GeeCollection* _tmp84_;
			gchar* flat_version = NULL;
			Tag* _tmp85_;
			gchar* _tmp86_;
			TagSourceCollection* _tmp87_;
			const gchar* _tmp88_;
			Tag* _tmp89_;
			Tag* _tmp90_;
			GeeCollection* _tmp91_;
			GeeTreeMap* _tmp92_;
			Tag* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			Tag* _tmp96_;
			Tag* _tmp97_;
			GeeCollection* _tmp98_;
			GeeCollection* _tmp99_;
			GeeMultiMap* _tmp100_;
			GeeMultiMap* _tmp101_;
			Tag* _tmp102_;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp80_ = _tag_it;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp80_)) {
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 3912 "Tag.c"
			}
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp81_ = _tag_it;
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp82_ = gee_iterator_get (_tmp81_);
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = (Tag*) _tmp82_;
#line 455 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp83_ = tag;
#line 455 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp84_ = tag_get_sources (_tmp83_);
#line 455 "/home/jens/Source/shotwell/src/Tag.vala"
			source_collection = _tmp84_;
#line 456 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp85_ = tag;
#line 456 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp86_ = tag_get_user_visible_name (_tmp85_);
#line 456 "/home/jens/Source/shotwell/src/Tag.vala"
			flat_version = _tmp86_;
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp87_ = tag_global;
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp88_ = flat_version;
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp89_ = tag_source_collection_fetch_by_name (_tmp87_, _tmp88_, FALSE);
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp90_ = _tmp89_;
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp91_ = source_collection;
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			tag_attach_many (_tmp90_, _tmp91_);
#line 457 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp90_);
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp92_ = ancestry_dictionary;
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp93_ = tag;
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp94_ = tag_get_path (_tmp93_);
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp95_ = _tmp94_;
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp95_, NULL);
#line 459 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp95_);
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp96_ = tag;
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp97_ = tag;
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp98_ = tag_get_sources (_tmp97_);
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp99_ = _tmp98_;
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp100_ = tag_detach_many (_tmp96_, _tmp99_);
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp101_ = _tmp100_;
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp101_);
#line 461 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp99_);
#line 462 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp102_ = tag;
#line 462 "/home/jens/Source/shotwell/src/Tag.vala"
			data_source_destroy_orphan (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, TYPE_DATA_SOURCE, DataSource), TRUE);
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (flat_version);
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (source_collection);
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 3984 "Tag.c"
		}
#line 454 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tag_it);
#line 3988 "Tag.c"
	}
#line 468 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp103_ = victim_set;
#line 468 "/home/jens/Source/shotwell/src/Tag.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GEE_TYPE_COLLECTION, GeeCollection));
#line 3994 "Tag.c"
	{
		GeeIterator* _fq_tag_path_it = NULL;
		GeeTreeMap* _tmp104_;
		GeeSet* _tmp105_;
		GeeSet* _tmp106_;
		GeeSet* _tmp107_;
		GeeIterator* _tmp108_;
		GeeIterator* _tmp109_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp104_ = ancestry_dictionary;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp105_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp106_ = _tmp105_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp107_ = _tmp106_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp108_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, GEE_TYPE_ITERABLE, GeeIterable));
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp109_ = _tmp108_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp107_);
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_fq_tag_path_it = _tmp109_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 4021 "Tag.c"
			GeeIterator* _tmp110_;
			gchar* fq_tag_path = NULL;
			GeeIterator* _tmp111_;
			gpointer _tmp112_;
			GeeList* parents_to_search = NULL;
			const gchar* _tmp113_;
			GeeList* _tmp114_;
			Tag* curr_child = NULL;
			GeeTreeMap* _tmp115_;
			const gchar* _tmp116_;
			gpointer _tmp117_;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp110_ = _fq_tag_path_it;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp110_)) {
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 4039 "Tag.c"
			}
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp111_ = _fq_tag_path_it;
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp112_ = gee_iterator_get (_tmp111_);
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			fq_tag_path = (gchar*) _tmp112_;
#line 471 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp113_ = fq_tag_path;
#line 471 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp114_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp113_);
#line 471 "/home/jens/Source/shotwell/src/Tag.vala"
			parents_to_search = _tmp114_;
#line 474 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp115_ = ancestry_dictionary;
#line 474 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp116_ = fq_tag_path;
#line 474 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp117_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp116_);
#line 474 "/home/jens/Source/shotwell/src/Tag.vala"
			curr_child = (Tag*) _tmp117_;
#line 4061 "Tag.c"
			{
				GeeList* _parent_path_list = NULL;
				GeeList* _tmp118_;
				GeeList* _tmp119_;
				gint _parent_path_size = 0;
				GeeList* _tmp120_;
				gint _tmp121_;
				gint _tmp122_;
				gint _parent_path_index = 0;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp118_ = parents_to_search;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp119_ = _g_object_ref0 (_tmp118_);
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_parent_path_list = _tmp119_;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp120_ = _parent_path_list;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp121_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, GEE_TYPE_COLLECTION, GeeCollection));
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp122_ = _tmp121_;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_parent_path_size = _tmp122_;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_parent_path_index = -1;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				while (TRUE) {
#line 4089 "Tag.c"
					gint _tmp123_;
					gint _tmp124_;
					gint _tmp125_;
					gchar* parent_path = NULL;
					GeeList* _tmp126_;
					gint _tmp127_;
					gpointer _tmp128_;
					gint child_ref_count = 0;
					Tag* _tmp129_;
					gint parent_ref_count = 0;
					GeeTreeMap* _tmp130_;
					const gchar* _tmp131_;
					gint _tmp136_;
					gint _tmp137_;
					GeeSet* _tmp140_;
					GeeTreeMap* _tmp141_;
					const gchar* _tmp142_;
					gpointer _tmp143_;
					Tag* _tmp144_;
					gboolean _tmp145_;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp123_ = _parent_path_index;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_parent_path_index = _tmp123_ + 1;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp124_ = _parent_path_index;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp125_ = _parent_path_size;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					if (!(_tmp124_ < _tmp125_)) {
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
						break;
#line 4122 "Tag.c"
					}
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp126_ = _parent_path_list;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp127_ = _parent_path_index;
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp128_ = gee_list_get (_tmp126_, _tmp127_);
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					parent_path = (gchar*) _tmp128_;
#line 479 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp129_ = curr_child;
#line 479 "/home/jens/Source/shotwell/src/Tag.vala"
					child_ref_count = tag_get_sources_count (_tmp129_);
#line 480 "/home/jens/Source/shotwell/src/Tag.vala"
					parent_ref_count = -1;
#line 483 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp130_ = ancestry_dictionary;
#line 483 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp131_ = parent_path;
#line 483 "/home/jens/Source/shotwell/src/Tag.vala"
					if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp131_)) {
#line 4144 "Tag.c"
						GeeTreeMap* _tmp132_;
						const gchar* _tmp133_;
						gpointer _tmp134_;
						Tag* _tmp135_;
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp132_ = ancestry_dictionary;
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp133_ = parent_path;
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp134_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp133_);
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp135_ = (Tag*) _tmp134_;
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						parent_ref_count = tag_get_sources_count (_tmp135_);
#line 485 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (_tmp135_);
#line 4161 "Tag.c"
					}
#line 489 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp136_ = child_ref_count;
#line 489 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp137_ = parent_ref_count;
#line 489 "/home/jens/Source/shotwell/src/Tag.vala"
					if (_tmp136_ > _tmp137_) {
#line 4169 "Tag.c"
						GeeSet* _tmp138_;
						Tag* _tmp139_;
#line 493 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp138_ = victim_set;
#line 493 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp139_ = curr_child;
#line 493 "/home/jens/Source/shotwell/src/Tag.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, GEE_TYPE_COLLECTION, GeeCollection), _tmp139_);
#line 497 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_free0 (parent_path);
#line 497 "/home/jens/Source/shotwell/src/Tag.vala"
						break;
#line 4182 "Tag.c"
					}
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp140_ = victim_set;
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp141_ = ancestry_dictionary;
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp142_ = parent_path;
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp143_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp142_);
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp144_ = (Tag*) _tmp143_;
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp145_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, GEE_TYPE_COLLECTION, GeeCollection), _tmp144_);
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_tmp144_);
#line 501 "/home/jens/Source/shotwell/src/Tag.vala"
					if (_tmp145_) {
#line 4200 "Tag.c"
						GeeSet* _tmp146_;
						Tag* _tmp147_;
#line 503 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp146_ = victim_set;
#line 503 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp147_ = curr_child;
#line 503 "/home/jens/Source/shotwell/src/Tag.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, GEE_TYPE_COLLECTION, GeeCollection), _tmp147_);
#line 504 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_free0 (parent_path);
#line 504 "/home/jens/Source/shotwell/src/Tag.vala"
						break;
#line 4213 "Tag.c"
					}
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (parent_path);
#line 4217 "Tag.c"
				}
#line 476 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_parent_path_list);
#line 4221 "Tag.c"
			}
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (curr_child);
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (parents_to_search);
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (fq_tag_path);
#line 4229 "Tag.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_fq_tag_path_it);
#line 4233 "Tag.c"
	}
	{
		GeeIterator* _t_it = NULL;
		GeeSet* _tmp148_;
		GeeIterator* _tmp149_;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp148_ = victim_set;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp149_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, GEE_TYPE_ITERABLE, GeeIterable));
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
		_t_it = _tmp149_;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 4247 "Tag.c"
			GeeIterator* _tmp150_;
			Tag* t = NULL;
			GeeIterator* _tmp151_;
			gpointer _tmp152_;
			GeeTreeMap* _tmp153_;
			Tag* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			Tag* _tmp157_;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp150_ = _t_it;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp150_)) {
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 4263 "Tag.c"
			}
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp151_ = _t_it;
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp152_ = gee_iterator_get (_tmp151_);
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			t = (Tag*) _tmp152_;
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp153_ = ancestry_dictionary;
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp154_ = t;
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp155_ = tag_get_path (_tmp154_);
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp156_ = _tmp155_;
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp156_, NULL);
#line 511 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp156_);
#line 512 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp157_ = t;
#line 512 "/home/jens/Source/shotwell/src/Tag.vala"
			data_source_destroy_orphan (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, TYPE_DATA_SOURCE, DataSource), TRUE);
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (t);
#line 4289 "Tag.c"
		}
#line 510 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_t_it);
#line 4293 "Tag.c"
	}
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp158_ = tag_global;
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp159_ = ancestry_dictionary;
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp160_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp161_ = _tmp160_;
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp162_ = _tmp161_;
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp163_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, TYPE_DATA_COLLECTION, DataCollection), _tmp162_, NULL, NULL);
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp164_ = _tmp163_;
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp164_);
#line 516 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp162_);
#line 517 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp165_ = tag_global;
#line 517 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp166_ = unlinked;
#line 517 "/home/jens/Source/shotwell/src/Tag.vala"
	container_source_collection_init_add_many_unlinked (G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, GEE_TYPE_COLLECTION, GeeCollection));
#line 4319 "Tag.c"
	{
		GeeIterator* _t_it = NULL;
		GeeTreeMap* _tmp167_;
		GeeCollection* _tmp168_;
		GeeCollection* _tmp169_;
		GeeCollection* _tmp170_;
		GeeIterator* _tmp171_;
		GeeIterator* _tmp172_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp167_ = ancestry_dictionary;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp168_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp167_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp169_ = _tmp168_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp170_ = _tmp169_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp171_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, GEE_TYPE_ITERABLE, GeeIterable));
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp172_ = _tmp171_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp170_);
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_t_it = _tmp172_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 4346 "Tag.c"
			GeeIterator* _tmp173_;
			Tag* t = NULL;
			GeeIterator* _tmp174_;
			gpointer _tmp175_;
			gboolean _tmp176_ = FALSE;
			Tag* _tmp177_;
			GeeList* _tmp178_;
			GeeList* _tmp179_;
			gint _tmp180_;
			gint _tmp181_;
			gboolean _tmp182_;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp173_ = _t_it;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp173_)) {
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 4364 "Tag.c"
			}
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp174_ = _t_it;
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp175_ = gee_iterator_get (_tmp174_);
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			t = (Tag*) _tmp175_;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp177_ = t;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp178_ = tag_get_hierarchical_children (_tmp177_);
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp179_ = _tmp178_;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp180_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, GEE_TYPE_COLLECTION, GeeCollection));
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp181_ = _tmp180_;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp182_ = _tmp181_ < 1;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp179_);
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp182_) {
#line 4388 "Tag.c"
				Tag* _tmp183_;
				Tag* _tmp184_;
				Tag* _tmp185_;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp183_ = t;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp184_ = tag_get_hierarchical_parent (_tmp183_);
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp185_ = _tmp184_;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp176_ = _tmp185_ == NULL;
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp185_);
#line 4402 "Tag.c"
			} else {
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp176_ = FALSE;
#line 4406 "Tag.c"
			}
#line 523 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp176_) {
#line 4410 "Tag.c"
				Tag* _tmp186_;
#line 525 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp186_ = t;
#line 525 "/home/jens/Source/shotwell/src/Tag.vala"
				tag_flatten (_tmp186_);
#line 4416 "Tag.c"
			}
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (t);
#line 4420 "Tag.c"
		}
#line 521 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_t_it);
#line 4424 "Tag.c"
	}
#line 387 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (victim_set);
#line 387 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (unlinked);
#line 387 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (ancestry_dictionary);
#line 387 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (rows);
#line 4434 "Tag.c"
}


void
tag_terminate (void)
{
}


gint
tag_compare_names (Tag* a,
                   Tag* b)
{
	gint result = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
#line 533 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (a), 0);
#line 533 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (b), 0);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_DATA_OBJECT, DataObject));
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_get_name_collation_key (a);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_DATA_OBJECT, DataObject));
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = _tmp4_;
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = tag_get_name_collation_key (b);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = _tmp6_;
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = string_precollated_compare (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp7_);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp5_);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp3_);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp8_;
#line 534 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 4492 "Tag.c"
}


gint
tag_compare_user_visible_names (Tag* a,
                                Tag* b)
{
	gint result = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
#line 538 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (a), 0);
#line 538 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (b), 0);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_user_visible_name (a);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_get_name_collation_key (a);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = tag_get_user_visible_name (b);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = _tmp4_;
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = tag_get_name_collation_key (b);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = _tmp6_;
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = string_precollated_compare (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp7_);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp5_);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp3_);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp8_;
#line 539 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 4544 "Tag.c"
}


guint
tag_hash_name_string (const gchar* a)
{
	guint result = 0U;
#line 543 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (a != NULL, 0U);
#line 544 "/home/jens/Source/shotwell/src/Tag.vala"
	result = string_collated_hash (a);
#line 544 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 4558 "Tag.c"
}


gboolean
tag_equal_name_strings (const gchar* a,
                        const gchar* b)
{
	gboolean result = FALSE;
#line 547 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 547 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 548 "/home/jens/Source/shotwell/src/Tag.vala"
	result = string_collated_equals (a, b);
#line 548 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 4575 "Tag.c"
}


Tag*
tag_for_path (const gchar* name)
{
	Tag* result = NULL;
	Tag* tag = NULL;
	TagSourceCollection* _tmp0_;
	Tag* _tmp1_;
	Tag* _tmp2_;
	Tag* _tmp5_;
	TagSourceCollection* _tmp13_;
	Tag* _tmp14_;
	GError * _inner_error_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 554 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_global;
#line 554 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = tag_source_collection_fetch_by_name (_tmp0_, name, TRUE);
#line 554 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp1_;
#line 555 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag;
#line 555 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp2_ == NULL) {
#line 4603 "Tag.c"
		TagSourceCollection* _tmp3_;
		Tag* _tmp4_;
#line 556 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = tag_global;
#line 556 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = tag_source_collection_restore_tag_from_holding_tank (_tmp3_, name);
#line 556 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (tag);
#line 556 "/home/jens/Source/shotwell/src/Tag.vala"
		tag = _tmp4_;
#line 4614 "Tag.c"
	}
#line 558 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = tag;
#line 558 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp5_ != NULL) {
#line 559 "/home/jens/Source/shotwell/src/Tag.vala"
		result = tag;
#line 559 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 4624 "Tag.c"
	}
	{
		TagRow* _tmp6_ = NULL;
		TagTable* _tmp7_;
		TagTable* _tmp8_;
		TagRow* _tmp9_;
		TagRow* _tmp10_;
		Tag* _tmp11_;
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = tag_table_get_instance ();
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = _tmp7_;
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp9_ = tag_table_add (_tmp8_, name, &_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp10_ = _tmp9_;
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp8_);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = _tmp10_;
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 4649 "Tag.c"
				goto __catch482_database_error;
			}
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
			return NULL;
#line 4660 "Tag.c"
		}
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp11_ = tag_new (_tmp6_, DATA_OBJECT_INVALID_OBJECT_ID);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (tag);
#line 563 "/home/jens/Source/shotwell/src/Tag.vala"
		tag = _tmp11_;
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_row_unref0 (_tmp6_);
#line 4670 "Tag.c"
	}
	goto __finally482;
	__catch482_database_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp12_ = err;
#line 565 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp12_);
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 4687 "Tag.c"
	}
	__finally482:
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (tag);
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 562 "/home/jens/Source/shotwell/src/Tag.vala"
		return NULL;
#line 4700 "Tag.c"
	}
#line 568 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp13_ = tag_global;
#line 568 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp14_ = tag;
#line 568 "/home/jens/Source/shotwell/src/Tag.vala"
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
#line 570 "/home/jens/Source/shotwell/src/Tag.vala"
	result = tag;
#line 570 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 4712 "Tag.c"
}


GeeCollection*
tag_get_terminal_tags (GeeCollection* tags)
{
	GeeCollection* result = NULL;
	GeeSet* result_paths = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp34_;
#line 573 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (tags), NULL);
#line 574 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 574 "/home/jens/Source/shotwell/src/Tag.vala"
	result_paths = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
#line 4730 "Tag.c"
	{
		GeeIterator* _tag_it = NULL;
		GeeIterator* _tmp1_;
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (tags, GEE_TYPE_ITERABLE, GeeIterable));
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_it = _tmp1_;
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 4740 "Tag.c"
			GeeIterator* _tmp2_;
			Tag* tag = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			Tag* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			Tag* _tmp13_;
			Tag* _tmp14_;
			Tag* _tmp15_;
			gboolean _tmp16_;
			GeeSet* _tmp30_;
			Tag* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp2_ = _tag_it;
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 4763 "Tag.c"
			}
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = _tag_it;
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = (Tag*) _tmp4_;
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = tag;
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = tag_get_path (_tmp5_);
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = _tmp6_;
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = !g_str_has_prefix (_tmp7_, TAG_PATH_SEPARATOR_STRING);
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp7_);
#line 578 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp8_) {
#line 4783 "Tag.c"
				GeeSet* _tmp9_;
				Tag* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp9_ = result_paths;
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp10_ = tag;
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = tag_get_path (_tmp10_);
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = _tmp11_;
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
#line 579 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp12_);
#line 580 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (tag);
#line 580 "/home/jens/Source/shotwell/src/Tag.vala"
				continue;
#line 4804 "Tag.c"
			}
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = tag;
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = tag_get_hierarchical_parent (_tmp13_);
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = _tmp14_;
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = _tmp15_ != NULL;
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp15_);
#line 586 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp16_) {
#line 4818 "Tag.c"
				GeeSet* _tmp17_;
				Tag* _tmp18_;
				Tag* _tmp19_;
				Tag* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gboolean _tmp23_;
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = result_paths;
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = tag;
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = tag_get_hierarchical_parent (_tmp18_);
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = _tmp19_;
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = tag_get_path (_tmp20_);
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = _tmp21_;
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp22_);
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp22_);
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp20_);
#line 589 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp23_) {
#line 4846 "Tag.c"
					GeeSet* _tmp24_;
					Tag* _tmp25_;
					Tag* _tmp26_;
					Tag* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp24_ = result_paths;
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp25_ = tag;
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp26_ = tag_get_hierarchical_parent (_tmp25_);
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp27_ = _tmp26_;
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp28_ = tag_get_path (_tmp27_);
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp29_ = _tmp28_;
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp29_);
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (_tmp29_);
#line 590 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_tmp27_);
#line 4871 "Tag.c"
				}
			}
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp30_ = result_paths;
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp31_ = tag;
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp32_ = tag_get_path (_tmp31_);
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp33_ = _tmp32_;
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
#line 593 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp33_);
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 4888 "Tag.c"
		}
#line 576 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tag_it);
#line 4892 "Tag.c"
	}
#line 596 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp34_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 596 "/home/jens/Source/shotwell/src/Tag.vala"
	_result_ = _tmp34_;
#line 4898 "Tag.c"
	{
		GeeIterator* _path_it = NULL;
		GeeSet* _tmp35_;
		GeeIterator* _tmp36_;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp35_ = result_paths;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp36_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ITERABLE, GeeIterable));
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
		_path_it = _tmp36_;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 4911 "Tag.c"
			GeeIterator* _tmp37_;
			gchar* path = NULL;
			GeeIterator* _tmp38_;
			gpointer _tmp39_;
			TagSourceCollection* _tmp40_;
			const gchar* _tmp41_;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp37_ = _path_it;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp37_)) {
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 4924 "Tag.c"
			}
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp38_ = _path_it;
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp39_ = gee_iterator_get (_tmp38_);
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			path = (gchar*) _tmp39_;
#line 598 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp40_ = tag_global;
#line 598 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp41_ = path;
#line 598 "/home/jens/Source/shotwell/src/Tag.vala"
			if (tag_source_collection_exists (_tmp40_, _tmp41_, FALSE)) {
#line 4938 "Tag.c"
				GeeArrayList* _tmp42_;
				const gchar* _tmp43_;
				Tag* _tmp44_;
				Tag* _tmp45_;
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp42_ = _result_;
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp43_ = path;
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp44_ = tag_for_path (_tmp43_);
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp45_ = _tmp44_;
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp45_);
#line 599 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp45_);
#line 4955 "Tag.c"
			} else {
				{
					GeeIterator* _probed_tag_it = NULL;
					GeeIterator* _tmp46_;
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp46_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (tags, GEE_TYPE_ITERABLE, GeeIterable));
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
					_probed_tag_it = _tmp46_;
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
					while (TRUE) {
#line 4966 "Tag.c"
						GeeIterator* _tmp47_;
						Tag* probed_tag = NULL;
						GeeIterator* _tmp48_;
						gpointer _tmp49_;
						Tag* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						const gchar* _tmp53_;
						gboolean _tmp54_;
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp47_ = _probed_tag_it;
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						if (!gee_iterator_next (_tmp47_)) {
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
							break;
#line 4982 "Tag.c"
						}
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp48_ = _probed_tag_it;
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp49_ = gee_iterator_get (_tmp48_);
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						probed_tag = (Tag*) _tmp49_;
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp50_ = probed_tag;
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp51_ = tag_get_path (_tmp50_);
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp52_ = _tmp51_;
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp53_ = path;
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp54_ = g_strcmp0 (_tmp52_, _tmp53_) == 0;
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_free0 (_tmp52_);
#line 602 "/home/jens/Source/shotwell/src/Tag.vala"
						if (_tmp54_) {
#line 5004 "Tag.c"
							GeeArrayList* _tmp55_;
							Tag* _tmp56_;
#line 603 "/home/jens/Source/shotwell/src/Tag.vala"
							_tmp55_ = _result_;
#line 603 "/home/jens/Source/shotwell/src/Tag.vala"
							_tmp56_ = probed_tag;
#line 603 "/home/jens/Source/shotwell/src/Tag.vala"
							gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp56_);
#line 5013 "Tag.c"
						}
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (probed_tag);
#line 5017 "Tag.c"
					}
#line 601 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_probed_tag_it);
#line 5021 "Tag.c"
				}
			}
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (path);
#line 5026 "Tag.c"
		}
#line 597 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_path_it);
#line 5030 "Tag.c"
	}
#line 608 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_COLLECTION, GeeCollection);
#line 608 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (result_paths);
#line 608 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5038 "Tag.c"
}


static gint
_tag_compare_user_visible_names_gcompare_data_func (gconstpointer a,
                                                    gconstpointer b,
                                                    gpointer self)
{
	gint result;
	result = tag_compare_user_visible_names ((Tag*) a, (Tag*) b);
#line 623 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5051 "Tag.c"
}


GeeList*
tag_make_user_visible_tag_list (GeeCollection* tags)
{
	GeeList* result = NULL;
	GeeHashSet* seen_tags = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* terminal_tags = NULL;
	GeeCollection* _tmp1_;
	GeeArrayList* sorted_tags = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp16_;
#line 612 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (tags), NULL);
#line 613 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 613 "/home/jens/Source/shotwell/src/Tag.vala"
	seen_tags = _tmp0_;
#line 614 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = tag_get_terminal_tags (tags);
#line 614 "/home/jens/Source/shotwell/src/Tag.vala"
	terminal_tags = _tmp1_;
#line 615 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 615 "/home/jens/Source/shotwell/src/Tag.vala"
	sorted_tags = _tmp2_;
#line 5080 "Tag.c"
	{
		GeeIterator* _tag_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = terminal_tags;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_it = _tmp4_;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 5093 "Tag.c"
			GeeIterator* _tmp5_;
			Tag* tag = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gchar* user_visible_name = NULL;
			Tag* _tmp8_;
			gchar* _tmp9_;
			GeeHashSet* _tmp10_;
			const gchar* _tmp11_;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _tag_it;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 5109 "Tag.c"
			}
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _tag_it;
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = (Tag*) _tmp7_;
#line 617 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = tag;
#line 617 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = tag_get_user_visible_name (_tmp8_);
#line 617 "/home/jens/Source/shotwell/src/Tag.vala"
			user_visible_name = _tmp9_;
#line 618 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = seen_tags;
#line 618 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = user_visible_name;
#line 618 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp11_)) {
#line 5129 "Tag.c"
				GeeArrayList* _tmp12_;
				Tag* _tmp13_;
				GeeHashSet* _tmp14_;
				const gchar* _tmp15_;
#line 619 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = sorted_tags;
#line 619 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = tag;
#line 619 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 620 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = seen_tags;
#line 620 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp15_ = user_visible_name;
#line 620 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 5146 "Tag.c"
			}
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (user_visible_name);
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 5152 "Tag.c"
		}
#line 616 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tag_it);
#line 5156 "Tag.c"
	}
#line 623 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp16_ = sorted_tags;
#line 623 "/home/jens/Source/shotwell/src/Tag.vala"
	gee_list_sort (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_LIST, GeeList), _tag_compare_user_visible_names_gcompare_data_func, NULL, NULL);
#line 624 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (sorted_tags, GEE_TYPE_LIST, GeeList);
#line 624 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (terminal_tags);
#line 624 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (seen_tags);
#line 624 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5170 "Tag.c"
}


gchar*
tag_make_tag_markup_string (GeeList* tags,
                            gint highlight_index)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gint i = 0;
	gboolean first = FALSE;
	GString* _tmp24_;
	gchar* built = NULL;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
#line 627 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (GEE_IS_LIST (tags), NULL);
#line 628 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = g_string_new ("<small>");
#line 628 "/home/jens/Source/shotwell/src/Tag.vala"
	builder = _tmp0_;
#line 629 "/home/jens/Source/shotwell/src/Tag.vala"
	i = 0;
#line 630 "/home/jens/Source/shotwell/src/Tag.vala"
	first = TRUE;
#line 5198 "Tag.c"
	{
		GeeList* _tag_list = NULL;
		GeeList* _tmp1_;
		gint _tag_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tag_index = 0;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = _g_object_ref0 (tags);
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_list = _tmp1_;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = _tag_list;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = _tmp3_;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_size = _tmp4_;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_tag_index = -1;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 5223 "Tag.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Tag* tag = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gchar* tag_name = NULL;
			Tag* _tmp11_;
			gchar* _tmp12_;
			gchar* esc_tag_name = NULL;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_;
			gint _tmp17_;
			GString* _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp23_;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _tag_index;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tag_index = _tmp5_ + 1;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _tag_index;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = _tag_size;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 5255 "Tag.c"
			}
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _tag_list;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _tag_index;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			tag = (Tag*) _tmp10_;
#line 632 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = tag;
#line 632 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = tag_get_user_visible_name (_tmp11_);
#line 632 "/home/jens/Source/shotwell/src/Tag.vala"
			tag_name = _tmp12_;
#line 633 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = tag_name;
#line 633 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = guarded_markup_escape_text (_tmp13_);
#line 633 "/home/jens/Source/shotwell/src/Tag.vala"
			esc_tag_name = _tmp14_;
#line 634 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = first;
#line 634 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp15_) {
#line 635 "/home/jens/Source/shotwell/src/Tag.vala"
				first = FALSE;
#line 5283 "Tag.c"
			} else {
				GString* _tmp16_;
#line 637 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = builder;
#line 637 "/home/jens/Source/shotwell/src/Tag.vala"
				g_string_append (_tmp16_, TAG_TAG_LIST_SEPARATOR_STRING);
#line 5290 "Tag.c"
			}
#line 638 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = i;
#line 638 "/home/jens/Source/shotwell/src/Tag.vala"
			if (highlight_index == _tmp17_) {
#line 5296 "Tag.c"
				GString* _tmp18_;
#line 639 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = builder;
#line 639 "/home/jens/Source/shotwell/src/Tag.vala"
				g_string_append (_tmp18_, "<u>");
#line 5302 "Tag.c"
			}
#line 640 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = builder;
#line 640 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = esc_tag_name;
#line 640 "/home/jens/Source/shotwell/src/Tag.vala"
			g_string_append (_tmp19_, _tmp20_);
#line 641 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = i;
#line 641 "/home/jens/Source/shotwell/src/Tag.vala"
			if (highlight_index == _tmp21_) {
#line 5314 "Tag.c"
				GString* _tmp22_;
#line 642 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = builder;
#line 642 "/home/jens/Source/shotwell/src/Tag.vala"
				g_string_append (_tmp22_, "</u>");
#line 5320 "Tag.c"
			}
#line 643 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp23_ = i;
#line 643 "/home/jens/Source/shotwell/src/Tag.vala"
			i = _tmp23_ + 1;
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (esc_tag_name);
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (tag_name);
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (tag);
#line 5332 "Tag.c"
		}
#line 631 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tag_list);
#line 5336 "Tag.c"
	}
#line 646 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp24_ = builder;
#line 646 "/home/jens/Source/shotwell/src/Tag.vala"
	g_string_append (_tmp24_, "</small>");
#line 647 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp25_ = builder;
#line 647 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp26_ = _tmp25_->str;
#line 647 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 647 "/home/jens/Source/shotwell/src/Tag.vala"
	built = _tmp27_;
#line 648 "/home/jens/Source/shotwell/src/Tag.vala"
	result = built;
#line 648 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_string_free0 (builder);
#line 648 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5356 "Tag.c"
}


gchar*
tag_prep_tag_name (const gchar* name)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 653 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 654 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = prepare_input_text (name, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 654 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp0_;
#line 654 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5373 "Tag.c"
}


static void
_vala_array_add127 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
	if ((*length) == (*size)) {
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 5389 "Tag.c"
	}
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
	(*array)[(*length)++] = value;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
	(*array)[*length] = NULL;
#line 5395 "Tag.c"
}


gchar**
tag_prep_tag_names (gchar** names,
                    int names_length1,
                    int* result_length1)
{
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
#line 660 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 660 "/home/jens/Source/shotwell/src/Tag.vala"
	_result_ = _tmp0_;
#line 660 "/home/jens/Source/shotwell/src/Tag.vala"
	_result__length1 = 0;
#line 660 "/home/jens/Source/shotwell/src/Tag.vala"
	__result__size_ = _result__length1;
#line 5419 "Tag.c"
	{
		gint ctr = 0;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
		ctr = 0;
#line 5424 "Tag.c"
		{
			gboolean _tmp1_ = FALSE;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp1_ = TRUE;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 5431 "Tag.c"
				gint _tmp3_;
				gchar* new_name = NULL;
				gint _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!_tmp1_) {
#line 5440 "Tag.c"
					gint _tmp2_;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp2_ = ctr;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
					ctr = _tmp2_ + 1;
#line 5446 "Tag.c"
				}
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp1_ = FALSE;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp3_ = ctr;
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!(_tmp3_ < names_length1)) {
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 5456 "Tag.c"
				}
#line 663 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp4_ = ctr;
#line 663 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = names[_tmp4_];
#line 663 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp6_ = tag_prep_tag_name (_tmp5_);
#line 663 "/home/jens/Source/shotwell/src/Tag.vala"
				new_name = _tmp6_;
#line 664 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp7_ = new_name;
#line 664 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp7_ != NULL) {
#line 5470 "Tag.c"
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					gchar* _tmp10_;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp8_ = _result_;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp8__length1 = _result__length1;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp9_ = new_name;
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp10_ = g_strdup (_tmp9_);
#line 665 "/home/jens/Source/shotwell/src/Tag.vala"
					_vala_array_add127 (&_result_, &_result__length1, &__result__size_, _tmp10_);
#line 5485 "Tag.c"
				}
#line 662 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (new_name);
#line 5489 "Tag.c"
			}
		}
	}
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = _result_;
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11__length1 = _result__length1;
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
	if (result_length1) {
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
		*result_length1 = _tmp11__length1;
#line 5501 "Tag.c"
	}
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp11_;
#line 668 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5507 "Tag.c"
}


static void
tag_set_raw_flat_name (Tag* self,
                       const gchar* name)
{
	gchar* prepped_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TagRow* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	Alteration* _tmp12_;
	Alteration* _tmp13_;
	GError * _inner_error_ = NULL;
#line 671 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 671 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (name != NULL);
#line 672 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_prep_tag_name (name);
#line 672 "/home/jens/Source/shotwell/src/Tag.vala"
	prepped_name = _tmp0_;
#line 674 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = prepped_name;
#line 674 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (_tmp1_ != NULL, "prepped_name != null");
#line 675 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = prepped_name;
#line 675 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (!g_str_has_prefix (_tmp2_, TAG_PATH_SEPARATOR_STRING), "!prepped_name.has_prefix(Tag.PATH_SEPARATOR_STRING)");
#line 5541 "Tag.c"
	{
		TagTable* _tmp3_;
		TagTable* _tmp4_;
		TagRow* _tmp5_;
		TagID _tmp6_;
		const gchar* _tmp7_;
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = tag_table_get_instance ();
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = _tmp3_;
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = self->priv->row;
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = _tmp5_->tag_id;
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = prepped_name;
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_table_rename (_tmp4_, &_tmp6_, _tmp7_, &_inner_error_);
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp4_);
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5566 "Tag.c"
				goto __catch483_database_error;
			}
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (prepped_name);
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 678 "/home/jens/Source/shotwell/src/Tag.vala"
			return;
#line 5577 "Tag.c"
		}
	}
	goto __finally483;
	__catch483_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = err;
#line 680 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp8_);
#line 681 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 681 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (prepped_name);
#line 681 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 5599 "Tag.c"
	}
	__finally483:
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (prepped_name);
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 677 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 5612 "Tag.c"
	}
#line 684 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = self->priv->row;
#line 684 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp10_ = prepped_name;
#line 684 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 684 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp9_->name);
#line 684 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_->name = _tmp11_;
#line 685 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (self->priv->name_collation_key);
#line 685 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->name_collation_key = NULL;
#line 687 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_update_indexable_keywords (self);
#line 689 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = alteration_new_from_list ("metadata:name, indexable:keywords");
#line 689 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp13_ = _tmp12_;
#line 689 "/home/jens/Source/shotwell/src/Tag.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 689 "/home/jens/Source/shotwell/src/Tag.vala"
	_alteration_unref0 (_tmp13_);
#line 671 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (prepped_name);
#line 5640 "Tag.c"
}


static void
tag_set_raw_path (Tag* self,
                  const gchar* path,
                  gboolean suppress_notify)
{
	gchar* prepped_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TagSourceCollection* _tmp3_;
	const gchar* _tmp4_;
	TagRow* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GError * _inner_error_ = NULL;
#line 692 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 692 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (path != NULL);
#line 693 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_prep_tag_name (path);
#line 693 "/home/jens/Source/shotwell/src/Tag.vala"
	prepped_path = _tmp0_;
#line 695 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = prepped_path;
#line 695 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (_tmp1_ != NULL, "prepped_path != null");
#line 696 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = prepped_path;
#line 696 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (g_str_has_prefix (_tmp2_, TAG_PATH_SEPARATOR_STRING), "prepped_path.has_prefix(Tag.PATH_SEPARATOR_STRING)");
#line 697 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = tag_global;
#line 697 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = prepped_path;
#line 697 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (!tag_source_collection_exists (_tmp3_, _tmp4_, FALSE), "!Tag.global.exists(prepped_path)");
#line 5681 "Tag.c"
	{
		TagTable* _tmp5_;
		TagTable* _tmp6_;
		TagRow* _tmp7_;
		TagID _tmp8_;
		const gchar* _tmp9_;
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = tag_table_get_instance ();
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = _tmp5_;
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = self->priv->row;
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = _tmp7_->tag_id;
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp9_ = prepped_path;
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_table_rename (_tmp6_, &_tmp8_, _tmp9_, &_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp6_);
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5706 "Tag.c"
				goto __catch484_database_error;
			}
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (prepped_path);
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/Tag.vala"
			return;
#line 5717 "Tag.c"
		}
	}
	goto __finally484;
	__catch484_database_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 702 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp10_ = err;
#line 702 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp10_);
#line 703 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 703 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (prepped_path);
#line 703 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 5739 "Tag.c"
	}
	__finally484:
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (prepped_path);
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 699 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 5752 "Tag.c"
	}
#line 706 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = self->priv->row;
#line 706 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = prepped_path;
#line 706 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 706 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp11_->name);
#line 706 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_->name = _tmp13_;
#line 707 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (self->priv->name_collation_key);
#line 707 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->name_collation_key = NULL;
#line 709 "/home/jens/Source/shotwell/src/Tag.vala"
	if (!suppress_notify) {
#line 5770 "Tag.c"
		Alteration* _tmp14_;
		Alteration* _tmp15_;
#line 710 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_update_indexable_keywords (self);
#line 711 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp14_ = alteration_new_from_list ("metadata:name, indexable:keywords");
#line 711 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp15_ = _tmp14_;
#line 711 "/home/jens/Source/shotwell/src/Tag.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 711 "/home/jens/Source/shotwell/src/Tag.vala"
		_alteration_unref0 (_tmp15_);
#line 5783 "Tag.c"
	}
#line 692 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (prepped_path);
#line 5787 "Tag.c"
}


static gchar*
tag_real_get_typename (DataSource* base)
{
	Tag * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 715 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 716 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = g_strdup (TAG_TYPENAME);
#line 716 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp0_;
#line 716 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5805 "Tag.c"
}


static gint64
tag_real_get_instance_id (DataSource* base)
{
	Tag * self;
	gint64 result = 0LL;
	TagID _tmp0_ = {0};
	gint64 _tmp1_;
#line 719 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 720 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_get_tag_id (self, &_tmp0_);
#line 720 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_.id;
#line 720 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp1_;
#line 720 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5826 "Tag.c"
}


static gchar*
tag_real_get_name (DataObject* base)
{
	Tag * self;
	gchar* result = NULL;
	TagRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 723 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 724 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->row;
#line 724 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_->name;
#line 724 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 724 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp2_;
#line 724 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5850 "Tag.c"
}


gchar*
tag_get_path (Tag* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 727 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 728 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 728 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp0_;
#line 728 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5867 "Tag.c"
}


gchar*
tag_get_user_visible_name (Tag* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 731 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_path (self);
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = hierarchical_tag_utilities_get_basename (_tmp1_);
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp3_;
#line 732 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5895 "Tag.c"
}


gchar*
tag_get_searchable_name (Tag* self)
{
	gchar* result = NULL;
	gchar* istring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 735 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_path (self);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = hierarchical_tag_utilities_get_basename (_tmp1_);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = _tmp4_;
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp3_);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 736 "/home/jens/Source/shotwell/src/Tag.vala"
	istring = _tmp5_;
#line 737 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = string_remove_diacritics (istring);
#line 737 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp6_;
#line 737 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (istring);
#line 737 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 5939 "Tag.c"
}


void
tag_flatten (Tag* self)
{
	Tag* _tmp0_;
	Tag* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 740 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 741 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_hierarchical_parent (self);
#line 741 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 741 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (_tmp1_ == NULL, "get_hierarchical_parent() == null");
#line 741 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp1_);
#line 743 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_get_user_visible_name (self);
#line 743 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 743 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_set_raw_flat_name (self, _tmp3_);
#line 743 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp3_);
#line 5968 "Tag.c"
}


void
tag_promote (Tag* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 746 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 747 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_path (self);
#line 747 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 747 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, TAG_PATH_SEPARATOR_STRING);
#line 747 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 747 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp2_) {
#line 748 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 5996 "Tag.c"
	}
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = tag_get_path (self);
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = _tmp3_;
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp4_, NULL);
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = _tmp5_;
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_set_raw_path (self, _tmp6_, FALSE);
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp6_);
#line 750 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp4_);
#line 6012 "Tag.c"
}


Tag*
tag_get_hierarchical_parent (Tag* self)
{
	Tag* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GeeList* components = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* parent_path = NULL;
	gchar* _tmp13_;
	TagSourceCollection* _tmp28_;
	const gchar* _tmp29_;
#line 753 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 755 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_path (self);
#line 755 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 755 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = !g_str_has_prefix (_tmp1_, TAG_PATH_SEPARATOR_STRING);
#line 755 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 755 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp2_) {
#line 756 "/home/jens/Source/shotwell/src/Tag.vala"
		result = NULL;
#line 756 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6054 "Tag.c"
	}
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = tag_get_path (self);
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = _tmp3_;
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = hierarchical_tag_utilities_enumerate_path_components (_tmp4_);
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = _tmp5_;
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp4_);
#line 758 "/home/jens/Source/shotwell/src/Tag.vala"
	components = _tmp6_;
#line 761 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = components;
#line 761 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 761 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = _tmp8_;
#line 761 "/home/jens/Source/shotwell/src/Tag.vala"
	_vala_assert (_tmp9_ > 0, "components.size > 0");
#line 763 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp10_ = components;
#line 763 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
#line 763 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = _tmp11_;
#line 763 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp12_ == 1) {
#line 764 "/home/jens/Source/shotwell/src/Tag.vala"
		result = NULL;
#line 764 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (components);
#line 764 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6090 "Tag.c"
	}
#line 767 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp13_ = g_strdup ("");
#line 767 "/home/jens/Source/shotwell/src/Tag.vala"
	parent_path = _tmp13_;
#line 6096 "Tag.c"
	{
		gint i = 0;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
		i = 0;
#line 6101 "Tag.c"
		{
			gboolean _tmp14_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = TRUE;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 6108 "Tag.c"
				gint _tmp16_;
				GeeList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				const gchar* _tmp20_;
				GeeList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!_tmp14_) {
#line 6123 "Tag.c"
					gint _tmp15_;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp15_ = i;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
					i = _tmp15_ + 1;
#line 6129 "Tag.c"
				}
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp16_ = i;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp17_ = components;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = _tmp18_;
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!(_tmp16_ < (_tmp19_ - 1))) {
#line 768 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 6145 "Tag.c"
				}
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = parent_path;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = components;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = i;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = gee_list_get (_tmp21_, _tmp22_);
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp24_ = (gchar*) _tmp23_;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp24_, NULL);
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp26_ = _tmp25_;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (parent_path);
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				parent_path = _tmp27_;
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp26_);
#line 769 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp24_);
#line 6171 "Tag.c"
			}
		}
	}
#line 771 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp28_ = tag_global;
#line 771 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp29_ = parent_path;
#line 771 "/home/jens/Source/shotwell/src/Tag.vala"
	if (tag_source_collection_exists (_tmp28_, _tmp29_, FALSE)) {
#line 6181 "Tag.c"
		const gchar* _tmp30_;
		Tag* _tmp31_;
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp30_ = parent_path;
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp31_ = tag_for_path (_tmp30_);
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		result = _tmp31_;
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (parent_path);
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (components);
#line 772 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6196 "Tag.c"
	} else {
#line 774 "/home/jens/Source/shotwell/src/Tag.vala"
		result = NULL;
#line 774 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (parent_path);
#line 774 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (components);
#line 774 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6206 "Tag.c"
	}
#line 753 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (parent_path);
#line 753 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (components);
#line 6212 "Tag.c"
}


gint
tag_get_attachment_count (Tag* self,
                          MediaSource* source)
{
	gint result = 0;
	gint _result_ = 0;
#line 777 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), 0);
#line 777 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), 0);
#line 779 "/home/jens/Source/shotwell/src/Tag.vala"
	if (!tag_contains (self, source)) {
#line 780 "/home/jens/Source/shotwell/src/Tag.vala"
		result = 0;
#line 780 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6232 "Tag.c"
	}
#line 783 "/home/jens/Source/shotwell/src/Tag.vala"
	_result_ = 1;
#line 6236 "Tag.c"
	{
		GeeList* _child_list = NULL;
		GeeList* _tmp0_;
		gint _child_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _child_index = 0;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = tag_get_hierarchical_children (self);
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_list = _tmp0_;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = _child_list;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_size = _tmp3_;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_index = -1;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 6261 "Tag.c"
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			Tag* child = NULL;
			GeeList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			Tag* _tmp10_;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _child_index;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_child_index = _tmp4_ + 1;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _child_index;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _child_size;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 6282 "Tag.c"
			}
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = _child_list;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _child_index;
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = gee_list_get (_tmp7_, _tmp8_);
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			child = (Tag*) _tmp9_;
#line 787 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = child;
#line 787 "/home/jens/Source/shotwell/src/Tag.vala"
			if (tag_contains (_tmp10_, source)) {
#line 6296 "Tag.c"
				gint _tmp11_;
#line 788 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = _result_;
#line 788 "/home/jens/Source/shotwell/src/Tag.vala"
				_result_ = _tmp11_ + 1;
#line 6302 "Tag.c"
			}
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (child);
#line 6306 "Tag.c"
		}
#line 786 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_child_list);
#line 6310 "Tag.c"
	}
#line 790 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _result_;
#line 790 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6316 "Tag.c"
}


/**
     * gets all hierarchical children of a tag recursively; tags are enumerated from most-derived
     * to least-derived
     */
GeeList*
tag_get_hierarchical_children (Tag* self)
{
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result_reversed = NULL;
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GeeTreeSet* forward_sorted_paths = NULL;
	GeeTreeSet* _tmp5_;
	gchar* target_path = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 797 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 798 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 798 "/home/jens/Source/shotwell/src/Tag.vala"
	_result_ = _tmp0_;
#line 799 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 799 "/home/jens/Source/shotwell/src/Tag.vala"
	result_reversed = _tmp1_;
#line 802 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_get_path (self);
#line 802 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 802 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = !g_str_has_prefix (_tmp3_, TAG_PATH_SEPARATOR_STRING);
#line 802 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp3_);
#line 802 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp4_) {
#line 803 "/home/jens/Source/shotwell/src/Tag.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_LIST, GeeList);
#line 803 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (result_reversed);
#line 803 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 6368 "Tag.c"
	}
#line 807 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 807 "/home/jens/Source/shotwell/src/Tag.vala"
	forward_sorted_paths = _tmp5_;
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = tag_get_path (self);
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = _tmp6_;
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = g_strconcat (_tmp7_, TAG_PATH_SEPARATOR_STRING, NULL);
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = _tmp8_;
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp7_);
#line 809 "/home/jens/Source/shotwell/src/Tag.vala"
	target_path = _tmp9_;
#line 6386 "Tag.c"
	{
		GeeIterator* _path_it = NULL;
		TagSourceCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp10_ = tag_global;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp11_ = tag_source_collection_get_all_names (_tmp10_);
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp12_ = _tmp11_;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp14_ = _tmp13_;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp12_);
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_path_it = _tmp14_;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 6410 "Tag.c"
			GeeIterator* _tmp15_;
			gchar* path = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = _path_it;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp15_)) {
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 6423 "Tag.c"
			}
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = _path_it;
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = gee_iterator_get (_tmp16_);
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			path = (gchar*) _tmp17_;
#line 811 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp18_ = path;
#line 811 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = target_path;
#line 811 "/home/jens/Source/shotwell/src/Tag.vala"
			if (g_str_has_prefix (_tmp18_, _tmp19_)) {
#line 6437 "Tag.c"
				GeeTreeSet* _tmp20_;
				const gchar* _tmp21_;
#line 812 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = forward_sorted_paths;
#line 812 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = path;
#line 812 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 6446 "Tag.c"
			}
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (path);
#line 6450 "Tag.c"
		}
#line 810 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_path_it);
#line 6454 "Tag.c"
	}
	{
		GeeIterator* _tmp_it = NULL;
		GeeTreeSet* _tmp22_;
		GeeIterator* _tmp23_;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp22_ = forward_sorted_paths;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp23_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp_it = _tmp23_;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 6468 "Tag.c"
			GeeIterator* _tmp24_;
			gchar* tmp = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			GeeArrayList* _tmp27_;
			const gchar* _tmp28_;
			Tag* _tmp29_;
			Tag* _tmp30_;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = _tmp_it;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp24_)) {
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 6483 "Tag.c"
			}
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp25_ = _tmp_it;
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp26_ = gee_iterator_get (_tmp25_);
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			tmp = (gchar*) _tmp26_;
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp27_ = result_reversed;
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp28_ = tmp;
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp29_ = tag_for_path (_tmp28_);
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp30_ = _tmp29_;
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp30_);
#line 816 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp30_);
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (tmp);
#line 6505 "Tag.c"
		}
#line 815 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp_it);
#line 6509 "Tag.c"
	}
	{
		gint index = 0;
		GeeArrayList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp31_ = result_reversed;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp32_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp33_ = _tmp32_;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
		index = _tmp33_ - 1;
#line 6524 "Tag.c"
		{
			gboolean _tmp34_ = FALSE;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp34_ = TRUE;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 6531 "Tag.c"
				gint _tmp36_;
				GeeArrayList* _tmp37_;
				GeeArrayList* _tmp38_;
				gint _tmp39_;
				gpointer _tmp40_;
				Tag* _tmp41_;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!_tmp34_) {
#line 6540 "Tag.c"
					gint _tmp35_;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp35_ = index;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
					index = _tmp35_ - 1;
#line 6546 "Tag.c"
				}
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp34_ = FALSE;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp36_ = index;
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!(_tmp36_ >= 0)) {
#line 819 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 6556 "Tag.c"
				}
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp37_ = _result_;
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp38_ = result_reversed;
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp39_ = index;
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp40_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp39_);
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp41_ = (Tag*) _tmp40_;
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp41_);
#line 820 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp41_);
#line 6572 "Tag.c"
			}
		}
	}
#line 823 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_LIST, GeeList);
#line 823 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (target_path);
#line 823 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (forward_sorted_paths);
#line 823 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (result_reversed);
#line 823 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6586 "Tag.c"
}


static gchar*
tag_get_next_untitled_tag_name (const gchar* _prefix)
{
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* prefix = NULL;
	gchar* _tmp1_;
	gchar* candidate_name = NULL;
	gchar* _tmp2_;
	guint64 counter = 0ULL;
#line 829 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_prefix != NULL) {
#line 829 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = _prefix;
#line 6604 "Tag.c"
	} else {
#line 829 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = "";
#line 6608 "Tag.c"
	}
#line 829 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 829 "/home/jens/Source/shotwell/src/Tag.vala"
	prefix = _tmp1_;
#line 830 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = g_strdup (_ ("untitled"));
#line 830 "/home/jens/Source/shotwell/src/Tag.vala"
	candidate_name = _tmp2_;
#line 831 "/home/jens/Source/shotwell/src/Tag.vala"
	counter = (guint64) 0;
#line 6620 "Tag.c"
	{
		gboolean _tmp3_ = FALSE;
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = TRUE;
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 6627 "Tag.c"
			gchar* _tmp5_ = NULL;
			guint64 _tmp6_;
			gchar* path_candidate = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			TagSourceCollection* _tmp18_;
			const gchar* _tmp19_;
			guint64 _tmp20_;
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!_tmp3_) {
#line 6642 "Tag.c"
				guint64 _tmp4_;
#line 840 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp4_ = counter;
#line 840 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!(_tmp4_ < G_MAXUINT64)) {
#line 840 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 6650 "Tag.c"
				}
			}
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = FALSE;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = counter;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp6_ == ((guint64) 0)) {
#line 6659 "Tag.c"
				gchar* _tmp7_;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp7_ = g_strdup ("");
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp5_);
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = _tmp7_;
#line 6667 "Tag.c"
			} else {
				guint64 _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp8_ = counter;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp9_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp8_);
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp10_ = _tmp9_;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = g_strconcat (" ", _tmp10_, NULL);
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp5_);
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = _tmp11_;
#line 834 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp10_);
#line 6687 "Tag.c"
			}
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = prefix;
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = candidate_name;
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = _tmp14_;
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = g_strconcat (_tmp15_, _tmp5_, NULL);
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = _tmp16_;
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp15_);
#line 833 "/home/jens/Source/shotwell/src/Tag.vala"
			path_candidate = _tmp17_;
#line 836 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp18_ = tag_global;
#line 836 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = path_candidate;
#line 836 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!tag_source_collection_exists (_tmp18_, _tmp19_, FALSE)) {
#line 837 "/home/jens/Source/shotwell/src/Tag.vala"
				result = path_candidate;
#line 837 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp5_);
#line 837 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (candidate_name);
#line 837 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (prefix);
#line 837 "/home/jens/Source/shotwell/src/Tag.vala"
				return result;
#line 6721 "Tag.c"
			}
#line 839 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = counter;
#line 839 "/home/jens/Source/shotwell/src/Tag.vala"
			counter = _tmp20_ + 1;
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (path_candidate);
#line 832 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp5_);
#line 6731 "Tag.c"
		}
	}
#line 843 "/home/jens/Source/shotwell/src/Tag.vala"
	g_assert_not_reached ();
#line 828 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (candidate_name);
#line 828 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (prefix);
#line 6740 "Tag.c"
}


Tag*
tag_create_new_child (Tag* self)
{
	Tag* result = NULL;
	gchar* path_prefix = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	Tag* _tmp12_;
	Tag* _tmp13_;
#line 846 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 847 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_path (self);
#line 847 "/home/jens/Source/shotwell/src/Tag.vala"
	path_prefix = _tmp0_;
#line 849 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = path_prefix;
#line 849 "/home/jens/Source/shotwell/src/Tag.vala"
	if (!g_str_has_prefix (_tmp1_, TAG_PATH_SEPARATOR_STRING)) {
#line 6768 "Tag.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = tag_get_path (self);
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_;
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp3_);
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = _tmp4_;
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_set_raw_path (self, _tmp5_, FALSE);
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (_tmp5_);
#line 850 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (_tmp3_);
#line 852 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = tag_get_path (self);
#line 852 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (path_prefix);
#line 852 "/home/jens/Source/shotwell/src/Tag.vala"
		path_prefix = _tmp6_;
#line 6794 "Tag.c"
	}
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = path_prefix;
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = g_strconcat (_tmp7_, TAG_PATH_SEPARATOR_STRING, NULL);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = _tmp8_;
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp10_ = tag_get_next_untitled_tag_name (_tmp9_);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = _tmp10_;
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = tag_for_path (_tmp11_);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp13_ = _tmp12_;
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp11_);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp9_);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp13_;
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (path_prefix);
#line 855 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6820 "Tag.c"
}


Tag*
tag_create_new_root (void)
{
	Tag* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Tag* _tmp2_;
	Tag* _tmp3_;
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_next_untitled_tag_name (NULL);
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_for_path (_tmp1_);
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = _tmp2_;
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp3_;
#line 859 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6846 "Tag.c"
}


gchar*
tag_get_name_collation_key (Tag* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 862 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 863 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->name_collation_key;
#line 863 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp0_ == NULL) {
#line 6863 "Tag.c"
		TagRow* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 864 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = self->priv->row;
#line 864 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = _tmp1_->name;
#line 864 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = g_utf8_collate_key (_tmp2_, (gssize) -1);
#line 864 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (self->priv->name_collation_key);
#line 864 "/home/jens/Source/shotwell/src/Tag.vala"
		self->priv->name_collation_key = _tmp3_;
#line 6877 "Tag.c"
	}
#line 866 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = self->priv->name_collation_key;
#line 866 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 866 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp5_;
#line 866 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6887 "Tag.c"
}


static gchar*
tag_real_to_string (DataObject* base)
{
	Tag * self;
	gchar* result = NULL;
	TagRow* _tmp0_;
	const gchar* _tmp1_;
	ViewCollection* _tmp2_;
	gchar* _tmp3_;
#line 869 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->row;
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_->name;
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = self->priv->media_views;
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = g_strdup_printf ("Tag %s (%d sources)", _tmp1_, data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection)));
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp3_;
#line 870 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6914 "Tag.c"
}


static gboolean
tag_real_equals (DataSource* base,
                 DataSource* source)
{
	Tag * self;
	gboolean result = FALSE;
	Tag* tag = NULL;
	Tag* _tmp0_;
	Tag* _tmp1_;
#line 873 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 873 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 875 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (source, TYPE_TAG) ? ((Tag*) source) : NULL);
#line 875 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp0_;
#line 876 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = tag;
#line 876 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp1_ != NULL) {
#line 6939 "Tag.c"
		Tag* _tmp2_;
#line 877 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = tag;
#line 877 "/home/jens/Source/shotwell/src/Tag.vala"
		if (_tmp2_ != self) {
#line 6945 "Tag.c"
			Tag* _tmp3_;
			TagRow* _tmp4_;
			TagID _tmp5_;
			gint64 _tmp6_;
			TagRow* _tmp7_;
			TagID _tmp8_;
			gint64 _tmp9_;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = tag;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _tmp3_->priv->row;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _tmp4_->tag_id;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _tmp5_.id;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = self->priv->row;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _tmp7_->tag_id;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _tmp8_.id;
#line 878 "/home/jens/Source/shotwell/src/Tag.vala"
			_vala_assert (_tmp6_ != _tmp9_, "tag.row.tag_id.id != row.tag_id.id");
#line 6969 "Tag.c"
		}
	}
#line 882 "/home/jens/Source/shotwell/src/Tag.vala"
	result = DATA_SOURCE_CLASS (tag_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), source);
#line 882 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (tag);
#line 882 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 6978 "Tag.c"
}


void
tag_get_tag_id (Tag* self,
                TagID* result)
{
	TagRow* _tmp0_;
	TagID _tmp1_;
#line 885 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 886 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->row;
#line 886 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_->tag_id;
#line 886 "/home/jens/Source/shotwell/src/Tag.vala"
	*result = _tmp1_;
#line 886 "/home/jens/Source/shotwell/src/Tag.vala"
	return;
#line 6998 "Tag.c"
}


static SourceSnapshot*
tag_real_save_snapshot (DataSource* base)
{
	Tag * self;
	SourceSnapshot* result = NULL;
	TagTagSnapshot* _tmp0_;
#line 889 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 890 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_tag_snapshot_new (self);
#line 890 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_SNAPSHOT, SourceSnapshot);
#line 890 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7016 "Tag.c"
}


static SourceProxy*
tag_real_get_proxy (Proxyable* base)
{
	Tag * self;
	SourceProxy* result = NULL;
	TagTagProxy* _tmp0_;
#line 893 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 894 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_tag_proxy_new (self);
#line 894 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_PROXY, SourceProxy);
#line 894 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7034 "Tag.c"
}


Tag*
tag_reconstitute (gint64 object_id,
                  TagRow* row)
{
	Tag* result = NULL;
	Tag* tag = NULL;
	Tag* _tmp6_;
	TagSourceCollection* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 897 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG_ROW (row), NULL);
#line 7051 "Tag.c"
	{
		TagID _tmp0_ = {0};
		TagTable* _tmp1_;
		TagTable* _tmp2_;
		TagID _tmp3_ = {0};
		TagID _tmp4_;
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = tag_table_get_instance ();
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = _tmp1_;
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_table_create_from_row (_tmp2_, row, &_tmp3_, &_inner_error_);
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = _tmp3_;
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp2_);
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = _tmp4_;
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7074 "Tag.c"
				goto __catch485_database_error;
			}
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
			return NULL;
#line 7083 "Tag.c"
		}
#line 900 "/home/jens/Source/shotwell/src/Tag.vala"
		row->tag_id = _tmp0_;
#line 7087 "Tag.c"
	}
	goto __finally485;
	__catch485_database_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 902 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = err;
#line 902 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp5_);
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 7104 "Tag.c"
	}
	__finally485:
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 899 "/home/jens/Source/shotwell/src/Tag.vala"
		return NULL;
#line 7115 "Tag.c"
	}
#line 905 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = tag_new (row, object_id);
#line 905 "/home/jens/Source/shotwell/src/Tag.vala"
	tag = _tmp6_;
#line 906 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = tag_global;
#line 906 "/home/jens/Source/shotwell/src/Tag.vala"
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (tag, TYPE_DATA_OBJECT, DataObject));
#line 908 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (tag, TYPE_DATA_OBJECT, DataObject));
#line 908 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp9_ = _tmp8_;
#line 908 "/home/jens/Source/shotwell/src/Tag.vala"
	g_debug ("Tag.vala:908: Reconstituted %s", _tmp9_);
#line 908 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp9_);
#line 910 "/home/jens/Source/shotwell/src/Tag.vala"
	result = tag;
#line 910 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7137 "Tag.c"
}


static gboolean
tag_real_has_links (ContainerSource* base)
{
	Tag * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollection* _tmp0_;
	SourceBacklink* _tmp1_;
	SourceBacklink* _tmp2_;
	gboolean _tmp3_;
#line 913 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = library_photo_global;
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = container_source_get_backlink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource));
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = _tmp1_;
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = source_collection_has_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp2_);
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	_source_backlink_unref0 (_tmp2_);
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp3_;
#line 914 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7166 "Tag.c"
}


static SourceBacklink*
tag_real_get_backlink (ContainerSource* base)
{
	Tag * self;
	SourceBacklink* result = NULL;
	SourceBacklink* _tmp0_;
#line 917 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 918 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = source_backlink_new_from_source (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 918 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp0_;
#line 918 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7184 "Tag.c"
}


static void
tag_real_break_link (ContainerSource* base,
                     DataSource* source)
{
	Tag * self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
#line 921 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 921 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 922 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->unlinking = TRUE;
#line 924 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_detach (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
#line 924 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 924 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp1_);
#line 926 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->unlinking = FALSE;
#line 7209 "Tag.c"
}


static void
tag_real_break_link_many (ContainerSource* base,
                          GeeCollection* sources)
{
	Tag * self;
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
#line 929 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 929 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 930 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->unlinking = TRUE;
#line 932 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_detach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
#line 932 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 932 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp1_);
#line 934 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->unlinking = FALSE;
#line 7234 "Tag.c"
}


static void
tag_real_establish_link (ContainerSource* base,
                         DataSource* source)
{
	Tag * self;
#line 937 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 937 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 938 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->relinking = TRUE;
#line 940 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_attach (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
#line 942 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->relinking = FALSE;
#line 7253 "Tag.c"
}


static void
tag_real_establish_link_many (ContainerSource* base,
                              GeeCollection* sources)
{
	Tag * self;
#line 945 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 945 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 946 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->relinking = TRUE;
#line 948 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_attach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
#line 950 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->relinking = FALSE;
#line 7272 "Tag.c"
}


static void
tag_update_indexable_keywords (Tag* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 953 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_searchable_name (self);
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = indexable_prepare_indexable_string (_tmp1_);
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (self->priv->indexable_keywords);
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->indexable_keywords = _tmp2_;
#line 954 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 7296 "Tag.c"
}


static const gchar*
tag_real_get_indexable_keywords (Indexable* base)
{
	Tag * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
#line 957 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 958 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->indexable_keywords;
#line 958 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp0_;
#line 958 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7314 "Tag.c"
}


void
tag_attach (Tag* self,
            MediaSource* source)
{
	Tag* attach_to = NULL;
	Tag* _tmp0_;
#line 961 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 961 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (source));
#line 962 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 962 "/home/jens/Source/shotwell/src/Tag.vala"
	attach_to = _tmp0_;
#line 963 "/home/jens/Source/shotwell/src/Tag.vala"
	while (TRUE) {
#line 7334 "Tag.c"
		Tag* _tmp1_;
		Tag* _tmp2_;
		ViewCollection* _tmp3_;
		Tag* _tmp8_;
		Tag* _tmp9_;
#line 963 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = attach_to;
#line 963 "/home/jens/Source/shotwell/src/Tag.vala"
		if (!(_tmp1_ != NULL)) {
#line 963 "/home/jens/Source/shotwell/src/Tag.vala"
			break;
#line 7346 "Tag.c"
		}
#line 964 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = attach_to;
#line 964 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_->priv->media_views;
#line 964 "/home/jens/Source/shotwell/src/Tag.vala"
		if (!view_collection_has_view_for_source (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource))) {
#line 7354 "Tag.c"
			Tag* _tmp4_;
			ViewCollection* _tmp5_;
			ThumbnailView* _tmp6_;
			ThumbnailView* _tmp7_;
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = attach_to;
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _tmp4_->priv->media_views;
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = _tmp6_;
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
#line 965 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp7_);
#line 7371 "Tag.c"
		}
#line 968 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = attach_to;
#line 968 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp9_ = tag_get_hierarchical_parent (_tmp8_);
#line 968 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (attach_to);
#line 968 "/home/jens/Source/shotwell/src/Tag.vala"
		attach_to = _tmp9_;
#line 7381 "Tag.c"
	}
#line 961 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (attach_to);
#line 7385 "Tag.c"
}


void
tag_attach_many (Tag* self,
                 GeeCollection* sources)
{
	Tag* attach_to = NULL;
	Tag* _tmp0_;
#line 972 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 972 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 973 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 973 "/home/jens/Source/shotwell/src/Tag.vala"
	attach_to = _tmp0_;
#line 974 "/home/jens/Source/shotwell/src/Tag.vala"
	while (TRUE) {
#line 7405 "Tag.c"
		Tag* _tmp1_;
		GeeArrayList* view_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		Tag* _tmp22_;
		Tag* _tmp23_;
#line 974 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = attach_to;
#line 974 "/home/jens/Source/shotwell/src/Tag.vala"
		if (!(_tmp1_ != NULL)) {
#line 974 "/home/jens/Source/shotwell/src/Tag.vala"
			break;
#line 7420 "Tag.c"
		}
#line 975 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 975 "/home/jens/Source/shotwell/src/Tag.vala"
		view_list = _tmp2_;
#line 7426 "Tag.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp3_;
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
			_source_it = _tmp3_;
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 7436 "Tag.c"
				GeeIterator* _tmp4_;
				MediaSource* source = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				Tag* _tmp7_;
				ViewCollection* _tmp8_;
				MediaSource* _tmp9_;
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp4_ = _source_it;
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp4_)) {
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 7450 "Tag.c"
				}
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = _source_it;
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				source = (MediaSource*) _tmp6_;
#line 977 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp7_ = attach_to;
#line 977 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp8_ = _tmp7_->priv->media_views;
#line 977 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp9_ = source;
#line 977 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!view_collection_has_view_for_source (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource))) {
#line 7466 "Tag.c"
					GeeArrayList* _tmp10_;
					MediaSource* _tmp11_;
					ThumbnailView* _tmp12_;
					ThumbnailView* _tmp13_;
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp10_ = view_list;
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp11_ = source;
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp12_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp13_ = _tmp12_;
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 978 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (_tmp13_);
#line 7483 "Tag.c"
				}
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (source);
#line 7487 "Tag.c"
			}
#line 976 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_source_it);
#line 7491 "Tag.c"
		}
#line 981 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp14_ = view_list;
#line 981 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 981 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp16_ = _tmp15_;
#line 981 "/home/jens/Source/shotwell/src/Tag.vala"
		if (_tmp16_ > 0) {
#line 7501 "Tag.c"
			Tag* _tmp17_;
			ViewCollection* _tmp18_;
			GeeArrayList* _tmp19_;
			GeeCollection* _tmp20_;
			GeeCollection* _tmp21_;
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = attach_to;
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp18_ = _tmp17_->priv->media_views;
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = view_list;
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = _tmp20_;
#line 982 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_tmp21_);
#line 7519 "Tag.c"
		}
#line 984 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp22_ = attach_to;
#line 984 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp23_ = tag_get_hierarchical_parent (_tmp22_);
#line 984 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (attach_to);
#line 984 "/home/jens/Source/shotwell/src/Tag.vala"
		attach_to = _tmp23_;
#line 974 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (view_list);
#line 7531 "Tag.c"
	}
#line 972 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (attach_to);
#line 7535 "Tag.c"
}


GeeList*
tag_detach (Tag* self,
            MediaSource* source)
{
	GeeList* result = NULL;
	DataView* this_view = NULL;
	ViewCollection* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp2_;
	GeeList* detached_from = NULL;
	GeeArrayList* _tmp3_;
	ViewCollection* _tmp27_;
	ViewCollection* _tmp28_;
	DataView* _tmp29_;
	Marker* _tmp30_;
	Marker* _tmp31_;
	GeeList* _tmp32_;
#line 991 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 991 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
#line 992 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 992 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = view_collection_get_view_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 992 "/home/jens/Source/shotwell/src/Tag.vala"
	this_view = _tmp1_;
#line 993 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = this_view;
#line 993 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp2_ == NULL) {
#line 994 "/home/jens/Source/shotwell/src/Tag.vala"
		result = NULL;
#line 994 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (this_view);
#line 994 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 7576 "Tag.c"
	}
#line 996 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 996 "/home/jens/Source/shotwell/src/Tag.vala"
	detached_from = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
#line 7582 "Tag.c"
	{
		GeeList* _child_tag_list = NULL;
		GeeList* _tmp4_;
		gint _child_tag_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _child_tag_index = 0;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = tag_get_hierarchical_children (self);
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_tag_list = _tmp4_;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = _child_tag_list;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = _tmp6_;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_tag_size = _tmp7_;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_child_tag_index = -1;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 7607 "Tag.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			Tag* child_tag = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			DataView* child_view = NULL;
			Tag* _tmp14_;
			ViewCollection* _tmp15_;
			DataView* _tmp16_;
			DataView* _tmp17_;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = _child_tag_index;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_child_tag_index = _tmp8_ + 1;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = _child_tag_index;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = _child_tag_size;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 7632 "Tag.c"
			}
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp11_ = _child_tag_list;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp12_ = _child_tag_index;
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			child_tag = (Tag*) _tmp13_;
#line 999 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = child_tag;
#line 999 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = _tmp14_->priv->media_views;
#line 999 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = view_collection_get_view_for_source (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 999 "/home/jens/Source/shotwell/src/Tag.vala"
			child_view = _tmp16_;
#line 1000 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = child_view;
#line 1000 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp17_ != NULL) {
#line 7654 "Tag.c"
				Tag* _tmp18_;
				ViewCollection* _tmp19_;
				Tag* _tmp20_;
				ViewCollection* _tmp21_;
				DataView* _tmp22_;
				Marker* _tmp23_;
				Marker* _tmp24_;
				GeeList* _tmp25_;
				Tag* _tmp26_;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp18_ = child_tag;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp19_ = _tmp18_->priv->media_views;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = child_tag;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = _tmp20_->priv->media_views;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = child_view;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp23_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_OBJECT, DataObject));
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp24_ = _tmp23_;
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_COLLECTION, DataCollection), _tmp24_);
#line 1001 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_tmp24_);
#line 1002 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = detached_from;
#line 1002 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp26_ = child_tag;
#line 1002 "/home/jens/Source/shotwell/src/Tag.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
#line 7688 "Tag.c"
			}
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (child_view);
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (child_tag);
#line 7694 "Tag.c"
		}
#line 998 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_child_tag_list);
#line 7698 "Tag.c"
	}
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp27_ = self->priv->media_views;
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp28_ = self->priv->media_views;
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp29_ = this_view;
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp30_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_OBJECT, DataObject));
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp31_ = _tmp30_;
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_DATA_COLLECTION, DataCollection), _tmp31_);
#line 1006 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp31_);
#line 1007 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp32_ = detached_from;
#line 1007 "/home/jens/Source/shotwell/src/Tag.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), self);
#line 1009 "/home/jens/Source/shotwell/src/Tag.vala"
	result = detached_from;
#line 1009 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (this_view);
#line 1009 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7724 "Tag.c"
}


GeeMultiMap*
tag_detach_many (Tag* self,
                 GeeCollection* sources)
{
	GeeMultiMap* result = NULL;
	GeeMultiMap* detached_from = NULL;
	GeeHashMultiMap* _tmp0_;
	Marker* marker = NULL;
	ViewCollection* _tmp1_;
	Marker* _tmp2_;
	ViewCollection* _tmp40_;
	Marker* _tmp41_;
	GeeMultiMap* _tmp42_ = NULL;
	GeeMultiMap* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	GeeMultiMap* _tmp47_;
#line 1015 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 1015 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (sources), NULL);
#line 1016 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_hash_multi_map_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1016 "/home/jens/Source/shotwell/src/Tag.vala"
	detached_from = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 1018 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = self->priv->media_views;
#line 1018 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 1018 "/home/jens/Source/shotwell/src/Tag.vala"
	marker = _tmp2_;
#line 7759 "Tag.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp3_;
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
		_source_it = _tmp3_;
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 7769 "Tag.c"
			GeeIterator* _tmp4_;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataView* view = NULL;
			ViewCollection* _tmp7_;
			MediaSource* _tmp8_;
			DataView* _tmp9_;
			DataView* _tmp10_;
			Marker* _tmp36_;
			DataView* _tmp37_;
			GeeMultiMap* _tmp38_;
			MediaSource* _tmp39_;
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp4_ = _source_it;
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 7789 "Tag.c"
			}
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp5_ = _source_it;
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			source = (MediaSource*) _tmp6_;
#line 1020 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = self->priv->media_views;
#line 1020 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = source;
#line 1020 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = view_collection_get_view_for_source (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_SOURCE, DataSource));
#line 1020 "/home/jens/Source/shotwell/src/Tag.vala"
			view = _tmp9_;
#line 1021 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = view;
#line 1021 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_tmp10_ == NULL) {
#line 1022 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (view);
#line 1022 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (source);
#line 1022 "/home/jens/Source/shotwell/src/Tag.vala"
				continue;
#line 7815 "Tag.c"
			}
			{
				GeeList* _child_tag_list = NULL;
				GeeList* _tmp11_;
				gint _child_tag_size = 0;
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _child_tag_index = 0;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = tag_get_hierarchical_children (self);
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_child_tag_list = _tmp11_;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = _child_tag_list;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp14_ = _tmp13_;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_child_tag_size = _tmp14_;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_child_tag_index = -1;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				while (TRUE) {
#line 7841 "Tag.c"
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					Tag* child_tag = NULL;
					GeeList* _tmp18_;
					gint _tmp19_;
					gpointer _tmp20_;
					DataView* child_view = NULL;
					Tag* _tmp21_;
					ViewCollection* _tmp22_;
					MediaSource* _tmp23_;
					DataView* _tmp24_;
					DataView* _tmp25_;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp15_ = _child_tag_index;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_child_tag_index = _tmp15_ + 1;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp16_ = _child_tag_index;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp17_ = _child_tag_size;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					if (!(_tmp16_ < _tmp17_)) {
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
						break;
#line 7867 "Tag.c"
					}
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp18_ = _child_tag_list;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp19_ = _child_tag_index;
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp20_ = gee_list_get (_tmp18_, _tmp19_);
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					child_tag = (Tag*) _tmp20_;
#line 1025 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp21_ = child_tag;
#line 1025 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp22_ = _tmp21_->priv->media_views;
#line 1025 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp23_ = source;
#line 1025 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp24_ = view_collection_get_view_for_source (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DATA_SOURCE, DataSource));
#line 1025 "/home/jens/Source/shotwell/src/Tag.vala"
					child_view = _tmp24_;
#line 1026 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp25_ = child_view;
#line 1026 "/home/jens/Source/shotwell/src/Tag.vala"
					if (_tmp25_ != NULL) {
#line 7891 "Tag.c"
						Tag* _tmp26_;
						ViewCollection* _tmp27_;
						Tag* _tmp28_;
						ViewCollection* _tmp29_;
						DataView* _tmp30_;
						Marker* _tmp31_;
						Marker* _tmp32_;
						GeeMultiMap* _tmp33_;
						Tag* _tmp34_;
						MediaSource* _tmp35_;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp26_ = child_tag;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp27_ = _tmp26_->priv->media_views;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp28_ = child_tag;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp29_ = _tmp28_->priv->media_views;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp30_ = child_view;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp31_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_DATA_OBJECT, DataObject));
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp32_ = _tmp31_;
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_DATA_COLLECTION, DataCollection), _tmp32_);
#line 1027 "/home/jens/Source/shotwell/src/Tag.vala"
						_g_object_unref0 (_tmp32_);
#line 1028 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp33_ = detached_from;
#line 1028 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp34_ = child_tag;
#line 1028 "/home/jens/Source/shotwell/src/Tag.vala"
						_tmp35_ = source;
#line 1028 "/home/jens/Source/shotwell/src/Tag.vala"
						gee_multi_map_set (_tmp33_, _tmp34_, _tmp35_);
#line 7928 "Tag.c"
					}
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (child_view);
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_object_unref0 (child_tag);
#line 7934 "Tag.c"
				}
#line 1024 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (_child_tag_list);
#line 7938 "Tag.c"
			}
#line 1032 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp36_ = marker;
#line 1032 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp37_ = view;
#line 1032 "/home/jens/Source/shotwell/src/Tag.vala"
			marker_mark (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_DATA_OBJECT, DataObject));
#line 1033 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp38_ = detached_from;
#line 1033 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp39_ = source;
#line 1033 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_multi_map_set (_tmp38_, self, _tmp39_);
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (view);
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (source);
#line 7956 "Tag.c"
		}
#line 1019 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_source_it);
#line 7960 "Tag.c"
	}
#line 1036 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp40_ = self->priv->media_views;
#line 1036 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp41_ = marker;
#line 1036 "/home/jens/Source/shotwell/src/Tag.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_COLLECTION, DataCollection), _tmp41_);
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp43_ = detached_from;
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp44_ = gee_multi_map_get_size (_tmp43_);
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp45_ = _tmp44_;
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp45_ > 0) {
#line 7976 "Tag.c"
		GeeMultiMap* _tmp46_;
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp46_ = detached_from;
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp42_ = _tmp46_;
#line 7982 "Tag.c"
	} else {
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp42_ = NULL;
#line 7986 "Tag.c"
	}
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp47_ = _g_object_ref0 (_tmp42_);
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp47_;
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (marker);
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (detached_from);
#line 1038 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 7998 "Tag.c"
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1025 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1025 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1026 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1026 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1028 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1028 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 8023 "Tag.c"
		gchar* _tmp2_;
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 8031 "Tag.c"
	} else {
#line 1031 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1031 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 8037 "Tag.c"
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 8062 "Tag.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 8071 "Tag.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 8092 "Tag.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 8096 "Tag.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 8102 "Tag.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 8112 "Tag.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 8116 "Tag.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 8124 "Tag.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 8131 "Tag.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 8135 "Tag.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 8141 "Tag.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 8153 "Tag.c"
}


gboolean
tag_rename (Tag* self,
            const gchar* name)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* new_name = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
#line 1042 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), FALSE);
#line 1042 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 1043 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_get_user_visible_name (self);
#line 1043 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 1043 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = g_strcmp0 (name, _tmp1_) == 0;
#line 1043 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp1_);
#line 1043 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp2_) {
#line 1044 "/home/jens/Source/shotwell/src/Tag.vala"
		result = TRUE;
#line 1044 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 8189 "Tag.c"
	}
#line 1046 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = tag_prep_tag_name (name);
#line 1046 "/home/jens/Source/shotwell/src/Tag.vala"
	new_name = _tmp3_;
#line 1047 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = new_name;
#line 1047 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp4_ == NULL) {
#line 1048 "/home/jens/Source/shotwell/src/Tag.vala"
		result = FALSE;
#line 1048 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (new_name);
#line 1048 "/home/jens/Source/shotwell/src/Tag.vala"
		return result;
#line 8205 "Tag.c"
	}
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp5_ = tag_get_path (self);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp6_ = _tmp5_;
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp7_ = g_str_has_prefix (_tmp6_, TAG_PATH_SEPARATOR_STRING);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (_tmp6_);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp7_) {
#line 8217 "Tag.c"
		gchar* new_path = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* old_path = NULL;
		gchar* _tmp10_;
		Tag* parent = NULL;
		Tag* _tmp11_;
		Tag* _tmp12_;
		TagSourceCollection* _tmp22_;
		const gchar* _tmp23_;
		GeeCollection* children = NULL;
		GeeList* _tmp24_;
		const gchar* _tmp25_;
		Alteration* _tmp47_;
		Alteration* _tmp48_;
#line 1052 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = new_name;
#line 1052 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 1052 "/home/jens/Source/shotwell/src/Tag.vala"
		new_path = _tmp9_;
#line 1053 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp10_ = tag_get_path (self);
#line 1053 "/home/jens/Source/shotwell/src/Tag.vala"
		old_path = _tmp10_;
#line 1055 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp11_ = tag_get_hierarchical_parent (self);
#line 1055 "/home/jens/Source/shotwell/src/Tag.vala"
		parent = _tmp11_;
#line 1056 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp12_ = parent;
#line 1056 "/home/jens/Source/shotwell/src/Tag.vala"
		if (_tmp12_ != NULL) {
#line 8251 "Tag.c"
			Tag* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp13_ = parent;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp14_ = tag_get_path (_tmp13_);
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp15_ = _tmp14_;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp16_ = g_strconcat (_tmp15_, TAG_PATH_SEPARATOR_STRING, NULL);
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp17_ = _tmp16_;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp18_ = new_path;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (new_path);
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			new_path = _tmp19_;
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp17_);
#line 1057 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (_tmp15_);
#line 8281 "Tag.c"
		} else {
			const gchar* _tmp20_;
			gchar* _tmp21_;
#line 1059 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp20_ = new_path;
#line 1059 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp21_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp20_, NULL);
#line 1059 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (new_path);
#line 1059 "/home/jens/Source/shotwell/src/Tag.vala"
			new_path = _tmp21_;
#line 8293 "Tag.c"
		}
#line 1062 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp22_ = tag_global;
#line 1062 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp23_ = new_path;
#line 1062 "/home/jens/Source/shotwell/src/Tag.vala"
		if (tag_source_collection_exists (_tmp22_, _tmp23_, TRUE)) {
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			result = FALSE;
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (parent);
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (old_path);
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (new_path);
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (new_name);
#line 1063 "/home/jens/Source/shotwell/src/Tag.vala"
			return result;
#line 8313 "Tag.c"
		}
#line 1065 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp24_ = tag_get_hierarchical_children (self);
#line 1065 "/home/jens/Source/shotwell/src/Tag.vala"
		children = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1067 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp25_ = new_path;
#line 1067 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_set_raw_path (self, _tmp25_, TRUE);
#line 8323 "Tag.c"
		{
			GeeIterator* _child_it = NULL;
			GeeCollection* _tmp26_;
			GeeIterator* _tmp27_;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp26_ = children;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp27_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
			_child_it = _tmp27_;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 8336 "Tag.c"
				GeeIterator* _tmp28_;
				Tag* child = NULL;
				GeeIterator* _tmp29_;
				gpointer _tmp30_;
				gchar* old_child_path = NULL;
				Tag* _tmp31_;
				gchar* _tmp32_;
				gint old_path_index = 0;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gint _tmp35_;
				gchar* child_subpath = NULL;
				const gchar* _tmp36_;
				gint _tmp37_;
				const gchar* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* new_child_path = NULL;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				Tag* _tmp45_;
				const gchar* _tmp46_;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp28_ = _child_it;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp28_)) {
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 8367 "Tag.c"
				}
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp29_ = _child_it;
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp30_ = gee_iterator_get (_tmp29_);
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				child = (Tag*) _tmp30_;
#line 1072 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp31_ = child;
#line 1072 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp32_ = tag_get_path (_tmp31_);
#line 1072 "/home/jens/Source/shotwell/src/Tag.vala"
				old_child_path = _tmp32_;
#line 1076 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp33_ = old_child_path;
#line 1076 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp34_ = old_path;
#line 1076 "/home/jens/Source/shotwell/src/Tag.vala"
				old_path_index = string_index_of (_tmp33_, _tmp34_, 0);
#line 1077 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp35_ = old_path_index;
#line 1077 "/home/jens/Source/shotwell/src/Tag.vala"
				_vala_assert (_tmp35_ != -1, "old_path_index != -1");
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp36_ = old_child_path;
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp37_ = old_path_index;
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp38_ = old_path;
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp39_ = strlen (_tmp38_);
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp40_ = _tmp39_;
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp41_ = string_substring (_tmp36_, (glong) (_tmp37_ + _tmp40_), (glong) -1);
#line 1079 "/home/jens/Source/shotwell/src/Tag.vala"
				child_subpath = _tmp41_;
#line 1081 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp42_ = new_path;
#line 1081 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp43_ = child_subpath;
#line 1081 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp44_ = g_strconcat (_tmp42_, _tmp43_, NULL);
#line 1081 "/home/jens/Source/shotwell/src/Tag.vala"
				new_child_path = _tmp44_;
#line 1083 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp45_ = child;
#line 1083 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp46_ = new_child_path;
#line 1083 "/home/jens/Source/shotwell/src/Tag.vala"
				tag_set_raw_path (_tmp45_, _tmp46_, TRUE);
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (new_child_path);
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (child_subpath);
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (old_child_path);
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (child);
#line 8427 "Tag.c"
			}
#line 1069 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_child_it);
#line 8431 "Tag.c"
		}
#line 1086 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_update_indexable_keywords (self);
#line 1087 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp47_ = alteration_new_from_list ("metadata:name, indexable:keywords");
#line 1087 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp48_ = _tmp47_;
#line 1087 "/home/jens/Source/shotwell/src/Tag.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp48_);
#line 1087 "/home/jens/Source/shotwell/src/Tag.vala"
		_alteration_unref0 (_tmp48_);
#line 8443 "Tag.c"
		{
			GeeIterator* _child_it = NULL;
			GeeCollection* _tmp49_;
			GeeIterator* _tmp50_;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp49_ = children;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp50_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
			_child_it = _tmp50_;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 8456 "Tag.c"
				GeeIterator* _tmp51_;
				Tag* child = NULL;
				GeeIterator* _tmp52_;
				gpointer _tmp53_;
				Tag* _tmp54_;
				Alteration* _tmp55_;
				Alteration* _tmp56_;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp51_ = _child_it;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp51_)) {
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 8470 "Tag.c"
				}
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp52_ = _child_it;
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp53_ = gee_iterator_get (_tmp52_);
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				child = (Tag*) _tmp53_;
#line 1089 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp54_ = child;
#line 1089 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp55_ = alteration_new_from_list ("metadata:name, indexable:keywords");
#line 1089 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp56_ = _tmp55_;
#line 1089 "/home/jens/Source/shotwell/src/Tag.vala"
				data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_DATA_OBJECT, DataObject), _tmp56_);
#line 1089 "/home/jens/Source/shotwell/src/Tag.vala"
				_alteration_unref0 (_tmp56_);
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (child);
#line 8490 "Tag.c"
			}
#line 1088 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_child_it);
#line 8494 "Tag.c"
		}
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (children);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (parent);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (old_path);
#line 1051 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_free0 (new_path);
#line 8504 "Tag.c"
	} else {
		TagSourceCollection* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
#line 1093 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp57_ = tag_global;
#line 1093 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp58_ = new_name;
#line 1093 "/home/jens/Source/shotwell/src/Tag.vala"
		if (tag_source_collection_exists (_tmp57_, _tmp58_, TRUE)) {
#line 1094 "/home/jens/Source/shotwell/src/Tag.vala"
			result = FALSE;
#line 1094 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_free0 (new_name);
#line 1094 "/home/jens/Source/shotwell/src/Tag.vala"
			return result;
#line 8521 "Tag.c"
		}
#line 1096 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp59_ = new_name;
#line 1096 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_set_raw_flat_name (self, _tmp59_);
#line 8527 "Tag.c"
	}
#line 1099 "/home/jens/Source/shotwell/src/Tag.vala"
	result = TRUE;
#line 1099 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (new_name);
#line 1099 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 8535 "Tag.c"
}


gboolean
tag_contains (Tag* self,
              MediaSource* source)
{
	gboolean result = FALSE;
	ViewCollection* _tmp0_;
#line 1102 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), FALSE);
#line 1102 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 1103 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 1103 "/home/jens/Source/shotwell/src/Tag.vala"
	result = view_collection_has_view_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
#line 1103 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 8555 "Tag.c"
}


gint
tag_get_sources_count (Tag* self)
{
	gint result = 0;
	ViewCollection* _tmp0_;
#line 1106 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), 0);
#line 1107 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 1107 "/home/jens/Source/shotwell/src/Tag.vala"
	result = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 1107 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 8572 "Tag.c"
}


GeeCollection*
tag_get_sources (Tag* self)
{
	GeeCollection* result = NULL;
	ViewCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 1110 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (self), NULL);
#line 1111 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 1111 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = view_collection_get_sources (_tmp0_);
#line 1111 "/home/jens/Source/shotwell/src/Tag.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1111 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 8592 "Tag.c"
}


void
tag_mirror_sources (Tag* self,
                    ViewCollection* view,
                    CreateView mirroring_ctor,
                    void* mirroring_ctor_target)
{
	ViewCollection* _tmp0_;
#line 1114 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 1114 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (view));
#line 1115 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 1115 "/home/jens/Source/shotwell/src/Tag.vala"
	view_collection_mirror (view, _tmp0_, mirroring_ctor, mirroring_ctor_target, NULL, NULL);
#line 8611 "Tag.c"
}


static void
tag_on_media_views_contents_altered (Tag* self,
                                     GeeIterable* added,
                                     GeeIterable* removed)
{
	GeeCollection* added_sources = NULL;
	GeeCollection* removed_sources = NULL;
	GeeCollection* _tmp47_;
	GeeCollection* _tmp51_;
	gboolean _tmp55_ = FALSE;
	GeeCollection* _tmp56_;
	GError * _inner_error_ = NULL;
#line 1118 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 1118 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1118 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1120 "/home/jens/Source/shotwell/src/Tag.vala"
	added_sources = NULL;
#line 1121 "/home/jens/Source/shotwell/src/Tag.vala"
	if (added != NULL) {
#line 8637 "Tag.c"
		GeeArrayList* _tmp0_;
#line 1122 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1122 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (added_sources);
#line 1122 "/home/jens/Source/shotwell/src/Tag.vala"
		added_sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 8645 "Tag.c"
		{
			GeeIterator* _view_it = NULL;
			GeeIterator* _tmp1_;
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp1_ = gee_iterable_iterator (added);
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
			_view_it = _tmp1_;
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 8655 "Tag.c"
				GeeIterator* _tmp2_;
				DataView* view = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				MediaSource* source = NULL;
				DataView* _tmp5_;
				DataSource* _tmp6_;
				TagRow* _tmp7_;
				GeeSet* _tmp8_;
				MediaSource* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				gboolean is_added = FALSE;
				GeeCollection* _tmp20_;
				MediaSource* _tmp21_;
				gboolean _tmp22_;
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp2_ = _view_it;
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp2_)) {
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 8679 "Tag.c"
				}
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp3_ = _view_it;
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp4_ = gee_iterator_get (_tmp3_);
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				view = (DataView*) _tmp4_;
#line 1124 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp5_ = view;
#line 1124 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp6_ = data_view_get_source (_tmp5_);
#line 1124 "/home/jens/Source/shotwell/src/Tag.vala"
				source = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource);
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp7_ = self->priv->row;
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp8_ = _tmp7_->source_id_list;
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp9_ = source;
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp10_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource));
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp11_ = _tmp10_;
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp12_ = !gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp11_);
#line 1128 "/home/jens/Source/shotwell/src/Tag.vala"
				if (_tmp12_) {
#line 8709 "Tag.c"
					gboolean is_added = FALSE;
					TagRow* _tmp13_;
					GeeSet* _tmp14_;
					MediaSource* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp13_ = self->priv->row;
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp14_ = _tmp13_->source_id_list;
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp15_ = source;
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp16_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_SOURCE, DataSource));
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp17_ = _tmp16_;
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp18_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), _tmp17_);
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					_g_free0 (_tmp17_);
#line 1129 "/home/jens/Source/shotwell/src/Tag.vala"
					is_added = _tmp18_;
#line 1130 "/home/jens/Source/shotwell/src/Tag.vala"
					_tmp19_ = is_added;
#line 1130 "/home/jens/Source/shotwell/src/Tag.vala"
					_vala_assert (_tmp19_, "is_added");
#line 8738 "Tag.c"
				}
#line 1133 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp20_ = added_sources;
#line 1133 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp21_ = source;
#line 1133 "/home/jens/Source/shotwell/src/Tag.vala"
				is_added = gee_collection_add (_tmp20_, _tmp21_);
#line 1134 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp22_ = is_added;
#line 1134 "/home/jens/Source/shotwell/src/Tag.vala"
				_vala_assert (_tmp22_, "is_added");
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (source);
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (view);
#line 8754 "Tag.c"
			}
#line 1123 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_view_it);
#line 8758 "Tag.c"
		}
	}
#line 1138 "/home/jens/Source/shotwell/src/Tag.vala"
	removed_sources = NULL;
#line 1139 "/home/jens/Source/shotwell/src/Tag.vala"
	if (removed != NULL) {
#line 8765 "Tag.c"
		GeeArrayList* _tmp23_;
#line 1140 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp23_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1140 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (removed_sources);
#line 1140 "/home/jens/Source/shotwell/src/Tag.vala"
		removed_sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection);
#line 8773 "Tag.c"
		{
			GeeIterator* _view_it = NULL;
			GeeIterator* _tmp24_;
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp24_ = gee_iterable_iterator (removed);
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
			_view_it = _tmp24_;
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
			while (TRUE) {
#line 8783 "Tag.c"
				GeeIterator* _tmp25_;
				DataView* view = NULL;
				GeeIterator* _tmp26_;
				gpointer _tmp27_;
				MediaSource* source = NULL;
				DataView* _tmp28_;
				DataSource* _tmp29_;
				gboolean is_removed = FALSE;
				TagRow* _tmp30_;
				GeeSet* _tmp31_;
				MediaSource* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gboolean _tmp35_;
				gboolean _tmp36_;
				gboolean is_added = FALSE;
				GeeCollection* _tmp37_;
				MediaSource* _tmp38_;
				gboolean _tmp39_;
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp25_ = _view_it;
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				if (!gee_iterator_next (_tmp25_)) {
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
					break;
#line 8809 "Tag.c"
				}
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp26_ = _view_it;
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp27_ = gee_iterator_get (_tmp26_);
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				view = (DataView*) _tmp27_;
#line 1142 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp28_ = view;
#line 1142 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp29_ = data_view_get_source (_tmp28_);
#line 1142 "/home/jens/Source/shotwell/src/Tag.vala"
				source = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_MEDIA_SOURCE, MediaSource);
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp30_ = self->priv->row;
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp31_ = _tmp30_->source_id_list;
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp32_ = source;
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp33_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_DATA_SOURCE, DataSource));
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp34_ = _tmp33_;
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp35_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection), _tmp34_);
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_free0 (_tmp34_);
#line 1144 "/home/jens/Source/shotwell/src/Tag.vala"
				is_removed = _tmp35_;
#line 1145 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp36_ = is_removed;
#line 1145 "/home/jens/Source/shotwell/src/Tag.vala"
				_vala_assert (_tmp36_, "is_removed");
#line 1147 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp37_ = removed_sources;
#line 1147 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp38_ = source;
#line 1147 "/home/jens/Source/shotwell/src/Tag.vala"
				is_added = gee_collection_add (_tmp37_, _tmp38_);
#line 1148 "/home/jens/Source/shotwell/src/Tag.vala"
				_tmp39_ = is_added;
#line 1148 "/home/jens/Source/shotwell/src/Tag.vala"
				_vala_assert (_tmp39_, "is_added");
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (source);
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
				_g_object_unref0 (view);
#line 8857 "Tag.c"
			}
#line 1141 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (_view_it);
#line 8861 "Tag.c"
		}
	}
	{
		TagTable* _tmp40_;
		TagTable* _tmp41_;
		TagRow* _tmp42_;
		TagID _tmp43_;
		TagRow* _tmp44_;
		GeeSet* _tmp45_;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp40_ = tag_table_get_instance ();
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp41_ = _tmp40_;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp42_ = self->priv->row;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp43_ = _tmp42_->tag_id;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp44_ = self->priv->row;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp45_ = _tmp44_->source_id_list;
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_table_set_tagged_sources (_tmp41_, &_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_COLLECTION, GeeCollection), &_inner_error_);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp41_);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8891 "Tag.c"
				goto __catch486_database_error;
			}
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (removed_sources);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (added_sources);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 1153 "/home/jens/Source/shotwell/src/Tag.vala"
			return;
#line 8904 "Tag.c"
		}
	}
	goto __finally486;
	__catch486_database_error:
	{
		GError* err = NULL;
		GError* _tmp46_;
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 1155 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp46_ = err;
#line 1155 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp46_);
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 8922 "Tag.c"
	}
	__finally486:
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (removed_sources);
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (added_sources);
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 1152 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 8937 "Tag.c"
	}
#line 1159 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp47_ = added_sources;
#line 1159 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp47_ != NULL) {
#line 8943 "Tag.c"
		TagSourceCollection* _tmp48_;
		GeeCollection* _tmp49_;
		gboolean _tmp50_;
#line 1160 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp48_ = tag_global;
#line 1160 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp49_ = added_sources;
#line 1160 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp50_ = self->priv->relinking;
#line 1160 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp49_, _tmp50_);
#line 8955 "Tag.c"
	}
#line 1162 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp51_ = removed_sources;
#line 1162 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp51_ != NULL) {
#line 8961 "Tag.c"
		TagSourceCollection* _tmp52_;
		GeeCollection* _tmp53_;
		gboolean _tmp54_;
#line 1163 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp52_ = tag_global;
#line 1163 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp53_ = removed_sources;
#line 1163 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp54_ = self->priv->unlinking;
#line 1163 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp53_, _tmp54_);
#line 8973 "Tag.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp56_ = added_sources;
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp56_ != NULL) {
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp55_ = TRUE;
#line 8981 "Tag.c"
	} else {
		GeeCollection* _tmp57_;
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp57_ = removed_sources;
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp55_ = _tmp57_ != NULL;
#line 8988 "Tag.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/Tag.vala"
	if (_tmp55_) {
#line 8992 "Tag.c"
		TagSourceCollection* _tmp58_;
		GeeCollection* _tmp59_;
		gboolean _tmp60_;
		GeeCollection* _tmp61_;
		gboolean _tmp62_;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp58_ = tag_global;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp59_ = added_sources;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp60_ = self->priv->relinking;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp61_ = removed_sources;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp62_ = self->priv->unlinking;
#line 1166 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp59_, _tmp60_, _tmp61_, _tmp62_);
#line 9010 "Tag.c"
	}
#line 1118 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (removed_sources);
#line 1118 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (added_sources);
#line 9016 "Tag.c"
}


static void
tag_on_sources_destroyed (Tag* self,
                          GeeCollection* sources)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
#line 1171 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_TAG (self));
#line 1171 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 1172 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_detach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
#line 1172 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 1172 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (_tmp1_);
#line 9036 "Tag.c"
}


static void
tag_real_destroy (DataSource* base)
{
	Tag * self;
	ViewCollection* _tmp0_;
	GError * _inner_error_ = NULL;
#line 1175 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TAG, Tag);
#line 1179 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 1179 "/home/jens/Source/shotwell/src/Tag.vala"
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection)) > 0) {
#line 9052 "Tag.c"
		ViewCollection* _tmp1_;
		guint _tmp2_;
		GeeArrayList* removed = NULL;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		ViewCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		ViewCollection* _tmp8_;
		TagSourceCollection* _tmp9_;
		GeeArrayList* _tmp10_;
		TagSourceCollection* _tmp11_;
		GeeArrayList* _tmp12_;
		ViewCollection* _tmp13_;
#line 1180 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp1_ = self->priv->media_views;
#line 1180 "/home/jens/Source/shotwell/src/Tag.vala"
		g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
#line 1180 "/home/jens/Source/shotwell/src/Tag.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _tag_on_media_views_contents_altered_data_collection_contents_altered, self);
#line 1182 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1182 "/home/jens/Source/shotwell/src/Tag.vala"
		removed = _tmp3_;
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = removed;
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = self->priv->media_views;
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp6_ = view_collection_get_sources (_tmp5_);
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		gee_array_list_add_all (_tmp4_, _tmp7_);
#line 1183 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp7_);
#line 1185 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp8_ = self->priv->media_views;
#line 1185 "/home/jens/Source/shotwell/src/Tag.vala"
		data_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
#line 1187 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp9_ = tag_global;
#line 1187 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp10_ = removed;
#line 1187 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
#line 1188 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp11_ = tag_global;
#line 1188 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp12_ = removed;
#line 1188 "/home/jens/Source/shotwell/src/Tag.vala"
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), NULL, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
#line 1190 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp13_ = self->priv->media_views;
#line 1190 "/home/jens/Source/shotwell/src/Tag.vala"
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _tag_on_media_views_contents_altered_data_collection_contents_altered, self, 0);
#line 1179 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (removed);
#line 9111 "Tag.c"
	}
	{
		TagTable* _tmp14_;
		TagTable* _tmp15_;
		TagRow* _tmp16_;
		TagID _tmp17_;
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp14_ = tag_table_get_instance ();
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp15_ = _tmp14_;
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp16_ = self->priv->row;
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp17_ = _tmp16_->tag_id;
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		tag_table_remove (_tmp15_, &_tmp17_, &_inner_error_);
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		_database_table_unref0 (_tmp15_);
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 9134 "Tag.c"
				goto __catch487_database_error;
			}
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
			g_clear_error (&_inner_error_);
#line 1194 "/home/jens/Source/shotwell/src/Tag.vala"
			return;
#line 9143 "Tag.c"
		}
	}
	goto __finally487;
	__catch487_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		err = _inner_error_;
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		_inner_error_ = NULL;
#line 1196 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp18_ = err;
#line 1196 "/home/jens/Source/shotwell/src/Tag.vala"
		app_window_database_error (_tmp18_);
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_error_free0 (err);
#line 9161 "Tag.c"
	}
	__finally487:
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		g_clear_error (&_inner_error_);
#line 1193 "/home/jens/Source/shotwell/src/Tag.vala"
		return;
#line 9172 "Tag.c"
	}
#line 1199 "/home/jens/Source/shotwell/src/Tag.vala"
	DATA_SOURCE_CLASS (tag_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 9176 "Tag.c"
}


static void
_tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                        DataSource* source,
                                                                        gpointer self)
{
#line 292 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_tag_snapshot_on_source_destroyed ((TagTagSnapshot*) self, source);
#line 9187 "Tag.c"
}


static TagTagSnapshot*
tag_tag_snapshot_construct (GType object_type,
                            Tag* tag)
{
	TagTagSnapshot* self = NULL;
	TagRow* _tmp0_;
	TagRow* _tmp1_;
	LibraryPhotoSourceCollection* _tmp11_;
	VideoSourceCollection* _tmp12_;
#line 278 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (tag), NULL);
#line 278 "/home/jens/Source/shotwell/src/Tag.vala"
	self = (TagTagSnapshot*) source_snapshot_construct (object_type);
#line 280 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag->priv->row;
#line 280 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tag_row_ref0 (_tmp0_);
#line 280 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (self->priv->row);
#line 280 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->row = _tmp1_;
#line 9212 "Tag.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp2_ = tag_get_sources (tag);
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp3_ = _tmp2_;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_tmp5_ = _tmp4_;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_tmp3_);
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_source_it = _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		while (TRUE) {
#line 9233 "Tag.c"
			GeeIterator* _tmp6_;
			MediaSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeHashSet* _tmp9_;
			MediaSource* _tmp10_;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp6_ = _source_it;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
				break;
#line 9246 "Tag.c"
			}
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp7_ = _source_it;
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			source = (MediaSource*) _tmp8_;
#line 285 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp9_ = self->priv->sources;
#line 285 "/home/jens/Source/shotwell/src/Tag.vala"
			_tmp10_ = source;
#line 285 "/home/jens/Source/shotwell/src/Tag.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
			_g_object_unref0 (source);
#line 9262 "Tag.c"
		}
#line 284 "/home/jens/Source/shotwell/src/Tag.vala"
		_g_object_unref0 (_source_it);
#line 9266 "Tag.c"
	}
#line 287 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp11_ = library_photo_global;
#line 287 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SOURCE_COLLECTION, SourceCollection), "item-destroyed", (GCallback) _tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
#line 288 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp12_ = video_global;
#line 288 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_SOURCE_COLLECTION, SourceCollection), "item-destroyed", (GCallback) _tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
#line 278 "/home/jens/Source/shotwell/src/Tag.vala"
	return self;
#line 9278 "Tag.c"
}


static TagTagSnapshot*
tag_tag_snapshot_new (Tag* tag)
{
#line 278 "/home/jens/Source/shotwell/src/Tag.vala"
	return tag_tag_snapshot_construct (TAG_TYPE_TAG_SNAPSHOT, tag);
#line 9287 "Tag.c"
}


static TagRow*
tag_tag_snapshot_get_row (TagTagSnapshot* self)
{
	TagRow* result = NULL;
	TagRow* _tmp0_;
	TagRow* _tmp1_;
#line 296 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (TAG_IS_TAG_SNAPSHOT (self), NULL);
#line 297 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->row;
#line 297 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tag_row_ref0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp1_;
#line 297 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 9307 "Tag.c"
}


static void
tag_tag_snapshot_real_notify_broken (SourceSnapshot* base)
{
	TagTagSnapshot * self;
	TagRow* _tmp0_;
	GeeHashSet* _tmp1_;
#line 300 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshot);
#line 301 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_row_new ();
#line 301 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (self->priv->row);
#line 301 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->row = _tmp0_;
#line 302 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = self->priv->sources;
#line 302 "/home/jens/Source/shotwell/src/Tag.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 304 "/home/jens/Source/shotwell/src/Tag.vala"
	SOURCE_SNAPSHOT_CLASS (tag_tag_snapshot_parent_class)->notify_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_SNAPSHOT, SourceSnapshot));
#line 9331 "Tag.c"
}


static void
tag_tag_snapshot_on_source_destroyed (TagTagSnapshot* self,
                                      DataSource* source)
{
	GeeHashSet* _tmp0_;
#line 307 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (TAG_IS_TAG_SNAPSHOT (self));
#line 307 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 308 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->sources;
#line 308 "/home/jens/Source/shotwell/src/Tag.vala"
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource))) {
#line 309 "/home/jens/Source/shotwell/src/Tag.vala"
		source_snapshot_notify_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_SNAPSHOT, SourceSnapshot));
#line 9350 "Tag.c"
	}
}


static void
tag_tag_snapshot_class_init (TagTagSnapshotClass * klass)
{
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_tag_snapshot_parent_class = g_type_class_peek_parent (klass);
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	((SourceSnapshotClass *) klass)->finalize = tag_tag_snapshot_finalize;
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	g_type_class_add_private (klass, sizeof (TagTagSnapshotPrivate));
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	((SourceSnapshotClass *) klass)->notify_broken = (void (*) (SourceSnapshot *)) tag_tag_snapshot_real_notify_broken;
#line 9366 "Tag.c"
}


static void
tag_tag_snapshot_instance_init (TagTagSnapshot * self)
{
	GeeHashSet* _tmp0_;
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv = TAG_TAG_SNAPSHOT_GET_PRIVATE (self);
#line 276 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 276 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->sources = _tmp0_;
#line 9380 "Tag.c"
}


static void
tag_tag_snapshot_finalize (SourceSnapshot * obj)
{
	TagTagSnapshot * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshot);
#line 292 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = library_photo_global;
#line 292 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
#line 292 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
#line 293 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = video_global;
#line 293 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 293 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _tag_tag_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
#line 275 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (self->priv->row);
#line 276 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_object_unref0 (self->priv->sources);
#line 274 "/home/jens/Source/shotwell/src/Tag.vala"
	SOURCE_SNAPSHOT_CLASS (tag_tag_snapshot_parent_class)->finalize (obj);
#line 9412 "Tag.c"
}


static GType
tag_tag_snapshot_get_type (void)
{
	static volatile gsize tag_tag_snapshot_type_id__volatile = 0;
	if (g_once_init_enter (&tag_tag_snapshot_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TagTagSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_tag_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagTagSnapshot), 0, (GInstanceInitFunc) tag_tag_snapshot_instance_init, NULL };
		GType tag_tag_snapshot_type_id;
		tag_tag_snapshot_type_id = g_type_register_static (TYPE_SOURCE_SNAPSHOT, "TagTagSnapshot", &g_define_type_info, 0);
		g_once_init_leave (&tag_tag_snapshot_type_id__volatile, tag_tag_snapshot_type_id);
	}
	return tag_tag_snapshot_type_id__volatile;
}


static TagTagProxy*
tag_tag_proxy_construct (GType object_type,
                         Tag* tag)
{
	TagTagProxy* self = NULL;
#line 314 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_TAG (tag), NULL);
#line 315 "/home/jens/Source/shotwell/src/Tag.vala"
	self = (TagTagProxy*) source_proxy_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (tag, TYPE_DATA_SOURCE, DataSource));
#line 314 "/home/jens/Source/shotwell/src/Tag.vala"
	return self;
#line 9441 "Tag.c"
}


static TagTagProxy*
tag_tag_proxy_new (Tag* tag)
{
#line 314 "/home/jens/Source/shotwell/src/Tag.vala"
	return tag_tag_proxy_construct (TAG_TYPE_TAG_PROXY, tag);
#line 9450 "Tag.c"
}


static DataSource*
tag_tag_proxy_real_reconstitute (SourceProxy* base,
                                 gint64 object_id,
                                 SourceSnapshot* snapshot)
{
	TagTagProxy * self;
	DataSource* result = NULL;
	TagRow* _tmp0_;
	TagRow* _tmp1_;
	Tag* _tmp2_;
	DataSource* _tmp3_;
#line 318 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TAG_TYPE_TAG_PROXY, TagTagProxy);
#line 318 "/home/jens/Source/shotwell/src/Tag.vala"
	g_return_val_if_fail (IS_SOURCE_SNAPSHOT (snapshot), NULL);
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = tag_tag_snapshot_get_row (G_TYPE_CHECK_INSTANCE_CAST (snapshot, TAG_TYPE_TAG_SNAPSHOT, TagTagSnapshot));
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp1_ = _tmp0_;
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = tag_reconstitute (object_id, _tmp1_);
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_SOURCE, DataSource);
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (_tmp1_);
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	result = _tmp3_;
#line 319 "/home/jens/Source/shotwell/src/Tag.vala"
	return result;
#line 9483 "Tag.c"
}


static void
tag_tag_proxy_class_init (TagTagProxyClass * klass)
{
#line 313 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_tag_proxy_parent_class = g_type_class_peek_parent (klass);
#line 313 "/home/jens/Source/shotwell/src/Tag.vala"
	((SourceProxyClass *) klass)->reconstitute = (DataSource* (*) (SourceProxy *, gint64, SourceSnapshot*)) tag_tag_proxy_real_reconstitute;
#line 9494 "Tag.c"
}


static void
tag_tag_proxy_instance_init (TagTagProxy * self)
{
}


static GType
tag_tag_proxy_get_type (void)
{
	static volatile gsize tag_tag_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&tag_tag_proxy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TagTagProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_tag_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagTagProxy), 0, (GInstanceInitFunc) tag_tag_proxy_instance_init, NULL };
		GType tag_tag_proxy_type_id;
		tag_tag_proxy_type_id = g_type_register_static (TYPE_SOURCE_PROXY, "TagTagProxy", &g_define_type_info, 0);
		g_once_init_leave (&tag_tag_proxy_type_id__volatile, tag_tag_proxy_type_id);
	}
	return tag_tag_proxy_type_id__volatile;
}


static void
tag_class_init (TagClass * klass)
{
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_parent_class = g_type_class_peek_parent (klass);
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	g_type_class_add_private (klass, sizeof (TagPrivate));
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource *)) tag_real_get_typename;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource *)) tag_real_get_instance_id;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject *)) tag_real_get_name;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject *)) tag_real_to_string;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource *, DataSource*)) tag_real_equals;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataSourceClass *) klass)->save_snapshot = (SourceSnapshot* (*) (DataSource *)) tag_real_save_snapshot;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource *)) tag_real_destroy;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	G_OBJECT_CLASS (klass)->finalize = tag_finalize;
#line 9541 "Tag.c"
}


static void
tag_container_source_interface_init (ContainerSourceIface * iface)
{
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_container_source_parent_iface = g_type_interface_peek_parent (iface);
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->has_links = (gboolean (*) (ContainerSource *)) tag_real_has_links;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->get_backlink = (SourceBacklink* (*) (ContainerSource *)) tag_real_get_backlink;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->break_link = (void (*) (ContainerSource *, DataSource*)) tag_real_break_link;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->break_link_many = (void (*) (ContainerSource *, GeeCollection*)) tag_real_break_link_many;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->establish_link = (void (*) (ContainerSource *, DataSource*)) tag_real_establish_link;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->establish_link_many = (void (*) (ContainerSource *, GeeCollection*)) tag_real_establish_link_many;
#line 9562 "Tag.c"
}


static void
tag_proxyable_interface_init (ProxyableIface * iface)
{
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_proxyable_parent_iface = g_type_interface_peek_parent (iface);
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->get_proxy = (SourceProxy* (*) (Proxyable *)) tag_real_get_proxy;
#line 9573 "Tag.c"
}


static void
tag_indexable_interface_init (IndexableIface * iface)
{
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	tag_indexable_parent_iface = g_type_interface_peek_parent (iface);
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	iface->get_indexable_keywords = (const gchar* (*) (Indexable *)) tag_real_get_indexable_keywords;
#line 9584 "Tag.c"
}


static void
tag_instance_init (Tag * self)
{
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv = TAG_GET_PRIVATE (self);
#line 327 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->name_collation_key = NULL;
#line 328 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->unlinking = FALSE;
#line 329 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->relinking = FALSE;
#line 330 "/home/jens/Source/shotwell/src/Tag.vala"
	self->priv->indexable_keywords = NULL;
#line 9601 "Tag.c"
}


static void
tag_finalize (GObject * obj)
{
	Tag * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	LibraryPhotoSourceCollection* _tmp2_;
	guint _tmp3_;
	VideoSourceCollection* _tmp4_;
	guint _tmp5_;
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAG, Tag);
#line 382 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp0_ = self->priv->media_views;
#line 382 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 382 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tag_on_media_views_contents_altered_data_collection_contents_altered, self);
#line 383 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp2_ = library_photo_global;
#line 383 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 383 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _tag_on_sources_destroyed_source_collection_items_destroyed, self);
#line 384 "/home/jens/Source/shotwell/src/Tag.vala"
	_tmp4_ = video_global;
#line 384 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp5_, NULL, FALSE);
#line 384 "/home/jens/Source/shotwell/src/Tag.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _tag_on_sources_destroyed_source_collection_items_destroyed, self);
#line 325 "/home/jens/Source/shotwell/src/Tag.vala"
	_tag_row_unref0 (self->priv->row);
#line 326 "/home/jens/Source/shotwell/src/Tag.vala"
	_data_collection_unref0 (self->priv->media_views);
#line 327 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (self->priv->name_collation_key);
#line 330 "/home/jens/Source/shotwell/src/Tag.vala"
	_g_free0 (self->priv->indexable_keywords);
#line 269 "/home/jens/Source/shotwell/src/Tag.vala"
	G_OBJECT_CLASS (tag_parent_class)->finalize (obj);
#line 9645 "Tag.c"
}


GType
tag_get_type (void)
{
	static volatile gsize tag_type_id__volatile = 0;
	if (g_once_init_enter (&tag_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tag), 0, (GInstanceInitFunc) tag_instance_init, NULL };
		static const GInterfaceInfo container_source_info = { (GInterfaceInitFunc) tag_container_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo proxyable_info = { (GInterfaceInitFunc) tag_proxyable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) tag_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tag_type_id;
		tag_type_id = g_type_register_static (TYPE_DATA_SOURCE, "Tag", &g_define_type_info, 0);
		g_type_add_interface_static (tag_type_id, TYPE_CONTAINER_SOURCE, &container_source_info);
		g_type_add_interface_static (tag_type_id, TYPE_PROXYABLE, &proxyable_info);
		g_type_add_interface_static (tag_type_id, TYPE_INDEXABLE, &indexable_info);
		g_once_init_leave (&tag_type_id__volatile, tag_type_id);
	}
	return tag_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



