/* Preferences.c generated by valac 0.40.4, the Vala compiler
 * generated from Preferences.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;

#define PREFERENCES_DIALOG_TYPE_PATH_FORMAT (preferences_dialog_path_format_get_type ())
#define PREFERENCES_DIALOG_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat))
#define PREFERENCES_DIALOG_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))

typedef struct _PreferencesDialogPathFormat PreferencesDialogPathFormat;
typedef struct _PreferencesDialogPathFormatClass PreferencesDialogPathFormatClass;

#define PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR (plugins_manifest_widget_mediator_get_type ())
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediator))
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediatorClass))
#define PLUGINS_IS_MANIFEST_WIDGET_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR))
#define PLUGINS_IS_MANIFEST_WIDGET_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR))
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediatorClass))

typedef struct _PluginsManifestWidgetMediator PluginsManifestWidgetMediator;
typedef struct _PluginsManifestWidgetMediatorClass PluginsManifestWidgetMediatorClass;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PreferencesDialogPathFormatPrivate PreferencesDialogPathFormatPrivate;
#define _preferences_dialog_path_format_unref0(var) ((var == NULL) ? NULL : (var = (preferences_dialog_path_format_unref (var), NULL)))
typedef struct _PreferencesDialogParamSpecPathFormat PreferencesDialogParamSpecPathFormat;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkAdjustment* bg_color_adjustment;
	GtkScale* bg_color_slider;
	GtkComboBox* photo_editor_combo;
	GtkComboBox* raw_editor_combo;
	SortedList* external_raw_apps;
	SortedList* external_photo_apps;
	GtkFileChooserButton* library_dir_button;
	GtkComboBoxText* dir_pattern_combo;
	GtkEntry* dir_pattern_entry;
	GtkLabel* dir_pattern_example;
	gboolean allow_closing;
	gchar* lib_dir;
	GeeArrayList* path_formats;
	GDateTime* example_date;
	GtkCheckButton* lowercase;
	PluginsManifestWidgetMediator* plugins_mediator;
	GtkComboBoxText* default_raw_developer_combo;
	GtkCheckButton* autoimport;
	GtkCheckButton* write_metadata;
	GtkLabel* pattern_help;
	GtkNotebook* preferences_notebook;
	GtkRadioButton* transparent_checker_radio;
	GtkRadioButton* transparent_solid_radio;
	GtkColorButton* transparent_solid_color;
	GtkRadioButton* transparent_none_radio;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _PreferencesDialogPathFormat {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreferencesDialogPathFormatPrivate * priv;
	gchar* name;
	gchar* pattern;
};

struct _PreferencesDialogPathFormatClass {
	GTypeClass parent_class;
	void (*finalize) (PreferencesDialogPathFormat *self);
};

struct _PreferencesDialogParamSpecPathFormat {
	GParamSpec parent_instance;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;
static gpointer preferences_dialog_path_format_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType sorted_list_get_type (void) G_GNUC_CONST;
static gpointer preferences_dialog_path_format_ref (gpointer instance);
static void preferences_dialog_path_format_unref (gpointer instance);
static GParamSpec* preferences_dialog_param_spec_path_format (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void preferences_dialog_value_set_path_format (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void preferences_dialog_value_take_path_format (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer preferences_dialog_value_get_path_format (const GValue* value) G_GNUC_UNUSED;
static GType preferences_dialog_path_format_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType plugins_manifest_widget_mediator_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
PluginsManifestWidgetMediator* plugins_manifest_widget_mediator_new (void);
PluginsManifestWidgetMediator* plugins_manifest_widget_mediator_construct (GType object_type);
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
gint resources_use_header_bar (void);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static gboolean preferences_dialog_on_delete (PreferencesDialog* self);
static gboolean _preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                                GdkEventAny* event,
                                                                gpointer self);
static void preferences_dialog_on_close (PreferencesDialog* self);
static void _preferences_dialog_on_close_gtk_dialog_response (GtkDialog* _sender,
                                                       gint response_id,
                                                       gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
void config_facade_get_bg_color (ConfigFacade* self,
                                 GdkRGBA* result);
static void preferences_dialog_on_value_changed (PreferencesDialog* self);
static void _preferences_dialog_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                        gpointer self);
static gboolean preferences_dialog_on_bg_color_reset (PreferencesDialog* self,
                                               GdkEventButton* event);
static gboolean _preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static void preferences_dialog_on_radio_changed (PreferencesDialog* self);
static void _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
static void preferences_dialog_on_color_changed (PreferencesDialog* self);
static void _preferences_dialog_on_color_changed_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                      gpointer self);
gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
gchar* resources_get_help_path (void);
#define RESOURCES_DIR_PATTERN_URI_SYSWIDE "help:shotwell/other-files"
static gboolean preferences_dialog_on_local_pattern_help (PreferencesDialog* self,
                                                   const gchar* ignore);
static gboolean _preferences_dialog_on_local_pattern_help_gtk_label_activate_link (GtkLabel* _sender,
                                                                            const gchar* uri,
                                                                            gpointer self);
static void preferences_dialog_add_to_dir_formats (PreferencesDialog* self,
                                            const gchar* name,
                                            const gchar* pattern);
static void preferences_dialog_on_dir_pattern_combo_changed (PreferencesDialog* self);
static void _preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void preferences_dialog_on_dir_pattern_entry_changed (PreferencesDialog* self);
static void _preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                            gpointer self);
static void preferences_dialog_on_lowercase_toggled (PreferencesDialog* self);
static void _preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
void preferences_dialog_populate_preference_options (PreferencesDialog* self);
static void preferences_dialog_on_photo_editor_changed (PreferencesDialog* self);
static void _preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self);
static void preferences_dialog_on_raw_editor_changed (PreferencesDialog* self);
static void _preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
gchar* raw_developer_get_label (RawDeveloper self);
static void preferences_dialog_set_raw_developer_combo (PreferencesDialog* self,
                                                 RawDeveloper d);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static void preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self);
static void _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                 gpointer self);
static void preferences_dialog_populate_app_combo_box (PreferencesDialog* self,
                                                GtkComboBox* combo_box,
                                                gchar** mime_types,
                                                int mime_types_length1,
                                                const gchar* current_app_executable,
                                                SortedList* * external_apps);
gchar** photo_file_format_get_editable_mime_types (int* result_length1);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
gchar** photo_file_format_get_mime_types (PhotoFileFormat self,
                                          int* result_length1);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static void preferences_dialog_setup_dir_pattern (PreferencesDialog* self,
                                           GtkComboBox* combo_box,
                                           GtkEntry* entry);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_transparent_background_type (ConfigurationFacade* self,
                                                           const gchar* type);
void configuration_facade_set_transparent_background_color (ConfigurationFacade* self,
                                                            const gchar* color_name);
void resources_launch_help (GdkScreen* screen,
                            const gchar* anchor,
                            GError** error);
SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types,
                                                         int mime_types_length1);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
#define RESOURCES_DEFAULT_ICON_SCALE 24
gint sorted_list_index_of (SortedList* self,
                           gconstpointer search);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void preferences_dialog_show_preferences (void);
GFile* app_dirs_get_import_dir (void);
static void preferences_dialog_commit_on_close (PreferencesDialog* self);
void config_facade_commit_bg_color (ConfigFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self,
                                                        gboolean auto_import);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self,
                                                          gboolean commit_metadata);
void app_dirs_set_import_dir (const gchar* path);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self,
                                                        const gchar* s);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self,
                                                 const gchar* s);
static gboolean preferences_dialog_get_allow_closing (PreferencesDialog* self);
static void preferences_dialog_set_background_color (PreferencesDialog* self,
                                              gdouble bg_color_value);
gboolean has_only_key_modifier (GdkModifierType field,
                                GdkModifierType mask);
void parse_color (const gchar* spec,
                  GdkRGBA* result);
#define CONFIG_FACADE_DEFAULT_BG_COLOR "#444"
static void preferences_dialog_set_allow_closing (PreferencesDialog* self,
                                           gboolean allow);
void config_facade_set_bg_color (ConfigFacade* self,
                                 GdkRGBA* color);
static void preferences_dialog_to_grayscale (PreferencesDialog* self,
                                      gdouble color_value,
                                      GdkRGBA* result);
gpointer sorted_list_get_at (SortedList* self,
                             gint index);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self,
                                                  const gchar* external_photo_app);
gchar* desktop_integration_get_app_open_command (GAppInfo* app_info);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self,
                                                const gchar* external_raw_app);
static RawDeveloper preferences_dialog_raw_developer_from_combo (PreferencesDialog* self);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self,
                                                     RawDeveloper d);
static void preferences_dialog_on_current_folder_changed (PreferencesDialog* self);
static gboolean preferences_dialog_real_map_event (GtkWidget* base,
                                            GdkEventAny* event);
static void _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                            gpointer self);
static PreferencesDialogPathFormat* preferences_dialog_path_format_new (const gchar* name,
                                                                 const gchar* pattern);
static PreferencesDialogPathFormat* preferences_dialog_path_format_construct (GType object_type,
                                                                       const gchar* name,
                                                                       const gchar* pattern);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self,
                                                       gboolean b);
static void preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj);
static void preferences_dialog_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean
_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                       GdkEventAny* event,
                                                       gpointer self)
{
	gboolean result;
	result = preferences_dialog_on_delete ((PreferencesDialog*) self);
#line 72 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 399 "Preferences.c"
}


static void
_preferences_dialog_on_close_gtk_dialog_response (GtkDialog* _sender,
                                                  gint response_id,
                                                  gpointer self)
{
#line 73 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_close ((PreferencesDialog*) self);
#line 410 "Preferences.c"
}


static void
_preferences_dialog_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                   gpointer self)
{
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_value_changed ((PreferencesDialog*) self);
#line 420 "Preferences.c"
}


static gboolean
_preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = preferences_dialog_on_bg_color_reset ((PreferencesDialog*) self, event);
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 433 "Preferences.c"
}


static void
_preferences_dialog_on_radio_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_radio_changed ((PreferencesDialog*) self);
#line 443 "Preferences.c"
}


static void
_preferences_dialog_on_color_changed_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                 gpointer self)
{
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_color_changed ((PreferencesDialog*) self);
#line 453 "Preferences.c"
}


static gboolean
_preferences_dialog_on_local_pattern_help_gtk_label_activate_link (GtkLabel* _sender,
                                                                   const gchar* uri,
                                                                   gpointer self)
{
	gboolean result;
	result = preferences_dialog_on_local_pattern_help ((PreferencesDialog*) self, uri);
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 466 "Preferences.c"
}


static void
_preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_combo_changed ((PreferencesDialog*) self);
#line 476 "Preferences.c"
}


static void
_preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self)
{
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_entry_changed ((PreferencesDialog*) self);
#line 486 "Preferences.c"
}


static void
_preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_lowercase_toggled ((PreferencesDialog*) self);
#line 496 "Preferences.c"
}


static void
_preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self)
{
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_photo_editor_changed ((PreferencesDialog*) self);
#line 506 "Preferences.c"
}


static void
_preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self)
{
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_raw_editor_changed ((PreferencesDialog*) self);
#line 516 "Preferences.c"
}


static void
_preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self)
{
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_default_raw_developer_changed ((PreferencesDialog*) self);
#line 526 "Preferences.c"
}


static PreferencesDialog*
preferences_dialog_construct (GType object_type)
{
	PreferencesDialog * self = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GdkWindow* _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkScale* _tmp12_;
	GtkRadioButton* _tmp13_;
	GtkRadioButton* _tmp14_;
	GtkRadioButton* _tmp15_;
	GtkRadioButton* _tmp16_;
	GtkColorButton* _tmp17_;
	GdkRGBA color = {0};
	ConfigFacade* _tmp18_;
	ConfigFacade* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkColorButton* _tmp22_;
	GdkRGBA _tmp23_;
	GtkColorButton* _tmp24_;
	ConfigFacade* _tmp25_;
	ConfigFacade* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GQuark _tmp31_ = 0U;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	static GQuark _tmp30_label0 = 0;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	static GQuark _tmp30_label1 = 0;
#line 570 "Preferences.c"
	gchar* help_path = NULL;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GtkComboBoxText* _tmp54_;
	GtkEntry* _tmp55_;
	GtkCheckButton* _tmp56_;
	GtkNotebook* _tmp57_;
	GtkWidget* _tmp58_;
	PluginsManifestWidgetMediator* _tmp59_;
	GtkComboBox* _tmp60_;
	GtkComboBox* _tmp61_;
	GtkCheckButton* _tmp62_;
	ConfigFacade* _tmp63_;
	ConfigFacade* _tmp64_;
	GtkCheckButton* _tmp65_;
	ConfigFacade* _tmp66_;
	ConfigFacade* _tmp67_;
	GtkComboBoxText* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GtkComboBoxText* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	ConfigFacade* _tmp74_;
	ConfigFacade* _tmp75_;
	GtkComboBoxText* _tmp76_;
#line 68 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = app_window_get_instance ();
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_widget_get_parent_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_set_parent_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp2_);
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = app_window_get_instance ();
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = _tmp3_;
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp4_);
#line 72 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _preferences_dialog_on_delete_gtk_widget_delete_event, self, 0);
#line 73 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) _preferences_dialog_on_close_gtk_dialog_response, self, 0);
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = self->priv->bg_color_adjustment;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = self->priv->bg_color_adjustment;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = config_facade_get_instance ();
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = _tmp7_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_get_bg_color (_tmp8_, &_tmp9_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = _tmp9_.red;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_adjustment_set_value (_tmp5_, gtk_adjustment_get_upper (_tmp6_) - (_tmp10_ * 65535.0));
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp8_);
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = self->priv->bg_color_adjustment;
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp11_, "value-changed", (GCallback) _preferences_dialog_on_value_changed_gtk_adjustment_value_changed, self, 0);
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = self->priv->bg_color_slider;
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event, self, 0);
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = self->priv->transparent_checker_radio;
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 82 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = self->priv->transparent_solid_radio;
#line 82 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 83 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = self->priv->transparent_none_radio;
#line 83 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = self->priv->transparent_solid_radio;
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = self->priv->transparent_solid_color;
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "active", G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, G_TYPE_OBJECT, GObject), "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 89 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = config_facade_get_instance ();
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp19_ = _tmp18_;
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp20_ = configuration_facade_get_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp21_ = _tmp20_;
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gdk_rgba_parse (&color, _tmp21_);
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp21_);
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp19_);
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp22_ = self->priv->transparent_solid_color;
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp23_ = color;
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_color_chooser_set_rgba (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_color_chooser_get_type ()) ? ((GtkColorChooser*) _tmp22_) : NULL, &_tmp23_);
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp24_ = self->priv->transparent_solid_color;
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp24_, "color-set", (GCallback) _preferences_dialog_on_color_changed_gtk_color_button_color_set, self, 0);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp25_ = config_facade_get_instance ();
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp26_ = _tmp25_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp27_ = configuration_facade_get_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp28_ = _tmp27_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp26_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp29_ = _tmp28_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp31_ = (NULL == _tmp29_) ? 0 : g_quark_from_string (_tmp29_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_free (_tmp29_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp31_ == ((0 != _tmp30_label0) ? _tmp30_label0 : (_tmp30_label0 = g_quark_from_static_string ("checkered")))) {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 715 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp32_;
#line 96 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp32_ = self->priv->transparent_checker_radio;
#line 96 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 97 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 725 "Preferences.c"
			}
		}
	} else if (_tmp31_ == ((0 != _tmp30_label1) ? _tmp30_label1 : (_tmp30_label1 = g_quark_from_static_string ("solid")))) {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 731 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp33_;
#line 99 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp33_ = self->priv->transparent_solid_radio;
#line 99 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 100 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 741 "Preferences.c"
			}
		}
	} else {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 747 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp34_;
#line 102 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp34_ = self->priv->transparent_none_radio;
#line 102 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 103 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 757 "Preferences.c"
			}
		}
	}
#line 111 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp35_ = resources_get_help_path ();
#line 111 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	help_path = _tmp35_;
#line 113 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp36_ = help_path;
#line 113 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp36_ == NULL) {
#line 769 "Preferences.c"
		GtkLabel* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp37_ = self->priv->pattern_help;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp38_ = g_strconcat ("<a href=\"" RESOURCES_DIR_PATTERN_URI_SYSWIDE "\">", _ ("(Help)"), NULL);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp39_ = _tmp38_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp40_ = g_strconcat (_tmp39_, "</a>", NULL);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp41_ = _tmp40_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_markup (_tmp37_, _tmp41_);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp41_);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp39_);
#line 791 "Preferences.c"
	} else {
		GtkLabel* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		GtkLabel* _tmp47_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp42_ = self->priv->pattern_help;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp43_ = g_strconcat ("<a href=\"dummy:\">", _ ("(Help)"), NULL);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp44_ = _tmp43_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp45_ = g_strconcat (_tmp44_, "</a>", NULL);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp46_ = _tmp45_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_markup (_tmp42_, _tmp46_);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp46_);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp44_);
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp47_ = self->priv->pattern_help;
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_signal_connect_object (_tmp47_, "activate-link", (GCallback) _preferences_dialog_on_local_pattern_help_gtk_label_activate_link, self, 0);
#line 819 "Preferences.c"
	}
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp48_ = g_strdup_printf (_ ("Year%sMonth%sDay"), G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S);
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp49_ = _tmp48_;
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp49_, "%Y" G_DIR_SEPARATOR_S "%m" G_DIR_SEPARATOR_S "%d");
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp49_);
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp50_ = g_strdup_printf (_ ("Year%sMonth"), G_DIR_SEPARATOR_S);
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp51_ = _tmp50_;
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp51_, "%Y" G_DIR_SEPARATOR_S "%m");
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp51_);
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp52_ = g_strdup_printf (_ ("Year%sMonth-Day"), G_DIR_SEPARATOR_S);
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp53_ = _tmp52_;
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp53_, "%Y" G_DIR_SEPARATOR_S "%m-%d");
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp53_);
#line 129 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _ ("Year-Month-Day"), "%Y-%m-%d");
#line 130 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _ ("Custom"), NULL);
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp54_ = self->priv->dir_pattern_combo;
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed, self, 0);
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp55_ = self->priv->dir_pattern_entry;
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed, self, 0);
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp56_ = self->priv->lowercase;
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled, self, 0);
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp57_ = self->priv->preferences_notebook;
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp58_ = gtk_notebook_get_nth_page (_tmp57_, 2);
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp59_ = self->priv->plugins_mediator;
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp58_) : NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
#line 138 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_preference_options (self);
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp60_ = self->priv->photo_editor_combo;
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp60_, "changed", (GCallback) _preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed, self, 0);
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp61_ = self->priv->raw_editor_combo;
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp61_, "changed", (GCallback) _preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed, self, 0);
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp62_ = self->priv->autoimport;
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp63_ = config_facade_get_instance ();
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp64_ = _tmp63_;
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_toggle_button_get_type (), GtkToggleButton), configuration_facade_get_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp64_);
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp65_ = self->priv->write_metadata;
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp66_ = config_facade_get_instance ();
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp67_ = _tmp66_;
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_toggle_button_get_type (), GtkToggleButton), configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp67_);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp68_ = self->priv->default_raw_developer_combo;
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp69_ = raw_developer_get_label (RAW_DEVELOPER_CAMERA);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp70_ = _tmp69_;
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp68_, _tmp70_);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp70_);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp71_ = self->priv->default_raw_developer_combo;
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp72_ = raw_developer_get_label (RAW_DEVELOPER_SHOTWELL);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp73_ = _tmp72_;
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp71_, _tmp73_);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp73_);
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp74_ = config_facade_get_instance ();
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp75_ = _tmp74_;
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_set_raw_developer_combo (self, configuration_facade_get_default_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp75_);
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp76_ = self->priv->default_raw_developer_combo;
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed, self, 0);
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (help_path);
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self;
#line 935 "Preferences.c"
}


static PreferencesDialog*
preferences_dialog_new (void)
{
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
#line 944 "Preferences.c"
}


void
preferences_dialog_populate_preference_options (PreferencesDialog* self)
{
	GtkComboBox* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SortedList* _tmp8_ = NULL;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ConfigFacade* _tmp13_;
	ConfigFacade* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	SortedList* _tmp17_ = NULL;
	GtkComboBoxText* _tmp18_;
	GtkEntry* _tmp19_;
	GtkCheckButton* _tmp20_;
	ConfigFacade* _tmp21_;
	ConfigFacade* _tmp22_;
#line 153 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->photo_editor_combo;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = photo_file_format_get_editable_mime_types (&_tmp1_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3__length1 = _tmp1_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = config_facade_get_instance ();
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = configuration_facade_get_external_photo_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = _tmp6_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_app_combo_box (self, _tmp0_, _tmp3_, _tmp1_, _tmp7_, &_tmp8_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_photo_apps);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->external_photo_apps = _tmp8_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp7_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp5_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->raw_editor_combo;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = photo_file_format_get_mime_types (PHOTO_FILE_FORMAT_RAW, &_tmp10_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = _tmp11_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12__length1 = _tmp10_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = config_facade_get_instance ();
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = _tmp13_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = configuration_facade_get_external_raw_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = _tmp15_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_app_combo_box (self, _tmp9_, _tmp12_, _tmp10_, _tmp16_, &_tmp17_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_raw_apps);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->external_raw_apps = _tmp17_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp16_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp14_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = self->priv->dir_pattern_combo;
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp19_ = self->priv->dir_pattern_entry;
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_setup_dir_pattern (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_combo_box_get_type (), GtkComboBox), _tmp19_);
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp20_ = self->priv->lowercase;
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp21_ = config_facade_get_instance ();
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp22_ = _tmp21_;
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_toggle_button_get_type (), GtkToggleButton), configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)));
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp22_);
#line 1050 "Preferences.c"
}


static void
preferences_dialog_on_radio_changed (PreferencesDialog* self)
{
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	GtkRadioButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 166 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 166 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->transparent_checker_radio;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp3_) {
#line 1076 "Preferences.c"
		ConfigFacade* _tmp4_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = config;
#line 169 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "checkered");
#line 1082 "Preferences.c"
	} else {
		GtkRadioButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = self->priv->transparent_solid_radio;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = _tmp6_;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (_tmp7_) {
#line 1095 "Preferences.c"
			ConfigFacade* _tmp8_;
#line 171 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp8_ = config;
#line 171 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "solid");
#line 1101 "Preferences.c"
		} else {
			ConfigFacade* _tmp9_;
#line 173 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp9_ = config;
#line 173 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "none");
#line 1108 "Preferences.c"
		}
	}
#line 165 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (config);
#line 1113 "Preferences.c"
}


static void
preferences_dialog_on_color_changed (PreferencesDialog* self)
{
	gchar* color = NULL;
	GtkColorButton* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
#line 177 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->transparent_solid_color;
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_color_chooser_get_rgba (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_color_chooser_get_type ()) ? ((GtkColorChooser*) _tmp0_) : NULL, &_tmp1_);
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = _tmp1_;
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gdk_rgba_to_string (&_tmp2_);
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color = _tmp3_;
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = config_facade_get_instance ();
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), color);
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp5_);
#line 177 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (color);
#line 1149 "Preferences.c"
}


static gboolean
preferences_dialog_on_local_pattern_help (PreferencesDialog* self,
                                          const gchar* ignore)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 184 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (ignore != NULL, FALSE);
#line 1163 "Preferences.c"
	{
		AppWindow* _tmp0_;
		AppWindow* _tmp1_;
		GdkScreen* _tmp2_;
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = app_window_get_instance ();
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = _tmp0_;
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp2_ = gtk_window_get_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		resources_launch_help (_tmp2_, "other-files.page", &_inner_error_);
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp1_);
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1180 "Preferences.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		e = _inner_error_;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_inner_error_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp3_ = e;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = _tmp3_->message;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_message ("Preferences.vala:188: Unable to launch help: %s", _tmp4_);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_error_free0 (e);
#line 1202 "Preferences.c"
	}
	__finally22:
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1207 "Preferences.c"
		gboolean _tmp5_ = FALSE;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_clear_error (&_inner_error_);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return _tmp5_;
#line 1215 "Preferences.c"
	}
#line 190 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 1221 "Preferences.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self ? g_object_ref (self) : NULL;
#line 1230 "Preferences.c"
}


static void
preferences_dialog_populate_app_combo_box (PreferencesDialog* self,
                                           GtkComboBox* combo_box,
                                           gchar** mime_types,
                                           int mime_types_length1,
                                           const gchar* current_app_executable,
                                           SortedList* * external_apps)
{
	SortedList* _vala_external_apps = NULL;
	SortedList* _tmp0_;
	SortedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp4_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp5_;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererPixbuf* _tmp8_;
	GtkCellRendererText* _tmp9_;
	GtkListStore* combo_store = NULL;
	GtkListStore* _tmp10_;
	GtkTreeIter iter = {0};
	gint current_app = 0;
	GtkListStore* _tmp57_;
	gint _tmp58_;
	GError * _inner_error_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_COMBO_BOX (combo_box));
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (current_app_executable != NULL);
#line 196 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_vala_assert (mime_types_length1 != 0, "mime_types.length != 0");
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = desktop_integration_get_apps_for_mime_types (mime_types, mime_types_length1);
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_vala_external_apps);
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_vala_external_apps = _tmp0_;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _vala_external_apps;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp3_ == 0) {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (external_apps) {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			*external_apps = _vala_external_apps;
#line 1288 "Preferences.c"
		} else {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (_vala_external_apps);
#line 1292 "Preferences.c"
		}
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return;
#line 1296 "Preferences.c"
	}
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp4_);
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pixbuf_renderer = _tmp4_;
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp5_);
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	text_renderer = _tmp5_;
#line 205 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_clear (G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_cell_layout_get_type (), GtkCellLayout));
#line 206 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = pixbuf_renderer;
#line 206 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
#line 207 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = text_renderer;
#line 207 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
#line 208 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = pixbuf_renderer;
#line 208 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_cell_renderer_get_type (), GtkCellRenderer), "pixbuf", 0);
#line 209 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = text_renderer;
#line 209 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_cell_renderer_get_type (), GtkCellRenderer), "text", 1);
#line 212 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = gtk_list_store_new (2, gdk_pixbuf_get_type (), G_TYPE_STRING, -1);
#line 212 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	combo_store = _tmp10_;
#line 215 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	current_app = -1;
#line 1334 "Preferences.c"
	{
		GeeIterator* _app_it = NULL;
		SortedList* _tmp11_;
		GeeIterator* _tmp12_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = _vala_external_apps;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_app_it = _tmp12_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		while (TRUE) {
#line 1347 "Preferences.c"
			GeeIterator* _tmp13_;
			GAppInfo* app = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			GtkListStore* _tmp16_;
			GtkTreeIter _tmp17_ = {0};
			GIcon* app_icon = NULL;
			GAppInfo* _tmp18_;
			GIcon* _tmp19_;
			GIcon* _tmp20_;
			GtkListStore* _tmp48_;
			GtkTreeIter _tmp49_;
			GAppInfo* _tmp50_;
			const gchar* _tmp51_;
			GValue _tmp52_ = {0};
			GAppInfo* _tmp53_;
			const gchar* _tmp54_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp13_ = _app_it;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (!gee_iterator_next (_tmp13_)) {
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 1371 "Preferences.c"
			}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp14_ = _app_it;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp15_ = gee_iterator_get (_tmp14_);
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			app = (GAppInfo*) _tmp15_;
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp16_ = combo_store;
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_list_store_append (_tmp16_, &_tmp17_);
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			iter = _tmp17_;
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp18_ = app;
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp19_ = g_app_info_get_icon (_tmp18_);
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			app_icon = _tmp20_;
#line 1393 "Preferences.c"
			{
				GIcon* _tmp21_;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp21_ = app_icon;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, g_file_icon_get_type ())) {
#line 1400 "Preferences.c"
					GdkPixbuf* _tmp22_ = NULL;
					GIcon* _tmp23_;
					GFile* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					GdkPixbuf* _tmp27_;
					GdkPixbuf* _tmp28_;
					GtkListStore* _tmp29_;
					GtkTreeIter _tmp30_;
					GdkPixbuf* _tmp31_;
					GValue _tmp32_ = {0};
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp23_ = app_icon;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp24_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_file_icon_get_type (), GFileIcon));
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp25_ = g_file_get_path (_tmp24_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp26_ = _tmp25_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp27_ = gdk_pixbuf_new_from_file (_tmp26_, &_inner_error_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp28_ = _tmp27_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_g_free0 (_tmp26_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp22_ = _tmp28_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1430 "Preferences.c"
						goto __catch23_g_error;
					}
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp29_ = combo_store;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp30_ = iter;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp31_ = scale_pixbuf (_tmp22_, RESOURCES_DEFAULT_ICON_SCALE, GDK_INTERP_BILINEAR, FALSE);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					g_value_init (&_tmp32_, gdk_pixbuf_get_type ());
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					g_value_take_object (&_tmp32_, _tmp31_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					gtk_list_store_set_value (_tmp29_, &_tmp30_, 0, &_tmp32_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					G_IS_VALUE (&_tmp32_) ? (g_value_unset (&_tmp32_), NULL) : NULL;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_g_object_unref0 (_tmp22_);
#line 1449 "Preferences.c"
				} else {
					GIcon* _tmp33_;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp33_ = app_icon;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_themed_icon_get_type ())) {
#line 1456 "Preferences.c"
						GdkPixbuf* icon_pixbuf = NULL;
						GtkIconTheme* _tmp34_;
						GIcon* _tmp35_;
						gchar** _tmp36_;
						gchar** _tmp37_;
						const gchar* _tmp38_;
						GdkPixbuf* _tmp39_;
						GtkListStore* _tmp40_;
						GtkTreeIter _tmp41_;
						GdkPixbuf* _tmp42_;
						GValue _tmp43_ = {0};
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp34_ = gtk_icon_theme_get_default ();
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp35_ = app_icon;
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp37_ = _tmp36_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_themed_icon_get_type (), GThemedIcon));
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp38_ = _tmp37_[0];
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp39_ = gtk_icon_theme_load_icon (_tmp34_, _tmp38_, RESOURCES_DEFAULT_ICON_SCALE, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						icon_pixbuf = _tmp39_;
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1482 "Preferences.c"
							goto __catch23_g_error;
						}
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp40_ = combo_store;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp41_ = iter;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp42_ = icon_pixbuf;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						g_value_init (&_tmp43_, gdk_pixbuf_get_type ());
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						g_value_set_object (&_tmp43_, _tmp42_);
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						gtk_list_store_set_value (_tmp40_, &_tmp41_, 0, &_tmp43_);
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						G_IS_VALUE (&_tmp43_) ? (g_value_unset (&_tmp43_), NULL) : NULL;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_g_object_unref0 (icon_pixbuf);
#line 1501 "Preferences.c"
					}
				}
			}
			goto __finally23;
			__catch23_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_error_ = _inner_error_;
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_inner_error_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp44_ = _error_;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp45_ = _tmp44_->message;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp46_ = g_strconcat ("Error loading icon pixbuf: ", _tmp45_, NULL);
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp47_ = _tmp46_;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_warning ("Preferences.vala:234: %s", _tmp47_);
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_free0 (_tmp47_);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_error_free0 (_error_);
#line 1531 "Preferences.c"
			}
			__finally23:
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (app_icon);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (app);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (_app_it);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (combo_store);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (text_renderer);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (pixbuf_renderer);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_clear_error (&_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				return;
#line 1554 "Preferences.c"
			}
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp48_ = combo_store;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp49_ = iter;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp50_ = app;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp51_ = g_app_info_get_name (_tmp50_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			g_value_init (&_tmp52_, G_TYPE_STRING);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			g_value_set_string (&_tmp52_, _tmp51_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_list_store_set_value (_tmp48_, &_tmp49_, 1, &_tmp52_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			G_IS_VALUE (&_tmp52_) ? (g_value_unset (&_tmp52_), NULL) : NULL;
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp53_ = app;
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp54_ = g_app_info_get_commandline (_tmp53_);
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (g_strcmp0 (_tmp54_, current_app_executable) == 0) {
#line 1578 "Preferences.c"
				SortedList* _tmp55_;
				GAppInfo* _tmp56_;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp55_ = _vala_external_apps;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp56_ = app;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				current_app = sorted_list_index_of (_tmp55_, _tmp56_);
#line 1587 "Preferences.c"
			}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (app_icon);
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (app);
#line 1593 "Preferences.c"
		}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_app_it);
#line 1597 "Preferences.c"
	}
#line 245 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp57_ = combo_store;
#line 245 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_set_model (combo_box, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_tree_model_get_type (), GtkTreeModel));
#line 247 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp58_ = current_app;
#line 247 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp58_ != -1) {
#line 1607 "Preferences.c"
		gint _tmp59_;
#line 248 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp59_ = current_app;
#line 248 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (combo_box, _tmp59_);
#line 1613 "Preferences.c"
	}
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (combo_store);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (text_renderer);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (external_apps) {
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*external_apps = _vala_external_apps;
#line 1625 "Preferences.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_vala_external_apps);
#line 1629 "Preferences.c"
	}
}


static void
preferences_dialog_setup_dir_pattern (PreferencesDialog* self,
                                      GtkComboBox* combo_box,
                                      GtkEntry* entry)
{
	gchar* pattern = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean found = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp29_;
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_COMBO_BOX (combo_box));
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_ENTRY (entry));
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = configuration_facade_get_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pattern = _tmp3_;
#line 253 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	found = FALSE;
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = pattern;
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL != _tmp4_) {
#line 1671 "Preferences.c"
		gint i = 0;
#line 256 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		i = 0;
#line 1675 "Preferences.c"
		{
			GeeArrayList* _pf_list = NULL;
			GeeArrayList* _tmp5_;
			GeeArrayList* _tmp6_;
			gint _pf_size = 0;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _pf_index = 0;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp5_ = self->priv->path_formats;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp6_ = _g_object_ref0 (_tmp5_);
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_list = _tmp6_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp7_ = _pf_list;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp9_ = _tmp8_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_size = _tmp9_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_index = -1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			while (TRUE) {
#line 1703 "Preferences.c"
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				PreferencesDialogPathFormat* pf = NULL;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				PreferencesDialogPathFormat* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp20_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp10_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_pf_index = _tmp10_ + 1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp11_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp12_ = _pf_size;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (!(_tmp11_ < _tmp12_)) {
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					break;
#line 1727 "Preferences.c"
				}
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp13_ = _pf_list;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp14_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp15_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp14_);
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				pf = (PreferencesDialogPathFormat*) _tmp15_;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp16_ = pf;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp17_ = _tmp16_->pattern;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp18_ = pattern;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 1745 "Preferences.c"
					gint _tmp19_;
#line 259 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp19_ = i;
#line 259 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					gtk_combo_box_set_active (combo_box, _tmp19_);
#line 260 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					found = TRUE;
#line 261 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_preferences_dialog_path_format_unref0 (pf);
#line 261 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					break;
#line 1757 "Preferences.c"
				}
#line 263 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp20_ = i;
#line 263 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				i = _tmp20_ + 1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_preferences_dialog_path_format_unref0 (pf);
#line 1765 "Preferences.c"
			}
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (_pf_list);
#line 1769 "Preferences.c"
		}
	} else {
		gchar* s = NULL;
		ConfigFacade* _tmp21_;
		ConfigFacade* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp21_ = config_facade_get_instance ();
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp22_ = _tmp21_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp23_ = configuration_facade_get_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp24_ = _tmp23_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp22_);
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		s = _tmp24_;
#line 268 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp25_ = s;
#line 268 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (!is_string_empty (_tmp25_)) {
#line 1794 "Preferences.c"
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp26_ = self->priv->path_formats;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp27_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp28_ = _tmp27_;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_combo_box_set_active (combo_box, _tmp28_ - 1);
#line 270 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			found = TRUE;
#line 1808 "Preferences.c"
		}
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (s);
#line 1812 "Preferences.c"
	}
#line 274 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp29_ = found;
#line 274 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!_tmp29_) {
#line 275 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (combo_box, 0);
#line 1820 "Preferences.c"
	}
#line 278 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_combo_changed (self);
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (pattern);
#line 1826 "Preferences.c"
}


void
preferences_dialog_show_preferences (void)
{
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp2_;
	PreferencesDialog* _tmp3_;
	PreferencesDialog* _tmp4_;
	GtkFileChooserButton* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PreferencesDialog* _tmp10_;
#line 282 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = preferences_dialog_preferences_dialog;
#line 282 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp0_ == NULL) {
#line 1847 "Preferences.c"
		PreferencesDialog* _tmp1_;
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = preferences_dialog_new ();
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_ref_sink (_tmp1_);
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (preferences_dialog_preferences_dialog);
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_preferences_dialog = _tmp1_;
#line 1857 "Preferences.c"
	}
#line 285 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = preferences_dialog_preferences_dialog;
#line 285 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_preference_options (_tmp2_);
#line 286 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = preferences_dialog_preferences_dialog;
#line 286 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = preferences_dialog_preferences_dialog;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_->priv->library_dir_button;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = app_dirs_get_import_dir ();
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = _tmp8_;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp9_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp9_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp7_);
#line 291 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = preferences_dialog_preferences_dialog;
#line 291 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
#line 1889 "Preferences.c"
}


static void
preferences_dialog_commit_on_close (PreferencesDialog* self)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	GtkCheckButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	GtkCheckButton* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	PreferencesDialogPathFormat* pf = NULL;
	GeeArrayList* _tmp14_;
	GtkComboBoxText* _tmp15_;
	gpointer _tmp16_;
	PreferencesDialogPathFormat* _tmp17_;
	const gchar* _tmp18_;
#line 296 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_commit_bg_color (_tmp1_);
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = config_facade_get_instance ();
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = self->priv->autoimport;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = _tmp5_;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp6_);
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp3_);
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = config_facade_get_instance ();
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = _tmp7_;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->write_metadata;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = _tmp10_;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp11_);
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp8_);
#line 301 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = self->priv->lib_dir;
#line 301 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp12_ != NULL) {
#line 1957 "Preferences.c"
		const gchar* _tmp13_;
#line 302 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->lib_dir;
#line 302 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		app_dirs_set_import_dir (_tmp13_);
#line 1963 "Preferences.c"
	}
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = self->priv->path_formats;
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = self->priv->dir_pattern_combo;
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox)));
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = (PreferencesDialogPathFormat*) _tmp16_;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = pf;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = _tmp17_->pattern;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL == _tmp18_) {
#line 1979 "Preferences.c"
		ConfigFacade* _tmp19_;
		ConfigFacade* _tmp20_;
		GtkEntry* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		ConfigFacade* _tmp24_;
		ConfigFacade* _tmp25_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp19_ = config_facade_get_instance ();
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp20_ = _tmp19_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp21_ = self->priv->dir_pattern_entry;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp22_ = gtk_entry_get_text (_tmp21_);
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp23_ = _tmp22_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp23_);
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp20_);
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp24_ = config_facade_get_instance ();
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp25_ = _tmp24_;
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), NULL);
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp25_);
#line 2009 "Preferences.c"
	} else {
		ConfigFacade* _tmp26_;
		ConfigFacade* _tmp27_;
		PreferencesDialogPathFormat* _tmp28_;
		const gchar* _tmp29_;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp26_ = config_facade_get_instance ();
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp27_ = _tmp26_;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp28_ = pf;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp29_ = _tmp28_->pattern;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp29_);
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp27_);
#line 2027 "Preferences.c"
	}
#line 296 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 2031 "Preferences.c"
}


static gboolean
preferences_dialog_on_delete (PreferencesDialog* self)
{
	gboolean result = FALSE;
#line 313 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 314 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!preferences_dialog_get_allow_closing (self)) {
#line 315 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = TRUE;
#line 315 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 2047 "Preferences.c"
	}
#line 317 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_commit_on_close (self);
#line 318 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = gtk_widget_hide_on_delete (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 318 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2055 "Preferences.c"
}


static void
preferences_dialog_on_close (PreferencesDialog* self)
{
#line 321 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 322 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!preferences_dialog_get_allow_closing (self)) {
#line 323 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return;
#line 2068 "Preferences.c"
	}
#line 325 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 326 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_commit_on_close (self);
#line 2074 "Preferences.c"
}


static void
preferences_dialog_on_value_changed (PreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
#line 329 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->bg_color_adjustment;
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->bg_color_adjustment;
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_set_background_color (self, ((gdouble) (gtk_adjustment_get_upper (_tmp0_) - gtk_adjustment_get_value (_tmp1_))) / 65535.0);
#line 2091 "Preferences.c"
}


static gboolean
preferences_dialog_on_bg_color_reset (PreferencesDialog* self,
                                      GdkEventButton* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
#line 334 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 334 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = event->button;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp2_ == ((guint) 1)) {
#line 2111 "Preferences.c"
		GdkEventType _tmp3_;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp3_ = event->type;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = _tmp3_ == GDK_BUTTON_PRESS;
#line 2117 "Preferences.c"
	} else {
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = FALSE;
#line 2121 "Preferences.c"
	}
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp1_) {
#line 2125 "Preferences.c"
		GdkModifierType _tmp4_;
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = event->state;
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = has_only_key_modifier (_tmp4_, GDK_CONTROL_MASK);
#line 2131 "Preferences.c"
	} else {
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = FALSE;
#line 2135 "Preferences.c"
	}
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp0_) {
#line 2139 "Preferences.c"
		GtkScale* _tmp5_;
		GtkAdjustment* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		gdouble _tmp8_;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = self->priv->bg_color_slider;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = self->priv->bg_color_adjustment;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		parse_color (CONFIG_FACADE_DEFAULT_BG_COLOR, &_tmp7_);
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = _tmp7_.red;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_range_get_type (), GtkRange), gtk_adjustment_get_upper (_tmp6_) - (_tmp8_ * 65536.0f));
#line 340 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_on_value_changed (self);
#line 342 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = TRUE;
#line 342 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 2160 "Preferences.c"
	}
#line 345 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = FALSE;
#line 345 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2166 "Preferences.c"
}


static void
preferences_dialog_on_dir_pattern_combo_changed (PreferencesDialog* self)
{
	PreferencesDialogPathFormat* pf = NULL;
	GeeArrayList* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gpointer _tmp2_;
	PreferencesDialogPathFormat* _tmp3_;
	const gchar* _tmp4_;
#line 348 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->path_formats;
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->dir_pattern_combo;
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox)));
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = (PreferencesDialogPathFormat*) _tmp2_;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = pf;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = _tmp3_->pattern;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL == _tmp4_) {
#line 2195 "Preferences.c"
		gchar* dir_pattern = NULL;
		ConfigFacade* _tmp5_;
		ConfigFacade* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkEntry* _tmp11_;
		const gchar* _tmp12_;
		GtkEntry* _tmp13_;
		GtkEntry* _tmp14_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = config_facade_get_instance ();
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = _tmp5_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = configuration_facade_get_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = _tmp7_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp6_);
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dir_pattern = _tmp8_;
#line 353 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = dir_pattern;
#line 353 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (is_string_empty (_tmp9_)) {
#line 2222 "Preferences.c"
			gchar* _tmp10_;
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp10_ = g_strdup ("");
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_free0 (dir_pattern);
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			dir_pattern = _tmp10_;
#line 2230 "Preferences.c"
		}
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = self->priv->dir_pattern_entry;
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp12_ = dir_pattern;
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_text (_tmp11_, _tmp12_);
#line 356 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->dir_pattern_entry;
#line 356 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_set (_tmp13_, "editable", TRUE, NULL);
#line 357 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp14_ = self->priv->dir_pattern_entry;
#line 357 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (dir_pattern);
#line 2248 "Preferences.c"
	} else {
		GtkEntry* _tmp15_;
		PreferencesDialogPathFormat* _tmp16_;
		const gchar* _tmp17_;
		GtkEntry* _tmp18_;
		GtkEntry* _tmp19_;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp15_ = self->priv->dir_pattern_entry;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp16_ = pf;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp17_ = _tmp16_->pattern;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_text (_tmp15_, _tmp17_);
#line 360 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp18_ = self->priv->dir_pattern_entry;
#line 360 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_set (_tmp18_, "editable", FALSE, NULL);
#line 361 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp19_ = self->priv->dir_pattern_entry;
#line 361 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 2271 "Preferences.c"
	}
#line 348 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 2275 "Preferences.c"
}


static void
preferences_dialog_on_dir_pattern_entry_changed (PreferencesDialog* self)
{
	gchar* example = NULL;
	GDateTime* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
#line 365 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->example_date;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->dir_pattern_entry;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = g_date_time_format (_tmp0_, _tmp3_);
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	example = _tmp4_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = example;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (is_string_empty (_tmp6_)) {
#line 2308 "Preferences.c"
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = self->priv->dir_pattern_entry;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = gtk_entry_get_text (_tmp7_);
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = _tmp8_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = !is_string_empty (_tmp9_);
#line 2320 "Preferences.c"
	} else {
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = FALSE;
#line 2324 "Preferences.c"
	}
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp5_) {
#line 2328 "Preferences.c"
		GtkLabel* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
#line 369 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = self->priv->dir_pattern_example;
#line 369 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_text (_tmp10_, _ ("Invalid pattern"));
#line 370 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = self->priv->dir_pattern_entry;
#line 370 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_from_icon_name (_tmp11_, GTK_ENTRY_ICON_SECONDARY, "dialog-error");
#line 371 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp12_ = self->priv->dir_pattern_entry;
#line 371 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_activatable (_tmp12_, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 372 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_set_allow_closing (self, FALSE);
#line 2346 "Preferences.c"
	} else {
		GtkLabel* _tmp13_;
		const gchar* _tmp14_;
		GtkEntry* _tmp15_;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->dir_pattern_example;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp14_ = example;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_text (_tmp13_, _tmp14_);
#line 376 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp15_ = self->priv->dir_pattern_entry;
#line 376 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_from_icon_name (_tmp15_, GTK_ENTRY_ICON_SECONDARY, NULL);
#line 377 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_set_allow_closing (self, TRUE);
#line 2363 "Preferences.c"
	}
#line 365 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (example);
#line 2367 "Preferences.c"
}


static void
preferences_dialog_set_allow_closing (PreferencesDialog* self,
                                      gboolean allow)
{
#line 381 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 382 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_set_deletable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), allow);
#line 383 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->allow_closing = allow;
#line 2381 "Preferences.c"
}


static gboolean
preferences_dialog_get_allow_closing (PreferencesDialog* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 386 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->allow_closing;
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = _tmp0_;
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2398 "Preferences.c"
}


static void
preferences_dialog_set_background_color (PreferencesDialog* self,
                                         gdouble bg_color_value)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GdkRGBA _tmp2_ = {0};
#line 390 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_to_grayscale (self, bg_color_value, &_tmp2_);
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_set_bg_color (_tmp1_, &_tmp2_);
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2421 "Preferences.c"
}


static void
preferences_dialog_to_grayscale (PreferencesDialog* self,
                                 gdouble color_value,
                                 GdkRGBA* result)
{
	GdkRGBA color = {0};
#line 394 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 395 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 397 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.red = color_value;
#line 398 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.green = color_value;
#line 399 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.blue = color_value;
#line 400 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.alpha = 1.0;
#line 402 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	*result = color;
#line 402 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return;
#line 2447 "Preferences.c"
}


static void
preferences_dialog_on_photo_editor_changed (PreferencesDialog* self)
{
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_;
	SortedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint photo_app_choice_index = 0;
	GAppInfo* app = NULL;
	SortedList* _tmp9_;
	gpointer _tmp10_;
	ConfigFacade* _tmp11_;
	ConfigFacade* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
#line 405 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->photo_editor_combo;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->external_photo_apps;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = _tmp3_;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (gtk_combo_box_get_active (_tmp1_) < _tmp4_) {
#line 2481 "Preferences.c"
		GtkComboBox* _tmp5_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = self->priv->photo_editor_combo;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = gtk_combo_box_get_active (_tmp5_);
#line 2487 "Preferences.c"
	} else {
		SortedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = self->priv->external_photo_apps;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = _tmp7_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp8_;
#line 2500 "Preferences.c"
	}
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	photo_app_choice_index = _tmp0_;
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->external_photo_apps;
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = sorted_list_get_at (_tmp9_, photo_app_choice_index);
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	app = (GAppInfo*) _tmp10_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = config_facade_get_instance ();
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = _tmp11_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = desktop_integration_get_app_open_command (app);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = _tmp13_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_external_photo_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp14_);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp14_);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp12_);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = desktop_integration_get_app_open_command (app);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = _tmp15_;
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_debug ("Preferences.vala:413: setting external photo editor to: %s", _tmp16_);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp16_);
#line 405 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (app);
#line 2534 "Preferences.c"
}


static void
preferences_dialog_on_raw_editor_changed (PreferencesDialog* self)
{
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_;
	SortedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint raw_app_choice_index = 0;
	GAppInfo* app = NULL;
	SortedList* _tmp9_;
	gpointer _tmp10_;
	ConfigFacade* _tmp11_;
	ConfigFacade* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
#line 416 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->raw_editor_combo;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->external_raw_apps;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = _tmp3_;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (gtk_combo_box_get_active (_tmp1_) < _tmp4_) {
#line 2566 "Preferences.c"
		GtkComboBox* _tmp5_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = self->priv->raw_editor_combo;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = gtk_combo_box_get_active (_tmp5_);
#line 2572 "Preferences.c"
	} else {
		SortedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = self->priv->external_raw_apps;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = _tmp7_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp8_;
#line 2585 "Preferences.c"
	}
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	raw_app_choice_index = _tmp0_;
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->external_raw_apps;
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = sorted_list_get_at (_tmp9_, raw_app_choice_index);
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	app = (GAppInfo*) _tmp10_;
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = config_facade_get_instance ();
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = _tmp11_;
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = g_app_info_get_commandline (app);
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_external_raw_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp13_);
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp12_);
#line 424 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = g_app_info_get_commandline (app);
#line 424 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_debug ("Preferences.vala:424: setting external raw editor to: %s", _tmp14_);
#line 416 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (app);
#line 2611 "Preferences.c"
}


static RawDeveloper
preferences_dialog_raw_developer_from_combo (PreferencesDialog* self)
{
	RawDeveloper result = 0;
	GtkComboBoxText* _tmp0_;
#line 427 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), 0);
#line 428 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->default_raw_developer_combo;
#line 428 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox)) == 0) {
#line 429 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 429 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 2630 "Preferences.c"
	}
#line 430 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = RAW_DEVELOPER_SHOTWELL;
#line 430 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2636 "Preferences.c"
}


static void
preferences_dialog_set_raw_developer_combo (PreferencesDialog* self,
                                            RawDeveloper d)
{
#line 433 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 434 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (d == RAW_DEVELOPER_CAMERA) {
#line 2648 "Preferences.c"
		GtkComboBoxText* _tmp0_;
#line 435 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = self->priv->default_raw_developer_combo;
#line 435 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), 0);
#line 2654 "Preferences.c"
	} else {
		GtkComboBoxText* _tmp1_;
#line 437 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = self->priv->default_raw_developer_combo;
#line 437 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), 1);
#line 2661 "Preferences.c"
	}
}


static void
preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
#line 440 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_default_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), preferences_dialog_raw_developer_from_combo (self));
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2681 "Preferences.c"
}


static void
preferences_dialog_on_current_folder_changed (PreferencesDialog* self)
{
	GtkFileChooserButton* _tmp0_;
	gchar* _tmp1_;
#line 444 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->library_dir_button;
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_file_chooser_get_type (), GtkFileChooser));
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->priv->lib_dir);
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->lib_dir = _tmp1_;
#line 2700 "Preferences.c"
}


static void
_preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                       gpointer self)
{
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_current_folder_changed ((PreferencesDialog*) self);
#line 2710 "Preferences.c"
}


static gboolean
preferences_dialog_real_map_event (GtkWidget* base,
                                   GdkEventAny* event)
{
	PreferencesDialog * self;
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GtkFileChooserButton* _tmp0_;
#line 448 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 448 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 449 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_result_ = GTK_WIDGET_CLASS (preferences_dialog_parent_class)->map_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget), event);
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->library_dir_button;
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_file_chooser_get_type (), GtkFileChooser), "current-folder-changed", (GCallback) _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed, self, 0);
#line 456 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = _result_;
#line 456 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2736 "Preferences.c"
}


static void
preferences_dialog_add_to_dir_formats (PreferencesDialog* self,
                                       const gchar* name,
                                       const gchar* pattern)
{
	PreferencesDialogPathFormat* pf = NULL;
	PreferencesDialogPathFormat* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkComboBoxText* _tmp2_;
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (name != NULL);
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = preferences_dialog_path_format_new (name, pattern);
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = _tmp0_;
#line 461 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->path_formats;
#line 461 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), pf);
#line 462 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->dir_pattern_combo;
#line 462 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp2_, name);
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 2767 "Preferences.c"
}


static void
preferences_dialog_on_lowercase_toggled (PreferencesDialog* self)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GtkCheckButton* _tmp2_;
#line 465 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->lowercase;
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton)));
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2789 "Preferences.c"
}


static PreferencesDialogPathFormat*
preferences_dialog_path_format_construct (GType object_type,
                                          const gchar* name,
                                          const gchar* pattern)
{
	PreferencesDialogPathFormat* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = (PreferencesDialogPathFormat*) g_type_create_instance (object_type);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = g_strdup (name);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->name);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->name = _tmp0_;
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = g_strdup (pattern);
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->pattern);
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->pattern = _tmp1_;
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self;
#line 2819 "Preferences.c"
}


static PreferencesDialogPathFormat*
preferences_dialog_path_format_new (const gchar* name,
                                    const gchar* pattern)
{
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return preferences_dialog_path_format_construct (PREFERENCES_DIALOG_TYPE_PATH_FORMAT, name, pattern);
#line 2829 "Preferences.c"
}


static void
preferences_dialog_value_path_format_init (GValue* value)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	value->data[0].v_pointer = NULL;
#line 2838 "Preferences.c"
}


static void
preferences_dialog_value_path_format_free_value (GValue* value)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (value->data[0].v_pointer);
#line 2849 "Preferences.c"
	}
}


static void
preferences_dialog_value_path_format_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dest_value->data[0].v_pointer = preferences_dialog_path_format_ref (src_value->data[0].v_pointer);
#line 2862 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2866 "Preferences.c"
	}
}


static gpointer
preferences_dialog_value_path_format_peek_pointer (const GValue* value)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return value->data[0].v_pointer;
#line 2876 "Preferences.c"
}


static gchar*
preferences_dialog_value_path_format_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (collect_values[0].v_pointer) {
#line 2888 "Preferences.c"
		PreferencesDialogPathFormat * object;
		object = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2895 "Preferences.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2899 "Preferences.c"
		}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = preferences_dialog_path_format_ref (object);
#line 2903 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 2907 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return NULL;
#line 2911 "Preferences.c"
}


static gchar*
preferences_dialog_value_path_format_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	PreferencesDialogPathFormat ** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!object_p) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2927 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = NULL;
#line 2933 "Preferences.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = value->data[0].v_pointer;
#line 2937 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = preferences_dialog_path_format_ref (value->data[0].v_pointer);
#line 2941 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return NULL;
#line 2945 "Preferences.c"
}


static GParamSpec*
preferences_dialog_param_spec_path_format (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	PreferencesDialogParamSpecPathFormat* spec;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return G_PARAM_SPEC (spec);
#line 2965 "Preferences.c"
}


static gpointer
preferences_dialog_value_get_path_format (const GValue* value)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return value->data[0].v_pointer;
#line 2976 "Preferences.c"
}


static void
preferences_dialog_value_set_path_format (GValue* value,
                                          gpointer v_object)
{
	PreferencesDialogPathFormat * old;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_ref (value->data[0].v_pointer);
#line 2999 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 3003 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (old);
#line 3009 "Preferences.c"
	}
}


static void
preferences_dialog_value_take_path_format (GValue* value,
                                           gpointer v_object)
{
	PreferencesDialogPathFormat * old;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = v_object;
#line 3031 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 3035 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (old);
#line 3041 "Preferences.c"
	}
}


static void
preferences_dialog_path_format_class_init (PreferencesDialogPathFormatClass * klass)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_path_format_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	((PreferencesDialogPathFormatClass *) klass)->finalize = preferences_dialog_path_format_finalize;
#line 3053 "Preferences.c"
}


static void
preferences_dialog_path_format_instance_init (PreferencesDialogPathFormat * self)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->ref_count = 1;
#line 3062 "Preferences.c"
}


static void
preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj)
{
	PreferencesDialogPathFormat * self;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_handlers_destroy (self);
#line 15 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->name);
#line 16 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->pattern);
#line 3078 "Preferences.c"
}


static GType
preferences_dialog_path_format_get_type (void)
{
	static volatile gsize preferences_dialog_path_format_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_path_format_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { preferences_dialog_value_path_format_init, preferences_dialog_value_path_format_free_value, preferences_dialog_value_path_format_copy_value, preferences_dialog_value_path_format_peek_pointer, "p", preferences_dialog_value_path_format_collect_value, "p", preferences_dialog_value_path_format_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogPathFormatClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_path_format_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialogPathFormat), 0, (GInstanceInitFunc) preferences_dialog_path_format_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType preferences_dialog_path_format_type_id;
		preferences_dialog_path_format_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreferencesDialogPathFormat", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&preferences_dialog_path_format_type_id__volatile, preferences_dialog_path_format_type_id);
	}
	return preferences_dialog_path_format_type_id__volatile;
}


static gpointer
preferences_dialog_path_format_ref (gpointer instance)
{
	PreferencesDialogPathFormat * self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return instance;
#line 3107 "Preferences.c"
}


static void
preferences_dialog_path_format_unref (gpointer instance)
{
	PreferencesDialogPathFormat * self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS (self)->finalize (self);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3122 "Preferences.c"
	}
}


static void
preferences_dialog_class_init (PreferencesDialogClass * klass)
{
	gint PreferencesDialog_private_offset;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	((GtkWidgetClass *) klass)->map_event = (gboolean (*) (GtkWidget *, GdkEventAny*)) preferences_dialog_real_map_event;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	PreferencesDialog_private_offset = g_type_class_get_instance_private_offset (klass);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Shotwell/ui/preferences_dialog.ui");
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bg_color_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, bg_color_adjustment));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bg_color_slider", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, bg_color_slider));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_editor_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, photo_editor_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "raw_editor_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, raw_editor_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "library_dir_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, library_dir_button));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_entry));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_example", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_example));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lowercase", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, lowercase));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "default_raw_developer_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, default_raw_developer_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "autoimport", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, autoimport));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "write_metadata", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, write_metadata));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pattern_help", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, pattern_help));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preferences_notebook", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, preferences_notebook));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_checker_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_checker_radio));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_solid_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_solid_radio));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_solid_color", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_solid_color));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_none_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_none_radio));
#line 3179 "Preferences.c"
}


static void
preferences_dialog_instance_init (PreferencesDialog * self)
{
	GeeArrayList* _tmp0_;
	GDateTime* _tmp1_;
	PluginsManifestWidgetMediator* _tmp2_;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
#line 39 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->allow_closing = FALSE;
#line 40 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->lib_dir = NULL;
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = gee_array_list_new (PREFERENCES_DIALOG_TYPE_PATH_FORMAT, (GBoxedCopyFunc) preferences_dialog_path_format_ref, (GDestroyNotify) preferences_dialog_path_format_unref, NULL, NULL, NULL);
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->path_formats = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = g_date_time_new_local (2009, 3, 10, 18, 16, (gdouble) 11);
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->example_date = _tmp1_;
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = plugins_manifest_widget_mediator_new ();
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp2_);
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->plugins_mediator = _tmp2_;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3211 "Preferences.c"
}


static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 22 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->bg_color_adjustment);
#line 24 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->bg_color_slider);
#line 26 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->photo_editor_combo);
#line 28 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->raw_editor_combo);
#line 29 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_raw_apps);
#line 30 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_photo_apps);
#line 32 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->library_dir_button);
#line 34 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_combo);
#line 36 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_entry);
#line 38 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_example);
#line 40 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->priv->lib_dir);
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->path_formats);
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_date_time_unref0 (self->priv->example_date);
#line 44 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->lowercase);
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->plugins_mediator);
#line 47 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->default_raw_developer_combo);
#line 50 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->autoimport);
#line 52 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->write_metadata);
#line 54 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->pattern_help);
#line 56 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->preferences_notebook);
#line 59 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_checker_radio);
#line 61 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_solid_radio);
#line 63 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_solid_color);
#line 65 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_none_radio);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
#line 3271 "Preferences.c"
}


GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



