# setup.py - Distutils interface to build, install and distribute
# GLE extension
import sys, os
from os import path
from distutils.core import setup, Extension
from distutils.command.build import build
from distutils.command.sdist import sdist

pack_name = "gle"
ext_name = "_gle"
platform = sys.platform

#####################################################################
# Had to overwrite the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.
####################################################################

class modified_sdist(sdist):
    def prune_file_list(self):

        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)

# Lists of include dirs, pre-processor macros, libraries at link-time
# (build_ext).
import numpy
incl_dirs = [".", "src", numpy.get_include()]
macros = [("PIC", None), ]
comp_args = []
link_args = []
libs = {'posix': ['GL', 'GLU'], 'nt': ['OPENGL32','GLU32']}.get( os.name, [])
#libs = ["GL", "GLU"]
if platform == "sunos5":
    comp_args.extend(['-Kpic'])
    
#elif platform == "irix6":
elif platform == "linux2":
    incl_dirs.append("/usr/X11R6/include")
    #comp_args.extend([" -pedantic", "-Wstrict-prototypes",  "-Wconversion"])
    #comp_args.extend(["-Wconversion"])
elif platform == "darwin":
    incl_dirs.append("/usr/include/malloc")
    comp_args.extend(["-framework", "OpenGL"])
    link_args.extend(["-framework", "OpenGL"])
    macros.append(("__APPLE__", None))
    libs = []
elif platform == "win32":
    macros.append(("WIN32", None))

# List of source files
src_list = ["ex_alpha.c",
            "extrude.c",
            "rotate.c",
            "urotate.c",
            "ex_angle.c",
            "intersect.c",
            "round_cap.c",
            "view.c",
            "ex_cut_round.c",
            "qmesh.c",
            "segment.c",
            "ex_raw.c",
            "rot_prince.c",
            "texgen.c"]

for i in range(len(src_list)):
    src_list[i] = path.join("src", src_list[i])

src_list.append(path.join("gle", "gle.i"))

# Change the order of commands that are called by "build"
# so that "build_py" command is called after "build_ext". In this case
# "build_py" will install (copy to the build directory) python
# modules generated by "build_ext'.

class modified_build(build):

    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]

try:   
    from version import VERSION
except:
    VERSION = "1.0"

dist = setup(name = pack_name,
             version=VERSION,
             description = "GLE library (python extension)",
             author = 'Molecular Graphics Laboratory',
             author_email = 'mgltools@scripps.edu',
             url = 'http://www.scripps.edu/~sanner/software/index.html',
             packages = ['gle','gle.Tests'],
             cmdclass = {"build" : modified_build,
                         'sdist' : modified_sdist},
             ext_package = pack_name,
             ext_modules = [Extension (ext_name, src_list,
                                       include_dirs = incl_dirs,
                                       define_macros = macros,
                                       libraries = libs,
                                       extra_compile_args = comp_args,
                                       extra_link_args = link_args
                     ) ] ,)
