#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$2" = pegasus
then
	
	cimprovider -d -m PhysicalAsset_OpenDRIM_CardModule
	cimprovider -r -m PhysicalAsset_OpenDRIM_CardModule
	
	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE <<EOFC
<?xml version="1.0" encoding="utf-8" ?>
<CIM CIMVERSION="2.0" DTDVERSION="2.0">
 <MESSAGE ID="1" PROTOCOLVERSION="1.0">
  <SIMPLEREQ>
   <IMETHODCALL NAME="DeleteClass">
    <LOCALNAMESPACEPATH>
EOFC
	
	namespace=$1
	index=`expr index $namespace /`
	
	while [ $index != 0 ]
	do
	  namespaceFragment=${namespace:0:index-1}
	  namespace=${namespace:index:${#namespace}-index}
	  index=`expr index $namespace /`
cat >> $OUTFILE <<EOFC
     <NAMESPACE NAME="$namespaceFragment"></NAMESPACE>
EOFC
	done
	
cat >> $OUTFILE <<EOFC
     <NAMESPACE NAME="$namespace"></NAMESPACE>
EOFC
	
cat >> $OUTFILE <<EOFC
    </LOCALNAMESPACEPATH>
    <IPARAMVALUE NAME="ClassName">
     <CLASSNAME NAME="OpenDRIM_Card"/>
    </IPARAMVALUE>
   </IMETHODCALL>
  </SIMPLEREQ>
 </MESSAGE>
</CIM>

EOFC
	
	PATH=$PATH:$PEGASUS_HOME/bin
	wbemexec $OUTFILE
	
	rm -f $OUTFILE

fi

if test "$2" = sfcb
then
	
	OUTFILE=./OpenDRIM_Card.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_Card]   
   provider: PhysicalAsset_OpenDRIM_CardProvider
   location: cmpiPhysicalAsset_OpenDRIM_CardProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbunstage -r $OUTFILE -n $1 OpenDRIM_Card.mof
	
	rm -f $OUTFILE

	sfcbrepos -f

fi

if test "$2" = openwbem
then
	
	OUTFILE=./OpenDRIM_Card-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $4/mof/OpenDRIM_Card.mof >> $OUTFILE
	owmofc -u http://localhost/$1 -r $OUTFILE

	rm -f $OUTFILE
	
fi
