# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys, time
import pygame, pygame.font, pygame.image
import PIL, PIL.Image

pygame.init()
font  = pygame.font.Font(None, 32)
white = pygame.color.Color('white')
black = pygame.color.Color('black')

s = u"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZéèëêàâäôöîïùûüç+-_()%,.;:!?<>&'\"*\\/@"

sprites = []
for char in s:
  print char
  image = font.render(char, 1, white, black)
  pygame.image.save(image, "/tmp/char.tga")
  image = PIL.Image.open("/tmp/char.tga")
  box = image.getbbox() or (0, 0, 0, 0)
  image = image.crop(box)
  image2 = PIL.Image.new("RGB", (image.size[0] + 2, image.size[1] + 2))
  image2.paste(image, (1, 1))
  sprites.append(image2)
  if   char == "/":
    image2.save(u"/home/jiba/tmp/balazar3_sprites/font_0_slash_0.png")
    open("/home/jiba/tmp/balazar3_sprites/font_0_slash.info", "w").write("%s %s %s %s\n" % (box[0], box[1], box[2] - box[0], box[3] - box[1]))
  elif char == "\\":
    image2.save(u"/home/jiba/tmp/balazar3_sprites/font_0_backslash_0.png")
    open("/home/jiba/tmp/balazar3_sprites/font_0_backslash.info", "w").write("%s %s %s %s\n" % (box[0], box[1], box[2] - box[0], box[3] - box[1]))
  else:
    image2.save(u"/home/jiba/tmp/balazar3_sprites/font_0_%s_0.png" % char)
    open("/home/jiba/tmp/balazar3_sprites/font_0_%s.info" % char, "w").write("%s %s %s %s\n" % (box[0], box[1], box[2] - box[0], box[3] - box[1]))
