//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Tool/LayoutUtil.h
//! @brief     Defines namespace GUI::Util::Layout
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_TOOL_LAYOUTUTIL_H
#define BORNAGAIN_GUI_VIEW_TOOL_LAYOUTUTIL_H

class QLayout;
class QGridLayout;
class QWidget;

//! Utility functions to add/remove widgets to the layout on the fly.
//! Taken from https://stackoverflow.com/questions/5395266/removing-widgets-from-qgridlayout

namespace GUI::Util::Layout {

//! Removes content from box layout.
void clearLayout(QLayout* layout, bool deleteWidgets = true);

//! Removes row from grid layout (important: doesn't change row count).
void removeRow(QGridLayout* layout, int row, bool deleteWidgets = true);

//! Removes column from grid layout.
void removeColumn(QGridLayout* layout, int column, bool deleteWidgets = true);

//! Clear layout completely.
void clearGridLayout(QGridLayout* layout, bool deleteWidgets = true);

//! Returns empty widget to occupy place in layout.
QWidget* placeHolder();

} // namespace GUI::Util::Layout

#endif // BORNAGAIN_GUI_VIEW_TOOL_LAYOUTUTIL_H
