//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Img3D/Build/Particle3DContainer.h
//! @brief     Implements namespace GUI::View::TransformTo3D
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_IMG3D_BUILD_PARTICLE3DCONTAINER_H
#define BORNAGAIN_IMG3D_BUILD_PARTICLE3DCONTAINER_H

#include "Base/Types/OwningVector.h"
#include <memory>

namespace Img3D {

class PlotParticle;

//! Contains the constituents of a 3D Particle (e.g. core and shell of a CoreAndShell)
class Particle3DContainer {
public:
    Particle3DContainer()
        : m_cumulativeAbundance(0)
    {
    }
    Particle3DContainer(const Particle3DContainer& other) = delete;
    Particle3DContainer& operator=(const Particle3DContainer& rhs) = delete;
    ~Particle3DContainer();

    Particle3DContainer(Particle3DContainer&& other) = default;
    Particle3DContainer& operator=(Particle3DContainer&& rhs) = default;

    void clearContainer();

    size_t containerSize() const { return m_containerParticles.size(); }
    double cumulativeAbundance() const { return m_cumulativeAbundance; }

    void addParticle3D(Img3D::PlotParticle* particle3D);
    void setCumulativeAbundance(double cumulativeAbundance);

    std::unique_ptr<Img3D::PlotParticle> createParticle(const size_t& index) const;

private:
    OwningVector<Img3D::PlotParticle> m_containerParticles;
    double m_cumulativeAbundance;
};

} // namespace Img3D

#endif // BORNAGAIN_IMG3D_BUILD_PARTICLE3DCONTAINER_H
