# Code generation format strings for UFC (Unified Form-assembly Code)
# This code is released into the public domain.
#
# The FEniCS Project (http://www.fenicsproject.org/) 2018.
"""Code generation strings for a file."""

import sys

declaration_pre = """
// This code conforms with the UFC specification version {ufcx_version}
// and was automatically generated by FFCx version {ffcx_version}.
//
// This code was generated with the following options:
//
{options}

#pragma once
#include <ufcx.h>

#ifdef __cplusplus
extern "C" {{
#endif
"""

declaration_post = """
#ifdef __cplusplus
}}
#endif
"""

implementation_pre = """
// This code conforms with the UFC specification version {ufcx_version}
// and was automatically generated by FFCx version {ffcx_version}.
//
// This code was generated with the following options:
//
{options}

#include <math.h>
#include <stdalign.h>
#include <stdlib.h>
#include <string.h>
#include <ufcx.h>
{extra_c_includes}

"""

if sys.platform.startswith("win32"):
    libraries: list[str] = []
else:
    libraries: list[str] = ["m"]

implementation_post = ""
