# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
FEDORA_RELEASES += 40
FEDORA_40_SUBVER = 1.14

.PHONY: all
all:: fedora-cloud-40.$(GARDEN_ARCH).qcow2 fedora-cloud-40.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.$(GARDEN_ARCH)-40-$(FEDORA_40_SUBVER).qcow2

$(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.x86_64-40-$(FEDORA_40_SUBVER).qcow2 $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.aarch64-40-$(FEDORA_40_SUBVER).qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.%-40-$(FEDORA_40_SUBVER).qcow2: | $(GARDEN_DL_DIR)/fedora
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.fedoraproject.org/pub/fedora/linux/releases/40/Cloud/$*/images/Fedora-Cloud-Base-Generic.$*-40-$(FEDORA_40_SUBVER).qcow2)

$(GARDEN_DL_DIR)/fedora/fedora-cloud-base-40.%.qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.%-40-$(FEDORA_40_SUBVER).qcow2 | $(GARDEN_DL_DIR)/fedora
	ln -sf $(notdir $<) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/fedora/fedora-cloud-base-40.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.*-40-$(FEDORA_40_SUBVER).qcow2
