#ifndef _IMAGE_H
#define _IMAGE_H

#include <gd.h>
#include <gdfonts.h>
#include <KayaAPI.h>
#include <stdfuns.h>

extern "C" {
    void* createImage(int x, int y, int tc);
    void destroyImage(void* img);

    /// Return Images directly
    KayaValue createImageFromPNG(void* fn);
    KayaValue createImageFromJPEG(void* fn);

    int imageColourAllocate(void* img, int r, int g, int b, int a);

    void imageLine(void* img, int x1, int y1, int x2, int y2, int col);
    void imageDashedLine(void* img, int x1, int y1, int x2, int y2, int col);
    void imageSetPixel(void* img, int x, int y, int col);
    void imageDrawPoly(void* img, KayaArray pts, int col, int filled);
    void imageRectangle(void* img, int x1, int y1, int x2, int y2, 
			int col, int filled);
    void imageArc(void* img, int cx, int cy, int w, int h, int s, int e,
			int col, KayaArray style, int filled);

    void imageCopy(void* dest,void* src, int dstx, int dsty, int srcx,
		   int srcy, int w, int h);
    void imageCopyResized(void* dest,void* src, int dstx, int dsty, int srcx,
			  int srcy, int destw, int desth, int srcw, int srch);

    void imageWritePNG(void* img, void* out);
    void imageWriteJPEG(void* img, void* out, int quality);
    KayaValue imageGetPNG(void* img);
    KayaValue imageGetJPEG(void* img, int quality);
    KayaValue imageGetBinary(void* bindata, int binsize);

    void* fontGetSmall();
    void* fontGetLarge();
    void* fontGetMediumBold();
    void* fontGetGiant();
    void* fontGetTiny();

    void imageString(void* img, void* font, int x, int y, wchar_t* str, 
		     int col, int up);
}

#endif
