/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2011-2014 Jean-Pierre Charras, jp.charras at wanadoo.fr
 * Copyright (C) 1992-2014 KiCad Developers, see CHANGELOG.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef _html_messagebox_
#define _html_messagebox_


/**
@file
Subclass of DIALOG_DISPLAY_HTML_TEXT_BASE, which is generated by wxFormBuilder.
*/

#include <../common/dialogs/dialog_display_info_HTML_base.h>


/**
 * Class HTML_MESSAGE_BOX
 */
class HTML_MESSAGE_BOX : public DIALOG_DISPLAY_HTML_TEXT_BASE
{
protected:
    // Handlers for HTML_MESSAGE_BOX_BASE events.
    void OnCloseButtonClick( wxCommandEvent& event );

public:
    /**
     * Constructor
     */
    HTML_MESSAGE_BOX( wxWindow* parent, const wxString& aTitle,
                       wxPoint aPos = wxDefaultPosition,
                       wxSize aSize = wxSize( 450, 250 ) );

    /**
     * Function ListSet
     * Add a list of items.
     * @param aList = a string containing items. Items are separated by '\n'
     */
    void ListSet( const wxString& aList );

    /**
     * Function ListSet
     * Add a list of items.
     * @param aList = a wxArrayString containing items.
     */
    void ListSet( const wxArrayString& aList );

    void ListClear();

    /**
     * Function MessageSet
     * adds a message (in bold) to message list.
     * @param message = the message
     */
    void MessageSet( const wxString& message );

    /**
     * Function AddHTML_Text
     * adds html text (without any change) to message list.
     * @param message = the text to add
     */
    void AddHTML_Text( const wxString& message );
};

#endif // _html_messagebox_
