/*
 *  Copyright 1994-2016 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "globals.h"
#include "sequences.h"


void
Sequences_new()
{
  DIR *dir;
  struct dirent *entry;
  gchar *blah;
  const gchar *home_dir;

  sequences = xcalloc(1, sizeof(Sequences_t));
  sequences->seqs = NULL;

  home_dir = g_get_home_dir();
  blah = g_strdup_printf("%s/%s", home_dir, SAVEDIR);

  dir = opendir(blah);

  if (dir == NULL) {
#ifdef DEBUG
    printf("[!] No user sequences found: %s: %s\n", blah, strerror(errno));
#endif
    g_free(blah);
  } else {
    g_free(blah);
    while ((entry = readdir(dir)) != NULL) {
      if (strcmp(entry->d_name, "..")) {
	Sequence_t *s = NULL;
	
	s = Sequence_load(entry->d_name);
	
	if (s != NULL)
	  sequences->seqs = g_list_insert_sorted(sequences->seqs, (gpointer)s, Sequence_sort_func);
      }
#ifdef XDEBUG
      else
	printf("[i] FYI not reading a sequence named '..' :)\n");
#endif
    }
    
    if (closedir(dir) == -1)
      xperror("closedir");
  }    

  sequences->size = g_list_length(sequences->seqs);
  sequences->shuffler = Shuffler_new(sequences->size);
  Shuffler_verbose(sequences->shuffler);
}


void
Sequences_free()
{
  GList *tmp;

  if (sequences == NULL)
	return;
  
  tmp = sequences->seqs;
  
  while (tmp != NULL) {
    Sequence_t *killme = (Sequence_t *)tmp->data;
    
    Sequence_delete(killme);
    tmp = g_list_next(tmp);
  }
  
  g_list_free(sequences->seqs);
  Shuffler_delete(sequences->shuffler);
  xfree(sequences);
}


/* TODO un g_list_find */
Sequence_t *
Sequences_find(const uint32_t id)
{
  GList *tmp;

  assert(NULL != sequences);
  tmp = sequences->seqs;

  while (tmp != NULL) {
    Sequence_t *s = (Sequence_t *)tmp->data;

    if (s->id == id)
      return s;

    tmp = g_list_next(tmp);
  }

  return NULL;
}
