/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETCHART_HEADER
#define LIFEOGRAPH_WIDGETCHART_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "helpers.hpp"


namespace LIFEO
{

using namespace HELPERS;

class ChartPoints : public std::map< Date::date_t, int >
{
    public:
                                    ChartPoints();
        void                        add( Date::date_t, int );
        void                        increase( Date::date_t, unsigned int = 1 );
        void                        finish()
        {
            if( get_span() != size() )
                value_min = 0;
        }

        int                         get_value_at( Date::date_t );
        unsigned int                get_span();

        int                         value_min;
        int                         value_max;
        unsigned int                current;
        bool                        flag_use_current;
};


class WidgetChart : public Gtk::DrawingArea
{
    public:
        // CONSTANTS
        static const float          border_curve;
        static const float          border_label;
        static const float          offset_label;
        static const float          label_height;
        static const float          bar_height;
        static const float          OVERVIEW_COEFFICIENT;
        static const float          COLUMN_WIDTH_MIN;
        // CALCULATED CONSTANTS
        static const float          label_y;
        static const float          s_x_min;
        static const float          s_y_min;

                                    WidgetChart( BaseObjectType*,
                                                 const Glib::RefPtr< Gtk::Builder >& );
        void                        set_points( ChartPoints* );

    protected:
        void                        on_size_allocate( Gtk::Allocation& );
        bool                        on_scroll_event( GdkEventScroll* );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_button_release_event( GdkEventButton* );
        bool                        on_motion_notify_event( GdkEventMotion* );
        bool                        on_leave_notify_event( GdkEventCrossing* );
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& );

        void                        update_col_geom( bool = false );

        // DATA
        ChartPoints                 *m_points;
        // GEOMETRY
        int                         m_width;
        int                         m_height;
        unsigned int                m_col_count;
        unsigned int                m_col_start;

        float                       m_x_max, m_y_max, m_y_mid;
        float                       m_amplitude, m_length, m_col_count_max;
        float                       m_step_x, m_coefficient;
        float                       m_overview_height;

        Cairo::RefPtr< Cairo::ToyFontFace >
                                    m_font_main;

        bool                        m_flag_button_pressed;
        bool                        m_flag_pointer_hovered;
};

} // end of namespace LIFEO

#endif
