from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


cast_bytes = _Mock()

disambiguate_url = _Mock()

getpass = _Mock()

ioloop = _Mock()

localhost = _Mock()

print_function = _Mock()

sys = _Mock()

time = _Mock()

tunnel = _Mock()

zmq = _Mock()

zmqstream = _Mock()



class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CBytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class Dict(_Mock):
  pass
  info_text = 'any value'

class EngineFactory(_Mock):
  pass
  _hb_last_monitored = 0.0
  _hb_last_pinged = 0.0
  _hb_missed_beats = 0

class Float(_Mock):
  pass
  default_value = 0.0
  info_text = 'a float'

class Heart(_Mock):
  pass


class IPKernelApp(_Mock):
  pass
  _in_init_profile_dir = False
  name = 'ipkernel'

class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class Kernel(_Mock):
  pass


class Message(_Mock):
  pass


class RegistrationFactory(_Mock):
  pass


class Type(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

