/*
    		 Crown Copyright (c) 1997, 1998
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/

/* AUTOMATICALLY GENERATED BY make_err FROM cpp */


/* Error catalogue */

ERR_CONST char *ERR_NAME = "cpp" ;

ERR_DATA ERR_CATALOG [] = {
    {
	"fail_input",
	"J",
	0,
	3,
	"",
	"Can't open input file, '%0'"
    },
    {
	"fail_output",
	"J",
	0,
	3,
	NULL,
	"Can't open output file, '%0'"
    },
    {
	"fail_dump",
	"J",
	0,
	3,
	NULL,
	"Can't open output dump file, '%0'"
    },
    {
	"fail_spec",
	"J",
	0,
	3,
	NULL,
	"Can't open output spec file, '%0'"
    },
    {
	"fail_spec_bad",
	"JJ",
	0,
	3,
	NULL,
	"Ill-formed spec file, '%0': %1"
    },
    {
	"fail_port",
	"J",
	0,
	3,
	NULL,
	"Can't open portability table, '%0'"
    },
    {
	"fail_too_many",
	"L",
	0,
	3,
	NULL,
	"Too many errors (%0) - aborting"
    },
    {
	"fail_error",
	"I",
	0,
	3,
	NULL,
	"%0"
    },
    {
	"fail_warning",
	"I",
	OPT_warning,
	3,
	NULL,
	"%0"
    },
    {
	"fail_list_item",
	"M9D",
	OPT_whatever,
	65,
	NULL,
	"\t%0. '%1' (%2)"
    },
    {
	"fail_list_end",
	"M",
	OPT_none,
	65,
	NULL,
	" (total %0)"
    },
    {
	"lex_parse",
	"C",
	0,
	17,
	"",
	"Parse error before '%0'"
    },
    {
	"lex_expect",
	"8",
	0,
	17,
	NULL,
	"Syntax error, '%0' expected"
    },
    {
	"lex_extra_comma",
	NULL,
	OPT_comma_extra,
	17,
	NULL,
	"Extra comma at end of list"
    },
    {
	"lex_abort",
	NULL,
	0,
	17,
	NULL,
	"Can't recover from this error"
    },
    {
	"lex_phases_eof",
	NULL,
	OPT_eof_nline,
	0,
#ifndef ERR_ALTERNATE
	"2.1",
#else
	"5.1.1.2",
#endif
	"File does not end in newline character"
    },
    {
	"lex_phases_comm_eof",
	NULL,
	0,
	0,
	NULL,
	"Unterminated comment"
    },
    {
	"lex_phases_str_eof",
	NULL,
	0,
	0,
	NULL,
	"End of file in string literal"
    },
    {
	"lex_charset_len",
	"HM",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.2",
#else
	"5.2.1",
#endif
	"Universal character '\\%0' should be followed by %1 hexadecimal digits"
    },
    {
	"lex_charset_replace",
	"K",
	OPT_trigraph,
	0,
	NULL,
	"Universal character '%0' used"
    },
    {
	"lex_charset_bad",
	"K",
	0,
	0,
	NULL,
	"Invalid universal character '%0'"
    },
    {
	"lex_trigraph_replace",
	"HH",
	OPT_trigraph,
	0,
#ifndef ERR_ALTERNATE
	"2.3",
#else
	"5.2.1.1",
#endif
	"Trigraph '??%0' replaced by '%1'"
    },
    {
	"lex_pptoken_unknown",
	"H",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.4",
#else
	"6.1",
#endif
	"Illegal character, '%0'"
    },
    {
	"lex_pptoken_unicode",
	"K",
	0,
	0,
	NULL,
	"Illegal universal character, '%0'"
    },
    {
	"lex_digraph_replace",
	"88",
	OPT_digraph,
	0,
#ifndef ERR_ALTERNATE
	"2.5",
#else
	"Amendment 1",
#endif
	"Digraph '%0' replaced by '%1'"
    },
    {
	"lex_digraph_iso",
	"68",
	OPT_iso_keyword,
	0,
	NULL,
	"ISO keyword '%0' replaced by '%1'"
    },
    {
	"lex_comment_nest",
	NULL,
	OPT_nest_comment,
	0,
#ifndef ERR_ALTERNATE
	"2.7",
#else
	"6.1.9",
#endif
	"'/*' in comment"
    },
    {
	"lex_name_limit",
	"6LL",
	OPT_name_limit,
	0,
#ifndef ERR_ALTERNATE
	"2.10",
#else
	"6.1.2",
#endif
	"Length of identifier '%0' (%1) exceeds %2"
    },
    {
	"lex_name_extendid",
	"K",
	0,
	0,
	NULL,
	"Invalid universal character, '%0', in identifier"
    },
    {
	"lex_key_word",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.11",
#else
	"6.1.1",
#endif
	"'%0' is now a keyword"
    },
    {
	"lex_key_iso",
	"6",
	OPT_wall,
	0,
	NULL,
	"ISO keyword '%0' is not a valid macro identifier"
    },
    {
	"lex_key_reserve",
	"6",
	OPT_wall,
	0,
	NULL,
	"'%0' is a reserved identifier"
    },
    {
	"lex_op_old_assign",
	"HH",
	OPT_none,
	0,
#ifndef ERR_ALTERNATE
	"2.12",
#else
	"6.1.5",
#endif
	"Old style assignment operator '=%0', assuming '= %1'"
    },
    {
	"lex_literal_bad",
	"J",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13",
#else
	"6.1.3",
#endif
	"Can't convert '%0' to a number"
    },
    {
	"lex_icon_octal",
	"J",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13.1",
#else
	"6.1.3.2",
#endif
	"Illegal octal digits in '%0'"
    },
    {
	"lex_icon_large",
	"JB",
	0,
	0,
	NULL,
	"Integer literal '%0' exceeds maximum value (%1)"
    },
    {
	"lex_icon_llong",
	"J",
	OPT_longlong,
	0,
	NULL,
	"'long long' integer literal '%0'"
    },
    {
	"lex_ccon_multibyte",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13.2",
#else
	"5.2.1.2",
#endif
	"Invalid multibyte character"
    },
    {
	"lex_ccon_empty",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13.2",
#else
	"6.1.3.4",
#endif
	"Empty character literal"
    },
    {
	"lex_ccon_multi",
	"F",
	OPT_wall,
	0,
	NULL,
	"Multicharacter character literal, %0"
    },
    {
	"lex_ccon_escape",
	"H",
	OPT_escape_unknown,
	0,
	NULL,
	"Unknown escape sequence, '\\%0'"
    },
    {
	"lex_ccon_hex",
	"H",
	OPT_escape_unknown,
	0,
	NULL,
	"Invalid hexadecimal escape sequence, '\\%0'"
    },
    {
	"lex_ccon_large",
	NULL,
	OPT_escape_overflow,
	0,
	NULL,
	"Character out of range"
    },
    {
	"lex_fcon_large",
	"5",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13.3",
#else
	"6.1.3.1",
#endif
	"Floating point literal '%0' too large"
    },
    {
	"lex_string_nl",
	"MN",
	0,
	0,
#ifndef ERR_ALTERNATE
	"2.13.4",
#else
	"6.1.4",
#endif
	"%0 newline character%1 in string literal"
    },
    {
	"lex_string_pp_nl",
	NULL,
	0,
	0,
	NULL,
	"End of line in string literal"
    },
    {
	"lex_string_concat",
	NULL,
	OPT_concat_string,
	0,
	NULL,
	"Concatenation of different string literal types"
    },
    {
	"basic_odr_decl",
	"7D",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.2",
#else
	"6.5",
#endif
	"'%0' has already been declared (at %1)"
    },
    {
	"basic_odr_diff",
	"7D",
	0,
	0,
	NULL,
	"'%0' has already been declared as a different kind of object (at %1)"
    },
    {
	"basic_odr_typedef",
	"7D",
	OPT_type_redef,
	0,
	NULL,
	"Type '%0' redeclared (see %1)"
    },
    {
	"basic_odr_def",
	"7D",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.2",
#else
	"6.7",
#endif
	"'%0' has already been defined (at %1)"
    },
    {
	"basic_odr_def_func",
	"9D",
	0,
	0,
	NULL,
	"The function '%0' has already been defined (at %1)"
    },
    {
	"basic_odr_undef",
	"9",
	0,
	0,
	NULL,
	"'%0' has been used but not defined"
    },
    {
	"basic_odr_inline",
	"9",
	0,
	0,
	NULL,
	"The 'inline' function '%0' has been used but not defined"
    },
    {
	"basic_odr_unused",
	"9",
	OPT_whatever,
	0,
	NULL,
	"'%0' has been defined but not used"
    },
    {
	"basic_odr_redundant",
	"9",
	OPT_whatever,
	0,
	NULL,
	"'%0' has been declared but not used or defined"
    },
    {
	"basic_odr_tentative",
	"7D",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"3.2",
#else
	"6.7.2",
#endif
	"Multiple definition of '%0' (see %1)"
    },
    {
	"basic_odr_def_type",
	"9D",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.2",
#else
	"6.5.2.3",
#endif
	"The type '%0' has already been defined (at %1)"
    },
    {
	"basic_scope_pdecl_param",
	"9",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"3.3.1",
#else
	"6.1.2.1",
#endif
	"The type '%0' has function parameter scope - it is only in scope in this declaration"
    },
    {
	"basic_scope_hide",
	"6D",
	OPT_decl_hide,
	0,
#ifndef ERR_ALTERNATE
	"3.3.7",
#else
	"6.1.2.1",
#endif
	"Declaration of '%0' hides a previous declaration (at %1)"
    },
    {
	"basic_scope_hide_mem",
	"67",
	OPT_decl_hide,
	0,
	NULL,
	"Declaration of '%0' hides the member '%1'"
    },
    {
	"lookup_ambig_id",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.4",
#else
	"6.3.1",
#endif
	"The name '%0' is ambiguous"
    },
    {
	"lookup_ambig_mem",
	"7",
	0,
	0,
	NULL,
	"The member '%0' is ambiguous"
    },
    {
	"lookup_ambig_list",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Ambiguous meanings are as follows"
    },
    {
	"lookup_unqual_undef",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.4.1",
#else
	"6.3.1",
#endif
	"The identifier '%0' hasn't been declared in this scope"
    },
    {
	"lookup_unqual_vis",
	"7",
	0,
	0,
	NULL,
	"Previous declaration of '%0' isn't visible in this scope"
    },
    {
	"lookup_qual_undef",
	"6A",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.4.3",
#else
	"6.5.2.1",
#endif
	"The member '%0' of '%1' hasn't been declared"
    },
    {
	"lookup_qual_bad",
	"7A",
	0,
	0,
	NULL,
	"'%0' is not a member of '%1'"
    },
    {
	"lookup_qual_decl",
	"7A",
	0,
	0,
	NULL,
	"'%0' is not an immediate member of '%1'"
    },
    {
	"lookup_elab_alias",
	"17",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.4.4",
#else
	"6.5.2.3",
#endif
	"'typedef' name used in '%0 %1'"
    },
    {
	"lookup_elab_invalid",
	"17",
	0,
	0,
	NULL,
	"Invalid identifier used in '%0 %1'"
    },
    {
	"lookup_elab_enum",
	"9",
	OPT_enum_decl,
	0,
	NULL,
	"Can't declare the enumeration '%0'"
    },
    {
	"lookup_classref_ambig",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.4.5",
#else
	"????",
#endif
	"Ambiguous class member look-up for '%0'"
    },
    {
	"basic_link_mem_extern",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.5",
#else
	"6.1.2.2",
#endif
	"The member '%0' has external linkage"
    },
    {
	"basic_link_none",
	"G9",
	OPT_cpp_error,
	0,
	NULL,
	"A type with no linkage, '%0', can't be used to declare an object with linkage, '%1'"
    },
    {
	"basic_link_qual",
	"33",
	OPT_type_qual_incompat,
	0,
#ifndef ERR_ALTERNATE
	"3.5",
#else
	"6.5.3",
#endif
	"The type qualifiers '%0' and '%1' are incompatible"
    },
    {
	"basic_link_incompat",
	"GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.5",
#else
	"6.1.2.6",
#endif
	"The types '%0' and '%1' are incompatible"
    },
    {
	"basic_link_decl_type",
	"7D",
	OPT_whatever,
	0,
	NULL,
	"The declaration of '%0' should be compatible with that at %1"
    },
    {
	"basic_link_typedef",
	"7D",
	OPT_whatever,
	0,
	NULL,
	"The redefinition of type '%0' should be compatible with that at %1"
    },
    {
	"basic_link_unmatch",
	"G7",
	0,
	0,
	NULL,
	"The type '%0' does not match any declaration of the member '%1'"
    },
    {
	"basic_start_main_over",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.6.1",
#else
	"5.1.2.2",
#endif
	"Can't overload '%0'"
    },
    {
	"basic_start_main_ret",
	"G6",
#ifndef ERR_ALTERNATE
	OPT_error,
#else
	OPT_wall,
#endif
	0,
	NULL,
	"Illegal return type '%0' for '%1'"
    },
    {
	"basic_start_main_proto",
	"G6",
	OPT_wall,
	0,
	NULL,
	"Unorthodox type '%0' for '%1'"
    },
    {
	"basic_start_main_link",
	"64",
#ifndef ERR_ALTERNATE
	OPT_error,
#else
	OPT_wall,
#endif
	0,
	NULL,
	"Can't declare '%0' to be '%1'"
    },
    {
	"basic_start_main_call",
	"7",
	OPT_cpp_error,
	0,
	NULL,
	"Can't call '%0' from within a program"
    },
    {
	"basic_start_main_addr",
	"7",
	OPT_cpp_error,
	0,
	NULL,
	"Can't take the address of '%0'"
    },
    {
	"basic_start_main_fall",
	"7G",
#ifndef ERR_ALTERNATE
	OPT_wall,
#else
	OPT_func_ret_void,
#endif
	0,
	NULL,
	"Implicit 'return 0' in function '%0' which returns '%1'"
    },
    {
	"basic_stc_alloc_ret",
	"6G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.7.3",
#else
	"????",
#endif
	"'%0' should return '%1'"
    },
    {
	"basic_stc_alloc_p1",
	"6G",
	0,
	0,
	NULL,
	"First parameter of '%0' should have type '%1'"
    },
    {
	"basic_stc_alloc_d1",
	"6",
	0,
	0,
	NULL,
	"First parameter of '%0' can't have default argument"
    },
    {
	"basic_stc_alloc_p2",
	"6G",
	OPT_delete_over,
	0,
	NULL,
	"Second parameter of '%0' should have type '%1'"
    },
    {
	"basic_stc_alloc_pn",
	"6",
	OPT_delete_over,
	0,
	NULL,
	"Too many parameters for '%0'"
    },
    {
	"basic_stc_alloc_templ",
	"6",
	0,
	0,
	NULL,
	"Template '%0' should have at least two parameters"
    },
    {
	"basic_stc_alloc_nspace",
	"7",
	0,
	0,
	NULL,
	"Should declare '%0' in global namespace scope"
    },
    {
	"basic_stc_alloc_link",
	"7",
	0,
	0,
	NULL,
	"Can't declare '%0' with internal linkage"
    },
    {
	"basic_stc_dealloc_over",
	"7",
	OPT_delete_over,
	0,
#ifndef ERR_ALTERNATE
	"3.7.3.2",
#else
	"????",
#endif
	"Can't overload '%0'"
    },
    {
	"basic_types_def_incompl",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.9",
#else
	"6.5",
#endif
	"The defined object '%0' must have complete object type"
    },
    {
	"basic_types_par_incompl",
	"7",
	0,
	0,
	NULL,
	"The parameter '%0' must have complete object type"
    },
    {
	"basic_types_tent_incompl",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.9",
#else
	"6.7.2",
#endif
	"The implicitly defined object '%0' must have complete object type"
    },
    {
	"basic_types_obj_func",
	"G",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"3.9",
#else
	"6.1.2.5",
#endif
	"The function type '%0' is not an object type"
    },
    {
	"basic_types_obj_ref",
	"G",
	OPT_whatever,
	0,
	NULL,
	"The reference type '%0' is not an object type"
    },
    {
	"basic_types_incompl",
	"G",
	OPT_whatever,
	0,
	NULL,
	"The type '%0' is incomplete"
    },
    {
	"basic_types_completed",
	"G",
	OPT_complete_struct,
	0,
	NULL,
	"The type '%0' has not been completed in its scope"
    },
    {
	"basic_types_obj_incompl",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"An incomplete type is not a complete object type"
    },
    {
	"basic_types_obj_void",
	"G",
	OPT_ptr_void,
	0,
	NULL,
	"'%0' is not a pointer to a complete object type"
    },
    {
	"basic_fund_void_decl",
	"7G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"3.9.1",
#else
	"6.1.2.5",
#endif
	"The object '%0' declared to have type '%1'"
    },
    {
	"basic_fund_void_mem",
	"7G",
	0,
	0,
	NULL,
	"The class member '%0' declared to have type '%1'"
    },
    {
	"basic_fund_void_exp",
	"G",
	0,
	0,
	NULL,
	"Invalid use of expression of type '%0'"
    },
    {
	"basic_lval_not",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"3.10",
#else
	"6.2.2.1",
#endif
	"Expression is not an lvalue"
    },
    {
	"basic_lval_mod_rvalue",
	NULL,
	0,
	0,
	NULL,
	"Expression should be an lvalue to be modifiable"
    },
    {
	"basic_lval_mod_array",
	NULL,
	0,
	0,
	NULL,
	"Lvalues of array type are not modifiable"
    },
    {
	"basic_lval_mod_func",
	NULL,
	0,
	0,
	NULL,
	"Lvalues of function type are not modifiable"
    },
    {
	"basic_lval_mod_incompl",
	NULL,
	0,
	0,
	NULL,
	"Lvalues of incomplete types are not modifiable"
    },
    {
	"basic_lval_mod_const",
	NULL,
	0,
	0,
	NULL,
	"A 'const' qualified lvalue is not modifiable"
    },
    {
	"basic_lval_mod_member",
	"G",
	OPT_c_error,
	0,
	NULL,
	"A type with a 'const' member, '%0', is not modifiable"
    },
    {
	"conv_lval_incompl",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"4.1",
#else
	"6.2.2.1",
#endif
	"Can't perform lvalue conversion on an incomplete type"
    },
    {
	"conv_array_string",
	NULL,
	OPT_const_string,
	0,
#ifndef ERR_ALTERNATE
	"4.2",
#else
	"6.1.4",
#endif
	"Conversion of string literal to non-'const' type"
    },
    {
	"conv_array_str_mod",
	NULL,
	OPT_const_string,
	0,
	NULL,
	"String literals are not modifiable"
    },
    {
	"conv_qual_cast",
	"3",
	OPT_type_qual_incompat,
	0,
#ifndef ERR_ALTERNATE
	"4.4",
#else
	"6.3.16.1",
#endif
	"Conversion casts away '%0'-ness"
    },
    {
	"conv_qual_multi",
	NULL,
	OPT_type_qual_incompat,
	0,
	NULL,
	"Multi-level qualification conversion should contain 'const' at each level"
    },
    {
	"conv_integral_cast",
	"GG",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"4.7",
#else
	"6.2.1",
#endif
	"Integral conversion from '%0' to '%1'"
    },
    {
	"conv_double_cast",
	"GG",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"4.8",
#else
	"6.2.1",
#endif
	"Floating point conversion from '%0' to '%1'"
    },
    {
	"conv_fpint_trunc",
	"GG",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"4.9",
#else
	"6.2.1",
#endif
	"Floating point truncation from '%0' to '%1'"
    },
    {
	"conv_fpint_float",
	"GG",
	OPT_whatever,
	0,
	NULL,
	"Integer to floating point conversion from '%0' to '%1'"
    },
    {
	"conv_fpint_large",
	"5",
	OPT_int_overflow,
	0,
	NULL,
	"Integer overflow in truncation of '%0'"
    },
    {
	"conv_ptr_null_complex",
	NULL,
	OPT_ptr_operator,
	0,
#ifndef ERR_ALTERNATE
	"4.10",
#else
	"6.2.2.3",
#endif
	"Complex null pointer constant"
    },
    {
	"conv_ptr_nonzero",
	"GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"4.10",
#else
	"6.3.4",
#endif
	"Conversion of nonzero value of type '%0' to type '%1'"
    },
    {
	"conv_ptr_cast",
	"GG",
	0,
	0,
	NULL,
	"Pointer conversion from '%0' to '%1'"
    },
    {
	"conv_ptr_incompat",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Types in pointer conversion should be compatible"
    },
    {
	"conv_ptr_ambiguous",
	NULL,
	0,
	0,
	NULL,
	"Base class in pointer conversion must be unambiguous"
    },
    {
	"conv_ptr_access",
	NULL,
	0,
	0,
	NULL,
	"Accessible base required in base class conversion"
    },
    {
	"conv_ptr_common",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't bring incompatible types to a common pointer type"
    },
    {
	"conv_ptr_gen",
	"G",
	OPT_gen_ptr_char,
	0,
	NULL,
	"Type '%0' used as generic pointer type"
    },
    {
	"conv_mem_nonzero",
	"GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"4.11",
#else
	"????",
#endif
	"Conversion of nonzero value of type '%0' to type '%1'"
    },
    {
	"conv_mem_cast",
	"GG",
	0,
	0,
	NULL,
	"Pointer to member conversion from '%0' to '%1'"
    },
    {
	"conv_mem_ambiguous",
	NULL,
	0,
	0,
	NULL,
	"Base class in pointer to member conversion must be unambiguous"
    },
    {
	"conv_mem_virtual",
	NULL,
	0,
	0,
	NULL,
	"Base class in pointer to member conversion can't be virtual"
    },
    {
	"conv_mem_common",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't bring incompatible types to a common pointer to member type"
    },
    {
	"conv_bool_cast",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"4.12",
#else
	"6.3",
#endif
	"Can't convert expression of type '%0' to a boolean"
    },
    {
	"conv_bool_assign",
	NULL,
	OPT_bool_assign,
	0,
	NULL,
	"Assignment in boolean value"
    },
    {
	"expr_paren_left",
	"88",
	OPT_paren,
	0,
#ifndef ERR_ALTERNATE
	"5",
#else
	"6.3",
#endif
	"Operator precedence is '( a %0 b ) %1 c'"
    },
    {
	"expr_paren_right",
	"88",
	OPT_paren,
	0,
	NULL,
	"Operator precedence is 'a %0 ( b %1 c )'"
    },
    {
	"expr_convert_op",
	"M8",
	OPT_whatever,
	0,
	NULL,
	"Conversion of operand %0 in operation '%1'"
    },
    {
	"expr_prim_this",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.1",
#else
	"6.3.1",
#endif
	"'this' is only in scope in non-static member functions"
    },
    {
	"expr_prim_mem",
	"9",
	0,
	0,
	NULL,
	"Can't use non-static member '%0' in this context"
    },
    {
	"expr_prim_type",
	"9",
	0,
	0,
	NULL,
	"'%0' denotes a type, not an expression"
    },
    {
	"expr_sub_ptr_op",
	"GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.1",
#else
	"6.3.2.1",
#endif
	"One operand of '[]' should have pointer type, not '%0' and '%1'"
    },
    {
	"expr_sub_int_op",
	"G",
	0,
	0,
	NULL,
	"Non-pointer operand of '[]' should have integral type, not '%0'"
    },
    {
	"expr_sub_char_op",
	"G",
	OPT_ptr_operator,
	0,
	NULL,
	"Non-pointer operand of '[]' has type '%0'"
    },
    {
	"expr_sub_incompl",
	NULL,
	0,
	0,
	NULL,
	"Pointer to complete object type expected in '[]'"
    },
    {
	"expr_call_func",
	"9",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.2.2",
#else
	"6.3.2.2",
#endif
	"In call of function '%0'"
    },
    {
	"expr_call_op",
	"G",
	0,
	0,
	NULL,
	"Invalid function type, '%0'"
    },
    {
	"expr_call_ret",
	NULL,
	0,
	0,
	NULL,
	"Function return type should be a complete object type or 'void'"
    },
    {
	"expr_call_mem",
	"9",
	0,
	0,
	NULL,
	"Non-static member function '%0' should have an associated object"
    },
    {
	"expr_call_undecl",
	"9",
	OPT_func_impl,
	0,
	NULL,
	"Implicit declaration of function '%0'"
    },
    {
	"expr_call_arg",
	"M",
	OPT_whatever,
	0,
	NULL,
	"Argument %0 is converted to parameter type"
    },
    {
	"expr_call_ellipsis",
	"M",
	OPT_whatever,
	0,
	NULL,
	"Argument %0 is converted to its promotion type"
    },
    {
	"expr_call_weak_arg",
	"MD",
	OPT_weak,
	0,
	NULL,
	"Incompatible type for argument %0 (see %1)"
    },
    {
	"expr_call_args_exact",
	"MNM",
	0,
	0,
	NULL,
	"Function call has %0 argument%1, it should have %2"
    },
    {
	"expr_call_args_range",
	"MNMM",
	0,
	0,
	NULL,
	"Function call has %0 argument%1, it should have between %2 and %3"
    },
    {
	"expr_call_args_min",
	"MNM",
	0,
	0,
	NULL,
	"Function call has %0 argument%1, it should have at least %2"
    },
    {
	"expr_call_struct",
	"G",
	OPT_wall,
	0,
	NULL,
	"Argument of type '%0' is passed as a data structure"
    },
    {
	"expr_call_ell_func",
	NULL,
	0,
	0,
	NULL,
	"Can only use '...' in function defined using '...'"
    },
    {
	"expr_call_ell_exp",
	NULL,
	OPT_ellipsis_ident,
	0,
	NULL,
	"'...' used as an expression"
    },
    {
	"expr_type_conv_incompl",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.3",
#else
	"6.3.4",
#endif
	"Complete object type required in type conversion"
    },
    {
	"expr_type_conv_array",
	"G",
	0,
	0,
	NULL,
	"Can't use array type '%0' in function-style cast"
    },
    {
	"expr_type_conv_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using a function-style cast"
    },
    {
	"expr_type_conv_many",
	"G",
	0,
	0,
	NULL,
	"A function-style cast with more than one argument requires a class type, not '%0'"
    },
    {
	"expr_pseudo_type",
	"GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.4",
#else
	"????",
#endif
	"Type mismatch for pseudo-destructor '%0::~%1'"
    },
    {
	"expr_pseudo_scalar",
	"G",
	0,
	0,
	NULL,
	"Can only have pseudo-destructor for scalar types, not '%0'"
    },
    {
	"expr_pseudo_obj",
	"6G",
	0,
	0,
	NULL,
	"Pseudo-destructor '%0' applied to type '%1'"
    },
    {
	"expr_pseudo_args",
	"6",
	0,
	0,
	NULL,
	"Can't give arguments to pseudo-destructor '%0'"
    },
    {
	"expr_ref_arrow_op",
	"GJ",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.5",
#else
	"6.3.2.3",
#endif
	"First operand of '->' should have type pointer to %1, not '%0'"
    },
    {
	"expr_ref_dot_op",
	"GJ",
	0,
	0,
	NULL,
	"First operand of '.' should have %1 type, not '%0'"
    },
    {
	"expr_ref_arrow_dot",
	"G",
	0,
	0,
	NULL,
	"Should use '.' with operand of type '%0', not '->'"
    },
    {
	"expr_ref_dot_arrow",
	"G",
	0,
	0,
	NULL,
	"Should use '->' with operand of type '%0', not '.'"
    },
    {
	"expr_ref_incompl",
	"81",
	0,
	0,
	NULL,
	"The %1 associated with the operand of '%0' should be complete"
    },
    {
	"expr_ref_select",
	"8J",
	0,
	0,
	NULL,
	"Second operand of '%0' should be a member of the %1 given by the first operand"
    },
    {
	"expr_ref_call",
	NULL,
	0,
	0,
	NULL,
	"Can only use member function selector in function call"
    },
    {
	"expr_ref_qual",
	"E7",
	OPT_none,
	0,
	NULL,
	"Illegal member access specifier, '%0%1'"
    },
    {
	"expr_ref_func_type",
	"2",
	0,
	0,
	NULL,
	"Member function called with unrelated class '%0'"
    },
    {
	"expr_ref_type",
	"7",
	0,
	0,
	NULL,
	"'%0' denotes a type member"
    },
    {
	"expr_post_incr_mod",
	"8",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.2.6",
#else
	"6.3.2.4",
#endif
	"Operand of postfix '%0' should be modifiable"
    },
    {
	"expr_post_incr_op",
	"8G",
	0,
	0,
	NULL,
	"Operand of postfix '%0' should have arithmetic or pointer type, not '%1'"
    },
    {
	"expr_post_incr_incompl",
	"8",
	0,
	0,
	NULL,
	"Pointer to complete object type expected in postfix '%0' operation"
    },
    {
	"expr_post_incr_bool_inc",
	"8G",
	OPT_int_operator,
	0,
	NULL,
	"Use of postfix '%0' on type '%1' is deprecated"
    },
    {
	"expr_post_incr_bool_dec",
	"8G",
	0,
	0,
	NULL,
	"Postfix '%0' can't be applied to type '%1'"
    },
    {
	"expr_cast_dynam_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.7",
#else
	"6.3.4",
#endif
	"Can't define a type in a 'dynamic_cast' expression"
    },
    {
	"expr_cast_dynam_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using 'dynamic_cast'"
    },
    {
	"expr_cast_dynam_type",
	"G",
	0,
	0,
	NULL,
	"Pointer or reference to complete class expected in 'dynamic_cast', not '%0'"
    },
    {
	"expr_cast_dynam_ptr",
	"G",
	0,
	0,
	NULL,
	"Operand to 'dynamic_cast' should be a pointer to complete class, not '%0'"
    },
    {
	"expr_cast_dynam_ref",
	"G",
	0,
	0,
	NULL,
	"Operand to 'dynamic_cast' should be an lvalue of complete class type, not '%0'"
    },
    {
	"expr_cast_dynam_poly",
	"2",
	0,
	0,
	NULL,
	"Operand to 'dynamic_cast' should have polymorphic class, not '%0'"
    },
    {
	"expr_typeid_index",
	"8",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"5.2.8",
#else
	"????",
#endif
	"Index in '%0' expression is unevaluated"
    },
    {
	"expr_typeid_side",
	"8",
	OPT_wall,
	0,
	NULL,
	"Side effects in unevaluated '%0' expression"
    },
    {
	"expr_typeid_typedef",
	"8",
	0,
	0,
	NULL,
	"Can't define a type in a '%0' expression"
    },
    {
	"expr_typeid_incompl",
	"8",
	0,
	0,
	NULL,
	"Can't have incomplete class in a '%0' expression"
    },
    {
	"expr_typeid_vtable",
	"8",
	0,
	0,
	NULL,
	"Can only apply '%0' to polymorphic types"
    },
    {
	"expr_cast_stat_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.9",
#else
	"6.3.4",
#endif
	"Can't define a type in a 'static_cast' expression"
    },
    {
	"expr_cast_stat_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using 'static_cast'"
    },
    {
	"expr_cast_stat_int_enum",
	"GG",
	0,
	0,
	NULL,
	"Integer to enumeration conversion from '%0' to '%1'"
    },
    {
	"expr_cast_stat_enum_enum",
	"GG",
	0,
	0,
	NULL,
	"Conversion between different enumeration types '%0' and '%1'"
    },
    {
	"expr_cast_stat_virt",
	NULL,
	0,
	0,
	NULL,
	"Base class in pointer up-cast can't be virtual"
    },
    {
	"expr_cast_stat_func",
	"G",
	0,
	0,
	NULL,
	"Can't cast to the function type '%0'"
    },
    {
	"expr_cast_reint_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.10",
#else
	"6.3.4",
#endif
	"Can't define a type in a 'reinterpret_cast' expression"
    },
    {
	"expr_cast_reint_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using 'reinterpret_cast'"
    },
    {
	"expr_cast_reint_int_ptr",
	"GG",
	0,
	0,
	NULL,
	"Integer to pointer conversion from '%0' to '%1'"
    },
    {
	"expr_cast_reint_ptr_int",
	"GG",
	0,
	0,
	NULL,
	"Pointer to integer conversion from '%0' to '%1'"
    },
    {
	"expr_cast_reint_func_ptr",
	"GG",
	OPT_conv_ptr_func,
	0,
	NULL,
	"Can't convert function pointer '%0' to non-function pointer '%1'"
    },
    {
	"expr_cast_reint_mem_func",
	"GG",
	0,
	0,
	NULL,
	"Pointer to member function '%0' converted to pointer to function '%1'"
    },
    {
	"expr_cast_const_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.2.11",
#else
	"6.3.4",
#endif
	"Can't define a type in a 'const_cast' expression"
    },
    {
	"expr_cast_const_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using 'const_cast'"
    },
    {
	"expr_unary_op_indir_op",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.3.1",
#else
	"6.3.3.2",
#endif
	"Operand of unary '*' should have pointer type, not '%0'"
    },
    {
	"expr_unary_op_indir_void",
	"G",
	OPT_none,
	0,
	NULL,
	"Can't apply unary '*' to a operand of type '%0'"
    },
    {
	"expr_unary_op_indir_null",
	"8",
	OPT_ptr_operator,
	0,
	NULL,
	"'%0' is undefined on null pointers"
    },
    {
	"expr_unary_op_ref_lvalue",
	NULL,
	0,
	0,
	NULL,
	"Operand of unary '&' should be an lvalue"
    },
    {
	"expr_unary_op_ref_void",
	"G",
	0,
	0,
	NULL,
	"Can't apply unary '&' to a operand of type '%0'"
    },
    {
	"expr_unary_op_ref_incompl",
	NULL,
	OPT_none,
	0,
	NULL,
	"Operand of unary '&' can't be incomplete"
    },
    {
	"expr_unary_op_ref_post",
	"7",
	OPT_wall,
	0,
	NULL,
	"Function '%0' declared in class previously taken address of as incomplete type"
    },
    {
	"expr_unary_op_ref_bitf",
	NULL,
	0,
	0,
	NULL,
	"Operand of unary '&' can't be a bitfield"
    },
    {
	"expr_unary_op_ref_register",
	"7",
	OPT_addr_register,
	0,
	NULL,
	"Can't take the address of the 'register' variable '%0'"
    },
    {
	"expr_unary_op_ref_paren",
	NULL,
	0,
	0,
	NULL,
	"Member operand to unary '&' can't be parenthesized"
    },
    {
	"expr_unary_op_ref_full",
	NULL,
	OPT_none,
	0,
	NULL,
	"Member operand to unary '&' can't be a fully qualified identifier"
    },
    {
	"expr_unary_op_ref_unqual",
	NULL,
	0,
	0,
	NULL,
	"Member operand to unary '&' must be a qualified identifier"
    },
    {
	"expr_unary_op_uplus_op",
	"8G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.3.1",
#else
	"6.3.3.3",
#endif
	"Operand of unary '%0' should have arithmetic or pointer type, not '%1'"
    },
    {
	"expr_unary_op_uminus_op",
	"8G",
	0,
	0,
	NULL,
	"Operand of unary '%0' should have arithmetic type, not '%1'"
    },
    {
	"expr_unary_op_compl_op",
	"8G",
	0,
	0,
	NULL,
	"Operand of '%0' should have integral type, not '%1'"
    },
    {
	"expr_unary_op_not_op",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Operand of '!' is converted to a boolean"
    },
    {
	"expr_pre_incr_mod",
	"8",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.3.2",
#else
	"6.3.3.1",
#endif
	"Operand of prefix '%0' should be modifiable"
    },
    {
	"expr_pre_incr_op",
	"8G",
	0,
	0,
	NULL,
	"Operand of prefix '%0' should have arithmetic or pointer type, not '%1'"
    },
    {
	"expr_pre_incr_incompl",
	"8",
	0,
	0,
	NULL,
	"Pointer to complete object type expected in prefix '%0' operation"
    },
    {
	"expr_pre_incr_bool_inc",
	"8G",
	OPT_int_operator,
	0,
	NULL,
	"Use of prefix '%0' on type '%1' is deprecated"
    },
    {
	"expr_pre_incr_bool_dec",
	"8G",
	0,
	0,
	NULL,
	"Postfix '%0' can't be applied to type '%1'"
    },
    {
	"expr_sizeof_func",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.3.3",
#else
	"6.3.3.4",
#endif
	"Can't apply '%0' to a function type"
    },
    {
	"expr_sizeof_bitf",
	"8",
	0,
	0,
	NULL,
	"Can't apply '%0' to a bitfield type"
    },
    {
	"expr_sizeof_incompl",
	"8",
	0,
	0,
	NULL,
	"Can't apply '%0' to an incomplete type"
    },
    {
	"expr_sizeof_typedef",
	"8",
	OPT_cpp_error,
	0,
	NULL,
	"Can't define a type in a '%0' expression"
    },
    {
	"expr_sizeof_side",
	"8",
	OPT_wall,
	0,
	NULL,
	"Side effects in unevaluated '%0' expression"
    },
    {
	"expr_new_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.3.4",
#else
	"????",
#endif
	"Can't declare types in a 'new' expression"
    },
    {
	"expr_new_incompl",
	NULL,
	0,
	0,
	NULL,
	"Type in 'new' expression should be a complete object type"
    },
    {
	"expr_new_abstract",
	NULL,
	0,
	0,
	NULL,
	"Type in 'new' expression can't be abstract"
    },
    {
	"expr_new_dim",
	"G",
	0,
	0,
	NULL,
	"Array bound in 'new' expression should have integral type, not '%0'"
    },
    {
	"expr_new_init",
	"8",
	OPT_whatever,
	0,
	NULL,
	"In '%0' expression initializer"
    },
    {
	"expr_new_array_init",
	"8",
	0,
	0,
	NULL,
	"Can't have an initializer in '%0' expression"
    },
    {
	"expr_delete_ptr",
	"8G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.3.5",
#else
	"????",
#endif
	"Operand of '%0' expression should have pointer type, not '%1'"
    },
    {
	"expr_delete_conv",
	"8",
	OPT_whatever,
	0,
	NULL,
	"Operand of '%0' expression is converted to a pointer type"
    },
    {
	"expr_delete_void",
	"8G",
	OPT_wall,
	0,
	NULL,
	"Operand of '%0' expression can't have type '%1'"
    },
    {
	"expr_delete_obj",
	"8",
	0,
	0,
	NULL,
	"Pointer in '%0' expression should be to an object type"
    },
    {
	"expr_delete_incompl",
	"8",
	OPT_wall,
	0,
	NULL,
	"Pointer in '%0' expression should be to a complete type"
    },
    {
	"expr_delete_post",
	"7",
	OPT_wall,
	0,
	NULL,
	"Function '%0' declared in class deleted through pointer to incomplete type"
    },
    {
	"expr_delete_const",
	"3",
	OPT_none,
	0,
	NULL,
	"Can't delete a '%0' object"
    },
    {
	"expr_delete_array",
	"8",
	0,
	0,
	NULL,
	"The array bound in '%0' is anachronistic"
    },
    {
	"expr_cast_expl_used",
	NULL,
	OPT_cast_explicit,
	0,
#ifndef ERR_ALTERNATE
	"5.4",
#else
	"6.3.4",
#endif
	"Explicit cast expression"
    },
    {
	"expr_cast_expl_typedef",
	NULL,
	OPT_cpp_error,
	0,
	NULL,
	"Can't define a type in a cast expression"
    },
    {
	"expr_cast_expl_scalar",
	"G",
	OPT_c_error,
	0,
	NULL,
	"Can't cast to the non-scalar type '%0'"
    },
    {
	"expr_cast_invalid",
	"GG",
	0,
	0,
	NULL,
	"Illegal conversion from type '%0' to type '%1'"
    },
    {
	"expr_cast_expl_bad",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion using an explicit cast"
    },
    {
	"expr_cast_ref",
	"GG",
	OPT_whatever,
	0,
	NULL,
	"'cast < %0 > ( a )' is equivalent to '*cast < %1 > ( &a )'"
    },
    {
	"expr_mptr_oper_arrow_op",
	"9G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.5",
#else
	"????",
#endif
	"First operand of '->*' should have type pointer to '%0', not '%1'"
    },
    {
	"expr_mptr_oper_dot_op",
	"9G",
	0,
	0,
	NULL,
	"First operand of '.*' should have type '%0', not '%1'"
    },
    {
	"expr_mptr_oper_arrow_dot",
	"G",
	0,
	0,
	NULL,
	"Should use '.*' with operand of type '%0', not '->*'"
    },
    {
	"expr_mptr_oper_dot_arrow",
	"G",
	0,
	0,
	NULL,
	"Should use '->*' with operand of type '%0', not '.*'"
    },
    {
	"expr_mptr_oper_op2",
	"8G",
	0,
	0,
	NULL,
	"Second operand of '%0' should have pointer to member type, not '%1'"
    },
    {
	"expr_mptr_oper_compl",
	"8",
	0,
	0,
	NULL,
	"Class in '%0' should be complete"
    },
    {
	"expr_mptr_oper_ambig",
	"8",
	0,
	0,
	NULL,
	"Base class conversion in '%0' must be unambiguous"
    },
    {
	"expr_mptr_oper_call",
	NULL,
	0,
	0,
	NULL,
	"Can only use function member selector in a function call"
    },
    {
	"expr_mptr_oper_null",
	"8",
	OPT_ptr_operator,
	0,
	NULL,
	"'%0' is undefined on null pointer to members"
    },
    {
	"expr_mptr_oper_paren",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Possible precedence error involving '.*' or '->*'"
    },
    {
	"expr_mul_mul_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.6",
#else
	"6.3.5",
#endif
	"Operands of binary '%0' should be arithmetic, not '%1' and '%2'"
    },
    {
	"expr_mul_rem_op",
	"8GG",
	0,
	0,
	NULL,
	"Operands of '%0' should be integral, not '%1' and '%2'"
    },
    {
	"expr_mul_div_zero",
	"8",
	OPT_int_overflow,
	0,
	NULL,
	"Division operation '%0' with zero divisor is undefined"
    },
    {
	"expr_mul_div_neg",
	"8B",
	OPT_int_operator,
	0,
	NULL,
	"Division operation '%0' involving negative operand '%1' is implementation dependent"
    },
    {
	"expr_add_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.7",
#else
	"6.3.6",
#endif
	"Can't perform binary '%0' on operands of types '%1' and '%2'"
    },
    {
	"expr_add_incompl",
	"8",
	0,
	0,
	NULL,
	"Pointer to complete object type expected in binary '%0'"
    },
    {
	"expr_add_ptrdiff",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Pointers in '-' should be to compatible types"
    },
    {
	"expr_add_array",
	"BG8",
	OPT_ptr_operator,
	0,
	NULL,
	"Can't address element '%0' of array of type '%1' using '%2'"
    },
    {
	"expr_add_different",
	NULL,
	OPT_ptr_operator,
	0,
	NULL,
	"Pointers in '-' should be to elements of the same array"
    },
    {
	"expr_shift_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.8",
#else
	"6.3.7",
#endif
	"Operands of '%0' should be integral, not '%1' and '%2'"
    },
    {
	"expr_shift_op1_sign",
	"8",
	OPT_int_operator,
	0,
	NULL,
	"Shift operation '%0' with signed first operand is implementation dependent"
    },
    {
	"expr_shift_op1_neg",
	"8B",
	OPT_int_operator,
	0,
	NULL,
	"Shift operation '%0' with negative first operand '%1' is implementation dependent"
    },
    {
	"expr_shift_op2_neg",
	"8B",
	OPT_int_operator,
	0,
	NULL,
	"Shift operation '%0' with negative second operand '%1' is undefined"
    },
    {
	"expr_shift_op2_big",
	"8BG",
	OPT_int_operator,
	0,
	NULL,
	"Shift operation '%0' second operand '%1' exceeds the minimum size of first operand type, '%2'"
    },
    {
	"expr_rel_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.9",
#else
	"6.3.8",
#endif
	"Can't perform '%0' on operands of types '%1' and '%2'"
    },
    {
	"expr_rel_nonzero",
	"8GG",
	0,
	0,
	NULL,
	"Can't perform '%0' on an operand of type '%1' and a nonzero value of type '%2'"
    },
    {
	"expr_rel_ptr",
	"8",
	OPT_whatever,
	0,
	NULL,
	"Pointer operands of '%0' are converted to a common type"
    },
    {
	"expr_rel_ptr_void",
	"8GG",
#ifndef ERR_ALTERNATE
	OPT_ptr_operator,
#else
	OPT_error,
#endif
	0,
	NULL,
	"Comparison '%0' performed on operands of types '%1' and '%2'"
    },
    {
	"expr_rel_paren",
	"88",
	OPT_paren,
	0,
	NULL,
	"Expressions like 'a %0 b %1 c' do not have their mathematical meaning"
    },
    {
	"expr_rel_true",
	NULL,
	OPT_int_operator,
	0,
	NULL,
	"The relation 'a >= 0' is always true for unsigned comparisons"
    },
    {
	"expr_rel_false",
	NULL,
	OPT_int_operator,
	0,
	NULL,
	"The relation 'a < 0' is always false for unsigned comparisons"
    },
    {
	"expr_rel_null",
	"8",
#ifndef ERR_ALTERNATE
	OPT_ptr_operator,
#else
	OPT_error,
#endif
	0,
	NULL,
	"Can't have null pointer operand to '%0'"
    },
    {
	"expr_eq_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.10",
#else
	"6.3.9",
#endif
	"Can't perform '%0' on operands of types '%1' and '%2'"
    },
    {
	"expr_eq_nonzero",
	"8GG",
	0,
	0,
	NULL,
	"Can't perform '%0' on an operand of type '%1' and a nonzero value of type '%2'"
    },
    {
	"expr_eq_ptr",
	"8",
	OPT_whatever,
	0,
	NULL,
	"Pointer operands of '%0' are converted to a common type"
    },
    {
	"expr_eq_mptr",
	"8",
	OPT_whatever,
	0,
	NULL,
	"Pointer to member operands of '%0' are converted to a common type"
    },
    {
	"expr_eq_float",
	"8",
	OPT_int_operator,
	0,
	NULL,
	"Floating point '%0' operation"
    },
    {
	"expr_bit_and_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.11",
#else
	"6.3.10",
#endif
	"Operands of binary '%0' should be integral, not '%1' and '%2'"
    },
    {
	"expr_xor_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.12",
#else
	"6.3.11",
#endif
	"Operands of '%0' should be integral, not '%1' and '%2'"
    },
    {
	"expr_or_op",
	"8GG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"5.13",
#else
	"6.3.12",
#endif
	"Operands of '%0' should be integral, not '%1' and '%2'"
    },
    {
	"expr_log_and_op",
	"8",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.14",
#else
	"6.3.13",
#endif
	"Operands of '%0' are converted to booleans"
    },
    {
	"expr_log_or_op",
	"8",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.15",
#else
	"6.3.14",
#endif
	"Operands of '%0' are converted to booleans"
    },
    {
	"expr_cond_bool",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.16",
#else
	"6.3.15",
#endif
	"The condition of '?:' is converted to a boolean"
    },
    {
	"expr_cond_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant condition in '?:' expression"
    },
    {
	"expr_cond_op",
	"GG",
	0,
	0,
	NULL,
	"Can't perform '?:' on operands of types '%0' and '%1'"
    },
    {
	"expr_cond_qual",
	"GG",
	OPT_none,
	0,
	NULL,
	"Qualifier mismatch for operands of types '%0' and '%1' in '?:'"
    },
    {
	"expr_cond_nonzero",
	"GG",
	0,
	0,
	NULL,
	"Can't perform '?:' on an operand of type '%0' and a nonzero value of type '%1'"
    },
    {
	"expr_cond_ptr",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Pointer operands of '?:' are converted to a common type"
    },
    {
	"expr_cond_mptr",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Pointer to member operands of '?:' are converted to a common type"
    },
    {
	"expr_ass_mod",
	"8",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.17",
#else
	"6.3.16",
#endif
	"Left operand of '%0' should be modifiable"
    },
    {
	"expr_ass_op",
	"8GG",
	0,
	0,
	NULL,
	"Can't perform '%0' on operands of types '%1' and '%2'"
    },
    {
	"expr_ass_incompl",
	"8",
	0,
	0,
	NULL,
	"Pointer to complete object type expected in '%0'"
    },
    {
	"expr_ass_conv",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion by assignment"
    },
    {
	"expr_ass_twice",
	"7",
	OPT_variable,
	0,
	NULL,
	"Variable '%0' modified twice in expression"
    },
    {
	"expr_const_bad",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"5.19",
#else
	"6.4",
#endif
	"Illegal integer constant expression"
    },
    {
	"expr_const_int",
	"G",
	OPT_whatever,
	0,
	NULL,
	"Constant expression should have integral type, not '%0'"
    },
    {
	"expr_const_off_mem",
	"9",
	0,
	0,
	NULL,
	"Member '%0' doesn't designate a constant offset"
    },
    {
	"expr_const_off_array",
	"G",
	0,
	0,
	NULL,
	"Array type required in constant offset, not '%0'"
    },
    {
	"expr_const_off_dim",
	NULL,
	0,
	0,
	NULL,
	"Constant index required in constant offset"
    },
    {
	"stmt_stmt_unreach",
	NULL,
	OPT_reached,
	0,
#ifndef ERR_ALTERNATE
	"6",
#else
	"6.6",
#endif
	"Statement not reached"
    },
    {
	"stmt_stmt_empty",
	"8",
	OPT_empty_body,
	0,
	NULL,
	"Empty body in '%0' statement"
    },
    {
	"stmt_label_redef",
	"79D",
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.1",
#else
	"6.6.1",
#endif
	"Label '%0' already defined in function '%1' (at %2)"
    },
    {
	"stmt_label_unused",
	"79",
	OPT_reached,
	0,
	NULL,
	"Label '%0' defined but not used in function '%1'"
    },
    {
	"stmt_label_case",
	NULL,
	0,
	0,
	NULL,
	"'case' should be inside a 'switch' statement"
    },
    {
	"stmt_label_default",
	NULL,
	0,
	0,
	NULL,
	"'default' should be inside a 'switch' statement"
    },
    {
	"stmt_label_fall",
	"8",
	OPT_case_fall,
	0,
	NULL,
	"Fall into '%0' statement"
    },
    {
	"stmt_expr_discard_func",
	NULL,
	OPT_discard_func,
	0,
#ifndef ERR_ALTERNATE
	"6.2",
#else
	"6.6.3",
#endif
	"Discarded function return"
    },
    {
	"stmt_expr_discard_val",
	NULL,
	OPT_discard_value,
	0,
	NULL,
	"Discarded value"
    },
    {
	"stmt_expr_incompl",
	NULL,
	OPT_none,
	0,
	NULL,
	"Incomplete value discarded"
    },
    {
	"stmt_select_type",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.4",
#else
	"6.6.4",
#endif
	"Invalid type for condition declaration, '%0'"
    },
    {
	"stmt_select_typedef",
	NULL,
	0,
	0,
	NULL,
	"Can't declare a type in a condition declaration"
    },
    {
	"stmt_if_cond",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"6.4.1",
#else
	"6.6.4.1",
#endif
	"Condition of an 'if' statement is converted to a boolean"
    },
    {
	"stmt_if_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant condition in 'if' statement"
    },
    {
	"stmt_if_no_else",
	NULL,
	OPT_cond_default,
	0,
	NULL,
	"No 'else' in 'if' statement"
    },
    {
	"stmt_switch_control",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.4.2",
#else
	"6.6.4.2",
#endif
	"Control expression of a 'switch' statement should have integral type, not '%0'"
    },
    {
	"stmt_switch_conv",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Control expression of a 'switch' statement is converted to an integral type"
    },
    {
	"stmt_switch_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant control expression in 'switch' statement"
    },
    {
	"stmt_switch_case_const",
	NULL,
	0,
	0,
	NULL,
	"Expression in a 'case' statement should be an integer constant"
    },
    {
	"stmt_switch_case_dup",
	"BD",
	0,
	0,
	NULL,
	"'case %0' already defined in 'switch' (at %1)"
    },
    {
	"stmt_switch_default_dup",
	"D",
	0,
	0,
	NULL,
	"'default' already defined in 'switch' (at %0)"
    },
    {
	"stmt_switch_case_not",
	"B",
	0,
	0,
	NULL,
	"'case %0' not defined in 'switch'"
    },
    {
	"stmt_switch_default_not",
	NULL,
	0,
	0,
	NULL,
	"'default' not defined in 'switch'"
    },
    {
	"stmt_switch_exhaust_none",
	NULL,
	0,
	0,
	NULL,
	"No cases in exhaustive 'switch' statement"
    },
    {
	"stmt_switch_exhaust_default",
	NULL,
	0,
	0,
	NULL,
	"Can't have 'default' in exhaustive 'switch' statement"
    },
    {
	"stmt_switch_case_none",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"No cases in 'switch' statement"
    },
    {
	"stmt_switch_no_default",
	NULL,
	OPT_cond_default,
	0,
	NULL,
	"No 'default' in 'switch' statement"
    },
    {
	"stmt_switch_case_enum",
	"9",
	OPT_enum_switch,
	0,
	NULL,
	"Enumerator '%0' not covered in 'switch'"
    },
    {
	"stmt_switch_case_extra",
	"BG",
	OPT_enum_switch,
	0,
	NULL,
	"'case %0' is not a valid value for type '%1'"
    },
    {
	"stmt_while_cond",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"6.5.1",
#else
	"6.6.5.1",
#endif
	"Condition of a 'while' statement is converted to a boolean"
    },
    {
	"stmt_while_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant condition in 'while' statement"
    },
    {
	"stmt_do_cond",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"6.5.2",
#else
	"6.6.5.2",
#endif
	"Condition of a 'do' statement is converted to a boolean"
    },
    {
	"stmt_do_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant condition in 'do' statement"
    },
    {
	"stmt_for_cond",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"6.5.3",
#else
	"6.6.5.3",
#endif
	"Condition of a 'for' statement is converted to a boolean"
    },
    {
	"stmt_for_const",
	NULL,
	OPT_const_cond,
	0,
	NULL,
	"Constant condition in 'for' statement"
    },
    {
	"stmt_for_init",
	"7",
	OPT_for_scope,
	0,
	NULL,
	"Variable '%0' used outside its 'for' statement"
    },
    {
	"stmt_break_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.6.1",
#else
	"6.6.6.3",
#endif
	"'break' should be inside an iteration or 'switch' statement"
    },
    {
	"stmt_cont_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.6.2",
#else
	"6.6.6.2",
#endif
	"'continue' should be inside an iteration statement"
    },
    {
	"stmt_return_void",
	"7G",
	OPT_func_ret_void,
	0,
#ifndef ERR_ALTERNATE
	"6.6.3",
#else
	"6.6.6.4",
#endif
	"'return' with no value in function '%0' which returns '%1'"
    },
    {
	"stmt_return_none",
	"7G",
	0,
	0,
	NULL,
	"'return' with value in function '%0' which returns '%1'"
    },
    {
	"stmt_return_bottom",
	"7G",
	0,
	0,
	NULL,
	"Can't return from function '%0' which returns '%1'"
    },
    {
	"stmt_return_conv",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"'return' value is converted to function return type"
    },
    {
	"stmt_return_fall",
	"7G",
	OPT_func_ret_void,
	0,
	NULL,
	"Fall out of function '%0' which returns '%1'"
    },
    {
	"stmt_return_auto",
	"98",
	OPT_ptr_operator,
	0,
	NULL,
	"Reference to local variable '%0' in '%1'"
    },
    {
	"stmt_goto_undef",
	"79",
	0,
	0,
#ifndef ERR_ALTERNATE
	"6.6.4",
#else
	"6.6.6.1",
#endif
	"Label '%0' used but not defined in function '%1'"
    },
    {
	"stmt_goto_case",
	"8",
	0,
	0,
	NULL,
	"Can't have 'goto %0'"
    },
    {
	"stmt_dcl_start",
	NULL,
	OPT_c_error,
	0,
#ifndef ERR_ALTERNATE
	"6.7",
#else
	"6.6.2",
#endif
	"Declaration statement should be at start of block"
    },
    {
	"stmt_dcl_bypass_lab",
	"77",
#ifndef ERR_ALTERNATE
	OPT_error,
#else
	OPT_variable,
#endif
	0,
	NULL,
	"Jump to label '%0' bypasses initialization of '%1'"
    },
    {
	"stmt_dcl_bypass_case",
	"B7",
#ifndef ERR_ALTERNATE
	OPT_error,
#else
	OPT_variable,
#endif
	0,
	NULL,
	"Jump to 'case %0' bypasses initialization of '%1'"
    },
    {
	"stmt_dcl_bypass_default",
	"7",
#ifndef ERR_ALTERNATE
	OPT_error,
#else
	OPT_variable,
#endif
	0,
	NULL,
	"Jump to 'default' bypasses initialization of '%0'"
    },
    {
	"stmt_dcl_unused",
	"9",
	OPT_variable,
	0,
	NULL,
	"Variable '%0' not used"
    },
    {
	"stmt_dcl_unset",
	"9",
	OPT_variable,
	0,
	NULL,
	"Variable '%0' may be used without being set"
    },
    {
	"stmt_dcl_reset",
	"9",
	OPT_variable,
	0,
	NULL,
	"Variable '%0' not used since previous assignment"
    },
    {
	"dcl_dcl_none",
	NULL,
	OPT_decl_none,
	0,
#ifndef ERR_ALTERNATE
	"7",
#else
	"6.7",
#endif
	"No declarations in translation unit"
    },
    {
	"dcl_dcl_empty",
	NULL,
	OPT_decl_empty,
	0,
#ifndef ERR_ALTERNATE
	"7",
#else
	"6.5",
#endif
	"Every declaration must introduce a name"
    },
    {
	"dcl_dcl_semicolon",
	NULL,
	OPT_semicolon_extra,
	0,
	NULL,
	"Can't have empty declaration"
    },
    {
	"dcl_dcl_anon",
	NULL,
	OPT_decl_struct_anon,
	0,
	NULL,
	"Every type definition must introduce a name"
    },
    {
	"dcl_dcl_ds_empty",
	NULL,
	OPT_dspec_none,
	0,
	NULL,
	"No declaration specifiers in declaration"
    },
    {
	"dcl_dcl_ds_func",
	NULL,
	OPT_dspec_none_func,
	0,
	NULL,
	"No declaration specifiers in function definition"
    },
    {
	"dcl_spec_dup",
	"4",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1",
#else
	"6.5.1",
#endif
	"Duplicate declaration specifier, '%0 %0'"
    },
    {
	"dcl_spec_order",
	"4",
	OPT_wall,
	0,
	NULL,
	"Declaration specifier, '%0' after type specifier"
    },
    {
	"dcl_stc_dup",
	"44",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.1",
#else
	"6.5.1",
#endif
	"Multiple storage class specifiers '%0', assuming '%1'"
    },
    {
	"dcl_stc_stat_block",
	NULL,
	OPT_func_block,
	0,
	NULL,
	"Can't declare 'static' functions inside a block"
    },
    {
	"dcl_stc_bad",
	"4",
	OPT_cpp_error,
	0,
#ifndef ERR_ALTERNATE
	"7.1.1",
#else
	"6.7",
#endif
	"Storage class specifier '%0' must be applied to an object"
    },
    {
	"dcl_stc_expl_spec",
	"4",
	0,
	0,
	NULL,
	"Can't apply '%0' to an explicit specialization or instantiation"
    },
    {
	"dcl_stc_auto_bad",
	"4",
	0,
	0,
	NULL,
	"Can only apply '%0' to a function parameter or variable"
    },
    {
	"dcl_stc_auto_func",
	"4",
	0,
	0,
	NULL,
	"Can't apply '%0' to a function declaration"
    },
    {
	"dcl_stc_ext_inline",
	NULL,
	OPT_none,
	0,
	NULL,
	"Can't declare a function 'extern inline'"
    },
    {
	"dcl_stc_ext_mem",
	NULL,
	0,
	0,
	NULL,
	"Can't apply 'extern' to a class member"
    },
    {
	"dcl_stc_mut_bad",
	NULL,
	0,
	0,
	NULL,
	"Can only apply 'mutable' to a data member"
    },
    {
	"dcl_stc_mut_const",
	"9",
	0,
	0,
	NULL,
	"Can't apply 'mutable' to the 'const' member '%0'"
    },
    {
	"dcl_stc_param",
	"4",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.1",
#else
	"6.7.1",
#endif
	"Can't apply '%0' to a function parameter"
    },
    {
	"dcl_stc_auto_par",
	NULL,
	OPT_c_error,
	0,
	NULL,
	"Can't apply 'auto' to a function parameter"
    },
    {
	"dcl_stc_internal",
	"9D",
	OPT_link_incompat,
	0,
#ifndef ERR_ALTERNATE
	"7.1.1",
#else
	"6.1.2.2",
#endif
	"'%0' previously declared with internal linkage (at %1)"
    },
    {
	"dcl_stc_external",
	"9D",
	OPT_link_resolve,
	0,
	NULL,
	"'%0' previously declared with external linkage (at %1)"
    },
    {
	"dcl_fct_spec_inline_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.2",
#else
	"6.5.1",
#endif
	"The specifier 'inline' can only applied to function declarations"
    },
    {
	"dcl_fct_spec_block",
	NULL,
	0,
	0,
	NULL,
	"Can't declare 'inline' functions inside a block"
    },
    {
	"dcl_fct_spec_virtual",
	NULL,
	0,
	0,
	NULL,
	"The specifier 'virtual' can only applied to function members"
    },
    {
	"dcl_fct_spec_explicit",
	NULL,
	0,
	0,
	NULL,
	"The specifier 'explicit' can only applied to function members"
    },
    {
	"dcl_fct_spec_expl_constr",
	NULL,
	0,
	0,
	NULL,
	"Can only apply 'explicit' to a constructor"
    },
    {
	"dcl_fct_spec_expl_conv",
	NULL,
	0,
	0,
	NULL,
	"Can't apply 'explicit' to a conversion function"
    },
    {
	"dcl_fct_spec_inline_call",
	"9",
	OPT_none,
	0,
	NULL,
	"The inline function '%0' has been called before it is defined"
    },
    {
	"dcl_typedef_func",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.3",
#else
	"6.5.1",
#endif
	"Can't apply 'typedef' to a function definition"
    },
    {
	"dcl_typedef_par",
	NULL,
	0,
	0,
	NULL,
	"Can't apply 'typedef' to a function parameter"
    },
    {
	"dcl_typedef_dspec",
	"4",
	0,
	0,
	NULL,
	"Can't use declaration specifier(s) '%0' with 'typedef'"
    },
    {
	"dcl_typedef_dcl",
	NULL,
	OPT_none,
	0,
	NULL,
	"The 'typedef' specifier must define a type"
    },
    {
	"dcl_typedef_constr",
	"76",
	0,
	0,
	NULL,
	"Can't use 'typedef' name '%0' in constructor '%1'"
    },
    {
	"dcl_typedef_destr",
	"76",
	0,
	0,
	NULL,
	"Can't use 'typedef' name '%0' in destructor '%1'"
    },
    {
	"dcl_friend_class",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.4",
#else
	"????",
#endif
	"The specifier 'friend' can only be used in a class definition"
    },
    {
	"dcl_type_infer",
	"G",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"7.1.5",
#else
	"6.5.2",
#endif
	"Type '%0' inferred"
    },
    {
	"dcl_type_none",
	NULL,
	OPT_infer_int,
	0,
	NULL,
	"No type specifier given in declaration"
    },
    {
	"dcl_type_qual",
	NULL,
	OPT_infer_int_cv,
	0,
	NULL,
	"Only type qualifiers given in type specifier"
    },
    {
	"dcl_type_cv_dup",
	"3",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.5",
#else
	"6.5.3",
#endif
	"Duplicate type qualifier, '%0 %0'"
    },
    {
	"dcl_type_type_cv",
	"93",
#ifndef ERR_ALTERNATE
	OPT_wall,
#else
	OPT_error,
#endif
	0,
	NULL,
	"Type '%0' is already '%1' qualified"
    },
    {
	"dcl_type_cv_unused",
	"3",
	OPT_cpp_error,
	0,
#ifndef ERR_ALTERNATE
	"7.1.5.1",
#else
	"6.5.3",
#endif
	"Type specifier(s) '%0' not used"
    },
    {
	"dcl_type_simple_dup",
	"1",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.1.5.2",
#else
	"6.5.2",
#endif
	"Duplicate type specifier, '%0 %0'"
    },
    {
	"dcl_type_simple_bad",
	"11",
	0,
	0,
	NULL,
	"Illegal type specifier, '%0', assuming '%1'"
    },
    {
	"dcl_type_simple_llong",
	"1",
	OPT_longlong,
	0,
	NULL,
	"Type specifier '%0' used"
    },
    {
	"dcl_type_simple_many",
	"GG",
	0,
	0,
	NULL,
	"Duplicate type names, '%0' and '%1'"
    },
    {
	"dcl_type_simple_undecl",
	"1G",
	0,
	0,
	NULL,
	"Can't use type specifiers '%0' with '%1'"
    },
    {
	"dcl_type_simple_undef",
	"7",
	0,
	0,
	NULL,
	"The type '%0' hasn't been declared"
    },
    {
	"dcl_type_elab_bad",
	"117D",
	OPT_type_tag_ignore,
	0,
#ifndef ERR_ALTERNATE
	"7.1.5.3",
#else
	"6.5.2.3",
#endif
	"Inconsistent key '%0' used for '%1 %2' (see %3)"
    },
    {
	"dcl_type_elab_qual",
	"1",
	0,
	0,
	NULL,
	"A type declaration should have the form '%0 identifier'"
    },
    {
	"dcl_enum_none",
	NULL,
	OPT_c_error,
	0,
#ifndef ERR_ALTERNATE
	"7.2",
#else
	"6.5.2.2",
#endif
	"No enumerators in enumeration type"
    },
    {
	"dcl_enum_const",
	"9",
	0,
	0,
	NULL,
	"Value for enumerator '%0' should be an integer constant expression"
    },
    {
	"dcl_enum_zero",
	"G",
	OPT_wall,
	0,
	NULL,
	"Zero is not a valid enumerator value for '%0'"
    },
    {
	"dcl_nspace_scope",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3",
#else
	"????",
#endif
	"A namespace can only be defined in namespace scope"
    },
    {
	"dcl_nspace_undef",
	"7",
	0,
	0,
	NULL,
	"The namespace '%0' hasn't been defined"
    },
    {
	"dcl_nspace_def_orig",
	"77",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3.1",
#else
	"????",
#endif
	"Namespace extension should use original name, '%0', not the alias '%1'"
    },
    {
	"dcl_nspace_unnamed_static",
	NULL,
	OPT_none,
	0,
#ifndef ERR_ALTERNATE
	"7.3.1.1",
#else
	"????",
#endif
	"Use of 'static' in namespace scope is deprecated"
    },
    {
	"dcl_nspace_memdef_scope",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3.1.2",
#else
	"6.5.7",
#endif
	"'%0' can only be defined in an enclosing namespace scope"
    },
    {
	"dcl_nspace_alias_class",
	"A",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3.2",
#else
	"????",
#endif
	"Namespace alias can't refer to the class '%0'"
    },
    {
	"dcl_nspace_alias_bad",
	"7D",
	0,
	0,
	NULL,
	"Namespace alias '%0' has already been defined as an original namespace name (at %1)"
    },
    {
	"dcl_nspace_alias_redef",
	"7D",
	0,
	0,
	NULL,
	"Namespace '%0' redefined inconsistently (see %1)"
    },
    {
	"dcl_nspace_udecl_unqual",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3.3",
#else
	"????",
#endif
	"The identifier in a 'using' declaration must be qualified"
    },
    {
	"dcl_nspace_udecl_mem",
	"7",
	0,
	0,
	NULL,
	"Can't use '%0' in its own scope"
    },
    {
	"dcl_nspace_udecl_base",
	"72",
	0,
	0,
	NULL,
	"Used identifier '%0' is not a member of a base class of '%1'"
    },
    {
	"dcl_nspace_udecl_vis",
	"72",
	0,
	0,
	NULL,
	"Used identifier '%0' is not visible in '%1'"
    },
    {
	"dcl_nspace_udecl_id",
	"7",
	0,
	0,
	NULL,
	"'%0' can only be used in a derived class"
    },
    {
	"dcl_nspace_udecl_constr",
	"7",
	0,
	0,
	NULL,
	"Can't use the member '%0'"
    },
    {
	"dcl_nspace_udecl_acc",
	"7D",
	OPT_wall,
	0,
	NULL,
	"Declaration reduces access to '%0' (see %1)"
    },
    {
	"dcl_nspace_udecl_multi",
	"7D",
	0,
	0,
	NULL,
	"Invalid redeclaration of '%0' (see %1)"
    },
    {
	"dcl_nspace_udecl_redecl",
	"7D",
	0,
	0,
	NULL,
	"Can't redeclare '%0' (see %1)"
    },
    {
	"dcl_nspace_udir_class",
	"A",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.3.4",
#else
	"????",
#endif
	"Can't use the class namespace '%0'"
    },
    {
	"dcl_nspace_udir_dup",
	"A",
	OPT_none,
	0,
	NULL,
	"Namespace '%0' already used in this scope"
    },
    {
	"dcl_asm_ti",
	NULL,
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"7.4",
#else
	"Annex G",
#endif
	"'asm' declarations are not portable"
    },
    {
	"dcl_asm_args",
	NULL,
	0,
	0,
	NULL,
	"Can't have arguments with 'asm'"
    },
    {
	"dcl_link_unknown",
	"F",
	0,
	0,
#ifndef ERR_ALTERNATE
	"7.5",
#else
	"????",
#endif
	"Unknown linkage specifier, %0"
    },
    {
	"dcl_link_scope",
	NULL,
	0,
	0,
	NULL,
	"Linkage specifications can only occur in namespace scope"
    },
    {
	"dcl_link_lang",
	"9JD",
	OPT_link_incompat,
	0,
	NULL,
	"'%0' previously declared with %1 linkage (at %2)"
    },
    {
	"dcl_link_func",
	"J",
	OPT_func_linkage,
	0,
	NULL,
	"Function type previously declared with %0 linkage"
    },
    {
	"dcl_link_conv",
	NULL,
	OPT_func_linkage,
	0,
	NULL,
	"Differing function linkage specifications in conversion"
    },
    {
	"dcl_link_over",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Only one function in a set of overloaded functions can have C linkage"
    },
    {
	"dcl_link_redecl",
	"6D",
#ifndef ERR_ALTERNATE
	OPT_whatever,
#else
	OPT_none,
#endif
	0,
	NULL,
	"Two objects with C linkage named '%0' are the same"
    },
    {
	"dcl_meaning_id",
	"E7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3",
#else
	"6.5.4",
#endif
	"The identifier '%0%1' can't be used in this context"
    },
    {
	"dcl_meaning_full",
	"E7",
	OPT_none,
	0,
	NULL,
	"The fully qualified identifier '%0%1' can't be used in this context"
    },
    {
	"dcl_meaning_mem",
	"E7",
	0,
	0,
	NULL,
	"Illegally qualified member declaration '%0%1'"
    },
    {
	"dcl_meaning_paren",
	NULL,
	OPT_wall,
	0,
	NULL,
	"Redundant parentheses in declarator"
    },
    {
	"dcl_ref_cv",
	"3",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.2",
#else
	"????",
#endif
	"Can't have '%0' qualified references"
    },
    {
	"dcl_ref_cv_type",
	"39",
	OPT_wall,
	0,
	NULL,
	"'%0' qualifier for reference type '%1'"
    },
    {
	"dcl_ref_void",
	"G",
	0,
	0,
	NULL,
	"Can't have references to '%0'"
    },
    {
	"dcl_ref_ref",
	NULL,
	0,
	0,
	NULL,
	"Can't have references to references"
    },
    {
	"dcl_ref_ptr",
	NULL,
	0,
	0,
	NULL,
	"Can't have pointers to references"
    },
    {
	"dcl_ref_array",
	NULL,
	0,
	0,
	NULL,
	"Can't have arrays of references"
    },
    {
	"dcl_mptr_type",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.3",
#else
	"????",
#endif
	"Class name required in pointer to member, not '%0'"
    },
    {
	"dcl_mptr_class",
	"G",
	0,
	0,
	NULL,
	"Class type required in pointer to member, not '%0'"
    },
    {
	"dcl_mptr_void",
	"G",
	0,
	0,
	NULL,
	"Can't have pointers to '%0' members"
    },
    {
	"dcl_mptr_ref",
	NULL,
	0,
	0,
	NULL,
	"Can't have pointers to reference members"
    },
    {
	"dcl_array_void",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.4",
#else
	"6.1.2.5",
#endif
	"Can't have arrays of '%0'"
    },
    {
	"dcl_array_incompl",
	NULL,
	OPT_type_obj_incompl,
	0,
	NULL,
	"Can't have arrays of incomplete types"
    },
    {
	"dcl_array_abstract",
	NULL,
	0,
	0,
	NULL,
	"Can't have arrays of abstract types"
    },
    {
	"dcl_array_array",
	NULL,
	0,
	0,
	NULL,
	"Can't have arrays of incomplete arrays"
    },
    {
	"dcl_array_bitf",
	NULL,
	0,
	0,
	NULL,
	"Can't have arrays of bitfields"
    },
    {
	"dcl_array_func",
	NULL,
	0,
	0,
	NULL,
	"Can't have arrays of functions"
    },
    {
	"dcl_array_dim_const",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.4",
#else
	"6.5.4.2",
#endif
	"Array bound should be an integer constant expression"
    },
    {
	"dcl_array_dim_zero",
	NULL,
	0,
	0,
	NULL,
	"Array bound can't be zero"
    },
    {
	"dcl_array_dim_neg",
	"B",
	0,
	0,
	NULL,
	"Array bound should be greater than zero, not %0"
    },
    {
	"dcl_fct_par_void",
	"7G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.5",
#else
	"6.5.4.3",
#endif
	"Parameter '%0' declared to have type '%1'"
    },
    {
	"dcl_fct_par_array",
	"7G",
	OPT_cpp_error,
	0,
	NULL,
	"Parameter '%0' declared to have incomplete array type '%1'"
    },
    {
	"dcl_fct_par_weak",
	NULL,
	0,
	0,
	NULL,
	"Parameter required in weak function prototype"
    },
    {
	"dcl_fct_par_empty",
	NULL,
	0,
	0,
	NULL,
	"Precisely '( void )' required in empty parameter list"
    },
    {
	"dcl_fct_par_ellipsis",
	NULL,
#ifndef ERR_ALTERNATE
	OPT_none,
#else
	OPT_ellipsis_ident,
#endif
	0,
	NULL,
	"Need at least one parameter before '...'"
    },
    {
	"dcl_fct_weak",
	NULL,
	0,
	0,
	NULL,
	"Can only have parameter list in function definition"
    },
    {
	"dcl_fct_proto",
	NULL,
	OPT_func_proto,
	0,
	NULL,
	"Function prototype used"
    },
    {
	"dcl_fct_nonproto",
	NULL,
	OPT_func_weak,
	0,
	NULL,
	"Non-prototype function used"
    },
    {
	"dcl_fct_array",
	NULL,
	0,
	0,
	NULL,
	"Can't have functions returning arrays"
    },
    {
	"dcl_fct_bitf",
	NULL,
	0,
	0,
	NULL,
	"Can't have functions returning bitfields"
    },
    {
	"dcl_fct_func",
	NULL,
	0,
	0,
	NULL,
	"Can't have functions returning functions"
    },
    {
	"dcl_fct_typedef_par",
	NULL,
	OPT_cpp_error,
	0,
	NULL,
	"Can't define a type in a function parameter"
    },
    {
	"dcl_fct_typedef_ret",
	NULL,
	OPT_cpp_error,
	0,
	NULL,
	"Can't define a type in a function return"
    },
    {
	"dcl_fct_cv_ret",
	"3",
	OPT_none,
	0,
	NULL,
	"A function can't return a '%0' qualified type"
    },
    {
	"dcl_fct_cv",
	"3",
	0,
	0,
	NULL,
	"Invalid use of '%0' qualified function"
    },
    {
	"dcl_fct_cv_decl",
	"3",
	0,
	0,
	NULL,
	"Only non-static member functions can be '%0' qualified"
    },
    {
	"dcl_fct_compat_ellipsis",
	NULL,
	OPT_ellipsis_extra,
	0,
	NULL,
	"Compatible function types should agree on use of ellipsis"
    },
    {
	"dcl_fct_compat_prom",
	"G",
	OPT_func_incompat,
	0,
	NULL,
	"The type '%0' is not compatible with its argument promotion type"
    },
    {
	"dcl_fct_qual",
	"39",
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.5",
#else
	"6.5.3",
#endif
	"'%0' qualifier for function type '%1'"
    },
    {
	"dcl_fct_ret",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.5",
#else
	"6.7.1",
#endif
	"Function return type should be a complete object type or 'void'"
    },
    {
	"dcl_fct_ret_void",
	"G",
	0,
	0,
	NULL,
	"Function return type can't be '%0'"
    },
    {
	"dcl_fct_typedef",
	NULL,
	0,
	0,
	NULL,
	"Can't define a function using a 'typedef' function type"
    },
    {
	"dcl_fct_par_proto",
	NULL,
	0,
	0,
	NULL,
	"Can't have parameter list with prototype"
    },
    {
	"dcl_fct_par_anon",
	NULL,
	OPT_c_error,
	0,
	NULL,
	"Must have parameter name in function definition"
    },
    {
	"dcl_fct_par_undecl",
	"6",
	0,
	0,
	NULL,
	"Parameter '%0' doesn't appear in parameter list"
    },
    {
	"dcl_fct_par_typedef",
	"7",
	0,
	0,
	NULL,
	"Can't use type name '%0' in parameter list"
    },
    {
	"dcl_fct_par_none",
	NULL,
	0,
	0,
	NULL,
	"Parameter declaration should contain a declarator"
    },
    {
	"dcl_fct_par_impl",
	"7",
	OPT_param_impl,
	0,
	NULL,
	"Implicit declaration of parameter '%0'"
    },
    {
	"dcl_fct_par_order",
	NULL,
	OPT_wall,
	0,
	NULL,
	"Function parameters declared out of sequence"
    },
    {
	"dcl_fct_default_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.3.6",
#else
	"6.7.1",
#endif
	"Can only have default arguments in a function declaration"
    },
    {
	"dcl_fct_default_missing",
	"7",
	0,
	0,
	NULL,
	"Parameter '%0' should have a default argument"
    },
    {
	"dcl_fct_default_dup",
	"7D",
	0,
	0,
	NULL,
	"Duplicate default argument for parameter '%0' (see %1)"
    },
    {
	"dcl_fct_default_redef",
	"7D",
	0,
	0,
	NULL,
	"Default argument for parameter '%0' redefined inconsistently (see %1)"
    },
    {
	"dcl_fct_default_templ",
	NULL,
	0,
	0,
	NULL,
	"Can't add default arguments to template functions"
    },
    {
	"dcl_fct_default_param",
	"7",
	0,
	0,
	NULL,
	"'%0' can't be used in a default argument"
    },
    {
	"dcl_fct_default_weak",
	"7",
	OPT_c_error,
	0,
	NULL,
	"Can't initialize the parameter '%0'"
    },
    {
	"dcl_fct_def_scope",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.4",
#else
	"6.7.1",
#endif
	"A function can only be defined in namespace or class scope"
    },
    {
	"dcl_fct_def_comment",
	"9",
	OPT_whatever,
	0,
	NULL,
	"In definition of function '%0'"
    },
    {
	"dcl_init_decl",
	"7J",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"8.5",
#else
	"6.5.7",
#endif
	"In initialization of '%0%1'"
    },
    {
	"dcl_init_typedef",
	"7",
	0,
	0,
	NULL,
	"Can't initialize the type '%0'"
    },
    {
	"dcl_init_incompl",
	NULL,
	0,
	0,
	NULL,
	"Can't initialize objects of incomplete type"
    },
    {
	"dcl_init_func",
	"9",
	0,
	0,
	NULL,
	"Can't initialize the function '%0'"
    },
    {
	"dcl_init_bad",
	NULL,
	0,
	0,
	NULL,
	"Badly placed function style initializer"
    },
    {
	"dcl_init_const",
	NULL,
	OPT_cpp_error,
	0,
	NULL,
	"'const' objects should be initialized"
    },
    {
	"dcl_init_ctor",
	"G",
	0,
	0,
	NULL,
	"A constructor-style initializer with more than one argument requires a class type, not '%0'"
    },
    {
	"dcl_init_conv",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Can't perform this conversion by initialization"
    },
    {
	"dcl_init_assign",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Initializers are converted as if by assignment"
    },
    {
	"dcl_init_dynamic",
	NULL,
	OPT_init_dynamic,
	0,
	NULL,
	"Object initializer should be a constant expression"
    },
    {
	"dcl_init_aggr_array_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.5.1",
#else
	"6.5.7",
#endif
	"Bad array initializer"
    },
    {
	"dcl_init_aggr_dynamic",
	NULL,
	OPT_init_dynamic,
	0,
	NULL,
	"Expression in aggregate initializer should be constant"
    },
    {
	"dcl_init_aggr_array_ti",
	"BG",
	OPT_init_aggregate,
	0,
	NULL,
	"Target dependent initialization, '%0' elements for array of type '%1'"
    },
    {
	"dcl_init_aggr_excess",
	"G",
	0,
	0,
	NULL,
	"Too many elements in initializer for type '%0'"
    },
    {
	"dcl_init_aggr_pad",
	"BG",
	OPT_init_aggregate,
	0,
	NULL,
	"'%0' too few elements in initializer for type '%1'"
    },
    {
	"dcl_init_aggr_type",
	"G",
	0,
	0,
	NULL,
	"Can't initialize objects of type '%0' using aggregate initializers"
    },
    {
	"dcl_init_aggr_empty",
	NULL,
	OPT_c_error,
	0,
	NULL,
	"Empty aggregate initializer"
    },
    {
	"dcl_init_aggr_no_scalar",
	NULL,
	0,
	0,
	NULL,
	"Scalar aggregate initializers can't be empty"
    },
    {
	"dcl_init_aggr_nest",
	NULL,
	0,
	0,
	NULL,
	"Scalar aggregate initializers can't be nested"
    },
    {
	"dcl_init_aggr_partial",
	NULL,
	OPT_init_aggregate,
	0,
	NULL,
	"Partially bracketed aggregate initializer"
    },
    {
	"dcl_init_aggr_auto",
	"7",
	OPT_init_struct,
	0,
	NULL,
	"Initializer for local aggregate variable '%0'"
    },
    {
	"dcl_init_string_char",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.5.2",
#else
	"6.5.7",
#endif
	"Can only initialize character arrays with string literals"
    },
    {
	"dcl_init_string_wchar",
	NULL,
	0,
	0,
	NULL,
	"Can only initialize wide character arrays with wide string literals"
    },
    {
	"dcl_init_string_excess",
	"G",
	0,
	0,
	NULL,
	"Initializer string too long for type '%0'"
    },
    {
	"dcl_init_string_zero",
	"G",
	OPT_cpp_error,
	0,
	NULL,
	"Initializer string (including terminal zero) too long for type '%0'"
    },
    {
	"dcl_init_ref_none",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"8.5.3",
#else
	"6.5.7",
#endif
	"References should be initialized"
    },
    {
	"dcl_init_ref_ambig",
	NULL,
	0,
	0,
	NULL,
	"Base class in reference binding must be unambiguous"
    },
    {
	"dcl_init_ref_const",
	NULL,
	0,
	0,
	NULL,
	"A non-'const' reference can't be initialized using an rvalue"
    },
    {
	"dcl_init_ref_qual",
	"3",
	0,
	0,
	NULL,
	"Reference binding from more '%0' qualified type"
    },
    {
	"dcl_init_ref_func",
	NULL,
	0,
	0,
	NULL,
	"A reference to function can only be initialized by a function"
    },
    {
	"dcl_init_ref_tmp",
	"G",
	OPT_wall,
	0,
	NULL,
	"Introducing temporary variable of type '%0'"
    },
    {
	"class_none",
	NULL,
	OPT_c_error,
	0,
#ifndef ERR_ALTERNATE
	"9",
#else
	"6.5.2.1",
#endif
	"No members in class definition"
    },
    {
	"class_mem_empty",
	NULL,
	OPT_decl_empty,
	0,
#ifndef ERR_ALTERNATE
	"9.2",
#else
	"6.5.2.1",
#endif
	"Every member declaration must introduce a name"
    },
    {
	"class_mem_declarator",
	NULL,
	OPT_c_error,
	0,
	NULL,
	"A member declaration should contain a declarator"
    },
    {
	"class_mem_semicolon",
	NULL,
	OPT_semicolon_extra,
	0,
	NULL,
	"Can't have empty member declaration"
    },
    {
	"class_mem_anon",
	NULL,
	OPT_decl_struct_anon,
	0,
	NULL,
	"Every type definition must introduce a member name"
    },
    {
	"class_mem_ds_empty",
	NULL,
	OPT_dspec_none,
	0,
	NULL,
	"No declaration specifiers in member declaration"
    },
    {
	"class_mem_redecl",
	"7D",
	0,
	0,
	NULL,
	"The member '%0' has already been declared (at %1)"
    },
    {
	"class_mem_incompl_mem",
	"7",
	0,
	0,
	NULL,
	"The member '%0' must have complete object type"
    },
    {
	"class_mem_init_mem",
	"9",
	0,
	0,
	NULL,
	"Can't have initializer with non-static member '%0'"
    },
    {
	"class_mem_def",
	"9",
	0,
	0,
	NULL,
	"Can't define the non-static member '%0'"
    },
    {
	"class_mem_init_const",
	NULL,
	0,
	0,
	NULL,
	"A member initializer should be a constant expression"
    },
    {
	"class_mem_incompl_stat",
	"7",
	0,
	0,
	NULL,
	"The static member '%0' must have complete object type"
    },
    {
	"class_mem_ctor",
	"7",
	OPT_cpp_error,
	0,
	NULL,
	"The member '%0' can't have the same name as its class"
    },
    {
	"class_mem_ctor_data",
	"7",
#ifndef ERR_ALTERNATE
	OPT_new,
#else
	OPT_none,
#endif
	0,
	NULL,
	"The data member '%0' can't have the same name as its class"
    },
    {
	"class_mem_ref",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-static reference member"
    },
    {
	"class_mem_const",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-static 'const' member"
    },
    {
	"class_mfct_eof",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.3",
#else
	"????",
#endif
	"End of file encountered in rewriting '%0'"
    },
    {
	"class_mfct_scope",
	"9",
	0,
	0,
	NULL,
	"'%0' can only be defined in its class or an enclosing namespace scope"
    },
    {
	"class_mfct_redecl",
	"9",
	0,
	0,
	NULL,
	"Can't redeclare the member function '%0'"
    },
    {
	"class_this_qual",
	"3",
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.3.2",
#else
	"????",
#endif
	"Member function called for more '%0' qualified object"
    },
    {
	"class_static_mfct_virt",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.4.1",
#else
	"????",
#endif
	"Can't have virtual static member functions"
    },
    {
	"class_static_data_init",
	"7G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.4.2",
#else
	"????",
#endif
	"The static member '%0' can only have an initializer if it has integral type, not '%1'"
    },
    {
	"class_static_data_const",
	"7G",
	0,
	0,
	NULL,
	"The static member '%0' can only have an initializer if it has 'const' type, not '%1'"
    },
    {
	"class_static_data_def",
	"7D",
	0,
	0,
	NULL,
	"'%0' was initialized in its class (at %1), and so can't be assigned a value in its definition"
    },
    {
	"class_static_data_scope",
	"7",
	0,
	0,
	NULL,
	"'%0' can only be defined in its class or an enclosing namespace scope"
    },
    {
	"class_static_data_anon",
	"7",
	0,
	0,
	NULL,
	"Can't have static member '%0' in an anonymous class"
    },
    {
	"class_union_deriv",
	"2",
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.5",
#else
	"6.5.2.1",
#endif
	"The union '%0' can't have base classes"
    },
    {
	"class_union_base",
	"2",
	0,
	0,
	NULL,
	"The union '%0' can't be used as a base class"
    },
    {
	"class_union_static",
	"2",
	0,
	0,
	NULL,
	"The union '%0' can't contain a static data member"
    },
    {
	"class_union_virtual",
	"2",
	0,
	0,
	NULL,
	"The union '%0' can't contain a virtual function"
    },
    {
	"class_union_ref",
	"2G",
	0,
	0,
	NULL,
	"The union '%0' can't have a member of reference type '%1'"
    },
    {
	"class_union_mem",
	"2G",
	0,
	0,
	NULL,
	"The union '%0' can't have a member of type '%1'"
    },
    {
	"class_union_anon_private",
	NULL,
	0,
	0,
	NULL,
	"An anonymous union can't have 'private' or 'protected' members"
    },
    {
	"class_union_anon_func",
	NULL,
	0,
	0,
	NULL,
	"An anonymous union can't have function members"
    },
    {
	"class_union_anon_static",
	NULL,
	0,
	0,
	NULL,
	"An anonymous union can't have external linkage"
    },
    {
	"class_union_anon_mem",
	NULL,
	0,
	0,
	NULL,
	"An anonymous union can't be a static data member of a class"
    },
    {
	"class_bit_base",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"9.6",
#else
	"6.5.2.1",
#endif
	"Bitfield base type should be integral, not '%0'"
    },
    {
	"class_bit_base_int",
	"G",
	OPT_bitf_type,
	0,
	NULL,
	"Only 'int' types allowed in bitfields, not '%0'"
    },
    {
	"class_bit_sign",
	"1",
	OPT_wall,
	0,
	NULL,
	"Sign of a bitfield of type '%0' is implementation dependent"
    },
    {
	"class_bit_dim_const",
	NULL,
	0,
	0,
	NULL,
	"Bitfield width should be an integer constant expression"
    },
    {
	"class_bit_dim_zero",
	NULL,
	0,
	0,
	NULL,
	"Only unnamed bitfields can have width zero"
    },
    {
	"class_bit_dim_neg",
	"B",
	0,
	0,
	NULL,
	"Bitfield width should be non-negative, not '%0'"
    },
    {
	"class_bit_dim_big",
	"BG",
	OPT_bitf_overflow,
	0,
	NULL,
	"Bitfield width '%0' exceeds minimum size for base type, '%1'"
    },
    {
	"class_bit_static",
	NULL,
	0,
	0,
	NULL,
	"A bitfield can't be a static member"
    },
    {
	"class_bit_typedef",
	NULL,
	0,
	0,
	NULL,
	"Can't use 'typedef' to define a bitfield type"
    },
    {
	"class_bit_ptr",
	NULL,
	0,
	0,
	NULL,
	"Can't have pointers to bitfields"
    },
    {
	"class_bit_ref",
	NULL,
	0,
	0,
	NULL,
	"Can't have references to bitfields"
    },
    {
	"class_bit_mptr",
	NULL,
	0,
	0,
	NULL,
	"Can't have pointers to bitfield members"
    },
    {
	"class_local_func",
	"9",
	OPT_none,
	0,
#ifndef ERR_ALTERNATE
	"9.8",
#else
	"6.5.2.1",
#endif
	"Member function '%0' of a local class should be defined in that class"
    },
    {
	"class_local_static",
	"7",
	0,
	0,
	NULL,
	"Can't have static member '%0' in a local class"
    },
    {
	"class_local_auto",
	"7",
	0,
	0,
	NULL,
	"Can't use variable '%0' in local class"
    },
    {
	"class_derived_class",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"10",
#else
	"????",
#endif
	"A base class should have class type, not '%0'"
    },
    {
	"class_derived_incompl",
	NULL,
	0,
	0,
	NULL,
	"A base class should be complete"
    },
    {
	"class_derived_empty",
	"2",
	0,
	0,
	NULL,
	"Empty base class list for '%0'"
    },
    {
	"class_derived_base",
	"22",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a base class, '%1'"
    },
    {
	"class_derived_virt",
	"22",
	OPT_whatever,
	0,
	NULL,
	"'%0' is a virtual base class of '%1'"
    },
    {
	"class_mi_dup",
	"22",
	0,
	0,
#ifndef ERR_ALTERNATE
	"10.1",
#else
	"????",
#endif
	"Class '%0' already has a base class '%1'"
    },
    {
	"class_member_lookup_ambig",
	"22",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"10.2",
#else
	"????",
#endif
	"'%0' is an ambiguous base class of '%1'"
    },
    {
	"class_member_lookup_func",
	NULL,
	0,
	0,
	NULL,
	"Can't call a member function inherited from an ambiguous base class"
    },
    {
	"class_virtual_poly",
	"2",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"10.3",
#else
	"????",
#endif
	"'%0' is a polymorphic type"
    },
    {
	"class_virtual_override",
	"6",
	OPT_wall,
	0,
	NULL,
	"'%0' is an overriding virtual function"
    },
    {
	"class_virtual_hide",
	"69",
	OPT_wall,
	0,
	NULL,
	"'%0' hides rather than overrides the virtual function '%1'"
    },
    {
	"class_virtual_ret",
	"79D",
	0,
	0,
	NULL,
	"Return type for overriding virtual function '%0' differs from that for '%1' (see %2)"
    },
    {
	"class_virtual_darg",
	"7",
	OPT_wall,
	0,
	NULL,
	"Default arguments for virtual function '%0' differ from those of overridden function"
    },
    {
	"class_virtual_ambig",
	"79",
	0,
	0,
	NULL,
	"Conversion from return type of '%0' to that of '%1' must be unambiguous"
    },
    {
	"class_virtual_final",
	"92",
	0,
	0,
	NULL,
	"Virtual function '%0' doesn't have a unique final overrider in '%1'"
    },
    {
	"class_virtual_destr",
	"2",
	OPT_wall,
	0,
	NULL,
	"The polymorphic type '%0' doesn't have a virtual destructor"
    },
    {
	"class_virtual_not",
	"9",
	OPT_wall,
	0,
	NULL,
	"Call to '%0' is not virtual"
    },
    {
	"class_abstract_virt",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"10.4",
#else
	"????",
#endif
	"Only virtual functions can be pure"
    },
    {
	"class_abstract_zero",
	NULL,
	0,
	0,
	NULL,
	"A pure specifier should be precisely '0'"
    },
    {
	"class_abstract_class",
	"2",
	OPT_whatever,
	0,
	NULL,
	"The class '%0' is abstract"
    },
    {
	"class_abstract_pure",
	"9",
	OPT_whatever,
	0,
	NULL,
	"'%0' is a pure virtual function"
    },
    {
	"class_abstract_decl",
	"7",
	0,
	0,
	NULL,
	"The object '%0' can't have abstract type"
    },
    {
	"class_abstract_mem",
	"7",
	0,
	0,
	NULL,
	"The member '%0' can't have abstract type"
    },
    {
	"class_abstract_par",
	NULL,
	0,
	0,
	NULL,
	"A function parameter can't have abstract type"
    },
    {
	"class_abstract_ret",
	NULL,
	0,
	0,
	NULL,
	"A function can't return an abstract type"
    },
    {
	"class_abstract_cast",
	NULL,
	0,
	0,
	NULL,
	"Can't explicitly cast to an abstract type"
    },
    {
	"class_abstract_call",
	"9",
	OPT_wall,
	0,
	NULL,
	"Calling the pure virtual function '%0' is undefined"
    },
    {
	"class_access_spec_priv",
	"2",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"11.1",
#else
	"????",
#endif
	"'%0' has a 'private' or 'protected' member"
    },
    {
	"class_access_spec_id",
	"909",
	0,
	0,
	NULL,
	"The '%1' member '%0' can't be accessed by '%2'"
    },
    {
	"class_access_spec_none",
	"90",
	0,
	0,
	NULL,
	"Can't access the '%1' member '%0'"
    },
    {
	"class_access_spec_change",
	"9D",
	0,
	0,
	NULL,
	"Can't change access in redeclaration of '%0' (see %1)"
    },
    {
	"class_access_base_acc",
	"90",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"11.2",
#else
	"????",
#endif
	"Missing base class access, '%1 %0'"
    },
    {
	"class_access_base_id",
	"2209",
	0,
	0,
	NULL,
	"The '%2' base '%0' of '%1' can't be accessed by '%3'"
    },
    {
	"class_access_base_none",
	"220",
	0,
	0,
	NULL,
	"Can't access the '%2' base '%0' of '%1'"
    },
    {
	"class_access_dcl_using",
	"7",
	OPT_none,
	0,
#ifndef ERR_ALTERNATE
	"11.3",
#else
	"????",
#endif
	"Access declarations are deprecated: use 'using %0'"
    },
    {
	"class_friend_decl",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"11.4",
#else
	"????",
#endif
	"Only functions and classes can be friends"
    },
    {
	"class_friend_elab",
	NULL,
	0,
	0,
	NULL,
	"Elaborated type specifier required in friend declaration"
    },
    {
	"class_friend_storage",
	"4",
	0,
	0,
	NULL,
	"The 'friend' specifier can't be used with the storage class specifier '%0'"
    },
    {
	"class_friend_def",
	NULL,
	0,
	0,
	NULL,
	"Can't apply 'friend' to a class definition"
    },
    {
	"class_friend_local",
	NULL,
	0,
	0,
	NULL,
	"Can't define a 'friend' function in a local class"
    },
    {
	"class_friend_pre",
	"7",
	OPT_wall,
	0,
	NULL,
	"'%0' first declared in a friend declaration"
    },
    {
	"class_friend_dup_func",
	"92",
	OPT_wall,
	0,
	NULL,
	"Function '%0' is already a friend of '%1'"
    },
    {
	"class_friend_dup_class",
	"22",
	OPT_wall,
	0,
	NULL,
	"Class '%0' is already a friend of '%1'"
    },
    {
	"class_special_decl",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"12",
#else
	"????",
#endif
	"Can't explicitly declare the implicit function '%0'"
    },
    {
	"class_ctor_static",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"12.1",
#else
	"????",
#endif
	"Constructors can't be static members"
    },
    {
	"class_ctor_virtual",
	NULL,
	0,
	0,
	NULL,
	"Constructors can't be virtual members"
    },
    {
	"class_ctor_ret",
	"6",
	0,
	0,
	NULL,
	"Can't give return type for constructor '%0'"
    },
    {
	"class_ctor_qual",
	"63",
	0,
	0,
	NULL,
	"The constructor '%0' can't be '%1' qualified"
    },
    {
	"class_ctor_result",
	"9",
	0,
	0,
	NULL,
	"Can't return a value from the constructor '%0'"
    },
    {
	"class_ctor_addr",
	"9",
	0,
	0,
	NULL,
	"Can't take the address of the constructor '%0'"
    },
    {
	"class_ctor_default",
	"2",
	0,
	0,
	NULL,
	"'%0' has no default constructor"
    },
    {
	"class_ctor_user",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a user-defined constructor"
    },
    {
	"class_ctor_nontriv",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-trivial constructor"
    },
    {
	"class_ctor_make",
	"2",
	OPT_wall,
	0,
	NULL,
	"'%0' has only copy constructors"
    },
    {
	"class_ctor_private",
	"2",
	OPT_wall,
	0,
	NULL,
	"'%0' has only private non-copy constructors and no friends"
    },
    {
	"class_conv_fct_typedef",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"12.3.2",
#else
	"????",
#endif
	"Can't declare type in conversion function name '%0'"
    },
    {
	"class_conv_fct_ret",
	"6",
	0,
	0,
	NULL,
	"Can't give return type for conversion function '%0'"
    },
    {
	"class_conv_fct_ret_bad",
	"6G",
	0,
	0,
	NULL,
	"Conversion function '%0' declared to return '%1'"
    },
    {
	"class_conv_fct_pars",
	"6",
	0,
	0,
	NULL,
	"Can't give parameter types for conversion function '%0'"
    },
    {
	"class_conv_fct_void",
	"6",
	OPT_none,
	0,
	NULL,
	"Illegal conversion function '%0'"
    },
    {
	"class_conv_fct_mem",
	NULL,
	0,
	0,
	NULL,
	"A conversion function must be a non-static member"
    },
    {
	"class_dtor_static",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"12.4",
#else
	"????",
#endif
	"Destructors can't be static members"
    },
    {
	"class_dtor_ret",
	"6",
	0,
	0,
	NULL,
	"Can't give return type for destructor '%0'"
    },
    {
	"class_dtor_pars",
	"6",
	0,
	0,
	NULL,
	"Can't give parameter types for destructor '%0'"
    },
    {
	"class_dtor_func",
	"6",
	0,
	0,
	NULL,
	"The destructor '%0' must be a member function"
    },
    {
	"class_dtor_inherit",
	"6A",
	0,
	0,
	NULL,
	"The destructor '%0' can't be inherited by '%1'"
    },
    {
	"class_dtor_qual",
	"63",
	0,
	0,
	NULL,
	"The destructor '%0' can't be '%1' qualified"
    },
    {
	"class_dtor_default",
	"2",
	0,
	0,
	NULL,
	"'%0' has no default destructor"
    },
    {
	"class_dtor_nontriv",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-trivial destructor"
    },
    {
	"class_dtor_result",
	"9",
	0,
	0,
	NULL,
	"Can't return a value from the destructor '%0'"
    },
    {
	"class_dtor_addr",
	"9",
	0,
	0,
	NULL,
	"Can't take the address of the destructor '%0'"
    },
    {
	"class_dtor_private",
	"2",
	OPT_wall,
	0,
	NULL,
	"'%0' has a private destructor and no friends"
    },
    {
	"class_dtor_three",
	"2",
	OPT_wall,
	0,
	NULL,
	"A class '%0' with a destructor, copy constructor or copy assignment operator should have all three"
    },
    {
	"class_free_static",
	"6",
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"12.5",
#else
	"????",
#endif
	"'%0' is implicitly declared static"
    },
    {
	"class_base_init_bad",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"12.6.2",
#else
	"????",
#endif
	"The function '%0' can't have constructor-style initializers"
    },
    {
	"class_base_init_empty",
	"9",
	0,
	0,
	NULL,
	"Empty constructor-style initializer for function '%0'"
    },
    {
	"class_base_init_old",
	"9",
	0,
	0,
	NULL,
	"Anachronistic base class initializer in '%0'"
    },
    {
	"class_base_init_uniq",
	"2",
	0,
	0,
	NULL,
	"Class '%0' does not have a unique base class"
    },
    {
	"class_base_init_static",
	"7",
	0,
	0,
	NULL,
	"Initializer '%0' isn't a non-static member or a base class"
    },
    {
	"class_base_init_inherit",
	"7",
	0,
	0,
	NULL,
	"Can't use inherited member '%0' as an initializer"
    },
    {
	"class_base_init_base",
	"2",
	0,
	0,
	NULL,
	"The base class initializer '%0' should be a direct or a virtual base"
    },
    {
	"class_base_init_ambig",
	"2",
	0,
	0,
	NULL,
	"The base class initializer '%0' is both a direct and a virtual base"
    },
    {
	"class_base_init_dup",
	"7",
	0,
	0,
	NULL,
	"Initializer for '%0' already given"
    },
    {
	"class_base_init_none",
	"7",
	OPT_variable,
	0,
	NULL,
	"No initializer for '%0' in constructor"
    },
    {
	"class_base_init_order",
	"7",
	OPT_variable,
	0,
	NULL,
	"Constructor initializer for '%0' out of sequence"
    },
    {
	"class_base_init_union",
	"2",
	0,
	0,
	NULL,
	"More than one initializer given for union '%0'"
    },
    {
	"class_base_init_anon",
	"7",
	0,
	0,
	NULL,
	"More than one initializer given for anonymous union member '%0'"
    },
    {
	"class_base_init_err",
	"9",
	OPT_whatever,
	0,
	NULL,
	"In special member function '%0'"
    },
    {
	"class_base_init_impl",
	"9",
	OPT_whatever,
	0,
	NULL,
	"In implicit definition of '%0'"
    },
    {
	"class_copy_bad",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"12.8",
#else
	"????",
#endif
	"Copy constructor '%0' should have a reference parameter"
    },
    {
	"class_copy_constr",
	"2",
	0,
	0,
	NULL,
	"'%0' has no copy constructor"
    },
    {
	"class_copy_assign",
	"2",
	0,
	0,
	NULL,
	"'%0' has no copy assignment operator"
    },
    {
	"class_copy_nontriv_constr",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-trivial copy constructor"
    },
    {
	"class_copy_nontriv_assign",
	"2",
	OPT_whatever,
	0,
	NULL,
	"'%0' has a non-trivial copy assignment operator"
    },
    {
	"class_copy_ptr",
	NULL,
	OPT_wall,
	0,
	NULL,
	"Pointers are shallow copied"
    },
    {
	"over_load_pars",
	NULL,
	OPT_whatever,
	0,
#ifndef ERR_ALTERNATE
	"13.1",
#else
	"????",
#endif
	"Can't overload functions with indistinguishable parameter types"
    },
    {
	"over_match_call_mem",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.3.1.1",
#else
	"????",
#endif
	"Can't have member function '&%0' in call"
    },
    {
	"over_match_call_ok",
	"9",
	OPT_overload_res,
	0,
	NULL,
	"Overloaded function call resolves to '%0'"
    },
    {
	"over_match_call_target",
	"7",
	OPT_overload_dep,
	0,
	NULL,
	"Target dependent resolution for call to overloaded function '%0'"
    },
    {
	"over_match_call_ambig",
	"7",
	OPT_overload_ambig,
	0,
	NULL,
	"Ambiguous call to overloaded function '%0'"
    },
    {
	"over_match_oper_ok",
	"9",
	OPT_overload_res,
	0,
#ifndef ERR_ALTERNATE
	"13.3.1.2",
#else
	"????",
#endif
	"Overloaded operator resolves to '%0'"
    },
    {
	"over_match_oper_target",
	"8",
	OPT_overload_dep,
	0,
	NULL,
	"Target dependent resolution for overloaded operator '%0'"
    },
    {
	"over_match_oper_ambig",
	"8",
	OPT_overload_ambig,
	0,
	NULL,
	"Ambiguous overloaded operator '%0'"
    },
    {
	"over_match_oper_arrow",
	NULL,
	0,
	0,
	NULL,
	"Infinite loop in overloading of '->'"
    },
    {
	"over_match_ctor_ok",
	"9",
	OPT_overload_res,
	0,
#ifndef ERR_ALTERNATE
	"13.3.1.3",
#else
	"????",
#endif
	"Overloaded constructor call resolves to '%0'"
    },
    {
	"over_match_ctor_target",
	"7",
	OPT_overload_dep,
	0,
	NULL,
	"Target dependent resolution for call to overloaded constructor '%0'"
    },
    {
	"over_match_ctor_ambig",
	"7",
	OPT_overload_ambig,
	0,
	NULL,
	"Ambiguous call to overloaded constructor '%0'"
    },
    {
	"over_match_ctor_none",
	"7",
	0,
	0,
	NULL,
	"None of the overloaded constructors '%0' is viable for given call"
    },
    {
	"over_match_conv_ok",
	"9",
	OPT_overload_res,
	0,
#ifndef ERR_ALTERNATE
	"13.3.1.5",
#else
	"????",
#endif
	"Overloaded user-defined conversion resolves to '%0'"
    },
    {
	"over_match_conv_target",
	"GG",
	OPT_overload_dep,
	0,
	NULL,
	"Target dependent resolution for user-defined conversion from '%0' to '%1'"
    },
    {
	"over_match_conv_ambig",
	"GG",
	OPT_overload_ambig,
	0,
	NULL,
	"Ambiguous user-defined conversion from '%0' to '%1'"
    },
    {
	"over_match_conv_dup",
	"G",
	0,
	0,
	NULL,
	"Ambiguous user-defined conversions from '%0'"
    },
    {
	"over_match_viable_none",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.3.2",
#else
	"????",
#endif
	"None of the overloaded functions '%0' is viable for given call"
    },
    {
	"over_match_viable_list",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"Viable candidates are as follows"
    },
    {
	"over_match_best_install",
	NULL,
	OPT_overload_ambig,
	0,
#ifndef ERR_ALTERNATE
	"13.3.3",
#else
	"????",
#endif
	"Failed target dependent overload resolution"
    },
    {
	"over_match_best_common",
	NULL,
	0,
	0,
	NULL,
	"Can't find common return type for target dependent overload resolution"
    },
    {
	"over_over_context",
	"7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.4",
#else
	"????",
#endif
	"Can't use the overloaded function '%0' in this context"
    },
    {
	"over_over_none",
	"7G",
	0,
	0,
	NULL,
	"None of the overloaded functions '%0' has type '%1'"
    },
    {
	"over_over_ok",
	"9",
	OPT_overload_res,
	0,
	NULL,
	"Address of overloaded function resolves to '%0'"
    },
    {
	"over_oper_bad",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5",
#else
	"????",
#endif
	"Can't overload '%0'"
    },
    {
	"over_oper_static",
	NULL,
	0,
	0,
	NULL,
	"Overloaded operators can't be static members"
    },
    {
	"over_oper_type",
	"6",
	0,
	0,
	NULL,
	"'%0' should have an overloadable parameter type"
    },
    {
	"over_oper_default",
	"6",
	0,
	0,
	NULL,
	"'%0' can't have default arguments"
    },
    {
	"over_oper_func",
	"7",
	0,
	0,
	NULL,
	"'%0' is not a function"
    },
    {
	"over_unary_pars",
	"6MN",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.1",
#else
	"????",
#endif
	"'%0' should have %1 parameter%2"
    },
    {
	"over_binary_pars_p2",
	"6MN",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.2",
#else
	"????",
#endif
	"'%0' should have %1 parameter%2"
    },
    {
	"over_binary_pars_p1",
	"6MMN",
	0,
	0,
	NULL,
	"'%0' should have %1 or %2 parameter%3"
    },
    {
	"over_ass_mem",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.3",
#else
	"????",
#endif
	"'%0' should be a member function"
    },
    {
	"over_ass_pars",
	"6MN",
	0,
	0,
	NULL,
	"'%0' should have %1 parameter%2"
    },
    {
	"over_call_mem",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.4",
#else
	"????",
#endif
	"'%0' should be a member function"
    },
    {
	"over_sub_mem",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.5",
#else
	"????",
#endif
	"'%0' should be a member function"
    },
    {
	"over_sub_pars",
	"6MN",
	0,
	0,
	NULL,
	"'%0' should have %1 parameter%2"
    },
    {
	"over_ref_mem",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.6",
#else
	"????",
#endif
	"'%0' should be a member function"
    },
    {
	"over_ref_pars",
	"6MN",
	0,
	0,
	NULL,
	"'%0' should have %1 parameter%2"
    },
    {
	"over_inc_pars",
	"6MMN",
	0,
	0,
#ifndef ERR_ALTERNATE
	"13.5.7",
#else
	"????",
#endif
	"'%0' should have %1 or %2 parameter%3"
    },
    {
	"over_inc_pars_p2",
	"6G",
	0,
	0,
	NULL,
	"Extra parameter to '%0' should be of type '%1'"
    },
    {
	"temp_decl_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"14",
#else
	"????",
#endif
	"Invalid template declaration"
    },
    {
	"temp_decl_scope",
	NULL,
	0,
	0,
	NULL,
	"A template can only be declared in namespace or class scope"
    },
    {
	"temp_decl_func",
	NULL,
	0,
	0,
	NULL,
	"Can't have partially specialized template functions"
    },
    {
	"temp_decl_one",
	NULL,
	0,
	0,
	NULL,
	"Can only declare a single object in a template declaration"
    },
    {
	"temp_decl_linkage",
	NULL,
	0,
	0,
	NULL,
	"A template can't have C linkage"
    },
    {
	"temp_decl_export",
	"7",
	0,
	0,
	NULL,
	"Can't export the template '%0'"
    },
    {
	"temp_decl_undef",
	"9",
	0,
	0,
	NULL,
	"The non-exported template '%0' has not been defined"
    },
    {
	"temp_param_eof",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.1",
#else
	"????",
#endif
	"End of file in template parameters"
    },
    {
	"temp_param_dup",
	"6",
	0,
	0,
	NULL,
	"Duplicate template parameter '%0'"
    },
    {
	"temp_param_type",
	"7G",
	0,
	0,
	NULL,
	"The template parameter '%0' can't have type '%1'"
    },
    {
	"temp_param_dcl_stc",
	"4",
	0,
	0,
	NULL,
	"Can't apply '%0' to a template parameter"
    },
    {
	"temp_param_default",
	"7",
	0,
	0,
	NULL,
	"The template parameter '%0' should have a default argument"
    },
    {
	"temp_param_func",
	NULL,
	0,
	0,
	NULL,
	"Can't have default arguments in template function"
    },
    {
	"temp_param_redecl",
	NULL,
	0,
	0,
	NULL,
	"Can't have default arguments in template redeclaration"
    },
    {
	"temp_param_none",
	"9",
	0,
	0,
	NULL,
	"No template from which to specialize '%0'"
    },
    {
	"temp_names_eof",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.2",
#else
	"????",
#endif
	"End of file in arguments for template '%0'"
    },
    {
	"temp_names_hack",
	NULL,
	0,
	0,
	NULL,
	"'>>' in template arguments interpreted as '> >'"
    },
    {
	"temp_names_bad",
	NULL,
	0,
	0,
	NULL,
	"Bad 'template' qualifier"
    },
    {
	"temp_names_not",
	"7",
	0,
	0,
	NULL,
	"'template %0' doesn't name a template member"
    },
    {
	"temp_names_mem",
	"7",
	0,
	0,
	NULL,
	"Member '%0' should be prefixed by 'template'"
    },
    {
	"temp_arg_type",
	"79",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.3",
#else
	"????",
#endif
	"Type expected for parameter '%0' of template '%1'"
    },
    {
	"temp_arg_exp",
	"79",
	0,
	0,
	NULL,
	"Expression expected for parameter '%0' of template '%1'"
    },
    {
	"temp_arg_less",
	"9",
	0,
	0,
	NULL,
	"Not enough arguments for template '%0'"
    },
    {
	"temp_arg_more",
	"9",
	0,
	0,
	NULL,
	"Too many arguments for template '%0'"
    },
    {
	"temp_arg_local",
	"G",
	0,
	0,
	NULL,
	"Type argument '%0' should have external linkage"
    },
    {
	"temp_arg_const",
	NULL,
	0,
	0,
	NULL,
	"A non-type template argument should be constant"
    },
    {
	"temp_arg_internal",
	NULL,
	0,
	0,
	NULL,
	"A non-type template argument should have external linkage"
    },
    {
	"temp_arg_over",
	NULL,
	0,
	0,
	NULL,
	"A non-type template argument can't be an overloaded pointer to member"
    },
    {
	"temp_arg_bad",
	NULL,
	0,
	0,
	NULL,
	"Invalid non-type template argument"
    },
    {
	"temp_arg_init",
	"79",
	OPT_whatever,
	0,
	NULL,
	"In initialization of template parameter '%0' of '%1'"
    },
    {
	"temp_arg_templ",
	"79",
	0,
	0,
	NULL,
	"Template name expected for parameter '%0' of template '%1'"
    },
    {
	"temp_arg_templ_not",
	"77",
	0,
	0,
	NULL,
	"Value for template parameter '%0', '%1' does not denote a type name"
    },
    {
	"temp_arg_templ_bad",
	"7G",
	0,
	0,
	NULL,
	"Invalid type for template parameter '%0', '%1'"
    },
    {
	"temp_mem_virtual",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.5.2",
#else
	"????",
#endif
	"A template member function can't be virtual"
    },
    {
	"temp_mem_destr",
	NULL,
	0,
	0,
	NULL,
	"A destructor can't be a template member function"
    },
    {
	"temp_mem_local",
	NULL,
	0,
	0,
	NULL,
	"A local class can't have a template member or friend"
    },
    {
	"temp_class_spec_primary",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.5.4",
#else
	"????",
#endif
	"Specialization '%0' should be more specialized than its primary template"
    },
    {
	"temp_class_spec_depend",
	"G",
	0,
	0,
	NULL,
	"Dependent non-type argument in specialization '%0'"
    },
    {
	"temp_class_spec_darg",
	NULL,
	0,
	0,
	NULL,
	"Can't have default arguments in template specialization"
    },
    {
	"temp_class_spec_ambig",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.5.4.1",
#else
	"????",
#endif
	"Ambiguous specialization for template '%0'"
    },
    {
	"temp_class_spec_match",
	"9",
	OPT_wall,
	0,
	NULL,
	"Specialization '%0' used"
    },
    {
	"temp_res_nspace",
	"AG",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.6",
#else
	"????",
#endif
	"Qualifier '%0' expands to the non-class type '%1'"
    },
    {
	"temp_res_qual",
	NULL,
	0,
	0,
	NULL,
	"Qualifier in 'typename' doesn't depend on a template parameter"
    },
    {
	"temp_res_type",
	"A6",
	0,
	0,
	NULL,
	"'typename %0::%1' doesn't denote a type"
    },
    {
	"temp_res_key",
	"179G",
	0,
	0,
	NULL,
	"Template parameter '%1' of '%2' should be '%0', not '%3'"
    },
    {
	"temp_local_not",
	"G",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.6.1",
#else
	"????",
#endif
	"Can't use the template type '%0' in this context"
    },
    {
	"temp_local_hide",
	"7",
	0,
	0,
	NULL,
	"Can't hide the template parameter '%0'"
    },
    {
	"temp_spec_type",
	"G7",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.7",
#else
	"????",
#endif
	"Invalid type '%0' for specialization of template '%1'"
    },
    {
	"temp_spec_bad",
	"G",
	0,
	0,
	NULL,
	"Invalid specialization for template '%0'"
    },
    {
	"temp_spec_member",
	"9",
	0,
	0,
	NULL,
	"Can't specialize '%0' in a class"
    },
    {
	"temp_spec_prefix",
	NULL,
	OPT_new,
	0,
	NULL,
	"'template <>' required in template specialization"
    },
    {
	"temp_spec_reinst",
	"G",
	0,
	0,
	NULL,
	"Template '%0' already explicitly instantiated"
    },
    {
	"temp_spec_respec",
	"G",
	OPT_none,
	0,
	NULL,
	"Template '%0' already explicitly specialized"
    },
    {
	"temp_spec_redecl",
	"G",
	0,
	0,
	NULL,
	"Template '%0' both explicitly instantiated and explicitly specialized"
    },
    {
	"temp_spec_used",
	"G",
	0,
	0,
	NULL,
	"Template '%0' specialized after use"
    },
    {
	"temp_spec_post",
	"GG",
	0,
	0,
	NULL,
	"Template specialization '%0' matches previously used instance '%1'"
    },
    {
	"temp_inst_def",
	"G",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"14.7.1",
#else
	"????",
#endif
	"Instantiating template '%0'"
    },
    {
	"temp_inst_depth",
	"L",
	0,
	0,
	NULL,
	"Template instantiation depth too great (%0)"
    },
    {
	"temp_inst_comment",
	"GD",
	OPT_whatever,
	0,
	NULL,
	"In instantiation of template '%0' (at %1)"
    },
    {
	"temp_explicit_bad",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.7.2",
#else
	"????",
#endif
	"No template from which to instantiate '%0'"
    },
    {
	"temp_explicit_id",
	"7",
	OPT_none,
	0,
	NULL,
	"'%0 <>' required in explicit template instantiation"
    },
    {
	"temp_explicit_def",
	NULL,
	0,
	0,
	NULL,
	"Can't have definition in explicit template instantiation"
    },
    {
	"temp_explicit_incompl",
	NULL,
	0,
	0,
	NULL,
	"Complete class required in explicit template instantiation"
    },
    {
	"temp_explicit_templ",
	NULL,
	0,
	0,
	NULL,
	"Invalid template instantiation"
    },
    {
	"temp_expl_spec_dargs",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.7.3",
#else
	"????",
#endif
	"Can't have default function arguments in explicit specialization"
    },
    {
	"temp_deduct_fail",
	"9",
	0,
	0,
#ifndef ERR_ALTERNATE
	"14.8.2",
#else
	"????",
#endif
	"Template argument deduction failed for '%0'"
    },
    {
	"temp_deduct_undef",
	"79",
	0,
	0,
	NULL,
	"Can't deduce value of template parameter '%0'"
    },
    {
	"except_handlers",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"15",
#else
	"????",
#endif
	"A 'try' block must have at least one associated 'catch' handler"
    },
    {
	"except_not",
	NULL,
	OPT_throw_bad,
	0,
	NULL,
	"Body of 'try' block doesn't throw an exception"
    },
    {
	"except_jump_into",
	NULL,
	0,
	0,
	NULL,
	"Can't jump into a 'try' block or handler"
    },
    {
	"except_throw_type",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"15.1",
#else
	"????",
#endif
	"Can only throw an expression, not a type"
    },
    {
	"except_throw_typedef",
	NULL,
	0,
	0,
	NULL,
	"Can't define a type in a 'throw' expression"
    },
    {
	"except_throw_copy",
	NULL,
	OPT_whatever,
	0,
	NULL,
	"'throw' expression is copied to temporary variable"
    },
    {
	"except_throw_incompl",
	NULL,
	0,
	0,
	NULL,
	"Can't throw a reference to an incomplete class"
    },
    {
	"except_throw_ambig",
	NULL,
	OPT_none,
	0,
	NULL,
	"Can't throw an expression with an ambiguous base class"
    },
    {
	"except_handle_typedef",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"15.3",
#else
	"????",
#endif
	"Can't define a type in an exception declaration"
    },
    {
	"except_handle_unreach",
	"GG",
	OPT_throw_bad,
	0,
	NULL,
	"Exceptions of type '%0' will be caught by the previous '%1' handler"
    },
    {
	"except_handle_ellipsis",
	NULL,
	0,
	0,
	NULL,
	"A '...' exception handler must be the last in its block"
    },
    {
	"except_handle_incompl",
	NULL,
	0,
	0,
	NULL,
	"Can't catch a reference to an incomplete class"
    },
    {
	"except_handle_return",
	"7",
	0,
	0,
	NULL,
	"Can't return from exception handler in '%0'"
    },
    {
	"except_spec_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"15.4",
#else
	"????",
#endif
	"Can only use exception specification in a function declarator"
    },
    {
	"except_spec_typedef",
	NULL,
	0,
	0,
	NULL,
	"Can't define a type in an exception specification"
    },
    {
	"except_spec_ellipsis",
	NULL,
	0,
	0,
	NULL,
	"Can't use '...' in an exception specification"
    },
    {
	"except_spec_incompl",
	NULL,
	OPT_new,
	0,
	NULL,
	"Can't have a reference to an incomplete class in an exception specification"
    },
    {
	"except_spec_wrong",
	"7D",
	0,
	0,
	NULL,
	"Redeclaration of '%0' should have the same exception specifiers (see %1)"
    },
    {
	"except_spec_virtual",
	"79D",
	0,
	0,
	NULL,
	"Exception specifiers for overriding virtual function '%0' should be more restrictive than those for '%1' (see %2)"
    },
    {
	"except_spec_assign",
	NULL,
	0,
	0,
	NULL,
	"Exception specifiers in conversion should be more restrictive"
    },
    {
	"except_spec_init",
	NULL,
	0,
	0,
	NULL,
	"Exception specifiers in initialization should match"
    },
    {
	"except_spec_throw",
	"G",
	OPT_throw_bad,
	0,
	NULL,
	"Uncaught exception of type '%0' thrown"
    },
    {
	"except_spec_call",
	"9G",
	OPT_throw_bad,
	0,
	NULL,
	"Function '%0' may throw an uncaught exception of type '%1'"
    },
    {
	"cpp_bad",
	NULL,
	OPT_ppdir_id,
	0,
#ifndef ERR_ALTERNATE
	"16",
#else
	"6.8",
#endif
	"Bad preprocessing directive"
    },
    {
	"cpp_unknown",
	"6",
	OPT_ppdir_unknown,
	0,
	NULL,
	"Unknown preprocessing directive, '#%0'"
    },
    {
	"cpp_end",
	"8",
	0,
	0,
	NULL,
	"End of '#%0' directive expected"
    },
    {
	"cpp_indent",
	NULL,
	OPT_ppdir_indent,
	0,
	NULL,
	"Indented preprocessing directive"
    },
    {
	"cpp_indent_dir",
	NULL,
	OPT_ppdir_indent_dir,
	0,
	NULL,
	"Space after '#' in preprocessing directive"
    },
    {
	"cpp_space_replace",
	NULL,
	0,
	0,
	NULL,
	"White space required before illegal character in replacement list"
    },
    {
	"cpp_old",
	"8",
	OPT_none,
	0,
	NULL,
	"Pre-ISO preprocessors don't handle '#%0'"
    },
    {
	"cpp_cond_if_match",
	"88",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.1",
#else
	"6.8.1",
#endif
	"'#%0' without matching '#%1'"
    },
    {
	"cpp_cond_else_dup",
	"88D",
	0,
	0,
	NULL,
	"'#%0' after '#%1' (at %2)"
    },
    {
	"cpp_cond_def_id",
	NULL,
	0,
	0,
	NULL,
	"Bad 'defined' operation"
    },
    {
	"cpp_cond_def_replace",
	NULL,
	OPT_wall,
	0,
	NULL,
	"Macro expansion gives 'defined'"
    },
    {
	"cpp_cond_ifdef_id",
	"8",
	0,
	0,
	NULL,
	"Macro identifier expected after '#%0'"
    },
    {
	"cpp_cond_zero",
	"6",
	OPT_none,
	0,
	NULL,
	"Identifier '%0' replaced by '0'"
    },
    {
	"cpp_cond_if_const",
	"8",
	0,
	0,
	NULL,
	"Integer constant expression expected after '#%0'"
    },
    {
	"cpp_cond_if_ti",
	"8",
	OPT_wall,
	0,
	NULL,
	"Target dependent '#%0'"
    },
    {
	"cpp_cond_if_ti_decl",
	"8",
	OPT_decl_cond,
	0,
	NULL,
	"Can't have target dependent '#%0' at outer level"
    },
    {
	"cpp_cond_if_jump_into",
	NULL,
	0,
	0,
	NULL,
	"Can't jump into a target dependent '#if' statement"
    },
    {
	"cpp_cond_if_macro",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.1",
#else
	"6.8.1",
#endif
	"Can't define macro '%0' in a target dependent '#if' statement"
    },
    {
	"cpp_cond_endif_end",
	"8",
	OPT_ppdir_text,
	0,
	NULL,
	"No text allowed after '#%0' directive"
    },
    {
	"cpp_include_bad",
	NULL,
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.2",
#else
	"6.8.2",
#endif
	"Illegal header name"
    },
    {
	"cpp_include_incompl",
	NULL,
	0,
	0,
	NULL,
	"Incomplete header name"
    },
    {
	"cpp_include_undef",
	"J",
	OPT_wall,
	0,
	NULL,
	"Undefined header name, '%0'"
    },
    {
	"cpp_include_empty",
	NULL,
	0,
	0,
	NULL,
	"Empty header name"
    },
    {
	"cpp_include_full",
	"J",
	OPT_include_full,
	0,
	NULL,
	"Inclusion of '%0' may not be portable"
    },
    {
	"cpp_include_unknown",
	"J",
	0,
	0,
	NULL,
	"Can't open included file, '%0'"
    },
    {
	"cpp_include_open",
	"J",
	OPT_include_verbose,
	0,
	NULL,
	"Opening included file, '%0'"
    },
    {
	"cpp_include_close",
	"J",
	OPT_include_verbose,
	0,
	NULL,
	"Closing included file, '%0'"
    },
    {
	"cpp_include_depth",
	"L",
	0,
	0,
	NULL,
	"Include depth too great (%0)"
    },
    {
	"cpp_include_dup",
	"JD",
	OPT_include_verbose,
	0,
	NULL,
	"File '%0' has already been included (from %1)"
    },
    {
	"cpp_include_date",
	NULL,
	OPT_wall,
	0,
	NULL,
	"Date stamp on file has changed"
    },
    {
	"cpp_replace_id",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.3",
#else
	"6.8.3",
#endif
	"Macro identifier expected after '#%0'"
    },
    {
	"cpp_replace_redef_ok",
	"7D",
	OPT_none,
	0,
	NULL,
	"Macro '%0' redefined (see %1)"
    },
    {
	"cpp_replace_redef_bad",
	"7D",
	OPT_macro_redef,
	0,
	NULL,
	"Macro '%0' redefined inconsistently (see %1)"
    },
    {
	"cpp_replace_redef_weak",
	"7D",
	OPT_macro_weak,
	0,
	NULL,
	"Macro '%0' redefined with parameter renaming (see %1)"
    },
    {
	"cpp_replace_redef_space",
	"7D",
	OPT_macro_weak,
	0,
	NULL,
	"Macro '%0' redefined with differing white space (see %1)"
    },
    {
	"cpp_replace_redef_nest",
	"7D",
	OPT_macro_nest,
	0,
	NULL,
	"Nested definition of macro '%0' (see %1)"
    },
    {
	"cpp_replace_par_dup",
	"66",
	0,
	0,
	NULL,
	"Parameter '%0' already defined for macro '%1'"
    },
    {
	"cpp_replace_par_bad",
	"6",
	0,
	0,
	NULL,
	"Badly punctuated parameters for macro '%0'"
    },
    {
	"cpp_replace_arg_none",
	"6",
	OPT_wall,
	0,
	NULL,
	"Macro '%0' invoked without arguments"
    },
    {
	"cpp_replace_arg_empty",
	"M6",
	OPT_wall,
	0,
	NULL,
	"Argument %0 for macro '%1' is empty"
    },
    {
	"cpp_replace_arg_ppdir",
	"6",
	OPT_macro_arg_dir,
	0,
	NULL,
	"Preprocessing directive in arguments for macro '%0'"
    },
    {
	"cpp_replace_arg_eof",
	"6",
	0,
	0,
	NULL,
	"Unterminated arguments for macro '%0'"
    },
    {
	"cpp_replace_arg_number",
	"6MNM",
	0,
	0,
	NULL,
	"Macro '%0' applied with %1 argument%2, not %3"
    },
    {
	"cpp_stringize_par",
	"6",
	OPT_hash_ident,
	0,
#ifndef ERR_ALTERNATE
	"16.3.2",
#else
	"6.8.3.2",
#endif
	"'#' should be followed by a parameter for macro '%0'"
    },
    {
	"cpp_stringize_bad",
	"6",
	0,
	0,
	NULL,
	"Invalid string formed by macro '%0'"
    },
    {
	"cpp_stringize_old",
	"66",
	OPT_wall,
	0,
	NULL,
	"Quoted parameter '%0' in definition of macro '%1'"
    },
    {
	"cpp_concat_place",
	"6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.3.3",
#else
	"6.8.3.3",
#endif
	"Badly placed '##' operator in macro '%0'"
    },
    {
	"cpp_concat_bad",
	"6",
	0,
	0,
	NULL,
	"Invalid result for '##' operator in macro '%0'"
    },
    {
	"cpp_rescan_recursive",
	"6",
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"16.3.4",
#else
	"6.8.3.4",
#endif
	"Macro '%0' used recursively"
    },
    {
	"cpp_scope_id",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.3.5",
#else
	"6.8.3.5",
#endif
	"Macro identifier expected after '#%0'"
    },
    {
	"cpp_scope_undef",
	"6",
	OPT_none,
	0,
	NULL,
	"Undefined macro '%0' was not defined"
    },
    {
	"cpp_line_bad",
	"8",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.4",
#else
	"6.8.4",
#endif
	"Line number expected after '#%0'"
    },
    {
	"cpp_line_float",
	"8",
	0,
	0,
	NULL,
	"Invalid line number in '#%0'"
    },
    {
	"cpp_line_range",
	"8",
	0,
	0,
	NULL,
	"Line number out of range in '#%0'"
    },
    {
	"cpp_error_msg",
	"J",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.5",
#else
	"6.8.5",
#endif
	"%0"
    },
    {
	"cpp_pragma_unknown",
	"8",
	OPT_pragma_unknown,
	0,
#ifndef ERR_ALTERNATE
	"16.6",
#else
	"6.8.6",
#endif
	"Unknown '#%0' directive"
    },
    {
	"cpp_null",
	NULL,
	OPT_wall,
	0,
#ifndef ERR_ALTERNATE
	"16.7",
#else
	"6.8.7",
#endif
	"Null preprocessing directive"
    },
    {
	"cpp_predef_bad",
	"68",
	0,
	0,
#ifndef ERR_ALTERNATE
	"16.8",
#else
	"6.8.8",
#endif
	"Identifier '%0' subject of '#%1' directive"
    },
    {
	"cpp_predef_undef",
	"7",
	0,
	0,
	NULL,
	"Undefining built-in macro '%0'"
    },
    {
	"cpp_predef_redef",
	"7",
	0,
	0,
	NULL,
	"Built-in macro '%0' redefined"
    },
    {
	"cpp_predef_keyword",
	"6",
	OPT_wall,
	0,
	NULL,
	"Keyword '%0' redefined using '#define'"
    },
    {
	"lib_builtin",
	"J6",
	0,
	0,
#ifndef ERR_ALTERNATE
	"18",
#else
	"????",
#endif
	"Built-in '%0::%1' not declared"
    },
    {
	"printf_unknown",
	"J",
	OPT_printf_string,
	9,
	NULL,
	"Unknown format string, '%0'"
    },
    {
	"printf_invalid",
	"J",
	OPT_printf_string,
	9,
	NULL,
	"Invalid format string, '%0'"
    },
    {
	"printf_unterm",
	"J",
	OPT_printf_string,
	9,
	NULL,
	"Unterminated '%0' format string"
    },
    {
	"printf_flags",
	"JJ",
	OPT_printf_string,
	9,
	NULL,
	"Can't have flags '%0' with '%1' format string"
    },
    {
	"printf_width",
	"J",
	OPT_printf_string,
	9,
	NULL,
	"Can't have field width with '%0' format string"
    },
    {
	"printf_precision",
	"J",
	OPT_printf_string,
	9,
	NULL,
	"Can't have precision with '%0' format string"
    },
    {
	"printf_arg_zero",
	NULL,
	OPT_printf_string,
	9,
	NULL,
	"Can't have argument zero in format string"
    },
    {
	"printf_arg_large",
	"M",
	OPT_printf_string,
	9,
	NULL,
	"Argument %0 in format string out of range"
    },
    {
	"printf_arg_compat",
	"M",
	OPT_printf_string,
	9,
	NULL,
	"Incompatible format string for argument %0"
    },
    {
	"printf_arg_none",
	"M",
	OPT_printf_string,
	9,
	NULL,
	"No format string given for argument %0"
    },
    {
	"printf_arg_mix",
	NULL,
	OPT_printf_string,
	9,
	NULL,
	"Can't mix numbered and unnumbered arguments in format string"
    },
    {
	"limits_max",
	"JLL",
	0,
	0,
#ifndef ERR_ALTERNATE
	"Annex B",
#else
	"5.2.4.1",
#endif
	"Value for '%0' (%1) exceeds implementation limit (%2)"
    },
    {
	"limits_min",
	"JLL",
	OPT_wall,
	0,
	NULL,
	"Value for '%0' (%1) exceeds minimum implementation limit (%2)"
    },
    {
	"pragma_scope_undef",
	"6",
	0,
	5,
	"",
	"Checking scope '%0' not defined"
    },
    {
	"pragma_scope_redef",
	"6",
	0,
	5,
	NULL,
	"Checking scope '%0' already defined"
    },
    {
	"pragma_scope_end",
	NULL,
	0,
	5,
	NULL,
	"Unexpected end of checking scope"
    },
    {
	"pragma_scope_set",
	"J",
	0,
	5,
	NULL,
	"Option '%0' has already been set in this scope"
    },
    {
	"pragma_dblock_name",
	"6",
	0,
	5,
	NULL,
	"Name mismatch for end of declaration block '%0'"
    },
    {
	"pragma_dblock_end",
	NULL,
	0,
	5,
	NULL,
	"Unexpected end of declaration block"
    },
    {
	"pragma_dir_undef",
	"J",
	0,
	5,
	NULL,
	"Directory '%0' not defined"
    },
    {
	"pragma_dir_mode",
	"J",
	0,
	5,
	NULL,
	"Checking mode for directory '%0' already defined"
    },
    {
	"pragma_error_bad",
	"F",
	0,
	5,
	NULL,
	"Unknown error, %0"
    },
    {
	"pragma_option_bad",
	"F",
	0,
	5,
	NULL,
	"Unknown option, %0"
    },
    {
	"pragma_keyword_bad",
	"6",
	0,
	5,
	NULL,
	"Unknown keyword, '%0'"
    },
    {
	"pragma_char_lit",
	"G",
	0,
	5,
	NULL,
	"Character literal should have integral type, not '%0'"
    },
    {
	"pragma_builtin_type",
	"G",
	0,
	5,
	NULL,
	"Built-in type should be integral, not '%0'"
    },
    {
	"pragma_promote_type",
	"G",
	0,
	5,
	NULL,
	"Promotion type should be integral, not '%0'"
    },
    {
	"pragma_promote_compat",
	"G",
	OPT_whatever,
	5,
	NULL,
	"Promotion types for '%0' should be compatible"
    },
    {
	"pragma_compat_type",
	NULL,
	0,
	5,
	NULL,
	"Invalid arguments for directive"
    },
    {
	"pragma_arg_dup",
	"G",
	0,
	5,
	NULL,
	"Inconsistent compatible argument type for '%0'"
    },
    {
	"pragma_arg_cycle",
	NULL,
	0,
	5,
	NULL,
	"Directive completes a cycle of compatible argument types"
    },
    {
	"pragma_lit_type",
	"G",
	0,
	5,
	NULL,
	"Literal type should be a promoted integral type, not '%0'"
    },
    {
	"pragma_lit_range",
	"BG",
	OPT_none,
	5,
	NULL,
	"Literal limit '%0' doesn't fit into type '%1'"
    },
    {
	"pragma_lit_question",
	NULL,
	0,
	5,
	NULL,
	"Type required in '?:' literal limit"
    },
    {
	"pragma_token_sort",
	"7",
	0,
	33,
	NULL,
	"Invalid sort for token '%0'"
    },
    {
	"pragma_preserve_undecl",
	"87",
	0,
	5,
	NULL,
	"Identifier in '%0' directive, '%1', doesn't have linkage"
    },
    {
	"pragma_weak_redef",
	"7",
	0,
	5,
	NULL,
	"Weak symbol '%0' already defined"
    },
    {
	"pragma_cpp_known",
	"8",
	0,
	5,
	NULL,
	"Preprocessing directive '#%0' used"
    },
    {
	"pragma_cpp_ident",
	"8",
	0,
	5,
	NULL,
	"String literal expected after '#%0'"
    },
    {
	"pragma_assert_id",
	"8",
	0,
	5,
	NULL,
	"Predicate identifier expected after '#%0'"
    },
    {
	"pragma_assert_open",
	"8",
	0,
	5,
	NULL,
	"Open bracket expected after predicate in '#%0'"
    },
    {
	"pragma_assert_paren",
	"8",
	0,
	5,
	NULL,
	"Unterminated predicate token sequence in '#%0'"
    },
    {
	"pragma_assert_empty",
	"8",
	0,
	5,
	NULL,
	"Empty predicate token sequence in '#%0'"
    },
    {
	"pragma_assert_pred",
	"6",
	OPT_ppdir_assert,
	5,
	NULL,
	"Predicate '%0' used"
    },
    {
	"port_entry_undef",
	"J",
	0,
	5,
	NULL,
	"Portability table entry '%0' not defined"
    },
    {
	"port_entry_redef",
	"J",
	0,
	5,
	NULL,
	"Portability table entry '%0' already defined"
    },
    {
	"token_info",
	"7",
	OPT_whatever,
	33,
	"",
	"'%0' is tokenized"
    },
    {
	"token_redecl",
	"7D",
	0,
	33,
	NULL,
	"Token '%0' declared inconsistently (see %1)"
    },
    {
	"token_redef",
	"7D",
	0,
	33,
	NULL,
	"Incompatible redefinition for token '%0' (see %1)"
    },
    {
	"token_redef_ok",
	"7D",
	OPT_token_redef,
	33,
	NULL,
	"Redefinition of token '%0' (see %1)"
    },
    {
	"token_undef",
	"7",
	OPT_token_undef,
	33,
	NULL,
	"Token '%0' not defined"
    },
    {
	"token_undecl",
	"7",
	0,
	33,
	NULL,
	"Token '%0' not declared"
    },
    {
	"token_qual",
	"7",
	0,
	33,
	NULL,
	"Can't qualify the token name '%0'"
    },
    {
	"token_scope",
	"7",
	0,
	33,
	NULL,
	"Identifier '%0' used out of scope"
    },
    {
	"token_no_def",
	"7D",
	0,
	33,
	NULL,
	"Token in 'no_def' directive, '%0', has already been defined (at %1)"
    },
    {
	"token_def_not",
	"7",
	0,
	33,
	NULL,
	"Can't define token '%0'"
    },
    {
	"token_def_args",
	"7",
	0,
	33,
	NULL,
	"Wrong number of parameters in definition of token '%0'"
    },
    {
	"token_def_func",
	"7G",
	0,
	33,
	NULL,
	"Function of type '%1' required in 'FUNC' token definition, not '%0'"
    },
    {
	"token_def_ambig",
	"7",
	0,
	33,
	NULL,
	"Ambiguous 'FUNC' token '%0' in definition"
    },
    {
	"token_def_except",
	NULL,
	0,
	33,
	NULL,
	"Exception specifiers should match in 'FUNC' token definition"
    },
    {
	"token_def_implicit",
	"7",
	OPT_func_token_undef,
	33,
	NULL,
	"Implicit definition of token '%0'"
    },
    {
	"token_proc_high",
	NULL,
	0,
	33,
	NULL,
	"High-level 'PROC' tokens not allowed"
    },
    {
	"token_func",
	"G",
	0,
	33,
	NULL,
	"A 'FUNC' token should have function type, not '%0'"
    },
    {
	"token_mem",
	"G",
	0,
	33,
	NULL,
	"The second type in a 'MEMBER' token should have class type, not '%0'"
    },
    {
	"token_mem_off",
	NULL,
	OPT_whatever,
	33,
	NULL,
	"Constant offset required in 'MEMBER' token"
    },
    {
	"token_stmt_ret",
	"7",
	0,
	33,
	NULL,
	"Can't have 'return' statement in 'STATEMENT' token '%0'"
    },
    {
	"token_stmt_jump",
	NULL,
	0,
	33,
	NULL,
	"Jump into 'STATEMENT' token"
    },
    {
	"token_const",
	"7",
	OPT_token_const,
	33,
	NULL,
	"Non-constant 'EXP' token '%0' used in constant expression"
    },
    {
	"token_arg_sort",
	"7",
	0,
	33,
	NULL,
	"Wrong sort for 'PROC' token parameter '%0'"
    },
    {
	"token_arg_bad",
	"7",
	0,
	33,
	NULL,
	"Invalid 'PROC' token parameter '%0'"
    },
    {
	"token_arg_exp",
	"7",
	OPT_whatever,
	33,
	NULL,
	"Values for 'EXP' token '%0' are converted to the token type"
    },
    {
	"token_arg_const",
	"7",
	0,
	33,
	NULL,
	"Non-constant value for constant 'EXP' token '%0'"
    },
    {
	"token_arg_lvalue",
	"7",
	0,
	33,
	NULL,
	"Value for lvalue 'EXP' token '%0' is an rvalue"
    },
    {
	"token_arg_mem",
	"7",
	OPT_whatever,
	33,
	NULL,
	"Types for 'MEMBER' token '%0' should be compatible"
    },
    {
	"token_arg_nat",
	"7",
	0,
	33,
	NULL,
	"Non-negative integer constant required in 'NAT' token '%0'"
    },
    {
	"token_arg_type",
	"87G",
	0,
	33,
	NULL,
	"Invalid type for '%0' token '%1', '%2'"
    },
    {
	"token_recursive",
	"7",
	0,
	33,
	NULL,
	"Token '%0' defined recursively"
    },
    {
	"token_arg_undef",
	"77",
	0,
	33,
	NULL,
	"Can't deduce value of token parameter '%0' in application of token '%1'"
    },
    {
	"token_conv",
	"7GG",
	OPT_none,
	33,
	NULL,
	"Using token '%0' for conversion from '%1' to '%2'"
    },
    {
	NULL,
	NULL,
	0,
	0,
	NULL,
	NULL
    }
} ;
