---
myst:
  html_meta:
    keywords: LaTeX, langages de programmation, mise en forme de code, coloration syntaxique, formater un programme,formater du code, verbatim, insérer du code-source, listing informatique, listing, minted
---

# Comment présenter du code informatique avec le package <ctanpkg:minted> ?

<ctanpkg:minted> est un package permettant de mettre en forme du code
informatique. Il en existe d’autres, par exemple <ctanpkg:listings>.

Pour les autres possibilités, voir
[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique).

::::{attention}
- L’utilisation de <ctanpkg:minted> nécessite une compilation avec l’option
[shell-escape](/2_programmation/compilation/write18.md).
  :::{admonition} À noter
  :class: note
  Cette page ne permet pas la compilation avec l’option shell-escape pour des raisons de
  sécurité.
  :::
- La coloration se fait à l’aide de la bibliothèque `Python`
[Pygments](https://pygments.org/) qui doit être installée sur la machine.
::::

## Installer `Pygments`
Pour l’installation, on utilise son gestionnaire de paquets `Python` (`pip`,
`conda` ou autre…).

Par exemple, dans un environement `Python` on peut entrer :
```text
pip install Pygments
```

## Un premier exemple

Une fois `Pygments` installé, on peut utiliser <ctanpkg:minted> très simplement
(à condition  de lancer la compilation avec l'option `shell-escape`).

Ci-dessous un permier exemple.

```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage{minted}

\begin{document}
\begin{minted}{python}
# Une  boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != 4: 
    print("Encore ?? Et oui, on est reparti pour un tour de plus !!!!")
\end{minted}
\end{document}
```

La compilation du code donne :

![](/_static/images/minted_1.png)

## Avec quelques options supplémentaires
```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage{minted}

\begin{document}
\begin{minted}[breaklines,linenos,numbersep=3mm]{python}
# Une  boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != 4: 
    print("Encore ? Eh bien oui, on est reparti pour un tour
    supplémentaire... c'est sans fin !")
\end{minted}
\end{document}
```

La compilation du code donne :

![](/_static/images/minted_2.png)


:::{note}
L’option ```breaklines``` permet le retour à la ligne automatique.
:::

## Code en mode *inline*

Pour insérer de cours extraits de code dans du texte, <ctanpkg:minted> fournit la
commande ```\mintinline{⟨langage⟩}``` dont la syntaxe générale est la suivante :

```{noedit}
\mintinline{⟨langage⟩}⟨caractère au choix⟩⟨code⟩⟨(même) caractère au choix⟩
```

Un exemple ci-dessous :

```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage{minted}

\begin{document}
En Python, on utilise \mintinline{python}|for| pour les boucles bornées et
\mintinline{python}|while| pour les boucles non bornées.
\end{document}
```

La compilation du code donne :

![](/_static/images/minted_3.png)

:::{note}
 - On note l’absence d’accolades pour délimiter le code après ```\mintinline{python}```,
   mais la présence d’un « _caractère au choix_ », qui doit être le même au début et à la
   fin.
 - Dans cet exemple, on a choisi « | » comme caractère.
::::

:::{admonition} Info
:class: tip
Pour une mise en page plus élaborée, on pourra utiliser le package
<ctanpkg:tcolorbox> :
cf. [](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_tcolorbox.md).
:::
