//////////////////////////////////////////////////////////////////////////////
// Name:        SVGStringList.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genList.py
//////////////////////////////////////////////////////////////////////////////

#include "SVGStringList.h"
#include <wx/tokenzr.h>
#include <wx/arrimpl.cpp>
WX_DEFINE_OBJARRAY(wxSVGStringListBase);

wxString wxSVGStringList::GetValueAsString(wxChar delimiter) const {
	wxString value;
	for (unsigned int i = 0; i < GetCount(); i++) {
		if (i > 0) {
			value += delimiter;
		}
		value += Item(i);
	}
	return value;
}

void wxSVGStringList::SetValueAsString(const wxString& value, wxChar delimiter) {
	Clear();
	wxStringTokenizer tkz(value, delimiter);
	while (tkz.HasMoreTokens()) {
		Add(tkz.GetNextToken().Strip(wxString::both));
	}
}
