
/* 

 * Copyright (c) 2009 - 2011, Andy Bierman
 * All Rights Reserved.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *

*** Generated by yangdump 2.1.1539M

    Combined SIL module
    module device_test
    revision 2011-09-07
    namespace http://netconfcentral.org/ns/device_test

 */

//extern "C" {
#include <libxml/xmlstring.h>

#include "procdefs.h"
#include "agt.h"
#include "agt_cb.h"
#include "agt_rpc.h"
#include "agt_timer.h"
#include "agt_util.h"
#include "dlq.h"
#include "ncx.h"
#include "ncxmod.h"
#include "ncxtypes.h"
#include "rpc.h"
#include "ses.h"
#include "status.h"
#include "val.h"
#include "val_util.h"
#include "xml_util.h"
#include "device_test.h"
//}

#include "test/support/callbacks/sil-callback-log.h"

/* module static variables */
static ncx_module_t *device_test_mod;
static obj_template_t *xpo_obj;
static obj_template_t *copy_profile_obj;
static val_value_t *xpo_val;

/* put your static variables here */


/********************************************************************
* FUNCTION y_device_test_init_static_vars
* 
* initialize module static variables
* 
********************************************************************/
static void y_device_test_init_static_vars (void)
{
    device_test_mod = NULL;
    xpo_obj = NULL;
    copy_profile_obj = NULL;
    xpo_val = NULL;

    /* init your static variables here */

} /* y_device_test_init_static_vars */


/********************************************************************
* FUNCTION device_test_xpo_profile_id_edit
* 
* Edit database object callback
* Path: /xpo/profile/id
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_id_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_id_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_id_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_id_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_id_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/id
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_id_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_id_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_id_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_id_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_id_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/id
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_id_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_id_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_id_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_id_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_resourceType_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/resourceType
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_resourceType_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_resourceType_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_resourceType_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_resourceType_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_channelId_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/channelId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_channelId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_channelId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_channelId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_channelId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_configuration_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/configuration
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_configuration_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_configuration_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_configuration_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_configuration_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_statusConfig_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/statusConfig
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_statusConfig_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_statusConfig_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_statusConfig_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_statusConfig_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_alarmConfig_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/alarmConfig
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_alarmConfig_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_alarmConfig_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_alarmConfig_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_alarmConfig_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_physicalPath_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode/physicalPath
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_physicalPath_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_physicalPath_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_physicalPath_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_physicalPath_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceNode_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceNode
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceNode_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceNode_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceNode_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceNode_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_id_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/id
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_id_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_id_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_id_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_id_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_sourceId_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/sourceId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_sourceId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    val_value_t *lastkey = NULL;
    uint32 k_xpo_profile_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_resourceConnection_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    (void)k_xpo_profile_id;
    (void)k_xpo_profile_stream_id;
    (void)k_xpo_profile_stream_resourceConnection_id;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_sourceId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_sourceId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_sourceId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/sourcePinId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    val_value_t *lastkey = NULL;
    uint32 k_xpo_profile_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_resourceConnection_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    (void)k_xpo_profile_id;
    (void)k_xpo_profile_stream_id;
    (void)k_xpo_profile_stream_resourceConnection_id;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_destinationId_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/destinationId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_destinationId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    val_value_t *lastkey = NULL;
    uint32 k_xpo_profile_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_resourceConnection_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    (void)k_xpo_profile_id;
    (void)k_xpo_profile_stream_id;
    (void)k_xpo_profile_stream_resourceConnection_id;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_destinationId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_destinationId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_destinationId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/destinationPinId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    val_value_t *lastkey = NULL;
    uint32 k_xpo_profile_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_resourceConnection_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    (void)k_xpo_profile_id;
    (void)k_xpo_profile_stream_id;
    (void)k_xpo_profile_stream_resourceConnection_id;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_bitrate_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection/bitrate
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_bitrate_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    val_value_t *lastkey = NULL;
    uint32 k_xpo_profile_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    uint32 k_xpo_profile_stream_resourceConnection_id = VAL_UINT(agt_get_key_value(errorval, &lastkey));
    (void)k_xpo_profile_id;
    (void)k_xpo_profile_stream_id;
    (void)k_xpo_profile_stream_resourceConnection_id;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_bitrate_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_bitrate_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_bitrate_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_resourceConnection_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream/resourceConnection
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_resourceConnection_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_resourceConnection_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_resourceConnection_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_resourceConnection_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_stream_edit
* 
* Edit database object callback
* Path: /xpo/profile/stream
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_stream_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_stream_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_stream_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_stream_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_id_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/id
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_id_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_id_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_id_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_id_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_sourceStreamId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/sourceStreamId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_sourceStreamId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_sourceStreamId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_sourceStreamId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_sourceStreamId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_destinationStreamId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/destinationStreamId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_destinationStreamId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_destinationStreamId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_destinationStreamId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_destinationStreamId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_sourceId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/sourceId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_sourceId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_sourceId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_sourceId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_sourceId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_sourcePinId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/sourcePinId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_sourcePinId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_sourcePinId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_sourcePinId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_sourcePinId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_destinationId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/destinationId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_destinationId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_destinationId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_destinationId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_destinationId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_destinationPinId_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/destinationPinId
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_destinationPinId_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_destinationPinId_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_destinationPinId_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_destinationPinId_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_bitrate_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection/bitrate
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_bitrate_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_bitrate_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_bitrate_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_bitrate_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_streamConnection_edit
* 
* Edit database object callback
* Path: /xpo/profile/streamConnection
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_streamConnection_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_streamConnection_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_streamConnection_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_streamConnection_edit */


/********************************************************************
* FUNCTION device_test_xpo_profile_edit
* 
* Edit database object callback
* Path: /xpo/profile
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_profile_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_profile_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_profile_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_profile_edit */


/********************************************************************
* FUNCTION device_test_xpo_activeProfile_edit
* 
* Edit database object callback
* Path: /xpo/activeProfile
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_activeProfile_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_activeProfile_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_activeProfile_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_activeProfile_edit */


/********************************************************************
* FUNCTION device_test_xpo_edit
* 
* Edit database object callback
* Path: /xpo
* Add object instrumentation in COMMIT phase.
* 
* INPUTS:
*     see agt/agt_cb.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t device_test_xpo_edit (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    agt_cbtyp_t cbtyp,
    op_editop_t editop,
    val_value_t *newval,
    val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;

    if (LOGDEBUG) {
        log_debug("\nEnter device_test_xpo_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "device_test_xpo_edit";
    val_value_t* value = (newval) ? newval : curval;
    std::string module_name = (char*) val_get_mod_name(value);

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        cbData.cbType = "validate";
        cbLog.addCallback(module_name, cbData);
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        cbData.cbType = "apply";
        cbLog.addCallback(module_name, cbData);
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        cbData.cbType = "commit";
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            cbData.cbPhase = "load";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_MERGE:
            cbData.cbPhase = "merge";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_REPLACE:
            cbData.cbPhase = "replace";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_CREATE:
            cbData.cbPhase = "create";
            cbLog.addCallback(module_name, cbData);
            break;
        case OP_EDITOP_DELETE:
            cbData.cbPhase = "delete";
            cbLog.addCallback(module_name, cbData);
            break;
        default:
            cbData.cbPhase = "default";
            cbLog.addCallback(module_name, cbData);
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }

        if (res == NO_ERR) {
            res = agt_check_cache(&xpo_val, newval, curval, editop);
        }
        
        break;
    case AGT_CB_ROLLBACK:
        cbData.cbType = "rollback";
        cbLog.addCallback(module_name, cbData);
        /* undo device instrumentation here */
        break;
    default:
        cbData.cbType = "default";
        cbLog.addCallback(module_name, cbData);
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_CONTENT,
            res,
            NULL,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }
    return res;

} /* device_test_xpo_edit */


/********************************************************************
* FUNCTION y_device_test_copy_profile_validate
* 
* RPC validation phase
* All YANG constraints have passed at this point.
* Add description-stmt checks in this function.
* 
* INPUTS:
*     see agt/agt_rpc.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t y_device_test_copy_profile_validate (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    xml_node_t *methnode)
{
    status_t res = NO_ERR;
    val_value_t *errorval = NULL;

    val_value_t *sourceProfileId_val;
    val_value_t *destinationProfileId_val;
    val_value_t *replaceExisting_val;
    uint32 sourceProfileId;
    uint32 destinationProfileId;
    boolean replaceExisting;

    sourceProfileId_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_sourceProfileId);
    if (sourceProfileId_val != NULL && sourceProfileId_val->res == NO_ERR) {
        sourceProfileId = VAL_UINT(sourceProfileId_val);
    }

    destinationProfileId_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_destinationProfileId);
    if (destinationProfileId_val != NULL && destinationProfileId_val->res == NO_ERR) {
        destinationProfileId = VAL_UINT(destinationProfileId_val);
    }

    replaceExisting_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_replaceExisting);
    if (replaceExisting_val != NULL && replaceExisting_val->res == NO_ERR) {
        replaceExisting = VAL_BOOL(replaceExisting_val);
    }

    if (res != NO_ERR) {
        agt_record_error(
            scb,
            &msg->mhdr,
            NCX_LAYER_OPERATION,
            res,
            methnode,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval,
            (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
            errorval);
    }

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "y_device_test_copy_profile_validate";
    cbLog.addCallback("device_test", cbData);

    return res;

} /* y_device_test_copy_profile_validate */


/********************************************************************
* FUNCTION y_device_test_copy_profile_invoke
* 
* RPC invocation phase
* All constraints have passed at this point.
* Call device instrumentation code in this function.
* 
* INPUTS:
*     see agt/agt_rpc.h for details
* 
* RETURNS:
*     error status
********************************************************************/
static status_t y_device_test_copy_profile_invoke (
    ses_cb_t *scb,
    rpc_msg_t *msg,
    xml_node_t *methnode)
{
    status_t res = NO_ERR;

    val_value_t *sourceProfileId_val;
    val_value_t *destinationProfileId_val;
    val_value_t *replaceExisting_val;
    uint32 sourceProfileId;
    uint32 destinationProfileId;
    boolean replaceExisting;

    sourceProfileId_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_sourceProfileId);
    if (sourceProfileId_val != NULL && sourceProfileId_val->res == NO_ERR) {
        sourceProfileId = VAL_UINT(sourceProfileId_val);
    }

    destinationProfileId_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_destinationProfileId);
    if (destinationProfileId_val != NULL && destinationProfileId_val->res == NO_ERR) {
        destinationProfileId = VAL_UINT(destinationProfileId_val);
    }

    replaceExisting_val = val_find_child(
        msg->rpc_input,
        y_device_test_M_device_test,
        y_device_test_N_replaceExisting);
    if (replaceExisting_val != NULL && replaceExisting_val->res == NO_ERR) {
        replaceExisting = VAL_BOOL(replaceExisting_val);
    }

    /* remove the next line if scb is used */
    (void)scb;

    /* remove the next line if methnode is used */
    (void)methnode;

    /* invoke your device instrumentation code here */
    

    YumaTest::SILCallbackLog& cbLog = YumaTest::SILCallbackLog::getInstance();
    YumaTest::SILCallbackLog::CallbackInfo cbData;
    cbData.cbName = "y_device_test_copy_profile_invoke";
    cbLog.addCallback("device_test", cbData);

    return res;

} /* y_device_test_copy_profile_invoke */


/********************************************************************
* FUNCTION y_device_test_init
* 
* initialize the device_test server instrumentation library
* 
* INPUTS:
*    modname == requested module name
*    revision == requested version (NULL for any)
* 
* RETURNS:
*     error status
********************************************************************/
status_t y_device_test_init (
    const xmlChar *modname,
    const xmlChar *revision)
{
    status_t res = NO_ERR;
    agt_profile_t *agt_profile;

    y_device_test_init_static_vars();

    /* change if custom handling done */
    if (xml_strcmp(modname, y_device_test_M_device_test)) {
        return ERR_NCX_UNKNOWN_MODULE;
    }

    if (revision && xml_strcmp(revision, y_device_test_R_device_test)) {
        return ERR_NCX_WRONG_VERSION;
    }

    agt_profile = agt_get_profile();

    res = ncxmod_load_module(
        y_device_test_M_device_test,
        y_device_test_R_device_test,
        &agt_profile->agt_savedevQ,
        &device_test_mod);
    if (res != NO_ERR) {
        return res;
    }

    xpo_obj = ncx_find_object(
        device_test_mod,
        y_device_test_N_xpo);
    if (device_test_mod == NULL) {
        return SET_ERROR(ERR_NCX_DEF_NOT_FOUND);
    }
    
    copy_profile_obj = ncx_find_object(
        device_test_mod,
        y_device_test_N_copy_profile);
    if (device_test_mod == NULL) {
        return SET_ERROR(ERR_NCX_DEF_NOT_FOUND);
    }
    
    res = agt_rpc_register_method(
        y_device_test_M_device_test,
        y_device_test_N_copy_profile,
        AGT_RPC_PH_VALIDATE,
        y_device_test_copy_profile_validate);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_rpc_register_method(
        y_device_test_M_device_test,
        y_device_test_N_copy_profile,
        AGT_RPC_PH_INVOKE,
        y_device_test_copy_profile_invoke);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/activeProfile",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_activeProfile_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/id",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_id_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/bitrate",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_bitrate_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_destinationId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationPinId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_destinationPinId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationStreamId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_destinationStreamId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/id",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_id_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourceId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_sourceId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourcePinId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_sourcePinId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourceStreamId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_streamConnection_sourceStreamId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/id",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_id_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/bitrate",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_bitrate_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/destinationId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_destinationId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/destinationPinId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_destinationPinId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/id",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_id_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/sourceId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_sourceId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/sourcePinId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceConnection_sourcePinId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/alarmConfig",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_alarmConfig_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/channelId",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_channelId_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/configuration",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_configuration_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/id",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_id_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/physicalPath",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_physicalPath_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/resourceType",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_resourceType_edit);
    if (res != NO_ERR) {
        return res;
    }

    res = agt_cb_register_callback(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/statusConfig",
        (const xmlChar *)"2011-09-07",
        device_test_xpo_profile_stream_resourceNode_statusConfig_edit);
    if (res != NO_ERR) {
        return res;
    }

    /* put your module initialization code here */
    
    return res;
} /* y_device_test_init */


/********************************************************************
* FUNCTION y_device_test_init2
* 
* SIL init phase 2: non-config data structures
* Called after running config is loaded
* 
* RETURNS:
*     error status
********************************************************************/
status_t y_device_test_init2 (void)
{
    status_t res = NO_ERR;

    xpo_val = agt_init_cache(
        y_device_test_M_device_test,
        y_device_test_N_xpo,
        &res);
    if (res != NO_ERR) {
        return res;
    }

    /* put your init2 code here */

    return res;
} /* y_device_test_init2 */


/********************************************************************
* FUNCTION y_device_test_cleanup
*    cleanup the server instrumentation library
* 
********************************************************************/
void y_device_test_cleanup (void)
{
    agt_rpc_unregister_method(
        y_device_test_M_device_test,
        y_device_test_N_copy_profile);

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/activeProfile");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/id");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/bitrate");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationPinId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/destinationStreamId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/id");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourceId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourcePinId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/streamConnection/sourceStreamId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/id");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/bitrate");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/destinationId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/destinationPinId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/id");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/sourceId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceConnection/sourcePinId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/alarmConfig");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/channelId");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/configuration");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/id");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/physicalPath");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/resourceType");

    agt_cb_unregister_callbacks(
        y_device_test_M_device_test,
        (const xmlChar *)"/xpo/profile/stream/resourceNode/statusConfig");

    /* put your cleanup code here */
    
} /* y_device_test_cleanup */

/* END device_test.c */
