/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.tv.media.AWTVideoSize;
import javax.tv.media.AWTVideoSizeControl;
import org.dvb.media.BackgroundVideoPresentationControl;
import org.dvb.media.VideoTransformation;
import org.havi.ui.HScreenPoint;
import org.havi.ui.HScreenRectangle;
import org.videolan.StreamInfo;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.VideoControl;

public class BackgroundVideoPresentationControlImpl
extends VideoControl
implements BackgroundVideoPresentationControl,
AWTVideoSizeControl {
    private Handler player;

    protected BackgroundVideoPresentationControlImpl(Handler player) {
        super(0);
        this.player = player;
    }

    protected StreamInfo[] getStreams() {
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            return null;
        }
        return ci.getVideoStreams();
    }

    protected void setStreamNumber(int num) {
    }

    public int getCurrentStreamNumber() {
        return 1;
    }

    public boolean setVideoTransformation(VideoTransformation transform) {
        if (transform == null) {
            return false;
        }
        this.setClipRegion(transform.getClipRegion());
        HScreenPoint pos = transform.getVideoPosition();
        float[] scales = transform.getScalingFactors();
        Dimension vd = this.getInputVideoSize();
        Dimension sd = this.getScreenSize();
        this.setVideoArea(new HScreenRectangle(pos.x, pos.y, (float)vd.width * scales[0] / (float)sd.width, (float)vd.height * scales[0] / (float)sd.height));
        return true;
    }

    public VideoTransformation getVideoTransformation() {
        float yscale;
        float xscale;
        Dimension vd = this.getInputVideoSize();
        HScreenRectangle rect = this.getActiveVideoArea();
        if (vd.width == 0 || vd.height == 0) {
            xscale = 0.0f;
            yscale = 0.0f;
        } else {
            Dimension sd = this.getScreenSize();
            xscale = rect.width * (float)sd.width / (float)vd.width;
            yscale = rect.height * (float)sd.height / (float)vd.height;
        }
        return new VideoTransformation(this.getClipRegion(), xscale, yscale, new HScreenPoint(rect.x, rect.y));
    }

    public VideoTransformation getClosestMatch(VideoTransformation transform) {
        return transform;
    }

    public AWTVideoSize getSize() {
        return new AWTVideoSize(this.getClipRegion(), this.getRectangle(this.getScreenSize(), this.getActiveVideoArea()));
    }

    public AWTVideoSize getDefaultSize() {
        Dimension vd = this.getInputVideoSize();
        Dimension sd = this.getScreenSize();
        return new AWTVideoSize(new Rectangle(vd.width, vd.height), new Rectangle(sd.width, sd.height));
    }

    public Dimension getSourceVideoSize() {
        return this.getVideoSize();
    }

    public boolean setSize(AWTVideoSize size) {
        this.setClipRegion(size.getSource());
        this.setVideoArea(this.getNormalizedRectangle(this.getScreenSize(), size.getDestination()));
        return true;
    }

    public AWTVideoSize checkSize(AWTVideoSize size) {
        Dimension vd = this.getInputVideoSize();
        Rectangle sr = size.getSource();
        if (sr.x < 0) {
            sr.x = 0;
        }
        if (sr.x + sr.width > vd.width) {
            sr.width = vd.width - sr.x;
            if (sr.width <= 0) {
                sr.x = 0;
                sr.width = 0;
            }
        }
        if (sr.y < 0) {
            sr.y = 0;
        }
        if (sr.y + sr.height > vd.height) {
            sr.height = vd.height - sr.y;
            if (sr.height <= 0) {
                sr.y = 0;
                sr.height = 0;
            }
        }
        Rectangle dr = size.getDestination();
        return new AWTVideoSize(sr, dr);
    }
}

